/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class DateTileSkin
extends TileSkin {
    private static final DateTimeFormatter DAY_FORMATTER = DateTimeFormatter.ofPattern("EEEE");
    private static final DateTimeFormatter MONTH_YEAR_FORMATTER = DateTimeFormatter.ofPattern("MMMM YYYY");
    private Text titleText;
    private Text text;
    private Label description;

    public DateTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        ZonedDateTime TIME = this.tile.getTime();
        this.titleText = new Text(DAY_FORMATTER.format(TIME));
        this.titleText.setFill(this.tile.getTitleColor());
        this.description = new Label(Integer.toString(TIME.getDayOfMonth()));
        this.description.setAlignment(Pos.CENTER);
        this.description.setTextAlignment(TextAlignment.CENTER);
        this.description.setWrapText(true);
        this.description.setTextOverrun(OverrunStyle.WORD_ELLIPSIS);
        this.description.setTextFill(this.tile.getTextColor());
        this.description.setPrefSize(225.0, 180.0);
        this.description.setFont(Fonts.latoLight(162.5));
        this.text = new Text(MONTH_YEAR_FORMATTER.format(TIME));
        this.text.setFill(this.tile.getTextColor());
        this.getPane().getChildren().addAll((Node[])new Node[]{this.titleText, this.text, this.description});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode(this.titleText, !this.titleText.getText().isEmpty());
            Helper.enableNode(this.text, this.tile.isTextVisible());
            Helper.enableNode(this.description, !this.description.getText().isEmpty());
        }
    }

    @Override
    protected void resizeDynamicText() {
        double fontSize = this.size * 0.65;
        this.description.setFont(Fonts.latoLight(fontSize));
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font(customFont.getFamily(), fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resize() {
        super.resize();
        this.description.setPrefSize(this.width - this.size * 0.1, this.height * 0.7);
        this.description.relocate(this.contentBounds.getX(), this.height * 0.1125);
        this.redraw();
    }

    @Override
    protected void redraw() {
        super.redraw();
        ZonedDateTime TIME = this.tile.getTime();
        this.titleText.setText(DAY_FORMATTER.format(TIME));
        this.text.setText(MONTH_YEAR_FORMATTER.format(TIME));
        this.description.setText(Integer.toString(TIME.getDayOfMonth()));
        this.resizeDynamicText();
        this.resizeStaticText();
        this.titleText.setFill(this.tile.getTitleColor());
        this.text.setFill(this.tile.getTextColor());
        this.description.setTextFill(TIME.getDayOfWeek().getValue() == 7 ? Tile.RED : this.tile.getTextColor());
    }
}

