/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lmediathek/tool/TimerPool;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "timerPool", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "getTimerPool$annotations", "getTimerPool", "()Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "TimerPoolThreadFactory", "MediathekView"})
public final class TimerPool {
    private static final Logger logger;
    @NotNull
    private static final ScheduledThreadPoolExecutor timerPool;
    @NotNull
    public static final TimerPool INSTANCE;

    @JvmStatic
    public static /* synthetic */ void getTimerPool$annotations() {
    }

    @NotNull
    public static final ScheduledThreadPoolExecutor getTimerPool() {
        return timerPool;
    }

    private TimerPool() {
    }

    static {
        TimerPool timerPool;
        INSTANCE = timerPool = new TimerPool();
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue(logger, "LogManager.getLogger()");
        TimerPool.logger = logger;
        TimerPool.timerPool = new ScheduledThreadPoolExecutor(RangesKt.coerceIn(Runtime.getRuntime().availableProcessors() / 2, 2, 4), new TimerPoolThreadFactory());
        TimerPool.logger.trace("Initializing timer pool...");
        TimerPool.timerPool.setRemoveOnCancelPolicy(true);
        TimerPool.timerPool.allowCoreThreadTimeOut(true);
        TimerPool.timerPool.setKeepAliveTime(1L, TimeUnit.MINUTES);
        TimerPool.timerPool.scheduleWithFixedDelay(1.INSTANCE, 4L, 1L, TimeUnit.SECONDS);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lmediathek/tool/TimerPool$TimerPoolThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "()V", "group", "Ljava/lang/ThreadGroup;", "threadNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "MediathekView"})
    private static final class TimerPoolThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Intrinsics.checkNotNullParameter(r, "r");
            Thread t = new Thread(this.group, r, "TimerPool-thread-" + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(false);
            t.setPriority(5);
            return t;
        }

        public TimerPoolThreadFactory() {
            ThreadGroup threadGroup;
            SecurityManager s2 = System.getSecurityManager();
            if (s2 != null) {
                ThreadGroup threadGroup2 = s2.getThreadGroup();
                threadGroup = threadGroup2;
                Intrinsics.checkNotNullExpressionValue(threadGroup2, "s.threadGroup");
            } else {
                Thread thread2 = Thread.currentThread();
                Intrinsics.checkNotNullExpressionValue(thread2, "Thread.currentThread()");
                ThreadGroup threadGroup3 = thread2.getThreadGroup();
                threadGroup = threadGroup3;
                Intrinsics.checkNotNullExpressionValue(threadGroup3, "Thread.currentThread().threadGroup");
            }
            this.group = threadGroup;
        }
    }
}

