from typing import IO, Any, AnyStr, Callable, Dict, Iterable, List, Mapping, Optional, Sequence, Tuple, Type, overload

NO_DEFAULT: Tuple[str, ...]
SUPPRESS_HELP: str
SUPPRESS_USAGE: str

def check_builtin(option: Option, opt: Any, value: str) -> Any: ...
def check_choice(option: Option, opt: Any, value: str) -> Any: ...

class OptParseError(Exception):
    msg: str
    def __init__(self, msg: str) -> None: ...

class BadOptionError(OptParseError):
    opt_str: str
    def __init__(self, opt_str: str) -> None: ...

class AmbiguousOptionError(BadOptionError):
    possibilities: Iterable[str]
    def __init__(self, opt_str: str, possibilities: Sequence[str]) -> None: ...

class OptionError(OptParseError):
    msg: str
    option_id: str
    def __init__(self, msg: str, option: Option) -> None: ...

class OptionConflictError(OptionError): ...
class OptionValueError(OptParseError): ...

class HelpFormatter:
    NO_DEFAULT_VALUE: str
    _long_opt_fmt: str
    _short_opt_fmt: str
    current_indent: int
    default_tag: str
    help_position: Any
    help_width: Any
    indent_increment: int
    level: int
    max_help_position: int
    option_strings: Dict[Option, str]
    parser: OptionParser
    short_first: Any
    width: int
    def __init__(self, indent_increment: int, max_help_position: int, width: Optional[int], short_first: int) -> None: ...
    def dedent(self) -> None: ...
    def expand_default(self, option: Option) -> str: ...
    def format_description(self, description: str) -> str: ...
    def format_epilog(self, epilog: str) -> str: ...
    def format_heading(self, heading: Any) -> str: ...
    def format_option(self, option: Option) -> str: ...
    def format_option_strings(self, option: Option) -> str: ...
    def format_usage(self, usage: Any) -> str: ...
    def indent(self) -> None: ...
    def set_long_opt_delimiter(self, delim: str) -> None: ...
    def set_parser(self, parser: OptionParser) -> None: ...
    def set_short_opt_delimiter(self, delim: str) -> None: ...
    def store_option_strings(self, parser: OptionParser) -> None: ...

class IndentedHelpFormatter(HelpFormatter):
    def __init__(
        self, indent_increment: int = ..., max_help_position: int = ..., width: Optional[int] = ..., short_first: int = ...
    ) -> None: ...
    def format_heading(self, heading: str) -> str: ...
    def format_usage(self, usage: str) -> str: ...

class TitledHelpFormatter(HelpFormatter):
    def __init__(
        self, indent_increment: int = ..., max_help_position: int = ..., width: Optional[int] = ..., short_first: int = ...
    ) -> None: ...
    def format_heading(self, heading: str) -> str: ...
    def format_usage(self, usage: str) -> str: ...

class Option:
    ACTIONS: Tuple[str, ...]
    ALWAYS_TYPED_ACTIONS: Tuple[str, ...]
    ATTRS: List[str]
    CHECK_METHODS: Optional[List[Callable[..., Any]]]
    CONST_ACTIONS: Tuple[str, ...]
    STORE_ACTIONS: Tuple[str, ...]
    TYPED_ACTIONS: Tuple[str, ...]
    TYPES: Tuple[str, ...]
    TYPE_CHECKER: Dict[str, Callable[..., Any]]
    _long_opts: List[str]
    _short_opts: List[str]
    action: str
    dest: Optional[str]
    default: Any
    nargs: int
    type: Any
    callback: Optional[Callable[..., Any]]
    callback_args: Optional[Tuple[Any, ...]]
    callback_kwargs: Optional[Dict[str, Any]]
    help: Optional[str]
    metavar: Optional[str]
    def __init__(self, *opts: Optional[str], **attrs: Any) -> None: ...
    def _check_action(self) -> None: ...
    def _check_callback(self) -> None: ...
    def _check_choice(self) -> None: ...
    def _check_const(self) -> None: ...
    def _check_dest(self) -> None: ...
    def _check_nargs(self) -> None: ...
    def _check_opt_strings(self, opts: Iterable[Optional[str]]) -> List[str]: ...
    def _check_type(self) -> None: ...
    def _set_attrs(self, attrs: Dict[str, Any]) -> None: ...
    def _set_opt_strings(self, opts: Iterable[str]) -> None: ...
    def check_value(self, opt: str, value: Any) -> Any: ...
    def convert_value(self, opt: str, value: Any) -> Any: ...
    def get_opt_string(self) -> str: ...
    def process(self, opt: Any, value: Any, values: Any, parser: OptionParser) -> int: ...
    def take_action(self, action: str, dest: str, opt: Any, value: Any, values: Any, parser: OptionParser) -> int: ...
    def takes_value(self) -> bool: ...

make_option = Option

class OptionContainer:
    _long_opt: Dict[str, Option]
    _short_opt: Dict[str, Option]
    conflict_handler: str
    defaults: Dict[str, Any]
    description: Any
    option_class: Type[Option]
    def __init__(self, option_class: Type[Option], conflict_handler: Any, description: Any) -> None: ...
    def _check_conflict(self, option: Any) -> None: ...
    def _create_option_mappings(self) -> None: ...
    def _share_option_mappings(self, parser: OptionParser) -> None: ...
    @overload
    def add_option(self, opt: Option) -> Option: ...
    @overload
    def add_option(self, *args: Optional[str], **kwargs: Any) -> Any: ...
    def add_options(self, option_list: Iterable[Option]) -> None: ...
    def destroy(self) -> None: ...
    def format_description(self, formatter: Optional[HelpFormatter]) -> Any: ...
    def format_help(self, formatter: Optional[HelpFormatter]) -> str: ...
    def format_option_help(self, formatter: Optional[HelpFormatter]) -> str: ...
    def get_description(self) -> Any: ...
    def get_option(self, opt_str: str) -> Optional[Option]: ...
    def has_option(self, opt_str: str) -> bool: ...
    def remove_option(self, opt_str: str) -> None: ...
    def set_conflict_handler(self, handler: Any) -> None: ...
    def set_description(self, description: Any) -> None: ...

class OptionGroup(OptionContainer):
    option_list: List[Option]
    parser: OptionParser
    title: str
    def __init__(self, parser: OptionParser, title: str, description: Optional[str] = ...) -> None: ...
    def _create_option_list(self) -> None: ...
    def set_title(self, title: str) -> None: ...

class Values:
    def __init__(self, defaults: Optional[Mapping[str, Any]] = ...) -> None: ...
    def _update(self, dict: Mapping[str, Any], mode: Any) -> None: ...
    def _update_careful(self, dict: Mapping[str, Any]) -> None: ...
    def _update_loose(self, dict: Mapping[str, Any]) -> None: ...
    def ensure_value(self, attr: str, value: Any) -> Any: ...
    def read_file(self, filename: str, mode: str = ...) -> None: ...
    def read_module(self, modname: str, mode: str = ...) -> None: ...
    def __getattr__(self, name: str) -> Any: ...
    def __setattr__(self, name: str, value: Any) -> None: ...

class OptionParser(OptionContainer):
    allow_interspersed_args: bool
    epilog: Optional[str]
    formatter: HelpFormatter
    largs: Optional[List[str]]
    option_groups: List[OptionGroup]
    option_list: List[Option]
    process_default_values: Any
    prog: Optional[str]
    rargs: Optional[List[Any]]
    standard_option_list: List[Option]
    usage: Optional[str]
    values: Optional[Values]
    version: str
    def __init__(
        self,
        usage: Optional[str] = ...,
        option_list: Optional[Iterable[Option]] = ...,
        option_class: Type[Option] = ...,
        version: Optional[str] = ...,
        conflict_handler: str = ...,
        description: Optional[str] = ...,
        formatter: Optional[HelpFormatter] = ...,
        add_help_option: bool = ...,
        prog: Optional[str] = ...,
        epilog: Optional[str] = ...,
    ) -> None: ...
    def _add_help_option(self) -> None: ...
    def _add_version_option(self) -> None: ...
    def _create_option_list(self) -> None: ...
    def _get_all_options(self) -> List[Option]: ...
    def _get_args(self, args: Iterable[Any]) -> List[Any]: ...
    def _init_parsing_state(self) -> None: ...
    def _match_long_opt(self, opt: str) -> str: ...
    def _populate_option_list(self, option_list: Iterable[Option], add_help: bool = ...) -> None: ...
    def _process_args(self, largs: List[Any], rargs: List[Any], values: Values) -> None: ...
    def _process_long_opt(self, rargs: List[Any], values: Any) -> None: ...
    def _process_short_opts(self, rargs: List[Any], values: Any) -> None: ...
    @overload
    def add_option_group(self, __opt_group: OptionGroup) -> OptionGroup: ...
    @overload
    def add_option_group(self, *args: Any, **kwargs: Any) -> OptionGroup: ...
    def check_values(self, values: Values, args: List[str]) -> Tuple[Values, List[str]]: ...
    def disable_interspersed_args(self) -> None: ...
    def enable_interspersed_args(self) -> None: ...
    def error(self, msg: str) -> None: ...
    def exit(self, status: int = ..., msg: Optional[str] = ...) -> None: ...
    def expand_prog_name(self, s: Optional[str]) -> Any: ...
    def format_epilog(self, formatter: HelpFormatter) -> Any: ...
    def format_help(self, formatter: Optional[HelpFormatter] = ...) -> str: ...
    def format_option_help(self, formatter: Optional[HelpFormatter] = ...) -> str: ...
    def get_default_values(self) -> Values: ...
    def get_option_group(self, opt_str: str) -> Any: ...
    def get_prog_name(self) -> str: ...
    def get_usage(self) -> str: ...
    def get_version(self) -> str: ...
    def parse_args(
        self, args: Optional[Sequence[AnyStr]] = ..., values: Optional[Values] = ...
    ) -> Tuple[Values, List[AnyStr]]: ...
    def print_usage(self, file: Optional[IO[str]] = ...) -> None: ...
    def print_help(self, file: Optional[IO[str]] = ...) -> None: ...
    def print_version(self, file: Optional[IO[str]] = ...) -> None: ...
    def set_default(self, dest: Any, value: Any) -> None: ...
    def set_defaults(self, **kwargs: Any) -> None: ...
    def set_process_default_values(self, process: Any) -> None: ...
    def set_usage(self, usage: str) -> None: ...
