from .. import Provider as LoremProvider


class Provider(LoremProvider):
    """Implement lorem provider for ``th_TH`` locale.

    Word list is randomly drawn from the Thailand's Ministry of Education,
    removing compound words and long words, adding common words (like
    prepositions) and few of regional words.

    Sources:

    - http://www.arts.chula.ac.th/~ling/TTC/id-4.html
    - https://www.sanook.com/campus/1390689/
    - https://www.sanook.com/campus/1397677/
    - https://www.sanook.com/campus/1392241/
    """

    word_connector = ""  # Thai writing has no word divider
    sentence_punctuation = " "  # single space
    word_list = (
        "กตัญญู",
        "กบ",
        "กรดไหลย้อน",
        "กรรมการ",
        "กระจาย",
        "กระถาง",
        "กล",
        "กล่อง",
        "กล้า",
        "กลาง",
        "กลางคืน",
        "กล่าว",
        "กว้าง",
        "กะเพรา",
        "กะละมัง",
        "กับ",
        "ก้าง",
        "กาม",
        "การ",
        "กำ",
        "กำไร",
        "กิ่งไม้",
        "กิจกรรม",
        "กิน",
        "กิโลเมตร",
        "กีฬา",
        "กู",
        "กูเกิล",
        "เกม",
        "เกาหลี",
        "แก้ว",
        "แกะ",
        "แก",
        "แก่",
        "แก้",
        "โก๋แก่",
        "โกง",
        "ขนม",
        "ขนมชั้น",
        "ของหวาน",
        "ขัด",
        "ขันน้ำ",
        "ข้าง",
        "ขาดเคิ่ง",
        "ข้าว",
        "ข้าวเจ้า",
        "ข้าวหมูแดง",
        "ขี่",
        "ขี้ไคล",
        "ขี้ดิน",
        "ขุด",
        "เขยิบ",
        "เขยื้อน",
        "เข้ารหัส",
        "แข่งขัน",
        "แข็ง",
        "แข้ง",
        "ไข่",
        "คนไข้",
        "คนตาย",
        "คบ",
        "คมนาคม",
        "ครอง",
        "ครู",
        "คลาน",
        "ควร",
        "ความ",
        "คอก",
        "คอมมิวนิสต์",
        "ค่อย",
        "คะแนน",
        "คั่ว",
        "คาว",
        "คำถาม",
        "คำสั่ง",
        "คู่",
        "เคย",
        "เครื่องบิน",
        "เคเอฟซี",
        "เคารพ",
        "แคะ",
        "โควิด",
        "ไค้หัน",
        "งม",
        "ง่วง",
        "เงา",
        "โง่",
        "จะไปพั่ง",
        "จัด",
        "จาก",
        "จ๋า",
        "เจ็บไข้",
        "แจ่มใส",
        "ใจ",
        "ฉีด",
        "เฉย",
        "ชนิด",
        "ชะนี",
        "ช้า",
        "ชาว",
        "ชาวนา",
        "ชิง",
        "ชุดนอน",
        "ชุมนุม",
        "ชู",
        "เช้า",
        "เชื่อม",
        "เชื้อโรค",
        "เชื่อ",
        "ไชโย",
        "ซ่อน",
        "ซ่อมเบิ่ง",
        "ซอย",
        "ซี่",
        "แซง",
        "ด้วย",
        "ดอกไม้",
        "ดอง",
        "ดังนี้",
        "ด้าย",
        "ดาวเทียม",
        "ดำ",
        "ดี",
        "ดึก",
        "ดู",
        "เดี่ยว",
        "โดย",
        "ได้แก่",
        "ตกลง",
        "ต้น",
        "ตรวจ",
        "ตลอด",
        "ตอก",
        "ตอใด",
        "ต่อ",
        "ตะแกรง",
        "ตะปู",
        "ตั้งแต่",
        "ตับ",
        "ตัวเมีย",
        "ตัวอย่าง",
        "ตำลึง",
        "ติด",
        "ตีน",
        "ตื่น",
        "ตู้",
        "ตู่",
        "เตา",
        "เตียน",
        "แต่ง",
        "แตะ",
        "แต่",
        "โตย",
        "โต",
        "ไต้หวัน",
        "ไต้",
        "ถกเถียง",
        "ถาง",
        "ถีบ",
        "ถึง",
        "แถบ",
        "ทด",
        "ทดลอง",
        "ทรัพย์สิน",
        "ทวด",
        "ทวิตเตอร์",
        "ทหาร",
        "ท้องฟ้า",
        "ทอด",
        "ทอดมัน",
        "ทั่ว",
        "ทาน",
        "ทำสวน",
        "ที่ดิน",
        "ที่",
        "ทุกข์",
        "ทุ่ม",
        "เทเลแกรม",
        "แท็กซี่",
        "แท็บลอยด์",
        "ธนาคาร",
        "ธาตุ",
        "น้อง",
        "นักเรียน",
        "นั่ง",
        "น้า",
        "น้ำเย็น",
        "น้ำหวาน",
        "นิ่ม",
        "นุ่น",
        "เนื่องจาก",
        "เนื้อ",
        "โน่น",
        "ใน",
        "บริโภค",
        "บริษัท",
        "บอก",
        "บอกใบ้",
        "บัดนี้",
        "บันได",
        "บาด",
        "บูชา",
        "บูด",
        "เบียร์",
        "ใบไม้",
        "ปกครอง",
        "ประชาธิปไตย",
        "ประพฤติ",
        "ประสบการณ์",
        "ปาก",
        "ปิ่นโต",
        "ปี",
        "ปี่",
        "ปู",
        "เป็น",
        "เปลือง",
        "เป้า",
        "แปรง",
        "ผล",
        "ผลัด",
        "ผลิต",
        "ผสม",
        "ผ่อ",
        "ผัก",
        "ผิด",
        "ผีก",
        "ผู้ร้าย",
        "เผื่อ",
        "แผนที่",
        "โผล่",
        "ฝาก",
        "พนมมือ",
        "พยาธิ",
        "พ่อ",
        "พักผ่อน",
        "พับ",
        "พิการ",
        "พิพักพิพ่วน",
        "เพดาน",
        "เพราะ",
        "เพลง",
        "เพียง",
        "แพ้",
        "ฟาก",
        "เฟซบุ๊ก",
        "มลายู",
        "มอบ",
        "มะเขือเทศ",
        "มัสยิด",
        "มิตร",
        "เมตตา",
        "เมล็ด",
        "เมาะ",
        "แมค",
        "แม่มด",
        "แมลง",
        "แม่",
        "แม้",
        "ย่อ",
        "ยัน",
        "ยา",
        "ย้ำ",
        "ยีราฟ",
        "ยึด",
        "ยูทูบ",
        "เย็น",
        "เย็บ",
        "เยอะ",
        "เยาวชน",
        "รถโดยสาร",
        "รถถัง",
        "รถทัวร์",
        "รถบัส",
        "ร่มรื่น",
        "รสชาติ",
        "ร้อน",
        "รอ",
        "ระเบียง",
        "ระยำ",
        "รังแก",
        "รัฐบาล",
        "รัฐประหาร",
        "ราก",
        "ร่างกาย",
        "ร่าง",
        "ริม",
        "รู้จัก",
        "เริ่ม",
        "เรียง",
        "เรื่อย",
        "แรก",
        "แรงงาน",
        "โรงสี",
        "ฤดู",
        "ลงมือ",
        "ล่อ",
        "ลืมคาว",
        "ลูกชิ้น",
        "ลูกตา",
        "ลูก",
        "เล่ม",
        "เลี้ยว",
        "เลือก",
        "แลก",
        "และ",
        "วัง",
        "วัฒนธรรม",
        "วาด",
        "วิกิพีเดีย",
        "วิ่ง",
        "วิชาชีพ",
        "วินโดวส์",
        "ศาลากลาง",
        "ศาสตร์",
        "ศิษย์",
        "เศรษฐกิจ",
        "เศษอาหาร",
        "เศษ",
        "สดชื่น",
        "สด",
        "สถานี",
        "สนอง",
        "สบาย",
        "สมอง",
        "สมาคม",
        "สม่ำเสมอ",
        "สลับ",
        "สหกรณ์",
        "สหภาพ",
        "สัญญา",
        "สาธารณรัฐ",
        "สารวัตร",
        "สำนักงาน",
        "สำหรับ",
        "สีแดง",
        "สีเทา",
        "สี",
        "สุขภาพ",
        "สุดท้าย",
        "เสรีนิยม",
        "เสรีภาพ",
        "เสียบ",
        "แสง",
        "หน้ากาก",
        "หน้าต่าง",
        "หน้าที่",
        "หนุน",
        "หนู",
        "หมด",
        "ห่มผ้า",
        "หมอก",
        "หม้อ",
        "หมัด",
        "หมี",
        "หมุน",
        "หยอก",
        "หยัก",
        "หรือ",
        "หลง",
        "หล่น",
        "หลบ",
        "หลังคา",
        "ห่วงใย",
        "หว่าน",
        "ห่อข้าว",
        "ห้องเรียน",
        "หอย",
        "ห้าง",
        "หาบ",
        "หาม้าย",
        "หาย",
        "หึงสา",
        "หุ้ม",
        "เหตุ",
        "เห็น",
        "แหย่",
        "ใหม่",
        "ไหน",
        "องค์",
        "อด",
        "อธิษฐาน",
        "อนุบาล",
        "อบอุ่น",
        "อวัยวะ",
        "ออนซอนเด๊",
        "อ่อนหวาน",
        "อัศจรรย์",
        "อายุ",
        "อาสา",
        "อาหาร",
        "อิฐ",
        "อินเทอร์เน็ต",
        "อินสตาแกรม",
        "อิสลาม",
        "อุปโภค",
        "เอสซีบี",
        "เอิด",
        "แอนดรอยด์",
        "ไอศกรีม",
        "ไอโอเอส",
    )
