// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from LPC11Uxx_v7.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/NXP

// +build nxp,lpc11uxx

// LPC11Uxx
//

package nxp

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "LPC11Uxx"
	CPU          = "CM0"
	FPUPresent   = false
	NVICPrioBits = 2
)

// Interrupt numbers.
const (
	// GPIO pin interrupt
	IRQ_PIN_INT0 = 0

	// GPIO pin interrupt
	IRQ_PIN_INT1 = 1

	// GPIO pin interrupt
	IRQ_PIN_INT2 = 2

	// GPIO pin interrupt
	IRQ_PIN_INT3 = 3

	// GPIO pin interrupt
	IRQ_PIN_INT4 = 4

	// GPIO pin interrupt
	IRQ_PIN_INT5 = 5

	// GPIO pin interrupt
	IRQ_PIN_INT6 = 6

	// GPIO pin interrupt
	IRQ_PIN_INT7 = 7

	// GPIO group interrupt
	IRQ_GINT0 = 8

	IRQ_GINT1 = 9

	IRQ_SSP1 = 14

	// I2C-bus controller
	IRQ_I2C = 15

	// 16-bit counter/timers CT16B0
	IRQ_CT16B0 = 16

	// 16-bit counter/timers CT16B1
	IRQ_CT16B1 = 17

	// 32-bit counter/timers CT32B0
	IRQ_CT32B0 = 18

	// 32-bit counter/timers CT32B1
	IRQ_CT32B1 = 19

	// SSP/SPI
	IRQ_SSP0 = 20

	// USART
	IRQ_USART = 21

	// USB2.0 device controller
	IRQ_USB_IRQ = 22

	// USB2.0 device controller
	IRQ_USB_FIQ = 23

	// ADC
	IRQ_ADC = 24

	// Windowed Watchdog Timer (WWDT)
	IRQ_WDT = 25

	// System control block
	IRQ_BOD_IRQ = 26

	// Flash controller
	IRQ_FLASH_IRQ = 27

	// USB2.0 device controller
	IRQ_USBWAKEUP = 30

	// Highest interrupt number on this device.
	IRQ_max = 30
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_PIN_INT0, "PIN_INT0_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT1, "PIN_INT1_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT2, "PIN_INT2_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT3, "PIN_INT3_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT4, "PIN_INT4_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT5, "PIN_INT5_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT6, "PIN_INT6_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT7, "PIN_INT7_IRQHandler")
	_ = interrupt.Register(IRQ_GINT0, "GINT0_IRQHandler")
	_ = interrupt.Register(IRQ_GINT1, "GINT1_IRQHandler")
	_ = interrupt.Register(IRQ_SSP1, "SSP1_IRQHandler")
	_ = interrupt.Register(IRQ_I2C, "I2C_IRQHandler")
	_ = interrupt.Register(IRQ_CT16B0, "CT16B0_IRQHandler")
	_ = interrupt.Register(IRQ_CT16B1, "CT16B1_IRQHandler")
	_ = interrupt.Register(IRQ_CT32B0, "CT32B0_IRQHandler")
	_ = interrupt.Register(IRQ_CT32B1, "CT32B1_IRQHandler")
	_ = interrupt.Register(IRQ_SSP0, "SSP0_IRQHandler")
	_ = interrupt.Register(IRQ_USART, "USART_IRQHandler")
	_ = interrupt.Register(IRQ_USB_IRQ, "USB_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_USB_FIQ, "USB_FIQ_IRQHandler")
	_ = interrupt.Register(IRQ_ADC, "ADC_IRQHandler")
	_ = interrupt.Register(IRQ_WDT, "WDT_IRQHandler")
	_ = interrupt.Register(IRQ_BOD_IRQ, "BOD_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_FLASH_IRQ, "FLASH_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_USBWAKEUP, "USBWAKEUP_IRQHandler")
)

// Peripherals.
var (
	// I2C-bus controller
	I2C = (*I2C_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Windowed Watchdog Timer (WWDT)
	WWDT = (*WWDT_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// USART
	USART = (*USART_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// 16-bit counter/timers CT16B0
	CT16B0 = (*CT16B0_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// 16-bit counter/timers CT16B1
	CT16B1 = (*CT16B1_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// 32-bit counter/timers CT32B0
	CT32B0 = (*CT32B0_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// 32-bit counter/timers CT32B1
	CT32B1 = (*CT32B1_Type)(unsafe.Pointer(uintptr(0x40018000)))

	// ADC
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x4001c000)))

	// Power Management Unit (PMU)
	PMU = (*PMU_Type)(unsafe.Pointer(uintptr(0x40038000)))

	// Flash controller
	FLASHCTRL = (*FLASHCTRL_Type)(unsafe.Pointer(uintptr(0x4003c000)))

	// SSP/SPI
	SSP0 = (*SSP0_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// I/O configuration Modification
	IOCON = (*IOCON_Type)(unsafe.Pointer(uintptr(0x40044000)))

	// System control block
	SYSCON = (*SYSCON_Type)(unsafe.Pointer(uintptr(0x40048000)))

	// GPIO pin interrupt
	GPIO_PIN_INT = (*GPIO_PIN_INT_Type)(unsafe.Pointer(uintptr(0x4004c000)))

	// SSP/SPI
	SSP1 = (*SSP0_Type)(unsafe.Pointer(uintptr(0x40058000)))

	// GPIO group interrupt
	GPIO_GROUP_INT0 = (*GPIO_GROUP_INT0_Type)(unsafe.Pointer(uintptr(0x4005c000)))

	// GPIO group interrupt
	GPIO_GROUP_INT1 = (*GPIO_GROUP_INT0_Type)(unsafe.Pointer(uintptr(0x40060000)))

	// USB2.0 device controller
	USB = (*USB_Type)(unsafe.Pointer(uintptr(0x40080000)))

	// GPIO port
	GPIO_PORT = (*GPIO_PORT_Type)(unsafe.Pointer(uintptr(0x50000000)))
)

// I2C-bus controller
type I2C_Type struct {
	CONSET      volatile.Register32 // 0x0
	STAT        volatile.Register32 // 0x4
	DAT         volatile.Register32 // 0x8
	ADR0        volatile.Register32 // 0xC
	SCLH        volatile.Register32 // 0x10
	SCLL        volatile.Register32 // 0x14
	CONCLR      volatile.Register32 // 0x18
	MMCTRL      volatile.Register32 // 0x1C
	ADR1        volatile.Register32 // 0x20
	ADR2        volatile.Register32 // 0x24
	ADR3        volatile.Register32 // 0x28
	DATA_BUFFER volatile.Register32 // 0x2C
	MASK0       volatile.Register32 // 0x30
	MASK1       volatile.Register32 // 0x34
	MASK2       volatile.Register32 // 0x38
	MASK3       volatile.Register32 // 0x3C
}

// Windowed Watchdog Timer (WWDT)
type WWDT_Type struct {
	MOD     volatile.Register32 // 0x0
	TC      volatile.Register32 // 0x4
	FEED    volatile.Register32 // 0x8
	TV      volatile.Register32 // 0xC
	CLKSEL  volatile.Register32 // 0x10
	WARNINT volatile.Register32 // 0x14
	WINDOW  volatile.Register32 // 0x18
}

// USART
type USART_Type struct {
	RBR           volatile.Register32 // 0x0
	DLM           volatile.Register32 // 0x4
	IIR           volatile.Register32 // 0x8
	LCR           volatile.Register32 // 0xC
	MCR           volatile.Register32 // 0x10
	LSR           volatile.Register32 // 0x14
	MSR           volatile.Register32 // 0x18
	SCR           volatile.Register32 // 0x1C
	ACR           volatile.Register32 // 0x20
	ICR           volatile.Register32 // 0x24
	FDR           volatile.Register32 // 0x28
	OSR           volatile.Register32 // 0x2C
	TER           volatile.Register32 // 0x30
	_             [12]byte
	HDEN          volatile.Register32 // 0x40
	_             [4]byte
	SCICTRL       volatile.Register32 // 0x48
	RS485CTRL     volatile.Register32 // 0x4C
	RS485ADRMATCH volatile.Register32 // 0x50
	RS485DLY      volatile.Register32 // 0x54
	SYNCCTRL      volatile.Register32 // 0x58
}

// 16-bit counter/timers CT16B0
type CT16B0_Type struct {
	IR   volatile.Register32 // 0x0
	TCR  volatile.Register32 // 0x4
	TC   volatile.Register32 // 0x8
	PR   volatile.Register32 // 0xC
	PC   volatile.Register32 // 0x10
	MCR  volatile.Register32 // 0x14
	MR0  volatile.Register32 // 0x18
	MR1  volatile.Register32 // 0x1C
	MR2  volatile.Register32 // 0x20
	MR3  volatile.Register32 // 0x24
	CCR  volatile.Register32 // 0x28
	CR0  volatile.Register32 // 0x2C
	_    [4]byte
	CR1  volatile.Register32 // 0x34
	_    [4]byte
	EMR  volatile.Register32 // 0x3C
	_    [48]byte
	CTCR volatile.Register32 // 0x70
	PWMC volatile.Register32 // 0x74
}

// 16-bit counter/timers CT16B1
type CT16B1_Type struct {
	IR   volatile.Register32 // 0x0
	TCR  volatile.Register32 // 0x4
	TC   volatile.Register32 // 0x8
	PR   volatile.Register32 // 0xC
	PC   volatile.Register32 // 0x10
	MCR  volatile.Register32 // 0x14
	MR0  volatile.Register32 // 0x18
	MR1  volatile.Register32 // 0x1C
	MR2  volatile.Register32 // 0x20
	MR3  volatile.Register32 // 0x24
	CCR  volatile.Register32 // 0x28
	CR0  volatile.Register32 // 0x2C
	CR1  volatile.Register32 // 0x30
	_    [8]byte
	EMR  volatile.Register32 // 0x3C
	_    [48]byte
	CTCR volatile.Register32 // 0x70
	PWMC volatile.Register32 // 0x74
}

// 32-bit counter/timers CT32B0
type CT32B0_Type struct {
	IR   volatile.Register32 // 0x0
	TCR  volatile.Register32 // 0x4
	TC   volatile.Register32 // 0x8
	PR   volatile.Register32 // 0xC
	PC   volatile.Register32 // 0x10
	MCR  volatile.Register32 // 0x14
	MR0  volatile.Register32 // 0x18
	MR1  volatile.Register32 // 0x1C
	MR2  volatile.Register32 // 0x20
	MR3  volatile.Register32 // 0x24
	CCR  volatile.Register32 // 0x28
	CR0  volatile.Register32 // 0x2C
	_    [4]byte
	CR1  volatile.Register32 // 0x34
	_    [4]byte
	EMR  volatile.Register32 // 0x3C
	_    [48]byte
	CTCR volatile.Register32 // 0x70
	PWMC volatile.Register32 // 0x74
}

// 32-bit counter/timers CT32B1
type CT32B1_Type struct {
	IR   volatile.Register32 // 0x0
	TCR  volatile.Register32 // 0x4
	TC   volatile.Register32 // 0x8
	PR   volatile.Register32 // 0xC
	PC   volatile.Register32 // 0x10
	MCR  volatile.Register32 // 0x14
	MR0  volatile.Register32 // 0x18
	MR1  volatile.Register32 // 0x1C
	MR2  volatile.Register32 // 0x20
	MR3  volatile.Register32 // 0x24
	CCR  volatile.Register32 // 0x28
	CR0  volatile.Register32 // 0x2C
	CR1  volatile.Register32 // 0x30
	_    [8]byte
	EMR  volatile.Register32 // 0x3C
	_    [48]byte
	CTCR volatile.Register32 // 0x70
	PWMC volatile.Register32 // 0x74
}

// ADC
type ADC_Type struct {
	CR    volatile.Register32 // 0x0
	GDR   volatile.Register32 // 0x4
	_     [4]byte
	INTEN volatile.Register32 // 0xC
	DR0   volatile.Register32 // 0x10
	DR1   volatile.Register32 // 0x14
	DR2   volatile.Register32 // 0x18
	DR3   volatile.Register32 // 0x1C
	DR4   volatile.Register32 // 0x20
	DR5   volatile.Register32 // 0x24
	DR6   volatile.Register32 // 0x28
	DR7   volatile.Register32 // 0x2C
	STAT  volatile.Register32 // 0x30
}

// Power Management Unit (PMU)
type PMU_Type struct {
	PCON   volatile.Register32 // 0x0
	GPREG0 volatile.Register32 // 0x4
	GPREG1 volatile.Register32 // 0x8
	GPREG2 volatile.Register32 // 0xC
	GPREG3 volatile.Register32 // 0x10
	GPREG4 volatile.Register32 // 0x14
}

// Flash controller
type FLASHCTRL_Type struct {
	_         [16]byte
	FLASHCFG  volatile.Register32 // 0x10
	_         [12]byte
	FMSSTART  volatile.Register32 // 0x20
	FMSSTOP   volatile.Register32 // 0x24
	_         [4]byte
	FMSW0     volatile.Register32 // 0x2C
	FMSW1     volatile.Register32 // 0x30
	FMSW2     volatile.Register32 // 0x34
	FMSW3     volatile.Register32 // 0x38
	_         [96]byte
	EEMSSTART volatile.Register32 // 0x9C
	EEMSSTOP  volatile.Register32 // 0xA0
	EEMSSIG   volatile.Register32 // 0xA4
	_         [3896]byte
	FMSTAT    volatile.Register32 // 0xFE0
	_         [4]byte
	FMSTATCLR volatile.Register32 // 0xFE8
}

// SSP/SPI
type SSP0_Type struct {
	CR0  volatile.Register32 // 0x0
	CR1  volatile.Register32 // 0x4
	DR   volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	CPSR volatile.Register32 // 0x10
	IMSC volatile.Register32 // 0x14
	RIS  volatile.Register32 // 0x18
	MIS  volatile.Register32 // 0x1C
	ICR  volatile.Register32 // 0x20
}

// I/O configuration Modification
type IOCON_Type struct {
	RESET_PIO0_0  volatile.Register32 // 0x0
	PIO0_1        volatile.Register32 // 0x4
	PIO0_2        volatile.Register32 // 0x8
	PIO0_3        volatile.Register32 // 0xC
	PIO0_4        volatile.Register32 // 0x10
	PIO0_5        volatile.Register32 // 0x14
	PIO0_6        volatile.Register32 // 0x18
	PIO0_7        volatile.Register32 // 0x1C
	PIO0_8        volatile.Register32 // 0x20
	PIO0_9        volatile.Register32 // 0x24
	SWCLK_PIO0_10 volatile.Register32 // 0x28
	TDI_PIO0_11   volatile.Register32 // 0x2C
	TMS_PIO0_12   volatile.Register32 // 0x30
	TDO_PIO0_13   volatile.Register32 // 0x34
	TRST_PIO0_14  volatile.Register32 // 0x38
	SWDIO_PIO0_15 volatile.Register32 // 0x3C
	PIO0_16       volatile.Register32 // 0x40
	PIO0_17       volatile.Register32 // 0x44
	PIO0_18       volatile.Register32 // 0x48
	PIO0_19       volatile.Register32 // 0x4C
	PIO0_20       volatile.Register32 // 0x50
	PIO0_21       volatile.Register32 // 0x54
	PIO0_22       volatile.Register32 // 0x58
	PIO0_23       volatile.Register32 // 0x5C
	PIO1_0        volatile.Register32 // 0x60
	PIO1_1        volatile.Register32 // 0x64
	PIO1_2        volatile.Register32 // 0x68
	PIO1_3        volatile.Register32 // 0x6C
	PIO1_4        volatile.Register32 // 0x70
	PIO1_5        volatile.Register32 // 0x74
	PIO1_6        volatile.Register32 // 0x78
	PIO1_7        volatile.Register32 // 0x7C
	PIO1_8        volatile.Register32 // 0x80
	PIO1_9        volatile.Register32 // 0x84
	PIO1_10       volatile.Register32 // 0x88
	PIO1_11       volatile.Register32 // 0x8C
	PIO1_12       volatile.Register32 // 0x90
	PIO1_13       volatile.Register32 // 0x94
	PIO1_14       volatile.Register32 // 0x98
	PIO1_15       volatile.Register32 // 0x9C
	PIO1_16       volatile.Register32 // 0xA0
	PIO1_17       volatile.Register32 // 0xA4
	PIO1_18       volatile.Register32 // 0xA8
	PIO1_19       volatile.Register32 // 0xAC
	PIO1_20       volatile.Register32 // 0xB0
	PIO1_21       volatile.Register32 // 0xB4
	PIO1_22       volatile.Register32 // 0xB8
	PIO1_23       volatile.Register32 // 0xBC
	PIO1_24       volatile.Register32 // 0xC0
	PIO1_25       volatile.Register32 // 0xC4
	PIO1_26       volatile.Register32 // 0xC8
	PIO1_27       volatile.Register32 // 0xCC
	PIO1_28       volatile.Register32 // 0xD0
	PIO1_29       volatile.Register32 // 0xD4
	_             [4]byte
	PIO1_31       volatile.Register32 // 0xDC
}

// System control block
type SYSCON_Type struct {
	SYSMEMREMAP   volatile.Register32 // 0x0
	PRESETCTRL    volatile.Register32 // 0x4
	SYSPLLCTRL    volatile.Register32 // 0x8
	SYSPLLSTAT    volatile.Register32 // 0xC
	USBPLLCTRL    volatile.Register32 // 0x10
	USBPLLSTAT    volatile.Register32 // 0x14
	_             [8]byte
	SYSOSCCTRL    volatile.Register32 // 0x20
	WDTOSCCTRL    volatile.Register32 // 0x24
	_             [8]byte
	SYSRSTSTAT    volatile.Register32 // 0x30
	_             [12]byte
	SYSPLLCLKSEL  volatile.Register32 // 0x40
	SYSPLLCLKUEN  volatile.Register32 // 0x44
	USBPLLCLKSEL  volatile.Register32 // 0x48
	USBPLLCLKUEN  volatile.Register32 // 0x4C
	_             [32]byte
	MAINCLKSEL    volatile.Register32 // 0x70
	MAINCLKUEN    volatile.Register32 // 0x74
	SYSAHBCLKDIV  volatile.Register32 // 0x78
	_             [4]byte
	SYSAHBCLKCTRL volatile.Register32 // 0x80
	_             [16]byte
	SSP0CLKDIV    volatile.Register32 // 0x94
	UARTCLKDIV    volatile.Register32 // 0x98
	SSP1CLKDIV    volatile.Register32 // 0x9C
	_             [32]byte
	USBCLKSEL     volatile.Register32 // 0xC0
	USBCLKUEN     volatile.Register32 // 0xC4
	USBCLKDIV     volatile.Register32 // 0xC8
	_             [20]byte
	CLKOUTSEL     volatile.Register32 // 0xE0
	CLKOUTUEN     volatile.Register32 // 0xE4
	CLKOUTDIV     volatile.Register32 // 0xE8
	_             [20]byte
	PIOPORCAP0    volatile.Register32 // 0x100
	PIOPORCAP1    volatile.Register32 // 0x104
	_             [72]byte
	BODCTRL       volatile.Register32 // 0x150
	SYSTCKCAL     volatile.Register32 // 0x154
	_             [24]byte
	IRQLATENCY    volatile.Register32 // 0x170
	NMISRC        volatile.Register32 // 0x174
	PINTSEL0      volatile.Register32 // 0x178
	PINTSEL1      volatile.Register32 // 0x17C
	PINTSEL2      volatile.Register32 // 0x180
	PINTSEL3      volatile.Register32 // 0x184
	PINTSEL4      volatile.Register32 // 0x188
	PINTSEL5      volatile.Register32 // 0x18C
	PINTSEL6      volatile.Register32 // 0x190
	PINTSEL7      volatile.Register32 // 0x194
	USBCLKCTRL    volatile.Register32 // 0x198
	USBCLKST      volatile.Register32 // 0x19C
	_             [100]byte
	STARTERP0     volatile.Register32 // 0x204
	_             [12]byte
	STARTERP1     volatile.Register32 // 0x214
	_             [24]byte
	PDSLEEPCFG    volatile.Register32 // 0x230
	PDAWAKECFG    volatile.Register32 // 0x234
	PDRUNCFG      volatile.Register32 // 0x238
	_             [440]byte
	DEVICE_ID     volatile.Register32 // 0x3F4
}

// GPIO pin interrupt
type GPIO_PIN_INT_Type struct {
	ISEL  volatile.Register32 // 0x0
	IENR  volatile.Register32 // 0x4
	SIENR volatile.Register32 // 0x8
	CIENR volatile.Register32 // 0xC
	IENF  volatile.Register32 // 0x10
	SIENF volatile.Register32 // 0x14
	CIENF volatile.Register32 // 0x18
	RISE  volatile.Register32 // 0x1C
	FALL  volatile.Register32 // 0x20
	IST   volatile.Register32 // 0x24
}

// GPIO group interrupt
type GPIO_GROUP_INT0_Type struct {
	CTRL      volatile.Register32 // 0x0
	_         [28]byte
	PORT_POL0 volatile.Register32 // 0x20
	PORT_POL1 volatile.Register32 // 0x24
	_         [24]byte
	PORT_ENA0 volatile.Register32 // 0x40
	PORT_ENA1 volatile.Register32 // 0x44
}

// USB2.0 device controller
type USB_Type struct {
	DEVCMDSTAT   volatile.Register32 // 0x0
	INFO         volatile.Register32 // 0x4
	EPLISTSTART  volatile.Register32 // 0x8
	DATABUFSTART volatile.Register32 // 0xC
	LPM          volatile.Register32 // 0x10
	EPSKIP       volatile.Register32 // 0x14
	EPINUSE      volatile.Register32 // 0x18
	EPBUFCFG     volatile.Register32 // 0x1C
	INTSTAT      volatile.Register32 // 0x20
	INTEN        volatile.Register32 // 0x24
	INTSETSTAT   volatile.Register32 // 0x28
	INTROUTING   volatile.Register32 // 0x2C
	_            [4]byte
	EPTOGGLE     volatile.Register32 // 0x34
}

// GPIO port
type GPIO_PORT_Type struct {
	B00   volatile.Register8 // 0x0
	B01   volatile.Register8 // 0x1
	B02   volatile.Register8 // 0x2
	B03   volatile.Register8 // 0x3
	B04   volatile.Register8 // 0x4
	B05   volatile.Register8 // 0x5
	B06   volatile.Register8 // 0x6
	B07   volatile.Register8 // 0x7
	B08   volatile.Register8 // 0x8
	B09   volatile.Register8 // 0x9
	B010  volatile.Register8 // 0xA
	B011  volatile.Register8 // 0xB
	B012  volatile.Register8 // 0xC
	B013  volatile.Register8 // 0xD
	B014  volatile.Register8 // 0xE
	B015  volatile.Register8 // 0xF
	B016  volatile.Register8 // 0x10
	B017  volatile.Register8 // 0x11
	B018  volatile.Register8 // 0x12
	B019  volatile.Register8 // 0x13
	B020  volatile.Register8 // 0x14
	B021  volatile.Register8 // 0x15
	B022  volatile.Register8 // 0x16
	B023  volatile.Register8 // 0x17
	B024  volatile.Register8 // 0x18
	B025  volatile.Register8 // 0x19
	B026  volatile.Register8 // 0x1A
	B027  volatile.Register8 // 0x1B
	B028  volatile.Register8 // 0x1C
	B029  volatile.Register8 // 0x1D
	B030  volatile.Register8 // 0x1E
	B031  volatile.Register8 // 0x1F
	B132  volatile.Register8 // 0x20
	B133  volatile.Register8 // 0x21
	B134  volatile.Register8 // 0x22
	B135  volatile.Register8 // 0x23
	B136  volatile.Register8 // 0x24
	B137  volatile.Register8 // 0x25
	B138  volatile.Register8 // 0x26
	B139  volatile.Register8 // 0x27
	B140  volatile.Register8 // 0x28
	B141  volatile.Register8 // 0x29
	B142  volatile.Register8 // 0x2A
	B143  volatile.Register8 // 0x2B
	B144  volatile.Register8 // 0x2C
	B145  volatile.Register8 // 0x2D
	B146  volatile.Register8 // 0x2E
	B147  volatile.Register8 // 0x2F
	B148  volatile.Register8 // 0x30
	B149  volatile.Register8 // 0x31
	B150  volatile.Register8 // 0x32
	B151  volatile.Register8 // 0x33
	B152  volatile.Register8 // 0x34
	B153  volatile.Register8 // 0x35
	B154  volatile.Register8 // 0x36
	B155  volatile.Register8 // 0x37
	B156  volatile.Register8 // 0x38
	B157  volatile.Register8 // 0x39
	B158  volatile.Register8 // 0x3A
	B159  volatile.Register8 // 0x3B
	B160  volatile.Register8 // 0x3C
	B161  volatile.Register8 // 0x3D
	B162  volatile.Register8 // 0x3E
	B163  volatile.Register8 // 0x3F
	_     [4032]byte
	W0    volatile.Register32 // 0x1000
	W1    volatile.Register32 // 0x1004
	W2    volatile.Register32 // 0x1008
	W3    volatile.Register32 // 0x100C
	W4    volatile.Register32 // 0x1010
	W5    volatile.Register32 // 0x1014
	W6    volatile.Register32 // 0x1018
	W7    volatile.Register32 // 0x101C
	W8    volatile.Register32 // 0x1020
	W9    volatile.Register32 // 0x1024
	W10   volatile.Register32 // 0x1028
	W11   volatile.Register32 // 0x102C
	W12   volatile.Register32 // 0x1030
	W13   volatile.Register32 // 0x1034
	W14   volatile.Register32 // 0x1038
	W15   volatile.Register32 // 0x103C
	W16   volatile.Register32 // 0x1040
	W17   volatile.Register32 // 0x1044
	W18   volatile.Register32 // 0x1048
	W19   volatile.Register32 // 0x104C
	W20   volatile.Register32 // 0x1050
	W21   volatile.Register32 // 0x1054
	W22   volatile.Register32 // 0x1058
	W23   volatile.Register32 // 0x105C
	W24   volatile.Register32 // 0x1060
	W25   volatile.Register32 // 0x1064
	W26   volatile.Register32 // 0x1068
	W27   volatile.Register32 // 0x106C
	W28   volatile.Register32 // 0x1070
	W29   volatile.Register32 // 0x1074
	W30   volatile.Register32 // 0x1078
	W31   volatile.Register32 // 0x107C
	W32   volatile.Register32 // 0x1080
	W33   volatile.Register32 // 0x1084
	W34   volatile.Register32 // 0x1088
	W35   volatile.Register32 // 0x108C
	W36   volatile.Register32 // 0x1090
	W37   volatile.Register32 // 0x1094
	W38   volatile.Register32 // 0x1098
	W39   volatile.Register32 // 0x109C
	W40   volatile.Register32 // 0x10A0
	W41   volatile.Register32 // 0x10A4
	W42   volatile.Register32 // 0x10A8
	W43   volatile.Register32 // 0x10AC
	W44   volatile.Register32 // 0x10B0
	W45   volatile.Register32 // 0x10B4
	W46   volatile.Register32 // 0x10B8
	W47   volatile.Register32 // 0x10BC
	W48   volatile.Register32 // 0x10C0
	W49   volatile.Register32 // 0x10C4
	W50   volatile.Register32 // 0x10C8
	W51   volatile.Register32 // 0x10CC
	W52   volatile.Register32 // 0x10D0
	W53   volatile.Register32 // 0x10D4
	W54   volatile.Register32 // 0x10D8
	W55   volatile.Register32 // 0x10DC
	W56   volatile.Register32 // 0x10E0
	W57   volatile.Register32 // 0x10E4
	W58   volatile.Register32 // 0x10E8
	W59   volatile.Register32 // 0x10EC
	W60   volatile.Register32 // 0x10F0
	W61   volatile.Register32 // 0x10F4
	W62   volatile.Register32 // 0x10F8
	W63   volatile.Register32 // 0x10FC
	_     [3840]byte
	DIR0  volatile.Register32 // 0x2000
	DIR1  volatile.Register32 // 0x2004
	_     [120]byte
	MASK0 volatile.Register32 // 0x2080
	MASK1 volatile.Register32 // 0x2084
	_     [120]byte
	PIN0  volatile.Register32 // 0x2100
	PIN1  volatile.Register32 // 0x2104
	_     [120]byte
	MPIN0 volatile.Register32 // 0x2180
	MPIN1 volatile.Register32 // 0x2184
	_     [120]byte
	SET0  volatile.Register32 // 0x2200
	SET1  volatile.Register32 // 0x2204
	_     [120]byte
	CLR0  volatile.Register32 // 0x2280
	CLR1  volatile.Register32 // 0x2284
	_     [120]byte
	NOT0  volatile.Register32 // 0x2300
	NOT1  volatile.Register32 // 0x2304
}

// Bitfields for I2C: I2C-bus controller
const (
	// CONSET: I2C Control Set Register. When a one is written to a bit of this register, the corresponding bit in the I2C control register is set. Writing a zero has no effect on the corresponding bit in the I2C control register.
	// Position of RESERVED field.
	I2C_CONSET_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	I2C_CONSET_RESERVED_Msk = 0x3
	// Position of AA field.
	I2C_CONSET_AA_Pos = 0x2
	// Bit mask of AA field.
	I2C_CONSET_AA_Msk = 0x4
	// Bit AA.
	I2C_CONSET_AA = 0x4
	// Position of SI field.
	I2C_CONSET_SI_Pos = 0x3
	// Bit mask of SI field.
	I2C_CONSET_SI_Msk = 0x8
	// Bit SI.
	I2C_CONSET_SI = 0x8
	// Position of STO field.
	I2C_CONSET_STO_Pos = 0x4
	// Bit mask of STO field.
	I2C_CONSET_STO_Msk = 0x10
	// Bit STO.
	I2C_CONSET_STO = 0x10
	// Position of STA field.
	I2C_CONSET_STA_Pos = 0x5
	// Bit mask of STA field.
	I2C_CONSET_STA_Msk = 0x20
	// Bit STA.
	I2C_CONSET_STA = 0x20
	// Position of I2EN field.
	I2C_CONSET_I2EN_Pos = 0x6
	// Bit mask of I2EN field.
	I2C_CONSET_I2EN_Msk = 0x40
	// Bit I2EN.
	I2C_CONSET_I2EN = 0x40
	// Position of RESERVED field.
	I2C_CONSET_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C_CONSET_RESERVED_Msk = 0xffffff80

	// STAT: I2C Status Register. During I2C operation, this register provides detailed status codes that allow software to determine the next action needed.
	// Position of RESERVED field.
	I2C_STAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	I2C_STAT_RESERVED_Msk = 0x7
	// Position of Status field.
	I2C_STAT_Status_Pos = 0x3
	// Bit mask of Status field.
	I2C_STAT_Status_Msk = 0xf8
	// Position of RESERVED field.
	I2C_STAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_STAT_RESERVED_Msk = 0xffffff00

	// DAT: I2C Data Register. During master or slave transmit mode, data to be transmitted is written to this register. During master or slave receive mode, data that has been received may be read from this register.
	// Position of Data field.
	I2C_DAT_Data_Pos = 0x0
	// Bit mask of Data field.
	I2C_DAT_Data_Msk = 0xff
	// Position of RESERVED field.
	I2C_DAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_DAT_RESERVED_Msk = 0xffffff00

	// ADR0: I2C Slave Address Register 0. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
	// Position of GC field.
	I2C_ADR0_GC_Pos = 0x0
	// Bit mask of GC field.
	I2C_ADR0_GC_Msk = 0x1
	// Bit GC.
	I2C_ADR0_GC = 0x1
	// Position of Address field.
	I2C_ADR0_Address_Pos = 0x1
	// Bit mask of Address field.
	I2C_ADR0_Address_Msk = 0xfe
	// Position of RESERVED field.
	I2C_ADR0_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_ADR0_RESERVED_Msk = 0xffffff00

	// SCLH: SCH Duty Cycle Register High Half Word. Determines the high time of the I2C clock.
	// Position of SCLH field.
	I2C_SCLH_SCLH_Pos = 0x0
	// Bit mask of SCLH field.
	I2C_SCLH_SCLH_Msk = 0xffff
	// Position of RESERVED field.
	I2C_SCLH_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	I2C_SCLH_RESERVED_Msk = 0xffff0000

	// SCLL: SCL Duty Cycle Register Low Half Word. Determines the low time of the I2C clock. I2nSCLL and I2nSCLH together determine the clock frequency generated by an I2C master and certain times used in slave mode.
	// Position of SCLL field.
	I2C_SCLL_SCLL_Pos = 0x0
	// Bit mask of SCLL field.
	I2C_SCLL_SCLL_Msk = 0xffff
	// Position of RESERVED field.
	I2C_SCLL_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	I2C_SCLL_RESERVED_Msk = 0xffff0000

	// CONCLR: I2C Control Clear Register. When a one is written to a bit of this register, the corresponding bit in the I2C control register is cleared. Writing a zero has no effect on the corresponding bit in the I2C control register.
	// Position of RESERVED field.
	I2C_CONCLR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	I2C_CONCLR_RESERVED_Msk = 0x3
	// Position of AAC field.
	I2C_CONCLR_AAC_Pos = 0x2
	// Bit mask of AAC field.
	I2C_CONCLR_AAC_Msk = 0x4
	// Bit AAC.
	I2C_CONCLR_AAC = 0x4
	// Position of SIC field.
	I2C_CONCLR_SIC_Pos = 0x3
	// Bit mask of SIC field.
	I2C_CONCLR_SIC_Msk = 0x8
	// Bit SIC.
	I2C_CONCLR_SIC = 0x8
	// Position of RESERVED field.
	I2C_CONCLR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	I2C_CONCLR_RESERVED_Msk = 0x10
	// Bit RESERVED.
	I2C_CONCLR_RESERVED = 0x10
	// Position of STAC field.
	I2C_CONCLR_STAC_Pos = 0x5
	// Bit mask of STAC field.
	I2C_CONCLR_STAC_Msk = 0x20
	// Bit STAC.
	I2C_CONCLR_STAC = 0x20
	// Position of I2ENC field.
	I2C_CONCLR_I2ENC_Pos = 0x6
	// Bit mask of I2ENC field.
	I2C_CONCLR_I2ENC_Msk = 0x40
	// Bit I2ENC.
	I2C_CONCLR_I2ENC = 0x40
	// Position of RESERVED field.
	I2C_CONCLR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C_CONCLR_RESERVED_Msk = 0x80
	// Bit RESERVED.
	I2C_CONCLR_RESERVED = 0x80
	// Position of RESERVED field.
	I2C_CONCLR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_CONCLR_RESERVED_Msk = 0xffffff00

	// MMCTRL: Monitor mode control register.
	// Position of MM_ENA field.
	I2C_MMCTRL_MM_ENA_Pos = 0x0
	// Bit mask of MM_ENA field.
	I2C_MMCTRL_MM_ENA_Msk = 0x1
	// Bit MM_ENA.
	I2C_MMCTRL_MM_ENA = 0x1
	// Monitor mode disabled.
	I2C_MMCTRL_MM_ENA_MONITOR_MODE_DISABLE = 0x0
	// The I2C module will enter monitor mode. In this mode the SDA output will be forced high. This will prevent the I2C module from outputting data of any kind (including ACK) onto the I 2C data bus. Depending on the state of the ENA_SCL bit, the output may be also forced high, preventing the module from having control over the I2C clock line.
	I2C_MMCTRL_MM_ENA_THE_I2C_MODULE_WILL_ = 0x1
	// Position of ENA_SCL field.
	I2C_MMCTRL_ENA_SCL_Pos = 0x1
	// Bit mask of ENA_SCL field.
	I2C_MMCTRL_ENA_SCL_Msk = 0x2
	// Bit ENA_SCL.
	I2C_MMCTRL_ENA_SCL = 0x2
	// When this bit is cleared to 0, the SCL output will be forced high when the module is in monitor mode. As described above, this will prevent the module from having any control over the I2C clock line.
	I2C_MMCTRL_ENA_SCL_HIGH = 0x0
	// When this bit is set, the I2C module may exercise the same control over the clock line that it would in normal operation. This means that, acting as a slave peripheral, the I2C module can stretch the clock line (hold it low) until it has had time to respond to an I2C interrupt.[1]
	I2C_MMCTRL_ENA_SCL_NORMAL = 0x1
	// Position of MATCH_ALL field.
	I2C_MMCTRL_MATCH_ALL_Pos = 0x2
	// Bit mask of MATCH_ALL field.
	I2C_MMCTRL_MATCH_ALL_Msk = 0x4
	// Bit MATCH_ALL.
	I2C_MMCTRL_MATCH_ALL = 0x4
	// When this bit is cleared, an interrupt will only be generated when a match occurs to one of the (up-to) four address registers described above. That is, the module will respond as a normal slave as far as address-recognition is concerned.
	I2C_MMCTRL_MATCH_ALL_MATCH = 0x0
	// When this bit is set to 1 and the I2C is in monitor mode, an interrupt will be generated on ANY address received. This will enable the part to monitor all traffic on the bus.
	I2C_MMCTRL_MATCH_ALL_ANYADDRESS = 0x1
	// Position of RESERVED field.
	I2C_MMCTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	I2C_MMCTRL_RESERVED_Msk = 0xfffffff8

	// ADR1: I2C Slave Address Register. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
	// Position of GC field.
	I2C_ADR_GC_Pos = 0x0
	// Bit mask of GC field.
	I2C_ADR_GC_Msk = 0x1
	// Bit GC.
	I2C_ADR_GC = 0x1
	// Position of Address field.
	I2C_ADR_Address_Pos = 0x1
	// Bit mask of Address field.
	I2C_ADR_Address_Msk = 0xfe
	// Position of RESERVED field.
	I2C_ADR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_ADR_RESERVED_Msk = 0xffffff00

	// DATA_BUFFER: Data buffer register. The contents of the 8 MSBs of the I2DAT shift register will be transferred to the DATA_BUFFER automatically after every nine bits (8 bits of data plus ACK or NACK) has been received on the bus.
	// Position of Data field.
	I2C_DATA_BUFFER_Data_Pos = 0x0
	// Bit mask of Data field.
	I2C_DATA_BUFFER_Data_Msk = 0xff
	// Position of RESERVED field.
	I2C_DATA_BUFFER_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_DATA_BUFFER_RESERVED_Msk = 0xffffff00

	// MASK0: I2C Slave address mask register. This mask register is associated with I2ADR0 to determine an address match. The mask register has no effect when comparing to the General Call address (0000000).
	// Position of RESERVED field.
	I2C_MASK_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	I2C_MASK_RESERVED_Msk = 0x1
	// Bit RESERVED.
	I2C_MASK_RESERVED = 0x1
	// Position of MASK field.
	I2C_MASK_MASK_Pos = 0x1
	// Bit mask of MASK field.
	I2C_MASK_MASK_Msk = 0xfe
	// Position of RESERVED field.
	I2C_MASK_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_MASK_RESERVED_Msk = 0xffffff00
)

// Bitfields for WWDT: Windowed Watchdog Timer (WWDT)
const (
	// MOD: Watchdog mode register. This register contains the basic mode and status of the Watchdog Timer.
	// Position of WDEN field.
	WWDT_MOD_WDEN_Pos = 0x0
	// Bit mask of WDEN field.
	WWDT_MOD_WDEN_Msk = 0x1
	// Bit WDEN.
	WWDT_MOD_WDEN = 0x1
	// The watchdog timer is stopped.
	WWDT_MOD_WDEN_STOPPED = 0x0
	// The watchdog timer is running.
	WWDT_MOD_WDEN_RUNNING = 0x1
	// Position of WDRESET field.
	WWDT_MOD_WDRESET_Pos = 0x1
	// Bit mask of WDRESET field.
	WWDT_MOD_WDRESET_Msk = 0x2
	// Bit WDRESET.
	WWDT_MOD_WDRESET = 0x2
	// A watchdog timeout will not cause a chip reset.
	WWDT_MOD_WDRESET_INTERRUPT = 0x0
	// A watchdog timeout will cause a chip reset.
	WWDT_MOD_WDRESET_RESET = 0x1
	// Position of WDTOF field.
	WWDT_MOD_WDTOF_Pos = 0x2
	// Bit mask of WDTOF field.
	WWDT_MOD_WDTOF_Msk = 0x4
	// Bit WDTOF.
	WWDT_MOD_WDTOF = 0x4
	// Position of WDINT field.
	WWDT_MOD_WDINT_Pos = 0x3
	// Bit mask of WDINT field.
	WWDT_MOD_WDINT_Msk = 0x8
	// Bit WDINT.
	WWDT_MOD_WDINT = 0x8
	// Position of WDPROTECT field.
	WWDT_MOD_WDPROTECT_Pos = 0x4
	// Bit mask of WDPROTECT field.
	WWDT_MOD_WDPROTECT_Msk = 0x10
	// Bit WDPROTECT.
	WWDT_MOD_WDPROTECT = 0x10
	// The watchdog time-out value (TC) can be changed at any time.
	WWDT_MOD_WDPROTECT_NOT_LOCKED = 0x0
	// The watchdog time-out value (TC) can be changed only after the counter is below the value of WDWARNINT and WDWINDOW.
	WWDT_MOD_WDPROTECT_LOCKED = 0x1
	// Position of LOCK field.
	WWDT_MOD_LOCK_Pos = 0x5
	// Bit mask of LOCK field.
	WWDT_MOD_LOCK_Msk = 0x20
	// Bit LOCK.
	WWDT_MOD_LOCK = 0x20
	// Position of RESERVED field.
	WWDT_MOD_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	WWDT_MOD_RESERVED_Msk = 0xffffffc0

	// TC: Watchdog timer constant register. This 24-bit register determines the time-out value.
	// Position of COUNT field.
	WWDT_TC_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	WWDT_TC_COUNT_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_TC_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_TC_RESERVED_Msk = 0xff000000

	// FEED: Watchdog feed sequence register. Writing 0xAA followed by 0x55 to this register reloads the Watchdog timer with the value contained in WDTC.
	// Position of FEED field.
	WWDT_FEED_FEED_Pos = 0x0
	// Bit mask of FEED field.
	WWDT_FEED_FEED_Msk = 0xff
	// Position of RESERVED field.
	WWDT_FEED_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	WWDT_FEED_RESERVED_Msk = 0xffffff00

	// TV: Watchdog timer value register. This 24-bit register reads out the current value of the Watchdog timer.
	// Position of COUNT field.
	WWDT_TV_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	WWDT_TV_COUNT_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_TV_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_TV_RESERVED_Msk = 0xff000000

	// CLKSEL: Watchdog clock select register.
	// Position of CLKSEL field.
	WWDT_CLKSEL_CLKSEL_Pos = 0x0
	// Bit mask of CLKSEL field.
	WWDT_CLKSEL_CLKSEL_Msk = 0x1
	// Bit CLKSEL.
	WWDT_CLKSEL_CLKSEL = 0x1
	// IRC
	WWDT_CLKSEL_CLKSEL_IRC = 0x0
	// Watchdog oscillator (WDOSC)
	WWDT_CLKSEL_CLKSEL_WATCHDOG_OSCILLATOR_ = 0x1
	// Position of RESERVED field.
	WWDT_CLKSEL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	WWDT_CLKSEL_RESERVED_Msk = 0x7ffffffe
	// Position of LOCK field.
	WWDT_CLKSEL_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	WWDT_CLKSEL_LOCK_Msk = 0x80000000
	// Bit LOCK.
	WWDT_CLKSEL_LOCK = 0x80000000

	// WARNINT: Watchdog Warning Interrupt compare value.
	// Position of WARNINT field.
	WWDT_WARNINT_WARNINT_Pos = 0x0
	// Bit mask of WARNINT field.
	WWDT_WARNINT_WARNINT_Msk = 0x3ff
	// Position of RESERVED field.
	WWDT_WARNINT_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	WWDT_WARNINT_RESERVED_Msk = 0xfffffc00

	// WINDOW: Watchdog Window compare value.
	// Position of WINDOW field.
	WWDT_WINDOW_WINDOW_Pos = 0x0
	// Bit mask of WINDOW field.
	WWDT_WINDOW_WINDOW_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_WINDOW_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_WINDOW_RESERVED_Msk = 0xff000000
)

// Bitfields for USART: USART
const (
	// RBR: Receiver Buffer Register. Contains the next received character to be read. (DLAB=0)
	// Position of RBR field.
	USART_RBR_RBR_Pos = 0x0
	// Bit mask of RBR field.
	USART_RBR_RBR_Msk = 0xff
	// Position of RESERVED field.
	USART_RBR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_RBR_RESERVED_Msk = 0xffffff00

	// THR: Transmit Holding Register. The next character to be transmitted is written here. (DLAB=0)
	// Position of THR field.
	USART_THR_THR_Pos = 0x0
	// Bit mask of THR field.
	USART_THR_THR_Msk = 0xff
	// Position of RESERVED field.
	USART_THR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_THR_RESERVED_Msk = 0xffffff00

	// DLL: Divisor Latch LSB. Least significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider. (DLAB=1)
	// Position of DLLSB field.
	USART_DLL_DLLSB_Pos = 0x0
	// Bit mask of DLLSB field.
	USART_DLL_DLLSB_Msk = 0xff
	// Position of RESERVED field.
	USART_DLL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_DLL_RESERVED_Msk = 0xffffff00

	// DLM: Divisor Latch MSB. Most significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider. (DLAB=1)
	// Position of DLMSB field.
	USART_DLM_DLMSB_Pos = 0x0
	// Bit mask of DLMSB field.
	USART_DLM_DLMSB_Msk = 0xff
	// Position of RESERVED field.
	USART_DLM_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_DLM_RESERVED_Msk = 0xffffff00

	// IER: Interrupt Enable Register. Contains individual interrupt enable bits for the 7 potential USART interrupts. (DLAB=0)
	// Position of RBRINTEN field.
	USART_IER_RBRINTEN_Pos = 0x0
	// Bit mask of RBRINTEN field.
	USART_IER_RBRINTEN_Msk = 0x1
	// Bit RBRINTEN.
	USART_IER_RBRINTEN = 0x1
	// Disable the RDA interrupt.
	USART_IER_RBRINTEN_DISABLE_THE_RDA_INTE = 0x0
	// Enable the RDA interrupt.
	USART_IER_RBRINTEN_ENABLE_THE_RDA_INTER = 0x1
	// Position of THREINTEN field.
	USART_IER_THREINTEN_Pos = 0x1
	// Bit mask of THREINTEN field.
	USART_IER_THREINTEN_Msk = 0x2
	// Bit THREINTEN.
	USART_IER_THREINTEN = 0x2
	// Disable the THRE interrupt.
	USART_IER_THREINTEN_DISABLE_THE_THRE_INT = 0x0
	// Enable the THRE interrupt.
	USART_IER_THREINTEN_ENABLE_THE_THRE_INTE = 0x1
	// Position of RLSINTEN field.
	USART_IER_RLSINTEN_Pos = 0x2
	// Bit mask of RLSINTEN field.
	USART_IER_RLSINTEN_Msk = 0x4
	// Bit RLSINTEN.
	USART_IER_RLSINTEN = 0x4
	// Disable the RLS interrupt.
	USART_IER_RLSINTEN_DISABLE_THE_RLS_INTE = 0x0
	// Enable the RLS interrupt.
	USART_IER_RLSINTEN_ENABLE_THE_RLS_INTER = 0x1
	// Position of MSINTEN field.
	USART_IER_MSINTEN_Pos = 0x3
	// Bit mask of MSINTEN field.
	USART_IER_MSINTEN_Msk = 0x8
	// Bit MSINTEN.
	USART_IER_MSINTEN = 0x8
	// Disable the MS interrupt.
	USART_IER_MSINTEN_DISABLE_THE_MS_INTER = 0x0
	// Enable the MS interrupt.
	USART_IER_MSINTEN_ENABLE_THE_MS_INTERR = 0x1
	// Position of RESERVED field.
	USART_IER_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART_IER_RESERVED_Msk = 0xf0
	// Position of ABEOINTEN field.
	USART_IER_ABEOINTEN_Pos = 0x8
	// Bit mask of ABEOINTEN field.
	USART_IER_ABEOINTEN_Msk = 0x100
	// Bit ABEOINTEN.
	USART_IER_ABEOINTEN = 0x100
	// Disable end of auto-baud Interrupt.
	USART_IER_ABEOINTEN_DISABLE_END_OF_AUTO_ = 0x0
	// Enable end of auto-baud Interrupt.
	USART_IER_ABEOINTEN_ENABLE_END_OF_AUTO_B = 0x1
	// Position of ABTOINTEN field.
	USART_IER_ABTOINTEN_Pos = 0x9
	// Bit mask of ABTOINTEN field.
	USART_IER_ABTOINTEN_Msk = 0x200
	// Bit ABTOINTEN.
	USART_IER_ABTOINTEN = 0x200
	// Disable auto-baud time-out Interrupt.
	USART_IER_ABTOINTEN_DISABLE_AUTO_BAUD_TI = 0x0
	// Enable auto-baud time-out Interrupt.
	USART_IER_ABTOINTEN_ENABLE_AUTO_BAUD_TIM = 0x1
	// Position of RESERVED field.
	USART_IER_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART_IER_RESERVED_Msk = 0xfffffc00

	// IIR: Interrupt ID Register. Identifies which interrupt(s) are pending.
	// Position of INTSTATUS field.
	USART_IIR_INTSTATUS_Pos = 0x0
	// Bit mask of INTSTATUS field.
	USART_IIR_INTSTATUS_Msk = 0x1
	// Bit INTSTATUS.
	USART_IIR_INTSTATUS = 0x1
	// At least one interrupt is pending.
	USART_IIR_INTSTATUS_AT_LEAST_ONE_INTERRU = 0x0
	// No interrupt is pending.
	USART_IIR_INTSTATUS_NO_INTERRUPT_IS_PEND = 0x1
	// Position of INTID field.
	USART_IIR_INTID_Pos = 0x1
	// Bit mask of INTID field.
	USART_IIR_INTID_Msk = 0xe
	// 1 - Receive Line Status (RLS).
	USART_IIR_INTID_1_RECEIVE_LINE_S = 0x3
	// 2a - Receive Data Available (RDA).
	USART_IIR_INTID_2A__RECEIVE_DATA_AV = 0x2
	// 2b - Character Time-out Indicator (CTI).
	USART_IIR_INTID_2B__CHARACTER_TIME_ = 0x6
	// 3 - THRE Interrupt.
	USART_IIR_INTID_3_THRE_INTERRUPT = 0x1
	// 4 - Modem status
	USART_IIR_INTID_4_MODEM_STATUS = 0x0
	// Position of RESERVED field.
	USART_IIR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART_IIR_RESERVED_Msk = 0x30
	// Position of FIFOEN field.
	USART_IIR_FIFOEN_Pos = 0x6
	// Bit mask of FIFOEN field.
	USART_IIR_FIFOEN_Msk = 0xc0
	// Position of ABEOINT field.
	USART_IIR_ABEOINT_Pos = 0x8
	// Bit mask of ABEOINT field.
	USART_IIR_ABEOINT_Msk = 0x100
	// Bit ABEOINT.
	USART_IIR_ABEOINT = 0x100
	// Position of ABTOINT field.
	USART_IIR_ABTOINT_Pos = 0x9
	// Bit mask of ABTOINT field.
	USART_IIR_ABTOINT_Msk = 0x200
	// Bit ABTOINT.
	USART_IIR_ABTOINT = 0x200
	// Position of RESERVED field.
	USART_IIR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART_IIR_RESERVED_Msk = 0xfffffc00

	// FCR: FIFO Control Register. Controls USART FIFO usage and modes.
	// Position of FIFOEN field.
	USART_FCR_FIFOEN_Pos = 0x0
	// Bit mask of FIFOEN field.
	USART_FCR_FIFOEN_Msk = 0x1
	// Bit FIFOEN.
	USART_FCR_FIFOEN = 0x1
	// USART FIFOs are disabled. Must not be used in the application.
	USART_FCR_FIFOEN_DISABLED = 0x0
	// Active high enable for both USART Rx and TX FIFOs and FCR[7:1] access. This bit must be set for proper USART operation. Any transition on this bit will automatically clear the USART FIFOs.
	USART_FCR_FIFOEN_ENABLED = 0x1
	// Position of RXFIFORES field.
	USART_FCR_RXFIFORES_Pos = 0x1
	// Bit mask of RXFIFORES field.
	USART_FCR_RXFIFORES_Msk = 0x2
	// Bit RXFIFORES.
	USART_FCR_RXFIFORES = 0x2
	// No impact on either of USART FIFOs.
	USART_FCR_RXFIFORES_NO_IMPACT = 0x0
	// Writing a logic 1 to FCR[1] will clear all bytes in USART Rx FIFO, reset the pointer logic. This bit is self-clearing.
	USART_FCR_RXFIFORES_CLEAR = 0x1
	// Position of TXFIFORES field.
	USART_FCR_TXFIFORES_Pos = 0x2
	// Bit mask of TXFIFORES field.
	USART_FCR_TXFIFORES_Msk = 0x4
	// Bit TXFIFORES.
	USART_FCR_TXFIFORES = 0x4
	// No impact on either of USART FIFOs.
	USART_FCR_TXFIFORES_NO_IMPACT = 0x0
	// Writing a logic 1 to FCR[2] will clear all bytes in USART TX FIFO, reset the pointer logic. This bit is self-clearing.
	USART_FCR_TXFIFORES_CLEAR = 0x1
	// Position of RESERVED field.
	USART_FCR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART_FCR_RESERVED_Msk = 0x8
	// Bit RESERVED.
	USART_FCR_RESERVED = 0x8
	// Position of RESERVED field.
	USART_FCR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART_FCR_RESERVED_Msk = 0x30
	// Position of RXTL field.
	USART_FCR_RXTL_Pos = 0x6
	// Bit mask of RXTL field.
	USART_FCR_RXTL_Msk = 0xc0
	// Trigger level 0 (1 character or 0x01).
	USART_FCR_RXTL_TRIGGER_LEVEL_0_1_C = 0x0
	// Trigger level 1 (4 characters or 0x04).
	USART_FCR_RXTL_TRIGGER_LEVEL_1_4_C = 0x1
	// Trigger level 2 (8 characters or 0x08).
	USART_FCR_RXTL_TRIGGER_LEVEL_2_8_C = 0x2
	// Trigger level 3 (14 characters or 0x0E).
	USART_FCR_RXTL_TRIGGER_LEVEL_3_14_ = 0x3
	// Position of RESERVED field.
	USART_FCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_FCR_RESERVED_Msk = 0xffffff00

	// LCR: Line Control Register. Contains controls for frame formatting and break generation.
	// Position of WLS field.
	USART_LCR_WLS_Pos = 0x0
	// Bit mask of WLS field.
	USART_LCR_WLS_Msk = 0x3
	// 5-bit character length.
	USART_LCR_WLS_5_BIT_CHARACTER_LENG = 0x0
	// 6-bit character length.
	USART_LCR_WLS_6_BIT_CHARACTER_LENG = 0x1
	// 7-bit character length.
	USART_LCR_WLS_7_BIT_CHARACTER_LENG = 0x2
	// 8-bit character length.
	USART_LCR_WLS_8_BIT_CHARACTER_LENG = 0x3
	// Position of SBS field.
	USART_LCR_SBS_Pos = 0x2
	// Bit mask of SBS field.
	USART_LCR_SBS_Msk = 0x4
	// Bit SBS.
	USART_LCR_SBS = 0x4
	// 1 stop bit.
	USART_LCR_SBS_1_STOP_BIT_ = 0x0
	// 2 stop bits (1.5 if LCR[1:0]=00).
	USART_LCR_SBS_2_STOP_BITS_1_5_IF_ = 0x1
	// Position of PE field.
	USART_LCR_PE_Pos = 0x3
	// Bit mask of PE field.
	USART_LCR_PE_Msk = 0x8
	// Bit PE.
	USART_LCR_PE = 0x8
	// Disable parity generation and checking.
	USART_LCR_PE_DISABLE_PARITY_GENER = 0x0
	// Enable parity generation and checking.
	USART_LCR_PE_ENABLE_PARITY_GENERA = 0x1
	// Position of PS field.
	USART_LCR_PS_Pos = 0x4
	// Bit mask of PS field.
	USART_LCR_PS_Msk = 0x30
	// Odd parity. Number of 1s in the transmitted character and the attached parity bit will be odd.
	USART_LCR_PS_ODD_PARITY_NUMBER_O = 0x0
	// Even Parity. Number of 1s in the transmitted character and the attached parity bit will be even.
	USART_LCR_PS_EVEN_PARITY_NUMBER_ = 0x1
	// Forced 1 stick parity.
	USART_LCR_PS_FORCED_1_STICK_PARIT = 0x2
	// Forced 0 stick parity.
	USART_LCR_PS_FORCED_0_STICK_PARIT = 0x3
	// Position of BC field.
	USART_LCR_BC_Pos = 0x6
	// Bit mask of BC field.
	USART_LCR_BC_Msk = 0x40
	// Bit BC.
	USART_LCR_BC = 0x40
	// Disable break transmission.
	USART_LCR_BC_DISABLE_BREAK_TRANSM = 0x0
	// Enable break transmission. Output pin USART TXD is forced to logic 0 when LCR[6] is active high.
	USART_LCR_BC_ENABLE_BREAK_TRANSMI = 0x1
	// Position of DLAB field.
	USART_LCR_DLAB_Pos = 0x7
	// Bit mask of DLAB field.
	USART_LCR_DLAB_Msk = 0x80
	// Bit DLAB.
	USART_LCR_DLAB = 0x80
	// Disable access to Divisor Latches.
	USART_LCR_DLAB_DISABLE_ACCESS_TO_DI = 0x0
	// Enable access to Divisor Latches.
	USART_LCR_DLAB_ENABLE_ACCESS_TO_DIV = 0x1
	// Position of RESERVED field.
	USART_LCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_LCR_RESERVED_Msk = 0xffffff00

	// MCR: Modem Control Register.
	// Position of DTRCTRL field.
	USART_MCR_DTRCTRL_Pos = 0x0
	// Bit mask of DTRCTRL field.
	USART_MCR_DTRCTRL_Msk = 0x1
	// Bit DTRCTRL.
	USART_MCR_DTRCTRL = 0x1
	// Position of RTSCTRL field.
	USART_MCR_RTSCTRL_Pos = 0x1
	// Bit mask of RTSCTRL field.
	USART_MCR_RTSCTRL_Msk = 0x2
	// Bit RTSCTRL.
	USART_MCR_RTSCTRL = 0x2
	// Position of RESERVED field.
	USART_MCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	USART_MCR_RESERVED_Msk = 0xc
	// Position of LMS field.
	USART_MCR_LMS_Pos = 0x4
	// Bit mask of LMS field.
	USART_MCR_LMS_Msk = 0x10
	// Bit LMS.
	USART_MCR_LMS = 0x10
	// Disable modem loopback mode.
	USART_MCR_LMS_DISABLE_MODEM_LOOPBA = 0x0
	// Enable modem loopback mode.
	USART_MCR_LMS_ENABLE_MODEM_LOOPBAC = 0x1
	// Position of RESERVED field.
	USART_MCR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	USART_MCR_RESERVED_Msk = 0x20
	// Bit RESERVED.
	USART_MCR_RESERVED = 0x20
	// Position of RTSEN field.
	USART_MCR_RTSEN_Pos = 0x6
	// Bit mask of RTSEN field.
	USART_MCR_RTSEN_Msk = 0x40
	// Bit RTSEN.
	USART_MCR_RTSEN = 0x40
	// Disable auto-rts flow control.
	USART_MCR_RTSEN_DISABLE_AUTO_RTS_FLO = 0x0
	// Enable auto-rts flow control.
	USART_MCR_RTSEN_ENABLE_AUTO_RTS_FLOW = 0x1
	// Position of CTSEN field.
	USART_MCR_CTSEN_Pos = 0x7
	// Bit mask of CTSEN field.
	USART_MCR_CTSEN_Msk = 0x80
	// Bit CTSEN.
	USART_MCR_CTSEN = 0x80
	// Disable auto-cts flow control.
	USART_MCR_CTSEN_DISABLE_AUTO_CTS_FLO = 0x0
	// Enable auto-cts flow control.
	USART_MCR_CTSEN_ENABLE_AUTO_CTS_FLOW = 0x1
	// Position of RESERVED field.
	USART_MCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_MCR_RESERVED_Msk = 0xffffff00

	// LSR: Line Status Register. Contains flags for transmit and receive status, including line errors.
	// Position of RDR field.
	USART_LSR_RDR_Pos = 0x0
	// Bit mask of RDR field.
	USART_LSR_RDR_Msk = 0x1
	// Bit RDR.
	USART_LSR_RDR = 0x1
	// RBR is empty.
	USART_LSR_RDR_RBR_IS_EMPTY_ = 0x0
	// RBR contains valid data.
	USART_LSR_RDR_RBR_CONTAINS_VALID_D = 0x1
	// Position of OE field.
	USART_LSR_OE_Pos = 0x1
	// Bit mask of OE field.
	USART_LSR_OE_Msk = 0x2
	// Bit OE.
	USART_LSR_OE = 0x2
	// Overrun error status is inactive.
	USART_LSR_OE_INACTIVE = 0x0
	// Overrun error status is active.
	USART_LSR_OE_ACTIVE = 0x1
	// Position of PE field.
	USART_LSR_PE_Pos = 0x2
	// Bit mask of PE field.
	USART_LSR_PE_Msk = 0x4
	// Bit PE.
	USART_LSR_PE = 0x4
	// Parity error status is inactive.
	USART_LSR_PE_INACTIVE = 0x0
	// Parity error status is active.
	USART_LSR_PE_ACTIVE = 0x1
	// Position of FE field.
	USART_LSR_FE_Pos = 0x3
	// Bit mask of FE field.
	USART_LSR_FE_Msk = 0x8
	// Bit FE.
	USART_LSR_FE = 0x8
	// Framing error status is inactive.
	USART_LSR_FE_INACTIVE = 0x0
	// Framing error status is active.
	USART_LSR_FE_ACTIVE = 0x1
	// Position of BI field.
	USART_LSR_BI_Pos = 0x4
	// Bit mask of BI field.
	USART_LSR_BI_Msk = 0x10
	// Bit BI.
	USART_LSR_BI = 0x10
	// Break interrupt status is inactive.
	USART_LSR_BI_INACTIVE = 0x0
	// Break interrupt status is active.
	USART_LSR_BI_ACTIVE = 0x1
	// Position of THRE field.
	USART_LSR_THRE_Pos = 0x5
	// Bit mask of THRE field.
	USART_LSR_THRE_Msk = 0x20
	// Bit THRE.
	USART_LSR_THRE = 0x20
	// THR contains valid data.
	USART_LSR_THRE_THR_CONTAINS_VALID_D = 0x0
	// THR is empty.
	USART_LSR_THRE_THR_IS_EMPTY_ = 0x1
	// Position of TEMT field.
	USART_LSR_TEMT_Pos = 0x6
	// Bit mask of TEMT field.
	USART_LSR_TEMT_Msk = 0x40
	// Bit TEMT.
	USART_LSR_TEMT = 0x40
	// THR and/or the TSR contains valid data.
	USART_LSR_TEMT_VALID_D = 0x0
	// THR and the TSR are empty.
	USART_LSR_TEMT_EMPTY = 0x1
	// Position of RXFE field.
	USART_LSR_RXFE_Pos = 0x7
	// Bit mask of RXFE field.
	USART_LSR_RXFE_Msk = 0x80
	// Bit RXFE.
	USART_LSR_RXFE = 0x80
	// RBR contains no USART RX errors or FCR[0]=0.
	USART_LSR_RXFE_NO_ERROR = 0x0
	// USART RBR contains at least one USART RX error.
	USART_LSR_RXFE_ERRO = 0x1
	// Position of TXERR field.
	USART_LSR_TXERR_Pos = 0x8
	// Bit mask of TXERR field.
	USART_LSR_TXERR_Msk = 0x100
	// Bit TXERR.
	USART_LSR_TXERR = 0x100
	// Position of RESERVED field.
	USART_LSR_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART_LSR_RESERVED_Msk = 0xfffffe00

	// MSR: Modem Status Register.
	// Position of DCTS field.
	USART_MSR_DCTS_Pos = 0x0
	// Bit mask of DCTS field.
	USART_MSR_DCTS_Msk = 0x1
	// Bit DCTS.
	USART_MSR_DCTS = 0x1
	// No change detected on modem input, CTS.
	USART_MSR_DCTS_NO_CHANGE_DETECTED_O = 0x0
	// State change detected on modem input, CTS.
	USART_MSR_DCTS_STATE_CHANGE_DETECTE = 0x1
	// Position of DDSR field.
	USART_MSR_DDSR_Pos = 0x1
	// Bit mask of DDSR field.
	USART_MSR_DDSR_Msk = 0x2
	// Bit DDSR.
	USART_MSR_DDSR = 0x2
	// No change detected on modem input, DSR.
	USART_MSR_DDSR_NO_CHANGE_DETECTED_O = 0x0
	// State change detected on modem input, DSR.
	USART_MSR_DDSR_STATE_CHANGE_DETECTE = 0x1
	// Position of TERI field.
	USART_MSR_TERI_Pos = 0x2
	// Bit mask of TERI field.
	USART_MSR_TERI_Msk = 0x4
	// Bit TERI.
	USART_MSR_TERI = 0x4
	// No change detected on modem input, RI.
	USART_MSR_TERI_NO_CHANGE_DETECTED_O = 0x0
	// Low-to-high transition detected on RI.
	USART_MSR_TERI_LOW_TO_HIGH_TRANSITI = 0x1
	// Position of DDCD field.
	USART_MSR_DDCD_Pos = 0x3
	// Bit mask of DDCD field.
	USART_MSR_DDCD_Msk = 0x8
	// Bit DDCD.
	USART_MSR_DDCD = 0x8
	// No change detected on modem input, DCD.
	USART_MSR_DDCD_NO_CHANGE_DETECTED_O = 0x0
	// State change detected on modem input, DCD.
	USART_MSR_DDCD_STATE_CHANGE_DETECTE = 0x1
	// Position of CTS field.
	USART_MSR_CTS_Pos = 0x4
	// Bit mask of CTS field.
	USART_MSR_CTS_Msk = 0x10
	// Bit CTS.
	USART_MSR_CTS = 0x10
	// Position of DSR field.
	USART_MSR_DSR_Pos = 0x5
	// Bit mask of DSR field.
	USART_MSR_DSR_Msk = 0x20
	// Bit DSR.
	USART_MSR_DSR = 0x20
	// Position of RI field.
	USART_MSR_RI_Pos = 0x6
	// Bit mask of RI field.
	USART_MSR_RI_Msk = 0x40
	// Bit RI.
	USART_MSR_RI = 0x40
	// Position of DCD field.
	USART_MSR_DCD_Pos = 0x7
	// Bit mask of DCD field.
	USART_MSR_DCD_Msk = 0x80
	// Bit DCD.
	USART_MSR_DCD = 0x80
	// Position of RESERVED field.
	USART_MSR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_MSR_RESERVED_Msk = 0xffffff00

	// SCR: Scratch Pad Register. Eight-bit temporary storage for software.
	// Position of PAD field.
	USART_SCR_PAD_Pos = 0x0
	// Bit mask of PAD field.
	USART_SCR_PAD_Msk = 0xff
	// Position of RESERVED field.
	USART_SCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_SCR_RESERVED_Msk = 0xffffff00

	// ACR: Auto-baud Control Register. Contains controls for the auto-baud feature.
	// Position of START field.
	USART_ACR_START_Pos = 0x0
	// Bit mask of START field.
	USART_ACR_START_Msk = 0x1
	// Bit START.
	USART_ACR_START = 0x1
	// Auto-baud stop (auto-baud is not running).
	USART_ACR_START_AUTO_BAUD_STOP_AUTO = 0x0
	// Auto-baud start (auto-baud is running). Auto-baud run bit. This bit is automatically cleared after auto-baud completion.
	USART_ACR_START_AUTO_BAUD_START_AUT = 0x1
	// Position of MODE field.
	USART_ACR_MODE_Pos = 0x1
	// Bit mask of MODE field.
	USART_ACR_MODE_Msk = 0x2
	// Bit MODE.
	USART_ACR_MODE = 0x2
	// Mode 0.
	USART_ACR_MODE_MODE_0_ = 0x0
	// Mode 1.
	USART_ACR_MODE_MODE_1_ = 0x1
	// Position of AUTORESTART field.
	USART_ACR_AUTORESTART_Pos = 0x2
	// Bit mask of AUTORESTART field.
	USART_ACR_AUTORESTART_Msk = 0x4
	// Bit AUTORESTART.
	USART_ACR_AUTORESTART = 0x4
	// No restart
	USART_ACR_AUTORESTART_NO_RESTART = 0x0
	// Restart in case of time-out (counter restarts at next USART Rx falling edge)
	USART_ACR_AUTORESTART_RESTART_IN_CASE_OF_T = 0x1
	// Position of RESERVED field.
	USART_ACR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART_ACR_RESERVED_Msk = 0xf8
	// Position of ABEOINTCLR field.
	USART_ACR_ABEOINTCLR_Pos = 0x8
	// Bit mask of ABEOINTCLR field.
	USART_ACR_ABEOINTCLR_Msk = 0x100
	// Bit ABEOINTCLR.
	USART_ACR_ABEOINTCLR = 0x100
	// Writing a 0 has no impact.
	USART_ACR_ABEOINTCLR_NO_IMPACT = 0x0
	// Writing a 1 will clear the corresponding interrupt in the IIR.
	USART_ACR_ABEOINTCLR_CLEAR = 0x1
	// Position of ABTOINTCLR field.
	USART_ACR_ABTOINTCLR_Pos = 0x9
	// Bit mask of ABTOINTCLR field.
	USART_ACR_ABTOINTCLR_Msk = 0x200
	// Bit ABTOINTCLR.
	USART_ACR_ABTOINTCLR = 0x200
	// Writing a 0 has no impact.
	USART_ACR_ABTOINTCLR_NO_IMPACT = 0x0
	// Writing a 1 will clear the corresponding interrupt in the IIR.
	USART_ACR_ABTOINTCLR_CLEAR = 0x1
	// Position of RESERVED field.
	USART_ACR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART_ACR_RESERVED_Msk = 0xfffffc00

	// ICR: IrDA Control Register. Enables and configures the IrDA (remote control) mode.
	// Position of IRDAEN field.
	USART_ICR_IRDAEN_Pos = 0x0
	// Bit mask of IRDAEN field.
	USART_ICR_IRDAEN_Msk = 0x1
	// Bit IRDAEN.
	USART_ICR_IRDAEN = 0x1
	// IrDA mode is disabled, USARTn acts as a standard USART.
	USART_ICR_IRDAEN_IRDA_MODE_IS_DISABLE = 0x0
	// IrDA mode is enabled.
	USART_ICR_IRDAEN_IRDA_MODE_IS_ENABLED = 0x1
	// Position of IRDAINV field.
	USART_ICR_IRDAINV_Pos = 0x1
	// Bit mask of IRDAINV field.
	USART_ICR_IRDAINV_Msk = 0x2
	// Bit IRDAINV.
	USART_ICR_IRDAINV = 0x2
	// The serial input is not inverted.
	USART_ICR_IRDAINV_INVERTED = 0x0
	// The serial input is inverted. This has no effect on the serial output.
	USART_ICR_IRDAINV_NOT_INVERTED = 0x1
	// Position of FIXPULSEEN field.
	USART_ICR_FIXPULSEEN_Pos = 0x2
	// Bit mask of FIXPULSEEN field.
	USART_ICR_FIXPULSEEN_Msk = 0x4
	// Bit FIXPULSEEN.
	USART_ICR_FIXPULSEEN = 0x4
	// IrDA fixed pulse width mode disabled.
	USART_ICR_FIXPULSEEN_DISABLED = 0x0
	// IrDA fixed pulse width mode enabled.
	USART_ICR_FIXPULSEEN_ENABLED = 0x1
	// Position of PULSEDIV field.
	USART_ICR_PULSEDIV_Pos = 0x3
	// Bit mask of PULSEDIV field.
	USART_ICR_PULSEDIV_Msk = 0x38
	// 3 / (16 x baud rate)
	USART_ICR_PULSEDIV_3_DIV_16_X_BAUD_RATE = 0x0
	// 2 x TPCLK
	USART_ICR_PULSEDIV_2_X_TPCLK = 0x1
	// 4 x TPCLK
	USART_ICR_PULSEDIV_4_X_TPCLK = 0x2
	// 8 x TPCLK
	USART_ICR_PULSEDIV_8_X_TPCLK = 0x3
	// 16 x TPCLK
	USART_ICR_PULSEDIV_16_X_TPCLK = 0x4
	// 32 x TPCLK
	USART_ICR_PULSEDIV_32_X_TPCLK = 0x5
	// 64 x TPCLK
	USART_ICR_PULSEDIV_64_X_TPCLK = 0x6
	// 128 x TPCLK
	USART_ICR_PULSEDIV_128_X_TPCLK = 0x7
	// Position of RESERVED field.
	USART_ICR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USART_ICR_RESERVED_Msk = 0xffffffc0

	// FDR: Fractional Divider Register. Generates a clock input for the baud rate divider.
	// Position of DIVADDVAL field.
	USART_FDR_DIVADDVAL_Pos = 0x0
	// Bit mask of DIVADDVAL field.
	USART_FDR_DIVADDVAL_Msk = 0xf
	// Position of MULVAL field.
	USART_FDR_MULVAL_Pos = 0x4
	// Bit mask of MULVAL field.
	USART_FDR_MULVAL_Msk = 0xf0
	// Position of RESERVED field.
	USART_FDR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_FDR_RESERVED_Msk = 0xffffff00

	// OSR: Oversampling Register. Controls the degree of oversampling during each bit time.
	// Position of RESERVED field.
	USART_OSR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USART_OSR_RESERVED_Msk = 0x1
	// Bit RESERVED.
	USART_OSR_RESERVED = 0x1
	// Position of OSFRAC field.
	USART_OSR_OSFRAC_Pos = 0x1
	// Bit mask of OSFRAC field.
	USART_OSR_OSFRAC_Msk = 0xe
	// Position of OSINT field.
	USART_OSR_OSINT_Pos = 0x4
	// Bit mask of OSINT field.
	USART_OSR_OSINT_Msk = 0xf0
	// Position of FDINT field.
	USART_OSR_FDINT_Pos = 0x8
	// Bit mask of FDINT field.
	USART_OSR_FDINT_Msk = 0x7f00
	// Position of RESERVED field.
	USART_OSR_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	USART_OSR_RESERVED_Msk = 0xffff8000

	// TER: Transmit Enable Register. Turns off USART transmitter for use with software flow control.
	// Position of RESERVED field.
	USART_TER_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USART_TER_RESERVED_Msk = 0x7f
	// Position of TXEN field.
	USART_TER_TXEN_Pos = 0x7
	// Bit mask of TXEN field.
	USART_TER_TXEN_Msk = 0x80
	// Bit TXEN.
	USART_TER_TXEN = 0x80
	// Position of RESERVED field.
	USART_TER_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_TER_RESERVED_Msk = 0xffffff00

	// HDEN: Half duplex enable register.
	// Position of HDEN field.
	USART_HDEN_HDEN_Pos = 0x0
	// Bit mask of HDEN field.
	USART_HDEN_HDEN_Msk = 0x1
	// Bit HDEN.
	USART_HDEN_HDEN = 0x1
	// Disable half-duplex mode.
	USART_HDEN_HDEN_DISABLE_HALF_DUPLEX_ = 0x0
	// Enable half-duplex mode.
	USART_HDEN_HDEN_ENABLE_HALF_DUPLEX_M = 0x1
	// Position of RESERVED field.
	USART_HDEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART_HDEN_RESERVED_Msk = 0xfffffffe

	// SCICTRL: Smart Card Interface Control register. Enables and configures the Smart Card Interface feature.
	// Position of SCIEN field.
	USART_SCICTRL_SCIEN_Pos = 0x0
	// Bit mask of SCIEN field.
	USART_SCICTRL_SCIEN_Msk = 0x1
	// Bit SCIEN.
	USART_SCICTRL_SCIEN = 0x1
	// Smart card interface disabled.
	USART_SCICTRL_SCIEN_SMART_CARD_INTERFACE = 0x0
	// Asynchronous half duplex smart card interface is enabled.
	USART_SCICTRL_SCIEN_ASYNCHRONOUS_HALF_DU = 0x1
	// Position of NACKDIS field.
	USART_SCICTRL_NACKDIS_Pos = 0x1
	// Bit mask of NACKDIS field.
	USART_SCICTRL_NACKDIS_Msk = 0x2
	// Bit NACKDIS.
	USART_SCICTRL_NACKDIS = 0x2
	// A NACK response is enabled.
	USART_SCICTRL_NACKDIS_ENABLED = 0x0
	// A NACK response is inhibited.
	USART_SCICTRL_NACKDIS_DISABLED = 0x1
	// Position of PROTSEL field.
	USART_SCICTRL_PROTSEL_Pos = 0x2
	// Bit mask of PROTSEL field.
	USART_SCICTRL_PROTSEL_Msk = 0x4
	// Bit PROTSEL.
	USART_SCICTRL_PROTSEL = 0x4
	// T = 0
	USART_SCICTRL_PROTSEL_T_EQ_0 = 0x0
	// T = 1
	USART_SCICTRL_PROTSEL_T_EQ_1 = 0x1
	// Position of RESERVED field.
	USART_SCICTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART_SCICTRL_RESERVED_Msk = 0x18
	// Position of TXRETRY field.
	USART_SCICTRL_TXRETRY_Pos = 0x5
	// Bit mask of TXRETRY field.
	USART_SCICTRL_TXRETRY_Msk = 0xe0
	// Position of XTRAGUARD field.
	USART_SCICTRL_XTRAGUARD_Pos = 0x8
	// Bit mask of XTRAGUARD field.
	USART_SCICTRL_XTRAGUARD_Msk = 0xff00
	// Position of RESERVED field.
	USART_SCICTRL_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART_SCICTRL_RESERVED_Msk = 0xffff0000

	// RS485CTRL: RS-485/EIA-485 Control. Contains controls to configure various aspects of RS-485/EIA-485 modes.
	// Position of NMMEN field.
	USART_RS485CTRL_NMMEN_Pos = 0x0
	// Bit mask of NMMEN field.
	USART_RS485CTRL_NMMEN_Msk = 0x1
	// Bit NMMEN.
	USART_RS485CTRL_NMMEN = 0x1
	// RS-485/EIA-485 Normal Multidrop Mode (NMM) is disabled.
	USART_RS485CTRL_NMMEN_DISABLED = 0x0
	// RS-485/EIA-485 Normal Multidrop Mode (NMM) is enabled. In this mode, an address is detected when a received byte causes the USART to set the parity error and generate an interrupt.
	USART_RS485CTRL_NMMEN_ENABLED = 0x1
	// Position of RXDIS field.
	USART_RS485CTRL_RXDIS_Pos = 0x1
	// Bit mask of RXDIS field.
	USART_RS485CTRL_RXDIS_Msk = 0x2
	// Bit RXDIS.
	USART_RS485CTRL_RXDIS = 0x2
	// The receiver is enabled.
	USART_RS485CTRL_RXDIS_THE_RECEIVER_IS_ENAB = 0x0
	// The receiver is disabled.
	USART_RS485CTRL_RXDIS_THE_RECEIVER_IS_DISA = 0x1
	// Position of AADEN field.
	USART_RS485CTRL_AADEN_Pos = 0x2
	// Bit mask of AADEN field.
	USART_RS485CTRL_AADEN_Msk = 0x4
	// Bit AADEN.
	USART_RS485CTRL_AADEN = 0x4
	// Position of SEL field.
	USART_RS485CTRL_SEL_Pos = 0x3
	// Bit mask of SEL field.
	USART_RS485CTRL_SEL_Msk = 0x8
	// Bit SEL.
	USART_RS485CTRL_SEL = 0x8
	// If direction control is enabled (bit DCTRL = 1), pin RTS is used for direction control.
	USART_RS485CTRL_SEL_RTS = 0x0
	// If direction control is enabled (bit DCTRL = 1), pin DTR is used for direction control.
	USART_RS485CTRL_SEL_DTR = 0x1
	// Position of DCTRL field.
	USART_RS485CTRL_DCTRL_Pos = 0x4
	// Bit mask of DCTRL field.
	USART_RS485CTRL_DCTRL_Msk = 0x10
	// Bit DCTRL.
	USART_RS485CTRL_DCTRL = 0x10
	// Disable Auto Direction Control.
	USART_RS485CTRL_DCTRL_DISABLE_AUTO_DIRECTI = 0x0
	// Enable Auto Direction Control.
	USART_RS485CTRL_DCTRL_ENABLE_AUTO_DIRECTIO = 0x1
	// Position of OINV field.
	USART_RS485CTRL_OINV_Pos = 0x5
	// Bit mask of OINV field.
	USART_RS485CTRL_OINV_Msk = 0x20
	// Bit OINV.
	USART_RS485CTRL_OINV = 0x20
	// The direction control pin will be driven to logic 0 when the transmitter has data to be sent. It will be driven to logic 1 after the last bit of data has been transmitted.
	USART_RS485CTRL_OINV_LOW = 0x0
	// The direction control pin will be driven to logic 1 when the transmitter has data to be sent. It will be driven to logic 0 after the last bit of data has been transmitted.
	USART_RS485CTRL_OINV_HIGH = 0x1
	// Position of RESERVED field.
	USART_RS485CTRL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USART_RS485CTRL_RESERVED_Msk = 0xffffffc0

	// RS485ADRMATCH: RS-485/EIA-485 address match. Contains the address match value for RS-485/EIA-485 mode.
	// Position of ADRMATCH field.
	USART_RS485ADRMATCH_ADRMATCH_Pos = 0x0
	// Bit mask of ADRMATCH field.
	USART_RS485ADRMATCH_ADRMATCH_Msk = 0xff
	// Position of RESERVED field.
	USART_RS485ADRMATCH_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_RS485ADRMATCH_RESERVED_Msk = 0xffffff00

	// RS485DLY: RS-485/EIA-485 direction control delay.
	// Position of DLY field.
	USART_RS485DLY_DLY_Pos = 0x0
	// Bit mask of DLY field.
	USART_RS485DLY_DLY_Msk = 0xff
	// Position of RESERVED field.
	USART_RS485DLY_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_RS485DLY_RESERVED_Msk = 0xffffff00

	// SYNCCTRL: Synchronous mode control register.
	// Position of SYNC field.
	USART_SYNCCTRL_SYNC_Pos = 0x0
	// Bit mask of SYNC field.
	USART_SYNCCTRL_SYNC_Msk = 0x1
	// Bit SYNC.
	USART_SYNCCTRL_SYNC = 0x1
	// Disabled
	USART_SYNCCTRL_SYNC_DISABLED = 0x0
	// Enabled
	USART_SYNCCTRL_SYNC_ENABLED = 0x1
	// Position of CSRC field.
	USART_SYNCCTRL_CSRC_Pos = 0x1
	// Bit mask of CSRC field.
	USART_SYNCCTRL_CSRC_Msk = 0x2
	// Bit CSRC.
	USART_SYNCCTRL_CSRC = 0x2
	// Synchronous slave mode (SCLK in)
	USART_SYNCCTRL_CSRC_SYNCHRONOUS_SLAVE_MO = 0x0
	// Synchronous master mode (SCLK out)
	USART_SYNCCTRL_CSRC_SYNCHRONOUS_MASTER_M = 0x1
	// Position of FES field.
	USART_SYNCCTRL_FES_Pos = 0x2
	// Bit mask of FES field.
	USART_SYNCCTRL_FES_Msk = 0x4
	// Bit FES.
	USART_SYNCCTRL_FES = 0x4
	// RxD is sampled on the rising edge of SCLK
	USART_SYNCCTRL_FES_RISING = 0x0
	// RxD is sampled on the falling edge of SCLK
	USART_SYNCCTRL_FES_FALLING = 0x1
	// Position of TSBYPASS field.
	USART_SYNCCTRL_TSBYPASS_Pos = 0x3
	// Bit mask of TSBYPASS field.
	USART_SYNCCTRL_TSBYPASS_Msk = 0x8
	// Bit TSBYPASS.
	USART_SYNCCTRL_TSBYPASS = 0x8
	// The input clock is synchronized prior to being used in clock edge detection logic
	USART_SYNCCTRL_TSBYPASS_SYNC = 0x0
	// The input clock is not synchronized prior to being used in clock edge detection logic. This allows for a high er input clock rate at the expense of potential metastability.
	USART_SYNCCTRL_TSBYPASS_NOSYNC = 0x1
	// Position of CSCEN field.
	USART_SYNCCTRL_CSCEN_Pos = 0x4
	// Bit mask of CSCEN field.
	USART_SYNCCTRL_CSCEN_Msk = 0x10
	// Bit CSCEN.
	USART_SYNCCTRL_CSCEN = 0x10
	// SCLK cycles only when characters are being sent on TxD
	USART_SYNCCTRL_CSCEN_SCLK_CYCLES_ONLY_WHE = 0x0
	// SCLK runs continuously (characters can be received on RxD independently from transmission on TxD)
	USART_SYNCCTRL_CSCEN_SCLK_RUNS_CONTINUOUS = 0x1
	// Position of SSDIS field.
	USART_SYNCCTRL_SSDIS_Pos = 0x5
	// Bit mask of SSDIS field.
	USART_SYNCCTRL_SSDIS_Msk = 0x20
	// Bit SSDIS.
	USART_SYNCCTRL_SSDIS = 0x20
	// Send start and stop bits as in other modes.
	USART_SYNCCTRL_SSDIS_SEND_START_AND_STOP_ = 0x0
	// Do not send start/stop bits.
	USART_SYNCCTRL_SSDIS_DO_NOT_SEND_STARTSTOP = 0x1
	// Position of CCCLR field.
	USART_SYNCCTRL_CCCLR_Pos = 0x6
	// Bit mask of CCCLR field.
	USART_SYNCCTRL_CCCLR_Msk = 0x40
	// Bit CCCLR.
	USART_SYNCCTRL_CCCLR = 0x40
	// CSCEN is under software control.
	USART_SYNCCTRL_CCCLR_CSCEN_IS_UNDER_SOFTW = 0x0
	// Hardware clears CSCEN after each character is received.
	USART_SYNCCTRL_CCCLR_HARDWARE_CLEARS_CSCE = 0x1
	// Position of RESERVED field.
	USART_SYNCCTRL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART_SYNCCTRL_RESERVED_Msk = 0xffffff80
)

// Bitfields for CT16B0: 16-bit counter/timers CT16B0
const (
	// IR: Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending.
	// Position of MR0INT field.
	CT16B0_IR_MR0INT_Pos = 0x0
	// Bit mask of MR0INT field.
	CT16B0_IR_MR0INT_Msk = 0x1
	// Bit MR0INT.
	CT16B0_IR_MR0INT = 0x1
	// Position of MR1INT field.
	CT16B0_IR_MR1INT_Pos = 0x1
	// Bit mask of MR1INT field.
	CT16B0_IR_MR1INT_Msk = 0x2
	// Bit MR1INT.
	CT16B0_IR_MR1INT = 0x2
	// Position of MR2INT field.
	CT16B0_IR_MR2INT_Pos = 0x2
	// Bit mask of MR2INT field.
	CT16B0_IR_MR2INT_Msk = 0x4
	// Bit MR2INT.
	CT16B0_IR_MR2INT = 0x4
	// Position of MR3INT field.
	CT16B0_IR_MR3INT_Pos = 0x3
	// Bit mask of MR3INT field.
	CT16B0_IR_MR3INT_Msk = 0x8
	// Bit MR3INT.
	CT16B0_IR_MR3INT = 0x8
	// Position of CR0INT field.
	CT16B0_IR_CR0INT_Pos = 0x4
	// Bit mask of CR0INT field.
	CT16B0_IR_CR0INT_Msk = 0x10
	// Bit CR0INT.
	CT16B0_IR_CR0INT = 0x10
	// Position of RESERVED field.
	CT16B0_IR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	CT16B0_IR_RESERVED_Msk = 0x20
	// Bit RESERVED.
	CT16B0_IR_RESERVED = 0x20
	// Position of CR1INT field.
	CT16B0_IR_CR1INT_Pos = 0x6
	// Bit mask of CR1INT field.
	CT16B0_IR_CR1INT_Msk = 0x40
	// Bit CR1INT.
	CT16B0_IR_CR1INT = 0x40
	// Position of RESERVED field.
	CT16B0_IR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	CT16B0_IR_RESERVED_Msk = 0xffffff80

	// TCR: Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
	// Position of CEN field.
	CT16B0_TCR_CEN_Pos = 0x0
	// Bit mask of CEN field.
	CT16B0_TCR_CEN_Msk = 0x1
	// Bit CEN.
	CT16B0_TCR_CEN = 0x1
	// The counters are disabled.
	CT16B0_TCR_CEN_THE_COUNTERS_ARE_DIS = 0x0
	// The Timer Counter and Prescale Counter are enabled for counting.
	CT16B0_TCR_CEN_THE_TIMER_COUNTER_AN = 0x1
	// Position of CRST field.
	CT16B0_TCR_CRST_Pos = 0x1
	// Bit mask of CRST field.
	CT16B0_TCR_CRST_Msk = 0x2
	// Bit CRST.
	CT16B0_TCR_CRST = 0x2
	// Do nothing.
	CT16B0_TCR_CRST_DO_NOTHING_ = 0x0
	// The Timer Counter and the Prescale Counter are synchronously reset on the next positive edge of PCLK. The counters remain reset until TCR[1] is returned to zero.
	CT16B0_TCR_CRST_THE_TIMER_COUNTER_AN = 0x1
	// Position of RESERVED field.
	CT16B0_TCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	CT16B0_TCR_RESERVED_Msk = 0xfffffffc

	// TC: Timer Counter. The 16-bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
	// Position of TC field.
	CT16B0_TC_TC_Pos = 0x0
	// Bit mask of TC field.
	CT16B0_TC_TC_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_TC_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_TC_RESERVED_Msk = 0xffff0000

	// PR: Prescale Register. When the Prescale Counter (below) is equal to this value, the next clock increments the TC and clears the PC.
	// Position of PCVAL field.
	CT16B0_PR_PCVAL_Pos = 0x0
	// Bit mask of PCVAL field.
	CT16B0_PR_PCVAL_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_PR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_PR_RESERVED_Msk = 0xffff0000

	// PC: Prescale Counter. The 16-bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
	// Position of PC field.
	CT16B0_PC_PC_Pos = 0x0
	// Bit mask of PC field.
	CT16B0_PC_PC_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_PC_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_PC_RESERVED_Msk = 0xffff0000

	// MCR: Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
	// Position of MR0I field.
	CT16B0_MCR_MR0I_Pos = 0x0
	// Bit mask of MR0I field.
	CT16B0_MCR_MR0I_Msk = 0x1
	// Bit MR0I.
	CT16B0_MCR_MR0I = 0x1
	// Enabled
	CT16B0_MCR_MR0I_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR0I_DISABLED = 0x0
	// Position of MR0R field.
	CT16B0_MCR_MR0R_Pos = 0x1
	// Bit mask of MR0R field.
	CT16B0_MCR_MR0R_Msk = 0x2
	// Bit MR0R.
	CT16B0_MCR_MR0R = 0x2
	// Enabled
	CT16B0_MCR_MR0R_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR0R_DISABLED = 0x0
	// Position of MR0S field.
	CT16B0_MCR_MR0S_Pos = 0x2
	// Bit mask of MR0S field.
	CT16B0_MCR_MR0S_Msk = 0x4
	// Bit MR0S.
	CT16B0_MCR_MR0S = 0x4
	// Enabled
	CT16B0_MCR_MR0S_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR0S_DISABLED = 0x0
	// Position of MR1I field.
	CT16B0_MCR_MR1I_Pos = 0x3
	// Bit mask of MR1I field.
	CT16B0_MCR_MR1I_Msk = 0x8
	// Bit MR1I.
	CT16B0_MCR_MR1I = 0x8
	// Enabled
	CT16B0_MCR_MR1I_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR1I_DISABLED = 0x0
	// Position of MR1R field.
	CT16B0_MCR_MR1R_Pos = 0x4
	// Bit mask of MR1R field.
	CT16B0_MCR_MR1R_Msk = 0x10
	// Bit MR1R.
	CT16B0_MCR_MR1R = 0x10
	// Enabled
	CT16B0_MCR_MR1R_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR1R_DISABLED = 0x0
	// Position of MR1S field.
	CT16B0_MCR_MR1S_Pos = 0x5
	// Bit mask of MR1S field.
	CT16B0_MCR_MR1S_Msk = 0x20
	// Bit MR1S.
	CT16B0_MCR_MR1S = 0x20
	// Enabled
	CT16B0_MCR_MR1S_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR1S_DISABLED = 0x0
	// Position of MR2I field.
	CT16B0_MCR_MR2I_Pos = 0x6
	// Bit mask of MR2I field.
	CT16B0_MCR_MR2I_Msk = 0x40
	// Bit MR2I.
	CT16B0_MCR_MR2I = 0x40
	// Enabled
	CT16B0_MCR_MR2I_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR2I_DISABLED = 0x0
	// Position of MR2R field.
	CT16B0_MCR_MR2R_Pos = 0x7
	// Bit mask of MR2R field.
	CT16B0_MCR_MR2R_Msk = 0x80
	// Bit MR2R.
	CT16B0_MCR_MR2R = 0x80
	// Enabled
	CT16B0_MCR_MR2R_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR2R_DISABLED = 0x0
	// Position of MR2S field.
	CT16B0_MCR_MR2S_Pos = 0x8
	// Bit mask of MR2S field.
	CT16B0_MCR_MR2S_Msk = 0x100
	// Bit MR2S.
	CT16B0_MCR_MR2S = 0x100
	// Enabled
	CT16B0_MCR_MR2S_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR2S_DISABLED = 0x0
	// Position of MR3I field.
	CT16B0_MCR_MR3I_Pos = 0x9
	// Bit mask of MR3I field.
	CT16B0_MCR_MR3I_Msk = 0x200
	// Bit MR3I.
	CT16B0_MCR_MR3I = 0x200
	// Enabled
	CT16B0_MCR_MR3I_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR3I_DISABLED = 0x0
	// Position of MR3R field.
	CT16B0_MCR_MR3R_Pos = 0xa
	// Bit mask of MR3R field.
	CT16B0_MCR_MR3R_Msk = 0x400
	// Bit MR3R.
	CT16B0_MCR_MR3R = 0x400
	// Enabled
	CT16B0_MCR_MR3R_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR3R_DISABLED = 0x0
	// Position of MR3S field.
	CT16B0_MCR_MR3S_Pos = 0xb
	// Bit mask of MR3S field.
	CT16B0_MCR_MR3S_Msk = 0x800
	// Bit MR3S.
	CT16B0_MCR_MR3S = 0x800
	// Enabled
	CT16B0_MCR_MR3S_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR3S_DISABLED = 0x0
	// Position of RESERVED field.
	CT16B0_MCR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT16B0_MCR_RESERVED_Msk = 0xfffff000

	// MR0: Match Register 0. MR0 can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR0 matches the TC.
	// Position of MATCH field.
	CT16B0_MR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	CT16B0_MR_MATCH_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_MR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_MR_RESERVED_Msk = 0xffff0000

	// CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place.
	// Position of CAP0RE field.
	CT16B0_CCR_CAP0RE_Pos = 0x0
	// Bit mask of CAP0RE field.
	CT16B0_CCR_CAP0RE_Msk = 0x1
	// Bit CAP0RE.
	CT16B0_CCR_CAP0RE = 0x1
	// Enabled.
	CT16B0_CCR_CAP0RE_ENABLED_ = 0x1
	// Disabled.
	CT16B0_CCR_CAP0RE_DISABLED_ = 0x0
	// Position of CAP0FE field.
	CT16B0_CCR_CAP0FE_Pos = 0x1
	// Bit mask of CAP0FE field.
	CT16B0_CCR_CAP0FE_Msk = 0x2
	// Bit CAP0FE.
	CT16B0_CCR_CAP0FE = 0x2
	// Enabled.
	CT16B0_CCR_CAP0FE_ENABLED_ = 0x1
	// Disabled.
	CT16B0_CCR_CAP0FE_DISABLED_ = 0x0
	// Position of CAP0I field.
	CT16B0_CCR_CAP0I_Pos = 0x2
	// Bit mask of CAP0I field.
	CT16B0_CCR_CAP0I_Msk = 0x4
	// Bit CAP0I.
	CT16B0_CCR_CAP0I = 0x4
	// Enabled.
	CT16B0_CCR_CAP0I_ENABLED_ = 0x1
	// Disabled.
	CT16B0_CCR_CAP0I_DISABLED_ = 0x0
	// Position of RESERVED field.
	CT16B0_CCR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CT16B0_CCR_RESERVED_Msk = 0x8
	// Bit RESERVED.
	CT16B0_CCR_RESERVED = 0x8
	// Position of RESERVED field.
	CT16B0_CCR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	CT16B0_CCR_RESERVED_Msk = 0x10
	// Bit RESERVED.
	CT16B0_CCR_RESERVED = 0x10
	// Position of RESERVED field.
	CT16B0_CCR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	CT16B0_CCR_RESERVED_Msk = 0x20
	// Bit RESERVED.
	CT16B0_CCR_RESERVED = 0x20
	// Position of CAP1RE field.
	CT16B0_CCR_CAP1RE_Pos = 0x6
	// Bit mask of CAP1RE field.
	CT16B0_CCR_CAP1RE_Msk = 0x40
	// Bit CAP1RE.
	CT16B0_CCR_CAP1RE = 0x40
	// Enabled.
	CT16B0_CCR_CAP1RE_ENABLED_ = 0x1
	// Disabled.
	CT16B0_CCR_CAP1RE_DISABLED_ = 0x0
	// Position of CAP1FE field.
	CT16B0_CCR_CAP1FE_Pos = 0x7
	// Bit mask of CAP1FE field.
	CT16B0_CCR_CAP1FE_Msk = 0x80
	// Bit CAP1FE.
	CT16B0_CCR_CAP1FE = 0x80
	// Enabled.
	CT16B0_CCR_CAP1FE_ENABLED_ = 0x1
	// Disabled.
	CT16B0_CCR_CAP1FE_DISABLED_ = 0x0
	// Position of CAP1I field.
	CT16B0_CCR_CAP1I_Pos = 0x8
	// Bit mask of CAP1I field.
	CT16B0_CCR_CAP1I_Msk = 0x100
	// Bit CAP1I.
	CT16B0_CCR_CAP1I = 0x100
	// Enabled.
	CT16B0_CCR_CAP1I_ENABLED_ = 0x1
	// Disabled.
	CT16B0_CCR_CAP1I_DISABLED_ = 0x0
	// Position of RESERVED field.
	CT16B0_CCR_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	CT16B0_CCR_RESERVED_Msk = 0xfffffe00

	// CR0: Capture Register 0. CR0 is loaded with the value of TC when there is an event on the CT16B0_CAP0 input.
	// Position of CAP field.
	CT16B0_CR0_CAP_Pos = 0x0
	// Bit mask of CAP field.
	CT16B0_CR0_CAP_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_CR0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_CR0_RESERVED_Msk = 0xffff0000

	// CR1: Capture Register 1. CR1 is loaded with the value of TC when there is an event on the CT16B0_CAP1 input.
	// Position of CAP field.
	CT16B0_CR1_CAP_Pos = 0x0
	// Bit mask of CAP field.
	CT16B0_CR1_CAP_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_CR1_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_CR1_RESERVED_Msk = 0xffff0000

	// EMR: External Match Register. The EMR controls the match function and the external match pins CT16B0_MAT[1:0] and CT16B1_MAT[1:0].
	// Position of EM0 field.
	CT16B0_EMR_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	CT16B0_EMR_EM0_Msk = 0x1
	// Bit EM0.
	CT16B0_EMR_EM0 = 0x1
	// Position of EM1 field.
	CT16B0_EMR_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	CT16B0_EMR_EM1_Msk = 0x2
	// Bit EM1.
	CT16B0_EMR_EM1 = 0x2
	// Position of EM2 field.
	CT16B0_EMR_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	CT16B0_EMR_EM2_Msk = 0x4
	// Bit EM2.
	CT16B0_EMR_EM2 = 0x4
	// Position of EM3 field.
	CT16B0_EMR_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	CT16B0_EMR_EM3_Msk = 0x8
	// Bit EM3.
	CT16B0_EMR_EM3 = 0x8
	// Position of EMC0 field.
	CT16B0_EMR_EMC0_Pos = 0x4
	// Bit mask of EMC0 field.
	CT16B0_EMR_EMC0_Msk = 0x30
	// Do Nothing.
	CT16B0_EMR_EMC0_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT16Bn_MAT0 pin is LOW if pinned out).
	CT16B0_EMR_EMC0_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT16Bn_MAT0 pin is HIGH if pinned out).
	CT16B0_EMR_EMC0_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT16B0_EMR_EMC0_TOGGLE_THE_CORRESPON = 0x3
	// Position of EMC1 field.
	CT16B0_EMR_EMC1_Pos = 0x6
	// Bit mask of EMC1 field.
	CT16B0_EMR_EMC1_Msk = 0xc0
	// Do Nothing.
	CT16B0_EMR_EMC1_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT16Bn_MAT1 pin is LOW if pinned out).
	CT16B0_EMR_EMC1_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT16Bn_MAT1 pin is HIGH if pinned out).
	CT16B0_EMR_EMC1_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT16B0_EMR_EMC1_TOGGLE_THE_CORRESPON = 0x3
	// Position of EMC2 field.
	CT16B0_EMR_EMC2_Pos = 0x8
	// Bit mask of EMC2 field.
	CT16B0_EMR_EMC2_Msk = 0x300
	// Do Nothing.
	CT16B0_EMR_EMC2_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT16Bn_MAT2 pin is LOW if pinned out).
	CT16B0_EMR_EMC2_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT16Bn_MAT2 pin is HIGH if pinned out).
	CT16B0_EMR_EMC2_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT16B0_EMR_EMC2_TOGGLE_THE_CORRESPON = 0x3
	// Position of EMC3 field.
	CT16B0_EMR_EMC3_Pos = 0xa
	// Bit mask of EMC3 field.
	CT16B0_EMR_EMC3_Msk = 0xc00
	// Do Nothing.
	CT16B0_EMR_EMC3_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT16Bn_MAT3 pin is LOW if pinned out).
	CT16B0_EMR_EMC3_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT16Bn_MAT3 pin is HIGH if pinned out).
	CT16B0_EMR_EMC3_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT16B0_EMR_EMC3_TOGGLE_THE_CORRESPON = 0x3
	// Position of RESERVED field.
	CT16B0_EMR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT16B0_EMR_RESERVED_Msk = 0xfffff000

	// CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
	// Position of CTM field.
	CT16B0_CTCR_CTM_Pos = 0x0
	// Bit mask of CTM field.
	CT16B0_CTCR_CTM_Msk = 0x3
	// Timer Mode: every rising PCLK edge
	CT16B0_CTCR_CTM_TIMER_MODE_EVERY_RI = 0x0
	// Position of CIS field.
	CT16B0_CTCR_CIS_Pos = 0x2
	// Bit mask of CIS field.
	CT16B0_CTCR_CIS_Msk = 0xc
	// CT16B0_CAP0.
	CT16B0_CTCR_CIS_CT16B0_CAP0_ = 0x0
	// Reserved.
	CT16B0_CTCR_CIS_RESERVED_ = 0x1
	// CT16B0_CAP1.
	CT16B0_CTCR_CIS_CT16B0_CAP1_ = 0x2
	// Position of ENCC field.
	CT16B0_CTCR_ENCC_Pos = 0x4
	// Bit mask of ENCC field.
	CT16B0_CTCR_ENCC_Msk = 0x10
	// Bit ENCC.
	CT16B0_CTCR_ENCC = 0x10
	// Position of SELCC field.
	CT16B0_CTCR_SELCC_Pos = 0x5
	// Bit mask of SELCC field.
	CT16B0_CTCR_SELCC_Msk = 0xe0
	// Position of RESERVED field.
	CT16B0_CTCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CT16B0_CTCR_RESERVED_Msk = 0xffffff00

	// PWMC: PWM Control Register. The PWMCON enables PWM mode for the external match pins CT16B0_MAT[1:0] and CT16B1_MAT[1:0].
	// Position of PWMEN0 field.
	CT16B0_PWMC_PWMEN0_Pos = 0x0
	// Bit mask of PWMEN0 field.
	CT16B0_PWMC_PWMEN0_Msk = 0x1
	// Bit PWMEN0.
	CT16B0_PWMC_PWMEN0 = 0x1
	// CT16Bn_MAT0 is controlled by EM0.
	CT16B0_PWMC_PWMEN0_CT16BN_MAT0_IS_CONTR = 0x0
	// PWM mode is enabled for CT16Bn_MAT0.
	CT16B0_PWMC_PWMEN0_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of PWMEN1 field.
	CT16B0_PWMC_PWMEN1_Pos = 0x1
	// Bit mask of PWMEN1 field.
	CT16B0_PWMC_PWMEN1_Msk = 0x2
	// Bit PWMEN1.
	CT16B0_PWMC_PWMEN1 = 0x2
	// CT16Bn_MAT01 is controlled by EM1.
	CT16B0_PWMC_PWMEN1_CT16BN_MAT01_IS_CONT = 0x0
	// PWM mode is enabled for CT16Bn_MAT1.
	CT16B0_PWMC_PWMEN1_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of PWMEN2 field.
	CT16B0_PWMC_PWMEN2_Pos = 0x2
	// Bit mask of PWMEN2 field.
	CT16B0_PWMC_PWMEN2_Msk = 0x4
	// Bit PWMEN2.
	CT16B0_PWMC_PWMEN2 = 0x4
	// CT16Bn_MAT2 is controlled by EM2.
	CT16B0_PWMC_PWMEN2_CT16BN_MAT2_IS_CONTR = 0x0
	// PWM mode is enabled for CT16Bn_MAT2.
	CT16B0_PWMC_PWMEN2_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of PWMEN3 field.
	CT16B0_PWMC_PWMEN3_Pos = 0x3
	// Bit mask of PWMEN3 field.
	CT16B0_PWMC_PWMEN3_Msk = 0x8
	// Bit PWMEN3.
	CT16B0_PWMC_PWMEN3 = 0x8
	// CT16Bn_MAT3 is controlled by EM3.
	CT16B0_PWMC_PWMEN3_CT16BN_MAT3_IS_CONTR = 0x0
	// PWM mode is enabled for CT16Bn_MAT3.
	CT16B0_PWMC_PWMEN3_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of RESERVED field.
	CT16B0_PWMC_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	CT16B0_PWMC_RESERVED_Msk = 0xfffffff0
)

// Bitfields for CT16B1: 16-bit counter/timers CT16B1
const (
	// IR: Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending.
	// Position of MR0INT field.
	CT16B1_IR_MR0INT_Pos = 0x0
	// Bit mask of MR0INT field.
	CT16B1_IR_MR0INT_Msk = 0x1
	// Bit MR0INT.
	CT16B1_IR_MR0INT = 0x1
	// Position of MR1INT field.
	CT16B1_IR_MR1INT_Pos = 0x1
	// Bit mask of MR1INT field.
	CT16B1_IR_MR1INT_Msk = 0x2
	// Bit MR1INT.
	CT16B1_IR_MR1INT = 0x2
	// Position of MR2INT field.
	CT16B1_IR_MR2INT_Pos = 0x2
	// Bit mask of MR2INT field.
	CT16B1_IR_MR2INT_Msk = 0x4
	// Bit MR2INT.
	CT16B1_IR_MR2INT = 0x4
	// Position of MR3INT field.
	CT16B1_IR_MR3INT_Pos = 0x3
	// Bit mask of MR3INT field.
	CT16B1_IR_MR3INT_Msk = 0x8
	// Bit MR3INT.
	CT16B1_IR_MR3INT = 0x8
	// Position of CR0INT field.
	CT16B1_IR_CR0INT_Pos = 0x4
	// Bit mask of CR0INT field.
	CT16B1_IR_CR0INT_Msk = 0x10
	// Bit CR0INT.
	CT16B1_IR_CR0INT = 0x10
	// Position of CR1INT field.
	CT16B1_IR_CR1INT_Pos = 0x5
	// Bit mask of CR1INT field.
	CT16B1_IR_CR1INT_Msk = 0x20
	// Bit CR1INT.
	CT16B1_IR_CR1INT = 0x20
	// Position of RESERVED field.
	CT16B1_IR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	CT16B1_IR_RESERVED_Msk = 0x40
	// Bit RESERVED.
	CT16B1_IR_RESERVED = 0x40
	// Position of RESERVED field.
	CT16B1_IR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	CT16B1_IR_RESERVED_Msk = 0xffffff80

	// TCR: Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
	// Position of CEN field.
	CT16B1_TCR_CEN_Pos = 0x0
	// Bit mask of CEN field.
	CT16B1_TCR_CEN_Msk = 0x1
	// Bit CEN.
	CT16B1_TCR_CEN = 0x1
	// The counters are disabled.
	CT16B1_TCR_CEN_THE_COUNTERS_ARE_DIS = 0x0
	// The Timer Counter and Prescale Counter are enabled for counting.
	CT16B1_TCR_CEN_THE_TIMER_COUNTER_AN = 0x1
	// Position of CRST field.
	CT16B1_TCR_CRST_Pos = 0x1
	// Bit mask of CRST field.
	CT16B1_TCR_CRST_Msk = 0x2
	// Bit CRST.
	CT16B1_TCR_CRST = 0x2
	// Do nothing.
	CT16B1_TCR_CRST_DO_NOTHING_ = 0x0
	// The Timer Counter and the Prescale Counter are synchronously reset on the next positive edge of PCLK. The counters remain reset until TCR[1] is returned to zero.
	CT16B1_TCR_CRST_THE_TIMER_COUNTER_AN = 0x1
	// Position of RESERVED field.
	CT16B1_TCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	CT16B1_TCR_RESERVED_Msk = 0xfffffffc

	// TC: Timer Counter. The 16-bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
	// Position of TC field.
	CT16B1_TC_TC_Pos = 0x0
	// Bit mask of TC field.
	CT16B1_TC_TC_Msk = 0xffff
	// Position of RESERVED field.
	CT16B1_TC_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B1_TC_RESERVED_Msk = 0xffff0000

	// PR: Prescale Register. When the Prescale Counter (below) is equal to this value, the next clock increments the TC and clears the PC.
	// Position of PCVAL field.
	CT16B1_PR_PCVAL_Pos = 0x0
	// Bit mask of PCVAL field.
	CT16B1_PR_PCVAL_Msk = 0xffff
	// Position of RESERVED field.
	CT16B1_PR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B1_PR_RESERVED_Msk = 0xffff0000

	// PC: Prescale Counter. The 16-bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
	// Position of PC field.
	CT16B1_PC_PC_Pos = 0x0
	// Bit mask of PC field.
	CT16B1_PC_PC_Msk = 0xffff
	// Position of RESERVED field.
	CT16B1_PC_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B1_PC_RESERVED_Msk = 0xffff0000

	// MCR: Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
	// Position of MR0I field.
	CT16B1_MCR_MR0I_Pos = 0x0
	// Bit mask of MR0I field.
	CT16B1_MCR_MR0I_Msk = 0x1
	// Bit MR0I.
	CT16B1_MCR_MR0I = 0x1
	// Enabled
	CT16B1_MCR_MR0I_ENABLED = 0x1
	// Disabled
	CT16B1_MCR_MR0I_DISABLED = 0x0
	// Position of MR0R field.
	CT16B1_MCR_MR0R_Pos = 0x1
	// Bit mask of MR0R field.
	CT16B1_MCR_MR0R_Msk = 0x2
	// Bit MR0R.
	CT16B1_MCR_MR0R = 0x2
	// Enabled
	CT16B1_MCR_MR0R_ENABLED = 0x1
	// Disabled
	CT16B1_MCR_MR0R_DISABLED = 0x0
	// Position of MR0S field.
	CT16B1_MCR_MR0S_Pos = 0x2
	// Bit mask of MR0S field.
	CT16B1_MCR_MR0S_Msk = 0x4
	// Bit MR0S.
	CT16B1_MCR_MR0S = 0x4
	// Enabled
	CT16B1_MCR_MR0S_ENABLED = 0x1
	// Disabled
	CT16B1_MCR_MR0S_DISABLED = 0x0
	// Position of MR1I field.
	CT16B1_MCR_MR1I_Pos = 0x3
	// Bit mask of MR1I field.
	CT16B1_MCR_MR1I_Msk = 0x8
	// Bit MR1I.
	CT16B1_MCR_MR1I = 0x8
	// Enabled
	CT16B1_MCR_MR1I_ENABLED = 0x1
	// Disabled
	CT16B1_MCR_MR1I_DISABLED = 0x0
	// Position of MR1R field.
	CT16B1_MCR_MR1R_Pos = 0x4
	// Bit mask of MR1R field.
	CT16B1_MCR_MR1R_Msk = 0x10
	// Bit MR1R.
	CT16B1_MCR_MR1R = 0x10
	// Enabled
	CT16B1_MCR_MR1R_ENABLED = 0x1
	// Disabled
	CT16B1_MCR_MR1R_DISABLED = 0x0
	// Position of MR1S field.
	CT16B1_MCR_MR1S_Pos = 0x5
	// Bit mask of MR1S field.
	CT16B1_MCR_MR1S_Msk = 0x20
	// Bit MR1S.
	CT16B1_MCR_MR1S = 0x20
	// Enabled
	CT16B1_MCR_MR1S_ENABLED = 0x1
	// Disabled
	CT16B1_MCR_MR1S_DISABLED = 0x0
	// Position of MR2I field.
	CT16B1_MCR_MR2I_Pos = 0x6
	// Bit mask of MR2I field.
	CT16B1_MCR_MR2I_Msk = 0x40
	// Bit MR2I.
	CT16B1_MCR_MR2I = 0x40
	// Enabled
	CT16B1_MCR_MR2I_ENABLED = 0x1
	// Disabled
	CT16B1_MCR_MR2I_DISABLED = 0x0
	// Position of MR2R field.
	CT16B1_MCR_MR2R_Pos = 0x7
	// Bit mask of MR2R field.
	CT16B1_MCR_MR2R_Msk = 0x80
	// Bit MR2R.
	CT16B1_MCR_MR2R = 0x80
	// Enabled
	CT16B1_MCR_MR2R_ENABLED = 0x1
	// Disabled
	CT16B1_MCR_MR2R_DISABLED = 0x0
	// Position of MR2S field.
	CT16B1_MCR_MR2S_Pos = 0x8
	// Bit mask of MR2S field.
	CT16B1_MCR_MR2S_Msk = 0x100
	// Bit MR2S.
	CT16B1_MCR_MR2S = 0x100
	// Enabled
	CT16B1_MCR_MR2S_ENABLED = 0x1
	// Disabled
	CT16B1_MCR_MR2S_DISABLED = 0x0
	// Position of MR3I field.
	CT16B1_MCR_MR3I_Pos = 0x9
	// Bit mask of MR3I field.
	CT16B1_MCR_MR3I_Msk = 0x200
	// Bit MR3I.
	CT16B1_MCR_MR3I = 0x200
	// Enabled
	CT16B1_MCR_MR3I_ENABLED = 0x1
	// Disabled
	CT16B1_MCR_MR3I_DISABLED = 0x0
	// Position of MR3R field.
	CT16B1_MCR_MR3R_Pos = 0xa
	// Bit mask of MR3R field.
	CT16B1_MCR_MR3R_Msk = 0x400
	// Bit MR3R.
	CT16B1_MCR_MR3R = 0x400
	// Enabled
	CT16B1_MCR_MR3R_ENABLED = 0x1
	// Disabled
	CT16B1_MCR_MR3R_DISABLED = 0x0
	// Position of MR3S field.
	CT16B1_MCR_MR3S_Pos = 0xb
	// Bit mask of MR3S field.
	CT16B1_MCR_MR3S_Msk = 0x800
	// Bit MR3S.
	CT16B1_MCR_MR3S = 0x800
	// Enabled
	CT16B1_MCR_MR3S_ENABLED = 0x1
	// Disabled
	CT16B1_MCR_MR3S_DISABLED = 0x0
	// Position of RESERVED field.
	CT16B1_MCR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT16B1_MCR_RESERVED_Msk = 0xfffff000

	// MR0: Match Register 0. MR0 can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR0 matches the TC.
	// Position of MATCH field.
	CT16B1_MR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	CT16B1_MR_MATCH_Msk = 0xffff
	// Position of RESERVED field.
	CT16B1_MR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B1_MR_RESERVED_Msk = 0xffff0000

	// CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place.
	// Position of CAP0RE field.
	CT16B1_CCR_CAP0RE_Pos = 0x0
	// Bit mask of CAP0RE field.
	CT16B1_CCR_CAP0RE_Msk = 0x1
	// Bit CAP0RE.
	CT16B1_CCR_CAP0RE = 0x1
	// Enabled.
	CT16B1_CCR_CAP0RE_ENABLED_ = 0x1
	// Disabled.
	CT16B1_CCR_CAP0RE_DISABLED_ = 0x0
	// Position of CAP0FE field.
	CT16B1_CCR_CAP0FE_Pos = 0x1
	// Bit mask of CAP0FE field.
	CT16B1_CCR_CAP0FE_Msk = 0x2
	// Bit CAP0FE.
	CT16B1_CCR_CAP0FE = 0x2
	// Enabled.
	CT16B1_CCR_CAP0FE_ENABLED_ = 0x1
	// Disabled.
	CT16B1_CCR_CAP0FE_DISABLED_ = 0x0
	// Position of CAP0I field.
	CT16B1_CCR_CAP0I_Pos = 0x2
	// Bit mask of CAP0I field.
	CT16B1_CCR_CAP0I_Msk = 0x4
	// Bit CAP0I.
	CT16B1_CCR_CAP0I = 0x4
	// Enabled.
	CT16B1_CCR_CAP0I_ENABLED_ = 0x1
	// Disabled.
	CT16B1_CCR_CAP0I_DISABLED_ = 0x0
	// Position of CAP1RE field.
	CT16B1_CCR_CAP1RE_Pos = 0x3
	// Bit mask of CAP1RE field.
	CT16B1_CCR_CAP1RE_Msk = 0x8
	// Bit CAP1RE.
	CT16B1_CCR_CAP1RE = 0x8
	// Enabled.
	CT16B1_CCR_CAP1RE_ENABLED_ = 0x1
	// Disabled.
	CT16B1_CCR_CAP1RE_DISABLED_ = 0x0
	// Position of CAP1FE field.
	CT16B1_CCR_CAP1FE_Pos = 0x4
	// Bit mask of CAP1FE field.
	CT16B1_CCR_CAP1FE_Msk = 0x10
	// Bit CAP1FE.
	CT16B1_CCR_CAP1FE = 0x10
	// Enabled.
	CT16B1_CCR_CAP1FE_ENABLED_ = 0x1
	// Disabled.
	CT16B1_CCR_CAP1FE_DISABLED_ = 0x0
	// Position of CAP1I field.
	CT16B1_CCR_CAP1I_Pos = 0x5
	// Bit mask of CAP1I field.
	CT16B1_CCR_CAP1I_Msk = 0x20
	// Bit CAP1I.
	CT16B1_CCR_CAP1I = 0x20
	// Enabled.
	CT16B1_CCR_CAP1I_ENABLED_ = 0x1
	// Disabled.
	CT16B1_CCR_CAP1I_DISABLED_ = 0x0
	// Position of RESERVED field.
	CT16B1_CCR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	CT16B1_CCR_RESERVED_Msk = 0xffffffc0

	// CR0: Capture Register 0. CR0 is loaded with the value of TC when there is an event on the CT16B0_CAP0 input.
	// Position of CAP field.
	CT16B1_CR0_CAP_Pos = 0x0
	// Bit mask of CAP field.
	CT16B1_CR0_CAP_Msk = 0xffff
	// Position of RESERVED field.
	CT16B1_CR0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B1_CR0_RESERVED_Msk = 0xffff0000

	// CR1: Capture Register 1. CR1 is loaded with the value of TC when there is an event on the CT16B1_CAP1 input.
	// Position of CAP field.
	CT16B1_CR1_CAP_Pos = 0x0
	// Bit mask of CAP field.
	CT16B1_CR1_CAP_Msk = 0xffff
	// Position of RESERVED field.
	CT16B1_CR1_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B1_CR1_RESERVED_Msk = 0xffff0000

	// EMR: External Match Register. The EMR controls the match function and the external match pins CT16B0_MAT[1:0] and CT16B1_MAT[1:0].
	// Position of EM0 field.
	CT16B1_EMR_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	CT16B1_EMR_EM0_Msk = 0x1
	// Bit EM0.
	CT16B1_EMR_EM0 = 0x1
	// Position of EM1 field.
	CT16B1_EMR_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	CT16B1_EMR_EM1_Msk = 0x2
	// Bit EM1.
	CT16B1_EMR_EM1 = 0x2
	// Position of EM2 field.
	CT16B1_EMR_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	CT16B1_EMR_EM2_Msk = 0x4
	// Bit EM2.
	CT16B1_EMR_EM2 = 0x4
	// Position of EM3 field.
	CT16B1_EMR_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	CT16B1_EMR_EM3_Msk = 0x8
	// Bit EM3.
	CT16B1_EMR_EM3 = 0x8
	// Position of EMC0 field.
	CT16B1_EMR_EMC0_Pos = 0x4
	// Bit mask of EMC0 field.
	CT16B1_EMR_EMC0_Msk = 0x30
	// Do Nothing.
	CT16B1_EMR_EMC0_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT16Bn_MAT0 pin is LOW if pinned out).
	CT16B1_EMR_EMC0_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT16Bn_MAT0 pin is HIGH if pinned out).
	CT16B1_EMR_EMC0_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT16B1_EMR_EMC0_TOGGLE_THE_CORRESPON = 0x3
	// Position of EMC1 field.
	CT16B1_EMR_EMC1_Pos = 0x6
	// Bit mask of EMC1 field.
	CT16B1_EMR_EMC1_Msk = 0xc0
	// Do Nothing.
	CT16B1_EMR_EMC1_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT16Bn_MAT1 pin is LOW if pinned out).
	CT16B1_EMR_EMC1_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT16Bn_MAT1 pin is HIGH if pinned out).
	CT16B1_EMR_EMC1_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT16B1_EMR_EMC1_TOGGLE_THE_CORRESPON = 0x3
	// Position of EMC2 field.
	CT16B1_EMR_EMC2_Pos = 0x8
	// Bit mask of EMC2 field.
	CT16B1_EMR_EMC2_Msk = 0x300
	// Do Nothing.
	CT16B1_EMR_EMC2_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT16Bn_MAT2 pin is LOW if pinned out).
	CT16B1_EMR_EMC2_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT16Bn_MAT2 pin is HIGH if pinned out).
	CT16B1_EMR_EMC2_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT16B1_EMR_EMC2_TOGGLE_THE_CORRESPON = 0x3
	// Position of EMC3 field.
	CT16B1_EMR_EMC3_Pos = 0xa
	// Bit mask of EMC3 field.
	CT16B1_EMR_EMC3_Msk = 0xc00
	// Do Nothing.
	CT16B1_EMR_EMC3_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT16Bn_MAT3 pin is LOW if pinned out).
	CT16B1_EMR_EMC3_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT16Bn_MAT3 pin is HIGH if pinned out).
	CT16B1_EMR_EMC3_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT16B1_EMR_EMC3_TOGGLE_THE_CORRESPON = 0x3
	// Position of RESERVED field.
	CT16B1_EMR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT16B1_EMR_RESERVED_Msk = 0xfffff000

	// CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
	// Position of CTM field.
	CT16B1_CTCR_CTM_Pos = 0x0
	// Bit mask of CTM field.
	CT16B1_CTCR_CTM_Msk = 0x3
	// Timer Mode: every rising PCLK edge
	CT16B1_CTCR_CTM_TIMER_MODE_EVERY_RI = 0x0
	// Position of CIS field.
	CT16B1_CTCR_CIS_Pos = 0x2
	// Bit mask of CIS field.
	CT16B1_CTCR_CIS_Msk = 0xc
	// CT16B1_CAP0.
	CT16B1_CTCR_CIS_CT16B1_CAP0_ = 0x0
	// CT16B1_CAP1.
	CT16B1_CTCR_CIS_CT16B1_CAP1_ = 0x1
	// Position of ENCC field.
	CT16B1_CTCR_ENCC_Pos = 0x4
	// Bit mask of ENCC field.
	CT16B1_CTCR_ENCC_Msk = 0x10
	// Bit ENCC.
	CT16B1_CTCR_ENCC = 0x10
	// Position of SELCC field.
	CT16B1_CTCR_SELCC_Pos = 0x5
	// Bit mask of SELCC field.
	CT16B1_CTCR_SELCC_Msk = 0xe0
	// Position of RESERVED field.
	CT16B1_CTCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CT16B1_CTCR_RESERVED_Msk = 0xffffff00

	// PWMC: PWM Control Register. The PWMCON enables PWM mode for the external match pins CT16B0_MAT[1:0] and CT16B1_MAT[1:0].
	// Position of PWMEN0 field.
	CT16B1_PWMC_PWMEN0_Pos = 0x0
	// Bit mask of PWMEN0 field.
	CT16B1_PWMC_PWMEN0_Msk = 0x1
	// Bit PWMEN0.
	CT16B1_PWMC_PWMEN0 = 0x1
	// CT16Bn_MAT0 is controlled by EM0.
	CT16B1_PWMC_PWMEN0_CT16BN_MAT0_IS_CONTR = 0x0
	// PWM mode is enabled for CT16Bn_MAT0.
	CT16B1_PWMC_PWMEN0_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of PWMEN1 field.
	CT16B1_PWMC_PWMEN1_Pos = 0x1
	// Bit mask of PWMEN1 field.
	CT16B1_PWMC_PWMEN1_Msk = 0x2
	// Bit PWMEN1.
	CT16B1_PWMC_PWMEN1 = 0x2
	// CT16Bn_MAT01 is controlled by EM1.
	CT16B1_PWMC_PWMEN1_CT16BN_MAT01_IS_CONT = 0x0
	// PWM mode is enabled for CT16Bn_MAT1.
	CT16B1_PWMC_PWMEN1_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of PWMEN2 field.
	CT16B1_PWMC_PWMEN2_Pos = 0x2
	// Bit mask of PWMEN2 field.
	CT16B1_PWMC_PWMEN2_Msk = 0x4
	// Bit PWMEN2.
	CT16B1_PWMC_PWMEN2 = 0x4
	// CT16Bn_MAT2 is controlled by EM2.
	CT16B1_PWMC_PWMEN2_CT16BN_MAT2_IS_CONTR = 0x0
	// PWM mode is enabled for CT16Bn_MAT2.
	CT16B1_PWMC_PWMEN2_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of PWMEN3 field.
	CT16B1_PWMC_PWMEN3_Pos = 0x3
	// Bit mask of PWMEN3 field.
	CT16B1_PWMC_PWMEN3_Msk = 0x8
	// Bit PWMEN3.
	CT16B1_PWMC_PWMEN3 = 0x8
	// CT16Bn_MAT3 is controlled by EM3.
	CT16B1_PWMC_PWMEN3_CT16BN_MAT3_IS_CONTR = 0x0
	// PWM mode is enabled for CT16Bn_MAT3.
	CT16B1_PWMC_PWMEN3_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of RESERVED field.
	CT16B1_PWMC_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	CT16B1_PWMC_RESERVED_Msk = 0xfffffff0
)

// Bitfields for CT32B0: 32-bit counter/timers CT32B0
const (
	// IR: Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending.
	// Position of MR0INT field.
	CT32B0_IR_MR0INT_Pos = 0x0
	// Bit mask of MR0INT field.
	CT32B0_IR_MR0INT_Msk = 0x1
	// Bit MR0INT.
	CT32B0_IR_MR0INT = 0x1
	// Position of MR1INT field.
	CT32B0_IR_MR1INT_Pos = 0x1
	// Bit mask of MR1INT field.
	CT32B0_IR_MR1INT_Msk = 0x2
	// Bit MR1INT.
	CT32B0_IR_MR1INT = 0x2
	// Position of MR2INT field.
	CT32B0_IR_MR2INT_Pos = 0x2
	// Bit mask of MR2INT field.
	CT32B0_IR_MR2INT_Msk = 0x4
	// Bit MR2INT.
	CT32B0_IR_MR2INT = 0x4
	// Position of MR3INT field.
	CT32B0_IR_MR3INT_Pos = 0x3
	// Bit mask of MR3INT field.
	CT32B0_IR_MR3INT_Msk = 0x8
	// Bit MR3INT.
	CT32B0_IR_MR3INT = 0x8
	// Position of CR0INT field.
	CT32B0_IR_CR0INT_Pos = 0x4
	// Bit mask of CR0INT field.
	CT32B0_IR_CR0INT_Msk = 0x10
	// Bit CR0INT.
	CT32B0_IR_CR0INT = 0x10
	// Position of RESERVED field.
	CT32B0_IR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	CT32B0_IR_RESERVED_Msk = 0x20
	// Bit RESERVED.
	CT32B0_IR_RESERVED = 0x20
	// Position of CR1INT field.
	CT32B0_IR_CR1INT_Pos = 0x6
	// Bit mask of CR1INT field.
	CT32B0_IR_CR1INT_Msk = 0x40
	// Bit CR1INT.
	CT32B0_IR_CR1INT = 0x40
	// Position of RESERVED field.
	CT32B0_IR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	CT32B0_IR_RESERVED_Msk = 0xffffff80

	// TCR: Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
	// Position of CEN field.
	CT32B0_TCR_CEN_Pos = 0x0
	// Bit mask of CEN field.
	CT32B0_TCR_CEN_Msk = 0x1
	// Bit CEN.
	CT32B0_TCR_CEN = 0x1
	// The counters are disabled.
	CT32B0_TCR_CEN_THE_COUNTERS_ARE_DIS = 0x0
	// The Timer Counter and Prescale Counter are enabled for counting.
	CT32B0_TCR_CEN_THE_TIMER_COUNTER_AN = 0x1
	// Position of CRST field.
	CT32B0_TCR_CRST_Pos = 0x1
	// Bit mask of CRST field.
	CT32B0_TCR_CRST_Msk = 0x2
	// Bit CRST.
	CT32B0_TCR_CRST = 0x2
	// Do nothing.
	CT32B0_TCR_CRST_DO_NOTHING_ = 0x0
	// The Timer Counter and the Prescale Counter are synchronously reset on the next positive edge of PCLK. The counters remain reset until TCR[1] is returned to zero.
	CT32B0_TCR_CRST_THE_TIMER_COUNTER_AN = 0x1
	// Position of RESERVED field.
	CT32B0_TCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	CT32B0_TCR_RESERVED_Msk = 0xfffffffc

	// TC: Timer Counter. The 32-bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
	// Position of TC field.
	CT32B0_TC_TC_Pos = 0x0
	// Bit mask of TC field.
	CT32B0_TC_TC_Msk = 0xffffffff

	// PR: Prescale Register. When the Prescale Counter (below) is equal to this value, the next clock increments the TC and clears the PC.
	// Position of PCVAL field.
	CT32B0_PR_PCVAL_Pos = 0x0
	// Bit mask of PCVAL field.
	CT32B0_PR_PCVAL_Msk = 0xffffffff

	// PC: Prescale Counter. The 32-bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
	// Position of PC field.
	CT32B0_PC_PC_Pos = 0x0
	// Bit mask of PC field.
	CT32B0_PC_PC_Msk = 0xffffffff

	// MCR: Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
	// Position of MR0I field.
	CT32B0_MCR_MR0I_Pos = 0x0
	// Bit mask of MR0I field.
	CT32B0_MCR_MR0I_Msk = 0x1
	// Bit MR0I.
	CT32B0_MCR_MR0I = 0x1
	// Enabled
	CT32B0_MCR_MR0I_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR0I_DISABLED = 0x0
	// Position of MR0R field.
	CT32B0_MCR_MR0R_Pos = 0x1
	// Bit mask of MR0R field.
	CT32B0_MCR_MR0R_Msk = 0x2
	// Bit MR0R.
	CT32B0_MCR_MR0R = 0x2
	// Enabled
	CT32B0_MCR_MR0R_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR0R_DISABLED = 0x0
	// Position of MR0S field.
	CT32B0_MCR_MR0S_Pos = 0x2
	// Bit mask of MR0S field.
	CT32B0_MCR_MR0S_Msk = 0x4
	// Bit MR0S.
	CT32B0_MCR_MR0S = 0x4
	// Enabled
	CT32B0_MCR_MR0S_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR0S_DISABLED = 0x0
	// Position of MR1I field.
	CT32B0_MCR_MR1I_Pos = 0x3
	// Bit mask of MR1I field.
	CT32B0_MCR_MR1I_Msk = 0x8
	// Bit MR1I.
	CT32B0_MCR_MR1I = 0x8
	// Enabled
	CT32B0_MCR_MR1I_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR1I_DISABLED = 0x0
	// Position of MR1R field.
	CT32B0_MCR_MR1R_Pos = 0x4
	// Bit mask of MR1R field.
	CT32B0_MCR_MR1R_Msk = 0x10
	// Bit MR1R.
	CT32B0_MCR_MR1R = 0x10
	// Enabled
	CT32B0_MCR_MR1R_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR1R_DISABLED = 0x0
	// Position of MR1S field.
	CT32B0_MCR_MR1S_Pos = 0x5
	// Bit mask of MR1S field.
	CT32B0_MCR_MR1S_Msk = 0x20
	// Bit MR1S.
	CT32B0_MCR_MR1S = 0x20
	// Enabled
	CT32B0_MCR_MR1S_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR1S_DISABLED = 0x0
	// Position of MR2I field.
	CT32B0_MCR_MR2I_Pos = 0x6
	// Bit mask of MR2I field.
	CT32B0_MCR_MR2I_Msk = 0x40
	// Bit MR2I.
	CT32B0_MCR_MR2I = 0x40
	// Enabled
	CT32B0_MCR_MR2I_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR2I_DISABLED = 0x0
	// Position of MR2R field.
	CT32B0_MCR_MR2R_Pos = 0x7
	// Bit mask of MR2R field.
	CT32B0_MCR_MR2R_Msk = 0x80
	// Bit MR2R.
	CT32B0_MCR_MR2R = 0x80
	// Enabled
	CT32B0_MCR_MR2R_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR2R_DISABLED = 0x0
	// Position of MR2S field.
	CT32B0_MCR_MR2S_Pos = 0x8
	// Bit mask of MR2S field.
	CT32B0_MCR_MR2S_Msk = 0x100
	// Bit MR2S.
	CT32B0_MCR_MR2S = 0x100
	// Enabled
	CT32B0_MCR_MR2S_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR2S_DISABLED = 0x0
	// Position of MR3I field.
	CT32B0_MCR_MR3I_Pos = 0x9
	// Bit mask of MR3I field.
	CT32B0_MCR_MR3I_Msk = 0x200
	// Bit MR3I.
	CT32B0_MCR_MR3I = 0x200
	// Enabled
	CT32B0_MCR_MR3I_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR3I_DISABLED = 0x0
	// Position of MR3R field.
	CT32B0_MCR_MR3R_Pos = 0xa
	// Bit mask of MR3R field.
	CT32B0_MCR_MR3R_Msk = 0x400
	// Bit MR3R.
	CT32B0_MCR_MR3R = 0x400
	// Enabled
	CT32B0_MCR_MR3R_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR3R_DISABLED = 0x0
	// Position of MR3S field.
	CT32B0_MCR_MR3S_Pos = 0xb
	// Bit mask of MR3S field.
	CT32B0_MCR_MR3S_Msk = 0x800
	// Bit MR3S.
	CT32B0_MCR_MR3S = 0x800
	// Enabled
	CT32B0_MCR_MR3S_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR3S_DISABLED = 0x0
	// Position of RESERVED field.
	CT32B0_MCR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT32B0_MCR_RESERVED_Msk = 0xfffff000

	// MR0: Match Register 0. MR0 can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR0 matches the TC.
	// Position of MATCH field.
	CT32B0_MR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	CT32B0_MR_MATCH_Msk = 0xffffffff

	// CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place.
	// Position of CAP0RE field.
	CT32B0_CCR_CAP0RE_Pos = 0x0
	// Bit mask of CAP0RE field.
	CT32B0_CCR_CAP0RE_Msk = 0x1
	// Bit CAP0RE.
	CT32B0_CCR_CAP0RE = 0x1
	// Enabled.
	CT32B0_CCR_CAP0RE_ENABLED_ = 0x1
	// Disabled.
	CT32B0_CCR_CAP0RE_DISABLED_ = 0x0
	// Position of CAP0FE field.
	CT32B0_CCR_CAP0FE_Pos = 0x1
	// Bit mask of CAP0FE field.
	CT32B0_CCR_CAP0FE_Msk = 0x2
	// Bit CAP0FE.
	CT32B0_CCR_CAP0FE = 0x2
	// Enabled.
	CT32B0_CCR_CAP0FE_ENABLED_ = 0x1
	// Disabled.
	CT32B0_CCR_CAP0FE_DISABLED_ = 0x0
	// Position of CAP0I field.
	CT32B0_CCR_CAP0I_Pos = 0x2
	// Bit mask of CAP0I field.
	CT32B0_CCR_CAP0I_Msk = 0x4
	// Bit CAP0I.
	CT32B0_CCR_CAP0I = 0x4
	// Enabled.
	CT32B0_CCR_CAP0I_ENABLED_ = 0x1
	// Disabled.
	CT32B0_CCR_CAP0I_DISABLED_ = 0x0
	// Position of RESERVED field.
	CT32B0_CCR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CT32B0_CCR_RESERVED_Msk = 0x38
	// Position of CAP1RE field.
	CT32B0_CCR_CAP1RE_Pos = 0x6
	// Bit mask of CAP1RE field.
	CT32B0_CCR_CAP1RE_Msk = 0x40
	// Bit CAP1RE.
	CT32B0_CCR_CAP1RE = 0x40
	// Enabled.
	CT32B0_CCR_CAP1RE_ENABLED_ = 0x1
	// Disabled.
	CT32B0_CCR_CAP1RE_DISABLED_ = 0x0
	// Position of CAP1FE field.
	CT32B0_CCR_CAP1FE_Pos = 0x7
	// Bit mask of CAP1FE field.
	CT32B0_CCR_CAP1FE_Msk = 0x80
	// Bit CAP1FE.
	CT32B0_CCR_CAP1FE = 0x80
	// Enabled.
	CT32B0_CCR_CAP1FE_ENABLED_ = 0x1
	// Disabled.
	CT32B0_CCR_CAP1FE_DISABLED_ = 0x0
	// Position of CAP1I field.
	CT32B0_CCR_CAP1I_Pos = 0x8
	// Bit mask of CAP1I field.
	CT32B0_CCR_CAP1I_Msk = 0x100
	// Bit CAP1I.
	CT32B0_CCR_CAP1I = 0x100
	// Enabled.
	CT32B0_CCR_CAP1I_ENABLED_ = 0x1
	// Disabled.
	CT32B0_CCR_CAP1I_DISABLED_ = 0x0
	// Position of RESERVED field.
	CT32B0_CCR_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	CT32B0_CCR_RESERVED_Msk = 0xfffffe00

	// CR0: Capture Register 0. CR0 is loaded with the value of TC when there is an event on the CT32B0_CAP0 input.
	// Position of CAP field.
	CT32B0_CR0_CAP_Pos = 0x0
	// Bit mask of CAP field.
	CT32B0_CR0_CAP_Msk = 0xffffffff

	// CR1: Capture Register 1. CR1 is loaded with the value of TC when there is an event on the CT32B0_CAP1 input.
	// Position of CAP field.
	CT32B0_CR1_CAP_Pos = 0x0
	// Bit mask of CAP field.
	CT32B0_CR1_CAP_Msk = 0xffffffff

	// EMR: External Match Register. The EMR controls the match function and the external match pins CT32Bn_MAT[3:0].
	// Position of EM0 field.
	CT32B0_EMR_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	CT32B0_EMR_EM0_Msk = 0x1
	// Bit EM0.
	CT32B0_EMR_EM0 = 0x1
	// Position of EM1 field.
	CT32B0_EMR_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	CT32B0_EMR_EM1_Msk = 0x2
	// Bit EM1.
	CT32B0_EMR_EM1 = 0x2
	// Position of EM2 field.
	CT32B0_EMR_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	CT32B0_EMR_EM2_Msk = 0x4
	// Bit EM2.
	CT32B0_EMR_EM2 = 0x4
	// Position of EM3 field.
	CT32B0_EMR_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	CT32B0_EMR_EM3_Msk = 0x8
	// Bit EM3.
	CT32B0_EMR_EM3 = 0x8
	// Position of EMC0 field.
	CT32B0_EMR_EMC0_Pos = 0x4
	// Bit mask of EMC0 field.
	CT32B0_EMR_EMC0_Msk = 0x30
	// Do Nothing.
	CT32B0_EMR_EMC0_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bi_MAT0 pin is LOW if pinned out).
	CT32B0_EMR_EMC0_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bi_MAT0 pin is HIGH if pinned out).
	CT32B0_EMR_EMC0_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B0_EMR_EMC0_TOGGLE_THE_CORRESPON = 0x3
	// Position of EMC1 field.
	CT32B0_EMR_EMC1_Pos = 0x6
	// Bit mask of EMC1 field.
	CT32B0_EMR_EMC1_Msk = 0xc0
	// Do Nothing.
	CT32B0_EMR_EMC1_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bi_MAT1 pin is LOW if pinned out).
	CT32B0_EMR_EMC1_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bi_MAT1 pin is HIGH if pinned out).
	CT32B0_EMR_EMC1_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B0_EMR_EMC1_TOGGLE_THE_CORRESPON = 0x3
	// Position of EMC2 field.
	CT32B0_EMR_EMC2_Pos = 0x8
	// Bit mask of EMC2 field.
	CT32B0_EMR_EMC2_Msk = 0x300
	// Do Nothing.
	CT32B0_EMR_EMC2_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bi_MAT2 pin is LOW if pinned out).
	CT32B0_EMR_EMC2_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bi_MAT2 pin is HIGH if pinned out).
	CT32B0_EMR_EMC2_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B0_EMR_EMC2_TOGGLE_THE_CORRESPON = 0x3
	// Position of EMC3 field.
	CT32B0_EMR_EMC3_Pos = 0xa
	// Bit mask of EMC3 field.
	CT32B0_EMR_EMC3_Msk = 0xc00
	// Do Nothing.
	CT32B0_EMR_EMC3_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bi_MAT3 pin is LOW if pinned out).
	CT32B0_EMR_EMC3_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bi_MAT3 pin is HIGH if pinned out).
	CT32B0_EMR_EMC3_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B0_EMR_EMC3_TOGGLE_THE_CORRESPON = 0x3
	// Position of RESERVED field.
	CT32B0_EMR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT32B0_EMR_RESERVED_Msk = 0xfffff000

	// CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
	// Position of CTM field.
	CT32B0_CTCR_CTM_Pos = 0x0
	// Bit mask of CTM field.
	CT32B0_CTCR_CTM_Msk = 0x3
	// Timer Mode: every rising PCLK edge
	CT32B0_CTCR_CTM_TIMER_MODE_EVERY_RI = 0x0
	// Position of CIS field.
	CT32B0_CTCR_CIS_Pos = 0x2
	// Bit mask of CIS field.
	CT32B0_CTCR_CIS_Msk = 0xc
	// CT32B0_CAP0
	CT32B0_CTCR_CIS_CT32B0_CAP0 = 0x0
	// Reserved.
	CT32B0_CTCR_CIS_RESERVED_ = 0x1
	// CT32B0_CAP1
	CT32B0_CTCR_CIS_CT32B0_CAP1 = 0x2
	// Position of ENCC field.
	CT32B0_CTCR_ENCC_Pos = 0x4
	// Bit mask of ENCC field.
	CT32B0_CTCR_ENCC_Msk = 0x10
	// Bit ENCC.
	CT32B0_CTCR_ENCC = 0x10
	// Position of SElCC field.
	CT32B0_CTCR_SElCC_Pos = 0x5
	// Bit mask of SElCC field.
	CT32B0_CTCR_SElCC_Msk = 0xe0
	// Reserved.
	CT32B0_CTCR_SElCC_RESERVED_ = 0x3
	// Position of RESERVED field.
	CT32B0_CTCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CT32B0_CTCR_RESERVED_Msk = 0xffffff00

	// PWMC: PWM Control Register. The PWMCON enables PWM mode for the external match pins CT32Bn_MAT[3:0].
	// Position of PWMEN0 field.
	CT32B0_PWMC_PWMEN0_Pos = 0x0
	// Bit mask of PWMEN0 field.
	CT32B0_PWMC_PWMEN0_Msk = 0x1
	// Bit PWMEN0.
	CT32B0_PWMC_PWMEN0 = 0x1
	// CT32Bn_MAT0 is controlled by EM0.
	CT32B0_PWMC_PWMEN0_CT32BN_MAT0_IS_CONTR = 0x0
	// PWM mode is enabled for CT32Bn_MAT0.
	CT32B0_PWMC_PWMEN0_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of PWMEN1 field.
	CT32B0_PWMC_PWMEN1_Pos = 0x1
	// Bit mask of PWMEN1 field.
	CT32B0_PWMC_PWMEN1_Msk = 0x2
	// Bit PWMEN1.
	CT32B0_PWMC_PWMEN1 = 0x2
	// CT32Bn_MAT01 is controlled by EM1.
	CT32B0_PWMC_PWMEN1_CT32BN_MAT01_IS_CONT = 0x0
	// PWM mode is enabled for CT32Bn_MAT1.
	CT32B0_PWMC_PWMEN1_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of PWMEN2 field.
	CT32B0_PWMC_PWMEN2_Pos = 0x2
	// Bit mask of PWMEN2 field.
	CT32B0_PWMC_PWMEN2_Msk = 0x4
	// Bit PWMEN2.
	CT32B0_PWMC_PWMEN2 = 0x4
	// CT32Bn_MAT2 is controlled by EM2.
	CT32B0_PWMC_PWMEN2_CT32BN_MAT2_IS_CONTR = 0x0
	// PWM mode is enabled for CT32Bn_MAT2.
	CT32B0_PWMC_PWMEN2_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of PWMEN3 field.
	CT32B0_PWMC_PWMEN3_Pos = 0x3
	// Bit mask of PWMEN3 field.
	CT32B0_PWMC_PWMEN3_Msk = 0x8
	// Bit PWMEN3.
	CT32B0_PWMC_PWMEN3 = 0x8
	// CT32Bn_MAT3 is controlled by EM3.
	CT32B0_PWMC_PWMEN3_CT32BN_MAT3_IS_CONTR = 0x0
	// PWM mode is enabled for CT132Bn_MAT3.
	CT32B0_PWMC_PWMEN3_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of RESERVED field.
	CT32B0_PWMC_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	CT32B0_PWMC_RESERVED_Msk = 0xfffffff0
)

// Bitfields for CT32B1: 32-bit counter/timers CT32B1
const (
	// IR: Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending.
	// Position of MR0INT field.
	CT32B1_IR_MR0INT_Pos = 0x0
	// Bit mask of MR0INT field.
	CT32B1_IR_MR0INT_Msk = 0x1
	// Bit MR0INT.
	CT32B1_IR_MR0INT = 0x1
	// Position of MR1INT field.
	CT32B1_IR_MR1INT_Pos = 0x1
	// Bit mask of MR1INT field.
	CT32B1_IR_MR1INT_Msk = 0x2
	// Bit MR1INT.
	CT32B1_IR_MR1INT = 0x2
	// Position of MR2INT field.
	CT32B1_IR_MR2INT_Pos = 0x2
	// Bit mask of MR2INT field.
	CT32B1_IR_MR2INT_Msk = 0x4
	// Bit MR2INT.
	CT32B1_IR_MR2INT = 0x4
	// Position of MR3INT field.
	CT32B1_IR_MR3INT_Pos = 0x3
	// Bit mask of MR3INT field.
	CT32B1_IR_MR3INT_Msk = 0x8
	// Bit MR3INT.
	CT32B1_IR_MR3INT = 0x8
	// Position of CR0INT field.
	CT32B1_IR_CR0INT_Pos = 0x4
	// Bit mask of CR0INT field.
	CT32B1_IR_CR0INT_Msk = 0x10
	// Bit CR0INT.
	CT32B1_IR_CR0INT = 0x10
	// Position of CR1INT field.
	CT32B1_IR_CR1INT_Pos = 0x5
	// Bit mask of CR1INT field.
	CT32B1_IR_CR1INT_Msk = 0x20
	// Bit CR1INT.
	CT32B1_IR_CR1INT = 0x20
	// Position of RESERVED field.
	CT32B1_IR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	CT32B1_IR_RESERVED_Msk = 0xffffffc0

	// TCR: Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
	// Position of CEN field.
	CT32B1_TCR_CEN_Pos = 0x0
	// Bit mask of CEN field.
	CT32B1_TCR_CEN_Msk = 0x1
	// Bit CEN.
	CT32B1_TCR_CEN = 0x1
	// The counters are disabled.
	CT32B1_TCR_CEN_THE_COUNTERS_ARE_DIS = 0x0
	// The Timer Counter and Prescale Counter are enabled for counting.
	CT32B1_TCR_CEN_THE_TIMER_COUNTER_AN = 0x1
	// Position of CRST field.
	CT32B1_TCR_CRST_Pos = 0x1
	// Bit mask of CRST field.
	CT32B1_TCR_CRST_Msk = 0x2
	// Bit CRST.
	CT32B1_TCR_CRST = 0x2
	// Do nothing.
	CT32B1_TCR_CRST_DO_NOTHING_ = 0x0
	// The Timer Counter and the Prescale Counter are synchronously reset on the next positive edge of PCLK. The counters remain reset until TCR[1] is returned to zero.
	CT32B1_TCR_CRST_THE_TIMER_COUNTER_AN = 0x1
	// Position of RESERVED field.
	CT32B1_TCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	CT32B1_TCR_RESERVED_Msk = 0xfffffffc

	// TC: Timer Counter. The 32-bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
	// Position of TC field.
	CT32B1_TC_TC_Pos = 0x0
	// Bit mask of TC field.
	CT32B1_TC_TC_Msk = 0xffffffff

	// PR: Prescale Register. When the Prescale Counter (below) is equal to this value, the next clock increments the TC and clears the PC.
	// Position of PCVAL field.
	CT32B1_PR_PCVAL_Pos = 0x0
	// Bit mask of PCVAL field.
	CT32B1_PR_PCVAL_Msk = 0xffffffff

	// PC: Prescale Counter. The 32-bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
	// Position of PC field.
	CT32B1_PC_PC_Pos = 0x0
	// Bit mask of PC field.
	CT32B1_PC_PC_Msk = 0xffffffff

	// MCR: Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
	// Position of MR0I field.
	CT32B1_MCR_MR0I_Pos = 0x0
	// Bit mask of MR0I field.
	CT32B1_MCR_MR0I_Msk = 0x1
	// Bit MR0I.
	CT32B1_MCR_MR0I = 0x1
	// Enabled
	CT32B1_MCR_MR0I_ENABLED = 0x1
	// Disabled
	CT32B1_MCR_MR0I_DISABLED = 0x0
	// Position of MR0R field.
	CT32B1_MCR_MR0R_Pos = 0x1
	// Bit mask of MR0R field.
	CT32B1_MCR_MR0R_Msk = 0x2
	// Bit MR0R.
	CT32B1_MCR_MR0R = 0x2
	// Enabled
	CT32B1_MCR_MR0R_ENABLED = 0x1
	// Disabled
	CT32B1_MCR_MR0R_DISABLED = 0x0
	// Position of MR0S field.
	CT32B1_MCR_MR0S_Pos = 0x2
	// Bit mask of MR0S field.
	CT32B1_MCR_MR0S_Msk = 0x4
	// Bit MR0S.
	CT32B1_MCR_MR0S = 0x4
	// Enabled
	CT32B1_MCR_MR0S_ENABLED = 0x1
	// Disabled
	CT32B1_MCR_MR0S_DISABLED = 0x0
	// Position of MR1I field.
	CT32B1_MCR_MR1I_Pos = 0x3
	// Bit mask of MR1I field.
	CT32B1_MCR_MR1I_Msk = 0x8
	// Bit MR1I.
	CT32B1_MCR_MR1I = 0x8
	// Enabled
	CT32B1_MCR_MR1I_ENABLED = 0x1
	// Disabled
	CT32B1_MCR_MR1I_DISABLED = 0x0
	// Position of MR1R field.
	CT32B1_MCR_MR1R_Pos = 0x4
	// Bit mask of MR1R field.
	CT32B1_MCR_MR1R_Msk = 0x10
	// Bit MR1R.
	CT32B1_MCR_MR1R = 0x10
	// Enabled
	CT32B1_MCR_MR1R_ENABLED = 0x1
	// Disabled
	CT32B1_MCR_MR1R_DISABLED = 0x0
	// Position of MR1S field.
	CT32B1_MCR_MR1S_Pos = 0x5
	// Bit mask of MR1S field.
	CT32B1_MCR_MR1S_Msk = 0x20
	// Bit MR1S.
	CT32B1_MCR_MR1S = 0x20
	// Enabled
	CT32B1_MCR_MR1S_ENABLED = 0x1
	// Disabled
	CT32B1_MCR_MR1S_DISABLED = 0x0
	// Position of MR2I field.
	CT32B1_MCR_MR2I_Pos = 0x6
	// Bit mask of MR2I field.
	CT32B1_MCR_MR2I_Msk = 0x40
	// Bit MR2I.
	CT32B1_MCR_MR2I = 0x40
	// Enabled
	CT32B1_MCR_MR2I_ENABLED = 0x1
	// Disabled
	CT32B1_MCR_MR2I_DISABLED = 0x0
	// Position of MR2R field.
	CT32B1_MCR_MR2R_Pos = 0x7
	// Bit mask of MR2R field.
	CT32B1_MCR_MR2R_Msk = 0x80
	// Bit MR2R.
	CT32B1_MCR_MR2R = 0x80
	// Enabled
	CT32B1_MCR_MR2R_ENABLED = 0x1
	// Disabled
	CT32B1_MCR_MR2R_DISABLED = 0x0
	// Position of MR2S field.
	CT32B1_MCR_MR2S_Pos = 0x8
	// Bit mask of MR2S field.
	CT32B1_MCR_MR2S_Msk = 0x100
	// Bit MR2S.
	CT32B1_MCR_MR2S = 0x100
	// Enabled
	CT32B1_MCR_MR2S_ENABLED = 0x1
	// Disabled
	CT32B1_MCR_MR2S_DISABLED = 0x0
	// Position of MR3I field.
	CT32B1_MCR_MR3I_Pos = 0x9
	// Bit mask of MR3I field.
	CT32B1_MCR_MR3I_Msk = 0x200
	// Bit MR3I.
	CT32B1_MCR_MR3I = 0x200
	// Enabled
	CT32B1_MCR_MR3I_ENABLED = 0x1
	// Disabled
	CT32B1_MCR_MR3I_DISABLED = 0x0
	// Position of MR3R field.
	CT32B1_MCR_MR3R_Pos = 0xa
	// Bit mask of MR3R field.
	CT32B1_MCR_MR3R_Msk = 0x400
	// Bit MR3R.
	CT32B1_MCR_MR3R = 0x400
	// Enabled
	CT32B1_MCR_MR3R_ENABLED = 0x1
	// Disabled
	CT32B1_MCR_MR3R_DISABLED = 0x0
	// Position of MR3S field.
	CT32B1_MCR_MR3S_Pos = 0xb
	// Bit mask of MR3S field.
	CT32B1_MCR_MR3S_Msk = 0x800
	// Bit MR3S.
	CT32B1_MCR_MR3S = 0x800
	// Enabled
	CT32B1_MCR_MR3S_ENABLED = 0x1
	// Disabled
	CT32B1_MCR_MR3S_DISABLED = 0x0
	// Position of RESERVED field.
	CT32B1_MCR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT32B1_MCR_RESERVED_Msk = 0xfffff000

	// MR0: Match Register 0. MR0 can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR0 matches the TC.
	// Position of MATCH field.
	CT32B1_MR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	CT32B1_MR_MATCH_Msk = 0xffffffff

	// CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place.
	// Position of CAP0RE field.
	CT32B1_CCR_CAP0RE_Pos = 0x0
	// Bit mask of CAP0RE field.
	CT32B1_CCR_CAP0RE_Msk = 0x1
	// Bit CAP0RE.
	CT32B1_CCR_CAP0RE = 0x1
	// Enabled.
	CT32B1_CCR_CAP0RE_ENABLED_ = 0x1
	// Disabled.
	CT32B1_CCR_CAP0RE_DISABLED_ = 0x0
	// Position of CAP0FE field.
	CT32B1_CCR_CAP0FE_Pos = 0x1
	// Bit mask of CAP0FE field.
	CT32B1_CCR_CAP0FE_Msk = 0x2
	// Bit CAP0FE.
	CT32B1_CCR_CAP0FE = 0x2
	// Enabled.
	CT32B1_CCR_CAP0FE_ENABLED_ = 0x1
	// Disabled.
	CT32B1_CCR_CAP0FE_DISABLED_ = 0x0
	// Position of CAP0I field.
	CT32B1_CCR_CAP0I_Pos = 0x2
	// Bit mask of CAP0I field.
	CT32B1_CCR_CAP0I_Msk = 0x4
	// Bit CAP0I.
	CT32B1_CCR_CAP0I = 0x4
	// Enabled.
	CT32B1_CCR_CAP0I_ENABLED_ = 0x1
	// Disabled.
	CT32B1_CCR_CAP0I_DISABLED_ = 0x0
	// Position of CAP1RE field.
	CT32B1_CCR_CAP1RE_Pos = 0x3
	// Bit mask of CAP1RE field.
	CT32B1_CCR_CAP1RE_Msk = 0x8
	// Bit CAP1RE.
	CT32B1_CCR_CAP1RE = 0x8
	// Enabled.
	CT32B1_CCR_CAP1RE_ENABLED_ = 0x1
	// Disabled.
	CT32B1_CCR_CAP1RE_DISABLED_ = 0x0
	// Position of CAP1FE field.
	CT32B1_CCR_CAP1FE_Pos = 0x4
	// Bit mask of CAP1FE field.
	CT32B1_CCR_CAP1FE_Msk = 0x10
	// Bit CAP1FE.
	CT32B1_CCR_CAP1FE = 0x10
	// Enabled.
	CT32B1_CCR_CAP1FE_ENABLED_ = 0x1
	// Disabled.
	CT32B1_CCR_CAP1FE_DISABLED_ = 0x0
	// Position of CAP1I field.
	CT32B1_CCR_CAP1I_Pos = 0x5
	// Bit mask of CAP1I field.
	CT32B1_CCR_CAP1I_Msk = 0x20
	// Bit CAP1I.
	CT32B1_CCR_CAP1I = 0x20
	// Enabled.
	CT32B1_CCR_CAP1I_ENABLED_ = 0x1
	// Disabled.
	CT32B1_CCR_CAP1I_DISABLED_ = 0x0
	// Position of RESERVED field.
	CT32B1_CCR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	CT32B1_CCR_RESERVED_Msk = 0xffffffc0

	// CR0: Capture Register 0. CR0 is loaded with the value of TC when there is an event on the CT32B0_CAP0 input.
	// Position of CAP field.
	CT32B1_CR0_CAP_Pos = 0x0
	// Bit mask of CAP field.
	CT32B1_CR0_CAP_Msk = 0xffffffff

	// CR1: Capture Register 1. CR1 is loaded with the value of TC when there is an event on the CT32B1_CAP1 input.
	// Position of CAP field.
	CT32B1_CR1_CAP_Pos = 0x0
	// Bit mask of CAP field.
	CT32B1_CR1_CAP_Msk = 0xffffffff

	// EMR: External Match Register. The EMR controls the match function and the external match pins CT32Bn_MAT[3:0].
	// Position of EM0 field.
	CT32B1_EMR_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	CT32B1_EMR_EM0_Msk = 0x1
	// Bit EM0.
	CT32B1_EMR_EM0 = 0x1
	// Position of EM1 field.
	CT32B1_EMR_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	CT32B1_EMR_EM1_Msk = 0x2
	// Bit EM1.
	CT32B1_EMR_EM1 = 0x2
	// Position of EM2 field.
	CT32B1_EMR_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	CT32B1_EMR_EM2_Msk = 0x4
	// Bit EM2.
	CT32B1_EMR_EM2 = 0x4
	// Position of EM3 field.
	CT32B1_EMR_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	CT32B1_EMR_EM3_Msk = 0x8
	// Bit EM3.
	CT32B1_EMR_EM3 = 0x8
	// Position of EMC0 field.
	CT32B1_EMR_EMC0_Pos = 0x4
	// Bit mask of EMC0 field.
	CT32B1_EMR_EMC0_Msk = 0x30
	// Do Nothing.
	CT32B1_EMR_EMC0_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bi_MAT0 pin is LOW if pinned out).
	CT32B1_EMR_EMC0_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bi_MAT0 pin is HIGH if pinned out).
	CT32B1_EMR_EMC0_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B1_EMR_EMC0_TOGGLE_THE_CORRESPON = 0x3
	// Position of EMC1 field.
	CT32B1_EMR_EMC1_Pos = 0x6
	// Bit mask of EMC1 field.
	CT32B1_EMR_EMC1_Msk = 0xc0
	// Do Nothing.
	CT32B1_EMR_EMC1_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bi_MAT1 pin is LOW if pinned out).
	CT32B1_EMR_EMC1_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bi_MAT1 pin is HIGH if pinned out).
	CT32B1_EMR_EMC1_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B1_EMR_EMC1_TOGGLE_THE_CORRESPON = 0x3
	// Position of EMC2 field.
	CT32B1_EMR_EMC2_Pos = 0x8
	// Bit mask of EMC2 field.
	CT32B1_EMR_EMC2_Msk = 0x300
	// Do Nothing.
	CT32B1_EMR_EMC2_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bi_MAT2 pin is LOW if pinned out).
	CT32B1_EMR_EMC2_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bi_MAT2 pin is HIGH if pinned out).
	CT32B1_EMR_EMC2_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B1_EMR_EMC2_TOGGLE_THE_CORRESPON = 0x3
	// Position of EMC3 field.
	CT32B1_EMR_EMC3_Pos = 0xa
	// Bit mask of EMC3 field.
	CT32B1_EMR_EMC3_Msk = 0xc00
	// Do Nothing.
	CT32B1_EMR_EMC3_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bi_MAT3 pin is LOW if pinned out).
	CT32B1_EMR_EMC3_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bi_MAT3 pin is HIGH if pinned out).
	CT32B1_EMR_EMC3_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B1_EMR_EMC3_TOGGLE_THE_CORRESPON = 0x3
	// Position of RESERVED field.
	CT32B1_EMR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT32B1_EMR_RESERVED_Msk = 0xfffff000

	// CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
	// Position of CTM field.
	CT32B1_CTCR_CTM_Pos = 0x0
	// Bit mask of CTM field.
	CT32B1_CTCR_CTM_Msk = 0x3
	// Timer Mode: every rising PCLK edge
	CT32B1_CTCR_CTM_TIMER_MODE_EVERY_RI = 0x0
	// Position of CIS field.
	CT32B1_CTCR_CIS_Pos = 0x2
	// Bit mask of CIS field.
	CT32B1_CTCR_CIS_Msk = 0xc
	// CT32B1_CAP0
	CT32B1_CTCR_CIS_CT32B1_CAP0 = 0x0
	// CT32B1_CAP1
	CT32B1_CTCR_CIS_CT32B1_CAP1 = 0x1
	// Position of ENCC field.
	CT32B1_CTCR_ENCC_Pos = 0x4
	// Bit mask of ENCC field.
	CT32B1_CTCR_ENCC_Msk = 0x10
	// Bit ENCC.
	CT32B1_CTCR_ENCC = 0x10
	// Position of SElCC field.
	CT32B1_CTCR_SElCC_Pos = 0x5
	// Bit mask of SElCC field.
	CT32B1_CTCR_SElCC_Msk = 0xe0
	// Position of RESERVED field.
	CT32B1_CTCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CT32B1_CTCR_RESERVED_Msk = 0xffffff00

	// PWMC: PWM Control Register. The PWMCON enables PWM mode for the external match pins CT32Bn_MAT[3:0].
	// Position of PWMEN0 field.
	CT32B1_PWMC_PWMEN0_Pos = 0x0
	// Bit mask of PWMEN0 field.
	CT32B1_PWMC_PWMEN0_Msk = 0x1
	// Bit PWMEN0.
	CT32B1_PWMC_PWMEN0 = 0x1
	// CT32Bn_MAT0 is controlled by EM0.
	CT32B1_PWMC_PWMEN0_CT32BN_MAT0_IS_CONTR = 0x0
	// PWM mode is enabled for CT32Bn_MAT0.
	CT32B1_PWMC_PWMEN0_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of PWMEN1 field.
	CT32B1_PWMC_PWMEN1_Pos = 0x1
	// Bit mask of PWMEN1 field.
	CT32B1_PWMC_PWMEN1_Msk = 0x2
	// Bit PWMEN1.
	CT32B1_PWMC_PWMEN1 = 0x2
	// CT32Bn_MAT01 is controlled by EM1.
	CT32B1_PWMC_PWMEN1_CT32BN_MAT01_IS_CONT = 0x0
	// PWM mode is enabled for CT32Bn_MAT1.
	CT32B1_PWMC_PWMEN1_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of PWMEN2 field.
	CT32B1_PWMC_PWMEN2_Pos = 0x2
	// Bit mask of PWMEN2 field.
	CT32B1_PWMC_PWMEN2_Msk = 0x4
	// Bit PWMEN2.
	CT32B1_PWMC_PWMEN2 = 0x4
	// CT32Bn_MAT2 is controlled by EM2.
	CT32B1_PWMC_PWMEN2_CT32BN_MAT2_IS_CONTR = 0x0
	// PWM mode is enabled for CT32Bn_MAT2.
	CT32B1_PWMC_PWMEN2_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of PWMEN3 field.
	CT32B1_PWMC_PWMEN3_Pos = 0x3
	// Bit mask of PWMEN3 field.
	CT32B1_PWMC_PWMEN3_Msk = 0x8
	// Bit PWMEN3.
	CT32B1_PWMC_PWMEN3 = 0x8
	// CT32Bn_MAT3 is controlled by EM3.
	CT32B1_PWMC_PWMEN3_CT32BN_MAT3_IS_CONTR = 0x0
	// PWM mode is enabled for CT132Bn_MAT3.
	CT32B1_PWMC_PWMEN3_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of RESERVED field.
	CT32B1_PWMC_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	CT32B1_PWMC_RESERVED_Msk = 0xfffffff0
)

// Bitfields for ADC: ADC
const (
	// CR: A/D Control Register. The CR register must be written to select the operating mode before A/D conversion can occur.
	// Position of SEL field.
	ADC_CR_SEL_Pos = 0x0
	// Bit mask of SEL field.
	ADC_CR_SEL_Msk = 0xff
	// Position of CLKDIV field.
	ADC_CR_CLKDIV_Pos = 0x8
	// Bit mask of CLKDIV field.
	ADC_CR_CLKDIV_Msk = 0xff00
	// Position of BURST field.
	ADC_CR_BURST_Pos = 0x10
	// Bit mask of BURST field.
	ADC_CR_BURST_Msk = 0x10000
	// Bit BURST.
	ADC_CR_BURST = 0x10000
	// Software-controlled mode: Conversions are software-controlled and require 11 clocks.
	ADC_CR_BURST_SOFTWARE_CONTROLLED_ = 0x0
	// Hardware scan mode: The AD converter does repeated conversions at the rate selected by the CLKS field, scanning (if necessary) through the pins selected by 1s in the SEL field. The first conversion after the start corresponds to the least-significant bit set to 1 in the SEL field, then the next higher bits (pins) set to 1 are scanned if applicable. Repeated conversions can be terminated by clearing this bit, but the conversion in progress when this bit is cleared will be completed. Important: START bits must be 000 when BURST = 1 or conversions will not start.
	ADC_CR_BURST_HARDWARE_SCAN_MODE_ = 0x1
	// Position of CLKS field.
	ADC_CR_CLKS_Pos = 0x11
	// Bit mask of CLKS field.
	ADC_CR_CLKS_Msk = 0xe0000
	// 11 clocks / 10 bits
	ADC_CR_CLKS_11_CLOCKS = 0x0
	// 10 clocks / 9 bits
	ADC_CR_CLKS_10_CLOCKS = 0x1
	// 9 clocks / 8 bits
	ADC_CR_CLKS_9_CLOCKS = 0x2
	// 8 clocks / 7 bits
	ADC_CR_CLKS_8_CLOCKS = 0x3
	// 7 clocks / 6 bits
	ADC_CR_CLKS_7_CLOCKS = 0x4
	// 6 clocks / 5 bits
	ADC_CR_CLKS_6_CLOCKS = 0x5
	// 5 clocks / 4 bits
	ADC_CR_CLKS_5_CLOCKS = 0x6
	// 4 clocks / 3 bits
	ADC_CR_CLKS_4_CLOCKS = 0x7
	// Position of RESERVED field.
	ADC_CR_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ADC_CR_RESERVED_Msk = 0xf00000
	// Position of START field.
	ADC_CR_START_Pos = 0x18
	// Bit mask of START field.
	ADC_CR_START_Msk = 0x7000000
	// No start (this value should be used when clearing PDN to 0).
	ADC_CR_START_NO_START_THIS_VALUE = 0x0
	// Start conversion now.
	ADC_CR_START_START_CONVERSION_NOW = 0x1
	// Start conversion when the edge selected by bit 27 occurs on PIO0_2/SSEL/CT16B0_CAP0.
	ADC_CR_START_PIO0_2 = 0x2
	// Start conversion when the edge selected by bit 27 occurs on PIO1_5/DIR/CT32B0_CAP0.
	ADC_CR_START_PIO1_5 = 0x3
	// Start conversion when the edge selected by bit 27 occurs on CT32B0_MAT0[1].
	ADC_CR_START_CT32B0_MAT0 = 0x4
	// Start conversion when the edge selected by bit 27 occurs on CT32B0_MAT1[1].
	ADC_CR_START_CT32B0_MAT1 = 0x5
	// Start conversion when the edge selected by bit 27 occurs on CT16B0_MAT0[1].
	ADC_CR_START_CT16B0_MAT0 = 0x6
	// Start conversion when the edge selected by bit 27 occurs on CT16B0_MAT1[1].
	ADC_CR_START_CT16B0_MAT1 = 0x7
	// Position of EDGE field.
	ADC_CR_EDGE_Pos = 0x1b
	// Bit mask of EDGE field.
	ADC_CR_EDGE_Msk = 0x8000000
	// Bit EDGE.
	ADC_CR_EDGE = 0x8000000
	// Start conversion on a rising edge on the selected CAP/MAT signal.
	ADC_CR_EDGE_RISING = 0x0
	// Start conversion on a falling edge on the selected CAP/MAT signal.
	ADC_CR_EDGE_FALLING = 0x1
	// Position of RESERVED field.
	ADC_CR_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	ADC_CR_RESERVED_Msk = 0xf0000000

	// GDR: A/D Global Data Register. Contains the result of the most recent A/D conversion.
	// Position of RESERVED field.
	ADC_GDR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_GDR_RESERVED_Msk = 0x3f
	// Position of V_VREF field.
	ADC_GDR_V_VREF_Pos = 0x6
	// Bit mask of V_VREF field.
	ADC_GDR_V_VREF_Msk = 0xffc0
	// Position of RESERVED field.
	ADC_GDR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_GDR_RESERVED_Msk = 0xff0000
	// Position of CHN field.
	ADC_GDR_CHN_Pos = 0x18
	// Bit mask of CHN field.
	ADC_GDR_CHN_Msk = 0x7000000
	// Position of RESERVED field.
	ADC_GDR_RESERVED_Pos = 0x1b
	// Bit mask of RESERVED field.
	ADC_GDR_RESERVED_Msk = 0x38000000
	// Position of OVERRUN field.
	ADC_GDR_OVERRUN_Pos = 0x1e
	// Bit mask of OVERRUN field.
	ADC_GDR_OVERRUN_Msk = 0x40000000
	// Bit OVERRUN.
	ADC_GDR_OVERRUN = 0x40000000
	// Position of DONE field.
	ADC_GDR_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	ADC_GDR_DONE_Msk = 0x80000000
	// Bit DONE.
	ADC_GDR_DONE = 0x80000000

	// INTEN: A/D Interrupt Enable Register. This register contains enable bits that allow the DONE flag of each A/D channel to be included or excluded from contributing to the generation of an A/D interrupt.
	// Position of ADINTEN field.
	ADC_INTEN_ADINTEN_Pos = 0x0
	// Bit mask of ADINTEN field.
	ADC_INTEN_ADINTEN_Msk = 0xff
	// Position of ADGINTEN field.
	ADC_INTEN_ADGINTEN_Pos = 0x8
	// Bit mask of ADGINTEN field.
	ADC_INTEN_ADGINTEN_Msk = 0x100
	// Bit ADGINTEN.
	ADC_INTEN_ADGINTEN = 0x100
	// Position of RESERVED field.
	ADC_INTEN_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	ADC_INTEN_RESERVED_Msk = 0xfffffe00

	// DR0: A/D Channel Data Register. This register contains the result of the most recent conversion completed on channel N
	// Position of RESERVED field.
	ADC_DR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_DR_RESERVED_Msk = 0x3f
	// Position of V_VREF field.
	ADC_DR_V_VREF_Pos = 0x6
	// Bit mask of V_VREF field.
	ADC_DR_V_VREF_Msk = 0xffc0
	// Position of RESERVED field.
	ADC_DR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_DR_RESERVED_Msk = 0x3fff0000
	// Position of OVERRUN field.
	ADC_DR_OVERRUN_Pos = 0x1e
	// Bit mask of OVERRUN field.
	ADC_DR_OVERRUN_Msk = 0x40000000
	// Bit OVERRUN.
	ADC_DR_OVERRUN = 0x40000000
	// Position of DONE field.
	ADC_DR_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	ADC_DR_DONE_Msk = 0x80000000
	// Bit DONE.
	ADC_DR_DONE = 0x80000000

	// STAT: A/D Status Register. This register contains DONE and OVERRUN flags for all of the A/D channels, as well as the A/D interrupt flag.
	// Position of DONE field.
	ADC_STAT_DONE_Pos = 0x0
	// Bit mask of DONE field.
	ADC_STAT_DONE_Msk = 0xff
	// Position of OVERRUN field.
	ADC_STAT_OVERRUN_Pos = 0x8
	// Bit mask of OVERRUN field.
	ADC_STAT_OVERRUN_Msk = 0xff00
	// Position of ADINT field.
	ADC_STAT_ADINT_Pos = 0x10
	// Bit mask of ADINT field.
	ADC_STAT_ADINT_Msk = 0x10000
	// Bit ADINT.
	ADC_STAT_ADINT = 0x10000
	// Position of RESERVED field.
	ADC_STAT_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	ADC_STAT_RESERVED_Msk = 0xfffe0000
)

// Bitfields for PMU: Power Management Unit (PMU)
const (
	// PCON: Power control register
	// Position of PM field.
	PMU_PCON_PM_Pos = 0x0
	// Bit mask of PM field.
	PMU_PCON_PM_Msk = 0x7
	// Default. The part is in active or sleep mode.
	PMU_PCON_PM_DEFAULT = 0x0
	// ARM WFI will enter Deep-sleep mode.
	PMU_PCON_PM_DEEPSLEEP = 0x1
	// ARM WFI will enter Power-down mode.
	PMU_PCON_PM_POWERDOWN = 0x2
	// ARM WFI will enter Deep-power down mode (ARM Cortex-M0 core powered-down).
	PMU_PCON_PM_DEEPPOWERDOWN = 0x3
	// Position of NODPD field.
	PMU_PCON_NODPD_Pos = 0x3
	// Bit mask of NODPD field.
	PMU_PCON_NODPD_Msk = 0x8
	// Bit NODPD.
	PMU_PCON_NODPD = 0x8
	// Position of RESERVED field.
	PMU_PCON_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	PMU_PCON_RESERVED_Msk = 0xf0
	// Position of SLEEPFLAG field.
	PMU_PCON_SLEEPFLAG_Pos = 0x8
	// Bit mask of SLEEPFLAG field.
	PMU_PCON_SLEEPFLAG_Msk = 0x100
	// Bit SLEEPFLAG.
	PMU_PCON_SLEEPFLAG = 0x100
	// Read: No power-down mode entered. LPC11U1x is in Active mode. Write: No effect.
	PMU_PCON_SLEEPFLAG_NOPOWERDOWN = 0x0
	// Read: Sleep/Deep-sleep or Deep power-down mode entered. Write: Writing a 1 clears the SLEEPFLAG bit to 0.
	PMU_PCON_SLEEPFLAG_POWERDOWN = 0x1
	// Position of RESERVED field.
	PMU_PCON_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	PMU_PCON_RESERVED_Msk = 0x600
	// Position of DPDFLAG field.
	PMU_PCON_DPDFLAG_Pos = 0xb
	// Bit mask of DPDFLAG field.
	PMU_PCON_DPDFLAG_Msk = 0x800
	// Bit DPDFLAG.
	PMU_PCON_DPDFLAG = 0x800
	// Read: Deep power-down mode not entered. Write: No effect.
	PMU_PCON_DPDFLAG_DPNOTENTERED = 0x0
	// Read: Deep power-down mode entered. Write: Clear the Deep power-down flag.
	PMU_PCON_DPDFLAG_DPENTERED = 0x1
	// Position of RESERVED field.
	PMU_PCON_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	PMU_PCON_RESERVED_Msk = 0xfffff000

	// GPREG0: General purpose register 0
	// Position of GPDATA field.
	PMU_GPREG_GPDATA_Pos = 0x0
	// Bit mask of GPDATA field.
	PMU_GPREG_GPDATA_Msk = 0xffffffff

	// GPREG4: General purpose register 4
	// Position of RESERVED field.
	PMU_GPREG4_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	PMU_GPREG4_RESERVED_Msk = 0x3ff
	// Position of WAKEUPHYS field.
	PMU_GPREG4_WAKEUPHYS_Pos = 0xa
	// Bit mask of WAKEUPHYS field.
	PMU_GPREG4_WAKEUPHYS_Msk = 0x400
	// Bit WAKEUPHYS.
	PMU_GPREG4_WAKEUPHYS = 0x400
	// Hysteresis for WAKEUP pin disabled.
	PMU_GPREG4_WAKEUPHYS_DISABLED = 0x0
	// Hysteresis for WAKEUP pin enabled.
	PMU_GPREG4_WAKEUPHYS_ENABLED = 0x1
	// Position of GPDATA field.
	PMU_GPREG4_GPDATA_Pos = 0xb
	// Bit mask of GPDATA field.
	PMU_GPREG4_GPDATA_Msk = 0xfffff800
)

// Bitfields for FLASHCTRL: Flash controller
const (
	// FLASHCFG: Flash memory access time configuration register
	// Position of FLASHTIM field.
	FLASHCTRL_FLASHCFG_FLASHTIM_Pos = 0x0
	// Bit mask of FLASHTIM field.
	FLASHCTRL_FLASHCFG_FLASHTIM_Msk = 0x3
	// 1 system clock flash access time (for system clock frequencies of up to 20 MHz).
	FLASHCTRL_FLASHCFG_FLASHTIM_1_SYSTEM_CLOCK_FLASH = 0x0
	// 2 system clocks flash access time (for system clock frequencies of up to 40 MHz).
	FLASHCTRL_FLASHCFG_FLASHTIM_2_SYSTEM_CLOCKS_FLAS = 0x1
	// 3 system clocks flash access time (for system clock frequencies of up to 50 MHz).
	FLASHCTRL_FLASHCFG_FLASHTIM_3_SYSTEM_CLOCKS_FLAS = 0x2
	// Position of RESERVED field.
	FLASHCTRL_FLASHCFG_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	FLASHCTRL_FLASHCFG_RESERVED_Msk = 0xfffffffc

	// FMSSTART: Signature start address register
	// Position of START field.
	FLASHCTRL_FMSSTART_START_Pos = 0x0
	// Bit mask of START field.
	FLASHCTRL_FMSSTART_START_Msk = 0x1ffff
	// Position of RESERVED field.
	FLASHCTRL_FMSSTART_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSSTART_RESERVED_Msk = 0xfffe0000

	// FMSSTOP: Signature stop-address register
	// Position of STOP field.
	FLASHCTRL_FMSSTOP_STOP_Pos = 0x0
	// Bit mask of STOP field.
	FLASHCTRL_FMSSTOP_STOP_Msk = 0x1ffff
	// Position of SIG_START field.
	FLASHCTRL_FMSSTOP_SIG_START_Pos = 0x11
	// Bit mask of SIG_START field.
	FLASHCTRL_FMSSTOP_SIG_START_Msk = 0x20000
	// Bit SIG_START.
	FLASHCTRL_FMSSTOP_SIG_START = 0x20000
	// Signature generation is stopped
	FLASHCTRL_FMSSTOP_SIG_START_SIGNATURE_GENERATION = 0x0
	// Initiate signature generation
	FLASHCTRL_FMSSTOP_SIG_START_INITIATE_SIGNATURE_G = 0x1
	// Position of RESERVED field.
	FLASHCTRL_FMSSTOP_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSSTOP_RESERVED_Msk = 0xfffc0000

	// FMSW0: Word 0 [31:0]
	// Position of SW0_31_0 field.
	FLASHCTRL_FMSW0_SW0_31_0_Pos = 0x0
	// Bit mask of SW0_31_0 field.
	FLASHCTRL_FMSW0_SW0_31_0_Msk = 0xffffffff

	// FMSW1: Word 1 [63:32]
	// Position of SW1_63_32 field.
	FLASHCTRL_FMSW1_SW1_63_32_Pos = 0x0
	// Bit mask of SW1_63_32 field.
	FLASHCTRL_FMSW1_SW1_63_32_Msk = 0xffffffff

	// FMSW2: Word 2 [95:64]
	// Position of SW2_95_64 field.
	FLASHCTRL_FMSW2_SW2_95_64_Pos = 0x0
	// Bit mask of SW2_95_64 field.
	FLASHCTRL_FMSW2_SW2_95_64_Msk = 0xffffffff

	// FMSW3: Word 3 [127:96]
	// Position of SW3_127_96 field.
	FLASHCTRL_FMSW3_SW3_127_96_Pos = 0x0
	// Bit mask of SW3_127_96 field.
	FLASHCTRL_FMSW3_SW3_127_96_Msk = 0xffffffff

	// EEMSSTART: EEPROM BIST start address register
	// Position of STARTA field.
	FLASHCTRL_EEMSSTART_STARTA_Pos = 0x0
	// Bit mask of STARTA field.
	FLASHCTRL_EEMSSTART_STARTA_Msk = 0x3fff
	// Position of RESERVED field.
	FLASHCTRL_EEMSSTART_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	FLASHCTRL_EEMSSTART_RESERVED_Msk = 0xffffc000

	// EEMSSTOP: EEPROM BIST stop address register
	// Position of STOPA field.
	FLASHCTRL_EEMSSTOP_STOPA_Pos = 0x0
	// Bit mask of STOPA field.
	FLASHCTRL_EEMSSTOP_STOPA_Msk = 0x3fff
	// Position of RESERVED field.
	FLASHCTRL_EEMSSTOP_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	FLASHCTRL_EEMSSTOP_RESERVED_Msk = 0x3fffc000
	// Position of DEVSEL field.
	FLASHCTRL_EEMSSTOP_DEVSEL_Pos = 0x1e
	// Bit mask of DEVSEL field.
	FLASHCTRL_EEMSSTOP_DEVSEL_Msk = 0x40000000
	// Bit DEVSEL.
	FLASHCTRL_EEMSSTOP_DEVSEL = 0x40000000
	// Position of STRTBIST field.
	FLASHCTRL_EEMSSTOP_STRTBIST_Pos = 0x1f
	// Bit mask of STRTBIST field.
	FLASHCTRL_EEMSSTOP_STRTBIST_Msk = 0x80000000
	// Bit STRTBIST.
	FLASHCTRL_EEMSSTOP_STRTBIST = 0x80000000

	// EEMSSIG: EEPROM 24-bit BIST signature register
	// Position of DATA_SIG field.
	FLASHCTRL_EEMSSIG_DATA_SIG_Pos = 0x0
	// Bit mask of DATA_SIG field.
	FLASHCTRL_EEMSSIG_DATA_SIG_Msk = 0xffff
	// Position of PARITY_SIG field.
	FLASHCTRL_EEMSSIG_PARITY_SIG_Pos = 0x10
	// Bit mask of PARITY_SIG field.
	FLASHCTRL_EEMSSIG_PARITY_SIG_Msk = 0xffff0000

	// FMSTAT: Signature generation status register
	// Position of RESERVED field.
	FLASHCTRL_FMSTAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSTAT_RESERVED_Msk = 0x3
	// Position of SIG_DONE field.
	FLASHCTRL_FMSTAT_SIG_DONE_Pos = 0x2
	// Bit mask of SIG_DONE field.
	FLASHCTRL_FMSTAT_SIG_DONE_Msk = 0x4
	// Bit SIG_DONE.
	FLASHCTRL_FMSTAT_SIG_DONE = 0x4
	// Position of RESERVED field.
	FLASHCTRL_FMSTAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSTAT_RESERVED_Msk = 0xfffffff8

	// FMSTATCLR: Signature generation status clear register
	// Position of RESERVED field.
	FLASHCTRL_FMSTATCLR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSTATCLR_RESERVED_Msk = 0x3
	// Position of SIG_DONE_CLR field.
	FLASHCTRL_FMSTATCLR_SIG_DONE_CLR_Pos = 0x2
	// Bit mask of SIG_DONE_CLR field.
	FLASHCTRL_FMSTATCLR_SIG_DONE_CLR_Msk = 0x4
	// Bit SIG_DONE_CLR.
	FLASHCTRL_FMSTATCLR_SIG_DONE_CLR = 0x4
	// Position of RESERVED field.
	FLASHCTRL_FMSTATCLR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSTATCLR_RESERVED_Msk = 0xfffffff8
)

// Bitfields for SSP0: SSP/SPI
const (
	// CR0: Control Register 0. Selects the serial clock rate, bus type, and data size.
	// Position of DSS field.
	SSP0_CR0_DSS_Pos = 0x0
	// Bit mask of DSS field.
	SSP0_CR0_DSS_Msk = 0xf
	// 4-bit transfer
	SSP0_CR0_DSS_4_BIT_TRANSFER = 0x3
	// 5-bit transfer
	SSP0_CR0_DSS_5_BIT_TRANSFER = 0x4
	// 6-bit transfer
	SSP0_CR0_DSS_6_BIT_TRANSFER = 0x5
	// 7-bit transfer
	SSP0_CR0_DSS_7_BIT_TRANSFER = 0x6
	// 8-bit transfer
	SSP0_CR0_DSS_8_BIT_TRANSFER = 0x7
	// 9-bit transfer
	SSP0_CR0_DSS_9_BIT_TRANSFER = 0x8
	// 10-bit transfer
	SSP0_CR0_DSS_10_BIT_TRANSFER = 0x9
	// 11-bit transfer
	SSP0_CR0_DSS_11_BIT_TRANSFER = 0xa
	// 12-bit transfer
	SSP0_CR0_DSS_12_BIT_TRANSFER = 0xb
	// 13-bit transfer
	SSP0_CR0_DSS_13_BIT_TRANSFER = 0xc
	// 14-bit transfer
	SSP0_CR0_DSS_14_BIT_TRANSFER = 0xd
	// 15-bit transfer
	SSP0_CR0_DSS_15_BIT_TRANSFER = 0xe
	// 16-bit transfer
	SSP0_CR0_DSS_16_BIT_TRANSFER = 0xf
	// Position of FRF field.
	SSP0_CR0_FRF_Pos = 0x4
	// Bit mask of FRF field.
	SSP0_CR0_FRF_Msk = 0x30
	// SPI
	SSP0_CR0_FRF_SPI = 0x0
	// TI
	SSP0_CR0_FRF_TI = 0x1
	// Microwire
	SSP0_CR0_FRF_MICROWIRE = 0x2
	// Position of CPOL field.
	SSP0_CR0_CPOL_Pos = 0x6
	// Bit mask of CPOL field.
	SSP0_CR0_CPOL_Msk = 0x40
	// Bit CPOL.
	SSP0_CR0_CPOL = 0x40
	// SPI controller maintains the bus clock low between frames.
	SSP0_CR0_CPOL_LOW = 0x0
	// SPI controller maintains the bus clock high between frames.
	SSP0_CR0_CPOL_HIGH = 0x1
	// Position of CPHA field.
	SSP0_CR0_CPHA_Pos = 0x7
	// Bit mask of CPHA field.
	SSP0_CR0_CPHA_Msk = 0x80
	// Bit CPHA.
	SSP0_CR0_CPHA = 0x80
	// SPI controller captures serial data on the first clock transition of the frame, that is, the transition away from the inter-frame state of the clock line.
	SSP0_CR0_CPHA_FIRSTCLOCK = 0x0
	// SPI controller captures serial data on the second clock transition of the frame, that is, the transition back to the inter-frame state of the clock line.
	SSP0_CR0_CPHA_SECONDCLOCK = 0x1
	// Position of SCR field.
	SSP0_CR0_SCR_Pos = 0x8
	// Bit mask of SCR field.
	SSP0_CR0_SCR_Msk = 0xff00
	// Position of RESERVED field.
	SSP0_CR0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SSP0_CR0_RESERVED_Msk = 0xffff0000

	// CR1: Control Register 1. Selects master/slave and other modes.
	// Position of LBM field.
	SSP0_CR1_LBM_Pos = 0x0
	// Bit mask of LBM field.
	SSP0_CR1_LBM_Msk = 0x1
	// Bit LBM.
	SSP0_CR1_LBM = 0x1
	// During normal operation.
	SSP0_CR1_LBM_DURING_NORMAL_OPERAT = 0x0
	// Serial input is taken from the serial output (MOSI or MISO) rather than the serial input pin (MISO or MOSI respectively).
	SSP0_CR1_LBM_SERIAL_INPUT_IS_TAKE = 0x1
	// Position of SSE field.
	SSP0_CR1_SSE_Pos = 0x1
	// Bit mask of SSE field.
	SSP0_CR1_SSE_Msk = 0x2
	// Bit SSE.
	SSP0_CR1_SSE = 0x2
	// The SPI controller is disabled.
	SSP0_CR1_SSE_DISABLED = 0x0
	// The SPI controller will interact with other devices on the serial bus. Software should write the appropriate control information to the other SSP/SPI registers and interrupt controller registers, before setting this bit.
	SSP0_CR1_SSE_ENABLED = 0x1
	// Position of MS field.
	SSP0_CR1_MS_Pos = 0x2
	// Bit mask of MS field.
	SSP0_CR1_MS_Msk = 0x4
	// Bit MS.
	SSP0_CR1_MS = 0x4
	// The SPI controller acts as a master on the bus, driving the SCLK, MOSI, and SSEL lines and receiving the MISO line.
	SSP0_CR1_MS_MASTER = 0x0
	// The SPI controller acts as a slave on the bus, driving MISO line and receiving SCLK, MOSI, and SSEL lines.
	SSP0_CR1_MS_SLAVE = 0x1
	// Position of SOD field.
	SSP0_CR1_SOD_Pos = 0x3
	// Bit mask of SOD field.
	SSP0_CR1_SOD_Msk = 0x8
	// Bit SOD.
	SSP0_CR1_SOD = 0x8
	// Position of RESERVED field.
	SSP0_CR1_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP0_CR1_RESERVED_Msk = 0xfffffff0

	// DR: Data Register. Writes fill the transmit FIFO, and reads empty the receive FIFO.
	// Position of DATA field.
	SSP0_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SSP0_DR_DATA_Msk = 0xffff
	// Position of RESERVED field.
	SSP0_DR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SSP0_DR_RESERVED_Msk = 0xffff0000

	// SR: Status Register
	// Position of TFE field.
	SSP0_SR_TFE_Pos = 0x0
	// Bit mask of TFE field.
	SSP0_SR_TFE_Msk = 0x1
	// Bit TFE.
	SSP0_SR_TFE = 0x1
	// Position of TNF field.
	SSP0_SR_TNF_Pos = 0x1
	// Bit mask of TNF field.
	SSP0_SR_TNF_Msk = 0x2
	// Bit TNF.
	SSP0_SR_TNF = 0x2
	// Position of RNE field.
	SSP0_SR_RNE_Pos = 0x2
	// Bit mask of RNE field.
	SSP0_SR_RNE_Msk = 0x4
	// Bit RNE.
	SSP0_SR_RNE = 0x4
	// Position of RFF field.
	SSP0_SR_RFF_Pos = 0x3
	// Bit mask of RFF field.
	SSP0_SR_RFF_Msk = 0x8
	// Bit RFF.
	SSP0_SR_RFF = 0x8
	// Position of BSY field.
	SSP0_SR_BSY_Pos = 0x4
	// Bit mask of BSY field.
	SSP0_SR_BSY_Msk = 0x10
	// Bit BSY.
	SSP0_SR_BSY = 0x10
	// Position of RESERVED field.
	SSP0_SR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SSP0_SR_RESERVED_Msk = 0xffffffe0

	// CPSR: Clock Prescale Register
	// Position of CPSDVSR field.
	SSP0_CPSR_CPSDVSR_Pos = 0x0
	// Bit mask of CPSDVSR field.
	SSP0_CPSR_CPSDVSR_Msk = 0xff
	// Position of RESERVED field.
	SSP0_CPSR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SSP0_CPSR_RESERVED_Msk = 0xffffff00

	// IMSC: Interrupt Mask Set and Clear Register
	// Position of RORIM field.
	SSP0_IMSC_RORIM_Pos = 0x0
	// Bit mask of RORIM field.
	SSP0_IMSC_RORIM_Msk = 0x1
	// Bit RORIM.
	SSP0_IMSC_RORIM = 0x1
	// Position of RTIM field.
	SSP0_IMSC_RTIM_Pos = 0x1
	// Bit mask of RTIM field.
	SSP0_IMSC_RTIM_Msk = 0x2
	// Bit RTIM.
	SSP0_IMSC_RTIM = 0x2
	// Position of RXIM field.
	SSP0_IMSC_RXIM_Pos = 0x2
	// Bit mask of RXIM field.
	SSP0_IMSC_RXIM_Msk = 0x4
	// Bit RXIM.
	SSP0_IMSC_RXIM = 0x4
	// Position of TXIM field.
	SSP0_IMSC_TXIM_Pos = 0x3
	// Bit mask of TXIM field.
	SSP0_IMSC_TXIM_Msk = 0x8
	// Bit TXIM.
	SSP0_IMSC_TXIM = 0x8
	// Position of RESERVED field.
	SSP0_IMSC_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP0_IMSC_RESERVED_Msk = 0xfffffff0

	// RIS: Raw Interrupt Status Register
	// Position of RORRIS field.
	SSP0_RIS_RORRIS_Pos = 0x0
	// Bit mask of RORRIS field.
	SSP0_RIS_RORRIS_Msk = 0x1
	// Bit RORRIS.
	SSP0_RIS_RORRIS = 0x1
	// Position of RTRIS field.
	SSP0_RIS_RTRIS_Pos = 0x1
	// Bit mask of RTRIS field.
	SSP0_RIS_RTRIS_Msk = 0x2
	// Bit RTRIS.
	SSP0_RIS_RTRIS = 0x2
	// Position of RXRIS field.
	SSP0_RIS_RXRIS_Pos = 0x2
	// Bit mask of RXRIS field.
	SSP0_RIS_RXRIS_Msk = 0x4
	// Bit RXRIS.
	SSP0_RIS_RXRIS = 0x4
	// Position of TXRIS field.
	SSP0_RIS_TXRIS_Pos = 0x3
	// Bit mask of TXRIS field.
	SSP0_RIS_TXRIS_Msk = 0x8
	// Bit TXRIS.
	SSP0_RIS_TXRIS = 0x8
	// Position of RESERVED field.
	SSP0_RIS_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP0_RIS_RESERVED_Msk = 0xfffffff0

	// MIS: Masked Interrupt Status Register
	// Position of RORMIS field.
	SSP0_MIS_RORMIS_Pos = 0x0
	// Bit mask of RORMIS field.
	SSP0_MIS_RORMIS_Msk = 0x1
	// Bit RORMIS.
	SSP0_MIS_RORMIS = 0x1
	// Position of RTMIS field.
	SSP0_MIS_RTMIS_Pos = 0x1
	// Bit mask of RTMIS field.
	SSP0_MIS_RTMIS_Msk = 0x2
	// Bit RTMIS.
	SSP0_MIS_RTMIS = 0x2
	// Position of RXMIS field.
	SSP0_MIS_RXMIS_Pos = 0x2
	// Bit mask of RXMIS field.
	SSP0_MIS_RXMIS_Msk = 0x4
	// Bit RXMIS.
	SSP0_MIS_RXMIS = 0x4
	// Position of TXMIS field.
	SSP0_MIS_TXMIS_Pos = 0x3
	// Bit mask of TXMIS field.
	SSP0_MIS_TXMIS_Msk = 0x8
	// Bit TXMIS.
	SSP0_MIS_TXMIS = 0x8
	// Position of RESERVED field.
	SSP0_MIS_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP0_MIS_RESERVED_Msk = 0xfffffff0

	// ICR: SSPICR Interrupt Clear Register
	// Position of RORIC field.
	SSP0_ICR_RORIC_Pos = 0x0
	// Bit mask of RORIC field.
	SSP0_ICR_RORIC_Msk = 0x1
	// Bit RORIC.
	SSP0_ICR_RORIC = 0x1
	// Position of RTIC field.
	SSP0_ICR_RTIC_Pos = 0x1
	// Bit mask of RTIC field.
	SSP0_ICR_RTIC_Msk = 0x2
	// Bit RTIC.
	SSP0_ICR_RTIC = 0x2
	// Position of RESERVED field.
	SSP0_ICR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SSP0_ICR_RESERVED_Msk = 0xfffffffc
)

// Bitfields for IOCON: I/O configuration Modification
const (
	// RESET_PIO0_0: I/O configuration for pin RESET/PIO0_0
	// Position of FUNC field.
	IOCON_RESET_PIO0_0_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_RESET_PIO0_0_FUNC_Msk = 0x7
	// RESET.
	IOCON_RESET_PIO0_0_FUNC_RESET_ = 0x0
	// PIO0_0.
	IOCON_RESET_PIO0_0_FUNC_PIO0_0_ = 0x1
	// Position of MODE field.
	IOCON_RESET_PIO0_0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_RESET_PIO0_0_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_RESET_PIO0_0_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_RESET_PIO0_0_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_RESET_PIO0_0_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_RESET_PIO0_0_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_RESET_PIO0_0_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_RESET_PIO0_0_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_RESET_PIO0_0_HYS = 0x20
	// Disable.
	IOCON_RESET_PIO0_0_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_RESET_PIO0_0_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_RESET_PIO0_0_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_RESET_PIO0_0_INV_Msk = 0x40
	// Bit INV.
	IOCON_RESET_PIO0_0_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_RESET_PIO0_0_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_RESET_PIO0_0_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_RESET_PIO0_0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_RESET_PIO0_0_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_RESET_PIO0_0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_RESET_PIO0_0_OD_Msk = 0x400
	// Bit OD.
	IOCON_RESET_PIO0_0_OD = 0x400
	// Disable.
	IOCON_RESET_PIO0_0_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_RESET_PIO0_0_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_RESET_PIO0_0_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_RESET_PIO0_0_RESERVED_Msk = 0xfffff800

	// PIO0_1: I/O configuration for pin PIO0_1/CLKOUT/CT32B0_MAT2/USB_FTOGGLE
	// Position of FUNC field.
	IOCON_PIO0_1_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_1_FUNC_Msk = 0x7
	// PIO0_1.
	IOCON_PIO0_1_FUNC_PIO0_1_ = 0x0
	// CLKOUT.
	IOCON_PIO0_1_FUNC_CLKOUT_ = 0x1
	// CT32B0_MAT2.
	IOCON_PIO0_1_FUNC_CT32B0_MAT2_ = 0x2
	// USB_FTOGGLE.
	IOCON_PIO0_1_FUNC_USB_FTOGGLE_ = 0x3
	// Position of MODE field.
	IOCON_PIO0_1_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_1_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_1_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_1_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_1_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_1_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_1_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_1_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_1_HYS = 0x20
	// Disable.
	IOCON_PIO0_1_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_1_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_1_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_1_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_1_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_1_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_1_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_1_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_1_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_1_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_1_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_1_OD = 0x400
	// Disable.
	IOCON_PIO0_1_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_1_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_1_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_1_RESERVED_Msk = 0xfffff800

	// PIO0_2: I/O configuration for pin PIO0_2/SSEL0/CT16B0_CAP0
	// Position of FUNC field.
	IOCON_PIO0_2_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_2_FUNC_Msk = 0x7
	// PIO0_2.
	IOCON_PIO0_2_FUNC_PIO0_2_ = 0x0
	// SSEL0.
	IOCON_PIO0_2_FUNC_SSEL0_ = 0x1
	// CT16B0_CAP0.
	IOCON_PIO0_2_FUNC_CT16B0_CAP0_ = 0x2
	// Position of MODE field.
	IOCON_PIO0_2_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_2_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_2_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_2_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_2_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_2_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_2_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_2_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_2_HYS = 0x20
	// Disable.
	IOCON_PIO0_2_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_2_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_2_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_2_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_2_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_2_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_2_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_2_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_2_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_2_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_2_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_2_OD = 0x400
	// Disable.
	IOCON_PIO0_2_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_2_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_2_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_2_RESERVED_Msk = 0xfffff800

	// PIO0_3: I/O configuration for pin PIO0_3/USB_VBUS
	// Position of FUNC field.
	IOCON_PIO0_3_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_3_FUNC_Msk = 0x7
	// PIO0_3.
	IOCON_PIO0_3_FUNC_PIO0_3_ = 0x0
	// USB_VBUS.
	IOCON_PIO0_3_FUNC_USB_VBUS_ = 0x1
	// Position of MODE field.
	IOCON_PIO0_3_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_3_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_3_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_3_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_3_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_3_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_3_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_3_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_3_HYS = 0x20
	// Disable.
	IOCON_PIO0_3_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_3_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_3_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_3_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_3_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_3_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_3_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_3_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_3_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_3_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_3_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_3_OD = 0x400
	// Disable.
	IOCON_PIO0_3_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_3_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_3_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_3_RESERVED_Msk = 0xfffff800

	// PIO0_4: I/O configuration for pin PIO0_4/SCL
	// Position of FUNC field.
	IOCON_PIO0_4_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_4_FUNC_Msk = 0x7
	// PIO0_4 (open-drain pin).
	IOCON_PIO0_4_FUNC_PIO0_4_OPEN_DRAIN_P = 0x0
	// I2C SCL (open-drain pin).
	IOCON_PIO0_4_FUNC_I2C_SCL_OPEN_DRAIN_ = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_4_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	IOCON_PIO0_4_RESERVED_Msk = 0xf8
	// Position of I2CMODE field.
	IOCON_PIO0_4_I2CMODE_Pos = 0x8
	// Bit mask of I2CMODE field.
	IOCON_PIO0_4_I2CMODE_Msk = 0x300
	// Standard mode/ Fast-mode I2C.
	IOCON_PIO0_4_I2CMODE_STANDARD_MODE_FAST_ = 0x0
	// Standard I/O functionality
	IOCON_PIO0_4_I2CMODE_STANDARD_IO_FUNCTIO = 0x1
	// Fast-mode Plus I2C
	IOCON_PIO0_4_I2CMODE_FAST_MODE_PLUS_I2C = 0x2
	// Reserved.
	IOCON_PIO0_4_I2CMODE_RESERVED_ = 0x3
	// Position of RESERVED field.
	IOCON_PIO0_4_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	IOCON_PIO0_4_RESERVED_Msk = 0xfffffc00

	// PIO0_5: I/O configuration for pin PIO0_5/SDA
	// Position of FUNC field.
	IOCON_PIO0_5_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_5_FUNC_Msk = 0x7
	// PIO0_5 (open-drain pin).
	IOCON_PIO0_5_FUNC_PIO0_5_OPEN_DRAIN_P = 0x0
	// I2C SDA (open-drain pin).
	IOCON_PIO0_5_FUNC_I2C_SDA_OPEN_DRAIN_ = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_5_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	IOCON_PIO0_5_RESERVED_Msk = 0xf8
	// Position of I2CMODE field.
	IOCON_PIO0_5_I2CMODE_Pos = 0x8
	// Bit mask of I2CMODE field.
	IOCON_PIO0_5_I2CMODE_Msk = 0x300
	// Standard mode/ Fast-mode I2C.
	IOCON_PIO0_5_I2CMODE_STANDARD_MODE_FAST_ = 0x0
	// Standard I/O functionality
	IOCON_PIO0_5_I2CMODE_STANDARD_IO_FUNCTIO = 0x1
	// Fast-mode Plus I2C
	IOCON_PIO0_5_I2CMODE_FAST_MODE_PLUS_I2C = 0x2
	// Reserved.
	IOCON_PIO0_5_I2CMODE_RESERVED_ = 0x3
	// Position of RESERVED field.
	IOCON_PIO0_5_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	IOCON_PIO0_5_RESERVED_Msk = 0xfffffc00

	// PIO0_6: I/O configuration for pin PIO0_6/USB_CONNECT/SCK0
	// Position of FUNC field.
	IOCON_PIO0_6_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_6_FUNC_Msk = 0x7
	// PIO0_6.
	IOCON_PIO0_6_FUNC_PIO0_6_ = 0x0
	// USB_CONNECT.
	IOCON_PIO0_6_FUNC_USB_CONNECT_ = 0x1
	// SCK0.
	IOCON_PIO0_6_FUNC_SCK0_ = 0x2
	// Position of MODE field.
	IOCON_PIO0_6_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_6_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_6_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_6_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_6_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_6_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_6_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_6_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_6_HYS = 0x20
	// Disable.
	IOCON_PIO0_6_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_6_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_6_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_6_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_6_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_6_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_6_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_6_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_6_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_6_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_6_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_6_OD = 0x400
	// Disable.
	IOCON_PIO0_6_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_6_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_6_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_6_RESERVED_Msk = 0xfffff800

	// PIO0_7: I/O configuration for pin PIO0_7/CTS
	// Position of FUNC field.
	IOCON_PIO0_7_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_7_FUNC_Msk = 0x7
	// PIO0_7.
	IOCON_PIO0_7_FUNC_PIO0_7_ = 0x0
	// CTS.
	IOCON_PIO0_7_FUNC_CTS_ = 0x1
	// Position of MODE field.
	IOCON_PIO0_7_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_7_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_7_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_7_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_7_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_7_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_7_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_7_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_7_HYS = 0x20
	// Disable.
	IOCON_PIO0_7_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_7_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_7_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_7_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_7_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_7_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_7_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_7_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_7_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_7_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_7_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_7_OD = 0x400
	// Disable.
	IOCON_PIO0_7_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_7_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_7_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_7_RESERVED_Msk = 0xfffff800

	// PIO0_8: I/O configuration for pin PIO0_8/MISO0/CT16B0_MAT0
	// Position of FUNC field.
	IOCON_PIO0_8_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_8_FUNC_Msk = 0x7
	// PIO0_8.
	IOCON_PIO0_8_FUNC_PIO0_8_ = 0x0
	// MISO0.
	IOCON_PIO0_8_FUNC_MISO0_ = 0x1
	// CT16B0_MAT0.
	IOCON_PIO0_8_FUNC_CT16B0_MAT0_ = 0x2
	// Position of MODE field.
	IOCON_PIO0_8_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_8_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_8_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_8_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_8_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_8_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_8_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_8_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_8_HYS = 0x20
	// Disable.
	IOCON_PIO0_8_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_8_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_8_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_8_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_8_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_8_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_8_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_8_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_8_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_8_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_8_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_8_OD = 0x400
	// Disable.
	IOCON_PIO0_8_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_8_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_8_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_8_RESERVED_Msk = 0xfffff800

	// PIO0_9: I/O configuration for pin PIO0_9/MOSI0/CT16B0_MAT1
	// Position of FUNC field.
	IOCON_PIO0_9_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_9_FUNC_Msk = 0x7
	// PIO0_9.
	IOCON_PIO0_9_FUNC_PIO0_9_ = 0x0
	// MOSI0.
	IOCON_PIO0_9_FUNC_MOSI0_ = 0x1
	// CT16B0_MAT1.
	IOCON_PIO0_9_FUNC_CT16B0_MAT1_ = 0x2
	// Position of MODE field.
	IOCON_PIO0_9_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_9_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_9_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_9_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_9_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_9_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_9_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_9_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_9_HYS = 0x20
	// Disable.
	IOCON_PIO0_9_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_9_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_9_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_9_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_9_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_9_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_9_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_9_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_9_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_9_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_9_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_9_OD = 0x400
	// Disable.
	IOCON_PIO0_9_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_9_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_9_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_9_RESERVED_Msk = 0xfffff800

	// SWCLK_PIO0_10: I/O configuration for pin SWCLK/PIO0_10/ SCK0/CT16B0_MAT2
	// Position of FUNC field.
	IOCON_SWCLK_PIO0_10_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_SWCLK_PIO0_10_FUNC_Msk = 0x7
	// SWCLK.
	IOCON_SWCLK_PIO0_10_FUNC_SWCLK_ = 0x0
	// PIO0_10.
	IOCON_SWCLK_PIO0_10_FUNC_PIO0_10_ = 0x1
	// SCK0.
	IOCON_SWCLK_PIO0_10_FUNC_SCK0_ = 0x2
	// CT16B0_MAT2.
	IOCON_SWCLK_PIO0_10_FUNC_CT16B0_MAT2_ = 0x3
	// Position of MODE field.
	IOCON_SWCLK_PIO0_10_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_SWCLK_PIO0_10_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_SWCLK_PIO0_10_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_SWCLK_PIO0_10_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_SWCLK_PIO0_10_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_SWCLK_PIO0_10_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_SWCLK_PIO0_10_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_SWCLK_PIO0_10_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_SWCLK_PIO0_10_HYS = 0x20
	// Disable.
	IOCON_SWCLK_PIO0_10_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_SWCLK_PIO0_10_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_SWCLK_PIO0_10_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_SWCLK_PIO0_10_INV_Msk = 0x40
	// Bit INV.
	IOCON_SWCLK_PIO0_10_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_SWCLK_PIO0_10_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_SWCLK_PIO0_10_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_SWCLK_PIO0_10_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_SWCLK_PIO0_10_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_SWCLK_PIO0_10_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_SWCLK_PIO0_10_OD_Msk = 0x400
	// Bit OD.
	IOCON_SWCLK_PIO0_10_OD = 0x400
	// Disable.
	IOCON_SWCLK_PIO0_10_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_SWCLK_PIO0_10_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_SWCLK_PIO0_10_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_SWCLK_PIO0_10_RESERVED_Msk = 0xfffff800

	// TDI_PIO0_11: I/O configuration for pin TDI/PIO0_11/AD0/CT32B0_MAT3
	// Position of FUNC field.
	IOCON_TDI_PIO0_11_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_TDI_PIO0_11_FUNC_Msk = 0x7
	// TDI.
	IOCON_TDI_PIO0_11_FUNC_TDI_ = 0x0
	// PIO0_11.
	IOCON_TDI_PIO0_11_FUNC_PIO0_11_ = 0x1
	// AD0.
	IOCON_TDI_PIO0_11_FUNC_AD0_ = 0x2
	// CT32B0_MAT3.
	IOCON_TDI_PIO0_11_FUNC_CT32B0_MAT3_ = 0x3
	// Position of MODE field.
	IOCON_TDI_PIO0_11_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_TDI_PIO0_11_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_TDI_PIO0_11_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_TDI_PIO0_11_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_TDI_PIO0_11_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_TDI_PIO0_11_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_TDI_PIO0_11_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_TDI_PIO0_11_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_TDI_PIO0_11_HYS = 0x20
	// Disable.
	IOCON_TDI_PIO0_11_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_TDI_PIO0_11_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_TDI_PIO0_11_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_TDI_PIO0_11_INV_Msk = 0x40
	// Bit INV.
	IOCON_TDI_PIO0_11_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_TDI_PIO0_11_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_TDI_PIO0_11_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_TDI_PIO0_11_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_TDI_PIO0_11_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_TDI_PIO0_11_ADMODE = 0x80
	// Analog input mode.
	IOCON_TDI_PIO0_11_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_TDI_PIO0_11_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_TDI_PIO0_11_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_TDI_PIO0_11_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_TDI_PIO0_11_FILTR = 0x100
	// Filter enabled.
	IOCON_TDI_PIO0_11_FILTR_FILTER_ENABLED_ = 0x0
	// Filter disabled.
	IOCON_TDI_PIO0_11_FILTR_FILTER_DISABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_TDI_PIO0_11_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_TDI_PIO0_11_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_TDI_PIO0_11_RESERVED = 0x200
	// Position of OD field.
	IOCON_TDI_PIO0_11_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_TDI_PIO0_11_OD_Msk = 0x400
	// Bit OD.
	IOCON_TDI_PIO0_11_OD = 0x400
	// Disable.
	IOCON_TDI_PIO0_11_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_TDI_PIO0_11_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_TDI_PIO0_11_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_TDI_PIO0_11_RESERVED_Msk = 0xfffff800

	// TMS_PIO0_12: I/O configuration for pin TMS/PIO0_12/AD1/CT32B1_CAP0
	// Position of FUNC field.
	IOCON_TMS_PIO0_12_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_TMS_PIO0_12_FUNC_Msk = 0x7
	// TMS.
	IOCON_TMS_PIO0_12_FUNC_TMS_ = 0x0
	// PIO0_12.
	IOCON_TMS_PIO0_12_FUNC_PIO0_12_ = 0x1
	// AD1.
	IOCON_TMS_PIO0_12_FUNC_AD1_ = 0x2
	// CT32B1_CAP0.
	IOCON_TMS_PIO0_12_FUNC_CT32B1_CAP0_ = 0x3
	// Position of MODE field.
	IOCON_TMS_PIO0_12_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_TMS_PIO0_12_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_TMS_PIO0_12_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_TMS_PIO0_12_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_TMS_PIO0_12_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_TMS_PIO0_12_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_TMS_PIO0_12_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_TMS_PIO0_12_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_TMS_PIO0_12_HYS = 0x20
	// Disable.
	IOCON_TMS_PIO0_12_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_TMS_PIO0_12_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_TMS_PIO0_12_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_TMS_PIO0_12_INV_Msk = 0x40
	// Bit INV.
	IOCON_TMS_PIO0_12_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_TMS_PIO0_12_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_TMS_PIO0_12_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_TMS_PIO0_12_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_TMS_PIO0_12_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_TMS_PIO0_12_ADMODE = 0x80
	// Analog input mode.
	IOCON_TMS_PIO0_12_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_TMS_PIO0_12_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_TMS_PIO0_12_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_TMS_PIO0_12_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_TMS_PIO0_12_FILTR = 0x100
	// Filter enabled.
	IOCON_TMS_PIO0_12_FILTR_FILTER_ENABLED_ = 0x0
	// Filter disabled.
	IOCON_TMS_PIO0_12_FILTR_FILTER_DISABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_TMS_PIO0_12_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_TMS_PIO0_12_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_TMS_PIO0_12_RESERVED = 0x200
	// Position of OD field.
	IOCON_TMS_PIO0_12_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_TMS_PIO0_12_OD_Msk = 0x400
	// Bit OD.
	IOCON_TMS_PIO0_12_OD = 0x400
	// Disable.
	IOCON_TMS_PIO0_12_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_TMS_PIO0_12_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_TMS_PIO0_12_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_TMS_PIO0_12_RESERVED_Msk = 0xfffff800

	// TDO_PIO0_13: I/O configuration for pin TDO/PIO0_13/AD2/CT32B1_MAT0
	// Position of FUNC field.
	IOCON_TDO_PIO0_13_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_TDO_PIO0_13_FUNC_Msk = 0x7
	// TDO.
	IOCON_TDO_PIO0_13_FUNC_TDO_ = 0x0
	// PIO0_13.
	IOCON_TDO_PIO0_13_FUNC_PIO0_13_ = 0x1
	// AD2.
	IOCON_TDO_PIO0_13_FUNC_AD2_ = 0x2
	// CT32B1_MAT0.
	IOCON_TDO_PIO0_13_FUNC_CT32B1_MAT0_ = 0x3
	// Position of MODE field.
	IOCON_TDO_PIO0_13_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_TDO_PIO0_13_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_TDO_PIO0_13_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_TDO_PIO0_13_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_TDO_PIO0_13_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_TDO_PIO0_13_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_TDO_PIO0_13_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_TDO_PIO0_13_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_TDO_PIO0_13_HYS = 0x20
	// Disable.
	IOCON_TDO_PIO0_13_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_TDO_PIO0_13_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_TDO_PIO0_13_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_TDO_PIO0_13_INV_Msk = 0x40
	// Bit INV.
	IOCON_TDO_PIO0_13_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_TDO_PIO0_13_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_TDO_PIO0_13_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_TDO_PIO0_13_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_TDO_PIO0_13_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_TDO_PIO0_13_ADMODE = 0x80
	// Analog input mode.
	IOCON_TDO_PIO0_13_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_TDO_PIO0_13_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_TDO_PIO0_13_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_TDO_PIO0_13_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_TDO_PIO0_13_FILTR = 0x100
	// Filter enabled.
	IOCON_TDO_PIO0_13_FILTR_FILTER_ENABLED_ = 0x0
	// Filter disabled.
	IOCON_TDO_PIO0_13_FILTR_FILTER_DISABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_TDO_PIO0_13_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_TDO_PIO0_13_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_TDO_PIO0_13_RESERVED = 0x200
	// Position of OD field.
	IOCON_TDO_PIO0_13_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_TDO_PIO0_13_OD_Msk = 0x400
	// Bit OD.
	IOCON_TDO_PIO0_13_OD = 0x400
	// Disable.
	IOCON_TDO_PIO0_13_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_TDO_PIO0_13_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_TDO_PIO0_13_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_TDO_PIO0_13_RESERVED_Msk = 0xfffff800

	// TRST_PIO0_14: I/O configuration for pin TRST/PIO0_14/AD3/CT32B1_MAT1
	// Position of FUNC field.
	IOCON_TRST_PIO0_14_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_TRST_PIO0_14_FUNC_Msk = 0x7
	// TRST.
	IOCON_TRST_PIO0_14_FUNC_TRST_ = 0x0
	// PIO0_14.
	IOCON_TRST_PIO0_14_FUNC_PIO0_14_ = 0x1
	// AD3.
	IOCON_TRST_PIO0_14_FUNC_AD3_ = 0x2
	// CT32B1_MAT1.
	IOCON_TRST_PIO0_14_FUNC_CT32B1_MAT1_ = 0x3
	// Position of MODE field.
	IOCON_TRST_PIO0_14_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_TRST_PIO0_14_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_TRST_PIO0_14_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_TRST_PIO0_14_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_TRST_PIO0_14_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_TRST_PIO0_14_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_TRST_PIO0_14_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_TRST_PIO0_14_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_TRST_PIO0_14_HYS = 0x20
	// Disable.
	IOCON_TRST_PIO0_14_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_TRST_PIO0_14_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_TRST_PIO0_14_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_TRST_PIO0_14_INV_Msk = 0x40
	// Bit INV.
	IOCON_TRST_PIO0_14_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_TRST_PIO0_14_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_TRST_PIO0_14_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_TRST_PIO0_14_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_TRST_PIO0_14_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_TRST_PIO0_14_ADMODE = 0x80
	// Analog input mode.
	IOCON_TRST_PIO0_14_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_TRST_PIO0_14_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_TRST_PIO0_14_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_TRST_PIO0_14_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_TRST_PIO0_14_FILTR = 0x100
	// Filter enabled.
	IOCON_TRST_PIO0_14_FILTR_FILTER_ENABLED_ = 0x0
	// Filter disabled.
	IOCON_TRST_PIO0_14_FILTR_FILTER_DISABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_TRST_PIO0_14_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_TRST_PIO0_14_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_TRST_PIO0_14_RESERVED = 0x200
	// Position of OD field.
	IOCON_TRST_PIO0_14_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_TRST_PIO0_14_OD_Msk = 0x400
	// Bit OD.
	IOCON_TRST_PIO0_14_OD = 0x400
	// Disable.
	IOCON_TRST_PIO0_14_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_TRST_PIO0_14_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_TRST_PIO0_14_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_TRST_PIO0_14_RESERVED_Msk = 0xfffff800

	// SWDIO_PIO0_15: I/O configuration for pin SWDIO/PIO0_15/AD4/CT32B1_MAT2
	// Position of FUNC field.
	IOCON_SWDIO_PIO0_15_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_SWDIO_PIO0_15_FUNC_Msk = 0x7
	// SWDIO.
	IOCON_SWDIO_PIO0_15_FUNC_SWDIO_ = 0x0
	// PIO0_15.
	IOCON_SWDIO_PIO0_15_FUNC_PIO0_15_ = 0x1
	// AD4.
	IOCON_SWDIO_PIO0_15_FUNC_AD4_ = 0x2
	// CT32B1_MAT2.
	IOCON_SWDIO_PIO0_15_FUNC_CT32B1_MAT2_ = 0x3
	// Position of MODE field.
	IOCON_SWDIO_PIO0_15_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_SWDIO_PIO0_15_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_SWDIO_PIO0_15_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_SWDIO_PIO0_15_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_SWDIO_PIO0_15_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_SWDIO_PIO0_15_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_SWDIO_PIO0_15_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_SWDIO_PIO0_15_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_SWDIO_PIO0_15_HYS = 0x20
	// Disable.
	IOCON_SWDIO_PIO0_15_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_SWDIO_PIO0_15_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_SWDIO_PIO0_15_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_SWDIO_PIO0_15_INV_Msk = 0x40
	// Bit INV.
	IOCON_SWDIO_PIO0_15_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_SWDIO_PIO0_15_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_SWDIO_PIO0_15_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_SWDIO_PIO0_15_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_SWDIO_PIO0_15_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_SWDIO_PIO0_15_ADMODE = 0x80
	// Analog input mode.
	IOCON_SWDIO_PIO0_15_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_SWDIO_PIO0_15_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_SWDIO_PIO0_15_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_SWDIO_PIO0_15_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_SWDIO_PIO0_15_FILTR = 0x100
	// Filter enabled.
	IOCON_SWDIO_PIO0_15_FILTR_FILTER_ENABLED_ = 0x0
	// Filter disabled.
	IOCON_SWDIO_PIO0_15_FILTR_FILTER_DISABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_SWDIO_PIO0_15_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_SWDIO_PIO0_15_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_SWDIO_PIO0_15_RESERVED = 0x200
	// Position of OD field.
	IOCON_SWDIO_PIO0_15_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_SWDIO_PIO0_15_OD_Msk = 0x400
	// Bit OD.
	IOCON_SWDIO_PIO0_15_OD = 0x400
	// Disable.
	IOCON_SWDIO_PIO0_15_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_SWDIO_PIO0_15_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_SWDIO_PIO0_15_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_SWDIO_PIO0_15_RESERVED_Msk = 0xfffff800

	// PIO0_16: I/O configuration for pin PIO0_16/AD5/CT32B1_MAT3/ WAKEUP
	// Position of FUNC field.
	IOCON_PIO0_16_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_16_FUNC_Msk = 0x7
	// PIO0_16.
	IOCON_PIO0_16_FUNC_PIO0_16_ = 0x0
	// AD5.
	IOCON_PIO0_16_FUNC_AD5_ = 0x1
	// CT32B1_MAT3.
	IOCON_PIO0_16_FUNC_CT32B1_MAT3_ = 0x2
	// Position of MODE field.
	IOCON_PIO0_16_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_16_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_16_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_16_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_16_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_16_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_16_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_16_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_16_HYS = 0x20
	// Disable.
	IOCON_PIO0_16_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_16_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_16_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_16_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_16_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_16_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_16_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_PIO0_16_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_PIO0_16_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_PIO0_16_ADMODE = 0x80
	// Analog input mode.
	IOCON_PIO0_16_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_PIO0_16_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_PIO0_16_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_PIO0_16_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_PIO0_16_FILTR = 0x100
	// Filter enabled.
	IOCON_PIO0_16_FILTR_FILTER_ENABLED_ = 0x0
	// Filter disabled.
	IOCON_PIO0_16_FILTR_FILTER_DISABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_16_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_PIO0_16_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_PIO0_16_RESERVED = 0x200
	// Position of OD field.
	IOCON_PIO0_16_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_16_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_16_OD = 0x400
	// Disable.
	IOCON_PIO0_16_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_16_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_16_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_16_RESERVED_Msk = 0xfffff800

	// PIO0_17: I/O configuration for pin PIO0_17/RTS/CT32B0_CAP0/SCLK
	// Position of FUNC field.
	IOCON_PIO0_17_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_17_FUNC_Msk = 0x7
	// PIO0_17.
	IOCON_PIO0_17_FUNC_PIO0_17_ = 0x0
	// RTS.
	IOCON_PIO0_17_FUNC_RTS_ = 0x1
	// CT32B0_CAP0.
	IOCON_PIO0_17_FUNC_CT32B0_CAP0_ = 0x2
	// SCLK (UART synchronous clock).
	IOCON_PIO0_17_FUNC_SCLK_UART_SYNCHRONO = 0x3
	// Position of MODE field.
	IOCON_PIO0_17_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_17_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_17_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_17_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_17_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_17_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_17_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_17_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_17_HYS = 0x20
	// Disable.
	IOCON_PIO0_17_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_17_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_17_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_17_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_17_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_17_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_17_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_17_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_17_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_17_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_17_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_17_OD = 0x400
	// Disable.
	IOCON_PIO0_17_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_17_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_17_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_17_RESERVED_Msk = 0xfffff800

	// PIO0_18: I/O configuration for pin PIO0_18/RXD/CT32B0_MAT0
	// Position of FUNC field.
	IOCON_PIO0_18_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_18_FUNC_Msk = 0x7
	// PIO0_18.
	IOCON_PIO0_18_FUNC_PIO0_18_ = 0x0
	// RXD.
	IOCON_PIO0_18_FUNC_RXD_ = 0x1
	// CT32B0_MAT0.
	IOCON_PIO0_18_FUNC_CT32B0_MAT0_ = 0x2
	// Position of MODE field.
	IOCON_PIO0_18_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_18_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_18_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_18_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_18_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_18_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_18_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_18_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_18_HYS = 0x20
	// Disable.
	IOCON_PIO0_18_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_18_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_18_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_18_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_18_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_18_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_18_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_18_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_18_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_18_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_18_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_18_OD = 0x400
	// Disable.
	IOCON_PIO0_18_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_18_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_18_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_18_RESERVED_Msk = 0xfffff800

	// PIO0_19: I/O configuration for pin PIO0_19/TXD/CT32B0_MAT1
	// Position of FUNC field.
	IOCON_PIO0_19_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_19_FUNC_Msk = 0x7
	// PIO0_19.
	IOCON_PIO0_19_FUNC_PIO0_19_ = 0x0
	// TXD.
	IOCON_PIO0_19_FUNC_TXD_ = 0x1
	// CT32B0_MAT1.
	IOCON_PIO0_19_FUNC_CT32B0_MAT1_ = 0x2
	// Position of MODE field.
	IOCON_PIO0_19_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_19_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_19_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_19_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_19_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_19_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_19_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_19_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_19_HYS = 0x20
	// Disable.
	IOCON_PIO0_19_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_19_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_19_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_19_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_19_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_19_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_19_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_19_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_19_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_19_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_19_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_19_OD = 0x400
	// Disable.
	IOCON_PIO0_19_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_19_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_19_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_19_RESERVED_Msk = 0xfffff800

	// PIO0_20: I/O configuration for pin PIO0_20/CT16B1_CAP0
	// Position of FUNC field.
	IOCON_PIO0_20_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_20_FUNC_Msk = 0x7
	// PIO0_20.
	IOCON_PIO0_20_FUNC_PIO0_20_ = 0x0
	// CT16B1_CAP0.
	IOCON_PIO0_20_FUNC_CT16B1_CAP0_ = 0x1
	// Position of MODE field.
	IOCON_PIO0_20_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_20_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_20_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_20_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_20_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_20_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_20_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_20_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_20_HYS = 0x20
	// Disable.
	IOCON_PIO0_20_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_20_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_20_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_20_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_20_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_20_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_20_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_20_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_20_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_20_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_20_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_20_OD = 0x400
	// Disable.
	IOCON_PIO0_20_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_20_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_20_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_20_RESERVED_Msk = 0xfffff800

	// PIO0_21: I/O configuration for pin PIO0_21/CT16B1_MAT0/MOSI1
	// Position of FUNC field.
	IOCON_PIO0_21_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_21_FUNC_Msk = 0x7
	// PIO0_21.
	IOCON_PIO0_21_FUNC_PIO0_21_ = 0x0
	// CT16B1_MAT0.
	IOCON_PIO0_21_FUNC_CT16B1_MAT0_ = 0x1
	// MOSI1.
	IOCON_PIO0_21_FUNC_MOSI1_ = 0x2
	// Position of MODE field.
	IOCON_PIO0_21_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_21_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_21_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_21_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_21_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_21_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_21_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_21_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_21_HYS = 0x20
	// Disable.
	IOCON_PIO0_21_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_21_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_21_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_21_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_21_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_21_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_21_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_21_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_21_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_21_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_21_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_21_OD = 0x400
	// Disable.
	IOCON_PIO0_21_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_21_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_21_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_21_RESERVED_Msk = 0xfffff800

	// PIO0_22: I/O configuration for pin PIO0_22/AD6/CT16B1_MAT1/MISO1
	// Position of FUNC field.
	IOCON_PIO0_22_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_22_FUNC_Msk = 0x7
	// PIO0_22.
	IOCON_PIO0_22_FUNC_PIO0_22_ = 0x0
	// AD6.
	IOCON_PIO0_22_FUNC_AD6_ = 0x1
	// CT16B1_MAT1.
	IOCON_PIO0_22_FUNC_CT16B1_MAT1_ = 0x2
	// MISO1.
	IOCON_PIO0_22_FUNC_MISO1_ = 0x3
	// Position of MODE field.
	IOCON_PIO0_22_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_22_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_22_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_22_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_22_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_22_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_22_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_22_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_22_HYS = 0x20
	// Disable.
	IOCON_PIO0_22_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_22_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_22_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_22_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_22_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_22_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_22_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_PIO0_22_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_PIO0_22_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_PIO0_22_ADMODE = 0x80
	// Analog input mode.
	IOCON_PIO0_22_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_PIO0_22_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_PIO0_22_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_PIO0_22_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_PIO0_22_FILTR = 0x100
	// Filter enabled.
	IOCON_PIO0_22_FILTR_FILTER_ENABLED_ = 0x0
	// Filter disabled.
	IOCON_PIO0_22_FILTR_FILTER_DISABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_22_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_PIO0_22_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_PIO0_22_RESERVED = 0x200
	// Position of OD field.
	IOCON_PIO0_22_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_22_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_22_OD = 0x400
	// Disable.
	IOCON_PIO0_22_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_22_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_22_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_22_RESERVED_Msk = 0xfffff800

	// PIO0_23: I/O configuration for pin PIO0_23/AD7
	// Position of FUNC field.
	IOCON_PIO0_23_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_23_FUNC_Msk = 0x7
	// PIO0_23.
	IOCON_PIO0_23_FUNC_PIO0_23_ = 0x0
	// AD7.
	IOCON_PIO0_23_FUNC_AD7_ = 0x1
	// Position of MODE field.
	IOCON_PIO0_23_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_23_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_23_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_23_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_23_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_23_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_23_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_23_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_23_HYS = 0x20
	// Disable.
	IOCON_PIO0_23_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_23_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_23_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_23_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_23_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_23_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_23_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_PIO0_23_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_PIO0_23_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_PIO0_23_ADMODE = 0x80
	// Analog input mode.
	IOCON_PIO0_23_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_PIO0_23_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_PIO0_23_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_PIO0_23_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_PIO0_23_FILTR = 0x100
	// Filter enabled.
	IOCON_PIO0_23_FILTR_FILTER_ENABLED_ = 0x0
	// Filter disabled.
	IOCON_PIO0_23_FILTR_FILTER_DISABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_23_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_PIO0_23_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_PIO0_23_RESERVED = 0x200
	// Position of OD field.
	IOCON_PIO0_23_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_23_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_23_OD = 0x400
	// Disable.
	IOCON_PIO0_23_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_23_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_23_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_23_RESERVED_Msk = 0xfffff800

	// PIO1_0: I/O configuration for pin PIO1_0/CT32B1_MAT0
	// Position of FUNC field.
	IOCON_PIO1_0_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_0_FUNC_Msk = 0x7
	// PIO1_0.
	IOCON_PIO1_0_FUNC_PIO1_0_ = 0x0
	// CT32B1_MAT1.
	IOCON_PIO1_0_FUNC_CT32B1_MAT1_ = 0x1
	// Position of MODE field.
	IOCON_PIO1_0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_0_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_0_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_0_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_0_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_0_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_0_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_0_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_0_HYS = 0x20
	// Disable.
	IOCON_PIO1_0_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_0_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_0_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_0_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_0_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_0_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_0_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_0_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_0_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_0_OD = 0x400
	// Disable.
	IOCON_PIO1_0_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_0_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_0_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_0_RESERVED_Msk = 0xfffff800

	// PIO1_1: I/O configuration for pin PIO1_1/CT32B1_MAT1
	// Position of FUNC field.
	IOCON_PIO1_1_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_1_FUNC_Msk = 0x7
	// PIO1_1.
	IOCON_PIO1_1_FUNC_PIO1_1_ = 0x0
	// CT32B1_MAT1.
	IOCON_PIO1_1_FUNC_CT32B1_MAT1_ = 0x1
	// Position of MODE field.
	IOCON_PIO1_1_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_1_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_1_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_1_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_1_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_1_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_1_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_1_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_1_HYS = 0x20
	// Disable.
	IOCON_PIO1_1_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_1_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_1_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_1_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_1_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_1_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_1_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_1_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_1_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_1_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_1_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_1_OD = 0x400
	// Disable.
	IOCON_PIO1_1_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_1_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_1_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_1_RESERVED_Msk = 0xfffff800

	// PIO1_2: I/O configuration for pin PIO1_2/CT32B1_MAT2
	// Position of FUNC field.
	IOCON_PIO1_2_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_2_FUNC_Msk = 0x7
	// PIO1_2.
	IOCON_PIO1_2_FUNC_PIO1_2_ = 0x0
	// CT32B1_MAT2.
	IOCON_PIO1_2_FUNC_CT32B1_MAT2_ = 0x1
	// Position of MODE field.
	IOCON_PIO1_2_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_2_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_2_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_2_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_2_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_2_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_2_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_2_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_2_HYS = 0x20
	// Disable.
	IOCON_PIO1_2_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_2_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_2_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_2_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_2_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_2_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_2_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_2_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_2_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_2_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_2_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_2_OD = 0x400
	// Disable.
	IOCON_PIO1_2_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_2_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_2_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_2_RESERVED_Msk = 0xfffff800

	// PIO1_3: I/O configuration for pin PIO1_3/CT32B1_MAT3
	// Position of FUNC field.
	IOCON_PIO1_3_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_3_FUNC_Msk = 0x7
	// PIO1_3.
	IOCON_PIO1_3_FUNC_PIO1_3_ = 0x0
	// CT32B1_MAT3.
	IOCON_PIO1_3_FUNC_CT32B1_MAT3_ = 0x1
	// Position of MODE field.
	IOCON_PIO1_3_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_3_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_3_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_3_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_3_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_3_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_3_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_3_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_3_HYS = 0x20
	// Disable.
	IOCON_PIO1_3_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_3_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_3_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_3_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_3_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_3_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_3_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_3_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_3_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_3_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_3_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_3_OD = 0x400
	// Disable.
	IOCON_PIO1_3_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_3_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_3_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_3_RESERVED_Msk = 0xfffff800

	// PIO1_4: I/O configuration for pin PIO1_4/CT32B1_CAP0
	// Position of FUNC field.
	IOCON_PIO1_4_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_4_FUNC_Msk = 0x7
	// PIO1_4.
	IOCON_PIO1_4_FUNC_PIO1_4_ = 0x0
	// CT32B1_CAP0.
	IOCON_PIO1_4_FUNC_CT32B1_CAP0_ = 0x1
	// Position of MODE field.
	IOCON_PIO1_4_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_4_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_4_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_4_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_4_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_4_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_4_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_4_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_4_HYS = 0x20
	// Disable.
	IOCON_PIO1_4_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_4_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_4_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_4_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_4_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_4_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_4_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_4_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_4_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_4_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_4_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_4_OD = 0x400
	// Disable.
	IOCON_PIO1_4_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_4_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_4_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_4_RESERVED_Msk = 0xfffff800

	// PIO1_5: I/O configuration for pin PIO1_5/CT32B1_CAP1
	// Position of FUNC field.
	IOCON_PIO1_5_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_5_FUNC_Msk = 0x7
	// PIO1_5.
	IOCON_PIO1_5_FUNC_PIO1_5_ = 0x0
	// CT32B1_CAP1.
	IOCON_PIO1_5_FUNC_CT32B1_CAP1_ = 0x1
	// Position of MODE field.
	IOCON_PIO1_5_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_5_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_5_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_5_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_5_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_5_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_5_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_5_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_5_HYS = 0x20
	// Disable.
	IOCON_PIO1_5_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_5_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_5_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_5_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_5_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_5_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_5_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_5_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_5_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_5_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_5_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_5_OD = 0x400
	// Disable.
	IOCON_PIO1_5_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO1_5_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_5_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_5_RESERVED_Msk = 0xfffff800

	// PIO1_6: I/O configuration for pin PIO1_6
	// Position of FUNC field.
	IOCON_PIO1_6_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_6_FUNC_Msk = 0x7
	// PIO1_6.
	IOCON_PIO1_6_FUNC_PIO1_6_ = 0x0
	// Position of MODE field.
	IOCON_PIO1_6_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_6_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_6_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_6_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_6_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_6_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_6_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_6_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_6_HYS = 0x20
	// Disable.
	IOCON_PIO1_6_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_6_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_6_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_6_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_6_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_6_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_6_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_6_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_6_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_6_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_6_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_6_OD = 0x400
	// Disable.
	IOCON_PIO1_6_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_6_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_6_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_6_RESERVED_Msk = 0xfffff800

	// PIO1_7: I/O configuration for pin PIO1_7
	// Position of FUNC field.
	IOCON_PIO1_7_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_7_FUNC_Msk = 0x7
	// PIO1_7.
	IOCON_PIO1_7_FUNC_PIO1_7_ = 0x0
	// Position of MODE field.
	IOCON_PIO1_7_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_7_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_7_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_7_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_7_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_7_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_7_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_7_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_7_HYS = 0x20
	// Disable.
	IOCON_PIO1_7_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_7_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_7_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_7_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_7_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_7_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_7_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_7_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_7_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_7_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_7_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_7_OD = 0x400
	// Disable.
	IOCON_PIO1_7_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_7_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_7_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_7_RESERVED_Msk = 0xfffff800

	// PIO1_8: I/O configuration for pin PIO1_8
	// Position of FUNC field.
	IOCON_PIO1_8_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_8_FUNC_Msk = 0x7
	// PIO1_8.
	IOCON_PIO1_8_FUNC_PIO1_8_ = 0x0
	// Position of MODE field.
	IOCON_PIO1_8_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_8_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_8_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_8_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_8_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_8_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_8_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_8_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_8_HYS = 0x20
	// Disable.
	IOCON_PIO1_8_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_8_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_8_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_8_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_8_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_8_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_8_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_8_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_8_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_8_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_8_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_8_OD = 0x400
	// Disable.
	IOCON_PIO1_8_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_8_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_8_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_8_RESERVED_Msk = 0xfffff800

	// PIO1_9: I/O configuration for pin PIO1_9
	// Position of FUNC field.
	IOCON_PIO1_9_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_9_FUNC_Msk = 0x7
	// PIO1_9.
	IOCON_PIO1_9_FUNC_PIO1_9_ = 0x0
	// Position of MODE field.
	IOCON_PIO1_9_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_9_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_9_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_9_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_9_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_9_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_9_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_9_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_9_HYS = 0x20
	// Disable.
	IOCON_PIO1_9_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_9_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_9_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_9_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_9_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_9_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_9_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_9_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_9_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_9_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_9_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_9_OD = 0x400
	// Disable.
	IOCON_PIO1_9_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_9_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_9_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_9_RESERVED_Msk = 0xfffff800

	// PIO1_10: I/O configuration for pin PIO1_10
	// Position of FUNC field.
	IOCON_PIO1_10_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_10_FUNC_Msk = 0x7
	// PIO1_10.
	IOCON_PIO1_10_FUNC_PIO1_10_ = 0x0
	// Position of MODE field.
	IOCON_PIO1_10_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_10_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_10_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_10_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_10_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_10_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_10_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_10_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_10_HYS = 0x20
	// Disable.
	IOCON_PIO1_10_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_10_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_10_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_10_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_10_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_10_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_10_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_10_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_10_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_10_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_10_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_10_OD = 0x400
	// Disable.
	IOCON_PIO1_10_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_10_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_10_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_10_RESERVED_Msk = 0xfffff800

	// PIO1_11: I/O configuration for pin PIO1_11
	// Position of FUNC field.
	IOCON_PIO1_11_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_11_FUNC_Msk = 0x7
	// PIO1_11.
	IOCON_PIO1_11_FUNC_PIO1_11_ = 0x0
	// Position of MODE field.
	IOCON_PIO1_11_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_11_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_11_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_11_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_11_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_11_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_11_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_11_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_11_HYS = 0x20
	// Disable.
	IOCON_PIO1_11_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_11_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_11_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_11_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_11_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_11_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_11_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_11_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_11_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_11_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_11_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_11_OD = 0x400
	// Disable.
	IOCON_PIO1_11_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_11_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_11_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_11_RESERVED_Msk = 0xfffff800

	// PIO1_12: I/O configuration for pin PIO1_12
	// Position of FUNC field.
	IOCON_PIO1_12_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_12_FUNC_Msk = 0x7
	// PIO1_12.
	IOCON_PIO1_12_FUNC_PIO1_12_ = 0x0
	// Position of MODE field.
	IOCON_PIO1_12_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_12_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_12_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_12_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_12_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_12_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_12_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_12_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_12_HYS = 0x20
	// Disable.
	IOCON_PIO1_12_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_12_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_12_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_12_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_12_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_12_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_12_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_12_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_12_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_12_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_12_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_12_OD = 0x400
	// Disable.
	IOCON_PIO1_12_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_12_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_12_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_12_RESERVED_Msk = 0xfffff800

	// PIO1_13: I/O configuration for pin PIO1_13/DTR/CT16B0_MAT0/TXD
	// Position of FUNC field.
	IOCON_PIO1_13_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_13_FUNC_Msk = 0x7
	// PIO1_13.
	IOCON_PIO1_13_FUNC_PIO1_13_ = 0x0
	// DTR.
	IOCON_PIO1_13_FUNC_DTR_ = 0x1
	// CT16B0_MAT0.
	IOCON_PIO1_13_FUNC_CT16B0_MAT0_ = 0x2
	// TXD.
	IOCON_PIO1_13_FUNC_TXD_ = 0x3
	// Position of MODE field.
	IOCON_PIO1_13_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_13_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_13_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_13_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_13_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_13_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_13_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_13_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_13_HYS = 0x20
	// Disable.
	IOCON_PIO1_13_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_13_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_13_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_13_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_13_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_13_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_13_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_13_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_13_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_13_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_13_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_13_OD = 0x400
	// Disable.
	IOCON_PIO1_13_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO1_13_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_13_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_13_RESERVED_Msk = 0xfffff800

	// PIO1_14: I/O configuration for pin PIO1_14/DSR/CT16B0_MAT1/RXD
	// Position of FUNC field.
	IOCON_PIO1_14_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_14_FUNC_Msk = 0x7
	// PIO1_14.
	IOCON_PIO1_14_FUNC_PIO1_14_ = 0x0
	// DSR.
	IOCON_PIO1_14_FUNC_DSR_ = 0x1
	// CT16B0_MAT1.
	IOCON_PIO1_14_FUNC_CT16B0_MAT1_ = 0x2
	// RXD.
	IOCON_PIO1_14_FUNC_RXD_ = 0x3
	// Position of MODE field.
	IOCON_PIO1_14_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_14_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_14_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_14_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_14_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_14_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_14_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_14_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_14_HYS = 0x20
	// Disable.
	IOCON_PIO1_14_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_14_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_14_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_14_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_14_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_14_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_14_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_14_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_14_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_14_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_14_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_14_OD = 0x400
	// Disable.
	IOCON_PIO1_14_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO1_14_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_14_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_14_RESERVED_Msk = 0xfffff800

	// PIO1_15: I/O configuration for pin PIO1_15/DCD/ CT16B0_MAT2/SCK1
	// Position of FUNC field.
	IOCON_PIO1_15_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_15_FUNC_Msk = 0x7
	// PIO1_15.
	IOCON_PIO1_15_FUNC_PIO1_15_ = 0x0
	// DCD.
	IOCON_PIO1_15_FUNC_DCD_ = 0x1
	// CT16B0_MAT2.
	IOCON_PIO1_15_FUNC_CT16B0_MAT2_ = 0x2
	// SCK1.
	IOCON_PIO1_15_FUNC_SCK1_ = 0x3
	// Position of MODE field.
	IOCON_PIO1_15_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_15_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_15_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_15_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_15_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_15_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_15_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_15_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_15_HYS = 0x20
	// Disable.
	IOCON_PIO1_15_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_15_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_15_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_15_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_15_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_15_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_15_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_15_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_15_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_15_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_15_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_15_OD = 0x400
	// Disable.
	IOCON_PIO1_15_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO1_15_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_15_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_15_RESERVED_Msk = 0xfffff800

	// PIO1_16: I/O configuration for pin PIO1_16/RI/CT16B0_CAP0
	// Position of FUNC field.
	IOCON_PIO1_16_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_16_FUNC_Msk = 0x7
	// PIO1_16.
	IOCON_PIO1_16_FUNC_PIO1_16_ = 0x0
	// RI.
	IOCON_PIO1_16_FUNC_RI_ = 0x1
	// CT16B0_CAP0.
	IOCON_PIO1_16_FUNC_CT16B0_CAP0_ = 0x2
	// Position of MODE field.
	IOCON_PIO1_16_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_16_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_16_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_16_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_16_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_16_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_16_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_16_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_16_HYS = 0x20
	// Disable.
	IOCON_PIO1_16_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_16_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_16_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_16_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_16_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_16_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_16_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_16_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_16_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_16_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_16_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_16_OD = 0x400
	// Disable.
	IOCON_PIO1_16_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO1_16_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_16_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_16_RESERVED_Msk = 0xfffff800

	// PIO1_17: I/O configuration for PIO1_17/CT16B0_CAP1/RXD
	// Position of FUNC field.
	IOCON_PIO1_17_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_17_FUNC_Msk = 0x7
	// PIO1_17.
	IOCON_PIO1_17_FUNC_PIO1_17_ = 0x0
	// CT16B0_CAP1
	IOCON_PIO1_17_FUNC_CT16B0_CAP1 = 0x1
	// RXD
	IOCON_PIO1_17_FUNC_RXD = 0x2
	// Position of MODE field.
	IOCON_PIO1_17_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_17_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_17_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_17_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_17_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_17_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_17_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_17_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_17_HYS = 0x20
	// Disable.
	IOCON_PIO1_17_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_17_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_17_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_17_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_17_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_17_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_17_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_17_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_17_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_17_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_17_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_17_OD = 0x400
	// Disable.
	IOCON_PIO1_17_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_17_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_17_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_17_RESERVED_Msk = 0xfffff800

	// PIO1_18: I/O configuration for PIO1_18/CT16B1_CAP1/TXD
	// Position of FUNC field.
	IOCON_PIO1_18_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_18_FUNC_Msk = 0x7
	// PIO1_18
	IOCON_PIO1_18_FUNC_PIO1_18 = 0x0
	// CT16B1_CAP1
	IOCON_PIO1_18_FUNC_CT16B1_CAP1 = 0x1
	// TXD
	IOCON_PIO1_18_FUNC_TXD = 0x2
	// Position of MODE field.
	IOCON_PIO1_18_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_18_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_18_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_18_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_18_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_18_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_18_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_18_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_18_HYS = 0x20
	// Disable.
	IOCON_PIO1_18_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_18_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_18_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_18_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_18_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_18_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_18_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_18_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_18_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_18_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_18_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_18_OD = 0x400
	// Disable.
	IOCON_PIO1_18_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_18_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_18_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_18_RESERVED_Msk = 0xfffff800

	// PIO1_19: I/O configuration for pin PIO1_19/DTR/SSEL1
	// Position of FUNC field.
	IOCON_PIO1_19_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_19_FUNC_Msk = 0x7
	// PIO1_19.
	IOCON_PIO1_19_FUNC_PIO1_19_ = 0x0
	// DTR.
	IOCON_PIO1_19_FUNC_DTR_ = 0x1
	// SSEL1.
	IOCON_PIO1_19_FUNC_SSEL1_ = 0x2
	// Position of MODE field.
	IOCON_PIO1_19_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_19_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_19_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_19_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_19_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_19_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_19_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_19_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_19_HYS = 0x20
	// Disable.
	IOCON_PIO1_19_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_19_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_19_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_19_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_19_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_19_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_19_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_19_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_19_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_19_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_19_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_19_OD = 0x400
	// Disable.
	IOCON_PIO1_19_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO1_19_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_19_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_19_RESERVED_Msk = 0xfffff800

	// PIO1_20: I/O configuration for pin PIO1_20/DSR/SCK1
	// Position of FUNC field.
	IOCON_PIO1_20_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_20_FUNC_Msk = 0x7
	// PIO1_20.
	IOCON_PIO1_20_FUNC_PIO1_20_ = 0x0
	// DSR.
	IOCON_PIO1_20_FUNC_DSR_ = 0x1
	// SCK1.
	IOCON_PIO1_20_FUNC_SCK1_ = 0x2
	// Position of MODE field.
	IOCON_PIO1_20_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_20_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_20_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_20_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_20_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_20_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_20_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_20_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_20_HYS = 0x20
	// Disable.
	IOCON_PIO1_20_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_20_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_20_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_20_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_20_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_20_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_20_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_20_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_20_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_20_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_20_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_20_OD = 0x400
	// Disable.
	IOCON_PIO1_20_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO1_20_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_20_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_20_RESERVED_Msk = 0xfffff800

	// PIO1_21: I/O configuration for pin PIO1_21/DCD/MISO1
	// Position of FUNC field.
	IOCON_PIO1_21_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_21_FUNC_Msk = 0x7
	// PIO1_21.
	IOCON_PIO1_21_FUNC_PIO1_21_ = 0x0
	// DCD.
	IOCON_PIO1_21_FUNC_DCD_ = 0x1
	// MISO1.
	IOCON_PIO1_21_FUNC_MISO1_ = 0x2
	// Position of MODE field.
	IOCON_PIO1_21_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_21_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_21_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_21_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_21_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_21_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_21_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_21_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_21_HYS = 0x20
	// Disable.
	IOCON_PIO1_21_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_21_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_21_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_21_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_21_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_21_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_21_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_21_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_21_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_21_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_21_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_21_OD = 0x400
	// Disable.
	IOCON_PIO1_21_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO1_21_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_21_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_21_RESERVED_Msk = 0xfffff800

	// PIO1_22: I/O configuration for pin PIO1_22/RI/MOSI1
	// Position of FUNC field.
	IOCON_PIO1_22_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_22_FUNC_Msk = 0x7
	// PIO1_22.
	IOCON_PIO1_22_FUNC_PIO1_22_ = 0x0
	// RI.
	IOCON_PIO1_22_FUNC_RI_ = 0x1
	// MOSI1.
	IOCON_PIO1_22_FUNC_MOSI1_ = 0x2
	// Position of MODE field.
	IOCON_PIO1_22_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_22_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_22_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_22_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_22_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_22_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_22_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_22_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_22_HYS = 0x20
	// Disable.
	IOCON_PIO1_22_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_22_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_22_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_22_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_22_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_22_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_22_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_22_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_22_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_22_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_22_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_22_OD = 0x400
	// Disable.
	IOCON_PIO1_22_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO1_22_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_22_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_22_RESERVED_Msk = 0xfffff800

	// PIO1_23: I/O configuration for pin PIO1_23/CT16B1_MAT1/SSEL1
	// Position of FUNC field.
	IOCON_PIO1_23_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_23_FUNC_Msk = 0x7
	// PIO1_23.
	IOCON_PIO1_23_FUNC_PIO1_23_ = 0x0
	// CT16B1_MAT1.
	IOCON_PIO1_23_FUNC_CT16B1_MAT1_ = 0x1
	// SSEL1.
	IOCON_PIO1_23_FUNC_SSEL1_ = 0x2
	// Position of MODE field.
	IOCON_PIO1_23_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_23_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_23_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_23_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_23_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_23_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_23_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_23_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_23_HYS = 0x20
	// Disable.
	IOCON_PIO1_23_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_23_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_23_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_23_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_23_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_23_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_23_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_23_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_23_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_23_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_23_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_23_OD = 0x400
	// Disable.
	IOCON_PIO1_23_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO1_23_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_23_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_23_RESERVED_Msk = 0xfffff800

	// PIO1_24: I/O configuration for pin PIO1_24/ CT32B0_MAT0
	// Position of FUNC field.
	IOCON_PIO1_24_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_24_FUNC_Msk = 0x7
	// PIO1_24.
	IOCON_PIO1_24_FUNC_PIO1_24_ = 0x0
	// CT32B0_MAT0.
	IOCON_PIO1_24_FUNC_CT32B0_MAT0_ = 0x1
	// Position of MODE field.
	IOCON_PIO1_24_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_24_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_24_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_24_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_24_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_24_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_24_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_24_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_24_HYS = 0x20
	// Disable.
	IOCON_PIO1_24_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_24_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_24_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_24_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_24_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_24_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_24_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_24_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_24_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_24_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_24_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_24_OD = 0x400
	// Disable.
	IOCON_PIO1_24_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO1_24_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_24_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_24_RESERVED_Msk = 0xfffff800

	// PIO1_25: I/O configuration for pin PIO1_25/CT32B0_MAT1
	// Position of FUNC field.
	IOCON_PIO1_25_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_25_FUNC_Msk = 0x7
	// PIO1_25.
	IOCON_PIO1_25_FUNC_PIO1_25_ = 0x0
	// CT32B0_MAT1.
	IOCON_PIO1_25_FUNC_CT32B0_MAT1_ = 0x1
	// Position of MODE field.
	IOCON_PIO1_25_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_25_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_25_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_25_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_25_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_25_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_25_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_25_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_25_HYS = 0x20
	// Disable.
	IOCON_PIO1_25_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_25_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_25_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_25_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_25_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_25_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_25_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_25_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_25_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_25_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_25_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_25_OD = 0x400
	// Disable.
	IOCON_PIO1_25_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO1_25_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_25_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_25_RESERVED_Msk = 0xfffff800

	// PIO1_26: I/O configuration for pin PIO1_26/CT32B0_MAT2/ RXD
	// Position of FUNC field.
	IOCON_PIO1_26_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_26_FUNC_Msk = 0x7
	// PIO1_26.
	IOCON_PIO1_26_FUNC_PIO1_26_ = 0x0
	// CT32B0_MAT2
	IOCON_PIO1_26_FUNC_CT32B0_MAT2 = 0x1
	// RXD.
	IOCON_PIO1_26_FUNC_RXD_ = 0x2
	// Position of MODE field.
	IOCON_PIO1_26_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_26_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_26_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_26_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_26_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_26_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_26_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_26_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_26_HYS = 0x20
	// Disable.
	IOCON_PIO1_26_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_26_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_26_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_26_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_26_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_26_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_26_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_26_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_26_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_26_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_26_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_26_OD = 0x400
	// Disable.
	IOCON_PIO1_26_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO1_26_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_26_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_26_RESERVED_Msk = 0xfffff800

	// PIO1_27: I/O configuration for pin PIO1_27/CT32B0_MAT3/ TXD
	// Position of FUNC field.
	IOCON_PIO1_27_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_27_FUNC_Msk = 0x7
	// PIO1_27.
	IOCON_PIO1_27_FUNC_PIO1_27_ = 0x0
	// CT32B0_MAT3.
	IOCON_PIO1_27_FUNC_CT32B0_MAT3_ = 0x1
	// TXD.
	IOCON_PIO1_27_FUNC_TXD_ = 0x2
	// Position of MODE field.
	IOCON_PIO1_27_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_27_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_27_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_27_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_27_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_27_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_27_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_27_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_27_HYS = 0x20
	// Disable.
	IOCON_PIO1_27_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_27_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_27_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_27_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_27_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_27_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_27_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_27_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_27_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_27_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_27_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_27_OD = 0x400
	// Disable.
	IOCON_PIO1_27_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO1_27_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_27_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_27_RESERVED_Msk = 0xfffff800

	// PIO1_28: I/O configuration for pin PIO1_28/CT32B0_CAP0/ SCLK
	// Position of FUNC field.
	IOCON_PIO1_28_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_28_FUNC_Msk = 0x7
	// PIO1_28.
	IOCON_PIO1_28_FUNC_PIO1_28_ = 0x0
	// CT32B0_CAP0.
	IOCON_PIO1_28_FUNC_CT32B0_CAP0_ = 0x1
	// SCLK.
	IOCON_PIO1_28_FUNC_SCLK_ = 0x2
	// Position of MODE field.
	IOCON_PIO1_28_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_28_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_28_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_28_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_28_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_28_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_28_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_28_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_28_HYS = 0x20
	// Disable.
	IOCON_PIO1_28_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_28_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_28_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_28_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_28_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_28_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_28_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_28_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_28_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_28_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_28_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_28_OD = 0x400
	// Disable.
	IOCON_PIO1_28_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO1_28_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_28_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_28_RESERVED_Msk = 0xfffff800

	// PIO1_29: I/O configuration for pin PIO1_29/SCK0/ CT32B0_CAP1
	// Position of FUNC field.
	IOCON_PIO1_29_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_29_FUNC_Msk = 0x7
	// PIO1_29.
	IOCON_PIO1_29_FUNC_PIO1_29_ = 0x0
	// SCK0.
	IOCON_PIO1_29_FUNC_SCK0_ = 0x1
	// CT32B0_CAP1.
	IOCON_PIO1_29_FUNC_CT32B0_CAP1_ = 0x2
	// Position of MODE field.
	IOCON_PIO1_29_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_29_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_29_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_29_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_29_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_29_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_29_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_29_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_29_HYS = 0x20
	// Disable.
	IOCON_PIO1_29_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_29_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_29_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_29_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_29_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_29_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_29_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_29_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_29_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_29_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_29_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_29_OD = 0x400
	// Disable.
	IOCON_PIO1_29_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO1_29_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_29_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_29_RESERVED_Msk = 0xfffff800

	// PIO1_31: I/O configuration for pin PIO1_31
	// Position of FUNC field.
	IOCON_PIO1_31_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_31_FUNC_Msk = 0x7
	// PIO1_31.
	IOCON_PIO1_31_FUNC_PIO1_31_ = 0x0
	// Position of MODE field.
	IOCON_PIO1_31_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_31_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_31_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_31_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_31_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_31_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_31_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_31_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_31_HYS = 0x20
	// Disable.
	IOCON_PIO1_31_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_31_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_31_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_31_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_31_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_31_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_31_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_31_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_31_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_31_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_31_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_31_OD = 0x400
	// Disable.
	IOCON_PIO1_31_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO1_31_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_31_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_31_RESERVED_Msk = 0xfffff800
)

// Bitfields for SYSCON: System control block
const (
	// SYSMEMREMAP: System memory remap
	// Position of MAP field.
	SYSCON_SYSMEMREMAP_MAP_Pos = 0x0
	// Bit mask of MAP field.
	SYSCON_SYSMEMREMAP_MAP_Msk = 0x3
	// Boot Loader Mode. Interrupt vectors are re-mapped to Boot ROM.
	SYSCON_SYSMEMREMAP_MAP_BOOT_LOADER_MODE_IN = 0x0
	// User RAM Mode. Interrupt vectors are re-mapped to Static RAM.
	SYSCON_SYSMEMREMAP_MAP_USER_RAM_MODE_INTER = 0x1
	// User Flash Mode. Interrupt vectors are not re-mapped and reside in Flash.
	SYSCON_SYSMEMREMAP_MAP_USER_FLASH_MODE_INT = 0x2
	// Position of RESERVED field.
	SYSCON_SYSMEMREMAP_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSMEMREMAP_RESERVED_Msk = 0xfffffffc

	// PRESETCTRL: Peripheral reset control
	// Position of SSP0_RST_N field.
	SYSCON_PRESETCTRL_SSP0_RST_N_Pos = 0x0
	// Bit mask of SSP0_RST_N field.
	SYSCON_PRESETCTRL_SSP0_RST_N_Msk = 0x1
	// Bit SSP0_RST_N.
	SYSCON_PRESETCTRL_SSP0_RST_N = 0x1
	// Resets the SSP0 peripheral.
	SYSCON_PRESETCTRL_SSP0_RST_N_RESETS_THE_SSP0_PERI = 0x0
	// SSP0 reset de-asserted.
	SYSCON_PRESETCTRL_SSP0_RST_N_SSP0_RESET_DE_ASSERT = 0x1
	// Position of I2C_RST_N field.
	SYSCON_PRESETCTRL_I2C_RST_N_Pos = 0x1
	// Bit mask of I2C_RST_N field.
	SYSCON_PRESETCTRL_I2C_RST_N_Msk = 0x2
	// Bit I2C_RST_N.
	SYSCON_PRESETCTRL_I2C_RST_N = 0x2
	// Resets the I2C peripheral.
	SYSCON_PRESETCTRL_I2C_RST_N_RESETS_THE_I2C_PERIP = 0x0
	// I2C reset de-asserted.
	SYSCON_PRESETCTRL_I2C_RST_N_I2C_RESET_DE_ASSERTE = 0x1
	// Position of SSP1_RST_N field.
	SYSCON_PRESETCTRL_SSP1_RST_N_Pos = 0x2
	// Bit mask of SSP1_RST_N field.
	SYSCON_PRESETCTRL_SSP1_RST_N_Msk = 0x4
	// Bit SSP1_RST_N.
	SYSCON_PRESETCTRL_SSP1_RST_N = 0x4
	// Resets the SSP1 peripheral.
	SYSCON_PRESETCTRL_SSP1_RST_N_RESETS_THE_SSP1_PERI = 0x0
	// SSP1 reset de-asserted.
	SYSCON_PRESETCTRL_SSP1_RST_N_SSP1_RESET_DE_ASSERT = 0x1
	// Position of RESERVED field.
	SYSCON_PRESETCTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL_RESERVED_Msk = 0x8
	// Bit RESERVED.
	SYSCON_PRESETCTRL_RESERVED = 0x8
	// Position of RESERVED field.
	SYSCON_PRESETCTRL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL_RESERVED_Msk = 0xfffffff0

	// SYSPLLCTRL: System PLL control
	// Position of MSEL field.
	SYSCON_SYSPLLCTRL_MSEL_Pos = 0x0
	// Bit mask of MSEL field.
	SYSCON_SYSPLLCTRL_MSEL_Msk = 0x1f
	// Position of PSEL field.
	SYSCON_SYSPLLCTRL_PSEL_Pos = 0x5
	// Bit mask of PSEL field.
	SYSCON_SYSPLLCTRL_PSEL_Msk = 0x60
	// P = 1
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_1 = 0x0
	// P = 2
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_2 = 0x1
	// P = 4
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_4 = 0x2
	// P = 8
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_8 = 0x3
	// Position of RESERVED field.
	SYSCON_SYSPLLCTRL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLCTRL_RESERVED_Msk = 0xffffff80

	// SYSPLLSTAT: System PLL status
	// Position of LOCK field.
	SYSCON_SYSPLLSTAT_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	SYSCON_SYSPLLSTAT_LOCK_Msk = 0x1
	// Bit LOCK.
	SYSCON_SYSPLLSTAT_LOCK = 0x1
	// PLL not locked
	SYSCON_SYSPLLSTAT_LOCK_PLL_NOT_LOCKED = 0x0
	// PLL locked
	SYSCON_SYSPLLSTAT_LOCK_PLL_LOCKED = 0x1
	// Position of RESERVED field.
	SYSCON_SYSPLLSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLSTAT_RESERVED_Msk = 0xfffffffe

	// USBPLLCTRL: USB PLL control
	// Position of MSEL field.
	SYSCON_USBPLLCTRL_MSEL_Pos = 0x0
	// Bit mask of MSEL field.
	SYSCON_USBPLLCTRL_MSEL_Msk = 0x1f
	// Position of PSEL field.
	SYSCON_USBPLLCTRL_PSEL_Pos = 0x5
	// Bit mask of PSEL field.
	SYSCON_USBPLLCTRL_PSEL_Msk = 0x60
	// P = 1
	SYSCON_USBPLLCTRL_PSEL_P_EQ_1 = 0x0
	// P = 2
	SYSCON_USBPLLCTRL_PSEL_P_EQ_2 = 0x1
	// P = 4
	SYSCON_USBPLLCTRL_PSEL_P_EQ_4 = 0x2
	// P = 8
	SYSCON_USBPLLCTRL_PSEL_P_EQ_8 = 0x3
	// Position of RESERVED field.
	SYSCON_USBPLLCTRL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	SYSCON_USBPLLCTRL_RESERVED_Msk = 0xffffff80

	// USBPLLSTAT: USB PLL status
	// Position of LOCK field.
	SYSCON_USBPLLSTAT_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	SYSCON_USBPLLSTAT_LOCK_Msk = 0x1
	// Bit LOCK.
	SYSCON_USBPLLSTAT_LOCK = 0x1
	// PLL not locked
	SYSCON_USBPLLSTAT_LOCK_PLL_NOT_LOCKED = 0x0
	// PLL locked
	SYSCON_USBPLLSTAT_LOCK_PLL_LOCKED = 0x1
	// Position of RESERVED field.
	SYSCON_USBPLLSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_USBPLLSTAT_RESERVED_Msk = 0xfffffffe

	// SYSOSCCTRL: System oscillator control
	// Position of BYPASS field.
	SYSCON_SYSOSCCTRL_BYPASS_Pos = 0x0
	// Bit mask of BYPASS field.
	SYSCON_SYSOSCCTRL_BYPASS_Msk = 0x1
	// Bit BYPASS.
	SYSCON_SYSOSCCTRL_BYPASS = 0x1
	// Oscillator is not bypassed.
	SYSCON_SYSOSCCTRL_BYPASS_OSCILLATOR_IS_NOT_BY = 0x0
	// Bypass enabled. PLL input (sys_osc_clk) is fed directly from the XTALIN pin bypassing the oscillator. Use this mode when using an external clock source instead of the crystal oscillator.
	SYSCON_SYSOSCCTRL_BYPASS_BYPASS_ENABLED_PLL_ = 0x1
	// Position of FREQRANGE field.
	SYSCON_SYSOSCCTRL_FREQRANGE_Pos = 0x1
	// Bit mask of FREQRANGE field.
	SYSCON_SYSOSCCTRL_FREQRANGE_Msk = 0x2
	// Bit FREQRANGE.
	SYSCON_SYSOSCCTRL_FREQRANGE = 0x2
	// 1 - 20 MHz frequency range.
	SYSCON_SYSOSCCTRL_FREQRANGE_1__20_MHZ_FREQUENCY = 0x0
	// 15 - 25 MHz frequency range
	SYSCON_SYSOSCCTRL_FREQRANGE_15__25_MHZ_FREQUENC = 0x1
	// Position of RESERVED field.
	SYSCON_SYSOSCCTRL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSOSCCTRL_RESERVED_Msk = 0xfffffffc

	// WDTOSCCTRL: Watchdog oscillator control
	// Position of DIVSEL field.
	SYSCON_WDTOSCCTRL_DIVSEL_Pos = 0x0
	// Bit mask of DIVSEL field.
	SYSCON_WDTOSCCTRL_DIVSEL_Msk = 0x1f
	// Position of FREQSEL field.
	SYSCON_WDTOSCCTRL_FREQSEL_Pos = 0x5
	// Bit mask of FREQSEL field.
	SYSCON_WDTOSCCTRL_FREQSEL_Msk = 0x1e0
	// 0.6 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_0_6_MHZ = 0x1
	// 1.05 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_1_05_MHZ = 0x2
	// 1.4 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_1_4_MHZ = 0x3
	// 1.75 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_1_75_MHZ = 0x4
	// 2.1 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_2_1_MHZ = 0x5
	// 2.4 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_2_4_MHZ = 0x6
	// 2.7 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_2_7_MHZ = 0x7
	// 3.0 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_3_0_MHZ = 0x8
	// 3.25 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_3_25_MHZ = 0x9
	// 3.5 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_3_5_MHZ = 0xa
	// 3.75 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_3_75_MHZ = 0xb
	// 4.0 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_4_0_MHZ = 0xc
	// 4.2 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_4_2_MHZ = 0xd
	// 4.4 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_4_4_MHZ = 0xe
	// 4.6 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_4_6_MHZ = 0xf
	// Position of RESERVED field.
	SYSCON_WDTOSCCTRL_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SYSCON_WDTOSCCTRL_RESERVED_Msk = 0xfffffe00

	// SYSRSTSTAT: System reset status register
	// Position of POR field.
	SYSCON_SYSRSTSTAT_POR_Pos = 0x0
	// Bit mask of POR field.
	SYSCON_SYSRSTSTAT_POR_Msk = 0x1
	// Bit POR.
	SYSCON_SYSRSTSTAT_POR = 0x1
	// No POR detected
	SYSCON_SYSRSTSTAT_POR_NO_POR_DETECTED = 0x0
	// POR detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_POR_POR_DETECTED_WRITIN = 0x1
	// Position of EXTRST field.
	SYSCON_SYSRSTSTAT_EXTRST_Pos = 0x1
	// Bit mask of EXTRST field.
	SYSCON_SYSRSTSTAT_EXTRST_Msk = 0x2
	// Bit EXTRST.
	SYSCON_SYSRSTSTAT_EXTRST = 0x2
	// No reset event detected.
	SYSCON_SYSRSTSTAT_EXTRST_NO_RESET_EVENT_DETEC = 0x0
	// Reset detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_EXTRST_RESET_DETECTED_WRIT = 0x1
	// Position of WDT field.
	SYSCON_SYSRSTSTAT_WDT_Pos = 0x2
	// Bit mask of WDT field.
	SYSCON_SYSRSTSTAT_WDT_Msk = 0x4
	// Bit WDT.
	SYSCON_SYSRSTSTAT_WDT = 0x4
	// No WDT reset detected
	SYSCON_SYSRSTSTAT_WDT_NO_WDT_RESET_DETECTE = 0x0
	// WDT reset detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_WDT_WDT_RESET_DETECTED_ = 0x1
	// Position of BOD field.
	SYSCON_SYSRSTSTAT_BOD_Pos = 0x3
	// Bit mask of BOD field.
	SYSCON_SYSRSTSTAT_BOD_Msk = 0x8
	// Bit BOD.
	SYSCON_SYSRSTSTAT_BOD = 0x8
	// No BOD reset detected
	SYSCON_SYSRSTSTAT_BOD_NO_BOD_RESET_DETECTE = 0x0
	// BOD reset detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_BOD_BOD_RESET_DETECTED_ = 0x1
	// Position of SYSRST field.
	SYSCON_SYSRSTSTAT_SYSRST_Pos = 0x4
	// Bit mask of SYSRST field.
	SYSCON_SYSRSTSTAT_SYSRST_Msk = 0x10
	// Bit SYSRST.
	SYSCON_SYSRSTSTAT_SYSRST = 0x10
	// No System reset detected
	SYSCON_SYSRSTSTAT_SYSRST_NO_SYSTEM_RESET_DETE = 0x0
	// System reset detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_SYSRST_SYSTEM_RESET_DETECTE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSRSTSTAT_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_SYSRSTSTAT_RESERVED_Msk = 0xffffffe0

	// SYSPLLCLKSEL: System PLL clock source select
	// Position of SEL field.
	SYSCON_SYSPLLCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_SYSPLLCLKSEL_SEL_Msk = 0x3
	// IRC
	SYSCON_SYSPLLCLKSEL_SEL_IRC = 0x0
	// Crystal Oscillator (SYSOSC)
	SYSCON_SYSPLLCLKSEL_SEL_CRYSTAL_OSCILLATOR_ = 0x1
	// Position of RESERVED field.
	SYSCON_SYSPLLCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLCLKSEL_RESERVED_Msk = 0xfffffffc

	// SYSPLLCLKUEN: System PLL clock source update enable
	// Position of ENA field.
	SYSCON_SYSPLLCLKUEN_ENA_Pos = 0x0
	// Bit mask of ENA field.
	SYSCON_SYSPLLCLKUEN_ENA_Msk = 0x1
	// Bit ENA.
	SYSCON_SYSPLLCLKUEN_ENA = 0x1
	// No change
	SYSCON_SYSPLLCLKUEN_ENA_NO_CHANGE = 0x0
	// Update clock source
	SYSCON_SYSPLLCLKUEN_ENA_UPDATE_CLOCK_SOURCE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSPLLCLKUEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLCLKUEN_RESERVED_Msk = 0xfffffffe

	// USBPLLCLKSEL: USB PLL clock source select
	// Position of SEL field.
	SYSCON_USBPLLCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_USBPLLCLKSEL_SEL_Msk = 0x3
	// IRC. The USB PLL clock source must be switched to system oscillator for correct full-speed USB operation. The IRC is suitable for low-speed USB operation.
	SYSCON_USBPLLCLKSEL_SEL_IRC_THE_USB_PLL_CLO = 0x0
	// System oscillator
	SYSCON_USBPLLCLKSEL_SEL_SYSTEM_OSCILLATOR = 0x1
	// Position of RESERVED field.
	SYSCON_USBPLLCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_USBPLLCLKSEL_RESERVED_Msk = 0xfffffffc

	// USBPLLCLKUEN: USB PLL clock source update enable
	// Position of ENA field.
	SYSCON_USBPLLCLKUEN_ENA_Pos = 0x0
	// Bit mask of ENA field.
	SYSCON_USBPLLCLKUEN_ENA_Msk = 0x1
	// Bit ENA.
	SYSCON_USBPLLCLKUEN_ENA = 0x1
	// No change
	SYSCON_USBPLLCLKUEN_ENA_NO_CHANGE = 0x0
	// Update clock source
	SYSCON_USBPLLCLKUEN_ENA_UPDATE_CLOCK_SOURCE = 0x1
	// Position of RESERVED field.
	SYSCON_USBPLLCLKUEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_USBPLLCLKUEN_RESERVED_Msk = 0xfffffffe

	// MAINCLKSEL: Main clock source select
	// Position of SEL field.
	SYSCON_MAINCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_MAINCLKSEL_SEL_Msk = 0x3
	// IRC Oscillator
	SYSCON_MAINCLKSEL_SEL_IRC_OSCILLATOR = 0x0
	// PLL input
	SYSCON_MAINCLKSEL_SEL_PLL_INPUT = 0x1
	// Watchdog oscillator
	SYSCON_MAINCLKSEL_SEL_WATCHDOG_OSCILLATOR = 0x2
	// PLL output
	SYSCON_MAINCLKSEL_SEL_PLL_OUTPUT = 0x3
	// Position of RESERVED field.
	SYSCON_MAINCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_MAINCLKSEL_RESERVED_Msk = 0xfffffffc

	// MAINCLKUEN: Main clock source update enable
	// Position of ENA field.
	SYSCON_MAINCLKUEN_ENA_Pos = 0x0
	// Bit mask of ENA field.
	SYSCON_MAINCLKUEN_ENA_Msk = 0x1
	// Bit ENA.
	SYSCON_MAINCLKUEN_ENA = 0x1
	// No change
	SYSCON_MAINCLKUEN_ENA_NO_CHANGE = 0x0
	// Update clock source
	SYSCON_MAINCLKUEN_ENA_UPDATE_CLOCK_SOURCE = 0x1
	// Position of RESERVED field.
	SYSCON_MAINCLKUEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_MAINCLKUEN_RESERVED_Msk = 0xfffffffe

	// SYSAHBCLKDIV: System clock divider
	// Position of DIV field.
	SYSCON_SYSAHBCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_SYSAHBCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKDIV_RESERVED_Msk = 0xffffff00

	// SYSAHBCLKCTRL: System clock control
	// Position of SYS field.
	SYSCON_SYSAHBCLKCTRL_SYS_Pos = 0x0
	// Bit mask of SYS field.
	SYSCON_SYSAHBCLKCTRL_SYS_Msk = 0x1
	// Bit SYS.
	SYSCON_SYSAHBCLKCTRL_SYS = 0x1
	// Enable
	SYSCON_SYSAHBCLKCTRL_SYS_ENABLE = 0x1
	// Position of ROM field.
	SYSCON_SYSAHBCLKCTRL_ROM_Pos = 0x1
	// Bit mask of ROM field.
	SYSCON_SYSAHBCLKCTRL_ROM_Msk = 0x2
	// Bit ROM.
	SYSCON_SYSAHBCLKCTRL_ROM = 0x2
	// Disable
	SYSCON_SYSAHBCLKCTRL_ROM_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_ROM_ENABLE = 0x1
	// Position of RAM0 field.
	SYSCON_SYSAHBCLKCTRL_RAM0_Pos = 0x2
	// Bit mask of RAM0 field.
	SYSCON_SYSAHBCLKCTRL_RAM0_Msk = 0x4
	// Bit RAM0.
	SYSCON_SYSAHBCLKCTRL_RAM0 = 0x4
	// Disable
	SYSCON_SYSAHBCLKCTRL_RAM0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_RAM0_ENABLE = 0x1
	// Position of FLASHREG field.
	SYSCON_SYSAHBCLKCTRL_FLASHREG_Pos = 0x3
	// Bit mask of FLASHREG field.
	SYSCON_SYSAHBCLKCTRL_FLASHREG_Msk = 0x8
	// Bit FLASHREG.
	SYSCON_SYSAHBCLKCTRL_FLASHREG = 0x8
	// Disable
	SYSCON_SYSAHBCLKCTRL_FLASHREG_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_FLASHREG_ENABLE = 0x1
	// Position of FLASHARRAY field.
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY_Pos = 0x4
	// Bit mask of FLASHARRAY field.
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY_Msk = 0x10
	// Bit FLASHARRAY.
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY = 0x10
	// Disable
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY_ENABLE = 0x1
	// Position of I2C field.
	SYSCON_SYSAHBCLKCTRL_I2C_Pos = 0x5
	// Bit mask of I2C field.
	SYSCON_SYSAHBCLKCTRL_I2C_Msk = 0x20
	// Bit I2C.
	SYSCON_SYSAHBCLKCTRL_I2C = 0x20
	// Disable
	SYSCON_SYSAHBCLKCTRL_I2C_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_I2C_ENABLE = 0x1
	// Position of GPIO field.
	SYSCON_SYSAHBCLKCTRL_GPIO_Pos = 0x6
	// Bit mask of GPIO field.
	SYSCON_SYSAHBCLKCTRL_GPIO_Msk = 0x40
	// Bit GPIO.
	SYSCON_SYSAHBCLKCTRL_GPIO = 0x40
	// Disable
	SYSCON_SYSAHBCLKCTRL_GPIO_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_GPIO_ENABLE = 0x1
	// Position of CT16B0 field.
	SYSCON_SYSAHBCLKCTRL_CT16B0_Pos = 0x7
	// Bit mask of CT16B0 field.
	SYSCON_SYSAHBCLKCTRL_CT16B0_Msk = 0x80
	// Bit CT16B0.
	SYSCON_SYSAHBCLKCTRL_CT16B0 = 0x80
	// Disable
	SYSCON_SYSAHBCLKCTRL_CT16B0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CT16B0_ENABLE = 0x1
	// Position of CT16B1 field.
	SYSCON_SYSAHBCLKCTRL_CT16B1_Pos = 0x8
	// Bit mask of CT16B1 field.
	SYSCON_SYSAHBCLKCTRL_CT16B1_Msk = 0x100
	// Bit CT16B1.
	SYSCON_SYSAHBCLKCTRL_CT16B1 = 0x100
	// Disable
	SYSCON_SYSAHBCLKCTRL_CT16B1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CT16B1_ENABLE = 0x1
	// Position of CT32B0 field.
	SYSCON_SYSAHBCLKCTRL_CT32B0_Pos = 0x9
	// Bit mask of CT32B0 field.
	SYSCON_SYSAHBCLKCTRL_CT32B0_Msk = 0x200
	// Bit CT32B0.
	SYSCON_SYSAHBCLKCTRL_CT32B0 = 0x200
	// Disable
	SYSCON_SYSAHBCLKCTRL_CT32B0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CT32B0_ENABLE = 0x1
	// Position of CT32B1 field.
	SYSCON_SYSAHBCLKCTRL_CT32B1_Pos = 0xa
	// Bit mask of CT32B1 field.
	SYSCON_SYSAHBCLKCTRL_CT32B1_Msk = 0x400
	// Bit CT32B1.
	SYSCON_SYSAHBCLKCTRL_CT32B1 = 0x400
	// Disable
	SYSCON_SYSAHBCLKCTRL_CT32B1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CT32B1_ENABLE = 0x1
	// Position of SSP0 field.
	SYSCON_SYSAHBCLKCTRL_SSP0_Pos = 0xb
	// Bit mask of SSP0 field.
	SYSCON_SYSAHBCLKCTRL_SSP0_Msk = 0x800
	// Bit SSP0.
	SYSCON_SYSAHBCLKCTRL_SSP0 = 0x800
	// Disable
	SYSCON_SYSAHBCLKCTRL_SSP0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_SSP0_ENABLE = 0x1
	// Position of USART field.
	SYSCON_SYSAHBCLKCTRL_USART_Pos = 0xc
	// Bit mask of USART field.
	SYSCON_SYSAHBCLKCTRL_USART_Msk = 0x1000
	// Bit USART.
	SYSCON_SYSAHBCLKCTRL_USART = 0x1000
	// Disable
	SYSCON_SYSAHBCLKCTRL_USART_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_USART_ENABLE = 0x1
	// Position of ADC field.
	SYSCON_SYSAHBCLKCTRL_ADC_Pos = 0xd
	// Bit mask of ADC field.
	SYSCON_SYSAHBCLKCTRL_ADC_Msk = 0x2000
	// Bit ADC.
	SYSCON_SYSAHBCLKCTRL_ADC = 0x2000
	// Disable
	SYSCON_SYSAHBCLKCTRL_ADC_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_ADC_ENABLE = 0x1
	// Position of USB field.
	SYSCON_SYSAHBCLKCTRL_USB_Pos = 0xe
	// Bit mask of USB field.
	SYSCON_SYSAHBCLKCTRL_USB_Msk = 0x4000
	// Bit USB.
	SYSCON_SYSAHBCLKCTRL_USB = 0x4000
	// Disable
	SYSCON_SYSAHBCLKCTRL_USB_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_USB_ENABLE = 0x1
	// Position of WWDT field.
	SYSCON_SYSAHBCLKCTRL_WWDT_Pos = 0xf
	// Bit mask of WWDT field.
	SYSCON_SYSAHBCLKCTRL_WWDT_Msk = 0x8000
	// Bit WWDT.
	SYSCON_SYSAHBCLKCTRL_WWDT = 0x8000
	// Disable
	SYSCON_SYSAHBCLKCTRL_WWDT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_WWDT_ENABLE = 0x1
	// Position of IOCON field.
	SYSCON_SYSAHBCLKCTRL_IOCON_Pos = 0x10
	// Bit mask of IOCON field.
	SYSCON_SYSAHBCLKCTRL_IOCON_Msk = 0x10000
	// Bit IOCON.
	SYSCON_SYSAHBCLKCTRL_IOCON = 0x10000
	// Disable
	SYSCON_SYSAHBCLKCTRL_IOCON_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_IOCON_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Msk = 0x20000
	// Bit RESERVED.
	SYSCON_SYSAHBCLKCTRL_RESERVED = 0x20000
	// Position of SSP1 field.
	SYSCON_SYSAHBCLKCTRL_SSP1_Pos = 0x12
	// Bit mask of SSP1 field.
	SYSCON_SYSAHBCLKCTRL_SSP1_Msk = 0x40000
	// Bit SSP1.
	SYSCON_SYSAHBCLKCTRL_SSP1 = 0x40000
	// Disable
	SYSCON_SYSAHBCLKCTRL_SSP1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_SSP1_ENABLE = 0x1
	// Position of PINT field.
	SYSCON_SYSAHBCLKCTRL_PINT_Pos = 0x13
	// Bit mask of PINT field.
	SYSCON_SYSAHBCLKCTRL_PINT_Msk = 0x80000
	// Bit PINT.
	SYSCON_SYSAHBCLKCTRL_PINT = 0x80000
	// Disable
	SYSCON_SYSAHBCLKCTRL_PINT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_PINT_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Msk = 0x700000
	// Position of GROUP0INT field.
	SYSCON_SYSAHBCLKCTRL_GROUP0INT_Pos = 0x17
	// Bit mask of GROUP0INT field.
	SYSCON_SYSAHBCLKCTRL_GROUP0INT_Msk = 0x800000
	// Bit GROUP0INT.
	SYSCON_SYSAHBCLKCTRL_GROUP0INT = 0x800000
	// Disable
	SYSCON_SYSAHBCLKCTRL_GROUP0INT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_GROUP0INT_ENABLE = 0x1
	// Position of GROUP1INT field.
	SYSCON_SYSAHBCLKCTRL_GROUP1INT_Pos = 0x18
	// Bit mask of GROUP1INT field.
	SYSCON_SYSAHBCLKCTRL_GROUP1INT_Msk = 0x1000000
	// Bit GROUP1INT.
	SYSCON_SYSAHBCLKCTRL_GROUP1INT = 0x1000000
	// Disable
	SYSCON_SYSAHBCLKCTRL_GROUP1INT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_GROUP1INT_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Pos = 0x19
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Msk = 0x2000000
	// Bit RESERVED.
	SYSCON_SYSAHBCLKCTRL_RESERVED = 0x2000000
	// Position of RAM1 field.
	SYSCON_SYSAHBCLKCTRL_RAM1_Pos = 0x1a
	// Bit mask of RAM1 field.
	SYSCON_SYSAHBCLKCTRL_RAM1_Msk = 0x4000000
	// Bit RAM1.
	SYSCON_SYSAHBCLKCTRL_RAM1 = 0x4000000
	// Disable
	SYSCON_SYSAHBCLKCTRL_RAM1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_RAM1_ENABLE = 0x1
	// Position of USBRAM field.
	SYSCON_SYSAHBCLKCTRL_USBRAM_Pos = 0x1b
	// Bit mask of USBRAM field.
	SYSCON_SYSAHBCLKCTRL_USBRAM_Msk = 0x8000000
	// Bit USBRAM.
	SYSCON_SYSAHBCLKCTRL_USBRAM = 0x8000000
	// Disable
	SYSCON_SYSAHBCLKCTRL_USBRAM_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_USBRAM_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Msk = 0xf0000000

	// SSP0CLKDIV: SSP0 clock divider
	// Position of DIV field.
	SYSCON_SSP0CLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_SSP0CLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_SSP0CLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_SSP0CLKDIV_RESERVED_Msk = 0xffffff00

	// UARTCLKDIV: UART clock divider
	// Position of DIV field.
	SYSCON_UARTCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_UARTCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_UARTCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_UARTCLKDIV_RESERVED_Msk = 0xffffff00

	// SSP1CLKDIV: SSP1 clock divider
	// Position of DIV field.
	SYSCON_SSP1CLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_SSP1CLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_SSP1CLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_SSP1CLKDIV_RESERVED_Msk = 0xffffff00

	// USBCLKSEL: USB clock source select
	// Position of SEL field.
	SYSCON_USBCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_USBCLKSEL_SEL_Msk = 0x3
	// USB PLL out
	SYSCON_USBCLKSEL_SEL_USB_PLL_OUT = 0x0
	// Main clock
	SYSCON_USBCLKSEL_SEL_MAIN_CLOCK = 0x1
	// Position of RESERVED field.
	SYSCON_USBCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_USBCLKSEL_RESERVED_Msk = 0xfffffffc

	// USBCLKUEN: USB clock source update enable
	// Position of ENA field.
	SYSCON_USBCLKUEN_ENA_Pos = 0x0
	// Bit mask of ENA field.
	SYSCON_USBCLKUEN_ENA_Msk = 0x1
	// Bit ENA.
	SYSCON_USBCLKUEN_ENA = 0x1
	// No change
	SYSCON_USBCLKUEN_ENA_NO_CHANGE = 0x0
	// Update clock source
	SYSCON_USBCLKUEN_ENA_UPDATE_CLOCK_SOURCE = 0x1
	// Position of RESERVED field.
	SYSCON_USBCLKUEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_USBCLKUEN_RESERVED_Msk = 0xfffffffe

	// USBCLKDIV: USB clock source divider
	// Position of DIV field.
	SYSCON_USBCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_USBCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_USBCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_USBCLKDIV_RESERVED_Msk = 0xffffff00

	// CLKOUTSEL: CLKOUT clock source select
	// Position of SEL field.
	SYSCON_CLKOUTSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_CLKOUTSEL_SEL_Msk = 0x3
	// IRC oscillator
	SYSCON_CLKOUTSEL_SEL_IRC_OSCILLATOR = 0x0
	// Crystal oscillator (SYSOSC)
	SYSCON_CLKOUTSEL_SEL_CRYSTAL_OSCILLATOR_ = 0x1
	// LF oscillator (watchdog oscillator)
	SYSCON_CLKOUTSEL_SEL_LF_OSCILLATOR_WATCH = 0x2
	// Main clock
	SYSCON_CLKOUTSEL_SEL_MAIN_CLOCK = 0x3
	// Position of RESERVED field.
	SYSCON_CLKOUTSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTSEL_RESERVED_Msk = 0xfffffffc

	// CLKOUTUEN: CLKOUT clock source update enable
	// Position of ENA field.
	SYSCON_CLKOUTUEN_ENA_Pos = 0x0
	// Bit mask of ENA field.
	SYSCON_CLKOUTUEN_ENA_Msk = 0x1
	// Bit ENA.
	SYSCON_CLKOUTUEN_ENA = 0x1
	// No change
	SYSCON_CLKOUTUEN_ENA_NO_CHANGE = 0x0
	// Update clock source
	SYSCON_CLKOUTUEN_ENA_UPDATE_CLOCK_SOURCE = 0x1
	// Position of RESERVED field.
	SYSCON_CLKOUTUEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTUEN_RESERVED_Msk = 0xfffffffe

	// CLKOUTDIV: CLKOUT clock divider
	// Position of DIV field.
	SYSCON_CLKOUTDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_CLKOUTDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_CLKOUTDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTDIV_RESERVED_Msk = 0xffffff00

	// PIOPORCAP0: POR captured PIO status 0
	// Position of PIOSTAT field.
	SYSCON_PIOPORCAP0_PIOSTAT_Pos = 0x0
	// Bit mask of PIOSTAT field.
	SYSCON_PIOPORCAP0_PIOSTAT_Msk = 0xffffff
	// Position of RESERVED field.
	SYSCON_PIOPORCAP0_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	SYSCON_PIOPORCAP0_RESERVED_Msk = 0xff000000

	// PIOPORCAP1: POR captured PIO status 1
	// Position of PIOSTAT field.
	SYSCON_PIOPORCAP1_PIOSTAT_Pos = 0x0
	// Bit mask of PIOSTAT field.
	SYSCON_PIOPORCAP1_PIOSTAT_Msk = 0xffffffff

	// BODCTRL: Brown-Out Detect
	// Position of BODRSTLEV field.
	SYSCON_BODCTRL_BODRSTLEV_Pos = 0x0
	// Bit mask of BODRSTLEV field.
	SYSCON_BODCTRL_BODRSTLEV_Msk = 0x3
	// Level 0: The reset assertion threshold voltage is 1.46 V; the reset de-assertion threshold voltage is 1.63 V.
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_0_THE_RESET_A = 0x0
	// Level 1: The reset assertion threshold voltage is 2.06 V; the reset de-assertion threshold voltage is 2.15 V.
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_1_THE_RESET_A = 0x1
	// Level 2: The reset assertion threshold voltage is 2.35 V; the reset de-assertion threshold voltage is 2.43 V.
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_2_THE_RESET_A = 0x2
	// Level 3: The reset assertion threshold voltage is 2.63 V; the reset de-assertion threshold voltage is 2.71 V.
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_3_THE_RESET_A = 0x3
	// Position of BODINTVAL field.
	SYSCON_BODCTRL_BODINTVAL_Pos = 0x2
	// Bit mask of BODINTVAL field.
	SYSCON_BODCTRL_BODINTVAL_Msk = 0xc
	// Level 0: Reserved.
	SYSCON_BODCTRL_BODINTVAL_LEVEL_0_RESERVED_ = 0x0
	// Level 1:The interrupt assertion threshold voltage is 2.22 V; the interrupt de-assertion threshold voltage is 2.35 V.
	SYSCON_BODCTRL_BODINTVAL_LEVEL_1THE_INTERRUP = 0x1
	// Level 2: The interrupt assertion threshold voltage is 2.52 V; the interrupt de-assertion threshold voltage is 2.66 V.
	SYSCON_BODCTRL_BODINTVAL_LEVEL_2_THE_INTERRU = 0x2
	// Level 3: The interrupt assertion threshold voltage is 2.80 V; the interrupt de-assertion threshold voltage is 2.90 V.
	SYSCON_BODCTRL_BODINTVAL_LEVEL_3_THE_INTERRU = 0x3
	// Position of BODRSTENA field.
	SYSCON_BODCTRL_BODRSTENA_Pos = 0x4
	// Bit mask of BODRSTENA field.
	SYSCON_BODCTRL_BODRSTENA_Msk = 0x10
	// Bit BODRSTENA.
	SYSCON_BODCTRL_BODRSTENA = 0x10
	// Disable reset function.
	SYSCON_BODCTRL_BODRSTENA_DISABLE_RESET_FUNCTI = 0x0
	// Enable reset function.
	SYSCON_BODCTRL_BODRSTENA_ENABLE_RESET_FUNCTIO = 0x1
	// Position of RESERVED field.
	SYSCON_BODCTRL_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_BODCTRL_RESERVED_Msk = 0xffffffe0

	// SYSTCKCAL: System tick counter calibration
	// Position of CAL field.
	SYSCON_SYSTCKCAL_CAL_Pos = 0x0
	// Bit mask of CAL field.
	SYSCON_SYSTCKCAL_CAL_Msk = 0x3ffffff
	// Position of RESERVED field.
	SYSCON_SYSTCKCAL_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	SYSCON_SYSTCKCAL_RESERVED_Msk = 0xfc000000

	// IRQLATENCY: IQR delay. Allows trade-off between interrupt latency and determinism.
	// Position of LATENCY field.
	SYSCON_IRQLATENCY_LATENCY_Pos = 0x0
	// Bit mask of LATENCY field.
	SYSCON_IRQLATENCY_LATENCY_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IRQLATENCY_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IRQLATENCY_RESERVED_Msk = 0xffffff00

	// NMISRC: NMI Source Control
	// Position of IRQNO field.
	SYSCON_NMISRC_IRQNO_Pos = 0x0
	// Bit mask of IRQNO field.
	SYSCON_NMISRC_IRQNO_Msk = 0x1f
	// Position of RESERVED field.
	SYSCON_NMISRC_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_NMISRC_RESERVED_Msk = 0x7fffffe0
	// Position of NMIEN field.
	SYSCON_NMISRC_NMIEN_Pos = 0x1f
	// Bit mask of NMIEN field.
	SYSCON_NMISRC_NMIEN_Msk = 0x80000000
	// Bit NMIEN.
	SYSCON_NMISRC_NMIEN = 0x80000000

	// PINTSEL0: GPIO Pin Interrupt Select register 0
	// Position of INTPIN field.
	SYSCON_PINTSEL_INTPIN_Pos = 0x0
	// Bit mask of INTPIN field.
	SYSCON_PINTSEL_INTPIN_Msk = 0x3f
	// Position of RESERVED field.
	SYSCON_PINTSEL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SYSCON_PINTSEL_RESERVED_Msk = 0xffffffc0

	// USBCLKCTRL: USB clock control
	// Position of AP_CLK field.
	SYSCON_USBCLKCTRL_AP_CLK_Pos = 0x0
	// Bit mask of AP_CLK field.
	SYSCON_USBCLKCTRL_AP_CLK_Msk = 0x1
	// Bit AP_CLK.
	SYSCON_USBCLKCTRL_AP_CLK = 0x1
	// Under hardware control.
	SYSCON_USBCLKCTRL_AP_CLK_UNDER_HARDWARE_CONTR = 0x0
	// Forced HIGH.
	SYSCON_USBCLKCTRL_AP_CLK_FORCED_HIGH_ = 0x1
	// Position of POL_CLK field.
	SYSCON_USBCLKCTRL_POL_CLK_Pos = 0x1
	// Bit mask of POL_CLK field.
	SYSCON_USBCLKCTRL_POL_CLK_Msk = 0x2
	// Bit POL_CLK.
	SYSCON_USBCLKCTRL_POL_CLK = 0x2
	// Falling edge of the USB need_clock triggers the USB wake-up (default).
	SYSCON_USBCLKCTRL_POL_CLK_FALLING_EDGE_OF_THE_ = 0x0
	// Rising edge of the USB need_clock triggers the USB wake-up.
	SYSCON_USBCLKCTRL_POL_CLK_RISING_EDGE_OF_THE_U = 0x1
	// Position of RESERVED field.
	SYSCON_USBCLKCTRL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_USBCLKCTRL_RESERVED_Msk = 0xfffffffc

	// USBCLKST: USB clock status
	// Position of NEED_CLKST field.
	SYSCON_USBCLKST_NEED_CLKST_Pos = 0x0
	// Bit mask of NEED_CLKST field.
	SYSCON_USBCLKST_NEED_CLKST_Msk = 0x1
	// Bit NEED_CLKST.
	SYSCON_USBCLKST_NEED_CLKST = 0x1
	// LOW
	SYSCON_USBCLKST_NEED_CLKST_LOW = 0x0
	// HIGH
	SYSCON_USBCLKST_NEED_CLKST_HIGH = 0x1
	// Position of RESERVED field.
	SYSCON_USBCLKST_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_USBCLKST_RESERVED_Msk = 0xfffffffe

	// STARTERP0: Start logic 0 interrupt wake-up enable register 0
	// Position of PINT0 field.
	SYSCON_STARTERP0_PINT0_Pos = 0x0
	// Bit mask of PINT0 field.
	SYSCON_STARTERP0_PINT0_Msk = 0x1
	// Bit PINT0.
	SYSCON_STARTERP0_PINT0 = 0x1
	// Disabled
	SYSCON_STARTERP0_PINT0_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT0_ENABLED = 0x1
	// Position of PINT1 field.
	SYSCON_STARTERP0_PINT1_Pos = 0x1
	// Bit mask of PINT1 field.
	SYSCON_STARTERP0_PINT1_Msk = 0x2
	// Bit PINT1.
	SYSCON_STARTERP0_PINT1 = 0x2
	// Disabled
	SYSCON_STARTERP0_PINT1_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT1_ENABLED = 0x1
	// Position of PINT2 field.
	SYSCON_STARTERP0_PINT2_Pos = 0x2
	// Bit mask of PINT2 field.
	SYSCON_STARTERP0_PINT2_Msk = 0x4
	// Bit PINT2.
	SYSCON_STARTERP0_PINT2 = 0x4
	// Disabled
	SYSCON_STARTERP0_PINT2_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT2_ENABLED = 0x1
	// Position of PINT3 field.
	SYSCON_STARTERP0_PINT3_Pos = 0x3
	// Bit mask of PINT3 field.
	SYSCON_STARTERP0_PINT3_Msk = 0x8
	// Bit PINT3.
	SYSCON_STARTERP0_PINT3 = 0x8
	// Disabled
	SYSCON_STARTERP0_PINT3_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT3_ENABLED = 0x1
	// Position of PINT4 field.
	SYSCON_STARTERP0_PINT4_Pos = 0x4
	// Bit mask of PINT4 field.
	SYSCON_STARTERP0_PINT4_Msk = 0x10
	// Bit PINT4.
	SYSCON_STARTERP0_PINT4 = 0x10
	// Disabled
	SYSCON_STARTERP0_PINT4_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT4_ENABLED = 0x1
	// Position of PINT5 field.
	SYSCON_STARTERP0_PINT5_Pos = 0x5
	// Bit mask of PINT5 field.
	SYSCON_STARTERP0_PINT5_Msk = 0x20
	// Bit PINT5.
	SYSCON_STARTERP0_PINT5 = 0x20
	// Disabled
	SYSCON_STARTERP0_PINT5_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT5_ENABLED = 0x1
	// Position of PINT6 field.
	SYSCON_STARTERP0_PINT6_Pos = 0x6
	// Bit mask of PINT6 field.
	SYSCON_STARTERP0_PINT6_Msk = 0x40
	// Bit PINT6.
	SYSCON_STARTERP0_PINT6 = 0x40
	// Disabled
	SYSCON_STARTERP0_PINT6_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT6_ENABLED = 0x1
	// Position of PINT7 field.
	SYSCON_STARTERP0_PINT7_Pos = 0x7
	// Bit mask of PINT7 field.
	SYSCON_STARTERP0_PINT7_Msk = 0x80
	// Bit PINT7.
	SYSCON_STARTERP0_PINT7 = 0x80
	// Disabled
	SYSCON_STARTERP0_PINT7_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT7_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Msk = 0xffffff00

	// STARTERP1: Start logic 1 interrupt wake-up enable register 1
	// Position of WWDTINT field.
	SYSCON_STARTERP1_WWDTINT_Pos = 0xc
	// Bit mask of WWDTINT field.
	SYSCON_STARTERP1_WWDTINT_Msk = 0x1000
	// Bit WWDTINT.
	SYSCON_STARTERP1_WWDTINT = 0x1000
	// Disabled
	SYSCON_STARTERP1_WWDTINT_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_WWDTINT_ENABLED = 0x1
	// Position of BODINT field.
	SYSCON_STARTERP1_BODINT_Pos = 0xd
	// Bit mask of BODINT field.
	SYSCON_STARTERP1_BODINT_Msk = 0x2000
	// Bit BODINT.
	SYSCON_STARTERP1_BODINT = 0x2000
	// Disabled
	SYSCON_STARTERP1_BODINT_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_BODINT_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Msk = 0x7c000
	// Position of USB_WAKEUP field.
	SYSCON_STARTERP1_USB_WAKEUP_Pos = 0x13
	// Bit mask of USB_WAKEUP field.
	SYSCON_STARTERP1_USB_WAKEUP_Msk = 0x80000
	// Bit USB_WAKEUP.
	SYSCON_STARTERP1_USB_WAKEUP = 0x80000
	// Disabled
	SYSCON_STARTERP1_USB_WAKEUP_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_USB_WAKEUP_ENABLED = 0x1
	// Position of GPIOINT0 field.
	SYSCON_STARTERP1_GPIOINT0_Pos = 0x14
	// Bit mask of GPIOINT0 field.
	SYSCON_STARTERP1_GPIOINT0_Msk = 0x100000
	// Bit GPIOINT0.
	SYSCON_STARTERP1_GPIOINT0 = 0x100000
	// Disabled
	SYSCON_STARTERP1_GPIOINT0_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_GPIOINT0_ENABLED = 0x1
	// Position of GPIOINT1 field.
	SYSCON_STARTERP1_GPIOINT1_Pos = 0x15
	// Bit mask of GPIOINT1 field.
	SYSCON_STARTERP1_GPIOINT1_Msk = 0x200000
	// Bit GPIOINT1.
	SYSCON_STARTERP1_GPIOINT1 = 0x200000
	// Disabled
	SYSCON_STARTERP1_GPIOINT1_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_GPIOINT1_ENABLED = 0x1

	// PDSLEEPCFG: Power-down states in deep-sleep mode
	// Position of BOD_PD field.
	SYSCON_PDSLEEPCFG_BOD_PD_Pos = 0x3
	// Bit mask of BOD_PD field.
	SYSCON_PDSLEEPCFG_BOD_PD_Msk = 0x8
	// Bit BOD_PD.
	SYSCON_PDSLEEPCFG_BOD_PD = 0x8
	// Powered
	SYSCON_PDSLEEPCFG_BOD_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDSLEEPCFG_BOD_PD_POWERED_DOWN = 0x1
	// Position of WDTOSC_PD field.
	SYSCON_PDSLEEPCFG_WDTOSC_PD_Pos = 0x6
	// Bit mask of WDTOSC_PD field.
	SYSCON_PDSLEEPCFG_WDTOSC_PD_Msk = 0x40
	// Bit WDTOSC_PD.
	SYSCON_PDSLEEPCFG_WDTOSC_PD = 0x40
	// Powered
	SYSCON_PDSLEEPCFG_WDTOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDSLEEPCFG_WDTOSC_PD_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Msk = 0xffffff80

	// PDAWAKECFG: Power-down states for wake-up from deep-sleep
	// Position of IRCOUT_PD field.
	SYSCON_PDAWAKECFG_IRCOUT_PD_Pos = 0x0
	// Bit mask of IRCOUT_PD field.
	SYSCON_PDAWAKECFG_IRCOUT_PD_Msk = 0x1
	// Bit IRCOUT_PD.
	SYSCON_PDAWAKECFG_IRCOUT_PD = 0x1
	// Powered
	SYSCON_PDAWAKECFG_IRCOUT_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_IRCOUT_PD_POWERED_DOWN = 0x1
	// Position of IRC_PD field.
	SYSCON_PDAWAKECFG_IRC_PD_Pos = 0x1
	// Bit mask of IRC_PD field.
	SYSCON_PDAWAKECFG_IRC_PD_Msk = 0x2
	// Bit IRC_PD.
	SYSCON_PDAWAKECFG_IRC_PD = 0x2
	// Powered
	SYSCON_PDAWAKECFG_IRC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_IRC_PD_POWERED_DOWN = 0x1
	// Position of FLASH_PD field.
	SYSCON_PDAWAKECFG_FLASH_PD_Pos = 0x2
	// Bit mask of FLASH_PD field.
	SYSCON_PDAWAKECFG_FLASH_PD_Msk = 0x4
	// Bit FLASH_PD.
	SYSCON_PDAWAKECFG_FLASH_PD = 0x4
	// Powered
	SYSCON_PDAWAKECFG_FLASH_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_FLASH_PD_POWERED_DOWN = 0x1
	// Position of BOD_PD field.
	SYSCON_PDAWAKECFG_BOD_PD_Pos = 0x3
	// Bit mask of BOD_PD field.
	SYSCON_PDAWAKECFG_BOD_PD_Msk = 0x8
	// Bit BOD_PD.
	SYSCON_PDAWAKECFG_BOD_PD = 0x8
	// Powered
	SYSCON_PDAWAKECFG_BOD_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_BOD_PD_POWERED_DOWN = 0x1
	// Position of ADC_PD field.
	SYSCON_PDAWAKECFG_ADC_PD_Pos = 0x4
	// Bit mask of ADC_PD field.
	SYSCON_PDAWAKECFG_ADC_PD_Msk = 0x10
	// Bit ADC_PD.
	SYSCON_PDAWAKECFG_ADC_PD = 0x10
	// Powered
	SYSCON_PDAWAKECFG_ADC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_ADC_PD_POWERED_DOWN = 0x1
	// Position of SYSOSC_PD field.
	SYSCON_PDAWAKECFG_SYSOSC_PD_Pos = 0x5
	// Bit mask of SYSOSC_PD field.
	SYSCON_PDAWAKECFG_SYSOSC_PD_Msk = 0x20
	// Bit SYSOSC_PD.
	SYSCON_PDAWAKECFG_SYSOSC_PD = 0x20
	// Powered
	SYSCON_PDAWAKECFG_SYSOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_SYSOSC_PD_POWERED_DOWN = 0x1
	// Position of WDTOSC_PD field.
	SYSCON_PDAWAKECFG_WDTOSC_PD_Pos = 0x6
	// Bit mask of WDTOSC_PD field.
	SYSCON_PDAWAKECFG_WDTOSC_PD_Msk = 0x40
	// Bit WDTOSC_PD.
	SYSCON_PDAWAKECFG_WDTOSC_PD = 0x40
	// Powered
	SYSCON_PDAWAKECFG_WDTOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_WDTOSC_PD_POWERED_DOWN = 0x1
	// Position of SYSPLL_PD field.
	SYSCON_PDAWAKECFG_SYSPLL_PD_Pos = 0x7
	// Bit mask of SYSPLL_PD field.
	SYSCON_PDAWAKECFG_SYSPLL_PD_Msk = 0x80
	// Bit SYSPLL_PD.
	SYSCON_PDAWAKECFG_SYSPLL_PD = 0x80
	// Powered
	SYSCON_PDAWAKECFG_SYSPLL_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_SYSPLL_PD_POWERED_DOWN = 0x1
	// Position of USBPLL_PD field.
	SYSCON_PDAWAKECFG_USBPLL_PD_Pos = 0x8
	// Bit mask of USBPLL_PD field.
	SYSCON_PDAWAKECFG_USBPLL_PD_Msk = 0x100
	// Bit USBPLL_PD.
	SYSCON_PDAWAKECFG_USBPLL_PD = 0x100
	// Powered
	SYSCON_PDAWAKECFG_USBPLL_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_USBPLL_PD_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0x200
	// Bit RESERVED.
	SYSCON_PDAWAKECFG_RESERVED = 0x200
	// Position of USBPAD_PD field.
	SYSCON_PDAWAKECFG_USBPAD_PD_Pos = 0xa
	// Bit mask of USBPAD_PD field.
	SYSCON_PDAWAKECFG_USBPAD_PD_Msk = 0x400
	// Bit USBPAD_PD.
	SYSCON_PDAWAKECFG_USBPAD_PD = 0x400
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0x800
	// Bit RESERVED.
	SYSCON_PDAWAKECFG_RESERVED = 0x800
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0x1000
	// Bit RESERVED.
	SYSCON_PDAWAKECFG_RESERVED = 0x1000
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0xe000
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0xffff0000

	// PDRUNCFG: Power configuration register
	// Position of IRCOUT_PD field.
	SYSCON_PDRUNCFG_IRCOUT_PD_Pos = 0x0
	// Bit mask of IRCOUT_PD field.
	SYSCON_PDRUNCFG_IRCOUT_PD_Msk = 0x1
	// Bit IRCOUT_PD.
	SYSCON_PDRUNCFG_IRCOUT_PD = 0x1
	// Powered
	SYSCON_PDRUNCFG_IRCOUT_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_IRCOUT_PD_POWERED_DOWN = 0x1
	// Position of IRC_PD field.
	SYSCON_PDRUNCFG_IRC_PD_Pos = 0x1
	// Bit mask of IRC_PD field.
	SYSCON_PDRUNCFG_IRC_PD_Msk = 0x2
	// Bit IRC_PD.
	SYSCON_PDRUNCFG_IRC_PD = 0x2
	// Powered
	SYSCON_PDRUNCFG_IRC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_IRC_PD_POWERED_DOWN = 0x1
	// Position of FLASH_PD field.
	SYSCON_PDRUNCFG_FLASH_PD_Pos = 0x2
	// Bit mask of FLASH_PD field.
	SYSCON_PDRUNCFG_FLASH_PD_Msk = 0x4
	// Bit FLASH_PD.
	SYSCON_PDRUNCFG_FLASH_PD = 0x4
	// Powered
	SYSCON_PDRUNCFG_FLASH_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_FLASH_PD_POWERED_DOWN = 0x1
	// Position of BOD_PD field.
	SYSCON_PDRUNCFG_BOD_PD_Pos = 0x3
	// Bit mask of BOD_PD field.
	SYSCON_PDRUNCFG_BOD_PD_Msk = 0x8
	// Bit BOD_PD.
	SYSCON_PDRUNCFG_BOD_PD = 0x8
	// Powered
	SYSCON_PDRUNCFG_BOD_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_BOD_PD_POWERED_DOWN = 0x1
	// Position of ADC_PD field.
	SYSCON_PDRUNCFG_ADC_PD_Pos = 0x4
	// Bit mask of ADC_PD field.
	SYSCON_PDRUNCFG_ADC_PD_Msk = 0x10
	// Bit ADC_PD.
	SYSCON_PDRUNCFG_ADC_PD = 0x10
	// Powered
	SYSCON_PDRUNCFG_ADC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_ADC_PD_POWERED_DOWN = 0x1
	// Position of SYSOSC_PD field.
	SYSCON_PDRUNCFG_SYSOSC_PD_Pos = 0x5
	// Bit mask of SYSOSC_PD field.
	SYSCON_PDRUNCFG_SYSOSC_PD_Msk = 0x20
	// Bit SYSOSC_PD.
	SYSCON_PDRUNCFG_SYSOSC_PD = 0x20
	// Powered
	SYSCON_PDRUNCFG_SYSOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_SYSOSC_PD_POWERED_DOWN = 0x1
	// Position of WDTOSC_PD field.
	SYSCON_PDRUNCFG_WDTOSC_PD_Pos = 0x6
	// Bit mask of WDTOSC_PD field.
	SYSCON_PDRUNCFG_WDTOSC_PD_Msk = 0x40
	// Bit WDTOSC_PD.
	SYSCON_PDRUNCFG_WDTOSC_PD = 0x40
	// Powered
	SYSCON_PDRUNCFG_WDTOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_WDTOSC_PD_POWERED_DOWN = 0x1
	// Position of SYSPLL_PD field.
	SYSCON_PDRUNCFG_SYSPLL_PD_Pos = 0x7
	// Bit mask of SYSPLL_PD field.
	SYSCON_PDRUNCFG_SYSPLL_PD_Msk = 0x80
	// Bit SYSPLL_PD.
	SYSCON_PDRUNCFG_SYSPLL_PD = 0x80
	// Powered
	SYSCON_PDRUNCFG_SYSPLL_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_SYSPLL_PD_POWERED_DOWN = 0x1
	// Position of USBPLL_PD field.
	SYSCON_PDRUNCFG_USBPLL_PD_Pos = 0x8
	// Bit mask of USBPLL_PD field.
	SYSCON_PDRUNCFG_USBPLL_PD_Msk = 0x100
	// Bit USBPLL_PD.
	SYSCON_PDRUNCFG_USBPLL_PD = 0x100
	// Powered
	SYSCON_PDRUNCFG_USBPLL_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_USBPLL_PD_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x200
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x200
	// Position of USBPAD_PD field.
	SYSCON_PDRUNCFG_USBPAD_PD_Pos = 0xa
	// Bit mask of USBPAD_PD field.
	SYSCON_PDRUNCFG_USBPAD_PD_Msk = 0x400
	// Bit USBPAD_PD.
	SYSCON_PDRUNCFG_USBPAD_PD = 0x400
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x800
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x800
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x1000
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x1000
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0xe000
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0xffff0000

	// DEVICE_ID: Device ID
	// Position of DEVICEID field.
	SYSCON_DEVICE_ID_DEVICEID_Pos = 0x0
	// Bit mask of DEVICEID field.
	SYSCON_DEVICE_ID_DEVICEID_Msk = 0xffffffff
)

// Bitfields for GPIO_PIN_INT: GPIO pin interrupt
const (
	// ISEL: Pin Interrupt Mode register
	// Position of PMODE0 field.
	GPIO_PIN_INT_ISEL_PMODE0_Pos = 0x0
	// Bit mask of PMODE0 field.
	GPIO_PIN_INT_ISEL_PMODE0_Msk = 0x1
	// Bit PMODE0.
	GPIO_PIN_INT_ISEL_PMODE0 = 0x1
	// Position of PMODE1 field.
	GPIO_PIN_INT_ISEL_PMODE1_Pos = 0x1
	// Bit mask of PMODE1 field.
	GPIO_PIN_INT_ISEL_PMODE1_Msk = 0x2
	// Bit PMODE1.
	GPIO_PIN_INT_ISEL_PMODE1 = 0x2
	// Position of PMODE2 field.
	GPIO_PIN_INT_ISEL_PMODE2_Pos = 0x2
	// Bit mask of PMODE2 field.
	GPIO_PIN_INT_ISEL_PMODE2_Msk = 0x4
	// Bit PMODE2.
	GPIO_PIN_INT_ISEL_PMODE2 = 0x4
	// Position of PMODE3 field.
	GPIO_PIN_INT_ISEL_PMODE3_Pos = 0x3
	// Bit mask of PMODE3 field.
	GPIO_PIN_INT_ISEL_PMODE3_Msk = 0x8
	// Bit PMODE3.
	GPIO_PIN_INT_ISEL_PMODE3 = 0x8
	// Position of PMODE4 field.
	GPIO_PIN_INT_ISEL_PMODE4_Pos = 0x4
	// Bit mask of PMODE4 field.
	GPIO_PIN_INT_ISEL_PMODE4_Msk = 0x10
	// Bit PMODE4.
	GPIO_PIN_INT_ISEL_PMODE4 = 0x10
	// Position of PMODE5 field.
	GPIO_PIN_INT_ISEL_PMODE5_Pos = 0x5
	// Bit mask of PMODE5 field.
	GPIO_PIN_INT_ISEL_PMODE5_Msk = 0x20
	// Bit PMODE5.
	GPIO_PIN_INT_ISEL_PMODE5 = 0x20
	// Position of PMODE6 field.
	GPIO_PIN_INT_ISEL_PMODE6_Pos = 0x6
	// Bit mask of PMODE6 field.
	GPIO_PIN_INT_ISEL_PMODE6_Msk = 0x40
	// Bit PMODE6.
	GPIO_PIN_INT_ISEL_PMODE6 = 0x40
	// Position of PMODE7 field.
	GPIO_PIN_INT_ISEL_PMODE7_Pos = 0x7
	// Bit mask of PMODE7 field.
	GPIO_PIN_INT_ISEL_PMODE7_Msk = 0x80
	// Bit PMODE7.
	GPIO_PIN_INT_ISEL_PMODE7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_ISEL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_ISEL_RESERVED_Msk = 0xffffff00

	// IENR: Pin Interrupt Enable (Rising) register
	// Position of ENRL0 field.
	GPIO_PIN_INT_IENR_ENRL0_Pos = 0x0
	// Bit mask of ENRL0 field.
	GPIO_PIN_INT_IENR_ENRL0_Msk = 0x1
	// Bit ENRL0.
	GPIO_PIN_INT_IENR_ENRL0 = 0x1
	// Position of ENRL1 field.
	GPIO_PIN_INT_IENR_ENRL1_Pos = 0x1
	// Bit mask of ENRL1 field.
	GPIO_PIN_INT_IENR_ENRL1_Msk = 0x2
	// Bit ENRL1.
	GPIO_PIN_INT_IENR_ENRL1 = 0x2
	// Position of ENRL2 field.
	GPIO_PIN_INT_IENR_ENRL2_Pos = 0x2
	// Bit mask of ENRL2 field.
	GPIO_PIN_INT_IENR_ENRL2_Msk = 0x4
	// Bit ENRL2.
	GPIO_PIN_INT_IENR_ENRL2 = 0x4
	// Position of ENRL3 field.
	GPIO_PIN_INT_IENR_ENRL3_Pos = 0x3
	// Bit mask of ENRL3 field.
	GPIO_PIN_INT_IENR_ENRL3_Msk = 0x8
	// Bit ENRL3.
	GPIO_PIN_INT_IENR_ENRL3 = 0x8
	// Position of ENRL4 field.
	GPIO_PIN_INT_IENR_ENRL4_Pos = 0x4
	// Bit mask of ENRL4 field.
	GPIO_PIN_INT_IENR_ENRL4_Msk = 0x10
	// Bit ENRL4.
	GPIO_PIN_INT_IENR_ENRL4 = 0x10
	// Position of ENRL5 field.
	GPIO_PIN_INT_IENR_ENRL5_Pos = 0x5
	// Bit mask of ENRL5 field.
	GPIO_PIN_INT_IENR_ENRL5_Msk = 0x20
	// Bit ENRL5.
	GPIO_PIN_INT_IENR_ENRL5 = 0x20
	// Position of ENRL6 field.
	GPIO_PIN_INT_IENR_ENRL6_Pos = 0x6
	// Bit mask of ENRL6 field.
	GPIO_PIN_INT_IENR_ENRL6_Msk = 0x40
	// Bit ENRL6.
	GPIO_PIN_INT_IENR_ENRL6 = 0x40
	// Position of ENRL7 field.
	GPIO_PIN_INT_IENR_ENRL7_Pos = 0x7
	// Bit mask of ENRL7 field.
	GPIO_PIN_INT_IENR_ENRL7_Msk = 0x80
	// Bit ENRL7.
	GPIO_PIN_INT_IENR_ENRL7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_IENR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_IENR_RESERVED_Msk = 0xffffff00

	// SIENR: Set Pin Interrupt Enable (Rising) register
	// Position of SETENRL0 field.
	GPIO_PIN_INT_SIENR_SETENRL0_Pos = 0x0
	// Bit mask of SETENRL0 field.
	GPIO_PIN_INT_SIENR_SETENRL0_Msk = 0x1
	// Bit SETENRL0.
	GPIO_PIN_INT_SIENR_SETENRL0 = 0x1
	// Position of SETENRL1 field.
	GPIO_PIN_INT_SIENR_SETENRL1_Pos = 0x1
	// Bit mask of SETENRL1 field.
	GPIO_PIN_INT_SIENR_SETENRL1_Msk = 0x2
	// Bit SETENRL1.
	GPIO_PIN_INT_SIENR_SETENRL1 = 0x2
	// Position of SETENRL2 field.
	GPIO_PIN_INT_SIENR_SETENRL2_Pos = 0x2
	// Bit mask of SETENRL2 field.
	GPIO_PIN_INT_SIENR_SETENRL2_Msk = 0x4
	// Bit SETENRL2.
	GPIO_PIN_INT_SIENR_SETENRL2 = 0x4
	// Position of SETENRL3 field.
	GPIO_PIN_INT_SIENR_SETENRL3_Pos = 0x3
	// Bit mask of SETENRL3 field.
	GPIO_PIN_INT_SIENR_SETENRL3_Msk = 0x8
	// Bit SETENRL3.
	GPIO_PIN_INT_SIENR_SETENRL3 = 0x8
	// Position of SETENRL4 field.
	GPIO_PIN_INT_SIENR_SETENRL4_Pos = 0x4
	// Bit mask of SETENRL4 field.
	GPIO_PIN_INT_SIENR_SETENRL4_Msk = 0x10
	// Bit SETENRL4.
	GPIO_PIN_INT_SIENR_SETENRL4 = 0x10
	// Position of SETENRL5 field.
	GPIO_PIN_INT_SIENR_SETENRL5_Pos = 0x5
	// Bit mask of SETENRL5 field.
	GPIO_PIN_INT_SIENR_SETENRL5_Msk = 0x20
	// Bit SETENRL5.
	GPIO_PIN_INT_SIENR_SETENRL5 = 0x20
	// Position of SETENRL6 field.
	GPIO_PIN_INT_SIENR_SETENRL6_Pos = 0x6
	// Bit mask of SETENRL6 field.
	GPIO_PIN_INT_SIENR_SETENRL6_Msk = 0x40
	// Bit SETENRL6.
	GPIO_PIN_INT_SIENR_SETENRL6 = 0x40
	// Position of SETENRL7 field.
	GPIO_PIN_INT_SIENR_SETENRL7_Pos = 0x7
	// Bit mask of SETENRL7 field.
	GPIO_PIN_INT_SIENR_SETENRL7_Msk = 0x80
	// Bit SETENRL7.
	GPIO_PIN_INT_SIENR_SETENRL7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_SIENR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_SIENR_RESERVED_Msk = 0xffffff00

	// CIENR: Clear Pin Interrupt Enable (Rising) register
	// Position of CENRL0 field.
	GPIO_PIN_INT_CIENR_CENRL0_Pos = 0x0
	// Bit mask of CENRL0 field.
	GPIO_PIN_INT_CIENR_CENRL0_Msk = 0x1
	// Bit CENRL0.
	GPIO_PIN_INT_CIENR_CENRL0 = 0x1
	// Position of CENRL1 field.
	GPIO_PIN_INT_CIENR_CENRL1_Pos = 0x1
	// Bit mask of CENRL1 field.
	GPIO_PIN_INT_CIENR_CENRL1_Msk = 0x2
	// Bit CENRL1.
	GPIO_PIN_INT_CIENR_CENRL1 = 0x2
	// Position of CENRL2 field.
	GPIO_PIN_INT_CIENR_CENRL2_Pos = 0x2
	// Bit mask of CENRL2 field.
	GPIO_PIN_INT_CIENR_CENRL2_Msk = 0x4
	// Bit CENRL2.
	GPIO_PIN_INT_CIENR_CENRL2 = 0x4
	// Position of CENRL3 field.
	GPIO_PIN_INT_CIENR_CENRL3_Pos = 0x3
	// Bit mask of CENRL3 field.
	GPIO_PIN_INT_CIENR_CENRL3_Msk = 0x8
	// Bit CENRL3.
	GPIO_PIN_INT_CIENR_CENRL3 = 0x8
	// Position of CENRL4 field.
	GPIO_PIN_INT_CIENR_CENRL4_Pos = 0x4
	// Bit mask of CENRL4 field.
	GPIO_PIN_INT_CIENR_CENRL4_Msk = 0x10
	// Bit CENRL4.
	GPIO_PIN_INT_CIENR_CENRL4 = 0x10
	// Position of CENRL5 field.
	GPIO_PIN_INT_CIENR_CENRL5_Pos = 0x5
	// Bit mask of CENRL5 field.
	GPIO_PIN_INT_CIENR_CENRL5_Msk = 0x20
	// Bit CENRL5.
	GPIO_PIN_INT_CIENR_CENRL5 = 0x20
	// Position of CENRL6 field.
	GPIO_PIN_INT_CIENR_CENRL6_Pos = 0x6
	// Bit mask of CENRL6 field.
	GPIO_PIN_INT_CIENR_CENRL6_Msk = 0x40
	// Bit CENRL6.
	GPIO_PIN_INT_CIENR_CENRL6 = 0x40
	// Position of CENRL7 field.
	GPIO_PIN_INT_CIENR_CENRL7_Pos = 0x7
	// Bit mask of CENRL7 field.
	GPIO_PIN_INT_CIENR_CENRL7_Msk = 0x80
	// Bit CENRL7.
	GPIO_PIN_INT_CIENR_CENRL7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_CIENR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_CIENR_RESERVED_Msk = 0xffffff00

	// IENF: Pin Interrupt Enable Falling Edge / Active Level register
	// Position of ENAF0 field.
	GPIO_PIN_INT_IENF_ENAF0_Pos = 0x0
	// Bit mask of ENAF0 field.
	GPIO_PIN_INT_IENF_ENAF0_Msk = 0x1
	// Bit ENAF0.
	GPIO_PIN_INT_IENF_ENAF0 = 0x1
	// Position of ENAF1 field.
	GPIO_PIN_INT_IENF_ENAF1_Pos = 0x1
	// Bit mask of ENAF1 field.
	GPIO_PIN_INT_IENF_ENAF1_Msk = 0x2
	// Bit ENAF1.
	GPIO_PIN_INT_IENF_ENAF1 = 0x2
	// Position of ENAF2 field.
	GPIO_PIN_INT_IENF_ENAF2_Pos = 0x2
	// Bit mask of ENAF2 field.
	GPIO_PIN_INT_IENF_ENAF2_Msk = 0x4
	// Bit ENAF2.
	GPIO_PIN_INT_IENF_ENAF2 = 0x4
	// Position of ENAF3 field.
	GPIO_PIN_INT_IENF_ENAF3_Pos = 0x3
	// Bit mask of ENAF3 field.
	GPIO_PIN_INT_IENF_ENAF3_Msk = 0x8
	// Bit ENAF3.
	GPIO_PIN_INT_IENF_ENAF3 = 0x8
	// Position of ENAF4 field.
	GPIO_PIN_INT_IENF_ENAF4_Pos = 0x4
	// Bit mask of ENAF4 field.
	GPIO_PIN_INT_IENF_ENAF4_Msk = 0x10
	// Bit ENAF4.
	GPIO_PIN_INT_IENF_ENAF4 = 0x10
	// Position of ENAF5 field.
	GPIO_PIN_INT_IENF_ENAF5_Pos = 0x5
	// Bit mask of ENAF5 field.
	GPIO_PIN_INT_IENF_ENAF5_Msk = 0x20
	// Bit ENAF5.
	GPIO_PIN_INT_IENF_ENAF5 = 0x20
	// Position of ENAF6 field.
	GPIO_PIN_INT_IENF_ENAF6_Pos = 0x6
	// Bit mask of ENAF6 field.
	GPIO_PIN_INT_IENF_ENAF6_Msk = 0x40
	// Bit ENAF6.
	GPIO_PIN_INT_IENF_ENAF6 = 0x40
	// Position of ENAF7 field.
	GPIO_PIN_INT_IENF_ENAF7_Pos = 0x7
	// Bit mask of ENAF7 field.
	GPIO_PIN_INT_IENF_ENAF7_Msk = 0x80
	// Bit ENAF7.
	GPIO_PIN_INT_IENF_ENAF7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_IENF_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_IENF_RESERVED_Msk = 0xffffff00

	// SIENF: Set Pin Interrupt Enable Falling Edge / Active Level register
	// Position of SETENAF0 field.
	GPIO_PIN_INT_SIENF_SETENAF0_Pos = 0x0
	// Bit mask of SETENAF0 field.
	GPIO_PIN_INT_SIENF_SETENAF0_Msk = 0x1
	// Bit SETENAF0.
	GPIO_PIN_INT_SIENF_SETENAF0 = 0x1
	// Position of SETENAF1 field.
	GPIO_PIN_INT_SIENF_SETENAF1_Pos = 0x1
	// Bit mask of SETENAF1 field.
	GPIO_PIN_INT_SIENF_SETENAF1_Msk = 0x2
	// Bit SETENAF1.
	GPIO_PIN_INT_SIENF_SETENAF1 = 0x2
	// Position of SETENAF2 field.
	GPIO_PIN_INT_SIENF_SETENAF2_Pos = 0x2
	// Bit mask of SETENAF2 field.
	GPIO_PIN_INT_SIENF_SETENAF2_Msk = 0x4
	// Bit SETENAF2.
	GPIO_PIN_INT_SIENF_SETENAF2 = 0x4
	// Position of SETENAF3 field.
	GPIO_PIN_INT_SIENF_SETENAF3_Pos = 0x3
	// Bit mask of SETENAF3 field.
	GPIO_PIN_INT_SIENF_SETENAF3_Msk = 0x8
	// Bit SETENAF3.
	GPIO_PIN_INT_SIENF_SETENAF3 = 0x8
	// Position of SETENAF4 field.
	GPIO_PIN_INT_SIENF_SETENAF4_Pos = 0x4
	// Bit mask of SETENAF4 field.
	GPIO_PIN_INT_SIENF_SETENAF4_Msk = 0x10
	// Bit SETENAF4.
	GPIO_PIN_INT_SIENF_SETENAF4 = 0x10
	// Position of SETENAF5 field.
	GPIO_PIN_INT_SIENF_SETENAF5_Pos = 0x5
	// Bit mask of SETENAF5 field.
	GPIO_PIN_INT_SIENF_SETENAF5_Msk = 0x20
	// Bit SETENAF5.
	GPIO_PIN_INT_SIENF_SETENAF5 = 0x20
	// Position of SETENAF6 field.
	GPIO_PIN_INT_SIENF_SETENAF6_Pos = 0x6
	// Bit mask of SETENAF6 field.
	GPIO_PIN_INT_SIENF_SETENAF6_Msk = 0x40
	// Bit SETENAF6.
	GPIO_PIN_INT_SIENF_SETENAF6 = 0x40
	// Position of SETENAF7 field.
	GPIO_PIN_INT_SIENF_SETENAF7_Pos = 0x7
	// Bit mask of SETENAF7 field.
	GPIO_PIN_INT_SIENF_SETENAF7_Msk = 0x80
	// Bit SETENAF7.
	GPIO_PIN_INT_SIENF_SETENAF7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_SIENF_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_SIENF_RESERVED_Msk = 0xffffff00

	// CIENF: Clear Pin Interrupt Enable Falling Edge / Active Level address
	// Position of CENAF0 field.
	GPIO_PIN_INT_CIENF_CENAF0_Pos = 0x0
	// Bit mask of CENAF0 field.
	GPIO_PIN_INT_CIENF_CENAF0_Msk = 0x1
	// Bit CENAF0.
	GPIO_PIN_INT_CIENF_CENAF0 = 0x1
	// Position of CENAF1 field.
	GPIO_PIN_INT_CIENF_CENAF1_Pos = 0x1
	// Bit mask of CENAF1 field.
	GPIO_PIN_INT_CIENF_CENAF1_Msk = 0x2
	// Bit CENAF1.
	GPIO_PIN_INT_CIENF_CENAF1 = 0x2
	// Position of CENAF2 field.
	GPIO_PIN_INT_CIENF_CENAF2_Pos = 0x2
	// Bit mask of CENAF2 field.
	GPIO_PIN_INT_CIENF_CENAF2_Msk = 0x4
	// Bit CENAF2.
	GPIO_PIN_INT_CIENF_CENAF2 = 0x4
	// Position of CENAF3 field.
	GPIO_PIN_INT_CIENF_CENAF3_Pos = 0x3
	// Bit mask of CENAF3 field.
	GPIO_PIN_INT_CIENF_CENAF3_Msk = 0x8
	// Bit CENAF3.
	GPIO_PIN_INT_CIENF_CENAF3 = 0x8
	// Position of CENAF4 field.
	GPIO_PIN_INT_CIENF_CENAF4_Pos = 0x4
	// Bit mask of CENAF4 field.
	GPIO_PIN_INT_CIENF_CENAF4_Msk = 0x10
	// Bit CENAF4.
	GPIO_PIN_INT_CIENF_CENAF4 = 0x10
	// Position of CENAF5 field.
	GPIO_PIN_INT_CIENF_CENAF5_Pos = 0x5
	// Bit mask of CENAF5 field.
	GPIO_PIN_INT_CIENF_CENAF5_Msk = 0x20
	// Bit CENAF5.
	GPIO_PIN_INT_CIENF_CENAF5 = 0x20
	// Position of CENAF6 field.
	GPIO_PIN_INT_CIENF_CENAF6_Pos = 0x6
	// Bit mask of CENAF6 field.
	GPIO_PIN_INT_CIENF_CENAF6_Msk = 0x40
	// Bit CENAF6.
	GPIO_PIN_INT_CIENF_CENAF6 = 0x40
	// Position of CENAF7 field.
	GPIO_PIN_INT_CIENF_CENAF7_Pos = 0x7
	// Bit mask of CENAF7 field.
	GPIO_PIN_INT_CIENF_CENAF7_Msk = 0x80
	// Bit CENAF7.
	GPIO_PIN_INT_CIENF_CENAF7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_CIENF_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_CIENF_RESERVED_Msk = 0xffffff00

	// RISE: Pin Interrupt Rising Edge register
	// Position of RDET0 field.
	GPIO_PIN_INT_RISE_RDET0_Pos = 0x0
	// Bit mask of RDET0 field.
	GPIO_PIN_INT_RISE_RDET0_Msk = 0x1
	// Bit RDET0.
	GPIO_PIN_INT_RISE_RDET0 = 0x1
	// Position of RDET1 field.
	GPIO_PIN_INT_RISE_RDET1_Pos = 0x1
	// Bit mask of RDET1 field.
	GPIO_PIN_INT_RISE_RDET1_Msk = 0x2
	// Bit RDET1.
	GPIO_PIN_INT_RISE_RDET1 = 0x2
	// Position of RDET2 field.
	GPIO_PIN_INT_RISE_RDET2_Pos = 0x2
	// Bit mask of RDET2 field.
	GPIO_PIN_INT_RISE_RDET2_Msk = 0x4
	// Bit RDET2.
	GPIO_PIN_INT_RISE_RDET2 = 0x4
	// Position of RDET3 field.
	GPIO_PIN_INT_RISE_RDET3_Pos = 0x3
	// Bit mask of RDET3 field.
	GPIO_PIN_INT_RISE_RDET3_Msk = 0x8
	// Bit RDET3.
	GPIO_PIN_INT_RISE_RDET3 = 0x8
	// Position of RDET4 field.
	GPIO_PIN_INT_RISE_RDET4_Pos = 0x4
	// Bit mask of RDET4 field.
	GPIO_PIN_INT_RISE_RDET4_Msk = 0x10
	// Bit RDET4.
	GPIO_PIN_INT_RISE_RDET4 = 0x10
	// Position of RDET5 field.
	GPIO_PIN_INT_RISE_RDET5_Pos = 0x5
	// Bit mask of RDET5 field.
	GPIO_PIN_INT_RISE_RDET5_Msk = 0x20
	// Bit RDET5.
	GPIO_PIN_INT_RISE_RDET5 = 0x20
	// Position of RDET6 field.
	GPIO_PIN_INT_RISE_RDET6_Pos = 0x6
	// Bit mask of RDET6 field.
	GPIO_PIN_INT_RISE_RDET6_Msk = 0x40
	// Bit RDET6.
	GPIO_PIN_INT_RISE_RDET6 = 0x40
	// Position of RDET7 field.
	GPIO_PIN_INT_RISE_RDET7_Pos = 0x7
	// Bit mask of RDET7 field.
	GPIO_PIN_INT_RISE_RDET7_Msk = 0x80
	// Bit RDET7.
	GPIO_PIN_INT_RISE_RDET7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_RISE_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_RISE_RESERVED_Msk = 0xffffff00

	// FALL: Pin Interrupt Falling Edge register
	// Position of FDET0 field.
	GPIO_PIN_INT_FALL_FDET0_Pos = 0x0
	// Bit mask of FDET0 field.
	GPIO_PIN_INT_FALL_FDET0_Msk = 0x1
	// Bit FDET0.
	GPIO_PIN_INT_FALL_FDET0 = 0x1
	// Position of FDET1 field.
	GPIO_PIN_INT_FALL_FDET1_Pos = 0x1
	// Bit mask of FDET1 field.
	GPIO_PIN_INT_FALL_FDET1_Msk = 0x2
	// Bit FDET1.
	GPIO_PIN_INT_FALL_FDET1 = 0x2
	// Position of FDET2 field.
	GPIO_PIN_INT_FALL_FDET2_Pos = 0x2
	// Bit mask of FDET2 field.
	GPIO_PIN_INT_FALL_FDET2_Msk = 0x4
	// Bit FDET2.
	GPIO_PIN_INT_FALL_FDET2 = 0x4
	// Position of FDET3 field.
	GPIO_PIN_INT_FALL_FDET3_Pos = 0x3
	// Bit mask of FDET3 field.
	GPIO_PIN_INT_FALL_FDET3_Msk = 0x8
	// Bit FDET3.
	GPIO_PIN_INT_FALL_FDET3 = 0x8
	// Position of FDET4 field.
	GPIO_PIN_INT_FALL_FDET4_Pos = 0x4
	// Bit mask of FDET4 field.
	GPIO_PIN_INT_FALL_FDET4_Msk = 0x10
	// Bit FDET4.
	GPIO_PIN_INT_FALL_FDET4 = 0x10
	// Position of FDET5 field.
	GPIO_PIN_INT_FALL_FDET5_Pos = 0x5
	// Bit mask of FDET5 field.
	GPIO_PIN_INT_FALL_FDET5_Msk = 0x20
	// Bit FDET5.
	GPIO_PIN_INT_FALL_FDET5 = 0x20
	// Position of FDET6 field.
	GPIO_PIN_INT_FALL_FDET6_Pos = 0x6
	// Bit mask of FDET6 field.
	GPIO_PIN_INT_FALL_FDET6_Msk = 0x40
	// Bit FDET6.
	GPIO_PIN_INT_FALL_FDET6 = 0x40
	// Position of FDET7 field.
	GPIO_PIN_INT_FALL_FDET7_Pos = 0x7
	// Bit mask of FDET7 field.
	GPIO_PIN_INT_FALL_FDET7_Msk = 0x80
	// Bit FDET7.
	GPIO_PIN_INT_FALL_FDET7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_FALL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_FALL_RESERVED_Msk = 0xffffff00

	// IST: Pin Interrupt Status register
	// Position of PSTAT0 field.
	GPIO_PIN_INT_IST_PSTAT0_Pos = 0x0
	// Bit mask of PSTAT0 field.
	GPIO_PIN_INT_IST_PSTAT0_Msk = 0x1
	// Bit PSTAT0.
	GPIO_PIN_INT_IST_PSTAT0 = 0x1
	// Position of PSTAT1 field.
	GPIO_PIN_INT_IST_PSTAT1_Pos = 0x1
	// Bit mask of PSTAT1 field.
	GPIO_PIN_INT_IST_PSTAT1_Msk = 0x2
	// Bit PSTAT1.
	GPIO_PIN_INT_IST_PSTAT1 = 0x2
	// Position of PSTAT2 field.
	GPIO_PIN_INT_IST_PSTAT2_Pos = 0x2
	// Bit mask of PSTAT2 field.
	GPIO_PIN_INT_IST_PSTAT2_Msk = 0x4
	// Bit PSTAT2.
	GPIO_PIN_INT_IST_PSTAT2 = 0x4
	// Position of PSTAT3 field.
	GPIO_PIN_INT_IST_PSTAT3_Pos = 0x3
	// Bit mask of PSTAT3 field.
	GPIO_PIN_INT_IST_PSTAT3_Msk = 0x8
	// Bit PSTAT3.
	GPIO_PIN_INT_IST_PSTAT3 = 0x8
	// Position of PSTAT4 field.
	GPIO_PIN_INT_IST_PSTAT4_Pos = 0x4
	// Bit mask of PSTAT4 field.
	GPIO_PIN_INT_IST_PSTAT4_Msk = 0x10
	// Bit PSTAT4.
	GPIO_PIN_INT_IST_PSTAT4 = 0x10
	// Position of PSTAT5 field.
	GPIO_PIN_INT_IST_PSTAT5_Pos = 0x5
	// Bit mask of PSTAT5 field.
	GPIO_PIN_INT_IST_PSTAT5_Msk = 0x20
	// Bit PSTAT5.
	GPIO_PIN_INT_IST_PSTAT5 = 0x20
	// Position of PSTAT6 field.
	GPIO_PIN_INT_IST_PSTAT6_Pos = 0x6
	// Bit mask of PSTAT6 field.
	GPIO_PIN_INT_IST_PSTAT6_Msk = 0x40
	// Bit PSTAT6.
	GPIO_PIN_INT_IST_PSTAT6 = 0x40
	// Position of PSTAT7 field.
	GPIO_PIN_INT_IST_PSTAT7_Pos = 0x7
	// Bit mask of PSTAT7 field.
	GPIO_PIN_INT_IST_PSTAT7_Msk = 0x80
	// Bit PSTAT7.
	GPIO_PIN_INT_IST_PSTAT7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_IST_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_IST_RESERVED_Msk = 0xffffff00
)

// Bitfields for GPIO_GROUP_INT0: GPIO group interrupt
const (
	// CTRL: GPIO grouped interrupt control register
	// Position of INT field.
	GPIO_GROUP_INT0_CTRL_INT_Pos = 0x0
	// Bit mask of INT field.
	GPIO_GROUP_INT0_CTRL_INT_Msk = 0x1
	// Bit INT.
	GPIO_GROUP_INT0_CTRL_INT = 0x1
	// No interrupt request is pending.
	GPIO_GROUP_INT0_CTRL_INT_NO_INTERRUPT_REQUEST = 0x0
	// Interrupt request is active.
	GPIO_GROUP_INT0_CTRL_INT_INTERRUPT_REQUEST_IS = 0x1
	// Position of COMB field.
	GPIO_GROUP_INT0_CTRL_COMB_Pos = 0x1
	// Bit mask of COMB field.
	GPIO_GROUP_INT0_CTRL_COMB_Msk = 0x2
	// Bit COMB.
	GPIO_GROUP_INT0_CTRL_COMB = 0x2
	// OR functionality: A grouped interrupt is generated when any one of the enabled inputs is active (based on its programmed polarity).
	GPIO_GROUP_INT0_CTRL_COMB_OR_FUNCTIONALITY_A_ = 0x0
	// AND functionality: An interrupt is generated when all enabled bits are active (based on their programmed polarity).
	GPIO_GROUP_INT0_CTRL_COMB_AND_FUNCTIONALITY_A = 0x1
	// Position of TRIG field.
	GPIO_GROUP_INT0_CTRL_TRIG_Pos = 0x2
	// Bit mask of TRIG field.
	GPIO_GROUP_INT0_CTRL_TRIG_Msk = 0x4
	// Bit TRIG.
	GPIO_GROUP_INT0_CTRL_TRIG = 0x4
	// Edge-triggered
	GPIO_GROUP_INT0_CTRL_TRIG_EDGE_TRIGGERED = 0x0
	// Level-triggered
	GPIO_GROUP_INT0_CTRL_TRIG_LEVEL_TRIGGERED = 0x1
	// Position of RESERVED field.
	GPIO_GROUP_INT0_CTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	GPIO_GROUP_INT0_CTRL_RESERVED_Msk = 0xfffffff8

	// PORT_POL0: GPIO grouped interrupt port 0 polarity register
	// Position of POL_0 field.
	GPIO_GROUP_INT0_PORT_POL_POL_0_Pos = 0x0
	// Bit mask of POL_0 field.
	GPIO_GROUP_INT0_PORT_POL_POL_0_Msk = 0x1
	// Bit POL_0.
	GPIO_GROUP_INT0_PORT_POL_POL_0 = 0x1
	// Position of POL_1 field.
	GPIO_GROUP_INT0_PORT_POL_POL_1_Pos = 0x1
	// Bit mask of POL_1 field.
	GPIO_GROUP_INT0_PORT_POL_POL_1_Msk = 0x2
	// Bit POL_1.
	GPIO_GROUP_INT0_PORT_POL_POL_1 = 0x2
	// Position of POL_2 field.
	GPIO_GROUP_INT0_PORT_POL_POL_2_Pos = 0x2
	// Bit mask of POL_2 field.
	GPIO_GROUP_INT0_PORT_POL_POL_2_Msk = 0x4
	// Bit POL_2.
	GPIO_GROUP_INT0_PORT_POL_POL_2 = 0x4
	// Position of POL_3 field.
	GPIO_GROUP_INT0_PORT_POL_POL_3_Pos = 0x3
	// Bit mask of POL_3 field.
	GPIO_GROUP_INT0_PORT_POL_POL_3_Msk = 0x8
	// Bit POL_3.
	GPIO_GROUP_INT0_PORT_POL_POL_3 = 0x8
	// Position of POL_4 field.
	GPIO_GROUP_INT0_PORT_POL_POL_4_Pos = 0x4
	// Bit mask of POL_4 field.
	GPIO_GROUP_INT0_PORT_POL_POL_4_Msk = 0x10
	// Bit POL_4.
	GPIO_GROUP_INT0_PORT_POL_POL_4 = 0x10
	// Position of POL_5 field.
	GPIO_GROUP_INT0_PORT_POL_POL_5_Pos = 0x5
	// Bit mask of POL_5 field.
	GPIO_GROUP_INT0_PORT_POL_POL_5_Msk = 0x20
	// Bit POL_5.
	GPIO_GROUP_INT0_PORT_POL_POL_5 = 0x20
	// Position of POL_6 field.
	GPIO_GROUP_INT0_PORT_POL_POL_6_Pos = 0x6
	// Bit mask of POL_6 field.
	GPIO_GROUP_INT0_PORT_POL_POL_6_Msk = 0x40
	// Bit POL_6.
	GPIO_GROUP_INT0_PORT_POL_POL_6 = 0x40
	// Position of POL_7 field.
	GPIO_GROUP_INT0_PORT_POL_POL_7_Pos = 0x7
	// Bit mask of POL_7 field.
	GPIO_GROUP_INT0_PORT_POL_POL_7_Msk = 0x80
	// Bit POL_7.
	GPIO_GROUP_INT0_PORT_POL_POL_7 = 0x80
	// Position of POL_8 field.
	GPIO_GROUP_INT0_PORT_POL_POL_8_Pos = 0x8
	// Bit mask of POL_8 field.
	GPIO_GROUP_INT0_PORT_POL_POL_8_Msk = 0x100
	// Bit POL_8.
	GPIO_GROUP_INT0_PORT_POL_POL_8 = 0x100
	// Position of POL_9 field.
	GPIO_GROUP_INT0_PORT_POL_POL_9_Pos = 0x9
	// Bit mask of POL_9 field.
	GPIO_GROUP_INT0_PORT_POL_POL_9_Msk = 0x200
	// Bit POL_9.
	GPIO_GROUP_INT0_PORT_POL_POL_9 = 0x200
	// Position of POL_10 field.
	GPIO_GROUP_INT0_PORT_POL_POL_10_Pos = 0xa
	// Bit mask of POL_10 field.
	GPIO_GROUP_INT0_PORT_POL_POL_10_Msk = 0x400
	// Bit POL_10.
	GPIO_GROUP_INT0_PORT_POL_POL_10 = 0x400
	// Position of POL_11 field.
	GPIO_GROUP_INT0_PORT_POL_POL_11_Pos = 0xb
	// Bit mask of POL_11 field.
	GPIO_GROUP_INT0_PORT_POL_POL_11_Msk = 0x800
	// Bit POL_11.
	GPIO_GROUP_INT0_PORT_POL_POL_11 = 0x800
	// Position of POL_12 field.
	GPIO_GROUP_INT0_PORT_POL_POL_12_Pos = 0xc
	// Bit mask of POL_12 field.
	GPIO_GROUP_INT0_PORT_POL_POL_12_Msk = 0x1000
	// Bit POL_12.
	GPIO_GROUP_INT0_PORT_POL_POL_12 = 0x1000
	// Position of POL_13 field.
	GPIO_GROUP_INT0_PORT_POL_POL_13_Pos = 0xd
	// Bit mask of POL_13 field.
	GPIO_GROUP_INT0_PORT_POL_POL_13_Msk = 0x2000
	// Bit POL_13.
	GPIO_GROUP_INT0_PORT_POL_POL_13 = 0x2000
	// Position of POL_14 field.
	GPIO_GROUP_INT0_PORT_POL_POL_14_Pos = 0xe
	// Bit mask of POL_14 field.
	GPIO_GROUP_INT0_PORT_POL_POL_14_Msk = 0x4000
	// Bit POL_14.
	GPIO_GROUP_INT0_PORT_POL_POL_14 = 0x4000
	// Position of POL_15 field.
	GPIO_GROUP_INT0_PORT_POL_POL_15_Pos = 0xf
	// Bit mask of POL_15 field.
	GPIO_GROUP_INT0_PORT_POL_POL_15_Msk = 0x8000
	// Bit POL_15.
	GPIO_GROUP_INT0_PORT_POL_POL_15 = 0x8000
	// Position of POL_16 field.
	GPIO_GROUP_INT0_PORT_POL_POL_16_Pos = 0x10
	// Bit mask of POL_16 field.
	GPIO_GROUP_INT0_PORT_POL_POL_16_Msk = 0x10000
	// Bit POL_16.
	GPIO_GROUP_INT0_PORT_POL_POL_16 = 0x10000
	// Position of POL_17 field.
	GPIO_GROUP_INT0_PORT_POL_POL_17_Pos = 0x11
	// Bit mask of POL_17 field.
	GPIO_GROUP_INT0_PORT_POL_POL_17_Msk = 0x20000
	// Bit POL_17.
	GPIO_GROUP_INT0_PORT_POL_POL_17 = 0x20000
	// Position of POL_18 field.
	GPIO_GROUP_INT0_PORT_POL_POL_18_Pos = 0x12
	// Bit mask of POL_18 field.
	GPIO_GROUP_INT0_PORT_POL_POL_18_Msk = 0x40000
	// Bit POL_18.
	GPIO_GROUP_INT0_PORT_POL_POL_18 = 0x40000
	// Position of POL_19 field.
	GPIO_GROUP_INT0_PORT_POL_POL_19_Pos = 0x13
	// Bit mask of POL_19 field.
	GPIO_GROUP_INT0_PORT_POL_POL_19_Msk = 0x80000
	// Bit POL_19.
	GPIO_GROUP_INT0_PORT_POL_POL_19 = 0x80000
	// Position of POL_20 field.
	GPIO_GROUP_INT0_PORT_POL_POL_20_Pos = 0x14
	// Bit mask of POL_20 field.
	GPIO_GROUP_INT0_PORT_POL_POL_20_Msk = 0x100000
	// Bit POL_20.
	GPIO_GROUP_INT0_PORT_POL_POL_20 = 0x100000
	// Position of POL_21 field.
	GPIO_GROUP_INT0_PORT_POL_POL_21_Pos = 0x15
	// Bit mask of POL_21 field.
	GPIO_GROUP_INT0_PORT_POL_POL_21_Msk = 0x200000
	// Bit POL_21.
	GPIO_GROUP_INT0_PORT_POL_POL_21 = 0x200000
	// Position of POL_22 field.
	GPIO_GROUP_INT0_PORT_POL_POL_22_Pos = 0x16
	// Bit mask of POL_22 field.
	GPIO_GROUP_INT0_PORT_POL_POL_22_Msk = 0x400000
	// Bit POL_22.
	GPIO_GROUP_INT0_PORT_POL_POL_22 = 0x400000
	// Position of POL_23 field.
	GPIO_GROUP_INT0_PORT_POL_POL_23_Pos = 0x17
	// Bit mask of POL_23 field.
	GPIO_GROUP_INT0_PORT_POL_POL_23_Msk = 0x800000
	// Bit POL_23.
	GPIO_GROUP_INT0_PORT_POL_POL_23 = 0x800000
	// Position of POL_24 field.
	GPIO_GROUP_INT0_PORT_POL_POL_24_Pos = 0x18
	// Bit mask of POL_24 field.
	GPIO_GROUP_INT0_PORT_POL_POL_24_Msk = 0x1000000
	// Bit POL_24.
	GPIO_GROUP_INT0_PORT_POL_POL_24 = 0x1000000
	// Position of POL_25 field.
	GPIO_GROUP_INT0_PORT_POL_POL_25_Pos = 0x19
	// Bit mask of POL_25 field.
	GPIO_GROUP_INT0_PORT_POL_POL_25_Msk = 0x2000000
	// Bit POL_25.
	GPIO_GROUP_INT0_PORT_POL_POL_25 = 0x2000000
	// Position of POL_26 field.
	GPIO_GROUP_INT0_PORT_POL_POL_26_Pos = 0x1a
	// Bit mask of POL_26 field.
	GPIO_GROUP_INT0_PORT_POL_POL_26_Msk = 0x4000000
	// Bit POL_26.
	GPIO_GROUP_INT0_PORT_POL_POL_26 = 0x4000000
	// Position of POL_27 field.
	GPIO_GROUP_INT0_PORT_POL_POL_27_Pos = 0x1b
	// Bit mask of POL_27 field.
	GPIO_GROUP_INT0_PORT_POL_POL_27_Msk = 0x8000000
	// Bit POL_27.
	GPIO_GROUP_INT0_PORT_POL_POL_27 = 0x8000000
	// Position of POL_28 field.
	GPIO_GROUP_INT0_PORT_POL_POL_28_Pos = 0x1c
	// Bit mask of POL_28 field.
	GPIO_GROUP_INT0_PORT_POL_POL_28_Msk = 0x10000000
	// Bit POL_28.
	GPIO_GROUP_INT0_PORT_POL_POL_28 = 0x10000000
	// Position of POL_29 field.
	GPIO_GROUP_INT0_PORT_POL_POL_29_Pos = 0x1d
	// Bit mask of POL_29 field.
	GPIO_GROUP_INT0_PORT_POL_POL_29_Msk = 0x20000000
	// Bit POL_29.
	GPIO_GROUP_INT0_PORT_POL_POL_29 = 0x20000000
	// Position of POL_30 field.
	GPIO_GROUP_INT0_PORT_POL_POL_30_Pos = 0x1e
	// Bit mask of POL_30 field.
	GPIO_GROUP_INT0_PORT_POL_POL_30_Msk = 0x40000000
	// Bit POL_30.
	GPIO_GROUP_INT0_PORT_POL_POL_30 = 0x40000000
	// Position of POL_31 field.
	GPIO_GROUP_INT0_PORT_POL_POL_31_Pos = 0x1f
	// Bit mask of POL_31 field.
	GPIO_GROUP_INT0_PORT_POL_POL_31_Msk = 0x80000000
	// Bit POL_31.
	GPIO_GROUP_INT0_PORT_POL_POL_31 = 0x80000000

	// PORT_ENA0: GPIO grouped interrupt port 0/1 enable register
	// Position of ENA_0 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_0_Pos = 0x0
	// Bit mask of ENA_0 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_0_Msk = 0x1
	// Bit ENA_0.
	GPIO_GROUP_INT0_PORT_ENA_ENA_0 = 0x1
	// Position of ENA_1 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_1_Pos = 0x1
	// Bit mask of ENA_1 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_1_Msk = 0x2
	// Bit ENA_1.
	GPIO_GROUP_INT0_PORT_ENA_ENA_1 = 0x2
	// Position of ENA_2 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_2_Pos = 0x2
	// Bit mask of ENA_2 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_2_Msk = 0x4
	// Bit ENA_2.
	GPIO_GROUP_INT0_PORT_ENA_ENA_2 = 0x4
	// Position of ENA_3 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_3_Pos = 0x3
	// Bit mask of ENA_3 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_3_Msk = 0x8
	// Bit ENA_3.
	GPIO_GROUP_INT0_PORT_ENA_ENA_3 = 0x8
	// Position of ENA_4 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_4_Pos = 0x4
	// Bit mask of ENA_4 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_4_Msk = 0x10
	// Bit ENA_4.
	GPIO_GROUP_INT0_PORT_ENA_ENA_4 = 0x10
	// Position of ENA_5 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_5_Pos = 0x5
	// Bit mask of ENA_5 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_5_Msk = 0x20
	// Bit ENA_5.
	GPIO_GROUP_INT0_PORT_ENA_ENA_5 = 0x20
	// Position of ENA_6 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_6_Pos = 0x6
	// Bit mask of ENA_6 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_6_Msk = 0x40
	// Bit ENA_6.
	GPIO_GROUP_INT0_PORT_ENA_ENA_6 = 0x40
	// Position of ENA_7 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_7_Pos = 0x7
	// Bit mask of ENA_7 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_7_Msk = 0x80
	// Bit ENA_7.
	GPIO_GROUP_INT0_PORT_ENA_ENA_7 = 0x80
	// Position of ENA_8 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_8_Pos = 0x8
	// Bit mask of ENA_8 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_8_Msk = 0x100
	// Bit ENA_8.
	GPIO_GROUP_INT0_PORT_ENA_ENA_8 = 0x100
	// Position of ENA_9 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_9_Pos = 0x9
	// Bit mask of ENA_9 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_9_Msk = 0x200
	// Bit ENA_9.
	GPIO_GROUP_INT0_PORT_ENA_ENA_9 = 0x200
	// Position of ENA_10 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_10_Pos = 0xa
	// Bit mask of ENA_10 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_10_Msk = 0x400
	// Bit ENA_10.
	GPIO_GROUP_INT0_PORT_ENA_ENA_10 = 0x400
	// Position of ENA_11 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_11_Pos = 0xb
	// Bit mask of ENA_11 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_11_Msk = 0x800
	// Bit ENA_11.
	GPIO_GROUP_INT0_PORT_ENA_ENA_11 = 0x800
	// Position of ENA_12 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_12_Pos = 0xc
	// Bit mask of ENA_12 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_12_Msk = 0x1000
	// Bit ENA_12.
	GPIO_GROUP_INT0_PORT_ENA_ENA_12 = 0x1000
	// Position of ENA_13 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_13_Pos = 0xd
	// Bit mask of ENA_13 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_13_Msk = 0x2000
	// Bit ENA_13.
	GPIO_GROUP_INT0_PORT_ENA_ENA_13 = 0x2000
	// Position of ENA_14 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_14_Pos = 0xe
	// Bit mask of ENA_14 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_14_Msk = 0x4000
	// Bit ENA_14.
	GPIO_GROUP_INT0_PORT_ENA_ENA_14 = 0x4000
	// Position of ENA_15 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_15_Pos = 0xf
	// Bit mask of ENA_15 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_15_Msk = 0x8000
	// Bit ENA_15.
	GPIO_GROUP_INT0_PORT_ENA_ENA_15 = 0x8000
	// Position of ENA_16 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_16_Pos = 0x10
	// Bit mask of ENA_16 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_16_Msk = 0x10000
	// Bit ENA_16.
	GPIO_GROUP_INT0_PORT_ENA_ENA_16 = 0x10000
	// Position of ENA_17 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_17_Pos = 0x11
	// Bit mask of ENA_17 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_17_Msk = 0x20000
	// Bit ENA_17.
	GPIO_GROUP_INT0_PORT_ENA_ENA_17 = 0x20000
	// Position of ENA_18 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_18_Pos = 0x12
	// Bit mask of ENA_18 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_18_Msk = 0x40000
	// Bit ENA_18.
	GPIO_GROUP_INT0_PORT_ENA_ENA_18 = 0x40000
	// Position of ENA_19 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_19_Pos = 0x13
	// Bit mask of ENA_19 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_19_Msk = 0x80000
	// Bit ENA_19.
	GPIO_GROUP_INT0_PORT_ENA_ENA_19 = 0x80000
	// Position of ENA_20 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_20_Pos = 0x14
	// Bit mask of ENA_20 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_20_Msk = 0x100000
	// Bit ENA_20.
	GPIO_GROUP_INT0_PORT_ENA_ENA_20 = 0x100000
	// Position of ENA_21 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_21_Pos = 0x15
	// Bit mask of ENA_21 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_21_Msk = 0x200000
	// Bit ENA_21.
	GPIO_GROUP_INT0_PORT_ENA_ENA_21 = 0x200000
	// Position of ENA_22 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_22_Pos = 0x16
	// Bit mask of ENA_22 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_22_Msk = 0x400000
	// Bit ENA_22.
	GPIO_GROUP_INT0_PORT_ENA_ENA_22 = 0x400000
	// Position of ENA_23 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_23_Pos = 0x17
	// Bit mask of ENA_23 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_23_Msk = 0x800000
	// Bit ENA_23.
	GPIO_GROUP_INT0_PORT_ENA_ENA_23 = 0x800000
	// Position of ENA_24 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_24_Pos = 0x18
	// Bit mask of ENA_24 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_24_Msk = 0x1000000
	// Bit ENA_24.
	GPIO_GROUP_INT0_PORT_ENA_ENA_24 = 0x1000000
	// Position of ENA_25 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_25_Pos = 0x19
	// Bit mask of ENA_25 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_25_Msk = 0x2000000
	// Bit ENA_25.
	GPIO_GROUP_INT0_PORT_ENA_ENA_25 = 0x2000000
	// Position of ENA_26 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_26_Pos = 0x1a
	// Bit mask of ENA_26 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_26_Msk = 0x4000000
	// Bit ENA_26.
	GPIO_GROUP_INT0_PORT_ENA_ENA_26 = 0x4000000
	// Position of ENA_27 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_27_Pos = 0x1b
	// Bit mask of ENA_27 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_27_Msk = 0x8000000
	// Bit ENA_27.
	GPIO_GROUP_INT0_PORT_ENA_ENA_27 = 0x8000000
	// Position of ENA_28 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_28_Pos = 0x1c
	// Bit mask of ENA_28 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_28_Msk = 0x10000000
	// Bit ENA_28.
	GPIO_GROUP_INT0_PORT_ENA_ENA_28 = 0x10000000
	// Position of ENA_29 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_29_Pos = 0x1d
	// Bit mask of ENA_29 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_29_Msk = 0x20000000
	// Bit ENA_29.
	GPIO_GROUP_INT0_PORT_ENA_ENA_29 = 0x20000000
	// Position of ENA_30 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_30_Pos = 0x1e
	// Bit mask of ENA_30 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_30_Msk = 0x40000000
	// Bit ENA_30.
	GPIO_GROUP_INT0_PORT_ENA_ENA_30 = 0x40000000
	// Position of ENA_31 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_31_Pos = 0x1f
	// Bit mask of ENA_31 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_31_Msk = 0x80000000
	// Bit ENA_31.
	GPIO_GROUP_INT0_PORT_ENA_ENA_31 = 0x80000000
)

// Bitfields for USB: USB2.0 device controller
const (
	// DEVCMDSTAT: USB Device Command/Status register
	// Position of DEV_ADDR field.
	USB_DEVCMDSTAT_DEV_ADDR_Pos = 0x0
	// Bit mask of DEV_ADDR field.
	USB_DEVCMDSTAT_DEV_ADDR_Msk = 0x7f
	// Position of DEV_EN field.
	USB_DEVCMDSTAT_DEV_EN_Pos = 0x7
	// Bit mask of DEV_EN field.
	USB_DEVCMDSTAT_DEV_EN_Msk = 0x80
	// Bit DEV_EN.
	USB_DEVCMDSTAT_DEV_EN = 0x80
	// Position of SETUP field.
	USB_DEVCMDSTAT_SETUP_Pos = 0x8
	// Bit mask of SETUP field.
	USB_DEVCMDSTAT_SETUP_Msk = 0x100
	// Bit SETUP.
	USB_DEVCMDSTAT_SETUP = 0x100
	// Position of PLL_ON field.
	USB_DEVCMDSTAT_PLL_ON_Pos = 0x9
	// Bit mask of PLL_ON field.
	USB_DEVCMDSTAT_PLL_ON_Msk = 0x200
	// Bit PLL_ON.
	USB_DEVCMDSTAT_PLL_ON = 0x200
	// USB_NeedClk functional
	USB_DEVCMDSTAT_PLL_ON_USB_NEEDCLK_FUNCTION = 0x0
	// USB_NeedClk always 1. Clock will not be stopped in case of suspend.
	USB_DEVCMDSTAT_PLL_ON_USB_NEEDCLK_ALWAYS_1 = 0x1
	// Position of RESERVED field.
	USB_DEVCMDSTAT_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_DEVCMDSTAT_RESERVED_Msk = 0x400
	// Bit RESERVED.
	USB_DEVCMDSTAT_RESERVED = 0x400
	// Position of LPM_SUP field.
	USB_DEVCMDSTAT_LPM_SUP_Pos = 0xb
	// Bit mask of LPM_SUP field.
	USB_DEVCMDSTAT_LPM_SUP_Msk = 0x800
	// Bit LPM_SUP.
	USB_DEVCMDSTAT_LPM_SUP = 0x800
	// LPM not supported.
	USB_DEVCMDSTAT_LPM_SUP_LPM_NOT_SUPPORTED_ = 0x0
	// LPM supported.
	USB_DEVCMDSTAT_LPM_SUP_LPM_SUPPORTED_ = 0x1
	// Position of INTONNAK_AO field.
	USB_DEVCMDSTAT_INTONNAK_AO_Pos = 0xc
	// Bit mask of INTONNAK_AO field.
	USB_DEVCMDSTAT_INTONNAK_AO_Msk = 0x1000
	// Bit INTONNAK_AO.
	USB_DEVCMDSTAT_INTONNAK_AO = 0x1000
	// Only acknowledged packets generate an interrupt
	USB_DEVCMDSTAT_INTONNAK_AO_ACKNOW = 0x0
	// Both acknowledged and NAKed packets generate interrupts.
	USB_DEVCMDSTAT_INTONNAK_AO_ACKNOW_NAK = 0x1
	// Position of INTONNAK_AI field.
	USB_DEVCMDSTAT_INTONNAK_AI_Pos = 0xd
	// Bit mask of INTONNAK_AI field.
	USB_DEVCMDSTAT_INTONNAK_AI_Msk = 0x2000
	// Bit INTONNAK_AI.
	USB_DEVCMDSTAT_INTONNAK_AI = 0x2000
	// Only acknowledged packets generate an interrupt
	USB_DEVCMDSTAT_INTONNAK_AI_ACKNOW = 0x0
	// Both acknowledged and NAKed packets generate interrupts.
	USB_DEVCMDSTAT_INTONNAK_AI_ACKNOW_NAK = 0x1
	// Position of INTONNAK_CO field.
	USB_DEVCMDSTAT_INTONNAK_CO_Pos = 0xe
	// Bit mask of INTONNAK_CO field.
	USB_DEVCMDSTAT_INTONNAK_CO_Msk = 0x4000
	// Bit INTONNAK_CO.
	USB_DEVCMDSTAT_INTONNAK_CO = 0x4000
	// Only acknowledged packets generate an interrupt
	USB_DEVCMDSTAT_INTONNAK_CO_ACKNOW = 0x0
	// Both acknowledged and NAKed packets generate interrupts.
	USB_DEVCMDSTAT_INTONNAK_CO_ACKNOW_NAK = 0x1
	// Position of INTONNAK_CI field.
	USB_DEVCMDSTAT_INTONNAK_CI_Pos = 0xf
	// Bit mask of INTONNAK_CI field.
	USB_DEVCMDSTAT_INTONNAK_CI_Msk = 0x8000
	// Bit INTONNAK_CI.
	USB_DEVCMDSTAT_INTONNAK_CI = 0x8000
	// Only acknowledged packets generate an interrupt
	USB_DEVCMDSTAT_INTONNAK_CI_ACKNOW = 0x0
	// Both acknowledged and NAKed packets generate interrupts.
	USB_DEVCMDSTAT_INTONNAK_CI_ACKNOW_NAK = 0x1
	// Position of DCON field.
	USB_DEVCMDSTAT_DCON_Pos = 0x10
	// Bit mask of DCON field.
	USB_DEVCMDSTAT_DCON_Msk = 0x10000
	// Bit DCON.
	USB_DEVCMDSTAT_DCON = 0x10000
	// Position of DSUS field.
	USB_DEVCMDSTAT_DSUS_Pos = 0x11
	// Bit mask of DSUS field.
	USB_DEVCMDSTAT_DSUS_Msk = 0x20000
	// Bit DSUS.
	USB_DEVCMDSTAT_DSUS = 0x20000
	// Position of RESERVED field.
	USB_DEVCMDSTAT_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	USB_DEVCMDSTAT_RESERVED_Msk = 0x40000
	// Bit RESERVED.
	USB_DEVCMDSTAT_RESERVED = 0x40000
	// Position of LPM_SUS field.
	USB_DEVCMDSTAT_LPM_SUS_Pos = 0x13
	// Bit mask of LPM_SUS field.
	USB_DEVCMDSTAT_LPM_SUS_Msk = 0x80000
	// Bit LPM_SUS.
	USB_DEVCMDSTAT_LPM_SUS = 0x80000
	// Position of LPM_REWP field.
	USB_DEVCMDSTAT_LPM_REWP_Pos = 0x14
	// Bit mask of LPM_REWP field.
	USB_DEVCMDSTAT_LPM_REWP_Msk = 0x100000
	// Bit LPM_REWP.
	USB_DEVCMDSTAT_LPM_REWP = 0x100000
	// Position of RESERVED field.
	USB_DEVCMDSTAT_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	USB_DEVCMDSTAT_RESERVED_Msk = 0xe00000
	// Position of DCON_C field.
	USB_DEVCMDSTAT_DCON_C_Pos = 0x18
	// Bit mask of DCON_C field.
	USB_DEVCMDSTAT_DCON_C_Msk = 0x1000000
	// Bit DCON_C.
	USB_DEVCMDSTAT_DCON_C = 0x1000000
	// Position of DSUS_C field.
	USB_DEVCMDSTAT_DSUS_C_Pos = 0x19
	// Bit mask of DSUS_C field.
	USB_DEVCMDSTAT_DSUS_C_Msk = 0x2000000
	// Bit DSUS_C.
	USB_DEVCMDSTAT_DSUS_C = 0x2000000
	// Position of DRES_C field.
	USB_DEVCMDSTAT_DRES_C_Pos = 0x1a
	// Bit mask of DRES_C field.
	USB_DEVCMDSTAT_DRES_C_Msk = 0x4000000
	// Bit DRES_C.
	USB_DEVCMDSTAT_DRES_C = 0x4000000
	// Position of RESERVED field.
	USB_DEVCMDSTAT_RESERVED_Pos = 0x1b
	// Bit mask of RESERVED field.
	USB_DEVCMDSTAT_RESERVED_Msk = 0x8000000
	// Bit RESERVED.
	USB_DEVCMDSTAT_RESERVED = 0x8000000
	// Position of VBUSDEBOUNCED field.
	USB_DEVCMDSTAT_VBUSDEBOUNCED_Pos = 0x1c
	// Bit mask of VBUSDEBOUNCED field.
	USB_DEVCMDSTAT_VBUSDEBOUNCED_Msk = 0x10000000
	// Bit VBUSDEBOUNCED.
	USB_DEVCMDSTAT_VBUSDEBOUNCED = 0x10000000
	// Position of RESERVED field.
	USB_DEVCMDSTAT_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	USB_DEVCMDSTAT_RESERVED_Msk = 0xe0000000

	// INFO: USB Info register
	// Position of FRAME_NR field.
	USB_INFO_FRAME_NR_Pos = 0x0
	// Bit mask of FRAME_NR field.
	USB_INFO_FRAME_NR_Msk = 0x7ff
	// Position of ERR_CODE field.
	USB_INFO_ERR_CODE_Pos = 0xb
	// Bit mask of ERR_CODE field.
	USB_INFO_ERR_CODE_Msk = 0x7800
	// No error
	USB_INFO_ERR_CODE_NO_ERROR = 0x0
	// PID encoding error
	USB_INFO_ERR_CODE_PID_ENCODING_ERROR = 0x1
	// PID unknown
	USB_INFO_ERR_CODE_PID_UNKNOWN = 0x2
	// Packet unexpected
	USB_INFO_ERR_CODE_PACKET_UNEXPECTED = 0x3
	// Token CRC error
	USB_INFO_ERR_CODE_TOKEN_CRC_ERROR = 0x4
	// Data CRC error
	USB_INFO_ERR_CODE_DATA_CRC_ERROR = 0x5
	// Time out
	USB_INFO_ERR_CODE_TIME_OUT = 0x6
	// Babble
	USB_INFO_ERR_CODE_BABBLE = 0x7
	// Truncated EOP
	USB_INFO_ERR_CODE_TRUNCATED_EOP = 0x8
	// Sent/Received NAK
	USB_INFO_ERR_CODE_SENTRECEIVED_NAK = 0x9
	// Sent Stall
	USB_INFO_ERR_CODE_SENT_STALL = 0xa
	// Overrun
	USB_INFO_ERR_CODE_OVERRUN = 0xb
	// Sent empty packet
	USB_INFO_ERR_CODE_SENT_EMPTY_PACKET = 0xc
	// Bitstuff error
	USB_INFO_ERR_CODE_BITSTUFF_ERROR = 0xd
	// Sync error
	USB_INFO_ERR_CODE_SYNC_ERROR = 0xe
	// Wrong data toggle
	USB_INFO_ERR_CODE_WRONG_DATA_TOGGLE = 0xf
	// Position of RESERVED field.
	USB_INFO_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	USB_INFO_RESERVED_Msk = 0x8000
	// Bit RESERVED.
	USB_INFO_RESERVED = 0x8000
	// Position of RESERVED field.
	USB_INFO_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USB_INFO_RESERVED_Msk = 0xffff0000

	// EPLISTSTART: USB EP Command/Status List start address
	// Position of RESERVED field.
	USB_EPLISTSTART_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USB_EPLISTSTART_RESERVED_Msk = 0xff
	// Position of EP_LIST field.
	USB_EPLISTSTART_EP_LIST_Pos = 0x8
	// Bit mask of EP_LIST field.
	USB_EPLISTSTART_EP_LIST_Msk = 0xffffff00

	// DATABUFSTART: USB Data buffer start address
	// Position of RESERVED field.
	USB_DATABUFSTART_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USB_DATABUFSTART_RESERVED_Msk = 0x3fffff
	// Position of DA_BUF field.
	USB_DATABUFSTART_DA_BUF_Pos = 0x16
	// Bit mask of DA_BUF field.
	USB_DATABUFSTART_DA_BUF_Msk = 0xffc00000

	// LPM: Link Power Management register
	// Position of HIRD_HW field.
	USB_LPM_HIRD_HW_Pos = 0x0
	// Bit mask of HIRD_HW field.
	USB_LPM_HIRD_HW_Msk = 0xf
	// Position of HIRD_SW field.
	USB_LPM_HIRD_SW_Pos = 0x4
	// Bit mask of HIRD_SW field.
	USB_LPM_HIRD_SW_Msk = 0xf0
	// Position of DATA_PENDING field.
	USB_LPM_DATA_PENDING_Pos = 0x8
	// Bit mask of DATA_PENDING field.
	USB_LPM_DATA_PENDING_Msk = 0x100
	// Bit DATA_PENDING.
	USB_LPM_DATA_PENDING = 0x100
	// Position of RESERVED field.
	USB_LPM_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USB_LPM_RESERVED_Msk = 0xfffffe00

	// EPSKIP: USB Endpoint skip
	// Position of SKIP field.
	USB_EPSKIP_SKIP_Pos = 0x0
	// Bit mask of SKIP field.
	USB_EPSKIP_SKIP_Msk = 0x3fffffff
	// Position of RESERVED field.
	USB_EPSKIP_RESERVED_Pos = 0x1e
	// Bit mask of RESERVED field.
	USB_EPSKIP_RESERVED_Msk = 0xc0000000

	// EPINUSE: USB Endpoint Buffer in use
	// Position of RESERVED field.
	USB_EPINUSE_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USB_EPINUSE_RESERVED_Msk = 0x3
	// Position of BUF field.
	USB_EPINUSE_BUF_Pos = 0x2
	// Bit mask of BUF field.
	USB_EPINUSE_BUF_Msk = 0x3fc
	// Position of RESERVED field.
	USB_EPINUSE_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_EPINUSE_RESERVED_Msk = 0xfffffc00

	// EPBUFCFG: USB Endpoint Buffer Configuration register
	// Position of RESERVED field.
	USB_EPBUFCFG_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USB_EPBUFCFG_RESERVED_Msk = 0x3
	// Position of BUF_SB field.
	USB_EPBUFCFG_BUF_SB_Pos = 0x2
	// Bit mask of BUF_SB field.
	USB_EPBUFCFG_BUF_SB_Msk = 0x3fc
	// Position of RESERVED field.
	USB_EPBUFCFG_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_EPBUFCFG_RESERVED_Msk = 0xfffffc00

	// INTSTAT: USB interrupt status register
	// Position of EP0OUT field.
	USB_INTSTAT_EP0OUT_Pos = 0x0
	// Bit mask of EP0OUT field.
	USB_INTSTAT_EP0OUT_Msk = 0x1
	// Bit EP0OUT.
	USB_INTSTAT_EP0OUT = 0x1
	// Position of EP0IN field.
	USB_INTSTAT_EP0IN_Pos = 0x1
	// Bit mask of EP0IN field.
	USB_INTSTAT_EP0IN_Msk = 0x2
	// Bit EP0IN.
	USB_INTSTAT_EP0IN = 0x2
	// Position of EP1OUT field.
	USB_INTSTAT_EP1OUT_Pos = 0x2
	// Bit mask of EP1OUT field.
	USB_INTSTAT_EP1OUT_Msk = 0x4
	// Bit EP1OUT.
	USB_INTSTAT_EP1OUT = 0x4
	// Position of EP1IN field.
	USB_INTSTAT_EP1IN_Pos = 0x3
	// Bit mask of EP1IN field.
	USB_INTSTAT_EP1IN_Msk = 0x8
	// Bit EP1IN.
	USB_INTSTAT_EP1IN = 0x8
	// Position of EP2OUT field.
	USB_INTSTAT_EP2OUT_Pos = 0x4
	// Bit mask of EP2OUT field.
	USB_INTSTAT_EP2OUT_Msk = 0x10
	// Bit EP2OUT.
	USB_INTSTAT_EP2OUT = 0x10
	// Position of EP2IN field.
	USB_INTSTAT_EP2IN_Pos = 0x5
	// Bit mask of EP2IN field.
	USB_INTSTAT_EP2IN_Msk = 0x20
	// Bit EP2IN.
	USB_INTSTAT_EP2IN = 0x20
	// Position of EP3OUT field.
	USB_INTSTAT_EP3OUT_Pos = 0x6
	// Bit mask of EP3OUT field.
	USB_INTSTAT_EP3OUT_Msk = 0x40
	// Bit EP3OUT.
	USB_INTSTAT_EP3OUT = 0x40
	// Position of EP3IN field.
	USB_INTSTAT_EP3IN_Pos = 0x7
	// Bit mask of EP3IN field.
	USB_INTSTAT_EP3IN_Msk = 0x80
	// Bit EP3IN.
	USB_INTSTAT_EP3IN = 0x80
	// Position of EP4OUT field.
	USB_INTSTAT_EP4OUT_Pos = 0x8
	// Bit mask of EP4OUT field.
	USB_INTSTAT_EP4OUT_Msk = 0x100
	// Bit EP4OUT.
	USB_INTSTAT_EP4OUT = 0x100
	// Position of EP4IN field.
	USB_INTSTAT_EP4IN_Pos = 0x9
	// Bit mask of EP4IN field.
	USB_INTSTAT_EP4IN_Msk = 0x200
	// Bit EP4IN.
	USB_INTSTAT_EP4IN = 0x200
	// Position of RESERVED field.
	USB_INTSTAT_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_INTSTAT_RESERVED_Msk = 0x3ffffc00
	// Position of FRAME_INT field.
	USB_INTSTAT_FRAME_INT_Pos = 0x1e
	// Bit mask of FRAME_INT field.
	USB_INTSTAT_FRAME_INT_Msk = 0x40000000
	// Bit FRAME_INT.
	USB_INTSTAT_FRAME_INT = 0x40000000
	// Position of DEV_INT field.
	USB_INTSTAT_DEV_INT_Pos = 0x1f
	// Bit mask of DEV_INT field.
	USB_INTSTAT_DEV_INT_Msk = 0x80000000
	// Bit DEV_INT.
	USB_INTSTAT_DEV_INT = 0x80000000

	// INTEN: USB interrupt enable register
	// Position of EP_INT_EN field.
	USB_INTEN_EP_INT_EN_Pos = 0x0
	// Bit mask of EP_INT_EN field.
	USB_INTEN_EP_INT_EN_Msk = 0x3ff
	// Position of RESERVED field.
	USB_INTEN_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_INTEN_RESERVED_Msk = 0x3ffffc00
	// Position of FRAME_INT_EN field.
	USB_INTEN_FRAME_INT_EN_Pos = 0x1e
	// Bit mask of FRAME_INT_EN field.
	USB_INTEN_FRAME_INT_EN_Msk = 0x40000000
	// Bit FRAME_INT_EN.
	USB_INTEN_FRAME_INT_EN = 0x40000000
	// Position of DEV_INT_EN field.
	USB_INTEN_DEV_INT_EN_Pos = 0x1f
	// Bit mask of DEV_INT_EN field.
	USB_INTEN_DEV_INT_EN_Msk = 0x80000000
	// Bit DEV_INT_EN.
	USB_INTEN_DEV_INT_EN = 0x80000000

	// INTSETSTAT: USB set interrupt status register
	// Position of EP_SET_INT field.
	USB_INTSETSTAT_EP_SET_INT_Pos = 0x0
	// Bit mask of EP_SET_INT field.
	USB_INTSETSTAT_EP_SET_INT_Msk = 0x3ff
	// Position of RESERVED field.
	USB_INTSETSTAT_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_INTSETSTAT_RESERVED_Msk = 0x3ffffc00
	// Position of FRAME_SET_INT field.
	USB_INTSETSTAT_FRAME_SET_INT_Pos = 0x1e
	// Bit mask of FRAME_SET_INT field.
	USB_INTSETSTAT_FRAME_SET_INT_Msk = 0x40000000
	// Bit FRAME_SET_INT.
	USB_INTSETSTAT_FRAME_SET_INT = 0x40000000
	// Position of DEV_SET_INT field.
	USB_INTSETSTAT_DEV_SET_INT_Pos = 0x1f
	// Bit mask of DEV_SET_INT field.
	USB_INTSETSTAT_DEV_SET_INT_Msk = 0x80000000
	// Bit DEV_SET_INT.
	USB_INTSETSTAT_DEV_SET_INT = 0x80000000

	// INTROUTING: USB interrupt routing register
	// Position of ROUTE_INT9_0 field.
	USB_INTROUTING_ROUTE_INT9_0_Pos = 0x0
	// Bit mask of ROUTE_INT9_0 field.
	USB_INTROUTING_ROUTE_INT9_0_Msk = 0x3ff
	// Position of RESERVED field.
	USB_INTROUTING_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_INTROUTING_RESERVED_Msk = 0x3ffffc00
	// Position of ROUTE_INT30 field.
	USB_INTROUTING_ROUTE_INT30_Pos = 0x1e
	// Bit mask of ROUTE_INT30 field.
	USB_INTROUTING_ROUTE_INT30_Msk = 0x40000000
	// Bit ROUTE_INT30.
	USB_INTROUTING_ROUTE_INT30 = 0x40000000
	// Position of ROUTE_INT31 field.
	USB_INTROUTING_ROUTE_INT31_Pos = 0x1f
	// Bit mask of ROUTE_INT31 field.
	USB_INTROUTING_ROUTE_INT31_Msk = 0x80000000
	// Bit ROUTE_INT31.
	USB_INTROUTING_ROUTE_INT31 = 0x80000000

	// EPTOGGLE: USB Endpoint toggle register
	// Position of TOGGLE field.
	USB_EPTOGGLE_TOGGLE_Pos = 0x0
	// Bit mask of TOGGLE field.
	USB_EPTOGGLE_TOGGLE_Msk = 0x3ff
	// Position of RESERVED field.
	USB_EPTOGGLE_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_EPTOGGLE_RESERVED_Msk = 0xfffffc00
)

// Bitfields for GPIO_PORT: GPIO port
const (
	// B00: Byte pin registers port 0; pins PIO0_0 to PIO0_31
	// Position of PBYTE field.
	GPIO_PORT_B0_PBYTE_Pos = 0x0
	// Bit mask of PBYTE field.
	GPIO_PORT_B0_PBYTE_Msk = 0x1
	// Bit PBYTE.
	GPIO_PORT_B0_PBYTE = 0x1

	// B132: Byte pin registers port 1
	// Position of PBYTE field.
	GPIO_PORT_B1_PBYTE_Pos = 0x0
	// Bit mask of PBYTE field.
	GPIO_PORT_B1_PBYTE_Msk = 0x1
	// Bit PBYTE.
	GPIO_PORT_B1_PBYTE = 0x1

	// W0: Word pin registers port 0
	// Position of PWORD field.
	GPIO_PORT_W_PWORD_Pos = 0x0
	// Bit mask of PWORD field.
	GPIO_PORT_W_PWORD_Msk = 0xffffffff

	// W32: Word pin registers port 1
	// Position of PWORD field.
	GPIO_PORT_W_PWORD_Pos = 0x0
	// Bit mask of PWORD field.
	GPIO_PORT_W_PWORD_Msk = 0xffffffff

	// DIR0: Direction registers port 0/1
	// Position of DIRP0 field.
	GPIO_PORT_DIR_DIRP0_Pos = 0x0
	// Bit mask of DIRP0 field.
	GPIO_PORT_DIR_DIRP0_Msk = 0x1
	// Bit DIRP0.
	GPIO_PORT_DIR_DIRP0 = 0x1
	// Position of DIRP1 field.
	GPIO_PORT_DIR_DIRP1_Pos = 0x1
	// Bit mask of DIRP1 field.
	GPIO_PORT_DIR_DIRP1_Msk = 0x2
	// Bit DIRP1.
	GPIO_PORT_DIR_DIRP1 = 0x2
	// Position of DIRP2 field.
	GPIO_PORT_DIR_DIRP2_Pos = 0x2
	// Bit mask of DIRP2 field.
	GPIO_PORT_DIR_DIRP2_Msk = 0x4
	// Bit DIRP2.
	GPIO_PORT_DIR_DIRP2 = 0x4
	// Position of DIRP3 field.
	GPIO_PORT_DIR_DIRP3_Pos = 0x3
	// Bit mask of DIRP3 field.
	GPIO_PORT_DIR_DIRP3_Msk = 0x8
	// Bit DIRP3.
	GPIO_PORT_DIR_DIRP3 = 0x8
	// Position of DIRP4 field.
	GPIO_PORT_DIR_DIRP4_Pos = 0x4
	// Bit mask of DIRP4 field.
	GPIO_PORT_DIR_DIRP4_Msk = 0x10
	// Bit DIRP4.
	GPIO_PORT_DIR_DIRP4 = 0x10
	// Position of DIRP5 field.
	GPIO_PORT_DIR_DIRP5_Pos = 0x5
	// Bit mask of DIRP5 field.
	GPIO_PORT_DIR_DIRP5_Msk = 0x20
	// Bit DIRP5.
	GPIO_PORT_DIR_DIRP5 = 0x20
	// Position of DIRP6 field.
	GPIO_PORT_DIR_DIRP6_Pos = 0x6
	// Bit mask of DIRP6 field.
	GPIO_PORT_DIR_DIRP6_Msk = 0x40
	// Bit DIRP6.
	GPIO_PORT_DIR_DIRP6 = 0x40
	// Position of DIRP7 field.
	GPIO_PORT_DIR_DIRP7_Pos = 0x7
	// Bit mask of DIRP7 field.
	GPIO_PORT_DIR_DIRP7_Msk = 0x80
	// Bit DIRP7.
	GPIO_PORT_DIR_DIRP7 = 0x80
	// Position of DIRP8 field.
	GPIO_PORT_DIR_DIRP8_Pos = 0x8
	// Bit mask of DIRP8 field.
	GPIO_PORT_DIR_DIRP8_Msk = 0x100
	// Bit DIRP8.
	GPIO_PORT_DIR_DIRP8 = 0x100
	// Position of DIRP9 field.
	GPIO_PORT_DIR_DIRP9_Pos = 0x9
	// Bit mask of DIRP9 field.
	GPIO_PORT_DIR_DIRP9_Msk = 0x200
	// Bit DIRP9.
	GPIO_PORT_DIR_DIRP9 = 0x200
	// Position of DIRP10 field.
	GPIO_PORT_DIR_DIRP10_Pos = 0xa
	// Bit mask of DIRP10 field.
	GPIO_PORT_DIR_DIRP10_Msk = 0x400
	// Bit DIRP10.
	GPIO_PORT_DIR_DIRP10 = 0x400
	// Position of DIRP11 field.
	GPIO_PORT_DIR_DIRP11_Pos = 0xb
	// Bit mask of DIRP11 field.
	GPIO_PORT_DIR_DIRP11_Msk = 0x800
	// Bit DIRP11.
	GPIO_PORT_DIR_DIRP11 = 0x800
	// Position of DIRP12 field.
	GPIO_PORT_DIR_DIRP12_Pos = 0xc
	// Bit mask of DIRP12 field.
	GPIO_PORT_DIR_DIRP12_Msk = 0x1000
	// Bit DIRP12.
	GPIO_PORT_DIR_DIRP12 = 0x1000
	// Position of DIRP13 field.
	GPIO_PORT_DIR_DIRP13_Pos = 0xd
	// Bit mask of DIRP13 field.
	GPIO_PORT_DIR_DIRP13_Msk = 0x2000
	// Bit DIRP13.
	GPIO_PORT_DIR_DIRP13 = 0x2000
	// Position of DIRP14 field.
	GPIO_PORT_DIR_DIRP14_Pos = 0xe
	// Bit mask of DIRP14 field.
	GPIO_PORT_DIR_DIRP14_Msk = 0x4000
	// Bit DIRP14.
	GPIO_PORT_DIR_DIRP14 = 0x4000
	// Position of DIRP15 field.
	GPIO_PORT_DIR_DIRP15_Pos = 0xf
	// Bit mask of DIRP15 field.
	GPIO_PORT_DIR_DIRP15_Msk = 0x8000
	// Bit DIRP15.
	GPIO_PORT_DIR_DIRP15 = 0x8000
	// Position of DIRP16 field.
	GPIO_PORT_DIR_DIRP16_Pos = 0x10
	// Bit mask of DIRP16 field.
	GPIO_PORT_DIR_DIRP16_Msk = 0x10000
	// Bit DIRP16.
	GPIO_PORT_DIR_DIRP16 = 0x10000
	// Position of DIRP17 field.
	GPIO_PORT_DIR_DIRP17_Pos = 0x11
	// Bit mask of DIRP17 field.
	GPIO_PORT_DIR_DIRP17_Msk = 0x20000
	// Bit DIRP17.
	GPIO_PORT_DIR_DIRP17 = 0x20000
	// Position of DIRP18 field.
	GPIO_PORT_DIR_DIRP18_Pos = 0x12
	// Bit mask of DIRP18 field.
	GPIO_PORT_DIR_DIRP18_Msk = 0x40000
	// Bit DIRP18.
	GPIO_PORT_DIR_DIRP18 = 0x40000
	// Position of DIRP19 field.
	GPIO_PORT_DIR_DIRP19_Pos = 0x13
	// Bit mask of DIRP19 field.
	GPIO_PORT_DIR_DIRP19_Msk = 0x80000
	// Bit DIRP19.
	GPIO_PORT_DIR_DIRP19 = 0x80000
	// Position of DIRP20 field.
	GPIO_PORT_DIR_DIRP20_Pos = 0x14
	// Bit mask of DIRP20 field.
	GPIO_PORT_DIR_DIRP20_Msk = 0x100000
	// Bit DIRP20.
	GPIO_PORT_DIR_DIRP20 = 0x100000
	// Position of DIRP21 field.
	GPIO_PORT_DIR_DIRP21_Pos = 0x15
	// Bit mask of DIRP21 field.
	GPIO_PORT_DIR_DIRP21_Msk = 0x200000
	// Bit DIRP21.
	GPIO_PORT_DIR_DIRP21 = 0x200000
	// Position of DIRP22 field.
	GPIO_PORT_DIR_DIRP22_Pos = 0x16
	// Bit mask of DIRP22 field.
	GPIO_PORT_DIR_DIRP22_Msk = 0x400000
	// Bit DIRP22.
	GPIO_PORT_DIR_DIRP22 = 0x400000
	// Position of DIRP23 field.
	GPIO_PORT_DIR_DIRP23_Pos = 0x17
	// Bit mask of DIRP23 field.
	GPIO_PORT_DIR_DIRP23_Msk = 0x800000
	// Bit DIRP23.
	GPIO_PORT_DIR_DIRP23 = 0x800000
	// Position of DIRP24 field.
	GPIO_PORT_DIR_DIRP24_Pos = 0x18
	// Bit mask of DIRP24 field.
	GPIO_PORT_DIR_DIRP24_Msk = 0x1000000
	// Bit DIRP24.
	GPIO_PORT_DIR_DIRP24 = 0x1000000
	// Position of DIRP25 field.
	GPIO_PORT_DIR_DIRP25_Pos = 0x19
	// Bit mask of DIRP25 field.
	GPIO_PORT_DIR_DIRP25_Msk = 0x2000000
	// Bit DIRP25.
	GPIO_PORT_DIR_DIRP25 = 0x2000000
	// Position of DIRP26 field.
	GPIO_PORT_DIR_DIRP26_Pos = 0x1a
	// Bit mask of DIRP26 field.
	GPIO_PORT_DIR_DIRP26_Msk = 0x4000000
	// Bit DIRP26.
	GPIO_PORT_DIR_DIRP26 = 0x4000000
	// Position of DIRP27 field.
	GPIO_PORT_DIR_DIRP27_Pos = 0x1b
	// Bit mask of DIRP27 field.
	GPIO_PORT_DIR_DIRP27_Msk = 0x8000000
	// Bit DIRP27.
	GPIO_PORT_DIR_DIRP27 = 0x8000000
	// Position of DIRP28 field.
	GPIO_PORT_DIR_DIRP28_Pos = 0x1c
	// Bit mask of DIRP28 field.
	GPIO_PORT_DIR_DIRP28_Msk = 0x10000000
	// Bit DIRP28.
	GPIO_PORT_DIR_DIRP28 = 0x10000000
	// Position of DIRP29 field.
	GPIO_PORT_DIR_DIRP29_Pos = 0x1d
	// Bit mask of DIRP29 field.
	GPIO_PORT_DIR_DIRP29_Msk = 0x20000000
	// Bit DIRP29.
	GPIO_PORT_DIR_DIRP29 = 0x20000000
	// Position of DIRP30 field.
	GPIO_PORT_DIR_DIRP30_Pos = 0x1e
	// Bit mask of DIRP30 field.
	GPIO_PORT_DIR_DIRP30_Msk = 0x40000000
	// Bit DIRP30.
	GPIO_PORT_DIR_DIRP30 = 0x40000000
	// Position of DIRP31 field.
	GPIO_PORT_DIR_DIRP31_Pos = 0x1f
	// Bit mask of DIRP31 field.
	GPIO_PORT_DIR_DIRP31_Msk = 0x80000000
	// Bit DIRP31.
	GPIO_PORT_DIR_DIRP31 = 0x80000000

	// MASK0: Mask register port 0/1
	// Position of MASKP0 field.
	GPIO_PORT_MASK_MASKP0_Pos = 0x0
	// Bit mask of MASKP0 field.
	GPIO_PORT_MASK_MASKP0_Msk = 0x1
	// Bit MASKP0.
	GPIO_PORT_MASK_MASKP0 = 0x1
	// Position of MASKP1 field.
	GPIO_PORT_MASK_MASKP1_Pos = 0x1
	// Bit mask of MASKP1 field.
	GPIO_PORT_MASK_MASKP1_Msk = 0x2
	// Bit MASKP1.
	GPIO_PORT_MASK_MASKP1 = 0x2
	// Position of MASKP2 field.
	GPIO_PORT_MASK_MASKP2_Pos = 0x2
	// Bit mask of MASKP2 field.
	GPIO_PORT_MASK_MASKP2_Msk = 0x4
	// Bit MASKP2.
	GPIO_PORT_MASK_MASKP2 = 0x4
	// Position of MASKP3 field.
	GPIO_PORT_MASK_MASKP3_Pos = 0x3
	// Bit mask of MASKP3 field.
	GPIO_PORT_MASK_MASKP3_Msk = 0x8
	// Bit MASKP3.
	GPIO_PORT_MASK_MASKP3 = 0x8
	// Position of MASKP4 field.
	GPIO_PORT_MASK_MASKP4_Pos = 0x4
	// Bit mask of MASKP4 field.
	GPIO_PORT_MASK_MASKP4_Msk = 0x10
	// Bit MASKP4.
	GPIO_PORT_MASK_MASKP4 = 0x10
	// Position of MASKP5 field.
	GPIO_PORT_MASK_MASKP5_Pos = 0x5
	// Bit mask of MASKP5 field.
	GPIO_PORT_MASK_MASKP5_Msk = 0x20
	// Bit MASKP5.
	GPIO_PORT_MASK_MASKP5 = 0x20
	// Position of MASKP6 field.
	GPIO_PORT_MASK_MASKP6_Pos = 0x6
	// Bit mask of MASKP6 field.
	GPIO_PORT_MASK_MASKP6_Msk = 0x40
	// Bit MASKP6.
	GPIO_PORT_MASK_MASKP6 = 0x40
	// Position of MASKP7 field.
	GPIO_PORT_MASK_MASKP7_Pos = 0x7
	// Bit mask of MASKP7 field.
	GPIO_PORT_MASK_MASKP7_Msk = 0x80
	// Bit MASKP7.
	GPIO_PORT_MASK_MASKP7 = 0x80
	// Position of MASKP8 field.
	GPIO_PORT_MASK_MASKP8_Pos = 0x8
	// Bit mask of MASKP8 field.
	GPIO_PORT_MASK_MASKP8_Msk = 0x100
	// Bit MASKP8.
	GPIO_PORT_MASK_MASKP8 = 0x100
	// Position of MASKP9 field.
	GPIO_PORT_MASK_MASKP9_Pos = 0x9
	// Bit mask of MASKP9 field.
	GPIO_PORT_MASK_MASKP9_Msk = 0x200
	// Bit MASKP9.
	GPIO_PORT_MASK_MASKP9 = 0x200
	// Position of MASKP10 field.
	GPIO_PORT_MASK_MASKP10_Pos = 0xa
	// Bit mask of MASKP10 field.
	GPIO_PORT_MASK_MASKP10_Msk = 0x400
	// Bit MASKP10.
	GPIO_PORT_MASK_MASKP10 = 0x400
	// Position of MASKP11 field.
	GPIO_PORT_MASK_MASKP11_Pos = 0xb
	// Bit mask of MASKP11 field.
	GPIO_PORT_MASK_MASKP11_Msk = 0x800
	// Bit MASKP11.
	GPIO_PORT_MASK_MASKP11 = 0x800
	// Position of MASKP12 field.
	GPIO_PORT_MASK_MASKP12_Pos = 0xc
	// Bit mask of MASKP12 field.
	GPIO_PORT_MASK_MASKP12_Msk = 0x1000
	// Bit MASKP12.
	GPIO_PORT_MASK_MASKP12 = 0x1000
	// Position of MASKP13 field.
	GPIO_PORT_MASK_MASKP13_Pos = 0xd
	// Bit mask of MASKP13 field.
	GPIO_PORT_MASK_MASKP13_Msk = 0x2000
	// Bit MASKP13.
	GPIO_PORT_MASK_MASKP13 = 0x2000
	// Position of MASKP14 field.
	GPIO_PORT_MASK_MASKP14_Pos = 0xe
	// Bit mask of MASKP14 field.
	GPIO_PORT_MASK_MASKP14_Msk = 0x4000
	// Bit MASKP14.
	GPIO_PORT_MASK_MASKP14 = 0x4000
	// Position of MASKP15 field.
	GPIO_PORT_MASK_MASKP15_Pos = 0xf
	// Bit mask of MASKP15 field.
	GPIO_PORT_MASK_MASKP15_Msk = 0x8000
	// Bit MASKP15.
	GPIO_PORT_MASK_MASKP15 = 0x8000
	// Position of MASKP16 field.
	GPIO_PORT_MASK_MASKP16_Pos = 0x10
	// Bit mask of MASKP16 field.
	GPIO_PORT_MASK_MASKP16_Msk = 0x10000
	// Bit MASKP16.
	GPIO_PORT_MASK_MASKP16 = 0x10000
	// Position of MASKP17 field.
	GPIO_PORT_MASK_MASKP17_Pos = 0x11
	// Bit mask of MASKP17 field.
	GPIO_PORT_MASK_MASKP17_Msk = 0x20000
	// Bit MASKP17.
	GPIO_PORT_MASK_MASKP17 = 0x20000
	// Position of MASKP18 field.
	GPIO_PORT_MASK_MASKP18_Pos = 0x12
	// Bit mask of MASKP18 field.
	GPIO_PORT_MASK_MASKP18_Msk = 0x40000
	// Bit MASKP18.
	GPIO_PORT_MASK_MASKP18 = 0x40000
	// Position of MASKP19 field.
	GPIO_PORT_MASK_MASKP19_Pos = 0x13
	// Bit mask of MASKP19 field.
	GPIO_PORT_MASK_MASKP19_Msk = 0x80000
	// Bit MASKP19.
	GPIO_PORT_MASK_MASKP19 = 0x80000
	// Position of MASKP20 field.
	GPIO_PORT_MASK_MASKP20_Pos = 0x14
	// Bit mask of MASKP20 field.
	GPIO_PORT_MASK_MASKP20_Msk = 0x100000
	// Bit MASKP20.
	GPIO_PORT_MASK_MASKP20 = 0x100000
	// Position of MASKP21 field.
	GPIO_PORT_MASK_MASKP21_Pos = 0x15
	// Bit mask of MASKP21 field.
	GPIO_PORT_MASK_MASKP21_Msk = 0x200000
	// Bit MASKP21.
	GPIO_PORT_MASK_MASKP21 = 0x200000
	// Position of MASKP22 field.
	GPIO_PORT_MASK_MASKP22_Pos = 0x16
	// Bit mask of MASKP22 field.
	GPIO_PORT_MASK_MASKP22_Msk = 0x400000
	// Bit MASKP22.
	GPIO_PORT_MASK_MASKP22 = 0x400000
	// Position of MASKP23 field.
	GPIO_PORT_MASK_MASKP23_Pos = 0x17
	// Bit mask of MASKP23 field.
	GPIO_PORT_MASK_MASKP23_Msk = 0x800000
	// Bit MASKP23.
	GPIO_PORT_MASK_MASKP23 = 0x800000
	// Position of MASKP24 field.
	GPIO_PORT_MASK_MASKP24_Pos = 0x18
	// Bit mask of MASKP24 field.
	GPIO_PORT_MASK_MASKP24_Msk = 0x1000000
	// Bit MASKP24.
	GPIO_PORT_MASK_MASKP24 = 0x1000000
	// Position of MASKP25 field.
	GPIO_PORT_MASK_MASKP25_Pos = 0x19
	// Bit mask of MASKP25 field.
	GPIO_PORT_MASK_MASKP25_Msk = 0x2000000
	// Bit MASKP25.
	GPIO_PORT_MASK_MASKP25 = 0x2000000
	// Position of MASKP26 field.
	GPIO_PORT_MASK_MASKP26_Pos = 0x1a
	// Bit mask of MASKP26 field.
	GPIO_PORT_MASK_MASKP26_Msk = 0x4000000
	// Bit MASKP26.
	GPIO_PORT_MASK_MASKP26 = 0x4000000
	// Position of MASKP27 field.
	GPIO_PORT_MASK_MASKP27_Pos = 0x1b
	// Bit mask of MASKP27 field.
	GPIO_PORT_MASK_MASKP27_Msk = 0x8000000
	// Bit MASKP27.
	GPIO_PORT_MASK_MASKP27 = 0x8000000
	// Position of MASKP28 field.
	GPIO_PORT_MASK_MASKP28_Pos = 0x1c
	// Bit mask of MASKP28 field.
	GPIO_PORT_MASK_MASKP28_Msk = 0x10000000
	// Bit MASKP28.
	GPIO_PORT_MASK_MASKP28 = 0x10000000
	// Position of MASKP29 field.
	GPIO_PORT_MASK_MASKP29_Pos = 0x1d
	// Bit mask of MASKP29 field.
	GPIO_PORT_MASK_MASKP29_Msk = 0x20000000
	// Bit MASKP29.
	GPIO_PORT_MASK_MASKP29 = 0x20000000
	// Position of MASKP30 field.
	GPIO_PORT_MASK_MASKP30_Pos = 0x1e
	// Bit mask of MASKP30 field.
	GPIO_PORT_MASK_MASKP30_Msk = 0x40000000
	// Bit MASKP30.
	GPIO_PORT_MASK_MASKP30 = 0x40000000
	// Position of MASKP31 field.
	GPIO_PORT_MASK_MASKP31_Pos = 0x1f
	// Bit mask of MASKP31 field.
	GPIO_PORT_MASK_MASKP31_Msk = 0x80000000
	// Bit MASKP31.
	GPIO_PORT_MASK_MASKP31 = 0x80000000

	// PIN0: Portpin register port 0
	// Position of PORT0 field.
	GPIO_PORT_PIN_PORT0_Pos = 0x0
	// Bit mask of PORT0 field.
	GPIO_PORT_PIN_PORT0_Msk = 0x1
	// Bit PORT0.
	GPIO_PORT_PIN_PORT0 = 0x1
	// Position of PORT1 field.
	GPIO_PORT_PIN_PORT1_Pos = 0x1
	// Bit mask of PORT1 field.
	GPIO_PORT_PIN_PORT1_Msk = 0x2
	// Bit PORT1.
	GPIO_PORT_PIN_PORT1 = 0x2
	// Position of PORT2 field.
	GPIO_PORT_PIN_PORT2_Pos = 0x2
	// Bit mask of PORT2 field.
	GPIO_PORT_PIN_PORT2_Msk = 0x4
	// Bit PORT2.
	GPIO_PORT_PIN_PORT2 = 0x4
	// Position of PORT3 field.
	GPIO_PORT_PIN_PORT3_Pos = 0x3
	// Bit mask of PORT3 field.
	GPIO_PORT_PIN_PORT3_Msk = 0x8
	// Bit PORT3.
	GPIO_PORT_PIN_PORT3 = 0x8
	// Position of PORT4 field.
	GPIO_PORT_PIN_PORT4_Pos = 0x4
	// Bit mask of PORT4 field.
	GPIO_PORT_PIN_PORT4_Msk = 0x10
	// Bit PORT4.
	GPIO_PORT_PIN_PORT4 = 0x10
	// Position of PORT5 field.
	GPIO_PORT_PIN_PORT5_Pos = 0x5
	// Bit mask of PORT5 field.
	GPIO_PORT_PIN_PORT5_Msk = 0x20
	// Bit PORT5.
	GPIO_PORT_PIN_PORT5 = 0x20
	// Position of PORT6 field.
	GPIO_PORT_PIN_PORT6_Pos = 0x6
	// Bit mask of PORT6 field.
	GPIO_PORT_PIN_PORT6_Msk = 0x40
	// Bit PORT6.
	GPIO_PORT_PIN_PORT6 = 0x40
	// Position of PORT7 field.
	GPIO_PORT_PIN_PORT7_Pos = 0x7
	// Bit mask of PORT7 field.
	GPIO_PORT_PIN_PORT7_Msk = 0x80
	// Bit PORT7.
	GPIO_PORT_PIN_PORT7 = 0x80
	// Position of PORT8 field.
	GPIO_PORT_PIN_PORT8_Pos = 0x8
	// Bit mask of PORT8 field.
	GPIO_PORT_PIN_PORT8_Msk = 0x100
	// Bit PORT8.
	GPIO_PORT_PIN_PORT8 = 0x100
	// Position of PORT9 field.
	GPIO_PORT_PIN_PORT9_Pos = 0x9
	// Bit mask of PORT9 field.
	GPIO_PORT_PIN_PORT9_Msk = 0x200
	// Bit PORT9.
	GPIO_PORT_PIN_PORT9 = 0x200
	// Position of PORT10 field.
	GPIO_PORT_PIN_PORT10_Pos = 0xa
	// Bit mask of PORT10 field.
	GPIO_PORT_PIN_PORT10_Msk = 0x400
	// Bit PORT10.
	GPIO_PORT_PIN_PORT10 = 0x400
	// Position of PORT11 field.
	GPIO_PORT_PIN_PORT11_Pos = 0xb
	// Bit mask of PORT11 field.
	GPIO_PORT_PIN_PORT11_Msk = 0x800
	// Bit PORT11.
	GPIO_PORT_PIN_PORT11 = 0x800
	// Position of PORT12 field.
	GPIO_PORT_PIN_PORT12_Pos = 0xc
	// Bit mask of PORT12 field.
	GPIO_PORT_PIN_PORT12_Msk = 0x1000
	// Bit PORT12.
	GPIO_PORT_PIN_PORT12 = 0x1000
	// Position of PORT13 field.
	GPIO_PORT_PIN_PORT13_Pos = 0xd
	// Bit mask of PORT13 field.
	GPIO_PORT_PIN_PORT13_Msk = 0x2000
	// Bit PORT13.
	GPIO_PORT_PIN_PORT13 = 0x2000
	// Position of PORT14 field.
	GPIO_PORT_PIN_PORT14_Pos = 0xe
	// Bit mask of PORT14 field.
	GPIO_PORT_PIN_PORT14_Msk = 0x4000
	// Bit PORT14.
	GPIO_PORT_PIN_PORT14 = 0x4000
	// Position of PORT15 field.
	GPIO_PORT_PIN_PORT15_Pos = 0xf
	// Bit mask of PORT15 field.
	GPIO_PORT_PIN_PORT15_Msk = 0x8000
	// Bit PORT15.
	GPIO_PORT_PIN_PORT15 = 0x8000
	// Position of PORT16 field.
	GPIO_PORT_PIN_PORT16_Pos = 0x10
	// Bit mask of PORT16 field.
	GPIO_PORT_PIN_PORT16_Msk = 0x10000
	// Bit PORT16.
	GPIO_PORT_PIN_PORT16 = 0x10000
	// Position of PORT17 field.
	GPIO_PORT_PIN_PORT17_Pos = 0x11
	// Bit mask of PORT17 field.
	GPIO_PORT_PIN_PORT17_Msk = 0x20000
	// Bit PORT17.
	GPIO_PORT_PIN_PORT17 = 0x20000
	// Position of PORT18 field.
	GPIO_PORT_PIN_PORT18_Pos = 0x12
	// Bit mask of PORT18 field.
	GPIO_PORT_PIN_PORT18_Msk = 0x40000
	// Bit PORT18.
	GPIO_PORT_PIN_PORT18 = 0x40000
	// Position of PORT19 field.
	GPIO_PORT_PIN_PORT19_Pos = 0x13
	// Bit mask of PORT19 field.
	GPIO_PORT_PIN_PORT19_Msk = 0x80000
	// Bit PORT19.
	GPIO_PORT_PIN_PORT19 = 0x80000
	// Position of PORT20 field.
	GPIO_PORT_PIN_PORT20_Pos = 0x14
	// Bit mask of PORT20 field.
	GPIO_PORT_PIN_PORT20_Msk = 0x100000
	// Bit PORT20.
	GPIO_PORT_PIN_PORT20 = 0x100000
	// Position of PORT21 field.
	GPIO_PORT_PIN_PORT21_Pos = 0x15
	// Bit mask of PORT21 field.
	GPIO_PORT_PIN_PORT21_Msk = 0x200000
	// Bit PORT21.
	GPIO_PORT_PIN_PORT21 = 0x200000
	// Position of PORT22 field.
	GPIO_PORT_PIN_PORT22_Pos = 0x16
	// Bit mask of PORT22 field.
	GPIO_PORT_PIN_PORT22_Msk = 0x400000
	// Bit PORT22.
	GPIO_PORT_PIN_PORT22 = 0x400000
	// Position of PORT23 field.
	GPIO_PORT_PIN_PORT23_Pos = 0x17
	// Bit mask of PORT23 field.
	GPIO_PORT_PIN_PORT23_Msk = 0x800000
	// Bit PORT23.
	GPIO_PORT_PIN_PORT23 = 0x800000
	// Position of PORT24 field.
	GPIO_PORT_PIN_PORT24_Pos = 0x18
	// Bit mask of PORT24 field.
	GPIO_PORT_PIN_PORT24_Msk = 0x1000000
	// Bit PORT24.
	GPIO_PORT_PIN_PORT24 = 0x1000000
	// Position of PORT25 field.
	GPIO_PORT_PIN_PORT25_Pos = 0x19
	// Bit mask of PORT25 field.
	GPIO_PORT_PIN_PORT25_Msk = 0x2000000
	// Bit PORT25.
	GPIO_PORT_PIN_PORT25 = 0x2000000
	// Position of PORT26 field.
	GPIO_PORT_PIN_PORT26_Pos = 0x1a
	// Bit mask of PORT26 field.
	GPIO_PORT_PIN_PORT26_Msk = 0x4000000
	// Bit PORT26.
	GPIO_PORT_PIN_PORT26 = 0x4000000
	// Position of PORT27 field.
	GPIO_PORT_PIN_PORT27_Pos = 0x1b
	// Bit mask of PORT27 field.
	GPIO_PORT_PIN_PORT27_Msk = 0x8000000
	// Bit PORT27.
	GPIO_PORT_PIN_PORT27 = 0x8000000
	// Position of PORT28 field.
	GPIO_PORT_PIN_PORT28_Pos = 0x1c
	// Bit mask of PORT28 field.
	GPIO_PORT_PIN_PORT28_Msk = 0x10000000
	// Bit PORT28.
	GPIO_PORT_PIN_PORT28 = 0x10000000
	// Position of PORT29 field.
	GPIO_PORT_PIN_PORT29_Pos = 0x1d
	// Bit mask of PORT29 field.
	GPIO_PORT_PIN_PORT29_Msk = 0x20000000
	// Bit PORT29.
	GPIO_PORT_PIN_PORT29 = 0x20000000
	// Position of PORT30 field.
	GPIO_PORT_PIN_PORT30_Pos = 0x1e
	// Bit mask of PORT30 field.
	GPIO_PORT_PIN_PORT30_Msk = 0x40000000
	// Bit PORT30.
	GPIO_PORT_PIN_PORT30 = 0x40000000
	// Position of PORT31 field.
	GPIO_PORT_PIN_PORT31_Pos = 0x1f
	// Bit mask of PORT31 field.
	GPIO_PORT_PIN_PORT31_Msk = 0x80000000
	// Bit PORT31.
	GPIO_PORT_PIN_PORT31 = 0x80000000

	// MPIN0: Masked port register port 0/1
	// Position of MPORTP0 field.
	GPIO_PORT_MPIN_MPORTP0_Pos = 0x0
	// Bit mask of MPORTP0 field.
	GPIO_PORT_MPIN_MPORTP0_Msk = 0x1
	// Bit MPORTP0.
	GPIO_PORT_MPIN_MPORTP0 = 0x1
	// Position of MPORTP1 field.
	GPIO_PORT_MPIN_MPORTP1_Pos = 0x1
	// Bit mask of MPORTP1 field.
	GPIO_PORT_MPIN_MPORTP1_Msk = 0x2
	// Bit MPORTP1.
	GPIO_PORT_MPIN_MPORTP1 = 0x2
	// Position of MPORTP2 field.
	GPIO_PORT_MPIN_MPORTP2_Pos = 0x2
	// Bit mask of MPORTP2 field.
	GPIO_PORT_MPIN_MPORTP2_Msk = 0x4
	// Bit MPORTP2.
	GPIO_PORT_MPIN_MPORTP2 = 0x4
	// Position of MPORTP3 field.
	GPIO_PORT_MPIN_MPORTP3_Pos = 0x3
	// Bit mask of MPORTP3 field.
	GPIO_PORT_MPIN_MPORTP3_Msk = 0x8
	// Bit MPORTP3.
	GPIO_PORT_MPIN_MPORTP3 = 0x8
	// Position of MPORTP4 field.
	GPIO_PORT_MPIN_MPORTP4_Pos = 0x4
	// Bit mask of MPORTP4 field.
	GPIO_PORT_MPIN_MPORTP4_Msk = 0x10
	// Bit MPORTP4.
	GPIO_PORT_MPIN_MPORTP4 = 0x10
	// Position of MPORTP5 field.
	GPIO_PORT_MPIN_MPORTP5_Pos = 0x5
	// Bit mask of MPORTP5 field.
	GPIO_PORT_MPIN_MPORTP5_Msk = 0x20
	// Bit MPORTP5.
	GPIO_PORT_MPIN_MPORTP5 = 0x20
	// Position of MPORTP6 field.
	GPIO_PORT_MPIN_MPORTP6_Pos = 0x6
	// Bit mask of MPORTP6 field.
	GPIO_PORT_MPIN_MPORTP6_Msk = 0x40
	// Bit MPORTP6.
	GPIO_PORT_MPIN_MPORTP6 = 0x40
	// Position of MPORTP7 field.
	GPIO_PORT_MPIN_MPORTP7_Pos = 0x7
	// Bit mask of MPORTP7 field.
	GPIO_PORT_MPIN_MPORTP7_Msk = 0x80
	// Bit MPORTP7.
	GPIO_PORT_MPIN_MPORTP7 = 0x80
	// Position of MPORTP8 field.
	GPIO_PORT_MPIN_MPORTP8_Pos = 0x8
	// Bit mask of MPORTP8 field.
	GPIO_PORT_MPIN_MPORTP8_Msk = 0x100
	// Bit MPORTP8.
	GPIO_PORT_MPIN_MPORTP8 = 0x100
	// Position of MPORTP9 field.
	GPIO_PORT_MPIN_MPORTP9_Pos = 0x9
	// Bit mask of MPORTP9 field.
	GPIO_PORT_MPIN_MPORTP9_Msk = 0x200
	// Bit MPORTP9.
	GPIO_PORT_MPIN_MPORTP9 = 0x200
	// Position of MPORTP10 field.
	GPIO_PORT_MPIN_MPORTP10_Pos = 0xa
	// Bit mask of MPORTP10 field.
	GPIO_PORT_MPIN_MPORTP10_Msk = 0x400
	// Bit MPORTP10.
	GPIO_PORT_MPIN_MPORTP10 = 0x400
	// Position of MPORTP11 field.
	GPIO_PORT_MPIN_MPORTP11_Pos = 0xb
	// Bit mask of MPORTP11 field.
	GPIO_PORT_MPIN_MPORTP11_Msk = 0x800
	// Bit MPORTP11.
	GPIO_PORT_MPIN_MPORTP11 = 0x800
	// Position of MPORTP12 field.
	GPIO_PORT_MPIN_MPORTP12_Pos = 0xc
	// Bit mask of MPORTP12 field.
	GPIO_PORT_MPIN_MPORTP12_Msk = 0x1000
	// Bit MPORTP12.
	GPIO_PORT_MPIN_MPORTP12 = 0x1000
	// Position of MPORTP13 field.
	GPIO_PORT_MPIN_MPORTP13_Pos = 0xd
	// Bit mask of MPORTP13 field.
	GPIO_PORT_MPIN_MPORTP13_Msk = 0x2000
	// Bit MPORTP13.
	GPIO_PORT_MPIN_MPORTP13 = 0x2000
	// Position of MPORTP14 field.
	GPIO_PORT_MPIN_MPORTP14_Pos = 0xe
	// Bit mask of MPORTP14 field.
	GPIO_PORT_MPIN_MPORTP14_Msk = 0x4000
	// Bit MPORTP14.
	GPIO_PORT_MPIN_MPORTP14 = 0x4000
	// Position of MPORTP15 field.
	GPIO_PORT_MPIN_MPORTP15_Pos = 0xf
	// Bit mask of MPORTP15 field.
	GPIO_PORT_MPIN_MPORTP15_Msk = 0x8000
	// Bit MPORTP15.
	GPIO_PORT_MPIN_MPORTP15 = 0x8000
	// Position of MPORTP16 field.
	GPIO_PORT_MPIN_MPORTP16_Pos = 0x10
	// Bit mask of MPORTP16 field.
	GPIO_PORT_MPIN_MPORTP16_Msk = 0x10000
	// Bit MPORTP16.
	GPIO_PORT_MPIN_MPORTP16 = 0x10000
	// Position of MPORTP17 field.
	GPIO_PORT_MPIN_MPORTP17_Pos = 0x11
	// Bit mask of MPORTP17 field.
	GPIO_PORT_MPIN_MPORTP17_Msk = 0x20000
	// Bit MPORTP17.
	GPIO_PORT_MPIN_MPORTP17 = 0x20000
	// Position of MPORTP18 field.
	GPIO_PORT_MPIN_MPORTP18_Pos = 0x12
	// Bit mask of MPORTP18 field.
	GPIO_PORT_MPIN_MPORTP18_Msk = 0x40000
	// Bit MPORTP18.
	GPIO_PORT_MPIN_MPORTP18 = 0x40000
	// Position of MPORTP19 field.
	GPIO_PORT_MPIN_MPORTP19_Pos = 0x13
	// Bit mask of MPORTP19 field.
	GPIO_PORT_MPIN_MPORTP19_Msk = 0x80000
	// Bit MPORTP19.
	GPIO_PORT_MPIN_MPORTP19 = 0x80000
	// Position of MPORTP20 field.
	GPIO_PORT_MPIN_MPORTP20_Pos = 0x14
	// Bit mask of MPORTP20 field.
	GPIO_PORT_MPIN_MPORTP20_Msk = 0x100000
	// Bit MPORTP20.
	GPIO_PORT_MPIN_MPORTP20 = 0x100000
	// Position of MPORTP21 field.
	GPIO_PORT_MPIN_MPORTP21_Pos = 0x15
	// Bit mask of MPORTP21 field.
	GPIO_PORT_MPIN_MPORTP21_Msk = 0x200000
	// Bit MPORTP21.
	GPIO_PORT_MPIN_MPORTP21 = 0x200000
	// Position of MPORTP22 field.
	GPIO_PORT_MPIN_MPORTP22_Pos = 0x16
	// Bit mask of MPORTP22 field.
	GPIO_PORT_MPIN_MPORTP22_Msk = 0x400000
	// Bit MPORTP22.
	GPIO_PORT_MPIN_MPORTP22 = 0x400000
	// Position of MPORTP23 field.
	GPIO_PORT_MPIN_MPORTP23_Pos = 0x17
	// Bit mask of MPORTP23 field.
	GPIO_PORT_MPIN_MPORTP23_Msk = 0x800000
	// Bit MPORTP23.
	GPIO_PORT_MPIN_MPORTP23 = 0x800000
	// Position of MPORTP24 field.
	GPIO_PORT_MPIN_MPORTP24_Pos = 0x18
	// Bit mask of MPORTP24 field.
	GPIO_PORT_MPIN_MPORTP24_Msk = 0x1000000
	// Bit MPORTP24.
	GPIO_PORT_MPIN_MPORTP24 = 0x1000000
	// Position of MPORTP25 field.
	GPIO_PORT_MPIN_MPORTP25_Pos = 0x19
	// Bit mask of MPORTP25 field.
	GPIO_PORT_MPIN_MPORTP25_Msk = 0x2000000
	// Bit MPORTP25.
	GPIO_PORT_MPIN_MPORTP25 = 0x2000000
	// Position of MPORTP26 field.
	GPIO_PORT_MPIN_MPORTP26_Pos = 0x1a
	// Bit mask of MPORTP26 field.
	GPIO_PORT_MPIN_MPORTP26_Msk = 0x4000000
	// Bit MPORTP26.
	GPIO_PORT_MPIN_MPORTP26 = 0x4000000
	// Position of MPORTP27 field.
	GPIO_PORT_MPIN_MPORTP27_Pos = 0x1b
	// Bit mask of MPORTP27 field.
	GPIO_PORT_MPIN_MPORTP27_Msk = 0x8000000
	// Bit MPORTP27.
	GPIO_PORT_MPIN_MPORTP27 = 0x8000000
	// Position of MPORTP28 field.
	GPIO_PORT_MPIN_MPORTP28_Pos = 0x1c
	// Bit mask of MPORTP28 field.
	GPIO_PORT_MPIN_MPORTP28_Msk = 0x10000000
	// Bit MPORTP28.
	GPIO_PORT_MPIN_MPORTP28 = 0x10000000
	// Position of MPORTP29 field.
	GPIO_PORT_MPIN_MPORTP29_Pos = 0x1d
	// Bit mask of MPORTP29 field.
	GPIO_PORT_MPIN_MPORTP29_Msk = 0x20000000
	// Bit MPORTP29.
	GPIO_PORT_MPIN_MPORTP29 = 0x20000000
	// Position of MPORTP30 field.
	GPIO_PORT_MPIN_MPORTP30_Pos = 0x1e
	// Bit mask of MPORTP30 field.
	GPIO_PORT_MPIN_MPORTP30_Msk = 0x40000000
	// Bit MPORTP30.
	GPIO_PORT_MPIN_MPORTP30 = 0x40000000
	// Position of MPORTP31 field.
	GPIO_PORT_MPIN_MPORTP31_Pos = 0x1f
	// Bit mask of MPORTP31 field.
	GPIO_PORT_MPIN_MPORTP31_Msk = 0x80000000
	// Bit MPORTP31.
	GPIO_PORT_MPIN_MPORTP31 = 0x80000000

	// SET0: Write: Set register for port 0/1 Read: output bits for port 0/1
	// Position of SETP0 field.
	GPIO_PORT_SET_SETP0_Pos = 0x0
	// Bit mask of SETP0 field.
	GPIO_PORT_SET_SETP0_Msk = 0x1
	// Bit SETP0.
	GPIO_PORT_SET_SETP0 = 0x1
	// Position of SETP1 field.
	GPIO_PORT_SET_SETP1_Pos = 0x1
	// Bit mask of SETP1 field.
	GPIO_PORT_SET_SETP1_Msk = 0x2
	// Bit SETP1.
	GPIO_PORT_SET_SETP1 = 0x2
	// Position of SETP2 field.
	GPIO_PORT_SET_SETP2_Pos = 0x2
	// Bit mask of SETP2 field.
	GPIO_PORT_SET_SETP2_Msk = 0x4
	// Bit SETP2.
	GPIO_PORT_SET_SETP2 = 0x4
	// Position of SETP3 field.
	GPIO_PORT_SET_SETP3_Pos = 0x3
	// Bit mask of SETP3 field.
	GPIO_PORT_SET_SETP3_Msk = 0x8
	// Bit SETP3.
	GPIO_PORT_SET_SETP3 = 0x8
	// Position of SETP4 field.
	GPIO_PORT_SET_SETP4_Pos = 0x4
	// Bit mask of SETP4 field.
	GPIO_PORT_SET_SETP4_Msk = 0x10
	// Bit SETP4.
	GPIO_PORT_SET_SETP4 = 0x10
	// Position of SETP5 field.
	GPIO_PORT_SET_SETP5_Pos = 0x5
	// Bit mask of SETP5 field.
	GPIO_PORT_SET_SETP5_Msk = 0x20
	// Bit SETP5.
	GPIO_PORT_SET_SETP5 = 0x20
	// Position of SETP6 field.
	GPIO_PORT_SET_SETP6_Pos = 0x6
	// Bit mask of SETP6 field.
	GPIO_PORT_SET_SETP6_Msk = 0x40
	// Bit SETP6.
	GPIO_PORT_SET_SETP6 = 0x40
	// Position of SETP7 field.
	GPIO_PORT_SET_SETP7_Pos = 0x7
	// Bit mask of SETP7 field.
	GPIO_PORT_SET_SETP7_Msk = 0x80
	// Bit SETP7.
	GPIO_PORT_SET_SETP7 = 0x80
	// Position of SETP8 field.
	GPIO_PORT_SET_SETP8_Pos = 0x8
	// Bit mask of SETP8 field.
	GPIO_PORT_SET_SETP8_Msk = 0x100
	// Bit SETP8.
	GPIO_PORT_SET_SETP8 = 0x100
	// Position of SETP9 field.
	GPIO_PORT_SET_SETP9_Pos = 0x9
	// Bit mask of SETP9 field.
	GPIO_PORT_SET_SETP9_Msk = 0x200
	// Bit SETP9.
	GPIO_PORT_SET_SETP9 = 0x200
	// Position of SETP10 field.
	GPIO_PORT_SET_SETP10_Pos = 0xa
	// Bit mask of SETP10 field.
	GPIO_PORT_SET_SETP10_Msk = 0x400
	// Bit SETP10.
	GPIO_PORT_SET_SETP10 = 0x400
	// Position of SETP11 field.
	GPIO_PORT_SET_SETP11_Pos = 0xb
	// Bit mask of SETP11 field.
	GPIO_PORT_SET_SETP11_Msk = 0x800
	// Bit SETP11.
	GPIO_PORT_SET_SETP11 = 0x800
	// Position of SETP12 field.
	GPIO_PORT_SET_SETP12_Pos = 0xc
	// Bit mask of SETP12 field.
	GPIO_PORT_SET_SETP12_Msk = 0x1000
	// Bit SETP12.
	GPIO_PORT_SET_SETP12 = 0x1000
	// Position of SETP13 field.
	GPIO_PORT_SET_SETP13_Pos = 0xd
	// Bit mask of SETP13 field.
	GPIO_PORT_SET_SETP13_Msk = 0x2000
	// Bit SETP13.
	GPIO_PORT_SET_SETP13 = 0x2000
	// Position of SETP14 field.
	GPIO_PORT_SET_SETP14_Pos = 0xe
	// Bit mask of SETP14 field.
	GPIO_PORT_SET_SETP14_Msk = 0x4000
	// Bit SETP14.
	GPIO_PORT_SET_SETP14 = 0x4000
	// Position of SETP15 field.
	GPIO_PORT_SET_SETP15_Pos = 0xf
	// Bit mask of SETP15 field.
	GPIO_PORT_SET_SETP15_Msk = 0x8000
	// Bit SETP15.
	GPIO_PORT_SET_SETP15 = 0x8000
	// Position of SETP16 field.
	GPIO_PORT_SET_SETP16_Pos = 0x10
	// Bit mask of SETP16 field.
	GPIO_PORT_SET_SETP16_Msk = 0x10000
	// Bit SETP16.
	GPIO_PORT_SET_SETP16 = 0x10000
	// Position of SETP17 field.
	GPIO_PORT_SET_SETP17_Pos = 0x11
	// Bit mask of SETP17 field.
	GPIO_PORT_SET_SETP17_Msk = 0x20000
	// Bit SETP17.
	GPIO_PORT_SET_SETP17 = 0x20000
	// Position of SETP18 field.
	GPIO_PORT_SET_SETP18_Pos = 0x12
	// Bit mask of SETP18 field.
	GPIO_PORT_SET_SETP18_Msk = 0x40000
	// Bit SETP18.
	GPIO_PORT_SET_SETP18 = 0x40000
	// Position of SETP19 field.
	GPIO_PORT_SET_SETP19_Pos = 0x13
	// Bit mask of SETP19 field.
	GPIO_PORT_SET_SETP19_Msk = 0x80000
	// Bit SETP19.
	GPIO_PORT_SET_SETP19 = 0x80000
	// Position of SETP20 field.
	GPIO_PORT_SET_SETP20_Pos = 0x14
	// Bit mask of SETP20 field.
	GPIO_PORT_SET_SETP20_Msk = 0x100000
	// Bit SETP20.
	GPIO_PORT_SET_SETP20 = 0x100000
	// Position of SETP21 field.
	GPIO_PORT_SET_SETP21_Pos = 0x15
	// Bit mask of SETP21 field.
	GPIO_PORT_SET_SETP21_Msk = 0x200000
	// Bit SETP21.
	GPIO_PORT_SET_SETP21 = 0x200000
	// Position of SETP22 field.
	GPIO_PORT_SET_SETP22_Pos = 0x16
	// Bit mask of SETP22 field.
	GPIO_PORT_SET_SETP22_Msk = 0x400000
	// Bit SETP22.
	GPIO_PORT_SET_SETP22 = 0x400000
	// Position of SETP23 field.
	GPIO_PORT_SET_SETP23_Pos = 0x17
	// Bit mask of SETP23 field.
	GPIO_PORT_SET_SETP23_Msk = 0x800000
	// Bit SETP23.
	GPIO_PORT_SET_SETP23 = 0x800000
	// Position of SETP24 field.
	GPIO_PORT_SET_SETP24_Pos = 0x18
	// Bit mask of SETP24 field.
	GPIO_PORT_SET_SETP24_Msk = 0x1000000
	// Bit SETP24.
	GPIO_PORT_SET_SETP24 = 0x1000000
	// Position of SETP25 field.
	GPIO_PORT_SET_SETP25_Pos = 0x19
	// Bit mask of SETP25 field.
	GPIO_PORT_SET_SETP25_Msk = 0x2000000
	// Bit SETP25.
	GPIO_PORT_SET_SETP25 = 0x2000000
	// Position of SETP26 field.
	GPIO_PORT_SET_SETP26_Pos = 0x1a
	// Bit mask of SETP26 field.
	GPIO_PORT_SET_SETP26_Msk = 0x4000000
	// Bit SETP26.
	GPIO_PORT_SET_SETP26 = 0x4000000
	// Position of SETP27 field.
	GPIO_PORT_SET_SETP27_Pos = 0x1b
	// Bit mask of SETP27 field.
	GPIO_PORT_SET_SETP27_Msk = 0x8000000
	// Bit SETP27.
	GPIO_PORT_SET_SETP27 = 0x8000000
	// Position of SETP28 field.
	GPIO_PORT_SET_SETP28_Pos = 0x1c
	// Bit mask of SETP28 field.
	GPIO_PORT_SET_SETP28_Msk = 0x10000000
	// Bit SETP28.
	GPIO_PORT_SET_SETP28 = 0x10000000
	// Position of SETP29 field.
	GPIO_PORT_SET_SETP29_Pos = 0x1d
	// Bit mask of SETP29 field.
	GPIO_PORT_SET_SETP29_Msk = 0x20000000
	// Bit SETP29.
	GPIO_PORT_SET_SETP29 = 0x20000000
	// Position of SETP30 field.
	GPIO_PORT_SET_SETP30_Pos = 0x1e
	// Bit mask of SETP30 field.
	GPIO_PORT_SET_SETP30_Msk = 0x40000000
	// Bit SETP30.
	GPIO_PORT_SET_SETP30 = 0x40000000
	// Position of SETP31 field.
	GPIO_PORT_SET_SETP31_Pos = 0x1f
	// Bit mask of SETP31 field.
	GPIO_PORT_SET_SETP31_Msk = 0x80000000
	// Bit SETP31.
	GPIO_PORT_SET_SETP31 = 0x80000000

	// CLR0: Clear port 0/1
	// Position of CLRP00 field.
	GPIO_PORT_CLR_CLRP00_Pos = 0x0
	// Bit mask of CLRP00 field.
	GPIO_PORT_CLR_CLRP00_Msk = 0x1
	// Bit CLRP00.
	GPIO_PORT_CLR_CLRP00 = 0x1
	// Position of CLRP01 field.
	GPIO_PORT_CLR_CLRP01_Pos = 0x1
	// Bit mask of CLRP01 field.
	GPIO_PORT_CLR_CLRP01_Msk = 0x2
	// Bit CLRP01.
	GPIO_PORT_CLR_CLRP01 = 0x2
	// Position of CLRP02 field.
	GPIO_PORT_CLR_CLRP02_Pos = 0x2
	// Bit mask of CLRP02 field.
	GPIO_PORT_CLR_CLRP02_Msk = 0x4
	// Bit CLRP02.
	GPIO_PORT_CLR_CLRP02 = 0x4
	// Position of CLRP03 field.
	GPIO_PORT_CLR_CLRP03_Pos = 0x3
	// Bit mask of CLRP03 field.
	GPIO_PORT_CLR_CLRP03_Msk = 0x8
	// Bit CLRP03.
	GPIO_PORT_CLR_CLRP03 = 0x8
	// Position of CLRP04 field.
	GPIO_PORT_CLR_CLRP04_Pos = 0x4
	// Bit mask of CLRP04 field.
	GPIO_PORT_CLR_CLRP04_Msk = 0x10
	// Bit CLRP04.
	GPIO_PORT_CLR_CLRP04 = 0x10
	// Position of CLRP05 field.
	GPIO_PORT_CLR_CLRP05_Pos = 0x5
	// Bit mask of CLRP05 field.
	GPIO_PORT_CLR_CLRP05_Msk = 0x20
	// Bit CLRP05.
	GPIO_PORT_CLR_CLRP05 = 0x20
	// Position of CLRP06 field.
	GPIO_PORT_CLR_CLRP06_Pos = 0x6
	// Bit mask of CLRP06 field.
	GPIO_PORT_CLR_CLRP06_Msk = 0x40
	// Bit CLRP06.
	GPIO_PORT_CLR_CLRP06 = 0x40
	// Position of CLRP07 field.
	GPIO_PORT_CLR_CLRP07_Pos = 0x7
	// Bit mask of CLRP07 field.
	GPIO_PORT_CLR_CLRP07_Msk = 0x80
	// Bit CLRP07.
	GPIO_PORT_CLR_CLRP07 = 0x80
	// Position of CLRP08 field.
	GPIO_PORT_CLR_CLRP08_Pos = 0x8
	// Bit mask of CLRP08 field.
	GPIO_PORT_CLR_CLRP08_Msk = 0x100
	// Bit CLRP08.
	GPIO_PORT_CLR_CLRP08 = 0x100
	// Position of CLRP09 field.
	GPIO_PORT_CLR_CLRP09_Pos = 0x9
	// Bit mask of CLRP09 field.
	GPIO_PORT_CLR_CLRP09_Msk = 0x200
	// Bit CLRP09.
	GPIO_PORT_CLR_CLRP09 = 0x200
	// Position of CLRP010 field.
	GPIO_PORT_CLR_CLRP010_Pos = 0xa
	// Bit mask of CLRP010 field.
	GPIO_PORT_CLR_CLRP010_Msk = 0x400
	// Bit CLRP010.
	GPIO_PORT_CLR_CLRP010 = 0x400
	// Position of CLRP011 field.
	GPIO_PORT_CLR_CLRP011_Pos = 0xb
	// Bit mask of CLRP011 field.
	GPIO_PORT_CLR_CLRP011_Msk = 0x800
	// Bit CLRP011.
	GPIO_PORT_CLR_CLRP011 = 0x800
	// Position of CLRP012 field.
	GPIO_PORT_CLR_CLRP012_Pos = 0xc
	// Bit mask of CLRP012 field.
	GPIO_PORT_CLR_CLRP012_Msk = 0x1000
	// Bit CLRP012.
	GPIO_PORT_CLR_CLRP012 = 0x1000
	// Position of CLRP013 field.
	GPIO_PORT_CLR_CLRP013_Pos = 0xd
	// Bit mask of CLRP013 field.
	GPIO_PORT_CLR_CLRP013_Msk = 0x2000
	// Bit CLRP013.
	GPIO_PORT_CLR_CLRP013 = 0x2000
	// Position of CLRP014 field.
	GPIO_PORT_CLR_CLRP014_Pos = 0xe
	// Bit mask of CLRP014 field.
	GPIO_PORT_CLR_CLRP014_Msk = 0x4000
	// Bit CLRP014.
	GPIO_PORT_CLR_CLRP014 = 0x4000
	// Position of CLRP015 field.
	GPIO_PORT_CLR_CLRP015_Pos = 0xf
	// Bit mask of CLRP015 field.
	GPIO_PORT_CLR_CLRP015_Msk = 0x8000
	// Bit CLRP015.
	GPIO_PORT_CLR_CLRP015 = 0x8000
	// Position of CLRP016 field.
	GPIO_PORT_CLR_CLRP016_Pos = 0x10
	// Bit mask of CLRP016 field.
	GPIO_PORT_CLR_CLRP016_Msk = 0x10000
	// Bit CLRP016.
	GPIO_PORT_CLR_CLRP016 = 0x10000
	// Position of CLRP017 field.
	GPIO_PORT_CLR_CLRP017_Pos = 0x11
	// Bit mask of CLRP017 field.
	GPIO_PORT_CLR_CLRP017_Msk = 0x20000
	// Bit CLRP017.
	GPIO_PORT_CLR_CLRP017 = 0x20000
	// Position of CLRP018 field.
	GPIO_PORT_CLR_CLRP018_Pos = 0x12
	// Bit mask of CLRP018 field.
	GPIO_PORT_CLR_CLRP018_Msk = 0x40000
	// Bit CLRP018.
	GPIO_PORT_CLR_CLRP018 = 0x40000
	// Position of CLRP019 field.
	GPIO_PORT_CLR_CLRP019_Pos = 0x13
	// Bit mask of CLRP019 field.
	GPIO_PORT_CLR_CLRP019_Msk = 0x80000
	// Bit CLRP019.
	GPIO_PORT_CLR_CLRP019 = 0x80000
	// Position of CLRP020 field.
	GPIO_PORT_CLR_CLRP020_Pos = 0x14
	// Bit mask of CLRP020 field.
	GPIO_PORT_CLR_CLRP020_Msk = 0x100000
	// Bit CLRP020.
	GPIO_PORT_CLR_CLRP020 = 0x100000
	// Position of CLRP021 field.
	GPIO_PORT_CLR_CLRP021_Pos = 0x15
	// Bit mask of CLRP021 field.
	GPIO_PORT_CLR_CLRP021_Msk = 0x200000
	// Bit CLRP021.
	GPIO_PORT_CLR_CLRP021 = 0x200000
	// Position of CLRP022 field.
	GPIO_PORT_CLR_CLRP022_Pos = 0x16
	// Bit mask of CLRP022 field.
	GPIO_PORT_CLR_CLRP022_Msk = 0x400000
	// Bit CLRP022.
	GPIO_PORT_CLR_CLRP022 = 0x400000
	// Position of CLRP023 field.
	GPIO_PORT_CLR_CLRP023_Pos = 0x17
	// Bit mask of CLRP023 field.
	GPIO_PORT_CLR_CLRP023_Msk = 0x800000
	// Bit CLRP023.
	GPIO_PORT_CLR_CLRP023 = 0x800000
	// Position of CLRP024 field.
	GPIO_PORT_CLR_CLRP024_Pos = 0x18
	// Bit mask of CLRP024 field.
	GPIO_PORT_CLR_CLRP024_Msk = 0x1000000
	// Bit CLRP024.
	GPIO_PORT_CLR_CLRP024 = 0x1000000
	// Position of CLRP025 field.
	GPIO_PORT_CLR_CLRP025_Pos = 0x19
	// Bit mask of CLRP025 field.
	GPIO_PORT_CLR_CLRP025_Msk = 0x2000000
	// Bit CLRP025.
	GPIO_PORT_CLR_CLRP025 = 0x2000000
	// Position of CLRP026 field.
	GPIO_PORT_CLR_CLRP026_Pos = 0x1a
	// Bit mask of CLRP026 field.
	GPIO_PORT_CLR_CLRP026_Msk = 0x4000000
	// Bit CLRP026.
	GPIO_PORT_CLR_CLRP026 = 0x4000000
	// Position of CLRP027 field.
	GPIO_PORT_CLR_CLRP027_Pos = 0x1b
	// Bit mask of CLRP027 field.
	GPIO_PORT_CLR_CLRP027_Msk = 0x8000000
	// Bit CLRP027.
	GPIO_PORT_CLR_CLRP027 = 0x8000000
	// Position of CLRP028 field.
	GPIO_PORT_CLR_CLRP028_Pos = 0x1c
	// Bit mask of CLRP028 field.
	GPIO_PORT_CLR_CLRP028_Msk = 0x10000000
	// Bit CLRP028.
	GPIO_PORT_CLR_CLRP028 = 0x10000000
	// Position of CLRP029 field.
	GPIO_PORT_CLR_CLRP029_Pos = 0x1d
	// Bit mask of CLRP029 field.
	GPIO_PORT_CLR_CLRP029_Msk = 0x20000000
	// Bit CLRP029.
	GPIO_PORT_CLR_CLRP029 = 0x20000000
	// Position of CLRP030 field.
	GPIO_PORT_CLR_CLRP030_Pos = 0x1e
	// Bit mask of CLRP030 field.
	GPIO_PORT_CLR_CLRP030_Msk = 0x40000000
	// Bit CLRP030.
	GPIO_PORT_CLR_CLRP030 = 0x40000000
	// Position of CLRP031 field.
	GPIO_PORT_CLR_CLRP031_Pos = 0x1f
	// Bit mask of CLRP031 field.
	GPIO_PORT_CLR_CLRP031_Msk = 0x80000000
	// Bit CLRP031.
	GPIO_PORT_CLR_CLRP031 = 0x80000000

	// NOT0: Toggle port 0/1
	// Position of NOTP0 field.
	GPIO_PORT_NOT_NOTP0_Pos = 0x0
	// Bit mask of NOTP0 field.
	GPIO_PORT_NOT_NOTP0_Msk = 0x1
	// Bit NOTP0.
	GPIO_PORT_NOT_NOTP0 = 0x1
	// Position of NOTP1 field.
	GPIO_PORT_NOT_NOTP1_Pos = 0x1
	// Bit mask of NOTP1 field.
	GPIO_PORT_NOT_NOTP1_Msk = 0x2
	// Bit NOTP1.
	GPIO_PORT_NOT_NOTP1 = 0x2
	// Position of NOTP2 field.
	GPIO_PORT_NOT_NOTP2_Pos = 0x2
	// Bit mask of NOTP2 field.
	GPIO_PORT_NOT_NOTP2_Msk = 0x4
	// Bit NOTP2.
	GPIO_PORT_NOT_NOTP2 = 0x4
	// Position of NOTP3 field.
	GPIO_PORT_NOT_NOTP3_Pos = 0x3
	// Bit mask of NOTP3 field.
	GPIO_PORT_NOT_NOTP3_Msk = 0x8
	// Bit NOTP3.
	GPIO_PORT_NOT_NOTP3 = 0x8
	// Position of NOTP4 field.
	GPIO_PORT_NOT_NOTP4_Pos = 0x4
	// Bit mask of NOTP4 field.
	GPIO_PORT_NOT_NOTP4_Msk = 0x10
	// Bit NOTP4.
	GPIO_PORT_NOT_NOTP4 = 0x10
	// Position of NOTP5 field.
	GPIO_PORT_NOT_NOTP5_Pos = 0x5
	// Bit mask of NOTP5 field.
	GPIO_PORT_NOT_NOTP5_Msk = 0x20
	// Bit NOTP5.
	GPIO_PORT_NOT_NOTP5 = 0x20
	// Position of NOTP6 field.
	GPIO_PORT_NOT_NOTP6_Pos = 0x6
	// Bit mask of NOTP6 field.
	GPIO_PORT_NOT_NOTP6_Msk = 0x40
	// Bit NOTP6.
	GPIO_PORT_NOT_NOTP6 = 0x40
	// Position of NOTP7 field.
	GPIO_PORT_NOT_NOTP7_Pos = 0x7
	// Bit mask of NOTP7 field.
	GPIO_PORT_NOT_NOTP7_Msk = 0x80
	// Bit NOTP7.
	GPIO_PORT_NOT_NOTP7 = 0x80
	// Position of NOTP8 field.
	GPIO_PORT_NOT_NOTP8_Pos = 0x8
	// Bit mask of NOTP8 field.
	GPIO_PORT_NOT_NOTP8_Msk = 0x100
	// Bit NOTP8.
	GPIO_PORT_NOT_NOTP8 = 0x100
	// Position of NOTP9 field.
	GPIO_PORT_NOT_NOTP9_Pos = 0x9
	// Bit mask of NOTP9 field.
	GPIO_PORT_NOT_NOTP9_Msk = 0x200
	// Bit NOTP9.
	GPIO_PORT_NOT_NOTP9 = 0x200
	// Position of NOTP10 field.
	GPIO_PORT_NOT_NOTP10_Pos = 0xa
	// Bit mask of NOTP10 field.
	GPIO_PORT_NOT_NOTP10_Msk = 0x400
	// Bit NOTP10.
	GPIO_PORT_NOT_NOTP10 = 0x400
	// Position of NOTP11 field.
	GPIO_PORT_NOT_NOTP11_Pos = 0xb
	// Bit mask of NOTP11 field.
	GPIO_PORT_NOT_NOTP11_Msk = 0x800
	// Bit NOTP11.
	GPIO_PORT_NOT_NOTP11 = 0x800
	// Position of NOTP12 field.
	GPIO_PORT_NOT_NOTP12_Pos = 0xc
	// Bit mask of NOTP12 field.
	GPIO_PORT_NOT_NOTP12_Msk = 0x1000
	// Bit NOTP12.
	GPIO_PORT_NOT_NOTP12 = 0x1000
	// Position of NOTP13 field.
	GPIO_PORT_NOT_NOTP13_Pos = 0xd
	// Bit mask of NOTP13 field.
	GPIO_PORT_NOT_NOTP13_Msk = 0x2000
	// Bit NOTP13.
	GPIO_PORT_NOT_NOTP13 = 0x2000
	// Position of NOTP14 field.
	GPIO_PORT_NOT_NOTP14_Pos = 0xe
	// Bit mask of NOTP14 field.
	GPIO_PORT_NOT_NOTP14_Msk = 0x4000
	// Bit NOTP14.
	GPIO_PORT_NOT_NOTP14 = 0x4000
	// Position of NOTP15 field.
	GPIO_PORT_NOT_NOTP15_Pos = 0xf
	// Bit mask of NOTP15 field.
	GPIO_PORT_NOT_NOTP15_Msk = 0x8000
	// Bit NOTP15.
	GPIO_PORT_NOT_NOTP15 = 0x8000
	// Position of NOTP16 field.
	GPIO_PORT_NOT_NOTP16_Pos = 0x10
	// Bit mask of NOTP16 field.
	GPIO_PORT_NOT_NOTP16_Msk = 0x10000
	// Bit NOTP16.
	GPIO_PORT_NOT_NOTP16 = 0x10000
	// Position of NOTP17 field.
	GPIO_PORT_NOT_NOTP17_Pos = 0x11
	// Bit mask of NOTP17 field.
	GPIO_PORT_NOT_NOTP17_Msk = 0x20000
	// Bit NOTP17.
	GPIO_PORT_NOT_NOTP17 = 0x20000
	// Position of NOTP18 field.
	GPIO_PORT_NOT_NOTP18_Pos = 0x12
	// Bit mask of NOTP18 field.
	GPIO_PORT_NOT_NOTP18_Msk = 0x40000
	// Bit NOTP18.
	GPIO_PORT_NOT_NOTP18 = 0x40000
	// Position of NOTP19 field.
	GPIO_PORT_NOT_NOTP19_Pos = 0x13
	// Bit mask of NOTP19 field.
	GPIO_PORT_NOT_NOTP19_Msk = 0x80000
	// Bit NOTP19.
	GPIO_PORT_NOT_NOTP19 = 0x80000
	// Position of NOTP20 field.
	GPIO_PORT_NOT_NOTP20_Pos = 0x14
	// Bit mask of NOTP20 field.
	GPIO_PORT_NOT_NOTP20_Msk = 0x100000
	// Bit NOTP20.
	GPIO_PORT_NOT_NOTP20 = 0x100000
	// Position of NOTP21 field.
	GPIO_PORT_NOT_NOTP21_Pos = 0x15
	// Bit mask of NOTP21 field.
	GPIO_PORT_NOT_NOTP21_Msk = 0x200000
	// Bit NOTP21.
	GPIO_PORT_NOT_NOTP21 = 0x200000
	// Position of NOTP22 field.
	GPIO_PORT_NOT_NOTP22_Pos = 0x16
	// Bit mask of NOTP22 field.
	GPIO_PORT_NOT_NOTP22_Msk = 0x400000
	// Bit NOTP22.
	GPIO_PORT_NOT_NOTP22 = 0x400000
	// Position of NOTP23 field.
	GPIO_PORT_NOT_NOTP23_Pos = 0x17
	// Bit mask of NOTP23 field.
	GPIO_PORT_NOT_NOTP23_Msk = 0x800000
	// Bit NOTP23.
	GPIO_PORT_NOT_NOTP23 = 0x800000
	// Position of NOTP24 field.
	GPIO_PORT_NOT_NOTP24_Pos = 0x18
	// Bit mask of NOTP24 field.
	GPIO_PORT_NOT_NOTP24_Msk = 0x1000000
	// Bit NOTP24.
	GPIO_PORT_NOT_NOTP24 = 0x1000000
	// Position of NOTP25 field.
	GPIO_PORT_NOT_NOTP25_Pos = 0x19
	// Bit mask of NOTP25 field.
	GPIO_PORT_NOT_NOTP25_Msk = 0x2000000
	// Bit NOTP25.
	GPIO_PORT_NOT_NOTP25 = 0x2000000
	// Position of NOTP26 field.
	GPIO_PORT_NOT_NOTP26_Pos = 0x1a
	// Bit mask of NOTP26 field.
	GPIO_PORT_NOT_NOTP26_Msk = 0x4000000
	// Bit NOTP26.
	GPIO_PORT_NOT_NOTP26 = 0x4000000
	// Position of NOTP27 field.
	GPIO_PORT_NOT_NOTP27_Pos = 0x1b
	// Bit mask of NOTP27 field.
	GPIO_PORT_NOT_NOTP27_Msk = 0x8000000
	// Bit NOTP27.
	GPIO_PORT_NOT_NOTP27 = 0x8000000
	// Position of NOTP28 field.
	GPIO_PORT_NOT_NOTP28_Pos = 0x1c
	// Bit mask of NOTP28 field.
	GPIO_PORT_NOT_NOTP28_Msk = 0x10000000
	// Bit NOTP28.
	GPIO_PORT_NOT_NOTP28 = 0x10000000
	// Position of NOTP29 field.
	GPIO_PORT_NOT_NOTP29_Pos = 0x1d
	// Bit mask of NOTP29 field.
	GPIO_PORT_NOT_NOTP29_Msk = 0x20000000
	// Bit NOTP29.
	GPIO_PORT_NOT_NOTP29 = 0x20000000
	// Position of NOTP30 field.
	GPIO_PORT_NOT_NOTP30_Pos = 0x1e
	// Bit mask of NOTP30 field.
	GPIO_PORT_NOT_NOTP30_Msk = 0x40000000
	// Bit NOTP30.
	GPIO_PORT_NOT_NOTP30 = 0x40000000
	// Position of NOTP31 field.
	GPIO_PORT_NOT_NOTP31_Pos = 0x1f
	// Bit mask of NOTP31 field.
	GPIO_PORT_NOT_NOTP31_Msk = 0x80000000
	// Bit NOTP31.
	GPIO_PORT_NOT_NOTP31 = 0x80000000
)
