// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from AT91SAM9G20.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

// +build sam,at91sam9g20

// Atmel AT91SAM9G20 device: ARM926EJ Embedded Microprocessor Unit, 400MHz, USB, Ethernet, 217 and 247 Pins (refer to http://www.atmel.com/devices/SAM9G20.aspx for more)
//

package sam

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device = "AT91SAM9G20"
)

// Interrupt numbers.
const (
	// Advanced Interrupt Controller
	IRQ_FIQ = 0

	// Debug Unit
	IRQ_DBGU = 1

	// Parallel Input/Output Controller A
	IRQ_PIOA = 2

	// Parallel Input/Output Controller B
	IRQ_PIOB = 3

	// Parallel Input/Output Controller C
	IRQ_PIOC = 4

	// Analog-to-Digital Converter
	IRQ_ADC = 5

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	IRQ_USART0 = 6

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	IRQ_USART1 = 7

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	IRQ_USART2 = 8

	// MultiMedia Card Interface
	IRQ_MCI = 9

	// USB Device Port
	IRQ_UDP = 10

	// Two-wire Interface
	IRQ_TWI = 11

	// Serial Peripheral Interface 0
	IRQ_SPI0 = 12

	// Serial Peripheral Interface 1
	IRQ_SPI1 = 13

	// Synchronous Serial Controller 0
	IRQ_SSC0 = 14

	// Timer Counter 0
	IRQ_TC0 = 17

	// Timer Counter 0
	IRQ_TC1 = 18

	// Timer Counter 0
	IRQ_TC2 = 19

	// USB Host Port
	IRQ_UHP = 20

	// Ethernet MAC 10/100
	IRQ_EMAC = 21

	// Image Sensor Interface
	IRQ_ISI = 22

	// Universal Synchronous Asynchronous Receiver Transmitter 3
	IRQ_USART3 = 23

	// Universal Synchronous Asynchronous Receiver Transmitter 4
	IRQ_USART4 = 24

	// Universal Synchronous Asynchronous Receiver Transmitter 5
	IRQ_USART5 = 25

	// Timer Counter 1
	IRQ_TC3 = 26

	// Timer Counter 1
	IRQ_TC4 = 27

	// Timer Counter 1
	IRQ_TC5 = 28

	// Advanced Interrupt Controller
	IRQ_IRQ0 = 29

	// Advanced Interrupt Controller
	IRQ_IRQ1 = 30

	// Advanced Interrupt Controller
	IRQ_IRQ2 = 31

	// Highest interrupt number on this device.
	IRQ_max = 31
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_FIQ, "FIQ_IRQHandler")
	_ = interrupt.Register(IRQ_DBGU, "DBGU_IRQHandler")
	_ = interrupt.Register(IRQ_PIOA, "PIOA_IRQHandler")
	_ = interrupt.Register(IRQ_PIOB, "PIOB_IRQHandler")
	_ = interrupt.Register(IRQ_PIOC, "PIOC_IRQHandler")
	_ = interrupt.Register(IRQ_ADC, "ADC_IRQHandler")
	_ = interrupt.Register(IRQ_USART0, "USART0_IRQHandler")
	_ = interrupt.Register(IRQ_USART1, "USART1_IRQHandler")
	_ = interrupt.Register(IRQ_USART2, "USART2_IRQHandler")
	_ = interrupt.Register(IRQ_MCI, "MCI_IRQHandler")
	_ = interrupt.Register(IRQ_UDP, "UDP_IRQHandler")
	_ = interrupt.Register(IRQ_TWI, "TWI_IRQHandler")
	_ = interrupt.Register(IRQ_SPI0, "SPI0_IRQHandler")
	_ = interrupt.Register(IRQ_SPI1, "SPI1_IRQHandler")
	_ = interrupt.Register(IRQ_SSC0, "SSC0_IRQHandler")
	_ = interrupt.Register(IRQ_TC0, "TC0_IRQHandler")
	_ = interrupt.Register(IRQ_TC1, "TC1_IRQHandler")
	_ = interrupt.Register(IRQ_TC2, "TC2_IRQHandler")
	_ = interrupt.Register(IRQ_UHP, "UHP_IRQHandler")
	_ = interrupt.Register(IRQ_EMAC, "EMAC_IRQHandler")
	_ = interrupt.Register(IRQ_ISI, "ISI_IRQHandler")
	_ = interrupt.Register(IRQ_USART3, "USART3_IRQHandler")
	_ = interrupt.Register(IRQ_USART4, "USART4_IRQHandler")
	_ = interrupt.Register(IRQ_USART5, "USART5_IRQHandler")
	_ = interrupt.Register(IRQ_TC3, "TC3_IRQHandler")
	_ = interrupt.Register(IRQ_TC4, "TC4_IRQHandler")
	_ = interrupt.Register(IRQ_TC5, "TC5_IRQHandler")
	_ = interrupt.Register(IRQ_IRQ0, "IRQ0_IRQHandler")
	_ = interrupt.Register(IRQ_IRQ1, "IRQ1_IRQHandler")
	_ = interrupt.Register(IRQ_IRQ2, "IRQ2_IRQHandler")
)

// Peripherals.
var (
	// USB Host Port
	UHP = (*UHP_Type)(unsafe.Pointer(uintptr(0x500000)))

	// Timer Counter 0
	TC0 = (*TC_Type)(unsafe.Pointer(uintptr(0xfffa0000)))

	// USB Device Port
	UDP = (*UDP_Type)(unsafe.Pointer(uintptr(0xfffa4000)))

	// MultiMedia Card Interface
	MCI = (*MCI_Type)(unsafe.Pointer(uintptr(0xfffa8000)))

	// Two-wire Interface
	TWI = (*TWI_Type)(unsafe.Pointer(uintptr(0xfffac000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	USART0 = (*USART_Type)(unsafe.Pointer(uintptr(0xfffb0000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0xfffb4000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0xfffb8000)))

	// Synchronous Serial Controller 0
	SSC0 = (*SSC_Type)(unsafe.Pointer(uintptr(0xfffbc000)))

	// Image Sensor Interface
	ISI = (*ISI_Type)(unsafe.Pointer(uintptr(0xfffc0000)))

	// Ethernet MAC 10/100
	EMAC = (*EMAC_Type)(unsafe.Pointer(uintptr(0xfffc4000)))

	// Serial Peripheral Interface 0
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0xfffc8000)))

	// Serial Peripheral Interface 1
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0xfffcc000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 3
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0xfffd0000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 4
	USART4 = (*USART_Type)(unsafe.Pointer(uintptr(0xfffd4000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 5
	USART5 = (*USART_Type)(unsafe.Pointer(uintptr(0xfffd8000)))

	// Timer Counter 1
	TC1 = (*TC_Type)(unsafe.Pointer(uintptr(0xfffdc000)))

	// Analog-to-Digital Converter
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0xfffe0000)))

	// SDRAM Controller
	SDRAMC = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffea00)))

	// Static Memory Controller
	SMC = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffec00)))

	// AHB Bus Matrix
	MATRIX = (*MATRIX_Type)(unsafe.Pointer(uintptr(0xffffee00)))

	// Advanced Interrupt Controller
	AIC = (*AIC_Type)(unsafe.Pointer(uintptr(0xfffff000)))

	// Debug Unit
	DBGU = (*DBGU_Type)(unsafe.Pointer(uintptr(0xfffff200)))

	// Parallel Input/Output Controller A
	PIOA = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff400)))

	// Parallel Input/Output Controller B
	PIOB = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff600)))

	// Parallel Input/Output Controller C
	PIOC = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff800)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0xfffffc00)))

	// Reset Controller
	RSTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd00)))

	// Shutdown Controller
	SHDWC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd10)))

	// Real-time Timer
	RTT = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd20)))

	// Periodic Interval Timer
	PIT = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd30)))

	// Watchdog Timer
	WDT = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd40)))

	// General Purpose Backup Register
	GPBR = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd50)))
)

// USB Host Port
type UHP_Type struct {
}

// Timer Counter 0
type TC_Type struct {
	CCR0 volatile.Register32 // 0x0
	CMR0 volatile.Register32 // 0x4
	_    [8]byte
	CV0  volatile.Register32 // 0x10
	RA0  volatile.Register32 // 0x14
	RB0  volatile.Register32 // 0x18
	RC0  volatile.Register32 // 0x1C
	SR0  volatile.Register32 // 0x20
	IER0 volatile.Register32 // 0x24
	IDR0 volatile.Register32 // 0x28
	IMR0 volatile.Register32 // 0x2C
	_    [16]byte
	CCR1 volatile.Register32 // 0x40
	CMR1 volatile.Register32 // 0x44
	_    [8]byte
	CV1  volatile.Register32 // 0x50
	RA1  volatile.Register32 // 0x54
	RB1  volatile.Register32 // 0x58
	RC1  volatile.Register32 // 0x5C
	SR1  volatile.Register32 // 0x60
	IER1 volatile.Register32 // 0x64
	IDR1 volatile.Register32 // 0x68
	IMR1 volatile.Register32 // 0x6C
	_    [16]byte
	CCR2 volatile.Register32 // 0x80
	CMR2 volatile.Register32 // 0x84
	_    [8]byte
	CV2  volatile.Register32 // 0x90
	RA2  volatile.Register32 // 0x94
	RB2  volatile.Register32 // 0x98
	RC2  volatile.Register32 // 0x9C
	SR2  volatile.Register32 // 0xA0
	IER2 volatile.Register32 // 0xA4
	IDR2 volatile.Register32 // 0xA8
	IMR2 volatile.Register32 // 0xAC
	_    [16]byte
	BCR  volatile.Register32 // 0xC0
	BMR  volatile.Register32 // 0xC4
}

// USB Device Port
type UDP_Type struct {
	FRM_NUM  volatile.Register32 // 0x0
	GLB_STAT volatile.Register32 // 0x4
	FADDR    volatile.Register32 // 0x8
	_        [4]byte
	IER      volatile.Register32 // 0x10
	IDR      volatile.Register32 // 0x14
	IMR      volatile.Register32 // 0x18
	ISR      volatile.Register32 // 0x1C
	ICR      volatile.Register32 // 0x20
	_        [4]byte
	RST_EP   volatile.Register32 // 0x28
	_        [4]byte
	CSR      [6]volatile.Register32 // 0x30
	_        [8]byte
	FDR      [6]volatile.Register32 // 0x50
	_        [12]byte
	TXVC     volatile.Register32 // 0x74
}

// MultiMedia Card Interface
type MCI_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	DTOR volatile.Register32 // 0x8
	SDCR volatile.Register32 // 0xC
	ARGR volatile.Register32 // 0x10
	CMDR volatile.Register32 // 0x14
	BLKR volatile.Register32 // 0x18
	_    [4]byte
	RSPR [4]volatile.Register32 // 0x20
	RDR  volatile.Register32    // 0x30
	TDR  volatile.Register32    // 0x34
	_    [8]byte
	SR   volatile.Register32 // 0x40
	IER  volatile.Register32 // 0x44
	IDR  volatile.Register32 // 0x48
	IMR  volatile.Register32 // 0x4C
	_    [176]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Two-wire Interface
type TWI_Type struct {
	CR   volatile.Register32 // 0x0
	MMR  volatile.Register32 // 0x4
	SMR  volatile.Register32 // 0x8
	IADR volatile.Register32 // 0xC
	CWGR volatile.Register32 // 0x10
	_    [12]byte
	SR   volatile.Register32 // 0x20
	IER  volatile.Register32 // 0x24
	IDR  volatile.Register32 // 0x28
	IMR  volatile.Register32 // 0x2C
	RHR  volatile.Register32 // 0x30
	THR  volatile.Register32 // 0x34
	_    [200]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Universal Synchronous Asynchronous Receiver Transmitter 0
type USART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	CSR  volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	RTOR volatile.Register32 // 0x24
	TTGR volatile.Register32 // 0x28
	_    [20]byte
	FIDI volatile.Register32 // 0x40
	NER  volatile.Register32 // 0x44
	_    [4]byte
	IF   volatile.Register32 // 0x4C
	MAN  volatile.Register32 // 0x50
	_    [172]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Synchronous Serial Controller 0
type SSC_Type struct {
	CR   volatile.Register32 // 0x0
	CMR  volatile.Register32 // 0x4
	_    [8]byte
	RCMR volatile.Register32 // 0x10
	RFMR volatile.Register32 // 0x14
	TCMR volatile.Register32 // 0x18
	TFMR volatile.Register32 // 0x1C
	RHR  volatile.Register32 // 0x20
	THR  volatile.Register32 // 0x24
	_    [8]byte
	RSHR volatile.Register32 // 0x30
	TSHR volatile.Register32 // 0x34
	RC0R volatile.Register32 // 0x38
	RC1R volatile.Register32 // 0x3C
	SR   volatile.Register32 // 0x40
	IER  volatile.Register32 // 0x44
	IDR  volatile.Register32 // 0x48
	IMR  volatile.Register32 // 0x4C
	_    [176]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Image Sensor Interface
type ISI_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	SR       volatile.Register32 // 0x8
	IER      volatile.Register32 // 0xC
	IDR      volatile.Register32 // 0x10
	IMR      volatile.Register32 // 0x14
	_        [8]byte
	PSIZE    volatile.Register32 // 0x20
	PDECF    volatile.Register32 // 0x24
	PPFBD    volatile.Register32 // 0x28
	CDBA     volatile.Register32 // 0x2C
	Y2R_SET0 volatile.Register32 // 0x30
	Y2R_SET1 volatile.Register32 // 0x34
	R2Y_SET0 volatile.Register32 // 0x38
	R2Y_SET1 volatile.Register32 // 0x3C
	R2Y_SET2 volatile.Register32 // 0x40
}

// Ethernet MAC 10/100
type EMAC_Type struct {
	NCR   volatile.Register32 // 0x0
	NCFGR volatile.Register32 // 0x4
	NSR   volatile.Register32 // 0x8
	_     [8]byte
	TSR   volatile.Register32 // 0x14
	RBQP  volatile.Register32 // 0x18
	TBQP  volatile.Register32 // 0x1C
	RSR   volatile.Register32 // 0x20
	ISR   volatile.Register32 // 0x24
	IER   volatile.Register32 // 0x28
	IDR   volatile.Register32 // 0x2C
	IMR   volatile.Register32 // 0x30
	MAN   volatile.Register32 // 0x34
	PTR   volatile.Register32 // 0x38
	PFR   volatile.Register32 // 0x3C
	FTO   volatile.Register32 // 0x40
	SCF   volatile.Register32 // 0x44
	MCF   volatile.Register32 // 0x48
	FRO   volatile.Register32 // 0x4C
	FCSE  volatile.Register32 // 0x50
	ALE   volatile.Register32 // 0x54
	DTF   volatile.Register32 // 0x58
	LCOL  volatile.Register32 // 0x5C
	ECOL  volatile.Register32 // 0x60
	TUND  volatile.Register32 // 0x64
	CSE   volatile.Register32 // 0x68
	RRE   volatile.Register32 // 0x6C
	ROV   volatile.Register32 // 0x70
	RSE   volatile.Register32 // 0x74
	ELE   volatile.Register32 // 0x78
	RJA   volatile.Register32 // 0x7C
	USF   volatile.Register32 // 0x80
	STE   volatile.Register32 // 0x84
	RLE   volatile.Register32 // 0x88
	_     [4]byte
	HRB   volatile.Register32 // 0x90
	HRT   volatile.Register32 // 0x94
	SA1B  volatile.Register32 // 0x98
	SA1T  volatile.Register32 // 0x9C
	SA2B  volatile.Register32 // 0xA0
	SA2T  volatile.Register32 // 0xA4
	SA3B  volatile.Register32 // 0xA8
	SA3T  volatile.Register32 // 0xAC
	SA4B  volatile.Register32 // 0xB0
	SA4T  volatile.Register32 // 0xB4
	TID   volatile.Register32 // 0xB8
	_     [4]byte
	USRIO volatile.Register32 // 0xC0
}

// Serial Peripheral Interface 0
type SPI_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	RDR  volatile.Register32 // 0x8
	TDR  volatile.Register32 // 0xC
	SR   volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	IDR  volatile.Register32 // 0x18
	IMR  volatile.Register32 // 0x1C
	_    [16]byte
	CSR  [4]volatile.Register32 // 0x30
	_    [164]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
	_    [20]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Analog-to-Digital Converter
type ADC_Type struct {
	CR    volatile.Register32 // 0x0
	MR    volatile.Register32 // 0x4
	SEQR1 volatile.Register32 // 0x8
	SEQR2 volatile.Register32 // 0xC
	CHER  volatile.Register32 // 0x10
	CHDR  volatile.Register32 // 0x14
	CHSR  volatile.Register32 // 0x18
	_     [4]byte
	LCDR  volatile.Register32 // 0x20
	IER   volatile.Register32 // 0x24
	IDR   volatile.Register32 // 0x28
	IMR   volatile.Register32 // 0x2C
	ISR   volatile.Register32 // 0x30
	_     [8]byte
	OVER  volatile.Register32 // 0x3C
	EMR   volatile.Register32 // 0x40
	CWR   volatile.Register32 // 0x44
	_     [8]byte
	CDR   [4]volatile.Register32 // 0x50
	_     [132]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
	_     [20]byte
	RPR   volatile.Register32 // 0x100
	RCR   volatile.Register32 // 0x104
	_     [8]byte
	RNPR  volatile.Register32 // 0x110
	RNCR  volatile.Register32 // 0x114
	_     [8]byte
	PTCR  volatile.Register32 // 0x120
	PTSR  volatile.Register32 // 0x124
}

// SDRAM Controller
type EBI_Type struct {
	MR  volatile.Register32 // 0x0
	TR  volatile.Register32 // 0x4
	CR  volatile.Register32 // 0x8
	_   [4]byte
	LPR volatile.Register32 // 0x10
	IER volatile.Register32 // 0x14
	IDR volatile.Register32 // 0x18
	IMR volatile.Register32 // 0x1C
	ISR volatile.Register32 // 0x20
	MDR volatile.Register32 // 0x24
}

// AHB Bus Matrix
type MATRIX_Type struct {
	MATRIX_MCFG  [6]volatile.Register32 // 0x0
	_            [40]byte
	MATRIX_SCFG  [5]volatile.Register32 // 0x40
	_            [44]byte
	MATRIX_PRAS0 volatile.Register32 // 0x80
	_            [4]byte
	MATRIX_PRAS1 volatile.Register32 // 0x88
	_            [4]byte
	MATRIX_PRAS2 volatile.Register32 // 0x90
	_            [4]byte
	MATRIX_PRAS3 volatile.Register32 // 0x98
	_            [4]byte
	MATRIX_PRAS4 volatile.Register32 // 0xA0
	_            [92]byte
	MATRIX_MRCR  volatile.Register32 // 0x100
	_            [24]byte
	EBI_CSA      volatile.Register32 // 0x11C
}

// Advanced Interrupt Controller
type AIC_Type struct {
	SMR   [32]volatile.Register32 // 0x0
	SVR   [32]volatile.Register32 // 0x80
	IVR   volatile.Register32     // 0x100
	FVR   volatile.Register32     // 0x104
	ISR   volatile.Register32     // 0x108
	IPR   volatile.Register32     // 0x10C
	IMR   volatile.Register32     // 0x110
	CISR  volatile.Register32     // 0x114
	_     [8]byte
	IECR  volatile.Register32 // 0x120
	IDCR  volatile.Register32 // 0x124
	ICCR  volatile.Register32 // 0x128
	ISCR  volatile.Register32 // 0x12C
	EOICR volatile.Register32 // 0x130
	SPU   volatile.Register32 // 0x134
	DCR   volatile.Register32 // 0x138
	_     [4]byte
	FFER  volatile.Register32 // 0x140
	FFDR  volatile.Register32 // 0x144
	FFSR  volatile.Register32 // 0x148
}

// Debug Unit
type DBGU_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	_    [28]byte
	CIDR volatile.Register32 // 0x40
	EXID volatile.Register32 // 0x44
	FNR  volatile.Register32 // 0x48
	_    [180]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Parallel Input/Output Controller A
type PIO_Type struct {
	PER  volatile.Register32 // 0x0
	PDR  volatile.Register32 // 0x4
	PSR  volatile.Register32 // 0x8
	_    [4]byte
	OER  volatile.Register32 // 0x10
	ODR  volatile.Register32 // 0x14
	OSR  volatile.Register32 // 0x18
	_    [4]byte
	IFER volatile.Register32 // 0x20
	IFDR volatile.Register32 // 0x24
	IFSR volatile.Register32 // 0x28
	_    [4]byte
	SODR volatile.Register32 // 0x30
	CODR volatile.Register32 // 0x34
	ODSR volatile.Register32 // 0x38
	PDSR volatile.Register32 // 0x3C
	IER  volatile.Register32 // 0x40
	IDR  volatile.Register32 // 0x44
	IMR  volatile.Register32 // 0x48
	ISR  volatile.Register32 // 0x4C
	MDER volatile.Register32 // 0x50
	MDDR volatile.Register32 // 0x54
	MDSR volatile.Register32 // 0x58
	_    [4]byte
	PUDR volatile.Register32 // 0x60
	PUER volatile.Register32 // 0x64
	PUSR volatile.Register32 // 0x68
	_    [4]byte
	ASR  volatile.Register32 // 0x70
	BSR  volatile.Register32 // 0x74
	ABSR volatile.Register32 // 0x78
	_    [36]byte
	OWER volatile.Register32 // 0xA0
	OWDR volatile.Register32 // 0xA4
	OWSR volatile.Register32 // 0xA8
}

// Power Management Controller
type PMC_Type struct {
	PMC_SCER    volatile.Register32 // 0x0
	PMC_SCDR    volatile.Register32 // 0x4
	PMC_SCSR    volatile.Register32 // 0x8
	_           [4]byte
	PMC_PCER    volatile.Register32 // 0x10
	PMC_PCDR    volatile.Register32 // 0x14
	PMC_PCSR    volatile.Register32 // 0x18
	_           [4]byte
	CKGR_MOR    volatile.Register32 // 0x20
	CKGR_MCFR   volatile.Register32 // 0x24
	CKGR_PLLAR  volatile.Register32 // 0x28
	CKGR_PLLBR  volatile.Register32 // 0x2C
	PMC_MCKR    volatile.Register32 // 0x30
	_           [12]byte
	PMC_PCK     [2]volatile.Register32 // 0x40
	_           [24]byte
	PMC_IER     volatile.Register32 // 0x60
	PMC_IDR     volatile.Register32 // 0x64
	PMC_SR      volatile.Register32 // 0x68
	PMC_IMR     volatile.Register32 // 0x6C
	_           [16]byte
	PMC_PLLICPR volatile.Register32 // 0x80
}

// Reset Controller
type SYSC_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	MR volatile.Register32 // 0x8
}

// Bitfields for UHP: USB Host Port
const ()

// Bitfields for TC0: Timer Counter 0
const (
	// CCR0: Channel Control Register (channel = 0)
	// Position of CLKEN field.
	TC_CCR0_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR0_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR0_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR0_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR0_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR0_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR0_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR0_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR0_SWTRG = 0x4

	// CMR0: Channel Mode Register (channel = 0)
	// Position of TCCLKS field.
	TC_CMR0_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR0_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR0_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR0_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR0_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR0_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR0_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR0_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR0_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR0_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR0_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR0_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR0_CLKI = 0x8
	// Position of BURST field.
	TC_CMR0_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR0_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR0_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR0_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR0_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR0_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR0_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR0_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR0_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR0_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR0_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR0_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR0_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR0_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR0_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR0_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR0_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR0_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR0_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR0_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR0_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR0_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR0_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR0_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR0_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR0_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR0_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR0_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR0_LDRA_Msk = 0x30000
	// None
	TC_CMR0_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR0_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR0_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR0_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR0_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR0_LDRB_Msk = 0xc0000
	// None
	TC_CMR0_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR0_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR0_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR0_LDRB_EDGE = 0x3

	// CMR0_WAVE_EQ_1: Channel Mode Register (channel = 0)
	// Position of TCCLKS field.
	TC_CMR0_WAVE_EQ_1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR0_WAVE_EQ_1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR0_WAVE_EQ_1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR0_WAVE_EQ_1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR0_WAVE_EQ_1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR0_WAVE_EQ_1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR0_WAVE_EQ_1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR0_WAVE_EQ_1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR0_WAVE_EQ_1_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR0_WAVE_EQ_1_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR0_WAVE_EQ_1_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR0_WAVE_EQ_1_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR0_WAVE_EQ_1_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR0_WAVE_EQ_1_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR0_WAVE_EQ_1_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR0_WAVE_EQ_1_EEVTEDG_Msk = 0x300
	// None
	TC_CMR0_WAVE_EQ_1_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR0_WAVE_EQ_1_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR0_WAVE_EQ_1_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR0_WAVE_EQ_1_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR0_WAVE_EQ_1_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR0_WAVE_EQ_1_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR0_WAVE_EQ_1_EEVT_TIOB = 0x0
	// XC0
	TC_CMR0_WAVE_EQ_1_EEVT_XC0 = 0x1
	// XC1
	TC_CMR0_WAVE_EQ_1_EEVT_XC1 = 0x2
	// XC2
	TC_CMR0_WAVE_EQ_1_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR0_WAVE_EQ_1_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR0_WAVE_EQ_1_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR0_WAVE_EQ_1_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR0_WAVE_EQ_1_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR0_WAVE_EQ_1_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR0_WAVE_EQ_1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR0_WAVE_EQ_1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR0_WAVE_EQ_1_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR0_WAVE_EQ_1_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR0_WAVE_EQ_1_ACPA_Msk = 0x30000
	// None
	TC_CMR0_WAVE_EQ_1_ACPA_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_ACPA_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR0_WAVE_EQ_1_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR0_WAVE_EQ_1_ACPC_Msk = 0xc0000
	// None
	TC_CMR0_WAVE_EQ_1_ACPC_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_ACPC_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR0_WAVE_EQ_1_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR0_WAVE_EQ_1_AEEVT_Msk = 0x300000
	// None
	TC_CMR0_WAVE_EQ_1_AEEVT_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_AEEVT_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR0_WAVE_EQ_1_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR0_WAVE_EQ_1_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR0_WAVE_EQ_1_ASWTRG_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_ASWTRG_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR0_WAVE_EQ_1_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR0_WAVE_EQ_1_BCPB_Msk = 0x3000000
	// None
	TC_CMR0_WAVE_EQ_1_BCPB_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BCPB_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR0_WAVE_EQ_1_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR0_WAVE_EQ_1_BCPC_Msk = 0xc000000
	// None
	TC_CMR0_WAVE_EQ_1_BCPC_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BCPC_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR0_WAVE_EQ_1_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR0_WAVE_EQ_1_BEEVT_Msk = 0x30000000
	// None
	TC_CMR0_WAVE_EQ_1_BEEVT_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BEEVT_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR0_WAVE_EQ_1_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR0_WAVE_EQ_1_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR0_WAVE_EQ_1_BSWTRG_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BSWTRG_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BSWTRG_TOGGLE = 0x3

	// CV0: Counter Value (channel = 0)
	// Position of CV field.
	TC_CV0_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV0_CV_Msk = 0xffff

	// RA0: Register A (channel = 0)
	// Position of RA field.
	TC_RA0_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA0_RA_Msk = 0xffff

	// RB0: Register B (channel = 0)
	// Position of RB field.
	TC_RB0_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB0_RB_Msk = 0xffff

	// RC0: Register C (channel = 0)
	// Position of RC field.
	TC_RC0_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC0_RC_Msk = 0xffff

	// SR0: Status Register (channel = 0)
	// Position of COVFS field.
	TC_SR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR0_CPAS = 0x4
	// Position of CPBS field.
	TC_SR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR0_CPBS = 0x8
	// Position of CPCS field.
	TC_SR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR0_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR0_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR0_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR0_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR0_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR0_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR0_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR0_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR0_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR0_MTIOB = 0x40000

	// IER0: Interrupt Enable Register (channel = 0)
	// Position of COVFS field.
	TC_IER0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER0_CPAS = 0x4
	// Position of CPBS field.
	TC_IER0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER0_CPBS = 0x8
	// Position of CPCS field.
	TC_IER0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER0_ETRGS = 0x80

	// IDR0: Interrupt Disable Register (channel = 0)
	// Position of COVFS field.
	TC_IDR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR0_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR0_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR0_ETRGS = 0x80

	// IMR0: Interrupt Mask Register (channel = 0)
	// Position of COVFS field.
	TC_IMR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR0_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR0_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR0_ETRGS = 0x80

	// CCR1: Channel Control Register (channel = 1)
	// Position of CLKEN field.
	TC_CCR1_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR1_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR1_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR1_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR1_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR1_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR1_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR1_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR1_SWTRG = 0x4

	// CMR1: Channel Mode Register (channel = 1)
	// Position of TCCLKS field.
	TC_CMR1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR1_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR1_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR1_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR1_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR1_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR1_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR1_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR1_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR1_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR1_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR1_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR1_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR1_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR1_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR1_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR1_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR1_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR1_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR1_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR1_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR1_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR1_LDRA_Msk = 0x30000
	// None
	TC_CMR1_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR1_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR1_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR1_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR1_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR1_LDRB_Msk = 0xc0000
	// None
	TC_CMR1_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR1_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR1_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR1_LDRB_EDGE = 0x3

	// CMR1_WAVE_EQ_1: Channel Mode Register (channel = 1)
	// Position of TCCLKS field.
	TC_CMR1_WAVE_EQ_1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR1_WAVE_EQ_1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR1_WAVE_EQ_1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR1_WAVE_EQ_1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR1_WAVE_EQ_1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR1_WAVE_EQ_1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR1_WAVE_EQ_1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR1_WAVE_EQ_1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR1_WAVE_EQ_1_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR1_WAVE_EQ_1_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR1_WAVE_EQ_1_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR1_WAVE_EQ_1_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR1_WAVE_EQ_1_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR1_WAVE_EQ_1_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR1_WAVE_EQ_1_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR1_WAVE_EQ_1_EEVTEDG_Msk = 0x300
	// None
	TC_CMR1_WAVE_EQ_1_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR1_WAVE_EQ_1_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR1_WAVE_EQ_1_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR1_WAVE_EQ_1_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR1_WAVE_EQ_1_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR1_WAVE_EQ_1_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR1_WAVE_EQ_1_EEVT_TIOB = 0x0
	// XC0
	TC_CMR1_WAVE_EQ_1_EEVT_XC0 = 0x1
	// XC1
	TC_CMR1_WAVE_EQ_1_EEVT_XC1 = 0x2
	// XC2
	TC_CMR1_WAVE_EQ_1_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR1_WAVE_EQ_1_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR1_WAVE_EQ_1_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR1_WAVE_EQ_1_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR1_WAVE_EQ_1_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR1_WAVE_EQ_1_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR1_WAVE_EQ_1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR1_WAVE_EQ_1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR1_WAVE_EQ_1_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR1_WAVE_EQ_1_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR1_WAVE_EQ_1_ACPA_Msk = 0x30000
	// None
	TC_CMR1_WAVE_EQ_1_ACPA_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_ACPA_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR1_WAVE_EQ_1_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR1_WAVE_EQ_1_ACPC_Msk = 0xc0000
	// None
	TC_CMR1_WAVE_EQ_1_ACPC_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_ACPC_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR1_WAVE_EQ_1_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR1_WAVE_EQ_1_AEEVT_Msk = 0x300000
	// None
	TC_CMR1_WAVE_EQ_1_AEEVT_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_AEEVT_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR1_WAVE_EQ_1_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR1_WAVE_EQ_1_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR1_WAVE_EQ_1_ASWTRG_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_ASWTRG_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR1_WAVE_EQ_1_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR1_WAVE_EQ_1_BCPB_Msk = 0x3000000
	// None
	TC_CMR1_WAVE_EQ_1_BCPB_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BCPB_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR1_WAVE_EQ_1_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR1_WAVE_EQ_1_BCPC_Msk = 0xc000000
	// None
	TC_CMR1_WAVE_EQ_1_BCPC_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BCPC_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR1_WAVE_EQ_1_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR1_WAVE_EQ_1_BEEVT_Msk = 0x30000000
	// None
	TC_CMR1_WAVE_EQ_1_BEEVT_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BEEVT_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR1_WAVE_EQ_1_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR1_WAVE_EQ_1_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR1_WAVE_EQ_1_BSWTRG_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BSWTRG_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BSWTRG_TOGGLE = 0x3

	// CV1: Counter Value (channel = 1)
	// Position of CV field.
	TC_CV1_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV1_CV_Msk = 0xffff

	// RA1: Register A (channel = 1)
	// Position of RA field.
	TC_RA1_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA1_RA_Msk = 0xffff

	// RB1: Register B (channel = 1)
	// Position of RB field.
	TC_RB1_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB1_RB_Msk = 0xffff

	// RC1: Register C (channel = 1)
	// Position of RC field.
	TC_RC1_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC1_RC_Msk = 0xffff

	// SR1: Status Register (channel = 1)
	// Position of COVFS field.
	TC_SR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR1_CPAS = 0x4
	// Position of CPBS field.
	TC_SR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR1_CPBS = 0x8
	// Position of CPCS field.
	TC_SR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR1_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR1_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR1_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR1_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR1_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR1_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR1_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR1_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR1_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR1_MTIOB = 0x40000

	// IER1: Interrupt Enable Register (channel = 1)
	// Position of COVFS field.
	TC_IER1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER1_CPAS = 0x4
	// Position of CPBS field.
	TC_IER1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER1_CPBS = 0x8
	// Position of CPCS field.
	TC_IER1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER1_ETRGS = 0x80

	// IDR1: Interrupt Disable Register (channel = 1)
	// Position of COVFS field.
	TC_IDR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR1_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR1_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR1_ETRGS = 0x80

	// IMR1: Interrupt Mask Register (channel = 1)
	// Position of COVFS field.
	TC_IMR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR1_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR1_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR1_ETRGS = 0x80

	// CCR2: Channel Control Register (channel = 2)
	// Position of CLKEN field.
	TC_CCR2_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR2_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR2_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR2_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR2_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR2_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR2_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR2_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR2_SWTRG = 0x4

	// CMR2: Channel Mode Register (channel = 2)
	// Position of TCCLKS field.
	TC_CMR2_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR2_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR2_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR2_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR2_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR2_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR2_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR2_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR2_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR2_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR2_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR2_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR2_CLKI = 0x8
	// Position of BURST field.
	TC_CMR2_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR2_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR2_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR2_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR2_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR2_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR2_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR2_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR2_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR2_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR2_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR2_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR2_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR2_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR2_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR2_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR2_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR2_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR2_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR2_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR2_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR2_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR2_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR2_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR2_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR2_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR2_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR2_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR2_LDRA_Msk = 0x30000
	// None
	TC_CMR2_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR2_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR2_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR2_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR2_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR2_LDRB_Msk = 0xc0000
	// None
	TC_CMR2_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR2_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR2_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR2_LDRB_EDGE = 0x3

	// CMR2_WAVE_EQ_1: Channel Mode Register (channel = 2)
	// Position of TCCLKS field.
	TC_CMR2_WAVE_EQ_1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR2_WAVE_EQ_1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR2_WAVE_EQ_1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR2_WAVE_EQ_1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR2_WAVE_EQ_1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR2_WAVE_EQ_1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR2_WAVE_EQ_1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR2_WAVE_EQ_1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR2_WAVE_EQ_1_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR2_WAVE_EQ_1_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR2_WAVE_EQ_1_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR2_WAVE_EQ_1_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR2_WAVE_EQ_1_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR2_WAVE_EQ_1_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR2_WAVE_EQ_1_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR2_WAVE_EQ_1_EEVTEDG_Msk = 0x300
	// None
	TC_CMR2_WAVE_EQ_1_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR2_WAVE_EQ_1_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR2_WAVE_EQ_1_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR2_WAVE_EQ_1_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR2_WAVE_EQ_1_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR2_WAVE_EQ_1_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR2_WAVE_EQ_1_EEVT_TIOB = 0x0
	// XC0
	TC_CMR2_WAVE_EQ_1_EEVT_XC0 = 0x1
	// XC1
	TC_CMR2_WAVE_EQ_1_EEVT_XC1 = 0x2
	// XC2
	TC_CMR2_WAVE_EQ_1_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR2_WAVE_EQ_1_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR2_WAVE_EQ_1_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR2_WAVE_EQ_1_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR2_WAVE_EQ_1_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR2_WAVE_EQ_1_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR2_WAVE_EQ_1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR2_WAVE_EQ_1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR2_WAVE_EQ_1_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR2_WAVE_EQ_1_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR2_WAVE_EQ_1_ACPA_Msk = 0x30000
	// None
	TC_CMR2_WAVE_EQ_1_ACPA_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_ACPA_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR2_WAVE_EQ_1_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR2_WAVE_EQ_1_ACPC_Msk = 0xc0000
	// None
	TC_CMR2_WAVE_EQ_1_ACPC_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_ACPC_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR2_WAVE_EQ_1_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR2_WAVE_EQ_1_AEEVT_Msk = 0x300000
	// None
	TC_CMR2_WAVE_EQ_1_AEEVT_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_AEEVT_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR2_WAVE_EQ_1_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR2_WAVE_EQ_1_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR2_WAVE_EQ_1_ASWTRG_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_ASWTRG_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR2_WAVE_EQ_1_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR2_WAVE_EQ_1_BCPB_Msk = 0x3000000
	// None
	TC_CMR2_WAVE_EQ_1_BCPB_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BCPB_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR2_WAVE_EQ_1_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR2_WAVE_EQ_1_BCPC_Msk = 0xc000000
	// None
	TC_CMR2_WAVE_EQ_1_BCPC_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BCPC_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR2_WAVE_EQ_1_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR2_WAVE_EQ_1_BEEVT_Msk = 0x30000000
	// None
	TC_CMR2_WAVE_EQ_1_BEEVT_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BEEVT_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR2_WAVE_EQ_1_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR2_WAVE_EQ_1_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR2_WAVE_EQ_1_BSWTRG_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BSWTRG_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BSWTRG_TOGGLE = 0x3

	// CV2: Counter Value (channel = 2)
	// Position of CV field.
	TC_CV2_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV2_CV_Msk = 0xffff

	// RA2: Register A (channel = 2)
	// Position of RA field.
	TC_RA2_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA2_RA_Msk = 0xffff

	// RB2: Register B (channel = 2)
	// Position of RB field.
	TC_RB2_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB2_RB_Msk = 0xffff

	// RC2: Register C (channel = 2)
	// Position of RC field.
	TC_RC2_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC2_RC_Msk = 0xffff

	// SR2: Status Register (channel = 2)
	// Position of COVFS field.
	TC_SR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR2_CPAS = 0x4
	// Position of CPBS field.
	TC_SR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR2_CPBS = 0x8
	// Position of CPCS field.
	TC_SR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR2_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR2_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR2_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR2_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR2_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR2_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR2_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR2_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR2_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR2_MTIOB = 0x40000

	// IER2: Interrupt Enable Register (channel = 2)
	// Position of COVFS field.
	TC_IER2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER2_CPAS = 0x4
	// Position of CPBS field.
	TC_IER2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER2_CPBS = 0x8
	// Position of CPCS field.
	TC_IER2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER2_ETRGS = 0x80

	// IDR2: Interrupt Disable Register (channel = 2)
	// Position of COVFS field.
	TC_IDR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR2_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR2_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR2_ETRGS = 0x80

	// IMR2: Interrupt Mask Register (channel = 2)
	// Position of COVFS field.
	TC_IMR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR2_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR2_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR2_ETRGS = 0x80

	// BCR: Block Control Register
	// Position of SYNC field.
	TC_BCR_SYNC_Pos = 0x0
	// Bit mask of SYNC field.
	TC_BCR_SYNC_Msk = 0x1
	// Bit SYNC.
	TC_BCR_SYNC = 0x1

	// BMR: Block Mode Register
	// Position of TC0XC0S field.
	TC_BMR_TC0XC0S_Pos = 0x0
	// Bit mask of TC0XC0S field.
	TC_BMR_TC0XC0S_Msk = 0x3
	// Signal connected to XC0: TCLK0
	TC_BMR_TC0XC0S_TCLK0 = 0x0
	// Signal connected to XC0: TIOA1
	TC_BMR_TC0XC0S_TIOA1 = 0x2
	// Signal connected to XC0: TIOA2
	TC_BMR_TC0XC0S_TIOA2 = 0x3
	// Position of TC1XC1S field.
	TC_BMR_TC1XC1S_Pos = 0x2
	// Bit mask of TC1XC1S field.
	TC_BMR_TC1XC1S_Msk = 0xc
	// Signal connected to XC1: TCLK1
	TC_BMR_TC1XC1S_TCLK1 = 0x0
	// Signal connected to XC1: TIOA0
	TC_BMR_TC1XC1S_TIOA0 = 0x2
	// Signal connected to XC1: TIOA2
	TC_BMR_TC1XC1S_TIOA2 = 0x3
	// Position of TC2XC2S field.
	TC_BMR_TC2XC2S_Pos = 0x4
	// Bit mask of TC2XC2S field.
	TC_BMR_TC2XC2S_Msk = 0x30
	// Signal connected to XC2: TCLK2
	TC_BMR_TC2XC2S_TCLK2 = 0x0
	// Signal connected to XC2: TIOA1
	TC_BMR_TC2XC2S_TIOA1 = 0x2
	// Signal connected to XC2: TIOA2
	TC_BMR_TC2XC2S_TIOA2 = 0x3
)

// Bitfields for UDP: USB Device Port
const (
	// FRM_NUM: Frame Number Register
	// Position of FRM_NUM field.
	UDP_FRM_NUM_FRM_NUM_Pos = 0x0
	// Bit mask of FRM_NUM field.
	UDP_FRM_NUM_FRM_NUM_Msk = 0x7ff
	// Position of FRM_ERR field.
	UDP_FRM_NUM_FRM_ERR_Pos = 0x10
	// Bit mask of FRM_ERR field.
	UDP_FRM_NUM_FRM_ERR_Msk = 0x10000
	// Bit FRM_ERR.
	UDP_FRM_NUM_FRM_ERR = 0x10000
	// Position of FRM_OK field.
	UDP_FRM_NUM_FRM_OK_Pos = 0x11
	// Bit mask of FRM_OK field.
	UDP_FRM_NUM_FRM_OK_Msk = 0x20000
	// Bit FRM_OK.
	UDP_FRM_NUM_FRM_OK = 0x20000

	// GLB_STAT: Global State Register
	// Position of FADDEN field.
	UDP_GLB_STAT_FADDEN_Pos = 0x0
	// Bit mask of FADDEN field.
	UDP_GLB_STAT_FADDEN_Msk = 0x1
	// Bit FADDEN.
	UDP_GLB_STAT_FADDEN = 0x1
	// Position of CONFG field.
	UDP_GLB_STAT_CONFG_Pos = 0x1
	// Bit mask of CONFG field.
	UDP_GLB_STAT_CONFG_Msk = 0x2
	// Bit CONFG.
	UDP_GLB_STAT_CONFG = 0x2

	// FADDR: Function Address Register
	// Position of FADD field.
	UDP_FADDR_FADD_Pos = 0x0
	// Bit mask of FADD field.
	UDP_FADDR_FADD_Msk = 0x7f
	// Position of FEN field.
	UDP_FADDR_FEN_Pos = 0x8
	// Bit mask of FEN field.
	UDP_FADDR_FEN_Msk = 0x100
	// Bit FEN.
	UDP_FADDR_FEN = 0x100

	// IER: Interrupt Enable Register
	// Position of EP0INT field.
	UDP_IER_EP0INT_Pos = 0x0
	// Bit mask of EP0INT field.
	UDP_IER_EP0INT_Msk = 0x1
	// Bit EP0INT.
	UDP_IER_EP0INT = 0x1
	// Position of EP1INT field.
	UDP_IER_EP1INT_Pos = 0x1
	// Bit mask of EP1INT field.
	UDP_IER_EP1INT_Msk = 0x2
	// Bit EP1INT.
	UDP_IER_EP1INT = 0x2
	// Position of EP2INT field.
	UDP_IER_EP2INT_Pos = 0x2
	// Bit mask of EP2INT field.
	UDP_IER_EP2INT_Msk = 0x4
	// Bit EP2INT.
	UDP_IER_EP2INT = 0x4
	// Position of EP3INT field.
	UDP_IER_EP3INT_Pos = 0x3
	// Bit mask of EP3INT field.
	UDP_IER_EP3INT_Msk = 0x8
	// Bit EP3INT.
	UDP_IER_EP3INT = 0x8
	// Position of EP4INT field.
	UDP_IER_EP4INT_Pos = 0x4
	// Bit mask of EP4INT field.
	UDP_IER_EP4INT_Msk = 0x10
	// Bit EP4INT.
	UDP_IER_EP4INT = 0x10
	// Position of EP5INT field.
	UDP_IER_EP5INT_Pos = 0x5
	// Bit mask of EP5INT field.
	UDP_IER_EP5INT_Msk = 0x20
	// Bit EP5INT.
	UDP_IER_EP5INT = 0x20
	// Position of RXSUSP field.
	UDP_IER_RXSUSP_Pos = 0x8
	// Bit mask of RXSUSP field.
	UDP_IER_RXSUSP_Msk = 0x100
	// Bit RXSUSP.
	UDP_IER_RXSUSP = 0x100
	// Position of RXRSM field.
	UDP_IER_RXRSM_Pos = 0x9
	// Bit mask of RXRSM field.
	UDP_IER_RXRSM_Msk = 0x200
	// Bit RXRSM.
	UDP_IER_RXRSM = 0x200
	// Position of SOFINT field.
	UDP_IER_SOFINT_Pos = 0xb
	// Bit mask of SOFINT field.
	UDP_IER_SOFINT_Msk = 0x800
	// Bit SOFINT.
	UDP_IER_SOFINT = 0x800
	// Position of WAKEUP field.
	UDP_IER_WAKEUP_Pos = 0xd
	// Bit mask of WAKEUP field.
	UDP_IER_WAKEUP_Msk = 0x2000
	// Bit WAKEUP.
	UDP_IER_WAKEUP = 0x2000

	// IDR: Interrupt Disable Register
	// Position of EP0INT field.
	UDP_IDR_EP0INT_Pos = 0x0
	// Bit mask of EP0INT field.
	UDP_IDR_EP0INT_Msk = 0x1
	// Bit EP0INT.
	UDP_IDR_EP0INT = 0x1
	// Position of EP1INT field.
	UDP_IDR_EP1INT_Pos = 0x1
	// Bit mask of EP1INT field.
	UDP_IDR_EP1INT_Msk = 0x2
	// Bit EP1INT.
	UDP_IDR_EP1INT = 0x2
	// Position of EP2INT field.
	UDP_IDR_EP2INT_Pos = 0x2
	// Bit mask of EP2INT field.
	UDP_IDR_EP2INT_Msk = 0x4
	// Bit EP2INT.
	UDP_IDR_EP2INT = 0x4
	// Position of EP3INT field.
	UDP_IDR_EP3INT_Pos = 0x3
	// Bit mask of EP3INT field.
	UDP_IDR_EP3INT_Msk = 0x8
	// Bit EP3INT.
	UDP_IDR_EP3INT = 0x8
	// Position of EP4INT field.
	UDP_IDR_EP4INT_Pos = 0x4
	// Bit mask of EP4INT field.
	UDP_IDR_EP4INT_Msk = 0x10
	// Bit EP4INT.
	UDP_IDR_EP4INT = 0x10
	// Position of EP5INT field.
	UDP_IDR_EP5INT_Pos = 0x5
	// Bit mask of EP5INT field.
	UDP_IDR_EP5INT_Msk = 0x20
	// Bit EP5INT.
	UDP_IDR_EP5INT = 0x20
	// Position of RXSUSP field.
	UDP_IDR_RXSUSP_Pos = 0x8
	// Bit mask of RXSUSP field.
	UDP_IDR_RXSUSP_Msk = 0x100
	// Bit RXSUSP.
	UDP_IDR_RXSUSP = 0x100
	// Position of RXRSM field.
	UDP_IDR_RXRSM_Pos = 0x9
	// Bit mask of RXRSM field.
	UDP_IDR_RXRSM_Msk = 0x200
	// Bit RXRSM.
	UDP_IDR_RXRSM = 0x200
	// Position of SOFINT field.
	UDP_IDR_SOFINT_Pos = 0xb
	// Bit mask of SOFINT field.
	UDP_IDR_SOFINT_Msk = 0x800
	// Bit SOFINT.
	UDP_IDR_SOFINT = 0x800
	// Position of WAKEUP field.
	UDP_IDR_WAKEUP_Pos = 0xd
	// Bit mask of WAKEUP field.
	UDP_IDR_WAKEUP_Msk = 0x2000
	// Bit WAKEUP.
	UDP_IDR_WAKEUP = 0x2000

	// IMR: Interrupt Mask Register
	// Position of EP0INT field.
	UDP_IMR_EP0INT_Pos = 0x0
	// Bit mask of EP0INT field.
	UDP_IMR_EP0INT_Msk = 0x1
	// Bit EP0INT.
	UDP_IMR_EP0INT = 0x1
	// Position of EP1INT field.
	UDP_IMR_EP1INT_Pos = 0x1
	// Bit mask of EP1INT field.
	UDP_IMR_EP1INT_Msk = 0x2
	// Bit EP1INT.
	UDP_IMR_EP1INT = 0x2
	// Position of EP2INT field.
	UDP_IMR_EP2INT_Pos = 0x2
	// Bit mask of EP2INT field.
	UDP_IMR_EP2INT_Msk = 0x4
	// Bit EP2INT.
	UDP_IMR_EP2INT = 0x4
	// Position of EP3INT field.
	UDP_IMR_EP3INT_Pos = 0x3
	// Bit mask of EP3INT field.
	UDP_IMR_EP3INT_Msk = 0x8
	// Bit EP3INT.
	UDP_IMR_EP3INT = 0x8
	// Position of EP4INT field.
	UDP_IMR_EP4INT_Pos = 0x4
	// Bit mask of EP4INT field.
	UDP_IMR_EP4INT_Msk = 0x10
	// Bit EP4INT.
	UDP_IMR_EP4INT = 0x10
	// Position of EP5INT field.
	UDP_IMR_EP5INT_Pos = 0x5
	// Bit mask of EP5INT field.
	UDP_IMR_EP5INT_Msk = 0x20
	// Bit EP5INT.
	UDP_IMR_EP5INT = 0x20
	// Position of RXSUSP field.
	UDP_IMR_RXSUSP_Pos = 0x8
	// Bit mask of RXSUSP field.
	UDP_IMR_RXSUSP_Msk = 0x100
	// Bit RXSUSP.
	UDP_IMR_RXSUSP = 0x100
	// Position of RXRSM field.
	UDP_IMR_RXRSM_Pos = 0x9
	// Bit mask of RXRSM field.
	UDP_IMR_RXRSM_Msk = 0x200
	// Bit RXRSM.
	UDP_IMR_RXRSM = 0x200
	// Position of SOFINT field.
	UDP_IMR_SOFINT_Pos = 0xb
	// Bit mask of SOFINT field.
	UDP_IMR_SOFINT_Msk = 0x800
	// Bit SOFINT.
	UDP_IMR_SOFINT = 0x800
	// Position of BIT12 field.
	UDP_IMR_BIT12_Pos = 0xc
	// Bit mask of BIT12 field.
	UDP_IMR_BIT12_Msk = 0x1000
	// Bit BIT12.
	UDP_IMR_BIT12 = 0x1000
	// Position of WAKEUP field.
	UDP_IMR_WAKEUP_Pos = 0xd
	// Bit mask of WAKEUP field.
	UDP_IMR_WAKEUP_Msk = 0x2000
	// Bit WAKEUP.
	UDP_IMR_WAKEUP = 0x2000

	// ISR: Interrupt Status Register
	// Position of EP0INT field.
	UDP_ISR_EP0INT_Pos = 0x0
	// Bit mask of EP0INT field.
	UDP_ISR_EP0INT_Msk = 0x1
	// Bit EP0INT.
	UDP_ISR_EP0INT = 0x1
	// Position of EP1INT field.
	UDP_ISR_EP1INT_Pos = 0x1
	// Bit mask of EP1INT field.
	UDP_ISR_EP1INT_Msk = 0x2
	// Bit EP1INT.
	UDP_ISR_EP1INT = 0x2
	// Position of EP2INT field.
	UDP_ISR_EP2INT_Pos = 0x2
	// Bit mask of EP2INT field.
	UDP_ISR_EP2INT_Msk = 0x4
	// Bit EP2INT.
	UDP_ISR_EP2INT = 0x4
	// Position of EP3INT field.
	UDP_ISR_EP3INT_Pos = 0x3
	// Bit mask of EP3INT field.
	UDP_ISR_EP3INT_Msk = 0x8
	// Bit EP3INT.
	UDP_ISR_EP3INT = 0x8
	// Position of EP4INT field.
	UDP_ISR_EP4INT_Pos = 0x4
	// Bit mask of EP4INT field.
	UDP_ISR_EP4INT_Msk = 0x10
	// Bit EP4INT.
	UDP_ISR_EP4INT = 0x10
	// Position of EP5INT field.
	UDP_ISR_EP5INT_Pos = 0x5
	// Bit mask of EP5INT field.
	UDP_ISR_EP5INT_Msk = 0x20
	// Bit EP5INT.
	UDP_ISR_EP5INT = 0x20
	// Position of RXSUSP field.
	UDP_ISR_RXSUSP_Pos = 0x8
	// Bit mask of RXSUSP field.
	UDP_ISR_RXSUSP_Msk = 0x100
	// Bit RXSUSP.
	UDP_ISR_RXSUSP = 0x100
	// Position of RXRSM field.
	UDP_ISR_RXRSM_Pos = 0x9
	// Bit mask of RXRSM field.
	UDP_ISR_RXRSM_Msk = 0x200
	// Bit RXRSM.
	UDP_ISR_RXRSM = 0x200
	// Position of SOFINT field.
	UDP_ISR_SOFINT_Pos = 0xb
	// Bit mask of SOFINT field.
	UDP_ISR_SOFINT_Msk = 0x800
	// Bit SOFINT.
	UDP_ISR_SOFINT = 0x800
	// Position of ENDBUSRES field.
	UDP_ISR_ENDBUSRES_Pos = 0xc
	// Bit mask of ENDBUSRES field.
	UDP_ISR_ENDBUSRES_Msk = 0x1000
	// Bit ENDBUSRES.
	UDP_ISR_ENDBUSRES = 0x1000
	// Position of WAKEUP field.
	UDP_ISR_WAKEUP_Pos = 0xd
	// Bit mask of WAKEUP field.
	UDP_ISR_WAKEUP_Msk = 0x2000
	// Bit WAKEUP.
	UDP_ISR_WAKEUP = 0x2000

	// ICR: Interrupt Clear Register
	// Position of RXSUSP field.
	UDP_ICR_RXSUSP_Pos = 0x8
	// Bit mask of RXSUSP field.
	UDP_ICR_RXSUSP_Msk = 0x100
	// Bit RXSUSP.
	UDP_ICR_RXSUSP = 0x100
	// Position of RXRSM field.
	UDP_ICR_RXRSM_Pos = 0x9
	// Bit mask of RXRSM field.
	UDP_ICR_RXRSM_Msk = 0x200
	// Bit RXRSM.
	UDP_ICR_RXRSM = 0x200
	// Position of SOFINT field.
	UDP_ICR_SOFINT_Pos = 0xb
	// Bit mask of SOFINT field.
	UDP_ICR_SOFINT_Msk = 0x800
	// Bit SOFINT.
	UDP_ICR_SOFINT = 0x800
	// Position of ENDBUSRES field.
	UDP_ICR_ENDBUSRES_Pos = 0xc
	// Bit mask of ENDBUSRES field.
	UDP_ICR_ENDBUSRES_Msk = 0x1000
	// Bit ENDBUSRES.
	UDP_ICR_ENDBUSRES = 0x1000
	// Position of WAKEUP field.
	UDP_ICR_WAKEUP_Pos = 0xd
	// Bit mask of WAKEUP field.
	UDP_ICR_WAKEUP_Msk = 0x2000
	// Bit WAKEUP.
	UDP_ICR_WAKEUP = 0x2000

	// RST_EP: Reset Endpoint Register
	// Position of EP0 field.
	UDP_RST_EP_EP0_Pos = 0x0
	// Bit mask of EP0 field.
	UDP_RST_EP_EP0_Msk = 0x1
	// Bit EP0.
	UDP_RST_EP_EP0 = 0x1
	// Position of EP1 field.
	UDP_RST_EP_EP1_Pos = 0x1
	// Bit mask of EP1 field.
	UDP_RST_EP_EP1_Msk = 0x2
	// Bit EP1.
	UDP_RST_EP_EP1 = 0x2
	// Position of EP2 field.
	UDP_RST_EP_EP2_Pos = 0x2
	// Bit mask of EP2 field.
	UDP_RST_EP_EP2_Msk = 0x4
	// Bit EP2.
	UDP_RST_EP_EP2 = 0x4
	// Position of EP3 field.
	UDP_RST_EP_EP3_Pos = 0x3
	// Bit mask of EP3 field.
	UDP_RST_EP_EP3_Msk = 0x8
	// Bit EP3.
	UDP_RST_EP_EP3 = 0x8
	// Position of EP4 field.
	UDP_RST_EP_EP4_Pos = 0x4
	// Bit mask of EP4 field.
	UDP_RST_EP_EP4_Msk = 0x10
	// Bit EP4.
	UDP_RST_EP_EP4 = 0x10
	// Position of EP5 field.
	UDP_RST_EP_EP5_Pos = 0x5
	// Bit mask of EP5 field.
	UDP_RST_EP_EP5_Msk = 0x20
	// Bit EP5.
	UDP_RST_EP_EP5 = 0x20

	// CSR: Endpoint Control and Status Register
	// Position of TXCOMP field.
	UDP_CSR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	UDP_CSR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	UDP_CSR_TXCOMP = 0x1
	// Position of RX_DATA_BK0 field.
	UDP_CSR_RX_DATA_BK0_Pos = 0x1
	// Bit mask of RX_DATA_BK0 field.
	UDP_CSR_RX_DATA_BK0_Msk = 0x2
	// Bit RX_DATA_BK0.
	UDP_CSR_RX_DATA_BK0 = 0x2
	// Position of RXSETUP field.
	UDP_CSR_RXSETUP_Pos = 0x2
	// Bit mask of RXSETUP field.
	UDP_CSR_RXSETUP_Msk = 0x4
	// Bit RXSETUP.
	UDP_CSR_RXSETUP = 0x4
	// Position of STALLSENT field.
	UDP_CSR_STALLSENT_Pos = 0x3
	// Bit mask of STALLSENT field.
	UDP_CSR_STALLSENT_Msk = 0x8
	// Bit STALLSENT.
	UDP_CSR_STALLSENT = 0x8
	// Position of TXPKTRDY field.
	UDP_CSR_TXPKTRDY_Pos = 0x4
	// Bit mask of TXPKTRDY field.
	UDP_CSR_TXPKTRDY_Msk = 0x10
	// Bit TXPKTRDY.
	UDP_CSR_TXPKTRDY = 0x10
	// Position of FORCESTALL field.
	UDP_CSR_FORCESTALL_Pos = 0x5
	// Bit mask of FORCESTALL field.
	UDP_CSR_FORCESTALL_Msk = 0x20
	// Bit FORCESTALL.
	UDP_CSR_FORCESTALL = 0x20
	// Position of RX_DATA_BK1 field.
	UDP_CSR_RX_DATA_BK1_Pos = 0x6
	// Bit mask of RX_DATA_BK1 field.
	UDP_CSR_RX_DATA_BK1_Msk = 0x40
	// Bit RX_DATA_BK1.
	UDP_CSR_RX_DATA_BK1 = 0x40
	// Position of DIR field.
	UDP_CSR_DIR_Pos = 0x7
	// Bit mask of DIR field.
	UDP_CSR_DIR_Msk = 0x80
	// Bit DIR.
	UDP_CSR_DIR = 0x80
	// Position of EPTYPE field.
	UDP_CSR_EPTYPE_Pos = 0x8
	// Bit mask of EPTYPE field.
	UDP_CSR_EPTYPE_Msk = 0x700
	// Control
	UDP_CSR_EPTYPE_CTRL = 0x0
	// Isochronous OUT
	UDP_CSR_EPTYPE_ISO_OUT = 0x1
	// Bulk OUT
	UDP_CSR_EPTYPE_BULK_OUT = 0x2
	// Interrupt OUT
	UDP_CSR_EPTYPE_INT_OUT = 0x3
	// Isochronous IN
	UDP_CSR_EPTYPE_ISO_IN = 0x5
	// Bulk IN
	UDP_CSR_EPTYPE_BULK_IN = 0x6
	// Interrupt IN
	UDP_CSR_EPTYPE_INT_IN = 0x7
	// Position of DTGLE field.
	UDP_CSR_DTGLE_Pos = 0xb
	// Bit mask of DTGLE field.
	UDP_CSR_DTGLE_Msk = 0x800
	// Bit DTGLE.
	UDP_CSR_DTGLE = 0x800
	// Position of EPEDS field.
	UDP_CSR_EPEDS_Pos = 0xf
	// Bit mask of EPEDS field.
	UDP_CSR_EPEDS_Msk = 0x8000
	// Bit EPEDS.
	UDP_CSR_EPEDS = 0x8000
	// Position of RXBYTECNT field.
	UDP_CSR_RXBYTECNT_Pos = 0x10
	// Bit mask of RXBYTECNT field.
	UDP_CSR_RXBYTECNT_Msk = 0x7ff0000

	// CSR0_ISOENDPT: Endpoint Control and Status Register
	// Position of TXCOMP field.
	UDP_CSR0_ISOENDPT_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	UDP_CSR0_ISOENDPT_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	UDP_CSR0_ISOENDPT_TXCOMP = 0x1
	// Position of RX_DATA_BK0 field.
	UDP_CSR0_ISOENDPT_RX_DATA_BK0_Pos = 0x1
	// Bit mask of RX_DATA_BK0 field.
	UDP_CSR0_ISOENDPT_RX_DATA_BK0_Msk = 0x2
	// Bit RX_DATA_BK0.
	UDP_CSR0_ISOENDPT_RX_DATA_BK0 = 0x2
	// Position of RXSETUP field.
	UDP_CSR0_ISOENDPT_RXSETUP_Pos = 0x2
	// Bit mask of RXSETUP field.
	UDP_CSR0_ISOENDPT_RXSETUP_Msk = 0x4
	// Bit RXSETUP.
	UDP_CSR0_ISOENDPT_RXSETUP = 0x4
	// Position of ISOERROR field.
	UDP_CSR0_ISOENDPT_ISOERROR_Pos = 0x3
	// Bit mask of ISOERROR field.
	UDP_CSR0_ISOENDPT_ISOERROR_Msk = 0x8
	// Bit ISOERROR.
	UDP_CSR0_ISOENDPT_ISOERROR = 0x8
	// Position of TXPKTRDY field.
	UDP_CSR0_ISOENDPT_TXPKTRDY_Pos = 0x4
	// Bit mask of TXPKTRDY field.
	UDP_CSR0_ISOENDPT_TXPKTRDY_Msk = 0x10
	// Bit TXPKTRDY.
	UDP_CSR0_ISOENDPT_TXPKTRDY = 0x10
	// Position of FORCESTALL field.
	UDP_CSR0_ISOENDPT_FORCESTALL_Pos = 0x5
	// Bit mask of FORCESTALL field.
	UDP_CSR0_ISOENDPT_FORCESTALL_Msk = 0x20
	// Bit FORCESTALL.
	UDP_CSR0_ISOENDPT_FORCESTALL = 0x20
	// Position of RX_DATA_BK1 field.
	UDP_CSR0_ISOENDPT_RX_DATA_BK1_Pos = 0x6
	// Bit mask of RX_DATA_BK1 field.
	UDP_CSR0_ISOENDPT_RX_DATA_BK1_Msk = 0x40
	// Bit RX_DATA_BK1.
	UDP_CSR0_ISOENDPT_RX_DATA_BK1 = 0x40
	// Position of DIR field.
	UDP_CSR0_ISOENDPT_DIR_Pos = 0x7
	// Bit mask of DIR field.
	UDP_CSR0_ISOENDPT_DIR_Msk = 0x80
	// Bit DIR.
	UDP_CSR0_ISOENDPT_DIR = 0x80
	// Position of EPTYPE field.
	UDP_CSR0_ISOENDPT_EPTYPE_Pos = 0x8
	// Bit mask of EPTYPE field.
	UDP_CSR0_ISOENDPT_EPTYPE_Msk = 0x700
	// Control
	UDP_CSR0_ISOENDPT_EPTYPE_CTRL = 0x0
	// Isochronous OUT
	UDP_CSR0_ISOENDPT_EPTYPE_ISO_OUT = 0x1
	// Isochronous IN
	UDP_CSR0_ISOENDPT_EPTYPE_ISO_IN = 0x5
	// Bulk OUT
	UDP_CSR0_ISOENDPT_EPTYPE_BULK_OUT = 0x2
	// Bulk IN
	UDP_CSR0_ISOENDPT_EPTYPE_BULK_IN = 0x6
	// Interrupt OUT
	UDP_CSR0_ISOENDPT_EPTYPE_INT_OUT = 0x3
	// Interrupt IN
	UDP_CSR0_ISOENDPT_EPTYPE_INT_IN = 0x7
	// Position of DTGLE field.
	UDP_CSR0_ISOENDPT_DTGLE_Pos = 0xb
	// Bit mask of DTGLE field.
	UDP_CSR0_ISOENDPT_DTGLE_Msk = 0x800
	// Bit DTGLE.
	UDP_CSR0_ISOENDPT_DTGLE = 0x800
	// Position of EPEDS field.
	UDP_CSR0_ISOENDPT_EPEDS_Pos = 0xf
	// Bit mask of EPEDS field.
	UDP_CSR0_ISOENDPT_EPEDS_Msk = 0x8000
	// Bit EPEDS.
	UDP_CSR0_ISOENDPT_EPEDS = 0x8000
	// Position of RXBYTECNT field.
	UDP_CSR0_ISOENDPT_RXBYTECNT_Pos = 0x10
	// Bit mask of RXBYTECNT field.
	UDP_CSR0_ISOENDPT_RXBYTECNT_Msk = 0x7ff0000

	// FDR: Endpoint FIFO Data Register
	// Position of FIFO_DATA field.
	UDP_FDR_FIFO_DATA_Pos = 0x0
	// Bit mask of FIFO_DATA field.
	UDP_FDR_FIFO_DATA_Msk = 0xff

	// TXVC: Transceiver Control Register
	// Position of TXVDIS field.
	UDP_TXVC_TXVDIS_Pos = 0x8
	// Bit mask of TXVDIS field.
	UDP_TXVC_TXVDIS_Msk = 0x100
	// Bit TXVDIS.
	UDP_TXVC_TXVDIS = 0x100
	// Position of PUON field.
	UDP_TXVC_PUON_Pos = 0x9
	// Bit mask of PUON field.
	UDP_TXVC_PUON_Msk = 0x200
	// Bit PUON.
	UDP_TXVC_PUON = 0x200
)

// Bitfields for MCI: MultiMedia Card Interface
const (
	// CR: Control Register
	// Position of MCIEN field.
	MCI_CR_MCIEN_Pos = 0x0
	// Bit mask of MCIEN field.
	MCI_CR_MCIEN_Msk = 0x1
	// Bit MCIEN.
	MCI_CR_MCIEN = 0x1
	// Position of MCIDIS field.
	MCI_CR_MCIDIS_Pos = 0x1
	// Bit mask of MCIDIS field.
	MCI_CR_MCIDIS_Msk = 0x2
	// Bit MCIDIS.
	MCI_CR_MCIDIS = 0x2
	// Position of PWSEN field.
	MCI_CR_PWSEN_Pos = 0x2
	// Bit mask of PWSEN field.
	MCI_CR_PWSEN_Msk = 0x4
	// Bit PWSEN.
	MCI_CR_PWSEN = 0x4
	// Position of PWSDIS field.
	MCI_CR_PWSDIS_Pos = 0x3
	// Bit mask of PWSDIS field.
	MCI_CR_PWSDIS_Msk = 0x8
	// Bit PWSDIS.
	MCI_CR_PWSDIS = 0x8
	// Position of SWRST field.
	MCI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	MCI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	MCI_CR_SWRST = 0x80

	// MR: Mode Register
	// Position of CLKDIV field.
	MCI_MR_CLKDIV_Pos = 0x0
	// Bit mask of CLKDIV field.
	MCI_MR_CLKDIV_Msk = 0xff
	// Position of PWSDIV field.
	MCI_MR_PWSDIV_Pos = 0x8
	// Bit mask of PWSDIV field.
	MCI_MR_PWSDIV_Msk = 0x700
	// Position of RDPROOF field.
	MCI_MR_RDPROOF_Pos = 0xb
	// Bit mask of RDPROOF field.
	MCI_MR_RDPROOF_Msk = 0x800
	// Bit RDPROOF.
	MCI_MR_RDPROOF = 0x800
	// Position of WRPROOF field.
	MCI_MR_WRPROOF_Pos = 0xc
	// Bit mask of WRPROOF field.
	MCI_MR_WRPROOF_Msk = 0x1000
	// Bit WRPROOF.
	MCI_MR_WRPROOF = 0x1000
	// Position of PDCFBYTE field.
	MCI_MR_PDCFBYTE_Pos = 0xd
	// Bit mask of PDCFBYTE field.
	MCI_MR_PDCFBYTE_Msk = 0x2000
	// Bit PDCFBYTE.
	MCI_MR_PDCFBYTE = 0x2000
	// Position of PDCPADV field.
	MCI_MR_PDCPADV_Pos = 0xe
	// Bit mask of PDCPADV field.
	MCI_MR_PDCPADV_Msk = 0x4000
	// Bit PDCPADV.
	MCI_MR_PDCPADV = 0x4000
	// Position of PDCMODE field.
	MCI_MR_PDCMODE_Pos = 0xf
	// Bit mask of PDCMODE field.
	MCI_MR_PDCMODE_Msk = 0x8000
	// Bit PDCMODE.
	MCI_MR_PDCMODE = 0x8000
	// Position of BLKLEN field.
	MCI_MR_BLKLEN_Pos = 0x10
	// Bit mask of BLKLEN field.
	MCI_MR_BLKLEN_Msk = 0xffff0000

	// DTOR: Data Timeout Register
	// Position of DTOCYC field.
	MCI_DTOR_DTOCYC_Pos = 0x0
	// Bit mask of DTOCYC field.
	MCI_DTOR_DTOCYC_Msk = 0xf
	// Position of DTOMUL field.
	MCI_DTOR_DTOMUL_Pos = 0x4
	// Bit mask of DTOMUL field.
	MCI_DTOR_DTOMUL_Msk = 0x70

	// SDCR: SD/SDIO Card Register
	// Position of SDCSEL field.
	MCI_SDCR_SDCSEL_Pos = 0x0
	// Bit mask of SDCSEL field.
	MCI_SDCR_SDCSEL_Msk = 0x3
	// Position of SDCBUS field.
	MCI_SDCR_SDCBUS_Pos = 0x7
	// Bit mask of SDCBUS field.
	MCI_SDCR_SDCBUS_Msk = 0x80
	// Bit SDCBUS.
	MCI_SDCR_SDCBUS = 0x80

	// ARGR: Argument Register
	// Position of ARG field.
	MCI_ARGR_ARG_Pos = 0x0
	// Bit mask of ARG field.
	MCI_ARGR_ARG_Msk = 0xffffffff

	// CMDR: Command Register
	// Position of CMDNB field.
	MCI_CMDR_CMDNB_Pos = 0x0
	// Bit mask of CMDNB field.
	MCI_CMDR_CMDNB_Msk = 0x3f
	// Position of RSPTYP field.
	MCI_CMDR_RSPTYP_Pos = 0x6
	// Bit mask of RSPTYP field.
	MCI_CMDR_RSPTYP_Msk = 0xc0
	// Position of SPCMD field.
	MCI_CMDR_SPCMD_Pos = 0x8
	// Bit mask of SPCMD field.
	MCI_CMDR_SPCMD_Msk = 0x700
	// Position of OPDCMD field.
	MCI_CMDR_OPDCMD_Pos = 0xb
	// Bit mask of OPDCMD field.
	MCI_CMDR_OPDCMD_Msk = 0x800
	// Bit OPDCMD.
	MCI_CMDR_OPDCMD = 0x800
	// Position of MAXLAT field.
	MCI_CMDR_MAXLAT_Pos = 0xc
	// Bit mask of MAXLAT field.
	MCI_CMDR_MAXLAT_Msk = 0x1000
	// Bit MAXLAT.
	MCI_CMDR_MAXLAT = 0x1000
	// Position of TRCMD field.
	MCI_CMDR_TRCMD_Pos = 0x10
	// Bit mask of TRCMD field.
	MCI_CMDR_TRCMD_Msk = 0x30000
	// Position of TRDIR field.
	MCI_CMDR_TRDIR_Pos = 0x12
	// Bit mask of TRDIR field.
	MCI_CMDR_TRDIR_Msk = 0x40000
	// Bit TRDIR.
	MCI_CMDR_TRDIR = 0x40000
	// Position of TRTYP field.
	MCI_CMDR_TRTYP_Pos = 0x13
	// Bit mask of TRTYP field.
	MCI_CMDR_TRTYP_Msk = 0x380000
	// Position of IOSPCMD field.
	MCI_CMDR_IOSPCMD_Pos = 0x18
	// Bit mask of IOSPCMD field.
	MCI_CMDR_IOSPCMD_Msk = 0x3000000

	// BLKR: Block Register
	// Position of BCNT field.
	MCI_BLKR_BCNT_Pos = 0x0
	// Bit mask of BCNT field.
	MCI_BLKR_BCNT_Msk = 0xffff
	// Position of BLKLEN field.
	MCI_BLKR_BLKLEN_Pos = 0x10
	// Bit mask of BLKLEN field.
	MCI_BLKR_BLKLEN_Msk = 0xffff0000

	// RSPR: Response Register
	// Position of RSP field.
	MCI_RSPR_RSP_Pos = 0x0
	// Bit mask of RSP field.
	MCI_RSPR_RSP_Msk = 0xffffffff

	// RDR: Receive Data Register
	// Position of DATA field.
	MCI_RDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	MCI_RDR_DATA_Msk = 0xffffffff

	// TDR: Transmit Data Register
	// Position of DATA field.
	MCI_TDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	MCI_TDR_DATA_Msk = 0xffffffff

	// SR: Status Register
	// Position of CMDRDY field.
	MCI_SR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	MCI_SR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	MCI_SR_CMDRDY = 0x1
	// Position of RXRDY field.
	MCI_SR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	MCI_SR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	MCI_SR_RXRDY = 0x2
	// Position of TXRDY field.
	MCI_SR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	MCI_SR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	MCI_SR_TXRDY = 0x4
	// Position of BLKE field.
	MCI_SR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	MCI_SR_BLKE_Msk = 0x8
	// Bit BLKE.
	MCI_SR_BLKE = 0x8
	// Position of DTIP field.
	MCI_SR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	MCI_SR_DTIP_Msk = 0x10
	// Bit DTIP.
	MCI_SR_DTIP = 0x10
	// Position of NOTBUSY field.
	MCI_SR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	MCI_SR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	MCI_SR_NOTBUSY = 0x20
	// Position of ENDRX field.
	MCI_SR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	MCI_SR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	MCI_SR_ENDRX = 0x40
	// Position of ENDTX field.
	MCI_SR_ENDTX_Pos = 0x7
	// Bit mask of ENDTX field.
	MCI_SR_ENDTX_Msk = 0x80
	// Bit ENDTX.
	MCI_SR_ENDTX = 0x80
	// Position of RXBUFF field.
	MCI_SR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	MCI_SR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	MCI_SR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	MCI_SR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	MCI_SR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	MCI_SR_TXBUFE = 0x8000
	// Position of RINDE field.
	MCI_SR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	MCI_SR_RINDE_Msk = 0x10000
	// Bit RINDE.
	MCI_SR_RINDE = 0x10000
	// Position of RDIRE field.
	MCI_SR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	MCI_SR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	MCI_SR_RDIRE = 0x20000
	// Position of RCRCE field.
	MCI_SR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	MCI_SR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	MCI_SR_RCRCE = 0x40000
	// Position of RENDE field.
	MCI_SR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	MCI_SR_RENDE_Msk = 0x80000
	// Bit RENDE.
	MCI_SR_RENDE = 0x80000
	// Position of RTOE field.
	MCI_SR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	MCI_SR_RTOE_Msk = 0x100000
	// Bit RTOE.
	MCI_SR_RTOE = 0x100000
	// Position of DCRCE field.
	MCI_SR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	MCI_SR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	MCI_SR_DCRCE = 0x200000
	// Position of DTOE field.
	MCI_SR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	MCI_SR_DTOE_Msk = 0x400000
	// Bit DTOE.
	MCI_SR_DTOE = 0x400000
	// Position of OVRE field.
	MCI_SR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	MCI_SR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	MCI_SR_OVRE = 0x40000000
	// Position of UNRE field.
	MCI_SR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	MCI_SR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	MCI_SR_UNRE = 0x80000000

	// IER: Interrupt Enable Register
	// Position of CMDRDY field.
	MCI_IER_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	MCI_IER_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	MCI_IER_CMDRDY = 0x1
	// Position of RXRDY field.
	MCI_IER_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	MCI_IER_RXRDY_Msk = 0x2
	// Bit RXRDY.
	MCI_IER_RXRDY = 0x2
	// Position of TXRDY field.
	MCI_IER_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	MCI_IER_TXRDY_Msk = 0x4
	// Bit TXRDY.
	MCI_IER_TXRDY = 0x4
	// Position of BLKE field.
	MCI_IER_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	MCI_IER_BLKE_Msk = 0x8
	// Bit BLKE.
	MCI_IER_BLKE = 0x8
	// Position of DTIP field.
	MCI_IER_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	MCI_IER_DTIP_Msk = 0x10
	// Bit DTIP.
	MCI_IER_DTIP = 0x10
	// Position of NOTBUSY field.
	MCI_IER_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	MCI_IER_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	MCI_IER_NOTBUSY = 0x20
	// Position of ENDRX field.
	MCI_IER_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	MCI_IER_ENDRX_Msk = 0x40
	// Bit ENDRX.
	MCI_IER_ENDRX = 0x40
	// Position of ENDTX field.
	MCI_IER_ENDTX_Pos = 0x7
	// Bit mask of ENDTX field.
	MCI_IER_ENDTX_Msk = 0x80
	// Bit ENDTX.
	MCI_IER_ENDTX = 0x80
	// Position of RXBUFF field.
	MCI_IER_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	MCI_IER_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	MCI_IER_RXBUFF = 0x4000
	// Position of TXBUFE field.
	MCI_IER_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	MCI_IER_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	MCI_IER_TXBUFE = 0x8000
	// Position of RINDE field.
	MCI_IER_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	MCI_IER_RINDE_Msk = 0x10000
	// Bit RINDE.
	MCI_IER_RINDE = 0x10000
	// Position of RDIRE field.
	MCI_IER_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	MCI_IER_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	MCI_IER_RDIRE = 0x20000
	// Position of RCRCE field.
	MCI_IER_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	MCI_IER_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	MCI_IER_RCRCE = 0x40000
	// Position of RENDE field.
	MCI_IER_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	MCI_IER_RENDE_Msk = 0x80000
	// Bit RENDE.
	MCI_IER_RENDE = 0x80000
	// Position of RTOE field.
	MCI_IER_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	MCI_IER_RTOE_Msk = 0x100000
	// Bit RTOE.
	MCI_IER_RTOE = 0x100000
	// Position of DCRCE field.
	MCI_IER_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	MCI_IER_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	MCI_IER_DCRCE = 0x200000
	// Position of DTOE field.
	MCI_IER_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	MCI_IER_DTOE_Msk = 0x400000
	// Bit DTOE.
	MCI_IER_DTOE = 0x400000
	// Position of OVRE field.
	MCI_IER_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	MCI_IER_OVRE_Msk = 0x40000000
	// Bit OVRE.
	MCI_IER_OVRE = 0x40000000
	// Position of UNRE field.
	MCI_IER_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	MCI_IER_UNRE_Msk = 0x80000000
	// Bit UNRE.
	MCI_IER_UNRE = 0x80000000

	// IDR: Interrupt Disable Register
	// Position of CMDRDY field.
	MCI_IDR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	MCI_IDR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	MCI_IDR_CMDRDY = 0x1
	// Position of RXRDY field.
	MCI_IDR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	MCI_IDR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	MCI_IDR_RXRDY = 0x2
	// Position of TXRDY field.
	MCI_IDR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	MCI_IDR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	MCI_IDR_TXRDY = 0x4
	// Position of BLKE field.
	MCI_IDR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	MCI_IDR_BLKE_Msk = 0x8
	// Bit BLKE.
	MCI_IDR_BLKE = 0x8
	// Position of DTIP field.
	MCI_IDR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	MCI_IDR_DTIP_Msk = 0x10
	// Bit DTIP.
	MCI_IDR_DTIP = 0x10
	// Position of NOTBUSY field.
	MCI_IDR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	MCI_IDR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	MCI_IDR_NOTBUSY = 0x20
	// Position of ENDRX field.
	MCI_IDR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	MCI_IDR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	MCI_IDR_ENDRX = 0x40
	// Position of ENDTX field.
	MCI_IDR_ENDTX_Pos = 0x7
	// Bit mask of ENDTX field.
	MCI_IDR_ENDTX_Msk = 0x80
	// Bit ENDTX.
	MCI_IDR_ENDTX = 0x80
	// Position of RXBUFF field.
	MCI_IDR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	MCI_IDR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	MCI_IDR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	MCI_IDR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	MCI_IDR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	MCI_IDR_TXBUFE = 0x8000
	// Position of RINDE field.
	MCI_IDR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	MCI_IDR_RINDE_Msk = 0x10000
	// Bit RINDE.
	MCI_IDR_RINDE = 0x10000
	// Position of RDIRE field.
	MCI_IDR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	MCI_IDR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	MCI_IDR_RDIRE = 0x20000
	// Position of RCRCE field.
	MCI_IDR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	MCI_IDR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	MCI_IDR_RCRCE = 0x40000
	// Position of RENDE field.
	MCI_IDR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	MCI_IDR_RENDE_Msk = 0x80000
	// Bit RENDE.
	MCI_IDR_RENDE = 0x80000
	// Position of RTOE field.
	MCI_IDR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	MCI_IDR_RTOE_Msk = 0x100000
	// Bit RTOE.
	MCI_IDR_RTOE = 0x100000
	// Position of DCRCE field.
	MCI_IDR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	MCI_IDR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	MCI_IDR_DCRCE = 0x200000
	// Position of DTOE field.
	MCI_IDR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	MCI_IDR_DTOE_Msk = 0x400000
	// Bit DTOE.
	MCI_IDR_DTOE = 0x400000
	// Position of OVRE field.
	MCI_IDR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	MCI_IDR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	MCI_IDR_OVRE = 0x40000000
	// Position of UNRE field.
	MCI_IDR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	MCI_IDR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	MCI_IDR_UNRE = 0x80000000

	// IMR: Interrupt Mask Register
	// Position of CMDRDY field.
	MCI_IMR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	MCI_IMR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	MCI_IMR_CMDRDY = 0x1
	// Position of RXRDY field.
	MCI_IMR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	MCI_IMR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	MCI_IMR_RXRDY = 0x2
	// Position of TXRDY field.
	MCI_IMR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	MCI_IMR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	MCI_IMR_TXRDY = 0x4
	// Position of BLKE field.
	MCI_IMR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	MCI_IMR_BLKE_Msk = 0x8
	// Bit BLKE.
	MCI_IMR_BLKE = 0x8
	// Position of DTIP field.
	MCI_IMR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	MCI_IMR_DTIP_Msk = 0x10
	// Bit DTIP.
	MCI_IMR_DTIP = 0x10
	// Position of NOTBUSY field.
	MCI_IMR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	MCI_IMR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	MCI_IMR_NOTBUSY = 0x20
	// Position of ENDRX field.
	MCI_IMR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	MCI_IMR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	MCI_IMR_ENDRX = 0x40
	// Position of ENDTX field.
	MCI_IMR_ENDTX_Pos = 0x7
	// Bit mask of ENDTX field.
	MCI_IMR_ENDTX_Msk = 0x80
	// Bit ENDTX.
	MCI_IMR_ENDTX = 0x80
	// Position of RXBUFF field.
	MCI_IMR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	MCI_IMR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	MCI_IMR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	MCI_IMR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	MCI_IMR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	MCI_IMR_TXBUFE = 0x8000
	// Position of RINDE field.
	MCI_IMR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	MCI_IMR_RINDE_Msk = 0x10000
	// Bit RINDE.
	MCI_IMR_RINDE = 0x10000
	// Position of RDIRE field.
	MCI_IMR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	MCI_IMR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	MCI_IMR_RDIRE = 0x20000
	// Position of RCRCE field.
	MCI_IMR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	MCI_IMR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	MCI_IMR_RCRCE = 0x40000
	// Position of RENDE field.
	MCI_IMR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	MCI_IMR_RENDE_Msk = 0x80000
	// Bit RENDE.
	MCI_IMR_RENDE = 0x80000
	// Position of RTOE field.
	MCI_IMR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	MCI_IMR_RTOE_Msk = 0x100000
	// Bit RTOE.
	MCI_IMR_RTOE = 0x100000
	// Position of DCRCE field.
	MCI_IMR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	MCI_IMR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	MCI_IMR_DCRCE = 0x200000
	// Position of DTOE field.
	MCI_IMR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	MCI_IMR_DTOE_Msk = 0x400000
	// Bit DTOE.
	MCI_IMR_DTOE = 0x400000
	// Position of OVRE field.
	MCI_IMR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	MCI_IMR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	MCI_IMR_OVRE = 0x40000000
	// Position of UNRE field.
	MCI_IMR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	MCI_IMR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	MCI_IMR_UNRE = 0x80000000

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	MCI_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	MCI_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	MCI_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	MCI_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	MCI_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	MCI_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	MCI_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	MCI_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	MCI_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	MCI_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	MCI_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	MCI_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	MCI_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	MCI_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	MCI_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	MCI_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	MCI_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	MCI_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	MCI_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	MCI_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	MCI_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	MCI_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	MCI_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	MCI_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	MCI_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	MCI_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	MCI_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	MCI_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	MCI_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	MCI_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	MCI_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	MCI_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	MCI_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	MCI_PTSR_TXTEN = 0x100
)

// Bitfields for TWI: Two-wire Interface
const (
	// CR: Control Register
	// Position of START field.
	TWI_CR_START_Pos = 0x0
	// Bit mask of START field.
	TWI_CR_START_Msk = 0x1
	// Bit START.
	TWI_CR_START = 0x1
	// Position of STOP field.
	TWI_CR_STOP_Pos = 0x1
	// Bit mask of STOP field.
	TWI_CR_STOP_Msk = 0x2
	// Bit STOP.
	TWI_CR_STOP = 0x2
	// Position of MSEN field.
	TWI_CR_MSEN_Pos = 0x2
	// Bit mask of MSEN field.
	TWI_CR_MSEN_Msk = 0x4
	// Bit MSEN.
	TWI_CR_MSEN = 0x4
	// Position of MSDIS field.
	TWI_CR_MSDIS_Pos = 0x3
	// Bit mask of MSDIS field.
	TWI_CR_MSDIS_Msk = 0x8
	// Bit MSDIS.
	TWI_CR_MSDIS = 0x8
	// Position of SVEN field.
	TWI_CR_SVEN_Pos = 0x4
	// Bit mask of SVEN field.
	TWI_CR_SVEN_Msk = 0x10
	// Bit SVEN.
	TWI_CR_SVEN = 0x10
	// Position of SVDIS field.
	TWI_CR_SVDIS_Pos = 0x5
	// Bit mask of SVDIS field.
	TWI_CR_SVDIS_Msk = 0x20
	// Bit SVDIS.
	TWI_CR_SVDIS = 0x20
	// Position of QUICK field.
	TWI_CR_QUICK_Pos = 0x6
	// Bit mask of QUICK field.
	TWI_CR_QUICK_Msk = 0x40
	// Bit QUICK.
	TWI_CR_QUICK = 0x40
	// Position of SWRST field.
	TWI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	TWI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	TWI_CR_SWRST = 0x80

	// MMR: Master Mode Register
	// Position of IADRSZ field.
	TWI_MMR_IADRSZ_Pos = 0x8
	// Bit mask of IADRSZ field.
	TWI_MMR_IADRSZ_Msk = 0x300
	// No internal device address
	TWI_MMR_IADRSZ_NONE = 0x0
	// One-byte internal device address
	TWI_MMR_IADRSZ_1_BYTE = 0x1
	// Two-byte internal device address
	TWI_MMR_IADRSZ_2_BYTE = 0x2
	// Three-byte internal device address
	TWI_MMR_IADRSZ_3_BYTE = 0x3
	// Position of MREAD field.
	TWI_MMR_MREAD_Pos = 0xc
	// Bit mask of MREAD field.
	TWI_MMR_MREAD_Msk = 0x1000
	// Bit MREAD.
	TWI_MMR_MREAD = 0x1000
	// Position of DADR field.
	TWI_MMR_DADR_Pos = 0x10
	// Bit mask of DADR field.
	TWI_MMR_DADR_Msk = 0x7f0000

	// SMR: Slave Mode Register
	// Position of SADR field.
	TWI_SMR_SADR_Pos = 0x10
	// Bit mask of SADR field.
	TWI_SMR_SADR_Msk = 0x7f0000

	// IADR: Internal Address Register
	// Position of IADR field.
	TWI_IADR_IADR_Pos = 0x0
	// Bit mask of IADR field.
	TWI_IADR_IADR_Msk = 0xffffff

	// CWGR: Clock Waveform Generator Register
	// Position of CLDIV field.
	TWI_CWGR_CLDIV_Pos = 0x0
	// Bit mask of CLDIV field.
	TWI_CWGR_CLDIV_Msk = 0xff
	// Position of CHDIV field.
	TWI_CWGR_CHDIV_Pos = 0x8
	// Bit mask of CHDIV field.
	TWI_CWGR_CHDIV_Msk = 0xff00
	// Position of CKDIV field.
	TWI_CWGR_CKDIV_Pos = 0x10
	// Bit mask of CKDIV field.
	TWI_CWGR_CKDIV_Msk = 0x70000

	// SR: Status Register
	// Position of TXCOMP field.
	TWI_SR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_SR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_SR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_SR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_SR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_SR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_SR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_SR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_SR_TXRDY = 0x4
	// Position of SVREAD field.
	TWI_SR_SVREAD_Pos = 0x3
	// Bit mask of SVREAD field.
	TWI_SR_SVREAD_Msk = 0x8
	// Bit SVREAD.
	TWI_SR_SVREAD = 0x8
	// Position of SVACC field.
	TWI_SR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_SR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_SR_SVACC = 0x10
	// Position of GACC field.
	TWI_SR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_SR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_SR_GACC = 0x20
	// Position of OVRE field.
	TWI_SR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_SR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_SR_OVRE = 0x40
	// Position of NACK field.
	TWI_SR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_SR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_SR_NACK = 0x100
	// Position of ARBLST field.
	TWI_SR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_SR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_SR_ARBLST = 0x200
	// Position of SCLWS field.
	TWI_SR_SCLWS_Pos = 0xa
	// Bit mask of SCLWS field.
	TWI_SR_SCLWS_Msk = 0x400
	// Bit SCLWS.
	TWI_SR_SCLWS = 0x400
	// Position of EOSACC field.
	TWI_SR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_SR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_SR_EOSACC = 0x800

	// IER: Interrupt Enable Register
	// Position of TXCOMP field.
	TWI_IER_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IER_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IER_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IER_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IER_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IER_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IER_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IER_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IER_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IER_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IER_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IER_SVACC = 0x10
	// Position of GACC field.
	TWI_IER_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IER_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IER_GACC = 0x20
	// Position of OVRE field.
	TWI_IER_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IER_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IER_OVRE = 0x40
	// Position of NACK field.
	TWI_IER_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IER_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IER_NACK = 0x100
	// Position of ARBLST field.
	TWI_IER_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IER_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IER_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IER_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IER_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IER_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IER_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IER_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IER_EOSACC = 0x800

	// IDR: Interrupt Disable Register
	// Position of TXCOMP field.
	TWI_IDR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IDR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IDR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IDR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IDR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IDR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IDR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IDR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IDR_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IDR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IDR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IDR_SVACC = 0x10
	// Position of GACC field.
	TWI_IDR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IDR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IDR_GACC = 0x20
	// Position of OVRE field.
	TWI_IDR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IDR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IDR_OVRE = 0x40
	// Position of NACK field.
	TWI_IDR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IDR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IDR_NACK = 0x100
	// Position of ARBLST field.
	TWI_IDR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IDR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IDR_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IDR_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IDR_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IDR_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IDR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IDR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IDR_EOSACC = 0x800

	// IMR: Interrupt Mask Register
	// Position of TXCOMP field.
	TWI_IMR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IMR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IMR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IMR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IMR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IMR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IMR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IMR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IMR_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IMR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IMR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IMR_SVACC = 0x10
	// Position of GACC field.
	TWI_IMR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IMR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IMR_GACC = 0x20
	// Position of OVRE field.
	TWI_IMR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IMR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IMR_OVRE = 0x40
	// Position of NACK field.
	TWI_IMR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IMR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IMR_NACK = 0x100
	// Position of ARBLST field.
	TWI_IMR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IMR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IMR_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IMR_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IMR_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IMR_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IMR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IMR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IMR_EOSACC = 0x800

	// RHR: Receive Holding Register
	// Position of RXDATA field.
	TWI_RHR_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	TWI_RHR_RXDATA_Msk = 0xff

	// THR: Transmit Holding Register
	// Position of TXDATA field.
	TWI_THR_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	TWI_THR_TXDATA_Msk = 0xff

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	TWI_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	TWI_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	TWI_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	TWI_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	TWI_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	TWI_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	TWI_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	TWI_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	TWI_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	TWI_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	TWI_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	TWI_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	TWI_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	TWI_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	TWI_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	TWI_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	TWI_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	TWI_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	TWI_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	TWI_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	TWI_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	TWI_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	TWI_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	TWI_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	TWI_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	TWI_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	TWI_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	TWI_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	TWI_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	TWI_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	TWI_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	TWI_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	TWI_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	TWI_PTSR_TXTEN = 0x100
)

// Bitfields for USART0: Universal Synchronous Asynchronous Receiver Transmitter 0
const (
	// CR: Control Register
	// Position of RSTRX field.
	USART_CR_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	USART_CR_RSTRX_Msk = 0x4
	// Bit RSTRX.
	USART_CR_RSTRX = 0x4
	// Position of RSTTX field.
	USART_CR_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	USART_CR_RSTTX_Msk = 0x8
	// Bit RSTTX.
	USART_CR_RSTTX = 0x8
	// Position of RXEN field.
	USART_CR_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	USART_CR_RXEN_Msk = 0x10
	// Bit RXEN.
	USART_CR_RXEN = 0x10
	// Position of RXDIS field.
	USART_CR_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	USART_CR_RXDIS_Msk = 0x20
	// Bit RXDIS.
	USART_CR_RXDIS = 0x20
	// Position of TXEN field.
	USART_CR_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	USART_CR_TXEN_Msk = 0x40
	// Bit TXEN.
	USART_CR_TXEN = 0x40
	// Position of TXDIS field.
	USART_CR_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	USART_CR_TXDIS_Msk = 0x80
	// Bit TXDIS.
	USART_CR_TXDIS = 0x80
	// Position of RSTSTA field.
	USART_CR_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	USART_CR_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	USART_CR_RSTSTA = 0x100
	// Position of STTBRK field.
	USART_CR_STTBRK_Pos = 0x9
	// Bit mask of STTBRK field.
	USART_CR_STTBRK_Msk = 0x200
	// Bit STTBRK.
	USART_CR_STTBRK = 0x200
	// Position of STPBRK field.
	USART_CR_STPBRK_Pos = 0xa
	// Bit mask of STPBRK field.
	USART_CR_STPBRK_Msk = 0x400
	// Bit STPBRK.
	USART_CR_STPBRK = 0x400
	// Position of STTTO field.
	USART_CR_STTTO_Pos = 0xb
	// Bit mask of STTTO field.
	USART_CR_STTTO_Msk = 0x800
	// Bit STTTO.
	USART_CR_STTTO = 0x800
	// Position of SENDA field.
	USART_CR_SENDA_Pos = 0xc
	// Bit mask of SENDA field.
	USART_CR_SENDA_Msk = 0x1000
	// Bit SENDA.
	USART_CR_SENDA = 0x1000
	// Position of RSTIT field.
	USART_CR_RSTIT_Pos = 0xd
	// Bit mask of RSTIT field.
	USART_CR_RSTIT_Msk = 0x2000
	// Bit RSTIT.
	USART_CR_RSTIT = 0x2000
	// Position of RSTNACK field.
	USART_CR_RSTNACK_Pos = 0xe
	// Bit mask of RSTNACK field.
	USART_CR_RSTNACK_Msk = 0x4000
	// Bit RSTNACK.
	USART_CR_RSTNACK = 0x4000
	// Position of RETTO field.
	USART_CR_RETTO_Pos = 0xf
	// Bit mask of RETTO field.
	USART_CR_RETTO_Msk = 0x8000
	// Bit RETTO.
	USART_CR_RETTO = 0x8000
	// Position of DTREN field.
	USART_CR_DTREN_Pos = 0x10
	// Bit mask of DTREN field.
	USART_CR_DTREN_Msk = 0x10000
	// Bit DTREN.
	USART_CR_DTREN = 0x10000
	// Position of DTRDIS field.
	USART_CR_DTRDIS_Pos = 0x11
	// Bit mask of DTRDIS field.
	USART_CR_DTRDIS_Msk = 0x20000
	// Bit DTRDIS.
	USART_CR_DTRDIS = 0x20000
	// Position of RTSEN field.
	USART_CR_RTSEN_Pos = 0x12
	// Bit mask of RTSEN field.
	USART_CR_RTSEN_Msk = 0x40000
	// Bit RTSEN.
	USART_CR_RTSEN = 0x40000
	// Position of RTSDIS field.
	USART_CR_RTSDIS_Pos = 0x13
	// Bit mask of RTSDIS field.
	USART_CR_RTSDIS_Msk = 0x80000
	// Bit RTSDIS.
	USART_CR_RTSDIS = 0x80000

	// MR: Mode Register
	// Position of USART_MODE field.
	USART_MR_USART_MODE_Pos = 0x0
	// Bit mask of USART_MODE field.
	USART_MR_USART_MODE_Msk = 0xf
	// Normal mode
	USART_MR_USART_MODE_NORMAL = 0x0
	// RS485
	USART_MR_USART_MODE_RS485 = 0x1
	// Hardware Handshaking
	USART_MR_USART_MODE_HW_HANDSHAKING = 0x2
	// Modem
	USART_MR_USART_MODE_MODEM = 0x3
	// IS07816 Protocol: T = 0
	USART_MR_USART_MODE_IS07816_T_0 = 0x4
	// IS07816 Protocol: T = 1
	USART_MR_USART_MODE_IS07816_T_1 = 0x6
	// IrDA
	USART_MR_USART_MODE_IRDA = 0x8
	// Position of USCLKS field.
	USART_MR_USCLKS_Pos = 0x4
	// Bit mask of USCLKS field.
	USART_MR_USCLKS_Msk = 0x30
	// Master Clock MCK is selected
	USART_MR_USCLKS_MCK = 0x0
	// Internal Clock Divided MCK/DIV (DIV=8) is selected
	USART_MR_USCLKS_DIV = 0x1
	// Serial Clock SLK is selected
	USART_MR_USCLKS_SCK = 0x3
	// Position of CHRL field.
	USART_MR_CHRL_Pos = 0x6
	// Bit mask of CHRL field.
	USART_MR_CHRL_Msk = 0xc0
	// Character length is 5 bits
	USART_MR_CHRL_5_BIT = 0x0
	// Character length is 6 bits
	USART_MR_CHRL_6_BIT = 0x1
	// Character length is 7 bits
	USART_MR_CHRL_7_BIT = 0x2
	// Character length is 8 bits
	USART_MR_CHRL_8_BIT = 0x3
	// Position of SYNC field.
	USART_MR_SYNC_Pos = 0x8
	// Bit mask of SYNC field.
	USART_MR_SYNC_Msk = 0x100
	// Bit SYNC.
	USART_MR_SYNC = 0x100
	// Position of PAR field.
	USART_MR_PAR_Pos = 0x9
	// Bit mask of PAR field.
	USART_MR_PAR_Msk = 0xe00
	// Even parity
	USART_MR_PAR_EVEN = 0x0
	// Odd parity
	USART_MR_PAR_ODD = 0x1
	// Parity forced to 0 (Space)
	USART_MR_PAR_SPACE = 0x2
	// Parity forced to 1 (Mark)
	USART_MR_PAR_MARK = 0x3
	// No parity
	USART_MR_PAR_NO = 0x4
	// Multidrop mode
	USART_MR_PAR_MULTIDROP = 0x6
	// Position of NBSTOP field.
	USART_MR_NBSTOP_Pos = 0xc
	// Bit mask of NBSTOP field.
	USART_MR_NBSTOP_Msk = 0x3000
	// 1 stop bit
	USART_MR_NBSTOP_1_BIT = 0x0
	// 1.5 stop bit (SYNC = 0) or reserved (SYNC = 1)
	USART_MR_NBSTOP_1_5_BIT = 0x1
	// 2 stop bits
	USART_MR_NBSTOP_2_BIT = 0x2
	// Position of CHMODE field.
	USART_MR_CHMODE_Pos = 0xe
	// Bit mask of CHMODE field.
	USART_MR_CHMODE_Msk = 0xc000
	// Normal Mode
	USART_MR_CHMODE_NORMAL = 0x0
	// Automatic Echo. Receiver input is connected to the TXD pin.
	USART_MR_CHMODE_AUTOMATIC = 0x1
	// Local Loopback. Transmitter output is connected to the Receiver Input.
	USART_MR_CHMODE_LOCAL_LOOPBACK = 0x2
	// Remote Loopback. RXD pin is internally connected to the TXD pin.
	USART_MR_CHMODE_REMOTE_LOOPBACK = 0x3
	// Position of MSBF field.
	USART_MR_MSBF_Pos = 0x10
	// Bit mask of MSBF field.
	USART_MR_MSBF_Msk = 0x10000
	// Bit MSBF.
	USART_MR_MSBF = 0x10000
	// Position of MODE9 field.
	USART_MR_MODE9_Pos = 0x11
	// Bit mask of MODE9 field.
	USART_MR_MODE9_Msk = 0x20000
	// Bit MODE9.
	USART_MR_MODE9 = 0x20000
	// Position of CLKO field.
	USART_MR_CLKO_Pos = 0x12
	// Bit mask of CLKO field.
	USART_MR_CLKO_Msk = 0x40000
	// Bit CLKO.
	USART_MR_CLKO = 0x40000
	// Position of OVER field.
	USART_MR_OVER_Pos = 0x13
	// Bit mask of OVER field.
	USART_MR_OVER_Msk = 0x80000
	// Bit OVER.
	USART_MR_OVER = 0x80000
	// Position of INACK field.
	USART_MR_INACK_Pos = 0x14
	// Bit mask of INACK field.
	USART_MR_INACK_Msk = 0x100000
	// Bit INACK.
	USART_MR_INACK = 0x100000
	// Position of DSNACK field.
	USART_MR_DSNACK_Pos = 0x15
	// Bit mask of DSNACK field.
	USART_MR_DSNACK_Msk = 0x200000
	// Bit DSNACK.
	USART_MR_DSNACK = 0x200000
	// Position of VAR_SYNC field.
	USART_MR_VAR_SYNC_Pos = 0x16
	// Bit mask of VAR_SYNC field.
	USART_MR_VAR_SYNC_Msk = 0x400000
	// Bit VAR_SYNC.
	USART_MR_VAR_SYNC = 0x400000
	// Position of MAX_ITERATION field.
	USART_MR_MAX_ITERATION_Pos = 0x18
	// Bit mask of MAX_ITERATION field.
	USART_MR_MAX_ITERATION_Msk = 0x7000000
	// Position of FILTER field.
	USART_MR_FILTER_Pos = 0x1c
	// Bit mask of FILTER field.
	USART_MR_FILTER_Msk = 0x10000000
	// Bit FILTER.
	USART_MR_FILTER = 0x10000000
	// Position of MAN field.
	USART_MR_MAN_Pos = 0x1d
	// Bit mask of MAN field.
	USART_MR_MAN_Msk = 0x20000000
	// Bit MAN.
	USART_MR_MAN = 0x20000000
	// Position of MODSYNC field.
	USART_MR_MODSYNC_Pos = 0x1e
	// Bit mask of MODSYNC field.
	USART_MR_MODSYNC_Msk = 0x40000000
	// Bit MODSYNC.
	USART_MR_MODSYNC = 0x40000000
	// Position of ONEBIT field.
	USART_MR_ONEBIT_Pos = 0x1f
	// Bit mask of ONEBIT field.
	USART_MR_ONEBIT_Msk = 0x80000000
	// Bit ONEBIT.
	USART_MR_ONEBIT = 0x80000000

	// IER: Interrupt Enable Register
	// Position of RXRDY field.
	USART_IER_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IER_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IER_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IER_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IER_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IER_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IER_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IER_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IER_RXBRK = 0x4
	// Position of ENDRX field.
	USART_IER_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IER_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IER_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IER_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IER_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IER_ENDTX = 0x10
	// Position of OVRE field.
	USART_IER_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IER_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IER_OVRE = 0x20
	// Position of FRAME field.
	USART_IER_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IER_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IER_FRAME = 0x40
	// Position of PARE field.
	USART_IER_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IER_PARE_Msk = 0x80
	// Bit PARE.
	USART_IER_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IER_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IER_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IER_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IER_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IER_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IER_ITER_Msk = 0x400
	// Bit ITER.
	USART_IER_ITER = 0x400
	// Position of TXBUFE field.
	USART_IER_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IER_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IER_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IER_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IER_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IER_RXBUFF = 0x1000
	// Position of NACK field.
	USART_IER_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IER_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IER_NACK = 0x2000
	// Position of RIIC field.
	USART_IER_RIIC_Pos = 0x10
	// Bit mask of RIIC field.
	USART_IER_RIIC_Msk = 0x10000
	// Bit RIIC.
	USART_IER_RIIC = 0x10000
	// Position of DSRIC field.
	USART_IER_DSRIC_Pos = 0x11
	// Bit mask of DSRIC field.
	USART_IER_DSRIC_Msk = 0x20000
	// Bit DSRIC.
	USART_IER_DSRIC = 0x20000
	// Position of DCDIC field.
	USART_IER_DCDIC_Pos = 0x12
	// Bit mask of DCDIC field.
	USART_IER_DCDIC_Msk = 0x40000
	// Bit DCDIC.
	USART_IER_DCDIC = 0x40000
	// Position of CTSIC field.
	USART_IER_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IER_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IER_CTSIC = 0x80000
	// Position of MANE field.
	USART_IER_MANE_Pos = 0x18
	// Bit mask of MANE field.
	USART_IER_MANE_Msk = 0x1000000
	// Bit MANE.
	USART_IER_MANE = 0x1000000

	// IDR: Interrupt Disable Register
	// Position of RXRDY field.
	USART_IDR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IDR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IDR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IDR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IDR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IDR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IDR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IDR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IDR_RXBRK = 0x4
	// Position of ENDRX field.
	USART_IDR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IDR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IDR_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IDR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IDR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IDR_ENDTX = 0x10
	// Position of OVRE field.
	USART_IDR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IDR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IDR_OVRE = 0x20
	// Position of FRAME field.
	USART_IDR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IDR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IDR_FRAME = 0x40
	// Position of PARE field.
	USART_IDR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IDR_PARE_Msk = 0x80
	// Bit PARE.
	USART_IDR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IDR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IDR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IDR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IDR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IDR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IDR_ITER_Msk = 0x400
	// Bit ITER.
	USART_IDR_ITER = 0x400
	// Position of TXBUFE field.
	USART_IDR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IDR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IDR_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IDR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IDR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IDR_RXBUFF = 0x1000
	// Position of NACK field.
	USART_IDR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IDR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IDR_NACK = 0x2000
	// Position of RIIC field.
	USART_IDR_RIIC_Pos = 0x10
	// Bit mask of RIIC field.
	USART_IDR_RIIC_Msk = 0x10000
	// Bit RIIC.
	USART_IDR_RIIC = 0x10000
	// Position of DSRIC field.
	USART_IDR_DSRIC_Pos = 0x11
	// Bit mask of DSRIC field.
	USART_IDR_DSRIC_Msk = 0x20000
	// Bit DSRIC.
	USART_IDR_DSRIC = 0x20000
	// Position of DCDIC field.
	USART_IDR_DCDIC_Pos = 0x12
	// Bit mask of DCDIC field.
	USART_IDR_DCDIC_Msk = 0x40000
	// Bit DCDIC.
	USART_IDR_DCDIC = 0x40000
	// Position of CTSIC field.
	USART_IDR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IDR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IDR_CTSIC = 0x80000
	// Position of MANE field.
	USART_IDR_MANE_Pos = 0x18
	// Bit mask of MANE field.
	USART_IDR_MANE_Msk = 0x1000000
	// Bit MANE.
	USART_IDR_MANE = 0x1000000

	// IMR: Interrupt Mask Register
	// Position of RXRDY field.
	USART_IMR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IMR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IMR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IMR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IMR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IMR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IMR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IMR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IMR_RXBRK = 0x4
	// Position of ENDRX field.
	USART_IMR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IMR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IMR_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IMR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IMR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IMR_ENDTX = 0x10
	// Position of OVRE field.
	USART_IMR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IMR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IMR_OVRE = 0x20
	// Position of FRAME field.
	USART_IMR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IMR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IMR_FRAME = 0x40
	// Position of PARE field.
	USART_IMR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IMR_PARE_Msk = 0x80
	// Bit PARE.
	USART_IMR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IMR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IMR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IMR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IMR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IMR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IMR_ITER_Msk = 0x400
	// Bit ITER.
	USART_IMR_ITER = 0x400
	// Position of TXBUFE field.
	USART_IMR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IMR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IMR_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IMR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IMR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IMR_RXBUFF = 0x1000
	// Position of NACK field.
	USART_IMR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IMR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IMR_NACK = 0x2000
	// Position of RIIC field.
	USART_IMR_RIIC_Pos = 0x10
	// Bit mask of RIIC field.
	USART_IMR_RIIC_Msk = 0x10000
	// Bit RIIC.
	USART_IMR_RIIC = 0x10000
	// Position of DSRIC field.
	USART_IMR_DSRIC_Pos = 0x11
	// Bit mask of DSRIC field.
	USART_IMR_DSRIC_Msk = 0x20000
	// Bit DSRIC.
	USART_IMR_DSRIC = 0x20000
	// Position of DCDIC field.
	USART_IMR_DCDIC_Pos = 0x12
	// Bit mask of DCDIC field.
	USART_IMR_DCDIC_Msk = 0x40000
	// Bit DCDIC.
	USART_IMR_DCDIC = 0x40000
	// Position of CTSIC field.
	USART_IMR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IMR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IMR_CTSIC = 0x80000
	// Position of MANE field.
	USART_IMR_MANE_Pos = 0x18
	// Bit mask of MANE field.
	USART_IMR_MANE_Msk = 0x1000000
	// Bit MANE.
	USART_IMR_MANE = 0x1000000

	// CSR: Channel Status Register
	// Position of RXRDY field.
	USART_CSR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_CSR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_CSR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_CSR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_CSR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_CSR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_CSR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_CSR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_CSR_RXBRK = 0x4
	// Position of ENDRX field.
	USART_CSR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_CSR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_CSR_ENDRX = 0x8
	// Position of ENDTX field.
	USART_CSR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_CSR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_CSR_ENDTX = 0x10
	// Position of OVRE field.
	USART_CSR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_CSR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_CSR_OVRE = 0x20
	// Position of FRAME field.
	USART_CSR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_CSR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_CSR_FRAME = 0x40
	// Position of PARE field.
	USART_CSR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_CSR_PARE_Msk = 0x80
	// Bit PARE.
	USART_CSR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_CSR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_CSR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_CSR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_CSR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_CSR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_CSR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_CSR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_CSR_ITER_Msk = 0x400
	// Bit ITER.
	USART_CSR_ITER = 0x400
	// Position of TXBUFE field.
	USART_CSR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_CSR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_CSR_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_CSR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_CSR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_CSR_RXBUFF = 0x1000
	// Position of NACK field.
	USART_CSR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_CSR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_CSR_NACK = 0x2000
	// Position of RIIC field.
	USART_CSR_RIIC_Pos = 0x10
	// Bit mask of RIIC field.
	USART_CSR_RIIC_Msk = 0x10000
	// Bit RIIC.
	USART_CSR_RIIC = 0x10000
	// Position of DSRIC field.
	USART_CSR_DSRIC_Pos = 0x11
	// Bit mask of DSRIC field.
	USART_CSR_DSRIC_Msk = 0x20000
	// Bit DSRIC.
	USART_CSR_DSRIC = 0x20000
	// Position of DCDIC field.
	USART_CSR_DCDIC_Pos = 0x12
	// Bit mask of DCDIC field.
	USART_CSR_DCDIC_Msk = 0x40000
	// Bit DCDIC.
	USART_CSR_DCDIC = 0x40000
	// Position of CTSIC field.
	USART_CSR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_CSR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_CSR_CTSIC = 0x80000
	// Position of RI field.
	USART_CSR_RI_Pos = 0x14
	// Bit mask of RI field.
	USART_CSR_RI_Msk = 0x100000
	// Bit RI.
	USART_CSR_RI = 0x100000
	// Position of DSR field.
	USART_CSR_DSR_Pos = 0x15
	// Bit mask of DSR field.
	USART_CSR_DSR_Msk = 0x200000
	// Bit DSR.
	USART_CSR_DSR = 0x200000
	// Position of DCD field.
	USART_CSR_DCD_Pos = 0x16
	// Bit mask of DCD field.
	USART_CSR_DCD_Msk = 0x400000
	// Bit DCD.
	USART_CSR_DCD = 0x400000
	// Position of CTS field.
	USART_CSR_CTS_Pos = 0x17
	// Bit mask of CTS field.
	USART_CSR_CTS_Msk = 0x800000
	// Bit CTS.
	USART_CSR_CTS = 0x800000
	// Position of MANERR field.
	USART_CSR_MANERR_Pos = 0x18
	// Bit mask of MANERR field.
	USART_CSR_MANERR_Msk = 0x1000000
	// Bit MANERR.
	USART_CSR_MANERR = 0x1000000

	// RHR: Receiver Holding Register
	// Position of RXCHR field.
	USART_RHR_RXCHR_Pos = 0x0
	// Bit mask of RXCHR field.
	USART_RHR_RXCHR_Msk = 0x1ff
	// Position of RXSYNH field.
	USART_RHR_RXSYNH_Pos = 0xf
	// Bit mask of RXSYNH field.
	USART_RHR_RXSYNH_Msk = 0x8000
	// Bit RXSYNH.
	USART_RHR_RXSYNH = 0x8000

	// THR: Transmitter Holding Register
	// Position of TXCHR field.
	USART_THR_TXCHR_Pos = 0x0
	// Bit mask of TXCHR field.
	USART_THR_TXCHR_Msk = 0x1ff
	// Position of TXSYNH field.
	USART_THR_TXSYNH_Pos = 0xf
	// Bit mask of TXSYNH field.
	USART_THR_TXSYNH_Msk = 0x8000
	// Bit TXSYNH.
	USART_THR_TXSYNH = 0x8000

	// BRGR: Baud Rate Generator Register
	// Position of CD field.
	USART_BRGR_CD_Pos = 0x0
	// Bit mask of CD field.
	USART_BRGR_CD_Msk = 0xffff
	// Position of FP field.
	USART_BRGR_FP_Pos = 0x10
	// Bit mask of FP field.
	USART_BRGR_FP_Msk = 0x70000

	// RTOR: Receiver Time-out Register
	// Position of TO field.
	USART_RTOR_TO_Pos = 0x0
	// Bit mask of TO field.
	USART_RTOR_TO_Msk = 0xffff

	// TTGR: Transmitter Timeguard Register
	// Position of TG field.
	USART_TTGR_TG_Pos = 0x0
	// Bit mask of TG field.
	USART_TTGR_TG_Msk = 0xff

	// FIDI: FI DI Ratio Register
	// Position of FI_DI_RATIO field.
	USART_FIDI_FI_DI_RATIO_Pos = 0x0
	// Bit mask of FI_DI_RATIO field.
	USART_FIDI_FI_DI_RATIO_Msk = 0x7ff

	// NER: Number of Errors Register
	// Position of NB_ERRORS field.
	USART_NER_NB_ERRORS_Pos = 0x0
	// Bit mask of NB_ERRORS field.
	USART_NER_NB_ERRORS_Msk = 0xff

	// IF: IrDA Filter Register
	// Position of IRDA_FILTER field.
	USART_IF_IRDA_FILTER_Pos = 0x0
	// Bit mask of IRDA_FILTER field.
	USART_IF_IRDA_FILTER_Msk = 0xff

	// MAN: Manchester Encoder Decoder Register
	// Position of TX_PL field.
	USART_MAN_TX_PL_Pos = 0x0
	// Bit mask of TX_PL field.
	USART_MAN_TX_PL_Msk = 0xf
	// Position of TX_PP field.
	USART_MAN_TX_PP_Pos = 0x8
	// Bit mask of TX_PP field.
	USART_MAN_TX_PP_Msk = 0x300
	// The preamble is composed of '1's
	USART_MAN_TX_PP_ALL_ONE = 0x0
	// The preamble is composed of '0's
	USART_MAN_TX_PP_ALL_ZERO = 0x1
	// The preamble is composed of '01's
	USART_MAN_TX_PP_ZERO_ONE = 0x2
	// The preamble is composed of '10's
	USART_MAN_TX_PP_ONE_ZERO = 0x3
	// Position of TX_MPOL field.
	USART_MAN_TX_MPOL_Pos = 0xc
	// Bit mask of TX_MPOL field.
	USART_MAN_TX_MPOL_Msk = 0x1000
	// Bit TX_MPOL.
	USART_MAN_TX_MPOL = 0x1000
	// Position of RX_PL field.
	USART_MAN_RX_PL_Pos = 0x10
	// Bit mask of RX_PL field.
	USART_MAN_RX_PL_Msk = 0xf0000
	// Position of RX_PP field.
	USART_MAN_RX_PP_Pos = 0x18
	// Bit mask of RX_PP field.
	USART_MAN_RX_PP_Msk = 0x3000000
	// The preamble is composed of '1's
	USART_MAN_RX_PP_ALL_ONE = 0x0
	// The preamble is composed of '0's
	USART_MAN_RX_PP_ALL_ZERO = 0x1
	// The preamble is composed of '01's
	USART_MAN_RX_PP_ZERO_ONE = 0x2
	// The preamble is composed of '10's
	USART_MAN_RX_PP_ONE_ZERO = 0x3
	// Position of RX_MPOL field.
	USART_MAN_RX_MPOL_Pos = 0x1c
	// Bit mask of RX_MPOL field.
	USART_MAN_RX_MPOL_Msk = 0x10000000
	// Bit RX_MPOL.
	USART_MAN_RX_MPOL = 0x10000000
	// Position of STUCKTO1 field.
	USART_MAN_STUCKTO1_Pos = 0x1d
	// Bit mask of STUCKTO1 field.
	USART_MAN_STUCKTO1_Msk = 0x20000000
	// Bit STUCKTO1.
	USART_MAN_STUCKTO1 = 0x20000000
	// Position of DRIFT field.
	USART_MAN_DRIFT_Pos = 0x1e
	// Bit mask of DRIFT field.
	USART_MAN_DRIFT_Msk = 0x40000000
	// Bit DRIFT.
	USART_MAN_DRIFT = 0x40000000

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	USART_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	USART_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	USART_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	USART_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	USART_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	USART_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	USART_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	USART_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	USART_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	USART_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	USART_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	USART_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	USART_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	USART_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	USART_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	USART_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	USART_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	USART_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	USART_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	USART_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	USART_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	USART_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	USART_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	USART_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	USART_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	USART_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	USART_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	USART_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	USART_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	USART_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	USART_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	USART_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	USART_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	USART_PTSR_TXTEN = 0x100
)

// Bitfields for SSC0: Synchronous Serial Controller 0
const (
	// CR: Control Register
	// Position of RXEN field.
	SSC_CR_RXEN_Pos = 0x0
	// Bit mask of RXEN field.
	SSC_CR_RXEN_Msk = 0x1
	// Bit RXEN.
	SSC_CR_RXEN = 0x1
	// Position of RXDIS field.
	SSC_CR_RXDIS_Pos = 0x1
	// Bit mask of RXDIS field.
	SSC_CR_RXDIS_Msk = 0x2
	// Bit RXDIS.
	SSC_CR_RXDIS = 0x2
	// Position of TXEN field.
	SSC_CR_TXEN_Pos = 0x8
	// Bit mask of TXEN field.
	SSC_CR_TXEN_Msk = 0x100
	// Bit TXEN.
	SSC_CR_TXEN = 0x100
	// Position of TXDIS field.
	SSC_CR_TXDIS_Pos = 0x9
	// Bit mask of TXDIS field.
	SSC_CR_TXDIS_Msk = 0x200
	// Bit TXDIS.
	SSC_CR_TXDIS = 0x200
	// Position of SWRST field.
	SSC_CR_SWRST_Pos = 0xf
	// Bit mask of SWRST field.
	SSC_CR_SWRST_Msk = 0x8000
	// Bit SWRST.
	SSC_CR_SWRST = 0x8000

	// CMR: Clock Mode Register
	// Position of DIV field.
	SSC_CMR_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SSC_CMR_DIV_Msk = 0xfff

	// RCMR: Receive Clock Mode Register
	// Position of CKS field.
	SSC_RCMR_CKS_Pos = 0x0
	// Bit mask of CKS field.
	SSC_RCMR_CKS_Msk = 0x3
	// Divided Clock
	SSC_RCMR_CKS_MCK = 0x0
	// TK Clock signal
	SSC_RCMR_CKS_TK = 0x1
	// RK pin
	SSC_RCMR_CKS_RK = 0x2
	// Position of CKO field.
	SSC_RCMR_CKO_Pos = 0x2
	// Bit mask of CKO field.
	SSC_RCMR_CKO_Msk = 0x1c
	// None
	SSC_RCMR_CKO_NONE = 0x0
	// Continuous Receive Clock
	SSC_RCMR_CKO_CONTINUOUS = 0x1
	// Receive Clock only during data transfers
	SSC_RCMR_CKO_TRANSFER = 0x2
	// Position of CKI field.
	SSC_RCMR_CKI_Pos = 0x5
	// Bit mask of CKI field.
	SSC_RCMR_CKI_Msk = 0x20
	// Bit CKI.
	SSC_RCMR_CKI = 0x20
	// Position of CKG field.
	SSC_RCMR_CKG_Pos = 0x6
	// Bit mask of CKG field.
	SSC_RCMR_CKG_Msk = 0xc0
	// None
	SSC_RCMR_CKG_NONE = 0x0
	// Continuous Receive Clock
	SSC_RCMR_CKG_CONTINUOUS = 0x1
	// Receive Clock only during data transfers
	SSC_RCMR_CKG_TRANSFER = 0x2
	// Position of START field.
	SSC_RCMR_START_Pos = 0x8
	// Bit mask of START field.
	SSC_RCMR_START_Msk = 0xf00
	// Continuous, as soon as the receiver is enabled, and immediately after the end of transfer of the previous data.
	SSC_RCMR_START_CONTINUOUS = 0x0
	// Transmit start
	SSC_RCMR_START_TRANSMIT = 0x1
	// Detection of a low level on RF signal
	SSC_RCMR_START_RF_LOW = 0x2
	// Detection of a high level on RF signal
	SSC_RCMR_START_RF_HIGH = 0x3
	// Detection of a falling edge on RF signal
	SSC_RCMR_START_RF_FALLING = 0x4
	// Detection of a rising edge on RF signal
	SSC_RCMR_START_RF_RISING = 0x5
	// Detection of any level change on RF signal
	SSC_RCMR_START_RF_LEVEL = 0x6
	// Detection of any edge on RF signal
	SSC_RCMR_START_RF_EDGE = 0x7
	// Compare 0
	SSC_RCMR_START_CMP_0 = 0x8
	// Position of STOP field.
	SSC_RCMR_STOP_Pos = 0xc
	// Bit mask of STOP field.
	SSC_RCMR_STOP_Msk = 0x1000
	// Bit STOP.
	SSC_RCMR_STOP = 0x1000
	// Position of STTDLY field.
	SSC_RCMR_STTDLY_Pos = 0x10
	// Bit mask of STTDLY field.
	SSC_RCMR_STTDLY_Msk = 0xff0000
	// Position of PERIOD field.
	SSC_RCMR_PERIOD_Pos = 0x18
	// Bit mask of PERIOD field.
	SSC_RCMR_PERIOD_Msk = 0xff000000

	// RFMR: Receive Frame Mode Register
	// Position of DATLEN field.
	SSC_RFMR_DATLEN_Pos = 0x0
	// Bit mask of DATLEN field.
	SSC_RFMR_DATLEN_Msk = 0x1f
	// Position of LOOP field.
	SSC_RFMR_LOOP_Pos = 0x5
	// Bit mask of LOOP field.
	SSC_RFMR_LOOP_Msk = 0x20
	// Bit LOOP.
	SSC_RFMR_LOOP = 0x20
	// Position of MSBF field.
	SSC_RFMR_MSBF_Pos = 0x7
	// Bit mask of MSBF field.
	SSC_RFMR_MSBF_Msk = 0x80
	// Bit MSBF.
	SSC_RFMR_MSBF = 0x80
	// Position of DATNB field.
	SSC_RFMR_DATNB_Pos = 0x8
	// Bit mask of DATNB field.
	SSC_RFMR_DATNB_Msk = 0xf00
	// Position of FSLEN field.
	SSC_RFMR_FSLEN_Pos = 0x10
	// Bit mask of FSLEN field.
	SSC_RFMR_FSLEN_Msk = 0xf0000
	// Position of FSOS field.
	SSC_RFMR_FSOS_Pos = 0x14
	// Bit mask of FSOS field.
	SSC_RFMR_FSOS_Msk = 0x700000
	// None
	SSC_RFMR_FSOS_NONE = 0x0
	// Negative Pulse
	SSC_RFMR_FSOS_NEGATIVE = 0x1
	// Positive Pulse
	SSC_RFMR_FSOS_POSITIVE = 0x2
	// Driven Low during data transfer
	SSC_RFMR_FSOS_LOW = 0x3
	// Driven High during data transfer
	SSC_RFMR_FSOS_HIGH = 0x4
	// Toggling at each start of data transfer
	SSC_RFMR_FSOS_TOGGLING = 0x5
	// Position of FSEDGE field.
	SSC_RFMR_FSEDGE_Pos = 0x18
	// Bit mask of FSEDGE field.
	SSC_RFMR_FSEDGE_Msk = 0x1000000
	// Bit FSEDGE.
	SSC_RFMR_FSEDGE = 0x1000000
	// Positive Edge Detection
	SSC_RFMR_FSEDGE_POSITIVE = 0x0
	// Negative Edge Detection
	SSC_RFMR_FSEDGE_NEGATIVE = 0x1

	// TCMR: Transmit Clock Mode Register
	// Position of CKS field.
	SSC_TCMR_CKS_Pos = 0x0
	// Bit mask of CKS field.
	SSC_TCMR_CKS_Msk = 0x3
	// Divided Clock
	SSC_TCMR_CKS_MCK = 0x0
	// TK Clock signal
	SSC_TCMR_CKS_TK = 0x1
	// RK pin
	SSC_TCMR_CKS_RK = 0x2
	// Position of CKO field.
	SSC_TCMR_CKO_Pos = 0x2
	// Bit mask of CKO field.
	SSC_TCMR_CKO_Msk = 0x1c
	// None
	SSC_TCMR_CKO_NONE = 0x0
	// Continuous Receive Clock
	SSC_TCMR_CKO_CONTINUOUS = 0x1
	// Transmit Clock only during data transfers
	SSC_TCMR_CKO_TRANSFER = 0x2
	// Position of CKI field.
	SSC_TCMR_CKI_Pos = 0x5
	// Bit mask of CKI field.
	SSC_TCMR_CKI_Msk = 0x20
	// Bit CKI.
	SSC_TCMR_CKI = 0x20
	// Position of CKG field.
	SSC_TCMR_CKG_Pos = 0x6
	// Bit mask of CKG field.
	SSC_TCMR_CKG_Msk = 0xc0
	// None
	SSC_TCMR_CKG_NONE = 0x0
	// Transmit Clock enabled only if TF Low
	SSC_TCMR_CKG_CONTINUOUS = 0x1
	// Transmit Clock enabled only if TF High
	SSC_TCMR_CKG_TRANSFER = 0x2
	// Position of START field.
	SSC_TCMR_START_Pos = 0x8
	// Bit mask of START field.
	SSC_TCMR_START_Msk = 0xf00
	// Continuous, as soon as a word is written in the SSC_THR Register (if Transmit is enabled), and immediately after the end of transfer of the previous data.
	SSC_TCMR_START_CONTINUOUS = 0x0
	// Receive start
	SSC_TCMR_START_RECEIVE = 0x1
	// Detection of a low level on TF signal
	SSC_TCMR_START_RF_LOW = 0x2
	// Detection of a high level on TF signal
	SSC_TCMR_START_RF_HIGH = 0x3
	// Detection of a falling edge on TF signal
	SSC_TCMR_START_RF_FALLING = 0x4
	// Detection of a rising edge on TF signal
	SSC_TCMR_START_RF_RISING = 0x5
	// Detection of any level change on TF signal
	SSC_TCMR_START_RF_LEVEL = 0x6
	// Detection of any edge on TF signal
	SSC_TCMR_START_RF_EDGE = 0x7
	// Compare 0
	SSC_TCMR_START_CMP_0 = 0x8
	// Position of STTDLY field.
	SSC_TCMR_STTDLY_Pos = 0x10
	// Bit mask of STTDLY field.
	SSC_TCMR_STTDLY_Msk = 0xff0000
	// Position of PERIOD field.
	SSC_TCMR_PERIOD_Pos = 0x18
	// Bit mask of PERIOD field.
	SSC_TCMR_PERIOD_Msk = 0xff000000

	// TFMR: Transmit Frame Mode Register
	// Position of DATLEN field.
	SSC_TFMR_DATLEN_Pos = 0x0
	// Bit mask of DATLEN field.
	SSC_TFMR_DATLEN_Msk = 0x1f
	// Position of DATDEF field.
	SSC_TFMR_DATDEF_Pos = 0x5
	// Bit mask of DATDEF field.
	SSC_TFMR_DATDEF_Msk = 0x20
	// Bit DATDEF.
	SSC_TFMR_DATDEF = 0x20
	// Position of MSBF field.
	SSC_TFMR_MSBF_Pos = 0x7
	// Bit mask of MSBF field.
	SSC_TFMR_MSBF_Msk = 0x80
	// Bit MSBF.
	SSC_TFMR_MSBF = 0x80
	// Position of DATNB field.
	SSC_TFMR_DATNB_Pos = 0x8
	// Bit mask of DATNB field.
	SSC_TFMR_DATNB_Msk = 0xf00
	// Position of FSLEN field.
	SSC_TFMR_FSLEN_Pos = 0x10
	// Bit mask of FSLEN field.
	SSC_TFMR_FSLEN_Msk = 0xf0000
	// Position of FSOS field.
	SSC_TFMR_FSOS_Pos = 0x14
	// Bit mask of FSOS field.
	SSC_TFMR_FSOS_Msk = 0x700000
	// None
	SSC_TFMR_FSOS_NONE = 0x0
	// Negative Pulse
	SSC_TFMR_FSOS_NEGATIVE = 0x1
	// Positive Pulse
	SSC_TFMR_FSOS_POSITIVE = 0x2
	// Driven Low during data transfer
	SSC_TFMR_FSOS_LOW = 0x3
	// Driven High during data transfer
	SSC_TFMR_FSOS_HIGH = 0x4
	// Toggling at each start of data transfer
	SSC_TFMR_FSOS_TOGGLING = 0x5
	// Position of FSDEN field.
	SSC_TFMR_FSDEN_Pos = 0x17
	// Bit mask of FSDEN field.
	SSC_TFMR_FSDEN_Msk = 0x800000
	// Bit FSDEN.
	SSC_TFMR_FSDEN = 0x800000
	// Position of FSEDGE field.
	SSC_TFMR_FSEDGE_Pos = 0x18
	// Bit mask of FSEDGE field.
	SSC_TFMR_FSEDGE_Msk = 0x1000000
	// Bit FSEDGE.
	SSC_TFMR_FSEDGE = 0x1000000
	// Positive Edge Detection
	SSC_TFMR_FSEDGE_POSITIVE = 0x0
	// Negative Edge Detection
	SSC_TFMR_FSEDGE_NEGATIVE = 0x1

	// RHR: Receive Holding Register
	// Position of RDAT field.
	SSC_RHR_RDAT_Pos = 0x0
	// Bit mask of RDAT field.
	SSC_RHR_RDAT_Msk = 0xffffffff

	// THR: Transmit Holding Register
	// Position of TDAT field.
	SSC_THR_TDAT_Pos = 0x0
	// Bit mask of TDAT field.
	SSC_THR_TDAT_Msk = 0xffffffff

	// RSHR: Receive Sync. Holding Register
	// Position of RSDAT field.
	SSC_RSHR_RSDAT_Pos = 0x0
	// Bit mask of RSDAT field.
	SSC_RSHR_RSDAT_Msk = 0xffff

	// TSHR: Transmit Sync. Holding Register
	// Position of TSDAT field.
	SSC_TSHR_TSDAT_Pos = 0x0
	// Bit mask of TSDAT field.
	SSC_TSHR_TSDAT_Msk = 0xffff

	// RC0R: Receive Compare 0 Register
	// Position of CP0 field.
	SSC_RC0R_CP0_Pos = 0x0
	// Bit mask of CP0 field.
	SSC_RC0R_CP0_Msk = 0xffff

	// RC1R: Receive Compare 1 Register
	// Position of CP1 field.
	SSC_RC1R_CP1_Pos = 0x0
	// Bit mask of CP1 field.
	SSC_RC1R_CP1_Msk = 0xffff

	// SR: Status Register
	// Position of TXRDY field.
	SSC_SR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_SR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_SR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_SR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_SR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_SR_TXEMPTY = 0x2
	// Position of ENDTX field.
	SSC_SR_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	SSC_SR_ENDTX_Msk = 0x4
	// Bit ENDTX.
	SSC_SR_ENDTX = 0x4
	// Position of TXBUFE field.
	SSC_SR_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	SSC_SR_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	SSC_SR_TXBUFE = 0x8
	// Position of RXRDY field.
	SSC_SR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_SR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_SR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_SR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_SR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_SR_OVRUN = 0x20
	// Position of ENDRX field.
	SSC_SR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	SSC_SR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	SSC_SR_ENDRX = 0x40
	// Position of RXBUFF field.
	SSC_SR_RXBUFF_Pos = 0x7
	// Bit mask of RXBUFF field.
	SSC_SR_RXBUFF_Msk = 0x80
	// Bit RXBUFF.
	SSC_SR_RXBUFF = 0x80
	// Position of CP0 field.
	SSC_SR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_SR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_SR_CP0 = 0x100
	// Position of CP1 field.
	SSC_SR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_SR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_SR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_SR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_SR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_SR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_SR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_SR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_SR_RXSYN = 0x800
	// Position of TXEN field.
	SSC_SR_TXEN_Pos = 0x10
	// Bit mask of TXEN field.
	SSC_SR_TXEN_Msk = 0x10000
	// Bit TXEN.
	SSC_SR_TXEN = 0x10000
	// Position of RXEN field.
	SSC_SR_RXEN_Pos = 0x11
	// Bit mask of RXEN field.
	SSC_SR_RXEN_Msk = 0x20000
	// Bit RXEN.
	SSC_SR_RXEN = 0x20000

	// IER: Interrupt Enable Register
	// Position of TXRDY field.
	SSC_IER_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IER_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IER_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IER_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IER_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IER_TXEMPTY = 0x2
	// Position of ENDTX field.
	SSC_IER_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	SSC_IER_ENDTX_Msk = 0x4
	// Bit ENDTX.
	SSC_IER_ENDTX = 0x4
	// Position of TXBUFE field.
	SSC_IER_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	SSC_IER_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	SSC_IER_TXBUFE = 0x8
	// Position of RXRDY field.
	SSC_IER_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IER_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IER_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IER_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IER_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IER_OVRUN = 0x20
	// Position of ENDRX field.
	SSC_IER_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	SSC_IER_ENDRX_Msk = 0x40
	// Bit ENDRX.
	SSC_IER_ENDRX = 0x40
	// Position of RXBUFF field.
	SSC_IER_RXBUFF_Pos = 0x7
	// Bit mask of RXBUFF field.
	SSC_IER_RXBUFF_Msk = 0x80
	// Bit RXBUFF.
	SSC_IER_RXBUFF = 0x80
	// Position of CP0 field.
	SSC_IER_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IER_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IER_CP0 = 0x100
	// Position of CP1 field.
	SSC_IER_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IER_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IER_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IER_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IER_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IER_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IER_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IER_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IER_RXSYN = 0x800

	// IDR: Interrupt Disable Register
	// Position of TXRDY field.
	SSC_IDR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IDR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IDR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IDR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IDR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IDR_TXEMPTY = 0x2
	// Position of ENDTX field.
	SSC_IDR_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	SSC_IDR_ENDTX_Msk = 0x4
	// Bit ENDTX.
	SSC_IDR_ENDTX = 0x4
	// Position of TXBUFE field.
	SSC_IDR_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	SSC_IDR_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	SSC_IDR_TXBUFE = 0x8
	// Position of RXRDY field.
	SSC_IDR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IDR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IDR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IDR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IDR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IDR_OVRUN = 0x20
	// Position of ENDRX field.
	SSC_IDR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	SSC_IDR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	SSC_IDR_ENDRX = 0x40
	// Position of RXBUFF field.
	SSC_IDR_RXBUFF_Pos = 0x7
	// Bit mask of RXBUFF field.
	SSC_IDR_RXBUFF_Msk = 0x80
	// Bit RXBUFF.
	SSC_IDR_RXBUFF = 0x80
	// Position of CP0 field.
	SSC_IDR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IDR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IDR_CP0 = 0x100
	// Position of CP1 field.
	SSC_IDR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IDR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IDR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IDR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IDR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IDR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IDR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IDR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IDR_RXSYN = 0x800

	// IMR: Interrupt Mask Register
	// Position of TXRDY field.
	SSC_IMR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IMR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IMR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IMR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IMR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IMR_TXEMPTY = 0x2
	// Position of ENDTX field.
	SSC_IMR_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	SSC_IMR_ENDTX_Msk = 0x4
	// Bit ENDTX.
	SSC_IMR_ENDTX = 0x4
	// Position of TXBUFE field.
	SSC_IMR_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	SSC_IMR_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	SSC_IMR_TXBUFE = 0x8
	// Position of RXRDY field.
	SSC_IMR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IMR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IMR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IMR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IMR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IMR_OVRUN = 0x20
	// Position of ENDRX field.
	SSC_IMR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	SSC_IMR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	SSC_IMR_ENDRX = 0x40
	// Position of RXBUFF field.
	SSC_IMR_RXBUFF_Pos = 0x7
	// Bit mask of RXBUFF field.
	SSC_IMR_RXBUFF_Msk = 0x80
	// Bit RXBUFF.
	SSC_IMR_RXBUFF = 0x80
	// Position of CP0 field.
	SSC_IMR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IMR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IMR_CP0 = 0x100
	// Position of CP1 field.
	SSC_IMR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IMR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IMR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IMR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IMR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IMR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IMR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IMR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IMR_RXSYN = 0x800

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	SSC_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	SSC_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	SSC_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	SSC_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	SSC_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	SSC_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	SSC_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	SSC_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	SSC_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	SSC_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	SSC_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	SSC_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	SSC_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	SSC_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	SSC_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	SSC_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	SSC_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	SSC_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	SSC_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	SSC_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	SSC_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	SSC_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	SSC_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	SSC_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	SSC_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	SSC_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	SSC_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	SSC_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	SSC_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	SSC_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	SSC_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	SSC_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	SSC_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	SSC_PTSR_TXTEN = 0x100
)

// Bitfields for ISI: Image Sensor Interface
const (
	// CR1: ISI Control 1 Register
	// Position of ISI_RST field.
	ISI_CR1_ISI_RST_Pos = 0x0
	// Bit mask of ISI_RST field.
	ISI_CR1_ISI_RST_Msk = 0x1
	// Bit ISI_RST.
	ISI_CR1_ISI_RST = 0x1
	// Position of ISI_DIS field.
	ISI_CR1_ISI_DIS_Pos = 0x1
	// Bit mask of ISI_DIS field.
	ISI_CR1_ISI_DIS_Msk = 0x2
	// Bit ISI_DIS.
	ISI_CR1_ISI_DIS = 0x2
	// Position of HSYNC_POL field.
	ISI_CR1_HSYNC_POL_Pos = 0x2
	// Bit mask of HSYNC_POL field.
	ISI_CR1_HSYNC_POL_Msk = 0x4
	// Bit HSYNC_POL.
	ISI_CR1_HSYNC_POL = 0x4
	// Position of VSYNC_POL field.
	ISI_CR1_VSYNC_POL_Pos = 0x3
	// Bit mask of VSYNC_POL field.
	ISI_CR1_VSYNC_POL_Msk = 0x8
	// Bit VSYNC_POL.
	ISI_CR1_VSYNC_POL = 0x8
	// Position of PIXCLK_POL field.
	ISI_CR1_PIXCLK_POL_Pos = 0x4
	// Bit mask of PIXCLK_POL field.
	ISI_CR1_PIXCLK_POL_Msk = 0x10
	// Bit PIXCLK_POL.
	ISI_CR1_PIXCLK_POL = 0x10
	// Position of EMB_SYNC field.
	ISI_CR1_EMB_SYNC_Pos = 0x6
	// Bit mask of EMB_SYNC field.
	ISI_CR1_EMB_SYNC_Msk = 0x40
	// Bit EMB_SYNC.
	ISI_CR1_EMB_SYNC = 0x40
	// Position of CRC_SYNC field.
	ISI_CR1_CRC_SYNC_Pos = 0x7
	// Bit mask of CRC_SYNC field.
	ISI_CR1_CRC_SYNC_Msk = 0x80
	// Bit CRC_SYNC.
	ISI_CR1_CRC_SYNC = 0x80
	// Position of FRATE field.
	ISI_CR1_FRATE_Pos = 0x8
	// Bit mask of FRATE field.
	ISI_CR1_FRATE_Msk = 0x700
	// Position of FULL field.
	ISI_CR1_FULL_Pos = 0xc
	// Bit mask of FULL field.
	ISI_CR1_FULL_Msk = 0x1000
	// Bit FULL.
	ISI_CR1_FULL = 0x1000
	// Position of THMASK field.
	ISI_CR1_THMASK_Pos = 0xd
	// Bit mask of THMASK field.
	ISI_CR1_THMASK_Msk = 0x6000
	// Position of CODEC_ON field.
	ISI_CR1_CODEC_ON_Pos = 0xf
	// Bit mask of CODEC_ON field.
	ISI_CR1_CODEC_ON_Msk = 0x8000
	// Bit CODEC_ON.
	ISI_CR1_CODEC_ON = 0x8000
	// Position of SLD field.
	ISI_CR1_SLD_Pos = 0x10
	// Bit mask of SLD field.
	ISI_CR1_SLD_Msk = 0xff0000
	// Position of SFD field.
	ISI_CR1_SFD_Pos = 0x18
	// Bit mask of SFD field.
	ISI_CR1_SFD_Msk = 0xff000000

	// CR2: ISI Control 2 Register
	// Position of IM_VSIZE field.
	ISI_CR2_IM_VSIZE_Pos = 0x0
	// Bit mask of IM_VSIZE field.
	ISI_CR2_IM_VSIZE_Msk = 0x7ff
	// Position of GS_MODE field.
	ISI_CR2_GS_MODE_Pos = 0xb
	// Bit mask of GS_MODE field.
	ISI_CR2_GS_MODE_Msk = 0x800
	// Bit GS_MODE.
	ISI_CR2_GS_MODE = 0x800
	// Position of RGB_MODE field.
	ISI_CR2_RGB_MODE_Pos = 0xc
	// Bit mask of RGB_MODE field.
	ISI_CR2_RGB_MODE_Msk = 0x1000
	// Bit RGB_MODE.
	ISI_CR2_RGB_MODE = 0x1000
	// Position of GRAYSCALE field.
	ISI_CR2_GRAYSCALE_Pos = 0xd
	// Bit mask of GRAYSCALE field.
	ISI_CR2_GRAYSCALE_Msk = 0x2000
	// Bit GRAYSCALE.
	ISI_CR2_GRAYSCALE = 0x2000
	// Position of RGB_SWAP field.
	ISI_CR2_RGB_SWAP_Pos = 0xe
	// Bit mask of RGB_SWAP field.
	ISI_CR2_RGB_SWAP_Msk = 0x4000
	// Bit RGB_SWAP.
	ISI_CR2_RGB_SWAP = 0x4000
	// Position of COL_SPACE field.
	ISI_CR2_COL_SPACE_Pos = 0xf
	// Bit mask of COL_SPACE field.
	ISI_CR2_COL_SPACE_Msk = 0x8000
	// Bit COL_SPACE.
	ISI_CR2_COL_SPACE = 0x8000
	// Position of IM_HSIZE field.
	ISI_CR2_IM_HSIZE_Pos = 0x10
	// Bit mask of IM_HSIZE field.
	ISI_CR2_IM_HSIZE_Msk = 0x7ff0000
	// Position of YCC_SWAP field.
	ISI_CR2_YCC_SWAP_Pos = 0x1c
	// Bit mask of YCC_SWAP field.
	ISI_CR2_YCC_SWAP_Msk = 0x30000000
	// Position of RGB_CFG field.
	ISI_CR2_RGB_CFG_Pos = 0x1e
	// Bit mask of RGB_CFG field.
	ISI_CR2_RGB_CFG_Msk = 0xc0000000

	// SR: ISI Status Register
	// Position of SOF field.
	ISI_SR_SOF_Pos = 0x0
	// Bit mask of SOF field.
	ISI_SR_SOF_Msk = 0x1
	// Bit SOF.
	ISI_SR_SOF = 0x1
	// Position of DIS field.
	ISI_SR_DIS_Pos = 0x1
	// Bit mask of DIS field.
	ISI_SR_DIS_Msk = 0x2
	// Bit DIS.
	ISI_SR_DIS = 0x2
	// Position of SOFTRST field.
	ISI_SR_SOFTRST_Pos = 0x2
	// Bit mask of SOFTRST field.
	ISI_SR_SOFTRST_Msk = 0x4
	// Bit SOFTRST.
	ISI_SR_SOFTRST = 0x4
	// Position of CDC_PND field.
	ISI_SR_CDC_PND_Pos = 0x3
	// Bit mask of CDC_PND field.
	ISI_SR_CDC_PND_Msk = 0x8
	// Bit CDC_PND.
	ISI_SR_CDC_PND = 0x8
	// Position of CRC_ERR field.
	ISI_SR_CRC_ERR_Pos = 0x4
	// Bit mask of CRC_ERR field.
	ISI_SR_CRC_ERR_Msk = 0x10
	// Bit CRC_ERR.
	ISI_SR_CRC_ERR = 0x10
	// Position of FO_C_OVF field.
	ISI_SR_FO_C_OVF_Pos = 0x5
	// Bit mask of FO_C_OVF field.
	ISI_SR_FO_C_OVF_Msk = 0x20
	// Bit FO_C_OVF.
	ISI_SR_FO_C_OVF = 0x20
	// Position of FO_P_OVF field.
	ISI_SR_FO_P_OVF_Pos = 0x6
	// Bit mask of FO_P_OVF field.
	ISI_SR_FO_P_OVF_Msk = 0x40
	// Bit FO_P_OVF.
	ISI_SR_FO_P_OVF = 0x40
	// Position of FO_P_EMP field.
	ISI_SR_FO_P_EMP_Pos = 0x7
	// Bit mask of FO_P_EMP field.
	ISI_SR_FO_P_EMP_Msk = 0x80
	// Bit FO_P_EMP.
	ISI_SR_FO_P_EMP = 0x80
	// Position of FO_C_EMP field.
	ISI_SR_FO_C_EMP_Pos = 0x8
	// Bit mask of FO_C_EMP field.
	ISI_SR_FO_C_EMP_Msk = 0x100
	// Bit FO_C_EMP.
	ISI_SR_FO_C_EMP = 0x100
	// Position of FR_OVR field.
	ISI_SR_FR_OVR_Pos = 0x9
	// Bit mask of FR_OVR field.
	ISI_SR_FR_OVR_Msk = 0x200
	// Bit FR_OVR.
	ISI_SR_FR_OVR = 0x200

	// IER: ISI Interrupt Enable Register
	// Position of SOF field.
	ISI_IER_SOF_Pos = 0x0
	// Bit mask of SOF field.
	ISI_IER_SOF_Msk = 0x1
	// Bit SOF.
	ISI_IER_SOF = 0x1
	// Position of DIS field.
	ISI_IER_DIS_Pos = 0x1
	// Bit mask of DIS field.
	ISI_IER_DIS_Msk = 0x2
	// Bit DIS.
	ISI_IER_DIS = 0x2
	// Position of SOFTRST field.
	ISI_IER_SOFTRST_Pos = 0x2
	// Bit mask of SOFTRST field.
	ISI_IER_SOFTRST_Msk = 0x4
	// Bit SOFTRST.
	ISI_IER_SOFTRST = 0x4
	// Position of CRC_ERR field.
	ISI_IER_CRC_ERR_Pos = 0x4
	// Bit mask of CRC_ERR field.
	ISI_IER_CRC_ERR_Msk = 0x10
	// Bit CRC_ERR.
	ISI_IER_CRC_ERR = 0x10
	// Position of FO_C_OVF field.
	ISI_IER_FO_C_OVF_Pos = 0x5
	// Bit mask of FO_C_OVF field.
	ISI_IER_FO_C_OVF_Msk = 0x20
	// Bit FO_C_OVF.
	ISI_IER_FO_C_OVF = 0x20
	// Position of FO_P_OVF field.
	ISI_IER_FO_P_OVF_Pos = 0x6
	// Bit mask of FO_P_OVF field.
	ISI_IER_FO_P_OVF_Msk = 0x40
	// Bit FO_P_OVF.
	ISI_IER_FO_P_OVF = 0x40
	// Position of FO_P_EMP field.
	ISI_IER_FO_P_EMP_Pos = 0x7
	// Bit mask of FO_P_EMP field.
	ISI_IER_FO_P_EMP_Msk = 0x80
	// Bit FO_P_EMP.
	ISI_IER_FO_P_EMP = 0x80
	// Position of FO_C_EMP field.
	ISI_IER_FO_C_EMP_Pos = 0x8
	// Bit mask of FO_C_EMP field.
	ISI_IER_FO_C_EMP_Msk = 0x100
	// Bit FO_C_EMP.
	ISI_IER_FO_C_EMP = 0x100
	// Position of FR_OVR field.
	ISI_IER_FR_OVR_Pos = 0x9
	// Bit mask of FR_OVR field.
	ISI_IER_FR_OVR_Msk = 0x200
	// Bit FR_OVR.
	ISI_IER_FR_OVR = 0x200

	// IDR: ISI Interrupt Disable Register
	// Position of SOF field.
	ISI_IDR_SOF_Pos = 0x0
	// Bit mask of SOF field.
	ISI_IDR_SOF_Msk = 0x1
	// Bit SOF.
	ISI_IDR_SOF = 0x1
	// Position of DIS field.
	ISI_IDR_DIS_Pos = 0x1
	// Bit mask of DIS field.
	ISI_IDR_DIS_Msk = 0x2
	// Bit DIS.
	ISI_IDR_DIS = 0x2
	// Position of SOFTRST field.
	ISI_IDR_SOFTRST_Pos = 0x2
	// Bit mask of SOFTRST field.
	ISI_IDR_SOFTRST_Msk = 0x4
	// Bit SOFTRST.
	ISI_IDR_SOFTRST = 0x4
	// Position of CRC_ERR field.
	ISI_IDR_CRC_ERR_Pos = 0x4
	// Bit mask of CRC_ERR field.
	ISI_IDR_CRC_ERR_Msk = 0x10
	// Bit CRC_ERR.
	ISI_IDR_CRC_ERR = 0x10
	// Position of FO_C_OVF field.
	ISI_IDR_FO_C_OVF_Pos = 0x5
	// Bit mask of FO_C_OVF field.
	ISI_IDR_FO_C_OVF_Msk = 0x20
	// Bit FO_C_OVF.
	ISI_IDR_FO_C_OVF = 0x20
	// Position of FO_P_OVF field.
	ISI_IDR_FO_P_OVF_Pos = 0x6
	// Bit mask of FO_P_OVF field.
	ISI_IDR_FO_P_OVF_Msk = 0x40
	// Bit FO_P_OVF.
	ISI_IDR_FO_P_OVF = 0x40
	// Position of FO_P_EMP field.
	ISI_IDR_FO_P_EMP_Pos = 0x7
	// Bit mask of FO_P_EMP field.
	ISI_IDR_FO_P_EMP_Msk = 0x80
	// Bit FO_P_EMP.
	ISI_IDR_FO_P_EMP = 0x80
	// Position of FO_C_EMP field.
	ISI_IDR_FO_C_EMP_Pos = 0x8
	// Bit mask of FO_C_EMP field.
	ISI_IDR_FO_C_EMP_Msk = 0x100
	// Bit FO_C_EMP.
	ISI_IDR_FO_C_EMP = 0x100
	// Position of FR_OVR field.
	ISI_IDR_FR_OVR_Pos = 0x9
	// Bit mask of FR_OVR field.
	ISI_IDR_FR_OVR_Msk = 0x200
	// Bit FR_OVR.
	ISI_IDR_FR_OVR = 0x200

	// IMR: ISI Interrupt Mask Register
	// Position of SOF field.
	ISI_IMR_SOF_Pos = 0x0
	// Bit mask of SOF field.
	ISI_IMR_SOF_Msk = 0x1
	// Bit SOF.
	ISI_IMR_SOF = 0x1
	// Position of DIS field.
	ISI_IMR_DIS_Pos = 0x1
	// Bit mask of DIS field.
	ISI_IMR_DIS_Msk = 0x2
	// Bit DIS.
	ISI_IMR_DIS = 0x2
	// Position of SOFTRST field.
	ISI_IMR_SOFTRST_Pos = 0x2
	// Bit mask of SOFTRST field.
	ISI_IMR_SOFTRST_Msk = 0x4
	// Bit SOFTRST.
	ISI_IMR_SOFTRST = 0x4
	// Position of CRC_ERR field.
	ISI_IMR_CRC_ERR_Pos = 0x4
	// Bit mask of CRC_ERR field.
	ISI_IMR_CRC_ERR_Msk = 0x10
	// Bit CRC_ERR.
	ISI_IMR_CRC_ERR = 0x10
	// Position of FO_C_OVF field.
	ISI_IMR_FO_C_OVF_Pos = 0x5
	// Bit mask of FO_C_OVF field.
	ISI_IMR_FO_C_OVF_Msk = 0x20
	// Bit FO_C_OVF.
	ISI_IMR_FO_C_OVF = 0x20
	// Position of FO_P_OVF field.
	ISI_IMR_FO_P_OVF_Pos = 0x6
	// Bit mask of FO_P_OVF field.
	ISI_IMR_FO_P_OVF_Msk = 0x40
	// Bit FO_P_OVF.
	ISI_IMR_FO_P_OVF = 0x40
	// Position of FO_P_EMP field.
	ISI_IMR_FO_P_EMP_Pos = 0x7
	// Bit mask of FO_P_EMP field.
	ISI_IMR_FO_P_EMP_Msk = 0x80
	// Bit FO_P_EMP.
	ISI_IMR_FO_P_EMP = 0x80
	// Position of FO_C_EMP field.
	ISI_IMR_FO_C_EMP_Pos = 0x8
	// Bit mask of FO_C_EMP field.
	ISI_IMR_FO_C_EMP_Msk = 0x100
	// Bit FO_C_EMP.
	ISI_IMR_FO_C_EMP = 0x100
	// Position of FR_OVR field.
	ISI_IMR_FR_OVR_Pos = 0x9
	// Bit mask of FR_OVR field.
	ISI_IMR_FR_OVR_Msk = 0x200
	// Bit FR_OVR.
	ISI_IMR_FR_OVR = 0x200

	// PSIZE: ISI Preview Size Register
	// Position of PREV_VSIZE field.
	ISI_PSIZE_PREV_VSIZE_Pos = 0x0
	// Bit mask of PREV_VSIZE field.
	ISI_PSIZE_PREV_VSIZE_Msk = 0x3ff
	// Position of PREV_HSIZE field.
	ISI_PSIZE_PREV_HSIZE_Pos = 0x10
	// Bit mask of PREV_HSIZE field.
	ISI_PSIZE_PREV_HSIZE_Msk = 0x3ff0000

	// PDECF: ISI Preview Decimation Factor Register
	// Position of DEC_FACTOR field.
	ISI_PDECF_DEC_FACTOR_Pos = 0x0
	// Bit mask of DEC_FACTOR field.
	ISI_PDECF_DEC_FACTOR_Msk = 0xff

	// PPFBD: ISI Preview Primary FBD Register
	// Position of PREV_FBD_ADDR field.
	ISI_PPFBD_PREV_FBD_ADDR_Pos = 0x0
	// Bit mask of PREV_FBD_ADDR field.
	ISI_PPFBD_PREV_FBD_ADDR_Msk = 0xffffffff

	// CDBA: ISI Codec DMA Base Address Register
	// Position of CODEC_DMA_ADDR field.
	ISI_CDBA_CODEC_DMA_ADDR_Pos = 0x0
	// Bit mask of CODEC_DMA_ADDR field.
	ISI_CDBA_CODEC_DMA_ADDR_Msk = 0xffffffff

	// Y2R_SET0: ISI CSC YCrCb To RGB Set 0 Register
	// Position of C0 field.
	ISI_Y2R_SET0_C0_Pos = 0x0
	// Bit mask of C0 field.
	ISI_Y2R_SET0_C0_Msk = 0xff
	// Position of C1 field.
	ISI_Y2R_SET0_C1_Pos = 0x8
	// Bit mask of C1 field.
	ISI_Y2R_SET0_C1_Msk = 0xff00
	// Position of C2 field.
	ISI_Y2R_SET0_C2_Pos = 0x10
	// Bit mask of C2 field.
	ISI_Y2R_SET0_C2_Msk = 0xff0000
	// Position of C3 field.
	ISI_Y2R_SET0_C3_Pos = 0x18
	// Bit mask of C3 field.
	ISI_Y2R_SET0_C3_Msk = 0xff000000

	// Y2R_SET1: ISI CSC YCrCb To RGB Set 1 Register
	// Position of C4 field.
	ISI_Y2R_SET1_C4_Pos = 0x0
	// Bit mask of C4 field.
	ISI_Y2R_SET1_C4_Msk = 0x1ff
	// Position of Yoff field.
	ISI_Y2R_SET1_Yoff_Pos = 0xc
	// Bit mask of Yoff field.
	ISI_Y2R_SET1_Yoff_Msk = 0x1000
	// Bit Yoff.
	ISI_Y2R_SET1_Yoff = 0x1000
	// Position of Croff field.
	ISI_Y2R_SET1_Croff_Pos = 0xd
	// Bit mask of Croff field.
	ISI_Y2R_SET1_Croff_Msk = 0x2000
	// Bit Croff.
	ISI_Y2R_SET1_Croff = 0x2000
	// Position of Cboff field.
	ISI_Y2R_SET1_Cboff_Pos = 0xe
	// Bit mask of Cboff field.
	ISI_Y2R_SET1_Cboff_Msk = 0x4000
	// Bit Cboff.
	ISI_Y2R_SET1_Cboff = 0x4000

	// R2Y_SET0: ISI CSC RGB To YCrCb Set 0 Register
	// Position of C0 field.
	ISI_R2Y_SET0_C0_Pos = 0x0
	// Bit mask of C0 field.
	ISI_R2Y_SET0_C0_Msk = 0xff
	// Position of C1 field.
	ISI_R2Y_SET0_C1_Pos = 0x8
	// Bit mask of C1 field.
	ISI_R2Y_SET0_C1_Msk = 0xff00
	// Position of C2 field.
	ISI_R2Y_SET0_C2_Pos = 0x10
	// Bit mask of C2 field.
	ISI_R2Y_SET0_C2_Msk = 0xff0000
	// Position of Roff field.
	ISI_R2Y_SET0_Roff_Pos = 0x18
	// Bit mask of Roff field.
	ISI_R2Y_SET0_Roff_Msk = 0x1000000
	// Bit Roff.
	ISI_R2Y_SET0_Roff = 0x1000000

	// R2Y_SET1: ISI CSC RGB To YCrCb Set 1 Register
	// Position of C3 field.
	ISI_R2Y_SET1_C3_Pos = 0x0
	// Bit mask of C3 field.
	ISI_R2Y_SET1_C3_Msk = 0xff
	// Position of C4 field.
	ISI_R2Y_SET1_C4_Pos = 0x8
	// Bit mask of C4 field.
	ISI_R2Y_SET1_C4_Msk = 0xff00
	// Position of C5 field.
	ISI_R2Y_SET1_C5_Pos = 0x10
	// Bit mask of C5 field.
	ISI_R2Y_SET1_C5_Msk = 0xff0000
	// Position of Goff field.
	ISI_R2Y_SET1_Goff_Pos = 0x18
	// Bit mask of Goff field.
	ISI_R2Y_SET1_Goff_Msk = 0x1000000
	// Bit Goff.
	ISI_R2Y_SET1_Goff = 0x1000000

	// R2Y_SET2: ISI CSC RGB To YCrCb Set 2 Register
	// Position of C6 field.
	ISI_R2Y_SET2_C6_Pos = 0x0
	// Bit mask of C6 field.
	ISI_R2Y_SET2_C6_Msk = 0xff
	// Position of C7 field.
	ISI_R2Y_SET2_C7_Pos = 0x8
	// Bit mask of C7 field.
	ISI_R2Y_SET2_C7_Msk = 0xff00
	// Position of C8 field.
	ISI_R2Y_SET2_C8_Pos = 0x10
	// Bit mask of C8 field.
	ISI_R2Y_SET2_C8_Msk = 0xff0000
	// Position of Boff field.
	ISI_R2Y_SET2_Boff_Pos = 0x18
	// Bit mask of Boff field.
	ISI_R2Y_SET2_Boff_Msk = 0x1000000
	// Bit Boff.
	ISI_R2Y_SET2_Boff = 0x1000000
)

// Bitfields for EMAC: Ethernet MAC 10/100
const (
	// NCR: Network Control Register
	// Position of LB field.
	EMAC_NCR_LB_Pos = 0x0
	// Bit mask of LB field.
	EMAC_NCR_LB_Msk = 0x1
	// Bit LB.
	EMAC_NCR_LB = 0x1
	// Position of LLB field.
	EMAC_NCR_LLB_Pos = 0x1
	// Bit mask of LLB field.
	EMAC_NCR_LLB_Msk = 0x2
	// Bit LLB.
	EMAC_NCR_LLB = 0x2
	// Position of RE field.
	EMAC_NCR_RE_Pos = 0x2
	// Bit mask of RE field.
	EMAC_NCR_RE_Msk = 0x4
	// Bit RE.
	EMAC_NCR_RE = 0x4
	// Position of TE field.
	EMAC_NCR_TE_Pos = 0x3
	// Bit mask of TE field.
	EMAC_NCR_TE_Msk = 0x8
	// Bit TE.
	EMAC_NCR_TE = 0x8
	// Position of MPE field.
	EMAC_NCR_MPE_Pos = 0x4
	// Bit mask of MPE field.
	EMAC_NCR_MPE_Msk = 0x10
	// Bit MPE.
	EMAC_NCR_MPE = 0x10
	// Position of CLRSTAT field.
	EMAC_NCR_CLRSTAT_Pos = 0x5
	// Bit mask of CLRSTAT field.
	EMAC_NCR_CLRSTAT_Msk = 0x20
	// Bit CLRSTAT.
	EMAC_NCR_CLRSTAT = 0x20
	// Position of INCSTAT field.
	EMAC_NCR_INCSTAT_Pos = 0x6
	// Bit mask of INCSTAT field.
	EMAC_NCR_INCSTAT_Msk = 0x40
	// Bit INCSTAT.
	EMAC_NCR_INCSTAT = 0x40
	// Position of WESTAT field.
	EMAC_NCR_WESTAT_Pos = 0x7
	// Bit mask of WESTAT field.
	EMAC_NCR_WESTAT_Msk = 0x80
	// Bit WESTAT.
	EMAC_NCR_WESTAT = 0x80
	// Position of BP field.
	EMAC_NCR_BP_Pos = 0x8
	// Bit mask of BP field.
	EMAC_NCR_BP_Msk = 0x100
	// Bit BP.
	EMAC_NCR_BP = 0x100
	// Position of TSTART field.
	EMAC_NCR_TSTART_Pos = 0x9
	// Bit mask of TSTART field.
	EMAC_NCR_TSTART_Msk = 0x200
	// Bit TSTART.
	EMAC_NCR_TSTART = 0x200
	// Position of THALT field.
	EMAC_NCR_THALT_Pos = 0xa
	// Bit mask of THALT field.
	EMAC_NCR_THALT_Msk = 0x400
	// Bit THALT.
	EMAC_NCR_THALT = 0x400

	// NCFGR: Network Configuration Register
	// Position of SPD field.
	EMAC_NCFGR_SPD_Pos = 0x0
	// Bit mask of SPD field.
	EMAC_NCFGR_SPD_Msk = 0x1
	// Bit SPD.
	EMAC_NCFGR_SPD = 0x1
	// Position of FD field.
	EMAC_NCFGR_FD_Pos = 0x1
	// Bit mask of FD field.
	EMAC_NCFGR_FD_Msk = 0x2
	// Bit FD.
	EMAC_NCFGR_FD = 0x2
	// Position of JFRAME field.
	EMAC_NCFGR_JFRAME_Pos = 0x3
	// Bit mask of JFRAME field.
	EMAC_NCFGR_JFRAME_Msk = 0x8
	// Bit JFRAME.
	EMAC_NCFGR_JFRAME = 0x8
	// Position of CAF field.
	EMAC_NCFGR_CAF_Pos = 0x4
	// Bit mask of CAF field.
	EMAC_NCFGR_CAF_Msk = 0x10
	// Bit CAF.
	EMAC_NCFGR_CAF = 0x10
	// Position of NBC field.
	EMAC_NCFGR_NBC_Pos = 0x5
	// Bit mask of NBC field.
	EMAC_NCFGR_NBC_Msk = 0x20
	// Bit NBC.
	EMAC_NCFGR_NBC = 0x20
	// Position of MTI field.
	EMAC_NCFGR_MTI_Pos = 0x6
	// Bit mask of MTI field.
	EMAC_NCFGR_MTI_Msk = 0x40
	// Bit MTI.
	EMAC_NCFGR_MTI = 0x40
	// Position of UNI field.
	EMAC_NCFGR_UNI_Pos = 0x7
	// Bit mask of UNI field.
	EMAC_NCFGR_UNI_Msk = 0x80
	// Bit UNI.
	EMAC_NCFGR_UNI = 0x80
	// Position of BIG field.
	EMAC_NCFGR_BIG_Pos = 0x8
	// Bit mask of BIG field.
	EMAC_NCFGR_BIG_Msk = 0x100
	// Bit BIG.
	EMAC_NCFGR_BIG = 0x100
	// Position of CLK field.
	EMAC_NCFGR_CLK_Pos = 0xa
	// Bit mask of CLK field.
	EMAC_NCFGR_CLK_Msk = 0xc00
	// MCK divided by 8 (MCK up to 20 MHz).
	EMAC_NCFGR_CLK_MCK_8 = 0x0
	// MCK divided by 16 (MCK up to 40 MHz).
	EMAC_NCFGR_CLK_MCK_16 = 0x1
	// MCK divided by 32 (MCK up to 80 MHz).
	EMAC_NCFGR_CLK_MCK_32 = 0x2
	// MCK divided by 64 (MCK up to 160 MHz).
	EMAC_NCFGR_CLK_MCK_64 = 0x3
	// Position of RTY field.
	EMAC_NCFGR_RTY_Pos = 0xc
	// Bit mask of RTY field.
	EMAC_NCFGR_RTY_Msk = 0x1000
	// Bit RTY.
	EMAC_NCFGR_RTY = 0x1000
	// Position of PAE field.
	EMAC_NCFGR_PAE_Pos = 0xd
	// Bit mask of PAE field.
	EMAC_NCFGR_PAE_Msk = 0x2000
	// Bit PAE.
	EMAC_NCFGR_PAE = 0x2000
	// Position of RBOF field.
	EMAC_NCFGR_RBOF_Pos = 0xe
	// Bit mask of RBOF field.
	EMAC_NCFGR_RBOF_Msk = 0xc000
	// No offset from start of receive buffer.
	EMAC_NCFGR_RBOF_OFFSET_0 = 0x0
	// One-byte offset from start of receive buffer.
	EMAC_NCFGR_RBOF_OFFSET_1 = 0x1
	// Two-byte offset from start of receive buffer.
	EMAC_NCFGR_RBOF_OFFSET_2 = 0x2
	// Three-byte offset from start of receive buffer.
	EMAC_NCFGR_RBOF_OFFSET_3 = 0x3
	// Position of RLCE field.
	EMAC_NCFGR_RLCE_Pos = 0x10
	// Bit mask of RLCE field.
	EMAC_NCFGR_RLCE_Msk = 0x10000
	// Bit RLCE.
	EMAC_NCFGR_RLCE = 0x10000
	// Position of DRFCS field.
	EMAC_NCFGR_DRFCS_Pos = 0x11
	// Bit mask of DRFCS field.
	EMAC_NCFGR_DRFCS_Msk = 0x20000
	// Bit DRFCS.
	EMAC_NCFGR_DRFCS = 0x20000
	// Position of EFRHD field.
	EMAC_NCFGR_EFRHD_Pos = 0x12
	// Bit mask of EFRHD field.
	EMAC_NCFGR_EFRHD_Msk = 0x40000
	// Bit EFRHD.
	EMAC_NCFGR_EFRHD = 0x40000
	// Position of IRXFCS field.
	EMAC_NCFGR_IRXFCS_Pos = 0x13
	// Bit mask of IRXFCS field.
	EMAC_NCFGR_IRXFCS_Msk = 0x80000
	// Bit IRXFCS.
	EMAC_NCFGR_IRXFCS = 0x80000

	// NSR: Network Status Register
	// Position of MDIO field.
	EMAC_NSR_MDIO_Pos = 0x1
	// Bit mask of MDIO field.
	EMAC_NSR_MDIO_Msk = 0x2
	// Bit MDIO.
	EMAC_NSR_MDIO = 0x2
	// Position of IDLE field.
	EMAC_NSR_IDLE_Pos = 0x2
	// Bit mask of IDLE field.
	EMAC_NSR_IDLE_Msk = 0x4
	// Bit IDLE.
	EMAC_NSR_IDLE = 0x4

	// TSR: Transmit Status Register
	// Position of UBR field.
	EMAC_TSR_UBR_Pos = 0x0
	// Bit mask of UBR field.
	EMAC_TSR_UBR_Msk = 0x1
	// Bit UBR.
	EMAC_TSR_UBR = 0x1
	// Position of COL field.
	EMAC_TSR_COL_Pos = 0x1
	// Bit mask of COL field.
	EMAC_TSR_COL_Msk = 0x2
	// Bit COL.
	EMAC_TSR_COL = 0x2
	// Position of RLES field.
	EMAC_TSR_RLES_Pos = 0x2
	// Bit mask of RLES field.
	EMAC_TSR_RLES_Msk = 0x4
	// Bit RLES.
	EMAC_TSR_RLES = 0x4
	// Position of TGO field.
	EMAC_TSR_TGO_Pos = 0x3
	// Bit mask of TGO field.
	EMAC_TSR_TGO_Msk = 0x8
	// Bit TGO.
	EMAC_TSR_TGO = 0x8
	// Position of BEX field.
	EMAC_TSR_BEX_Pos = 0x4
	// Bit mask of BEX field.
	EMAC_TSR_BEX_Msk = 0x10
	// Bit BEX.
	EMAC_TSR_BEX = 0x10
	// Position of COMP field.
	EMAC_TSR_COMP_Pos = 0x5
	// Bit mask of COMP field.
	EMAC_TSR_COMP_Msk = 0x20
	// Bit COMP.
	EMAC_TSR_COMP = 0x20
	// Position of UND field.
	EMAC_TSR_UND_Pos = 0x6
	// Bit mask of UND field.
	EMAC_TSR_UND_Msk = 0x40
	// Bit UND.
	EMAC_TSR_UND = 0x40

	// RBQP: Receive Buffer Queue Pointer Register
	// Position of ADDR field.
	EMAC_RBQP_ADDR_Pos = 0x2
	// Bit mask of ADDR field.
	EMAC_RBQP_ADDR_Msk = 0xfffffffc

	// TBQP: Transmit Buffer Queue Pointer Register
	// Position of ADDR field.
	EMAC_TBQP_ADDR_Pos = 0x2
	// Bit mask of ADDR field.
	EMAC_TBQP_ADDR_Msk = 0xfffffffc

	// RSR: Receive Status Register
	// Position of BNA field.
	EMAC_RSR_BNA_Pos = 0x0
	// Bit mask of BNA field.
	EMAC_RSR_BNA_Msk = 0x1
	// Bit BNA.
	EMAC_RSR_BNA = 0x1
	// Position of REC field.
	EMAC_RSR_REC_Pos = 0x1
	// Bit mask of REC field.
	EMAC_RSR_REC_Msk = 0x2
	// Bit REC.
	EMAC_RSR_REC = 0x2
	// Position of OVR field.
	EMAC_RSR_OVR_Pos = 0x2
	// Bit mask of OVR field.
	EMAC_RSR_OVR_Msk = 0x4
	// Bit OVR.
	EMAC_RSR_OVR = 0x4

	// ISR: Interrupt Status Register
	// Position of MFD field.
	EMAC_ISR_MFD_Pos = 0x0
	// Bit mask of MFD field.
	EMAC_ISR_MFD_Msk = 0x1
	// Bit MFD.
	EMAC_ISR_MFD = 0x1
	// Position of RCOMP field.
	EMAC_ISR_RCOMP_Pos = 0x1
	// Bit mask of RCOMP field.
	EMAC_ISR_RCOMP_Msk = 0x2
	// Bit RCOMP.
	EMAC_ISR_RCOMP = 0x2
	// Position of RXUBR field.
	EMAC_ISR_RXUBR_Pos = 0x2
	// Bit mask of RXUBR field.
	EMAC_ISR_RXUBR_Msk = 0x4
	// Bit RXUBR.
	EMAC_ISR_RXUBR = 0x4
	// Position of TXUBR field.
	EMAC_ISR_TXUBR_Pos = 0x3
	// Bit mask of TXUBR field.
	EMAC_ISR_TXUBR_Msk = 0x8
	// Bit TXUBR.
	EMAC_ISR_TXUBR = 0x8
	// Position of TUND field.
	EMAC_ISR_TUND_Pos = 0x4
	// Bit mask of TUND field.
	EMAC_ISR_TUND_Msk = 0x10
	// Bit TUND.
	EMAC_ISR_TUND = 0x10
	// Position of RLEX field.
	EMAC_ISR_RLEX_Pos = 0x5
	// Bit mask of RLEX field.
	EMAC_ISR_RLEX_Msk = 0x20
	// Bit RLEX.
	EMAC_ISR_RLEX = 0x20
	// Position of TXERR field.
	EMAC_ISR_TXERR_Pos = 0x6
	// Bit mask of TXERR field.
	EMAC_ISR_TXERR_Msk = 0x40
	// Bit TXERR.
	EMAC_ISR_TXERR = 0x40
	// Position of TCOMP field.
	EMAC_ISR_TCOMP_Pos = 0x7
	// Bit mask of TCOMP field.
	EMAC_ISR_TCOMP_Msk = 0x80
	// Bit TCOMP.
	EMAC_ISR_TCOMP = 0x80
	// Position of ROVR field.
	EMAC_ISR_ROVR_Pos = 0xa
	// Bit mask of ROVR field.
	EMAC_ISR_ROVR_Msk = 0x400
	// Bit ROVR.
	EMAC_ISR_ROVR = 0x400
	// Position of HRESP field.
	EMAC_ISR_HRESP_Pos = 0xb
	// Bit mask of HRESP field.
	EMAC_ISR_HRESP_Msk = 0x800
	// Bit HRESP.
	EMAC_ISR_HRESP = 0x800
	// Position of PFRE field.
	EMAC_ISR_PFRE_Pos = 0xc
	// Bit mask of PFRE field.
	EMAC_ISR_PFRE_Msk = 0x1000
	// Bit PFRE.
	EMAC_ISR_PFRE = 0x1000
	// Position of PTZ field.
	EMAC_ISR_PTZ_Pos = 0xd
	// Bit mask of PTZ field.
	EMAC_ISR_PTZ_Msk = 0x2000
	// Bit PTZ.
	EMAC_ISR_PTZ = 0x2000

	// IER: Interrupt Enable Register
	// Position of MFD field.
	EMAC_IER_MFD_Pos = 0x0
	// Bit mask of MFD field.
	EMAC_IER_MFD_Msk = 0x1
	// Bit MFD.
	EMAC_IER_MFD = 0x1
	// Position of RCOMP field.
	EMAC_IER_RCOMP_Pos = 0x1
	// Bit mask of RCOMP field.
	EMAC_IER_RCOMP_Msk = 0x2
	// Bit RCOMP.
	EMAC_IER_RCOMP = 0x2
	// Position of RXUBR field.
	EMAC_IER_RXUBR_Pos = 0x2
	// Bit mask of RXUBR field.
	EMAC_IER_RXUBR_Msk = 0x4
	// Bit RXUBR.
	EMAC_IER_RXUBR = 0x4
	// Position of TXUBR field.
	EMAC_IER_TXUBR_Pos = 0x3
	// Bit mask of TXUBR field.
	EMAC_IER_TXUBR_Msk = 0x8
	// Bit TXUBR.
	EMAC_IER_TXUBR = 0x8
	// Position of TUND field.
	EMAC_IER_TUND_Pos = 0x4
	// Bit mask of TUND field.
	EMAC_IER_TUND_Msk = 0x10
	// Bit TUND.
	EMAC_IER_TUND = 0x10
	// Position of RLE field.
	EMAC_IER_RLE_Pos = 0x5
	// Bit mask of RLE field.
	EMAC_IER_RLE_Msk = 0x20
	// Bit RLE.
	EMAC_IER_RLE = 0x20
	// Position of TXERR field.
	EMAC_IER_TXERR_Pos = 0x6
	// Bit mask of TXERR field.
	EMAC_IER_TXERR_Msk = 0x40
	// Bit TXERR.
	EMAC_IER_TXERR = 0x40
	// Position of TCOMP field.
	EMAC_IER_TCOMP_Pos = 0x7
	// Bit mask of TCOMP field.
	EMAC_IER_TCOMP_Msk = 0x80
	// Bit TCOMP.
	EMAC_IER_TCOMP = 0x80
	// Position of ROVR field.
	EMAC_IER_ROVR_Pos = 0xa
	// Bit mask of ROVR field.
	EMAC_IER_ROVR_Msk = 0x400
	// Bit ROVR.
	EMAC_IER_ROVR = 0x400
	// Position of HRESP field.
	EMAC_IER_HRESP_Pos = 0xb
	// Bit mask of HRESP field.
	EMAC_IER_HRESP_Msk = 0x800
	// Bit HRESP.
	EMAC_IER_HRESP = 0x800
	// Position of PFR field.
	EMAC_IER_PFR_Pos = 0xc
	// Bit mask of PFR field.
	EMAC_IER_PFR_Msk = 0x1000
	// Bit PFR.
	EMAC_IER_PFR = 0x1000
	// Position of PTZ field.
	EMAC_IER_PTZ_Pos = 0xd
	// Bit mask of PTZ field.
	EMAC_IER_PTZ_Msk = 0x2000
	// Bit PTZ.
	EMAC_IER_PTZ = 0x2000

	// IDR: Interrupt Disable Register
	// Position of MFD field.
	EMAC_IDR_MFD_Pos = 0x0
	// Bit mask of MFD field.
	EMAC_IDR_MFD_Msk = 0x1
	// Bit MFD.
	EMAC_IDR_MFD = 0x1
	// Position of RCOMP field.
	EMAC_IDR_RCOMP_Pos = 0x1
	// Bit mask of RCOMP field.
	EMAC_IDR_RCOMP_Msk = 0x2
	// Bit RCOMP.
	EMAC_IDR_RCOMP = 0x2
	// Position of RXUBR field.
	EMAC_IDR_RXUBR_Pos = 0x2
	// Bit mask of RXUBR field.
	EMAC_IDR_RXUBR_Msk = 0x4
	// Bit RXUBR.
	EMAC_IDR_RXUBR = 0x4
	// Position of TXUBR field.
	EMAC_IDR_TXUBR_Pos = 0x3
	// Bit mask of TXUBR field.
	EMAC_IDR_TXUBR_Msk = 0x8
	// Bit TXUBR.
	EMAC_IDR_TXUBR = 0x8
	// Position of TUND field.
	EMAC_IDR_TUND_Pos = 0x4
	// Bit mask of TUND field.
	EMAC_IDR_TUND_Msk = 0x10
	// Bit TUND.
	EMAC_IDR_TUND = 0x10
	// Position of RLE field.
	EMAC_IDR_RLE_Pos = 0x5
	// Bit mask of RLE field.
	EMAC_IDR_RLE_Msk = 0x20
	// Bit RLE.
	EMAC_IDR_RLE = 0x20
	// Position of TXERR field.
	EMAC_IDR_TXERR_Pos = 0x6
	// Bit mask of TXERR field.
	EMAC_IDR_TXERR_Msk = 0x40
	// Bit TXERR.
	EMAC_IDR_TXERR = 0x40
	// Position of TCOMP field.
	EMAC_IDR_TCOMP_Pos = 0x7
	// Bit mask of TCOMP field.
	EMAC_IDR_TCOMP_Msk = 0x80
	// Bit TCOMP.
	EMAC_IDR_TCOMP = 0x80
	// Position of ROVR field.
	EMAC_IDR_ROVR_Pos = 0xa
	// Bit mask of ROVR field.
	EMAC_IDR_ROVR_Msk = 0x400
	// Bit ROVR.
	EMAC_IDR_ROVR = 0x400
	// Position of HRESP field.
	EMAC_IDR_HRESP_Pos = 0xb
	// Bit mask of HRESP field.
	EMAC_IDR_HRESP_Msk = 0x800
	// Bit HRESP.
	EMAC_IDR_HRESP = 0x800
	// Position of PFR field.
	EMAC_IDR_PFR_Pos = 0xc
	// Bit mask of PFR field.
	EMAC_IDR_PFR_Msk = 0x1000
	// Bit PFR.
	EMAC_IDR_PFR = 0x1000
	// Position of PTZ field.
	EMAC_IDR_PTZ_Pos = 0xd
	// Bit mask of PTZ field.
	EMAC_IDR_PTZ_Msk = 0x2000
	// Bit PTZ.
	EMAC_IDR_PTZ = 0x2000

	// IMR: Interrupt Mask Register
	// Position of MFD field.
	EMAC_IMR_MFD_Pos = 0x0
	// Bit mask of MFD field.
	EMAC_IMR_MFD_Msk = 0x1
	// Bit MFD.
	EMAC_IMR_MFD = 0x1
	// Position of RCOMP field.
	EMAC_IMR_RCOMP_Pos = 0x1
	// Bit mask of RCOMP field.
	EMAC_IMR_RCOMP_Msk = 0x2
	// Bit RCOMP.
	EMAC_IMR_RCOMP = 0x2
	// Position of RXUBR field.
	EMAC_IMR_RXUBR_Pos = 0x2
	// Bit mask of RXUBR field.
	EMAC_IMR_RXUBR_Msk = 0x4
	// Bit RXUBR.
	EMAC_IMR_RXUBR = 0x4
	// Position of TXUBR field.
	EMAC_IMR_TXUBR_Pos = 0x3
	// Bit mask of TXUBR field.
	EMAC_IMR_TXUBR_Msk = 0x8
	// Bit TXUBR.
	EMAC_IMR_TXUBR = 0x8
	// Position of TUND field.
	EMAC_IMR_TUND_Pos = 0x4
	// Bit mask of TUND field.
	EMAC_IMR_TUND_Msk = 0x10
	// Bit TUND.
	EMAC_IMR_TUND = 0x10
	// Position of RLE field.
	EMAC_IMR_RLE_Pos = 0x5
	// Bit mask of RLE field.
	EMAC_IMR_RLE_Msk = 0x20
	// Bit RLE.
	EMAC_IMR_RLE = 0x20
	// Position of TXERR field.
	EMAC_IMR_TXERR_Pos = 0x6
	// Bit mask of TXERR field.
	EMAC_IMR_TXERR_Msk = 0x40
	// Bit TXERR.
	EMAC_IMR_TXERR = 0x40
	// Position of TCOMP field.
	EMAC_IMR_TCOMP_Pos = 0x7
	// Bit mask of TCOMP field.
	EMAC_IMR_TCOMP_Msk = 0x80
	// Bit TCOMP.
	EMAC_IMR_TCOMP = 0x80
	// Position of ROVR field.
	EMAC_IMR_ROVR_Pos = 0xa
	// Bit mask of ROVR field.
	EMAC_IMR_ROVR_Msk = 0x400
	// Bit ROVR.
	EMAC_IMR_ROVR = 0x400
	// Position of HRESP field.
	EMAC_IMR_HRESP_Pos = 0xb
	// Bit mask of HRESP field.
	EMAC_IMR_HRESP_Msk = 0x800
	// Bit HRESP.
	EMAC_IMR_HRESP = 0x800
	// Position of PFR field.
	EMAC_IMR_PFR_Pos = 0xc
	// Bit mask of PFR field.
	EMAC_IMR_PFR_Msk = 0x1000
	// Bit PFR.
	EMAC_IMR_PFR = 0x1000
	// Position of PTZ field.
	EMAC_IMR_PTZ_Pos = 0xd
	// Bit mask of PTZ field.
	EMAC_IMR_PTZ_Msk = 0x2000
	// Bit PTZ.
	EMAC_IMR_PTZ = 0x2000

	// MAN: Phy Maintenance Register
	// Position of DATA field.
	EMAC_MAN_DATA_Pos = 0x0
	// Bit mask of DATA field.
	EMAC_MAN_DATA_Msk = 0xffff
	// Position of CODE field.
	EMAC_MAN_CODE_Pos = 0x10
	// Bit mask of CODE field.
	EMAC_MAN_CODE_Msk = 0x30000
	// Position of REGA field.
	EMAC_MAN_REGA_Pos = 0x12
	// Bit mask of REGA field.
	EMAC_MAN_REGA_Msk = 0x7c0000
	// Position of PHYA field.
	EMAC_MAN_PHYA_Pos = 0x17
	// Bit mask of PHYA field.
	EMAC_MAN_PHYA_Msk = 0xf800000
	// Position of RW field.
	EMAC_MAN_RW_Pos = 0x1c
	// Bit mask of RW field.
	EMAC_MAN_RW_Msk = 0x30000000
	// Position of SOF field.
	EMAC_MAN_SOF_Pos = 0x1e
	// Bit mask of SOF field.
	EMAC_MAN_SOF_Msk = 0xc0000000

	// PTR: Pause Time Register
	// Position of PTIME field.
	EMAC_PTR_PTIME_Pos = 0x0
	// Bit mask of PTIME field.
	EMAC_PTR_PTIME_Msk = 0xffff

	// PFR: Pause Frames Received Register
	// Position of FROK field.
	EMAC_PFR_FROK_Pos = 0x0
	// Bit mask of FROK field.
	EMAC_PFR_FROK_Msk = 0xffff

	// FTO: Frames Transmitted Ok Register
	// Position of FTOK field.
	EMAC_FTO_FTOK_Pos = 0x0
	// Bit mask of FTOK field.
	EMAC_FTO_FTOK_Msk = 0xffffff

	// SCF: Single Collision Frames Register
	// Position of SCF field.
	EMAC_SCF_SCF_Pos = 0x0
	// Bit mask of SCF field.
	EMAC_SCF_SCF_Msk = 0xffff

	// MCF: Multiple Collision Frames Register
	// Position of MCF field.
	EMAC_MCF_MCF_Pos = 0x0
	// Bit mask of MCF field.
	EMAC_MCF_MCF_Msk = 0xffff

	// FRO: Frames Received Ok Register
	// Position of FROK field.
	EMAC_FRO_FROK_Pos = 0x0
	// Bit mask of FROK field.
	EMAC_FRO_FROK_Msk = 0xffffff

	// FCSE: Frame Check Sequence Errors Register
	// Position of FCSE field.
	EMAC_FCSE_FCSE_Pos = 0x0
	// Bit mask of FCSE field.
	EMAC_FCSE_FCSE_Msk = 0xff

	// ALE: Alignment Errors Register
	// Position of ALE field.
	EMAC_ALE_ALE_Pos = 0x0
	// Bit mask of ALE field.
	EMAC_ALE_ALE_Msk = 0xff

	// DTF: Deferred Transmission Frames Register
	// Position of DTF field.
	EMAC_DTF_DTF_Pos = 0x0
	// Bit mask of DTF field.
	EMAC_DTF_DTF_Msk = 0xffff

	// LCOL: Late Collisions Register
	// Position of LCOL field.
	EMAC_LCOL_LCOL_Pos = 0x0
	// Bit mask of LCOL field.
	EMAC_LCOL_LCOL_Msk = 0xff

	// ECOL: Excessive Collisions Register
	// Position of EXCOL field.
	EMAC_ECOL_EXCOL_Pos = 0x0
	// Bit mask of EXCOL field.
	EMAC_ECOL_EXCOL_Msk = 0xff

	// TUND: Transmit Underrun Errors Register
	// Position of TUND field.
	EMAC_TUND_TUND_Pos = 0x0
	// Bit mask of TUND field.
	EMAC_TUND_TUND_Msk = 0xff

	// CSE: Carrier Sense Errors Register
	// Position of CSE field.
	EMAC_CSE_CSE_Pos = 0x0
	// Bit mask of CSE field.
	EMAC_CSE_CSE_Msk = 0xff

	// RRE: Receive Resource Errors Register
	// Position of RRE field.
	EMAC_RRE_RRE_Pos = 0x0
	// Bit mask of RRE field.
	EMAC_RRE_RRE_Msk = 0xffff

	// ROV: Receive Overrun Errors Register
	// Position of ROVR field.
	EMAC_ROV_ROVR_Pos = 0x0
	// Bit mask of ROVR field.
	EMAC_ROV_ROVR_Msk = 0xff

	// RSE: Receive Symbol Errors Register
	// Position of RSE field.
	EMAC_RSE_RSE_Pos = 0x0
	// Bit mask of RSE field.
	EMAC_RSE_RSE_Msk = 0xff

	// ELE: Excessive Length Errors Register
	// Position of EXL field.
	EMAC_ELE_EXL_Pos = 0x0
	// Bit mask of EXL field.
	EMAC_ELE_EXL_Msk = 0xff

	// RJA: Receive Jabbers Register
	// Position of RJB field.
	EMAC_RJA_RJB_Pos = 0x0
	// Bit mask of RJB field.
	EMAC_RJA_RJB_Msk = 0xff

	// USF: Undersize Frames Register
	// Position of USF field.
	EMAC_USF_USF_Pos = 0x0
	// Bit mask of USF field.
	EMAC_USF_USF_Msk = 0xff

	// STE: SQE Test Errors Register
	// Position of SQER field.
	EMAC_STE_SQER_Pos = 0x0
	// Bit mask of SQER field.
	EMAC_STE_SQER_Msk = 0xff

	// RLE: Received Length Field Mismatch Register
	// Position of RLFM field.
	EMAC_RLE_RLFM_Pos = 0x0
	// Bit mask of RLFM field.
	EMAC_RLE_RLFM_Msk = 0xff

	// HRB: Hash Register Bottom [31:0] Register
	// Position of ADDR field.
	EMAC_HRB_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	EMAC_HRB_ADDR_Msk = 0xffffffff

	// HRT: Hash Register Top [63:32] Register
	// Position of ADDR field.
	EMAC_HRT_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	EMAC_HRT_ADDR_Msk = 0xffffffff

	// SA1B: Specific Address 1 Bottom Register
	// Position of ADDR field.
	EMAC_SA1B_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	EMAC_SA1B_ADDR_Msk = 0xffffffff

	// SA1T: Specific Address 1 Top Register
	// Position of ADDR field.
	EMAC_SA1T_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	EMAC_SA1T_ADDR_Msk = 0xffff

	// SA2B: Specific Address 2 Bottom Register
	// Position of ADDR field.
	EMAC_SA2B_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	EMAC_SA2B_ADDR_Msk = 0xffffffff

	// SA2T: Specific Address 2 Top Register
	// Position of ADDR field.
	EMAC_SA2T_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	EMAC_SA2T_ADDR_Msk = 0xffff

	// SA3B: Specific Address 3 Bottom Register
	// Position of ADDR field.
	EMAC_SA3B_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	EMAC_SA3B_ADDR_Msk = 0xffffffff

	// SA3T: Specific Address 3 Top Register
	// Position of ADDR field.
	EMAC_SA3T_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	EMAC_SA3T_ADDR_Msk = 0xffff

	// SA4B: Specific Address 4 Bottom Register
	// Position of ADDR field.
	EMAC_SA4B_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	EMAC_SA4B_ADDR_Msk = 0xffffffff

	// SA4T: Specific Address 4 Top Register
	// Position of ADDR field.
	EMAC_SA4T_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	EMAC_SA4T_ADDR_Msk = 0xffff

	// TID: Type ID Checking Register
	// Position of TID field.
	EMAC_TID_TID_Pos = 0x0
	// Bit mask of TID field.
	EMAC_TID_TID_Msk = 0xffff

	// USRIO: User Input/Output Register
	// Position of RMII field.
	EMAC_USRIO_RMII_Pos = 0x0
	// Bit mask of RMII field.
	EMAC_USRIO_RMII_Msk = 0x1
	// Bit RMII.
	EMAC_USRIO_RMII = 0x1
	// Position of CLKEN field.
	EMAC_USRIO_CLKEN_Pos = 0x1
	// Bit mask of CLKEN field.
	EMAC_USRIO_CLKEN_Msk = 0x2
	// Bit CLKEN.
	EMAC_USRIO_CLKEN = 0x2
)

// Bitfields for SPI0: Serial Peripheral Interface 0
const (
	// CR: Control Register
	// Position of SPIEN field.
	SPI_CR_SPIEN_Pos = 0x0
	// Bit mask of SPIEN field.
	SPI_CR_SPIEN_Msk = 0x1
	// Bit SPIEN.
	SPI_CR_SPIEN = 0x1
	// Position of SPIDIS field.
	SPI_CR_SPIDIS_Pos = 0x1
	// Bit mask of SPIDIS field.
	SPI_CR_SPIDIS_Msk = 0x2
	// Bit SPIDIS.
	SPI_CR_SPIDIS = 0x2
	// Position of SWRST field.
	SPI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	SPI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	SPI_CR_SWRST = 0x80
	// Position of LASTXFER field.
	SPI_CR_LASTXFER_Pos = 0x18
	// Bit mask of LASTXFER field.
	SPI_CR_LASTXFER_Msk = 0x1000000
	// Bit LASTXFER.
	SPI_CR_LASTXFER = 0x1000000

	// MR: Mode Register
	// Position of MSTR field.
	SPI_MR_MSTR_Pos = 0x0
	// Bit mask of MSTR field.
	SPI_MR_MSTR_Msk = 0x1
	// Bit MSTR.
	SPI_MR_MSTR = 0x1
	// Position of PS field.
	SPI_MR_PS_Pos = 0x1
	// Bit mask of PS field.
	SPI_MR_PS_Msk = 0x2
	// Bit PS.
	SPI_MR_PS = 0x2
	// Position of PCSDEC field.
	SPI_MR_PCSDEC_Pos = 0x2
	// Bit mask of PCSDEC field.
	SPI_MR_PCSDEC_Msk = 0x4
	// Bit PCSDEC.
	SPI_MR_PCSDEC = 0x4
	// Position of MODFDIS field.
	SPI_MR_MODFDIS_Pos = 0x4
	// Bit mask of MODFDIS field.
	SPI_MR_MODFDIS_Msk = 0x10
	// Bit MODFDIS.
	SPI_MR_MODFDIS = 0x10
	// Position of WDRBT field.
	SPI_MR_WDRBT_Pos = 0x5
	// Bit mask of WDRBT field.
	SPI_MR_WDRBT_Msk = 0x20
	// Bit WDRBT.
	SPI_MR_WDRBT = 0x20
	// Position of LLB field.
	SPI_MR_LLB_Pos = 0x7
	// Bit mask of LLB field.
	SPI_MR_LLB_Msk = 0x80
	// Bit LLB.
	SPI_MR_LLB = 0x80
	// Position of PCS field.
	SPI_MR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_MR_PCS_Msk = 0xf0000
	// Position of DLYBCS field.
	SPI_MR_DLYBCS_Pos = 0x18
	// Bit mask of DLYBCS field.
	SPI_MR_DLYBCS_Msk = 0xff000000

	// RDR: Receive Data Register
	// Position of RD field.
	SPI_RDR_RD_Pos = 0x0
	// Bit mask of RD field.
	SPI_RDR_RD_Msk = 0xffff
	// Position of PCS field.
	SPI_RDR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_RDR_PCS_Msk = 0xf0000

	// TDR: Transmit Data Register
	// Position of TD field.
	SPI_TDR_TD_Pos = 0x0
	// Bit mask of TD field.
	SPI_TDR_TD_Msk = 0xffff
	// Position of PCS field.
	SPI_TDR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_TDR_PCS_Msk = 0xf0000
	// Position of LASTXFER field.
	SPI_TDR_LASTXFER_Pos = 0x18
	// Bit mask of LASTXFER field.
	SPI_TDR_LASTXFER_Msk = 0x1000000
	// Bit LASTXFER.
	SPI_TDR_LASTXFER = 0x1000000

	// SR: Status Register
	// Position of RDRF field.
	SPI_SR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_SR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_SR_RDRF = 0x1
	// Position of TDRE field.
	SPI_SR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_SR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_SR_TDRE = 0x2
	// Position of MODF field.
	SPI_SR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_SR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_SR_MODF = 0x4
	// Position of OVRES field.
	SPI_SR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_SR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_SR_OVRES = 0x8
	// Position of NSSR field.
	SPI_SR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_SR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_SR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_SR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_SR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_SR_TXEMPTY = 0x200
	// Position of SPIENS field.
	SPI_SR_SPIENS_Pos = 0x10
	// Bit mask of SPIENS field.
	SPI_SR_SPIENS_Msk = 0x10000
	// Bit SPIENS.
	SPI_SR_SPIENS = 0x10000

	// IER: Interrupt Enable Register
	// Position of RDRF field.
	SPI_IER_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IER_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IER_RDRF = 0x1
	// Position of TDRE field.
	SPI_IER_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IER_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IER_TDRE = 0x2
	// Position of MODF field.
	SPI_IER_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IER_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IER_MODF = 0x4
	// Position of OVRES field.
	SPI_IER_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IER_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IER_OVRES = 0x8
	// Position of NSSR field.
	SPI_IER_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IER_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IER_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IER_TXEMPTY = 0x200

	// IDR: Interrupt Disable Register
	// Position of RDRF field.
	SPI_IDR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IDR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IDR_RDRF = 0x1
	// Position of TDRE field.
	SPI_IDR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IDR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IDR_TDRE = 0x2
	// Position of MODF field.
	SPI_IDR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IDR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IDR_MODF = 0x4
	// Position of OVRES field.
	SPI_IDR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IDR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IDR_OVRES = 0x8
	// Position of NSSR field.
	SPI_IDR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IDR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IDR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IDR_TXEMPTY = 0x200

	// IMR: Interrupt Mask Register
	// Position of RDRF field.
	SPI_IMR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IMR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IMR_RDRF = 0x1
	// Position of TDRE field.
	SPI_IMR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IMR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IMR_TDRE = 0x2
	// Position of MODF field.
	SPI_IMR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IMR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IMR_MODF = 0x4
	// Position of OVRES field.
	SPI_IMR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IMR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IMR_OVRES = 0x8
	// Position of NSSR field.
	SPI_IMR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IMR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IMR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IMR_TXEMPTY = 0x200

	// CSR: Chip Select Register
	// Position of CPOL field.
	SPI_CSR_CPOL_Pos = 0x0
	// Bit mask of CPOL field.
	SPI_CSR_CPOL_Msk = 0x1
	// Bit CPOL.
	SPI_CSR_CPOL = 0x1
	// Position of NCPHA field.
	SPI_CSR_NCPHA_Pos = 0x1
	// Bit mask of NCPHA field.
	SPI_CSR_NCPHA_Msk = 0x2
	// Bit NCPHA.
	SPI_CSR_NCPHA = 0x2
	// Position of CSAAT field.
	SPI_CSR_CSAAT_Pos = 0x3
	// Bit mask of CSAAT field.
	SPI_CSR_CSAAT_Msk = 0x8
	// Bit CSAAT.
	SPI_CSR_CSAAT = 0x8
	// Position of BITS field.
	SPI_CSR_BITS_Pos = 0x4
	// Bit mask of BITS field.
	SPI_CSR_BITS_Msk = 0xf0
	// 8 bits for transfer
	SPI_CSR_BITS_8_BIT = 0x0
	// 9 bits for transfer
	SPI_CSR_BITS_9_BIT = 0x1
	// 10 bits for transfer
	SPI_CSR_BITS_10_BIT = 0x2
	// 11 bits for transfer
	SPI_CSR_BITS_11_BIT = 0x3
	// 12 bits for transfer
	SPI_CSR_BITS_12_BIT = 0x4
	// 13 bits for transfer
	SPI_CSR_BITS_13_BIT = 0x5
	// 14 bits for transfer
	SPI_CSR_BITS_14_BIT = 0x6
	// 15 bits for transfer
	SPI_CSR_BITS_15_BIT = 0x7
	// 16 bits for transfer
	SPI_CSR_BITS_16_BIT = 0x8
	// Position of SCBR field.
	SPI_CSR_SCBR_Pos = 0x8
	// Bit mask of SCBR field.
	SPI_CSR_SCBR_Msk = 0xff00
	// Position of DLYBS field.
	SPI_CSR_DLYBS_Pos = 0x10
	// Bit mask of DLYBS field.
	SPI_CSR_DLYBS_Msk = 0xff0000
	// Position of DLYBCT field.
	SPI_CSR_DLYBCT_Pos = 0x18
	// Bit mask of DLYBCT field.
	SPI_CSR_DLYBCT_Msk = 0xff000000

	// WPMR: Write Protection Control Register
	// Position of WPEN field.
	SPI_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	SPI_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	SPI_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	SPI_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	SPI_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protection Status Register
	// Position of WPVS field.
	SPI_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	SPI_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	SPI_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	SPI_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	SPI_WPSR_WPVSRC_Msk = 0xff00

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	SPI_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	SPI_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	SPI_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	SPI_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	SPI_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	SPI_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	SPI_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	SPI_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	SPI_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	SPI_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	SPI_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	SPI_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	SPI_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	SPI_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	SPI_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	SPI_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	SPI_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	SPI_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	SPI_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	SPI_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	SPI_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	SPI_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	SPI_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	SPI_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	SPI_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	SPI_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	SPI_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	SPI_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	SPI_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	SPI_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	SPI_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	SPI_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	SPI_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	SPI_PTSR_TXTEN = 0x100
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// CR: Control Register
	// Position of SWRST field.
	ADC_CR_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	ADC_CR_SWRST_Msk = 0x1
	// Bit SWRST.
	ADC_CR_SWRST = 0x1
	// Position of START field.
	ADC_CR_START_Pos = 0x1
	// Bit mask of START field.
	ADC_CR_START_Msk = 0x2
	// Bit START.
	ADC_CR_START = 0x2

	// MR: Mode Register
	// Position of TRGEN field.
	ADC_MR_TRGEN_Pos = 0x0
	// Bit mask of TRGEN field.
	ADC_MR_TRGEN_Msk = 0x1
	// Bit TRGEN.
	ADC_MR_TRGEN = 0x1
	// Hardware triggers are disabled. Starting a conversion is only possible by software.
	ADC_MR_TRGEN_DIS = 0x0
	// Hardware trigger selected by TRGSEL field is enabled.
	ADC_MR_TRGEN_EN = 0x1
	// Position of TRGSEL field.
	ADC_MR_TRGSEL_Pos = 0x1
	// Bit mask of TRGSEL field.
	ADC_MR_TRGSEL_Msk = 0xe
	// ADC_TRIG0
	ADC_MR_TRGSEL_ADC_TRIG0 = 0x0
	// ADC_TRIG1
	ADC_MR_TRGSEL_ADC_TRIG1 = 0x1
	// ADC_TRIG2
	ADC_MR_TRGSEL_ADC_TRIG2 = 0x2
	// ADC_TRIG3
	ADC_MR_TRGSEL_ADC_TRIG3 = 0x3
	// ADC_TRIG4
	ADC_MR_TRGSEL_ADC_TRIG4 = 0x4
	// ADC_TRIG5
	ADC_MR_TRGSEL_ADC_TRIG5 = 0x5
	// ADC_TRIG6
	ADC_MR_TRGSEL_ADC_TRIG6 = 0x6
	// Position of LOWRES field.
	ADC_MR_LOWRES_Pos = 0x4
	// Bit mask of LOWRES field.
	ADC_MR_LOWRES_Msk = 0x10
	// Bit LOWRES.
	ADC_MR_LOWRES = 0x10
	// 10-bit resolution
	ADC_MR_LOWRES_BITS_10 = 0x0
	// 8-bit resolution
	ADC_MR_LOWRES_BITS_8 = 0x1
	// Position of SLEEP field.
	ADC_MR_SLEEP_Pos = 0x5
	// Bit mask of SLEEP field.
	ADC_MR_SLEEP_Msk = 0x20
	// Bit SLEEP.
	ADC_MR_SLEEP = 0x20
	// Normal Mode: The ADC Core and reference voltage circuitry are kept ON between conversions
	ADC_MR_SLEEP_NORMAL = 0x0
	// Sleep Mode: The ADC Core and reference voltage circuitry are OFF between conversions
	ADC_MR_SLEEP_SLEEP = 0x1
	// Position of FWUP field.
	ADC_MR_FWUP_Pos = 0x6
	// Bit mask of FWUP field.
	ADC_MR_FWUP_Msk = 0x40
	// Bit FWUP.
	ADC_MR_FWUP = 0x40
	// Normal Sleep Mode: The sleep mode is defined by the SLEEP bit
	ADC_MR_FWUP_OFF = 0x0
	// Fast Wake Up Sleep Mode: The Voltage reference is ON between conversions and ADC Core is OFF
	ADC_MR_FWUP_ON = 0x1
	// Position of FREERUN field.
	ADC_MR_FREERUN_Pos = 0x7
	// Bit mask of FREERUN field.
	ADC_MR_FREERUN_Msk = 0x80
	// Bit FREERUN.
	ADC_MR_FREERUN = 0x80
	// Normal Mode
	ADC_MR_FREERUN_OFF = 0x0
	// Free Run Mode: Never wait for any trigger.
	ADC_MR_FREERUN_ON = 0x1
	// Position of PRESCAL field.
	ADC_MR_PRESCAL_Pos = 0x8
	// Bit mask of PRESCAL field.
	ADC_MR_PRESCAL_Msk = 0xff00
	// Position of STARTUP field.
	ADC_MR_STARTUP_Pos = 0x10
	// Bit mask of STARTUP field.
	ADC_MR_STARTUP_Msk = 0xf0000
	// 0 periods of ADCClock
	ADC_MR_STARTUP_SUT0 = 0x0
	// 8 periods of ADCClock
	ADC_MR_STARTUP_SUT8 = 0x1
	// 16 periods of ADCClock
	ADC_MR_STARTUP_SUT16 = 0x2
	// 24 periods of ADCClock
	ADC_MR_STARTUP_SUT24 = 0x3
	// 64 periods of ADCClock
	ADC_MR_STARTUP_SUT64 = 0x4
	// 80 periods of ADCClock
	ADC_MR_STARTUP_SUT80 = 0x5
	// 96 periods of ADCClock
	ADC_MR_STARTUP_SUT96 = 0x6
	// 112 periods of ADCClock
	ADC_MR_STARTUP_SUT112 = 0x7
	// 512 periods of ADCClock
	ADC_MR_STARTUP_SUT512 = 0x8
	// 576 periods of ADCClock
	ADC_MR_STARTUP_SUT576 = 0x9
	// 640 periods of ADCClock
	ADC_MR_STARTUP_SUT640 = 0xa
	// 704 periods of ADCClock
	ADC_MR_STARTUP_SUT704 = 0xb
	// 768 periods of ADCClock
	ADC_MR_STARTUP_SUT768 = 0xc
	// 832 periods of ADCClock
	ADC_MR_STARTUP_SUT832 = 0xd
	// 896 periods of ADCClock
	ADC_MR_STARTUP_SUT896 = 0xe
	// 960 periods of ADCClock
	ADC_MR_STARTUP_SUT960 = 0xf
	// Position of TRACKTIM field.
	ADC_MR_TRACKTIM_Pos = 0x18
	// Bit mask of TRACKTIM field.
	ADC_MR_TRACKTIM_Msk = 0xf000000
	// Position of USEQ field.
	ADC_MR_USEQ_Pos = 0x1f
	// Bit mask of USEQ field.
	ADC_MR_USEQ_Msk = 0x80000000
	// Bit USEQ.
	ADC_MR_USEQ = 0x80000000
	// Normal Mode: The controller converts channels in a simple numeric order depending only on the channel index.
	ADC_MR_USEQ_NUM_ORDER = 0x0
	// User Sequence Mode: The sequence respects what is defined in ADC_SEQR1 and ADC_SEQR2 registers and can be used to convert several times the same channel.
	ADC_MR_USEQ_REG_ORDER = 0x1

	// SEQR1: Channel Sequence Register 1
	// Position of USCH1 field.
	ADC_SEQR1_USCH1_Pos = 0x0
	// Bit mask of USCH1 field.
	ADC_SEQR1_USCH1_Msk = 0xf
	// Position of USCH2 field.
	ADC_SEQR1_USCH2_Pos = 0x4
	// Bit mask of USCH2 field.
	ADC_SEQR1_USCH2_Msk = 0xf0
	// Position of USCH3 field.
	ADC_SEQR1_USCH3_Pos = 0x8
	// Bit mask of USCH3 field.
	ADC_SEQR1_USCH3_Msk = 0xf00
	// Position of USCH4 field.
	ADC_SEQR1_USCH4_Pos = 0xc
	// Bit mask of USCH4 field.
	ADC_SEQR1_USCH4_Msk = 0xf000
	// Position of USCH5 field.
	ADC_SEQR1_USCH5_Pos = 0x10
	// Bit mask of USCH5 field.
	ADC_SEQR1_USCH5_Msk = 0xf0000
	// Position of USCH6 field.
	ADC_SEQR1_USCH6_Pos = 0x14
	// Bit mask of USCH6 field.
	ADC_SEQR1_USCH6_Msk = 0xf00000
	// Position of USCH7 field.
	ADC_SEQR1_USCH7_Pos = 0x18
	// Bit mask of USCH7 field.
	ADC_SEQR1_USCH7_Msk = 0xf000000
	// Position of USCH8 field.
	ADC_SEQR1_USCH8_Pos = 0x1c
	// Bit mask of USCH8 field.
	ADC_SEQR1_USCH8_Msk = 0xf0000000

	// SEQR2: Channel Sequence Register 2
	// Position of USCH9 field.
	ADC_SEQR2_USCH9_Pos = 0x0
	// Bit mask of USCH9 field.
	ADC_SEQR2_USCH9_Msk = 0xf
	// Position of USCH10 field.
	ADC_SEQR2_USCH10_Pos = 0x4
	// Bit mask of USCH10 field.
	ADC_SEQR2_USCH10_Msk = 0xf0
	// Position of USCH11 field.
	ADC_SEQR2_USCH11_Pos = 0x8
	// Bit mask of USCH11 field.
	ADC_SEQR2_USCH11_Msk = 0xf00
	// Position of USCH12 field.
	ADC_SEQR2_USCH12_Pos = 0xc
	// Bit mask of USCH12 field.
	ADC_SEQR2_USCH12_Msk = 0xf000
	// Position of USCH13 field.
	ADC_SEQR2_USCH13_Pos = 0x10
	// Bit mask of USCH13 field.
	ADC_SEQR2_USCH13_Msk = 0xf0000
	// Position of USCH14 field.
	ADC_SEQR2_USCH14_Pos = 0x14
	// Bit mask of USCH14 field.
	ADC_SEQR2_USCH14_Msk = 0xf00000
	// Position of USCH15 field.
	ADC_SEQR2_USCH15_Pos = 0x18
	// Bit mask of USCH15 field.
	ADC_SEQR2_USCH15_Msk = 0xf000000
	// Position of USCH16 field.
	ADC_SEQR2_USCH16_Pos = 0x1c
	// Bit mask of USCH16 field.
	ADC_SEQR2_USCH16_Msk = 0xf0000000

	// CHER: Channel Enable Register
	// Position of CH0 field.
	ADC_CHER_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC_CHER_CH0_Msk = 0x1
	// Bit CH0.
	ADC_CHER_CH0 = 0x1
	// Position of CH1 field.
	ADC_CHER_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC_CHER_CH1_Msk = 0x2
	// Bit CH1.
	ADC_CHER_CH1 = 0x2
	// Position of CH2 field.
	ADC_CHER_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC_CHER_CH2_Msk = 0x4
	// Bit CH2.
	ADC_CHER_CH2 = 0x4
	// Position of CH3 field.
	ADC_CHER_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC_CHER_CH3_Msk = 0x8
	// Bit CH3.
	ADC_CHER_CH3 = 0x8

	// CHDR: Channel Disable Register
	// Position of CH0 field.
	ADC_CHDR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC_CHDR_CH0_Msk = 0x1
	// Bit CH0.
	ADC_CHDR_CH0 = 0x1
	// Position of CH1 field.
	ADC_CHDR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC_CHDR_CH1_Msk = 0x2
	// Bit CH1.
	ADC_CHDR_CH1 = 0x2
	// Position of CH2 field.
	ADC_CHDR_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC_CHDR_CH2_Msk = 0x4
	// Bit CH2.
	ADC_CHDR_CH2 = 0x4
	// Position of CH3 field.
	ADC_CHDR_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC_CHDR_CH3_Msk = 0x8
	// Bit CH3.
	ADC_CHDR_CH3 = 0x8

	// CHSR: Channel Status Register
	// Position of CH0 field.
	ADC_CHSR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC_CHSR_CH0_Msk = 0x1
	// Bit CH0.
	ADC_CHSR_CH0 = 0x1
	// Position of CH1 field.
	ADC_CHSR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC_CHSR_CH1_Msk = 0x2
	// Bit CH1.
	ADC_CHSR_CH1 = 0x2
	// Position of CH2 field.
	ADC_CHSR_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC_CHSR_CH2_Msk = 0x4
	// Bit CH2.
	ADC_CHSR_CH2 = 0x4
	// Position of CH3 field.
	ADC_CHSR_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC_CHSR_CH3_Msk = 0x8
	// Bit CH3.
	ADC_CHSR_CH3 = 0x8

	// LCDR: Last Converted Data Register
	// Position of LDATA field.
	ADC_LCDR_LDATA_Pos = 0x0
	// Bit mask of LDATA field.
	ADC_LCDR_LDATA_Msk = 0xfff
	// Position of CHNB field.
	ADC_LCDR_CHNB_Pos = 0xc
	// Bit mask of CHNB field.
	ADC_LCDR_CHNB_Msk = 0xf000

	// IER: Interrupt Enable Register
	// Position of EOC0 field.
	ADC_IER_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_IER_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_IER_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_IER_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_IER_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_IER_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_IER_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_IER_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_IER_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_IER_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_IER_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_IER_EOC3 = 0x8
	// Position of DRDY field.
	ADC_IER_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_IER_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_IER_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_IER_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_IER_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_IER_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_IER_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_IER_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_IER_COMPE = 0x4000000
	// Position of ENDRX field.
	ADC_IER_ENDRX_Pos = 0x1b
	// Bit mask of ENDRX field.
	ADC_IER_ENDRX_Msk = 0x8000000
	// Bit ENDRX.
	ADC_IER_ENDRX = 0x8000000
	// Position of RXBUFF field.
	ADC_IER_RXBUFF_Pos = 0x1c
	// Bit mask of RXBUFF field.
	ADC_IER_RXBUFF_Msk = 0x10000000
	// Bit RXBUFF.
	ADC_IER_RXBUFF = 0x10000000

	// IDR: Interrupt Disable Register
	// Position of EOC0 field.
	ADC_IDR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_IDR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_IDR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_IDR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_IDR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_IDR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_IDR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_IDR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_IDR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_IDR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_IDR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_IDR_EOC3 = 0x8
	// Position of DRDY field.
	ADC_IDR_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_IDR_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_IDR_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_IDR_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_IDR_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_IDR_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_IDR_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_IDR_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_IDR_COMPE = 0x4000000
	// Position of ENDRX field.
	ADC_IDR_ENDRX_Pos = 0x1b
	// Bit mask of ENDRX field.
	ADC_IDR_ENDRX_Msk = 0x8000000
	// Bit ENDRX.
	ADC_IDR_ENDRX = 0x8000000
	// Position of RXBUFF field.
	ADC_IDR_RXBUFF_Pos = 0x1c
	// Bit mask of RXBUFF field.
	ADC_IDR_RXBUFF_Msk = 0x10000000
	// Bit RXBUFF.
	ADC_IDR_RXBUFF = 0x10000000

	// IMR: Interrupt Mask Register
	// Position of EOC0 field.
	ADC_IMR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_IMR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_IMR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_IMR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_IMR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_IMR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_IMR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_IMR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_IMR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_IMR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_IMR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_IMR_EOC3 = 0x8
	// Position of DRDY field.
	ADC_IMR_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_IMR_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_IMR_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_IMR_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_IMR_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_IMR_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_IMR_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_IMR_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_IMR_COMPE = 0x4000000
	// Position of ENDRX field.
	ADC_IMR_ENDRX_Pos = 0x1b
	// Bit mask of ENDRX field.
	ADC_IMR_ENDRX_Msk = 0x8000000
	// Bit ENDRX.
	ADC_IMR_ENDRX = 0x8000000
	// Position of RXBUFF field.
	ADC_IMR_RXBUFF_Pos = 0x1c
	// Bit mask of RXBUFF field.
	ADC_IMR_RXBUFF_Msk = 0x10000000
	// Bit RXBUFF.
	ADC_IMR_RXBUFF = 0x10000000

	// ISR: Interrupt Status Register
	// Position of EOC0 field.
	ADC_ISR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_ISR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_ISR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_ISR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_ISR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_ISR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_ISR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_ISR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_ISR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_ISR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_ISR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_ISR_EOC3 = 0x8
	// Position of DRDY field.
	ADC_ISR_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_ISR_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_ISR_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_ISR_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_ISR_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_ISR_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_ISR_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_ISR_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_ISR_COMPE = 0x4000000
	// Position of ENDRX field.
	ADC_ISR_ENDRX_Pos = 0x1b
	// Bit mask of ENDRX field.
	ADC_ISR_ENDRX_Msk = 0x8000000
	// Bit ENDRX.
	ADC_ISR_ENDRX = 0x8000000
	// Position of RXBUFF field.
	ADC_ISR_RXBUFF_Pos = 0x1c
	// Bit mask of RXBUFF field.
	ADC_ISR_RXBUFF_Msk = 0x10000000
	// Bit RXBUFF.
	ADC_ISR_RXBUFF = 0x10000000

	// OVER: Overrun Status Register
	// Position of OVRE0 field.
	ADC_OVER_OVRE0_Pos = 0x0
	// Bit mask of OVRE0 field.
	ADC_OVER_OVRE0_Msk = 0x1
	// Bit OVRE0.
	ADC_OVER_OVRE0 = 0x1
	// Position of OVRE1 field.
	ADC_OVER_OVRE1_Pos = 0x1
	// Bit mask of OVRE1 field.
	ADC_OVER_OVRE1_Msk = 0x2
	// Bit OVRE1.
	ADC_OVER_OVRE1 = 0x2
	// Position of OVRE2 field.
	ADC_OVER_OVRE2_Pos = 0x2
	// Bit mask of OVRE2 field.
	ADC_OVER_OVRE2_Msk = 0x4
	// Bit OVRE2.
	ADC_OVER_OVRE2 = 0x4
	// Position of OVRE3 field.
	ADC_OVER_OVRE3_Pos = 0x3
	// Bit mask of OVRE3 field.
	ADC_OVER_OVRE3_Msk = 0x8
	// Bit OVRE3.
	ADC_OVER_OVRE3 = 0x8

	// EMR: Extended Mode Register
	// Position of CMPMODE field.
	ADC_EMR_CMPMODE_Pos = 0x0
	// Bit mask of CMPMODE field.
	ADC_EMR_CMPMODE_Msk = 0x3
	// Generates an event when the converted data is lower than the low threshold of the window.
	ADC_EMR_CMPMODE_LOW = 0x0
	// Generates an event when the converted data is higher than the high threshold of the window.
	ADC_EMR_CMPMODE_HIGH = 0x1
	// Generates an event when the converted data is in the comparison window.
	ADC_EMR_CMPMODE_IN = 0x2
	// Generates an event when the converted data is out of the comparison window.
	ADC_EMR_CMPMODE_OUT = 0x3
	// Position of CMPSEL field.
	ADC_EMR_CMPSEL_Pos = 0x4
	// Bit mask of CMPSEL field.
	ADC_EMR_CMPSEL_Msk = 0xf0
	// Position of CMPALL field.
	ADC_EMR_CMPALL_Pos = 0x9
	// Bit mask of CMPALL field.
	ADC_EMR_CMPALL_Msk = 0x200
	// Bit CMPALL.
	ADC_EMR_CMPALL = 0x200
	// Position of TAG field.
	ADC_EMR_TAG_Pos = 0x18
	// Bit mask of TAG field.
	ADC_EMR_TAG_Msk = 0x1000000
	// Bit TAG.
	ADC_EMR_TAG = 0x1000000

	// CWR: Compare Window Register
	// Position of LOWTHRES field.
	ADC_CWR_LOWTHRES_Pos = 0x0
	// Bit mask of LOWTHRES field.
	ADC_CWR_LOWTHRES_Msk = 0xfff
	// Position of HIGHTHRES field.
	ADC_CWR_HIGHTHRES_Pos = 0x10
	// Bit mask of HIGHTHRES field.
	ADC_CWR_HIGHTHRES_Msk = 0xfff0000

	// CDR: Channel Data Register
	// Position of DATA field.
	ADC_CDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	ADC_CDR_DATA_Msk = 0xfff

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	ADC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	ADC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	ADC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	ADC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	ADC_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protect Status Register
	// Position of WPVS field.
	ADC_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	ADC_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	ADC_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	ADC_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	ADC_WPSR_WPVSRC_Msk = 0xffff00

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	ADC_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	ADC_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	ADC_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	ADC_RCR_RXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	ADC_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	ADC_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	ADC_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	ADC_RNCR_RXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	ADC_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	ADC_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	ADC_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	ADC_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	ADC_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	ADC_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	ADC_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	ADC_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	ADC_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	ADC_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	ADC_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	ADC_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	ADC_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	ADC_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	ADC_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	ADC_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	ADC_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	ADC_PTSR_TXTEN = 0x100
)

// Bitfields for SDRAMC: SDRAM Controller
const (
	// MR: SDRAMC Mode Register
	// Position of MODE field.
	EBI_MR_MODE_Pos = 0x0
	// Bit mask of MODE field.
	EBI_MR_MODE_Msk = 0x7
	// Normal mode. Any access to the SDRAM is decoded normally. To activate this mode, command must be followed by a write to the SDRAM.
	EBI_MR_MODE_NORMAL = 0x0
	// The SDRAM Controller issues a NOP command when the SDRAM device is accessed regardless of the cycle. To activate this mode, command must be followed by a write to the SDRAM.
	EBI_MR_MODE_NOP = 0x1
	// The SDRAM Controller issues an "All Banks Precharge" command when the SDRAM device is accessed regardless of the cycle. To activate this mode, command must be followed by a write to the SDRAM.
	EBI_MR_MODE_ALLBANKS_PRECHARGE = 0x2
	// The SDRAM Controller issues a "Load Mode Register" command when the SDRAM device is accessed regardless of the cycle. To activate this mode, command must be followed by a write to the SDRAM.
	EBI_MR_MODE_LOAD_MODEREG = 0x3
	// The SDRAM Controller issues an "Auto-Refresh" Command when the SDRAM device is accessed regardless of the cycle. Previously, an "All Banks Precharge" command must be issued. To activate this mode, command must be followed by a write to the SDRAM.
	EBI_MR_MODE_AUTO_REFRESH = 0x4
	// The SDRAM Controller issues an "Extended Load Mode Register" command when the SDRAM device is accessed regardless of the cycle. To activate this mode, the "Extended Load Mode Register" command must be followed by a write to the SDRAM. The write in the SDRAM must be done in the appropriate bank; most low-power SDRAM devices use the bank 1.
	EBI_MR_MODE_EXT_LOAD_MODEREG = 0x5
	// Deep power-down mode. Enters deep power-down mode.
	EBI_MR_MODE_DEEP_POWERDOWN = 0x6

	// TR: SDRAMC Refresh Timer Register
	// Position of COUNT field.
	EBI_TR_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	EBI_TR_COUNT_Msk = 0xfff

	// CR: SDRAMC Configuration Register
	// Position of NC field.
	EBI_CR_NC_Pos = 0x0
	// Bit mask of NC field.
	EBI_CR_NC_Msk = 0x3
	// 8 column bits
	EBI_CR_NC_COL8 = 0x0
	// 9 column bits
	EBI_CR_NC_COL9 = 0x1
	// 10 column bits
	EBI_CR_NC_COL10 = 0x2
	// 11 column bits
	EBI_CR_NC_COL11 = 0x3
	// Position of NR field.
	EBI_CR_NR_Pos = 0x2
	// Bit mask of NR field.
	EBI_CR_NR_Msk = 0xc
	// 11 row bits
	EBI_CR_NR_ROW11 = 0x0
	// 12 row bits
	EBI_CR_NR_ROW12 = 0x1
	// 13 row bits
	EBI_CR_NR_ROW13 = 0x2
	// Position of NB field.
	EBI_CR_NB_Pos = 0x4
	// Bit mask of NB field.
	EBI_CR_NB_Msk = 0x10
	// Bit NB.
	EBI_CR_NB = 0x10
	// 2 banks
	EBI_CR_NB_BANK2 = 0x0
	// 4 banks
	EBI_CR_NB_BANK4 = 0x1
	// Position of CAS field.
	EBI_CR_CAS_Pos = 0x5
	// Bit mask of CAS field.
	EBI_CR_CAS_Msk = 0x60
	// 1 cycle CAS latency
	EBI_CR_CAS_LATENCY1 = 0x1
	// 2 cycle CAS latency
	EBI_CR_CAS_LATENCY2 = 0x2
	// 3 cycle CAS latency
	EBI_CR_CAS_LATENCY3 = 0x3
	// Position of DBW field.
	EBI_CR_DBW_Pos = 0x7
	// Bit mask of DBW field.
	EBI_CR_DBW_Msk = 0x80
	// Bit DBW.
	EBI_CR_DBW = 0x80
	// Position of TWR field.
	EBI_CR_TWR_Pos = 0x8
	// Bit mask of TWR field.
	EBI_CR_TWR_Msk = 0xf00
	// Position of TRC_TRFC field.
	EBI_CR_TRC_TRFC_Pos = 0xc
	// Bit mask of TRC_TRFC field.
	EBI_CR_TRC_TRFC_Msk = 0xf000
	// Position of TRP field.
	EBI_CR_TRP_Pos = 0x10
	// Bit mask of TRP field.
	EBI_CR_TRP_Msk = 0xf0000
	// Position of TRCD field.
	EBI_CR_TRCD_Pos = 0x14
	// Bit mask of TRCD field.
	EBI_CR_TRCD_Msk = 0xf00000
	// Position of TRAS field.
	EBI_CR_TRAS_Pos = 0x18
	// Bit mask of TRAS field.
	EBI_CR_TRAS_Msk = 0xf000000
	// Position of TXSR field.
	EBI_CR_TXSR_Pos = 0x1c
	// Bit mask of TXSR field.
	EBI_CR_TXSR_Msk = 0xf0000000

	// LPR: SDRAMC Low Power Register
	// Position of LPCB field.
	EBI_LPR_LPCB_Pos = 0x0
	// Bit mask of LPCB field.
	EBI_LPR_LPCB_Msk = 0x3
	// Low Power Feature is inhibited: no Power-down, Self-refresh or Deep Power-down command is issued to the SDRAM device.
	EBI_LPR_LPCB_DISABLED = 0x0
	// The SDRAM Controller issues a Self-refresh command to the SDRAM device, the SDCK clock is deactivated and the SDCKE signal is set low. The SDRAM device leaves the Self Refresh Mode when accessed and enters it after the access.
	EBI_LPR_LPCB_SELF_REFRESH = 0x1
	// The SDRAM Controller issues a Power-down Command to the SDRAM device after each access, the SDCKE signal is set to low. The SDRAM device leaves the Power-down Mode when accessed and enters it after the access.
	EBI_LPR_LPCB_POWER_DOWN = 0x2
	// The SDRAM Controller issues a Deep Power-down command to the SDRAM device. This mode is unique to low-power SDRAM.
	EBI_LPR_LPCB_DEEP_POWER_DOWN = 0x3
	// Position of PASR field.
	EBI_LPR_PASR_Pos = 0x4
	// Bit mask of PASR field.
	EBI_LPR_PASR_Msk = 0x70
	// Position of TCSR field.
	EBI_LPR_TCSR_Pos = 0x8
	// Bit mask of TCSR field.
	EBI_LPR_TCSR_Msk = 0x300
	// Position of DS field.
	EBI_LPR_DS_Pos = 0xa
	// Bit mask of DS field.
	EBI_LPR_DS_Msk = 0xc00
	// Position of TIMEOUT field.
	EBI_LPR_TIMEOUT_Pos = 0xc
	// Bit mask of TIMEOUT field.
	EBI_LPR_TIMEOUT_Msk = 0x3000
	// The SDRAM controller activates the SDRAM low-power mode immediately after the end of the last transfer.
	EBI_LPR_TIMEOUT_LP_LAST_XFER = 0x0
	// The SDRAM controller activates the SDRAM low-power mode 64 clock cycles after the end of the last transfer.
	EBI_LPR_TIMEOUT_LP_LAST_XFER_64 = 0x1
	// The SDRAM controller activates the SDRAM low-power mode 128 clock cycles after the end of the last transfer.
	EBI_LPR_TIMEOUT_LP_LAST_XFER_128 = 0x2

	// IER: SDRAMC Interrupt Enable Register
	// Position of RES field.
	EBI_IER_RES_Pos = 0x0
	// Bit mask of RES field.
	EBI_IER_RES_Msk = 0x1
	// Bit RES.
	EBI_IER_RES = 0x1

	// IDR: SDRAMC Interrupt Disable Register
	// Position of RES field.
	EBI_IDR_RES_Pos = 0x0
	// Bit mask of RES field.
	EBI_IDR_RES_Msk = 0x1
	// Bit RES.
	EBI_IDR_RES = 0x1

	// IMR: SDRAMC Interrupt Mask Register
	// Position of RES field.
	EBI_IMR_RES_Pos = 0x0
	// Bit mask of RES field.
	EBI_IMR_RES_Msk = 0x1
	// Bit RES.
	EBI_IMR_RES = 0x1

	// ISR: SDRAMC Interrupt Status Register
	// Position of RES field.
	EBI_ISR_RES_Pos = 0x0
	// Bit mask of RES field.
	EBI_ISR_RES_Msk = 0x1
	// Bit RES.
	EBI_ISR_RES = 0x1

	// MDR: SDRAMC Memory Device Register
	// Position of MD field.
	EBI_MDR_MD_Pos = 0x0
	// Bit mask of MD field.
	EBI_MDR_MD_Msk = 0x3
	// SDRAM
	EBI_MDR_MD_SDRAM = 0x0
	// Low-power SDRAM
	EBI_MDR_MD_LPSDRAM = 0x1
)

// Bitfields for MATRIX: AHB Bus Matrix
const (
	// MATRIX_MCFG: Master Configuration Register
	// Position of ULBT field.
	MATRIX_MATRIX_MCFG_ULBT_Pos = 0x0
	// Bit mask of ULBT field.
	MATRIX_MATRIX_MCFG_ULBT_Msk = 0x7

	// MATRIX_SCFG: Slave Configuration Register
	// Position of SLOT_CYCLE field.
	MATRIX_MATRIX_SCFG_SLOT_CYCLE_Pos = 0x0
	// Bit mask of SLOT_CYCLE field.
	MATRIX_MATRIX_SCFG_SLOT_CYCLE_Msk = 0xff
	// Position of DEFMSTR_TYPE field.
	MATRIX_MATRIX_SCFG_DEFMSTR_TYPE_Pos = 0x10
	// Bit mask of DEFMSTR_TYPE field.
	MATRIX_MATRIX_SCFG_DEFMSTR_TYPE_Msk = 0x30000
	// Position of FIXED_DEFMSTR field.
	MATRIX_MATRIX_SCFG_FIXED_DEFMSTR_Pos = 0x12
	// Bit mask of FIXED_DEFMSTR field.
	MATRIX_MATRIX_SCFG_FIXED_DEFMSTR_Msk = 0x1c0000
	// Position of ARBT field.
	MATRIX_MATRIX_SCFG_ARBT_Pos = 0x18
	// Bit mask of ARBT field.
	MATRIX_MATRIX_SCFG_ARBT_Msk = 0x3000000

	// MATRIX_PRAS0: Priority Register A for Slave 0
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS0_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS0_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS0_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS0_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS0_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS0_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS0_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS0_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_MATRIX_PRAS0_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_MATRIX_PRAS0_M4PR_Msk = 0x30000
	// Position of M5PR field.
	MATRIX_MATRIX_PRAS0_M5PR_Pos = 0x14
	// Bit mask of M5PR field.
	MATRIX_MATRIX_PRAS0_M5PR_Msk = 0x300000

	// MATRIX_PRAS1: Priority Register A for Slave 1
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS1_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS1_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS1_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS1_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS1_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS1_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS1_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS1_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_MATRIX_PRAS1_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_MATRIX_PRAS1_M4PR_Msk = 0x30000
	// Position of M5PR field.
	MATRIX_MATRIX_PRAS1_M5PR_Pos = 0x14
	// Bit mask of M5PR field.
	MATRIX_MATRIX_PRAS1_M5PR_Msk = 0x300000

	// MATRIX_PRAS2: Priority Register A for Slave 2
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS2_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS2_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS2_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS2_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS2_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS2_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS2_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS2_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_MATRIX_PRAS2_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_MATRIX_PRAS2_M4PR_Msk = 0x30000
	// Position of M5PR field.
	MATRIX_MATRIX_PRAS2_M5PR_Pos = 0x14
	// Bit mask of M5PR field.
	MATRIX_MATRIX_PRAS2_M5PR_Msk = 0x300000

	// MATRIX_PRAS3: Priority Register A for Slave 3
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS3_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS3_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS3_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS3_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS3_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS3_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS3_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS3_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_MATRIX_PRAS3_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_MATRIX_PRAS3_M4PR_Msk = 0x30000
	// Position of M5PR field.
	MATRIX_MATRIX_PRAS3_M5PR_Pos = 0x14
	// Bit mask of M5PR field.
	MATRIX_MATRIX_PRAS3_M5PR_Msk = 0x300000

	// MATRIX_PRAS4: Priority Register A for Slave 4
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS4_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS4_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS4_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS4_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS4_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS4_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS4_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS4_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_MATRIX_PRAS4_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_MATRIX_PRAS4_M4PR_Msk = 0x30000
	// Position of M5PR field.
	MATRIX_MATRIX_PRAS4_M5PR_Pos = 0x14
	// Bit mask of M5PR field.
	MATRIX_MATRIX_PRAS4_M5PR_Msk = 0x300000

	// MATRIX_MRCR: Master Remap Control Register
	// Position of RCB0 field.
	MATRIX_MATRIX_MRCR_RCB0_Pos = 0x0
	// Bit mask of RCB0 field.
	MATRIX_MATRIX_MRCR_RCB0_Msk = 0x1
	// Bit RCB0.
	MATRIX_MATRIX_MRCR_RCB0 = 0x1
	// Position of RCB1 field.
	MATRIX_MATRIX_MRCR_RCB1_Pos = 0x1
	// Bit mask of RCB1 field.
	MATRIX_MATRIX_MRCR_RCB1_Msk = 0x2
	// Bit RCB1.
	MATRIX_MATRIX_MRCR_RCB1 = 0x2

	// EBI_CSA: EBI Chip Select Assignment Register
	// Position of EBI_CS1A field.
	MATRIX_EBI_CSA_EBI_CS1A_Pos = 0x1
	// Bit mask of EBI_CS1A field.
	MATRIX_EBI_CSA_EBI_CS1A_Msk = 0x2
	// Bit EBI_CS1A.
	MATRIX_EBI_CSA_EBI_CS1A = 0x2
	// Position of EBI_CS3A field.
	MATRIX_EBI_CSA_EBI_CS3A_Pos = 0x3
	// Bit mask of EBI_CS3A field.
	MATRIX_EBI_CSA_EBI_CS3A_Msk = 0x8
	// Bit EBI_CS3A.
	MATRIX_EBI_CSA_EBI_CS3A = 0x8
	// Position of EBI_CS4A field.
	MATRIX_EBI_CSA_EBI_CS4A_Pos = 0x4
	// Bit mask of EBI_CS4A field.
	MATRIX_EBI_CSA_EBI_CS4A_Msk = 0x10
	// Bit EBI_CS4A.
	MATRIX_EBI_CSA_EBI_CS4A = 0x10
	// Position of EBI_CS5A field.
	MATRIX_EBI_CSA_EBI_CS5A_Pos = 0x5
	// Bit mask of EBI_CS5A field.
	MATRIX_EBI_CSA_EBI_CS5A_Msk = 0x20
	// Bit EBI_CS5A.
	MATRIX_EBI_CSA_EBI_CS5A = 0x20
	// Position of EBI_DBPUC field.
	MATRIX_EBI_CSA_EBI_DBPUC_Pos = 0x8
	// Bit mask of EBI_DBPUC field.
	MATRIX_EBI_CSA_EBI_DBPUC_Msk = 0x100
	// Bit EBI_DBPUC.
	MATRIX_EBI_CSA_EBI_DBPUC = 0x100
	// Position of VDDIOMSEL field.
	MATRIX_EBI_CSA_VDDIOMSEL_Pos = 0x10
	// Bit mask of VDDIOMSEL field.
	MATRIX_EBI_CSA_VDDIOMSEL_Msk = 0x10000
	// Bit VDDIOMSEL.
	MATRIX_EBI_CSA_VDDIOMSEL = 0x10000
	// Position of IOSR field.
	MATRIX_EBI_CSA_IOSR_Pos = 0x11
	// Bit mask of IOSR field.
	MATRIX_EBI_CSA_IOSR_Msk = 0x20000
	// Bit IOSR.
	MATRIX_EBI_CSA_IOSR = 0x20000
)

// Bitfields for AIC: Advanced Interrupt Controller
const (
	// SMR: Source Mode Register
	// Position of PRIOR field.
	AIC_SMR_PRIOR_Pos = 0x0
	// Bit mask of PRIOR field.
	AIC_SMR_PRIOR_Msk = 0x7
	// Position of SRCTYPE field.
	AIC_SMR_SRCTYPE_Pos = 0x5
	// Bit mask of SRCTYPE field.
	AIC_SMR_SRCTYPE_Msk = 0x60
	// High level Sensitive for internal sourceLow level Sensitive for external source
	AIC_SMR_SRCTYPE_INT_LEVEL_SENSITIVE = 0x0
	// Positive edge triggered for internal sourceNegative edge triggered for external source
	AIC_SMR_SRCTYPE_INT_EDGE_TRIGGERED = 0x1
	// High level Sensitive for internal sourceHigh level Sensitive for external source
	AIC_SMR_SRCTYPE_EXT_HIGH_LEVEL = 0x2
	// Positive edge triggered for internal sourcePositive edge triggered for external source
	AIC_SMR_SRCTYPE_EXT_POSITIVE_EDGE = 0x3

	// SVR: Source Vector Register
	// Position of VECTOR field.
	AIC_SVR_VECTOR_Pos = 0x0
	// Bit mask of VECTOR field.
	AIC_SVR_VECTOR_Msk = 0xffffffff

	// IVR: Interrupt Vector Register
	// Position of IRQV field.
	AIC_IVR_IRQV_Pos = 0x0
	// Bit mask of IRQV field.
	AIC_IVR_IRQV_Msk = 0xffffffff

	// FVR: FIQ Interrupt Vector Register
	// Position of FIQV field.
	AIC_FVR_FIQV_Pos = 0x0
	// Bit mask of FIQV field.
	AIC_FVR_FIQV_Msk = 0xffffffff

	// ISR: Interrupt Status Register
	// Position of IRQID field.
	AIC_ISR_IRQID_Pos = 0x0
	// Bit mask of IRQID field.
	AIC_ISR_IRQID_Msk = 0x1f

	// IPR: Interrupt Pending Register
	// Position of FIQ field.
	AIC_IPR_FIQ_Pos = 0x0
	// Bit mask of FIQ field.
	AIC_IPR_FIQ_Msk = 0x1
	// Bit FIQ.
	AIC_IPR_FIQ = 0x1
	// Position of SYS field.
	AIC_IPR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_IPR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_IPR_SYS = 0x2
	// Position of PID2 field.
	AIC_IPR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_IPR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_IPR_PID2 = 0x4
	// Position of PID3 field.
	AIC_IPR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_IPR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_IPR_PID3 = 0x8
	// Position of PID4 field.
	AIC_IPR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_IPR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_IPR_PID4 = 0x10
	// Position of PID5 field.
	AIC_IPR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_IPR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_IPR_PID5 = 0x20
	// Position of PID6 field.
	AIC_IPR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_IPR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_IPR_PID6 = 0x40
	// Position of PID7 field.
	AIC_IPR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_IPR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_IPR_PID7 = 0x80
	// Position of PID8 field.
	AIC_IPR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_IPR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_IPR_PID8 = 0x100
	// Position of PID9 field.
	AIC_IPR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_IPR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_IPR_PID9 = 0x200
	// Position of PID10 field.
	AIC_IPR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_IPR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_IPR_PID10 = 0x400
	// Position of PID11 field.
	AIC_IPR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_IPR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_IPR_PID11 = 0x800
	// Position of PID12 field.
	AIC_IPR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_IPR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_IPR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_IPR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_IPR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_IPR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_IPR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_IPR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_IPR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_IPR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_IPR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_IPR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_IPR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_IPR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_IPR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_IPR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_IPR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_IPR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_IPR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_IPR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_IPR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_IPR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_IPR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_IPR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_IPR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_IPR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_IPR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_IPR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_IPR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_IPR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_IPR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_IPR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_IPR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_IPR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_IPR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_IPR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_IPR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_IPR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_IPR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_IPR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_IPR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_IPR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_IPR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_IPR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_IPR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_IPR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_IPR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_IPR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_IPR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_IPR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_IPR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_IPR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_IPR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_IPR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_IPR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_IPR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_IPR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_IPR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_IPR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_IPR_PID31 = 0x80000000

	// IMR: Interrupt Mask Register
	// Position of FIQ field.
	AIC_IMR_FIQ_Pos = 0x0
	// Bit mask of FIQ field.
	AIC_IMR_FIQ_Msk = 0x1
	// Bit FIQ.
	AIC_IMR_FIQ = 0x1
	// Position of SYS field.
	AIC_IMR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_IMR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_IMR_SYS = 0x2
	// Position of PID2 field.
	AIC_IMR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_IMR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_IMR_PID2 = 0x4
	// Position of PID3 field.
	AIC_IMR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_IMR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_IMR_PID3 = 0x8
	// Position of PID4 field.
	AIC_IMR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_IMR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_IMR_PID4 = 0x10
	// Position of PID5 field.
	AIC_IMR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_IMR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_IMR_PID5 = 0x20
	// Position of PID6 field.
	AIC_IMR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_IMR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_IMR_PID6 = 0x40
	// Position of PID7 field.
	AIC_IMR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_IMR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_IMR_PID7 = 0x80
	// Position of PID8 field.
	AIC_IMR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_IMR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_IMR_PID8 = 0x100
	// Position of PID9 field.
	AIC_IMR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_IMR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_IMR_PID9 = 0x200
	// Position of PID10 field.
	AIC_IMR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_IMR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_IMR_PID10 = 0x400
	// Position of PID11 field.
	AIC_IMR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_IMR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_IMR_PID11 = 0x800
	// Position of PID12 field.
	AIC_IMR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_IMR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_IMR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_IMR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_IMR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_IMR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_IMR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_IMR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_IMR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_IMR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_IMR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_IMR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_IMR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_IMR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_IMR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_IMR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_IMR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_IMR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_IMR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_IMR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_IMR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_IMR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_IMR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_IMR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_IMR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_IMR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_IMR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_IMR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_IMR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_IMR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_IMR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_IMR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_IMR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_IMR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_IMR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_IMR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_IMR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_IMR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_IMR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_IMR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_IMR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_IMR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_IMR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_IMR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_IMR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_IMR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_IMR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_IMR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_IMR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_IMR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_IMR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_IMR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_IMR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_IMR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_IMR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_IMR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_IMR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_IMR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_IMR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_IMR_PID31 = 0x80000000

	// CISR: Core Interrupt Status Register
	// Position of NFIQ field.
	AIC_CISR_NFIQ_Pos = 0x0
	// Bit mask of NFIQ field.
	AIC_CISR_NFIQ_Msk = 0x1
	// Bit NFIQ.
	AIC_CISR_NFIQ = 0x1
	// Position of NIRQ field.
	AIC_CISR_NIRQ_Pos = 0x1
	// Bit mask of NIRQ field.
	AIC_CISR_NIRQ_Msk = 0x2
	// Bit NIRQ.
	AIC_CISR_NIRQ = 0x2

	// IECR: Interrupt Enable Command Register
	// Position of FIQ field.
	AIC_IECR_FIQ_Pos = 0x0
	// Bit mask of FIQ field.
	AIC_IECR_FIQ_Msk = 0x1
	// Bit FIQ.
	AIC_IECR_FIQ = 0x1
	// Position of SYS field.
	AIC_IECR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_IECR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_IECR_SYS = 0x2
	// Position of PID2 field.
	AIC_IECR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_IECR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_IECR_PID2 = 0x4
	// Position of PID3 field.
	AIC_IECR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_IECR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_IECR_PID3 = 0x8
	// Position of PID4 field.
	AIC_IECR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_IECR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_IECR_PID4 = 0x10
	// Position of PID5 field.
	AIC_IECR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_IECR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_IECR_PID5 = 0x20
	// Position of PID6 field.
	AIC_IECR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_IECR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_IECR_PID6 = 0x40
	// Position of PID7 field.
	AIC_IECR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_IECR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_IECR_PID7 = 0x80
	// Position of PID8 field.
	AIC_IECR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_IECR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_IECR_PID8 = 0x100
	// Position of PID9 field.
	AIC_IECR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_IECR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_IECR_PID9 = 0x200
	// Position of PID10 field.
	AIC_IECR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_IECR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_IECR_PID10 = 0x400
	// Position of PID11 field.
	AIC_IECR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_IECR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_IECR_PID11 = 0x800
	// Position of PID12 field.
	AIC_IECR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_IECR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_IECR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_IECR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_IECR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_IECR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_IECR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_IECR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_IECR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_IECR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_IECR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_IECR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_IECR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_IECR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_IECR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_IECR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_IECR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_IECR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_IECR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_IECR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_IECR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_IECR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_IECR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_IECR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_IECR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_IECR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_IECR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_IECR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_IECR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_IECR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_IECR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_IECR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_IECR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_IECR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_IECR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_IECR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_IECR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_IECR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_IECR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_IECR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_IECR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_IECR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_IECR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_IECR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_IECR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_IECR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_IECR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_IECR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_IECR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_IECR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_IECR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_IECR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_IECR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_IECR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_IECR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_IECR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_IECR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_IECR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_IECR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_IECR_PID31 = 0x80000000

	// IDCR: Interrupt Disable Command Register
	// Position of FIQ field.
	AIC_IDCR_FIQ_Pos = 0x0
	// Bit mask of FIQ field.
	AIC_IDCR_FIQ_Msk = 0x1
	// Bit FIQ.
	AIC_IDCR_FIQ = 0x1
	// Position of SYS field.
	AIC_IDCR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_IDCR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_IDCR_SYS = 0x2
	// Position of PID2 field.
	AIC_IDCR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_IDCR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_IDCR_PID2 = 0x4
	// Position of PID3 field.
	AIC_IDCR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_IDCR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_IDCR_PID3 = 0x8
	// Position of PID4 field.
	AIC_IDCR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_IDCR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_IDCR_PID4 = 0x10
	// Position of PID5 field.
	AIC_IDCR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_IDCR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_IDCR_PID5 = 0x20
	// Position of PID6 field.
	AIC_IDCR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_IDCR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_IDCR_PID6 = 0x40
	// Position of PID7 field.
	AIC_IDCR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_IDCR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_IDCR_PID7 = 0x80
	// Position of PID8 field.
	AIC_IDCR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_IDCR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_IDCR_PID8 = 0x100
	// Position of PID9 field.
	AIC_IDCR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_IDCR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_IDCR_PID9 = 0x200
	// Position of PID10 field.
	AIC_IDCR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_IDCR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_IDCR_PID10 = 0x400
	// Position of PID11 field.
	AIC_IDCR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_IDCR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_IDCR_PID11 = 0x800
	// Position of PID12 field.
	AIC_IDCR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_IDCR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_IDCR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_IDCR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_IDCR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_IDCR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_IDCR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_IDCR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_IDCR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_IDCR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_IDCR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_IDCR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_IDCR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_IDCR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_IDCR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_IDCR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_IDCR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_IDCR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_IDCR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_IDCR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_IDCR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_IDCR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_IDCR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_IDCR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_IDCR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_IDCR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_IDCR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_IDCR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_IDCR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_IDCR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_IDCR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_IDCR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_IDCR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_IDCR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_IDCR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_IDCR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_IDCR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_IDCR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_IDCR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_IDCR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_IDCR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_IDCR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_IDCR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_IDCR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_IDCR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_IDCR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_IDCR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_IDCR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_IDCR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_IDCR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_IDCR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_IDCR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_IDCR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_IDCR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_IDCR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_IDCR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_IDCR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_IDCR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_IDCR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_IDCR_PID31 = 0x80000000

	// ICCR: Interrupt Clear Command Register
	// Position of FIQ field.
	AIC_ICCR_FIQ_Pos = 0x0
	// Bit mask of FIQ field.
	AIC_ICCR_FIQ_Msk = 0x1
	// Bit FIQ.
	AIC_ICCR_FIQ = 0x1
	// Position of SYS field.
	AIC_ICCR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_ICCR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_ICCR_SYS = 0x2
	// Position of PID2 field.
	AIC_ICCR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_ICCR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_ICCR_PID2 = 0x4
	// Position of PID3 field.
	AIC_ICCR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_ICCR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_ICCR_PID3 = 0x8
	// Position of PID4 field.
	AIC_ICCR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_ICCR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_ICCR_PID4 = 0x10
	// Position of PID5 field.
	AIC_ICCR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_ICCR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_ICCR_PID5 = 0x20
	// Position of PID6 field.
	AIC_ICCR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_ICCR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_ICCR_PID6 = 0x40
	// Position of PID7 field.
	AIC_ICCR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_ICCR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_ICCR_PID7 = 0x80
	// Position of PID8 field.
	AIC_ICCR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_ICCR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_ICCR_PID8 = 0x100
	// Position of PID9 field.
	AIC_ICCR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_ICCR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_ICCR_PID9 = 0x200
	// Position of PID10 field.
	AIC_ICCR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_ICCR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_ICCR_PID10 = 0x400
	// Position of PID11 field.
	AIC_ICCR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_ICCR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_ICCR_PID11 = 0x800
	// Position of PID12 field.
	AIC_ICCR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_ICCR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_ICCR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_ICCR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_ICCR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_ICCR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_ICCR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_ICCR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_ICCR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_ICCR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_ICCR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_ICCR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_ICCR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_ICCR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_ICCR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_ICCR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_ICCR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_ICCR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_ICCR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_ICCR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_ICCR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_ICCR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_ICCR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_ICCR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_ICCR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_ICCR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_ICCR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_ICCR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_ICCR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_ICCR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_ICCR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_ICCR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_ICCR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_ICCR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_ICCR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_ICCR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_ICCR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_ICCR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_ICCR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_ICCR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_ICCR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_ICCR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_ICCR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_ICCR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_ICCR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_ICCR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_ICCR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_ICCR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_ICCR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_ICCR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_ICCR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_ICCR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_ICCR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_ICCR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_ICCR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_ICCR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_ICCR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_ICCR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_ICCR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_ICCR_PID31 = 0x80000000

	// ISCR: Interrupt Set Command Register
	// Position of FIQ field.
	AIC_ISCR_FIQ_Pos = 0x0
	// Bit mask of FIQ field.
	AIC_ISCR_FIQ_Msk = 0x1
	// Bit FIQ.
	AIC_ISCR_FIQ = 0x1
	// Position of SYS field.
	AIC_ISCR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_ISCR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_ISCR_SYS = 0x2
	// Position of PID2 field.
	AIC_ISCR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_ISCR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_ISCR_PID2 = 0x4
	// Position of PID3 field.
	AIC_ISCR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_ISCR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_ISCR_PID3 = 0x8
	// Position of PID4 field.
	AIC_ISCR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_ISCR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_ISCR_PID4 = 0x10
	// Position of PID5 field.
	AIC_ISCR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_ISCR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_ISCR_PID5 = 0x20
	// Position of PID6 field.
	AIC_ISCR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_ISCR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_ISCR_PID6 = 0x40
	// Position of PID7 field.
	AIC_ISCR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_ISCR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_ISCR_PID7 = 0x80
	// Position of PID8 field.
	AIC_ISCR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_ISCR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_ISCR_PID8 = 0x100
	// Position of PID9 field.
	AIC_ISCR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_ISCR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_ISCR_PID9 = 0x200
	// Position of PID10 field.
	AIC_ISCR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_ISCR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_ISCR_PID10 = 0x400
	// Position of PID11 field.
	AIC_ISCR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_ISCR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_ISCR_PID11 = 0x800
	// Position of PID12 field.
	AIC_ISCR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_ISCR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_ISCR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_ISCR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_ISCR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_ISCR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_ISCR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_ISCR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_ISCR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_ISCR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_ISCR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_ISCR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_ISCR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_ISCR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_ISCR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_ISCR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_ISCR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_ISCR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_ISCR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_ISCR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_ISCR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_ISCR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_ISCR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_ISCR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_ISCR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_ISCR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_ISCR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_ISCR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_ISCR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_ISCR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_ISCR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_ISCR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_ISCR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_ISCR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_ISCR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_ISCR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_ISCR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_ISCR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_ISCR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_ISCR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_ISCR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_ISCR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_ISCR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_ISCR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_ISCR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_ISCR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_ISCR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_ISCR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_ISCR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_ISCR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_ISCR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_ISCR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_ISCR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_ISCR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_ISCR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_ISCR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_ISCR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_ISCR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_ISCR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_ISCR_PID31 = 0x80000000

	// SPU: Spurious Interrupt Vector Register
	// Position of SIVR field.
	AIC_SPU_SIVR_Pos = 0x0
	// Bit mask of SIVR field.
	AIC_SPU_SIVR_Msk = 0xffffffff

	// DCR: Debug Control Register
	// Position of PROT field.
	AIC_DCR_PROT_Pos = 0x0
	// Bit mask of PROT field.
	AIC_DCR_PROT_Msk = 0x1
	// Bit PROT.
	AIC_DCR_PROT = 0x1
	// Position of GMSK field.
	AIC_DCR_GMSK_Pos = 0x1
	// Bit mask of GMSK field.
	AIC_DCR_GMSK_Msk = 0x2
	// Bit GMSK.
	AIC_DCR_GMSK = 0x2

	// FFER: Fast Forcing Enable Register
	// Position of SYS field.
	AIC_FFER_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_FFER_SYS_Msk = 0x2
	// Bit SYS.
	AIC_FFER_SYS = 0x2
	// Position of PID2 field.
	AIC_FFER_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_FFER_PID2_Msk = 0x4
	// Bit PID2.
	AIC_FFER_PID2 = 0x4
	// Position of PID3 field.
	AIC_FFER_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_FFER_PID3_Msk = 0x8
	// Bit PID3.
	AIC_FFER_PID3 = 0x8
	// Position of PID4 field.
	AIC_FFER_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_FFER_PID4_Msk = 0x10
	// Bit PID4.
	AIC_FFER_PID4 = 0x10
	// Position of PID5 field.
	AIC_FFER_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_FFER_PID5_Msk = 0x20
	// Bit PID5.
	AIC_FFER_PID5 = 0x20
	// Position of PID6 field.
	AIC_FFER_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_FFER_PID6_Msk = 0x40
	// Bit PID6.
	AIC_FFER_PID6 = 0x40
	// Position of PID7 field.
	AIC_FFER_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_FFER_PID7_Msk = 0x80
	// Bit PID7.
	AIC_FFER_PID7 = 0x80
	// Position of PID8 field.
	AIC_FFER_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_FFER_PID8_Msk = 0x100
	// Bit PID8.
	AIC_FFER_PID8 = 0x100
	// Position of PID9 field.
	AIC_FFER_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_FFER_PID9_Msk = 0x200
	// Bit PID9.
	AIC_FFER_PID9 = 0x200
	// Position of PID10 field.
	AIC_FFER_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_FFER_PID10_Msk = 0x400
	// Bit PID10.
	AIC_FFER_PID10 = 0x400
	// Position of PID11 field.
	AIC_FFER_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_FFER_PID11_Msk = 0x800
	// Bit PID11.
	AIC_FFER_PID11 = 0x800
	// Position of PID12 field.
	AIC_FFER_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_FFER_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_FFER_PID12 = 0x1000
	// Position of PID13 field.
	AIC_FFER_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_FFER_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_FFER_PID13 = 0x2000
	// Position of PID14 field.
	AIC_FFER_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_FFER_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_FFER_PID14 = 0x4000
	// Position of PID15 field.
	AIC_FFER_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_FFER_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_FFER_PID15 = 0x8000
	// Position of PID16 field.
	AIC_FFER_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_FFER_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_FFER_PID16 = 0x10000
	// Position of PID17 field.
	AIC_FFER_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_FFER_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_FFER_PID17 = 0x20000
	// Position of PID18 field.
	AIC_FFER_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_FFER_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_FFER_PID18 = 0x40000
	// Position of PID19 field.
	AIC_FFER_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_FFER_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_FFER_PID19 = 0x80000
	// Position of PID20 field.
	AIC_FFER_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_FFER_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_FFER_PID20 = 0x100000
	// Position of PID21 field.
	AIC_FFER_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_FFER_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_FFER_PID21 = 0x200000
	// Position of PID22 field.
	AIC_FFER_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_FFER_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_FFER_PID22 = 0x400000
	// Position of PID23 field.
	AIC_FFER_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_FFER_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_FFER_PID23 = 0x800000
	// Position of PID24 field.
	AIC_FFER_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_FFER_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_FFER_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_FFER_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_FFER_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_FFER_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_FFER_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_FFER_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_FFER_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_FFER_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_FFER_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_FFER_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_FFER_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_FFER_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_FFER_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_FFER_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_FFER_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_FFER_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_FFER_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_FFER_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_FFER_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_FFER_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_FFER_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_FFER_PID31 = 0x80000000

	// FFDR: Fast Forcing Disable Register
	// Position of SYS field.
	AIC_FFDR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_FFDR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_FFDR_SYS = 0x2
	// Position of PID2 field.
	AIC_FFDR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_FFDR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_FFDR_PID2 = 0x4
	// Position of PID3 field.
	AIC_FFDR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_FFDR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_FFDR_PID3 = 0x8
	// Position of PID4 field.
	AIC_FFDR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_FFDR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_FFDR_PID4 = 0x10
	// Position of PID5 field.
	AIC_FFDR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_FFDR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_FFDR_PID5 = 0x20
	// Position of PID6 field.
	AIC_FFDR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_FFDR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_FFDR_PID6 = 0x40
	// Position of PID7 field.
	AIC_FFDR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_FFDR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_FFDR_PID7 = 0x80
	// Position of PID8 field.
	AIC_FFDR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_FFDR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_FFDR_PID8 = 0x100
	// Position of PID9 field.
	AIC_FFDR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_FFDR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_FFDR_PID9 = 0x200
	// Position of PID10 field.
	AIC_FFDR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_FFDR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_FFDR_PID10 = 0x400
	// Position of PID11 field.
	AIC_FFDR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_FFDR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_FFDR_PID11 = 0x800
	// Position of PID12 field.
	AIC_FFDR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_FFDR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_FFDR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_FFDR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_FFDR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_FFDR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_FFDR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_FFDR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_FFDR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_FFDR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_FFDR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_FFDR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_FFDR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_FFDR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_FFDR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_FFDR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_FFDR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_FFDR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_FFDR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_FFDR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_FFDR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_FFDR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_FFDR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_FFDR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_FFDR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_FFDR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_FFDR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_FFDR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_FFDR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_FFDR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_FFDR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_FFDR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_FFDR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_FFDR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_FFDR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_FFDR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_FFDR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_FFDR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_FFDR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_FFDR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_FFDR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_FFDR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_FFDR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_FFDR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_FFDR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_FFDR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_FFDR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_FFDR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_FFDR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_FFDR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_FFDR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_FFDR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_FFDR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_FFDR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_FFDR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_FFDR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_FFDR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_FFDR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_FFDR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_FFDR_PID31 = 0x80000000

	// FFSR: Fast Forcing Status Register
	// Position of SYS field.
	AIC_FFSR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_FFSR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_FFSR_SYS = 0x2
	// Position of PID2 field.
	AIC_FFSR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_FFSR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_FFSR_PID2 = 0x4
	// Position of PID3 field.
	AIC_FFSR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_FFSR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_FFSR_PID3 = 0x8
	// Position of PID4 field.
	AIC_FFSR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_FFSR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_FFSR_PID4 = 0x10
	// Position of PID5 field.
	AIC_FFSR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_FFSR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_FFSR_PID5 = 0x20
	// Position of PID6 field.
	AIC_FFSR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_FFSR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_FFSR_PID6 = 0x40
	// Position of PID7 field.
	AIC_FFSR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_FFSR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_FFSR_PID7 = 0x80
	// Position of PID8 field.
	AIC_FFSR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_FFSR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_FFSR_PID8 = 0x100
	// Position of PID9 field.
	AIC_FFSR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_FFSR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_FFSR_PID9 = 0x200
	// Position of PID10 field.
	AIC_FFSR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_FFSR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_FFSR_PID10 = 0x400
	// Position of PID11 field.
	AIC_FFSR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_FFSR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_FFSR_PID11 = 0x800
	// Position of PID12 field.
	AIC_FFSR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_FFSR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_FFSR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_FFSR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_FFSR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_FFSR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_FFSR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_FFSR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_FFSR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_FFSR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_FFSR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_FFSR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_FFSR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_FFSR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_FFSR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_FFSR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_FFSR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_FFSR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_FFSR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_FFSR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_FFSR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_FFSR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_FFSR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_FFSR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_FFSR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_FFSR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_FFSR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_FFSR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_FFSR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_FFSR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_FFSR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_FFSR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_FFSR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_FFSR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_FFSR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_FFSR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_FFSR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_FFSR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_FFSR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_FFSR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_FFSR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_FFSR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_FFSR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_FFSR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_FFSR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_FFSR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_FFSR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_FFSR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_FFSR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_FFSR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_FFSR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_FFSR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_FFSR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_FFSR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_FFSR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_FFSR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_FFSR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_FFSR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_FFSR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_FFSR_PID31 = 0x80000000
)

// Bitfields for DBGU: Debug Unit
const (
	// CR: Control Register
	// Position of RSTRX field.
	DBGU_CR_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	DBGU_CR_RSTRX_Msk = 0x4
	// Bit RSTRX.
	DBGU_CR_RSTRX = 0x4
	// Position of RSTTX field.
	DBGU_CR_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	DBGU_CR_RSTTX_Msk = 0x8
	// Bit RSTTX.
	DBGU_CR_RSTTX = 0x8
	// Position of RXEN field.
	DBGU_CR_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	DBGU_CR_RXEN_Msk = 0x10
	// Bit RXEN.
	DBGU_CR_RXEN = 0x10
	// Position of RXDIS field.
	DBGU_CR_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	DBGU_CR_RXDIS_Msk = 0x20
	// Bit RXDIS.
	DBGU_CR_RXDIS = 0x20
	// Position of TXEN field.
	DBGU_CR_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	DBGU_CR_TXEN_Msk = 0x40
	// Bit TXEN.
	DBGU_CR_TXEN = 0x40
	// Position of TXDIS field.
	DBGU_CR_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	DBGU_CR_TXDIS_Msk = 0x80
	// Bit TXDIS.
	DBGU_CR_TXDIS = 0x80
	// Position of RSTSTA field.
	DBGU_CR_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	DBGU_CR_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	DBGU_CR_RSTSTA = 0x100

	// MR: Mode Register
	// Position of PAR field.
	DBGU_MR_PAR_Pos = 0x9
	// Bit mask of PAR field.
	DBGU_MR_PAR_Msk = 0xe00
	// Even Parity
	DBGU_MR_PAR_EVEN = 0x0
	// Odd Parity
	DBGU_MR_PAR_ODD = 0x1
	// Space: Parity forced to 0
	DBGU_MR_PAR_SPACE = 0x2
	// Mark: Parity forced to 1
	DBGU_MR_PAR_MARK = 0x3
	// No Parity
	DBGU_MR_PAR_NONE = 0x4
	// Position of CHMODE field.
	DBGU_MR_CHMODE_Pos = 0xe
	// Bit mask of CHMODE field.
	DBGU_MR_CHMODE_Msk = 0xc000
	// Normal Mode
	DBGU_MR_CHMODE_NORM = 0x0
	// Automatic Echo
	DBGU_MR_CHMODE_AUTO = 0x1
	// Local Loopback
	DBGU_MR_CHMODE_LOCLOOP = 0x2
	// Remote Loopback
	DBGU_MR_CHMODE_REMLOOP = 0x3

	// IER: Interrupt Enable Register
	// Position of RXRDY field.
	DBGU_IER_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	DBGU_IER_RXRDY_Msk = 0x1
	// Bit RXRDY.
	DBGU_IER_RXRDY = 0x1
	// Position of TXRDY field.
	DBGU_IER_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	DBGU_IER_TXRDY_Msk = 0x2
	// Bit TXRDY.
	DBGU_IER_TXRDY = 0x2
	// Position of ENDRX field.
	DBGU_IER_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	DBGU_IER_ENDRX_Msk = 0x8
	// Bit ENDRX.
	DBGU_IER_ENDRX = 0x8
	// Position of ENDTX field.
	DBGU_IER_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	DBGU_IER_ENDTX_Msk = 0x10
	// Bit ENDTX.
	DBGU_IER_ENDTX = 0x10
	// Position of OVRE field.
	DBGU_IER_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	DBGU_IER_OVRE_Msk = 0x20
	// Bit OVRE.
	DBGU_IER_OVRE = 0x20
	// Position of FRAME field.
	DBGU_IER_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	DBGU_IER_FRAME_Msk = 0x40
	// Bit FRAME.
	DBGU_IER_FRAME = 0x40
	// Position of PARE field.
	DBGU_IER_PARE_Pos = 0x7
	// Bit mask of PARE field.
	DBGU_IER_PARE_Msk = 0x80
	// Bit PARE.
	DBGU_IER_PARE = 0x80
	// Position of TXEMPTY field.
	DBGU_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	DBGU_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	DBGU_IER_TXEMPTY = 0x200
	// Position of TXBUFE field.
	DBGU_IER_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	DBGU_IER_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	DBGU_IER_TXBUFE = 0x800
	// Position of RXBUFF field.
	DBGU_IER_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	DBGU_IER_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	DBGU_IER_RXBUFF = 0x1000
	// Position of COMMTX field.
	DBGU_IER_COMMTX_Pos = 0x1e
	// Bit mask of COMMTX field.
	DBGU_IER_COMMTX_Msk = 0x40000000
	// Bit COMMTX.
	DBGU_IER_COMMTX = 0x40000000
	// Position of COMMRX field.
	DBGU_IER_COMMRX_Pos = 0x1f
	// Bit mask of COMMRX field.
	DBGU_IER_COMMRX_Msk = 0x80000000
	// Bit COMMRX.
	DBGU_IER_COMMRX = 0x80000000

	// IDR: Interrupt Disable Register
	// Position of RXRDY field.
	DBGU_IDR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	DBGU_IDR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	DBGU_IDR_RXRDY = 0x1
	// Position of TXRDY field.
	DBGU_IDR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	DBGU_IDR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	DBGU_IDR_TXRDY = 0x2
	// Position of ENDRX field.
	DBGU_IDR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	DBGU_IDR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	DBGU_IDR_ENDRX = 0x8
	// Position of ENDTX field.
	DBGU_IDR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	DBGU_IDR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	DBGU_IDR_ENDTX = 0x10
	// Position of OVRE field.
	DBGU_IDR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	DBGU_IDR_OVRE_Msk = 0x20
	// Bit OVRE.
	DBGU_IDR_OVRE = 0x20
	// Position of FRAME field.
	DBGU_IDR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	DBGU_IDR_FRAME_Msk = 0x40
	// Bit FRAME.
	DBGU_IDR_FRAME = 0x40
	// Position of PARE field.
	DBGU_IDR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	DBGU_IDR_PARE_Msk = 0x80
	// Bit PARE.
	DBGU_IDR_PARE = 0x80
	// Position of TXEMPTY field.
	DBGU_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	DBGU_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	DBGU_IDR_TXEMPTY = 0x200
	// Position of TXBUFE field.
	DBGU_IDR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	DBGU_IDR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	DBGU_IDR_TXBUFE = 0x800
	// Position of RXBUFF field.
	DBGU_IDR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	DBGU_IDR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	DBGU_IDR_RXBUFF = 0x1000
	// Position of COMMTX field.
	DBGU_IDR_COMMTX_Pos = 0x1e
	// Bit mask of COMMTX field.
	DBGU_IDR_COMMTX_Msk = 0x40000000
	// Bit COMMTX.
	DBGU_IDR_COMMTX = 0x40000000
	// Position of COMMRX field.
	DBGU_IDR_COMMRX_Pos = 0x1f
	// Bit mask of COMMRX field.
	DBGU_IDR_COMMRX_Msk = 0x80000000
	// Bit COMMRX.
	DBGU_IDR_COMMRX = 0x80000000

	// IMR: Interrupt Mask Register
	// Position of RXRDY field.
	DBGU_IMR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	DBGU_IMR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	DBGU_IMR_RXRDY = 0x1
	// Position of TXRDY field.
	DBGU_IMR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	DBGU_IMR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	DBGU_IMR_TXRDY = 0x2
	// Position of ENDRX field.
	DBGU_IMR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	DBGU_IMR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	DBGU_IMR_ENDRX = 0x8
	// Position of ENDTX field.
	DBGU_IMR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	DBGU_IMR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	DBGU_IMR_ENDTX = 0x10
	// Position of OVRE field.
	DBGU_IMR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	DBGU_IMR_OVRE_Msk = 0x20
	// Bit OVRE.
	DBGU_IMR_OVRE = 0x20
	// Position of FRAME field.
	DBGU_IMR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	DBGU_IMR_FRAME_Msk = 0x40
	// Bit FRAME.
	DBGU_IMR_FRAME = 0x40
	// Position of PARE field.
	DBGU_IMR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	DBGU_IMR_PARE_Msk = 0x80
	// Bit PARE.
	DBGU_IMR_PARE = 0x80
	// Position of TXEMPTY field.
	DBGU_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	DBGU_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	DBGU_IMR_TXEMPTY = 0x200
	// Position of TXBUFE field.
	DBGU_IMR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	DBGU_IMR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	DBGU_IMR_TXBUFE = 0x800
	// Position of RXBUFF field.
	DBGU_IMR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	DBGU_IMR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	DBGU_IMR_RXBUFF = 0x1000
	// Position of COMMTX field.
	DBGU_IMR_COMMTX_Pos = 0x1e
	// Bit mask of COMMTX field.
	DBGU_IMR_COMMTX_Msk = 0x40000000
	// Bit COMMTX.
	DBGU_IMR_COMMTX = 0x40000000
	// Position of COMMRX field.
	DBGU_IMR_COMMRX_Pos = 0x1f
	// Bit mask of COMMRX field.
	DBGU_IMR_COMMRX_Msk = 0x80000000
	// Bit COMMRX.
	DBGU_IMR_COMMRX = 0x80000000

	// SR: Status Register
	// Position of RXRDY field.
	DBGU_SR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	DBGU_SR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	DBGU_SR_RXRDY = 0x1
	// Position of TXRDY field.
	DBGU_SR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	DBGU_SR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	DBGU_SR_TXRDY = 0x2
	// Position of ENDRX field.
	DBGU_SR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	DBGU_SR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	DBGU_SR_ENDRX = 0x8
	// Position of ENDTX field.
	DBGU_SR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	DBGU_SR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	DBGU_SR_ENDTX = 0x10
	// Position of OVRE field.
	DBGU_SR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	DBGU_SR_OVRE_Msk = 0x20
	// Bit OVRE.
	DBGU_SR_OVRE = 0x20
	// Position of FRAME field.
	DBGU_SR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	DBGU_SR_FRAME_Msk = 0x40
	// Bit FRAME.
	DBGU_SR_FRAME = 0x40
	// Position of PARE field.
	DBGU_SR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	DBGU_SR_PARE_Msk = 0x80
	// Bit PARE.
	DBGU_SR_PARE = 0x80
	// Position of TXEMPTY field.
	DBGU_SR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	DBGU_SR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	DBGU_SR_TXEMPTY = 0x200
	// Position of TXBUFE field.
	DBGU_SR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	DBGU_SR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	DBGU_SR_TXBUFE = 0x800
	// Position of RXBUFF field.
	DBGU_SR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	DBGU_SR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	DBGU_SR_RXBUFF = 0x1000
	// Position of COMMTX field.
	DBGU_SR_COMMTX_Pos = 0x1e
	// Bit mask of COMMTX field.
	DBGU_SR_COMMTX_Msk = 0x40000000
	// Bit COMMTX.
	DBGU_SR_COMMTX = 0x40000000
	// Position of COMMRX field.
	DBGU_SR_COMMRX_Pos = 0x1f
	// Bit mask of COMMRX field.
	DBGU_SR_COMMRX_Msk = 0x80000000
	// Bit COMMRX.
	DBGU_SR_COMMRX = 0x80000000

	// RHR: Receive Holding Register
	// Position of RXCHR field.
	DBGU_RHR_RXCHR_Pos = 0x0
	// Bit mask of RXCHR field.
	DBGU_RHR_RXCHR_Msk = 0xff

	// THR: Transmit Holding Register
	// Position of TXCHR field.
	DBGU_THR_TXCHR_Pos = 0x0
	// Bit mask of TXCHR field.
	DBGU_THR_TXCHR_Msk = 0xff

	// BRGR: Baud Rate Generator Register
	// Position of CD field.
	DBGU_BRGR_CD_Pos = 0x0
	// Bit mask of CD field.
	DBGU_BRGR_CD_Msk = 0xffff
	// DBGU Disabled
	DBGU_BRGR_CD_DISABLED = 0x0
	// MCK
	DBGU_BRGR_CD_MCK = 0x1

	// CIDR: Chip ID Register
	// Position of VERSION field.
	DBGU_CIDR_VERSION_Pos = 0x0
	// Bit mask of VERSION field.
	DBGU_CIDR_VERSION_Msk = 0x1f
	// Position of EPROC field.
	DBGU_CIDR_EPROC_Pos = 0x5
	// Bit mask of EPROC field.
	DBGU_CIDR_EPROC_Msk = 0xe0
	// ARM946ES
	DBGU_CIDR_EPROC_ARM946ES = 0x1
	// ARM7TDMI
	DBGU_CIDR_EPROC_ARM7TDMI = 0x2
	// Cortex-M3
	DBGU_CIDR_EPROC_CM3 = 0x3
	// ARM920T
	DBGU_CIDR_EPROC_ARM920T = 0x4
	// ARM926EJS
	DBGU_CIDR_EPROC_ARM926EJS = 0x5
	// Cortex-A5
	DBGU_CIDR_EPROC_CA5 = 0x6
	// Position of NVPSIZ field.
	DBGU_CIDR_NVPSIZ_Pos = 0x8
	// Bit mask of NVPSIZ field.
	DBGU_CIDR_NVPSIZ_Msk = 0xf00
	// None
	DBGU_CIDR_NVPSIZ_NONE = 0x0
	// 8K bytes
	DBGU_CIDR_NVPSIZ_8K = 0x1
	// 16K bytes
	DBGU_CIDR_NVPSIZ_16K = 0x2
	// 32K bytes
	DBGU_CIDR_NVPSIZ_32K = 0x3
	// 64K bytes
	DBGU_CIDR_NVPSIZ_64K = 0x5
	// 128K bytes
	DBGU_CIDR_NVPSIZ_128K = 0x7
	// 256K bytes
	DBGU_CIDR_NVPSIZ_256K = 0x9
	// 512K bytes
	DBGU_CIDR_NVPSIZ_512K = 0xa
	// 1024K bytes
	DBGU_CIDR_NVPSIZ_1024K = 0xc
	// 2048K bytes
	DBGU_CIDR_NVPSIZ_2048K = 0xe
	// Position of NVPSIZ2 field.
	DBGU_CIDR_NVPSIZ2_Pos = 0xc
	// Bit mask of NVPSIZ2 field.
	DBGU_CIDR_NVPSIZ2_Msk = 0xf000
	// None
	DBGU_CIDR_NVPSIZ2_NONE = 0x0
	// 8K bytes
	DBGU_CIDR_NVPSIZ2_8K = 0x1
	// 16K bytes
	DBGU_CIDR_NVPSIZ2_16K = 0x2
	// 32K bytes
	DBGU_CIDR_NVPSIZ2_32K = 0x3
	// 64K bytes
	DBGU_CIDR_NVPSIZ2_64K = 0x5
	// 128K bytes
	DBGU_CIDR_NVPSIZ2_128K = 0x7
	// 256K bytes
	DBGU_CIDR_NVPSIZ2_256K = 0x9
	// 512K bytes
	DBGU_CIDR_NVPSIZ2_512K = 0xa
	// 1024K bytes
	DBGU_CIDR_NVPSIZ2_1024K = 0xc
	// 2048K bytes
	DBGU_CIDR_NVPSIZ2_2048K = 0xe
	// Position of SRAMSIZ field.
	DBGU_CIDR_SRAMSIZ_Pos = 0x10
	// Bit mask of SRAMSIZ field.
	DBGU_CIDR_SRAMSIZ_Msk = 0xf0000
	// 1K bytes
	DBGU_CIDR_SRAMSIZ_1K = 0x1
	// 2K bytes
	DBGU_CIDR_SRAMSIZ_2K = 0x2
	// 6K bytes
	DBGU_CIDR_SRAMSIZ_6K = 0x3
	// 112K bytes
	DBGU_CIDR_SRAMSIZ_112K = 0x4
	// 4K bytes
	DBGU_CIDR_SRAMSIZ_4K = 0x5
	// 80K bytes
	DBGU_CIDR_SRAMSIZ_80K = 0x6
	// 160K bytes
	DBGU_CIDR_SRAMSIZ_160K = 0x7
	// 8K bytes
	DBGU_CIDR_SRAMSIZ_8K = 0x8
	// 16K bytes
	DBGU_CIDR_SRAMSIZ_16K = 0x9
	// 32K bytes
	DBGU_CIDR_SRAMSIZ_32K = 0xa
	// 64K bytes
	DBGU_CIDR_SRAMSIZ_64K = 0xb
	// 128K bytes
	DBGU_CIDR_SRAMSIZ_128K = 0xc
	// 256K bytes
	DBGU_CIDR_SRAMSIZ_256K = 0xd
	// 96K bytes
	DBGU_CIDR_SRAMSIZ_96K = 0xe
	// 512K bytes
	DBGU_CIDR_SRAMSIZ_512K = 0xf
	// Position of ARCH field.
	DBGU_CIDR_ARCH_Pos = 0x14
	// Bit mask of ARCH field.
	DBGU_CIDR_ARCH_Msk = 0xff00000
	// AT91SAM9xx Series
	DBGU_CIDR_ARCH_AT91SAM9xx = 0x19
	// AT91SAM9XExx Series
	DBGU_CIDR_ARCH_AT91SAM9XExx = 0x29
	// AT91x34 Series
	DBGU_CIDR_ARCH_AT91x34 = 0x34
	// CAP7 Series
	DBGU_CIDR_ARCH_CAP7 = 0x37
	// CAP9 Series
	DBGU_CIDR_ARCH_CAP9 = 0x39
	// CAP11 Series
	DBGU_CIDR_ARCH_CAP11 = 0x3b
	// AT91x40 Series
	DBGU_CIDR_ARCH_AT91x40 = 0x40
	// AT91x42 Series
	DBGU_CIDR_ARCH_AT91x42 = 0x42
	// AT91x55 Series
	DBGU_CIDR_ARCH_AT91x55 = 0x55
	// AT91SAM7Axx Series
	DBGU_CIDR_ARCH_AT91SAM7Axx = 0x60
	// AT91SAM7AQxx Series
	DBGU_CIDR_ARCH_AT91SAM7AQxx = 0x61
	// AT91x63 Series
	DBGU_CIDR_ARCH_AT91x63 = 0x63
	// AT91SAM7Sxx Series
	DBGU_CIDR_ARCH_AT91SAM7Sxx = 0x70
	// AT91SAM7XCxx Series
	DBGU_CIDR_ARCH_AT91SAM7XCxx = 0x71
	// AT91SAM7SExx Series
	DBGU_CIDR_ARCH_AT91SAM7SExx = 0x72
	// AT91SAM7Lxx Series
	DBGU_CIDR_ARCH_AT91SAM7Lxx = 0x73
	// AT91SAM7Xxx Series
	DBGU_CIDR_ARCH_AT91SAM7Xxx = 0x75
	// AT91SAM7SLxx Series
	DBGU_CIDR_ARCH_AT91SAM7SLxx = 0x76
	// ATSAM3UxC Series (100-pin version)
	DBGU_CIDR_ARCH_ATSAM3UxC = 0x80
	// ATSAM3UxE Series (144-pin version)
	DBGU_CIDR_ARCH_ATSAM3UxE = 0x81
	// ATSAM3AxC Series (100-pin version)
	DBGU_CIDR_ARCH_ATSAM3AxC = 0x83
	// ATSAM3XxC Series (100-pin version)
	DBGU_CIDR_ARCH_ATSAM3XxC = 0x84
	// ATSAM3XxE Series (144-pin version)
	DBGU_CIDR_ARCH_ATSAM3XxE = 0x85
	// ATSAM3XxG Series (208/217-pin version)
	DBGU_CIDR_ARCH_ATSAM3XxG = 0x86
	// ATSAM3SxA Series (48-pin version)
	DBGU_CIDR_ARCH_ATSAM3SxA = 0x88
	// ATSAM3SxB Series (64-pin version)
	DBGU_CIDR_ARCH_ATSAM3SxB = 0x89
	// ATSAM3SxC Series (100-pin version)
	DBGU_CIDR_ARCH_ATSAM3SxC = 0x8a
	// AT91x92 Series
	DBGU_CIDR_ARCH_AT91x92 = 0x92
	// ATSAM3NxA Series (48-pin version)
	DBGU_CIDR_ARCH_ATSAM3NxA = 0x93
	// ATSAM3NxB Series (64-pin version)
	DBGU_CIDR_ARCH_ATSAM3NxB = 0x94
	// ATSAM3NxC Series (100-pin version)
	DBGU_CIDR_ARCH_ATSAM3NxC = 0x95
	// ATSAM3SDxA Series (48-pin version)
	DBGU_CIDR_ARCH_ATSAM3SDxA = 0x98
	// ATSAM3SDxB Series (64-pin version)
	DBGU_CIDR_ARCH_ATSAM3SDxB = 0x99
	// ATSAM3SDxC Series (100-pin version)
	DBGU_CIDR_ARCH_ATSAM3SDxC = 0x9a
	// AT75Cxx Series
	DBGU_CIDR_ARCH_AT75Cxx = 0xf0
	// Position of NVPTYP field.
	DBGU_CIDR_NVPTYP_Pos = 0x1c
	// Bit mask of NVPTYP field.
	DBGU_CIDR_NVPTYP_Msk = 0x70000000
	// ROM
	DBGU_CIDR_NVPTYP_ROM = 0x0
	// ROMless or on-chip Flash
	DBGU_CIDR_NVPTYP_ROMLESS = 0x1
	// Embedded Flash Memory
	DBGU_CIDR_NVPTYP_FLASH = 0x2
	// ROM and Embedded Flash MemoryNVPSIZ is ROM size NVPSIZ2 is Flash size
	DBGU_CIDR_NVPTYP_ROM_FLASH = 0x3
	// SRAM emulating ROM
	DBGU_CIDR_NVPTYP_SRAM = 0x4
	// Position of EXT field.
	DBGU_CIDR_EXT_Pos = 0x1f
	// Bit mask of EXT field.
	DBGU_CIDR_EXT_Msk = 0x80000000
	// Bit EXT.
	DBGU_CIDR_EXT = 0x80000000

	// EXID: Chip ID Extension Register
	// Position of EXID field.
	DBGU_EXID_EXID_Pos = 0x0
	// Bit mask of EXID field.
	DBGU_EXID_EXID_Msk = 0xffffffff

	// FNR: Force NTRST Register
	// Position of FNTRST field.
	DBGU_FNR_FNTRST_Pos = 0x0
	// Bit mask of FNTRST field.
	DBGU_FNR_FNTRST_Msk = 0x1
	// Bit FNTRST.
	DBGU_FNR_FNTRST = 0x1

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	DBGU_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	DBGU_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	DBGU_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	DBGU_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	DBGU_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	DBGU_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	DBGU_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	DBGU_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	DBGU_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	DBGU_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	DBGU_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	DBGU_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	DBGU_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	DBGU_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	DBGU_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	DBGU_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	DBGU_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	DBGU_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	DBGU_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	DBGU_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	DBGU_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	DBGU_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	DBGU_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	DBGU_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	DBGU_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	DBGU_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	DBGU_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	DBGU_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	DBGU_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	DBGU_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	DBGU_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	DBGU_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	DBGU_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	DBGU_PTSR_TXTEN = 0x100
)

// Bitfields for PIOA: Parallel Input/Output Controller A
const (
	// PER: PIO Enable Register
	// Position of P0 field.
	PIO_PER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PER_P0_Msk = 0x1
	// Bit P0.
	PIO_PER_P0 = 0x1
	// Position of P1 field.
	PIO_PER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PER_P1_Msk = 0x2
	// Bit P1.
	PIO_PER_P1 = 0x2
	// Position of P2 field.
	PIO_PER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PER_P2_Msk = 0x4
	// Bit P2.
	PIO_PER_P2 = 0x4
	// Position of P3 field.
	PIO_PER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PER_P3_Msk = 0x8
	// Bit P3.
	PIO_PER_P3 = 0x8
	// Position of P4 field.
	PIO_PER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PER_P4_Msk = 0x10
	// Bit P4.
	PIO_PER_P4 = 0x10
	// Position of P5 field.
	PIO_PER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PER_P5_Msk = 0x20
	// Bit P5.
	PIO_PER_P5 = 0x20
	// Position of P6 field.
	PIO_PER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PER_P6_Msk = 0x40
	// Bit P6.
	PIO_PER_P6 = 0x40
	// Position of P7 field.
	PIO_PER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PER_P7_Msk = 0x80
	// Bit P7.
	PIO_PER_P7 = 0x80
	// Position of P8 field.
	PIO_PER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PER_P8_Msk = 0x100
	// Bit P8.
	PIO_PER_P8 = 0x100
	// Position of P9 field.
	PIO_PER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PER_P9_Msk = 0x200
	// Bit P9.
	PIO_PER_P9 = 0x200
	// Position of P10 field.
	PIO_PER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PER_P10_Msk = 0x400
	// Bit P10.
	PIO_PER_P10 = 0x400
	// Position of P11 field.
	PIO_PER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PER_P11_Msk = 0x800
	// Bit P11.
	PIO_PER_P11 = 0x800
	// Position of P12 field.
	PIO_PER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PER_P12_Msk = 0x1000
	// Bit P12.
	PIO_PER_P12 = 0x1000
	// Position of P13 field.
	PIO_PER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PER_P13_Msk = 0x2000
	// Bit P13.
	PIO_PER_P13 = 0x2000
	// Position of P14 field.
	PIO_PER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PER_P14_Msk = 0x4000
	// Bit P14.
	PIO_PER_P14 = 0x4000
	// Position of P15 field.
	PIO_PER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PER_P15_Msk = 0x8000
	// Bit P15.
	PIO_PER_P15 = 0x8000
	// Position of P16 field.
	PIO_PER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PER_P16_Msk = 0x10000
	// Bit P16.
	PIO_PER_P16 = 0x10000
	// Position of P17 field.
	PIO_PER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PER_P17_Msk = 0x20000
	// Bit P17.
	PIO_PER_P17 = 0x20000
	// Position of P18 field.
	PIO_PER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PER_P18_Msk = 0x40000
	// Bit P18.
	PIO_PER_P18 = 0x40000
	// Position of P19 field.
	PIO_PER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PER_P19_Msk = 0x80000
	// Bit P19.
	PIO_PER_P19 = 0x80000
	// Position of P20 field.
	PIO_PER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PER_P20_Msk = 0x100000
	// Bit P20.
	PIO_PER_P20 = 0x100000
	// Position of P21 field.
	PIO_PER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PER_P21_Msk = 0x200000
	// Bit P21.
	PIO_PER_P21 = 0x200000
	// Position of P22 field.
	PIO_PER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PER_P22_Msk = 0x400000
	// Bit P22.
	PIO_PER_P22 = 0x400000
	// Position of P23 field.
	PIO_PER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PER_P23_Msk = 0x800000
	// Bit P23.
	PIO_PER_P23 = 0x800000
	// Position of P24 field.
	PIO_PER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PER_P24 = 0x1000000
	// Position of P25 field.
	PIO_PER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PER_P25 = 0x2000000
	// Position of P26 field.
	PIO_PER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PER_P26 = 0x4000000
	// Position of P27 field.
	PIO_PER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PER_P27 = 0x8000000
	// Position of P28 field.
	PIO_PER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PER_P28 = 0x10000000
	// Position of P29 field.
	PIO_PER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PER_P29 = 0x20000000
	// Position of P30 field.
	PIO_PER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PER_P30 = 0x40000000
	// Position of P31 field.
	PIO_PER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PER_P31 = 0x80000000

	// PDR: PIO Disable Register
	// Position of P0 field.
	PIO_PDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PDR_P0_Msk = 0x1
	// Bit P0.
	PIO_PDR_P0 = 0x1
	// Position of P1 field.
	PIO_PDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PDR_P1_Msk = 0x2
	// Bit P1.
	PIO_PDR_P1 = 0x2
	// Position of P2 field.
	PIO_PDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PDR_P2_Msk = 0x4
	// Bit P2.
	PIO_PDR_P2 = 0x4
	// Position of P3 field.
	PIO_PDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PDR_P3_Msk = 0x8
	// Bit P3.
	PIO_PDR_P3 = 0x8
	// Position of P4 field.
	PIO_PDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PDR_P4_Msk = 0x10
	// Bit P4.
	PIO_PDR_P4 = 0x10
	// Position of P5 field.
	PIO_PDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PDR_P5_Msk = 0x20
	// Bit P5.
	PIO_PDR_P5 = 0x20
	// Position of P6 field.
	PIO_PDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PDR_P6_Msk = 0x40
	// Bit P6.
	PIO_PDR_P6 = 0x40
	// Position of P7 field.
	PIO_PDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PDR_P7_Msk = 0x80
	// Bit P7.
	PIO_PDR_P7 = 0x80
	// Position of P8 field.
	PIO_PDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PDR_P8_Msk = 0x100
	// Bit P8.
	PIO_PDR_P8 = 0x100
	// Position of P9 field.
	PIO_PDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PDR_P9_Msk = 0x200
	// Bit P9.
	PIO_PDR_P9 = 0x200
	// Position of P10 field.
	PIO_PDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PDR_P10_Msk = 0x400
	// Bit P10.
	PIO_PDR_P10 = 0x400
	// Position of P11 field.
	PIO_PDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PDR_P11_Msk = 0x800
	// Bit P11.
	PIO_PDR_P11 = 0x800
	// Position of P12 field.
	PIO_PDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PDR_P12 = 0x1000
	// Position of P13 field.
	PIO_PDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PDR_P13 = 0x2000
	// Position of P14 field.
	PIO_PDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PDR_P14 = 0x4000
	// Position of P15 field.
	PIO_PDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PDR_P15 = 0x8000
	// Position of P16 field.
	PIO_PDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PDR_P16 = 0x10000
	// Position of P17 field.
	PIO_PDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PDR_P17 = 0x20000
	// Position of P18 field.
	PIO_PDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PDR_P18 = 0x40000
	// Position of P19 field.
	PIO_PDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PDR_P19 = 0x80000
	// Position of P20 field.
	PIO_PDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PDR_P20 = 0x100000
	// Position of P21 field.
	PIO_PDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PDR_P21 = 0x200000
	// Position of P22 field.
	PIO_PDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PDR_P22 = 0x400000
	// Position of P23 field.
	PIO_PDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PDR_P23 = 0x800000
	// Position of P24 field.
	PIO_PDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PDR_P31 = 0x80000000

	// PSR: PIO Status Register
	// Position of P0 field.
	PIO_PSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PSR_P0 = 0x1
	// Position of P1 field.
	PIO_PSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PSR_P1 = 0x2
	// Position of P2 field.
	PIO_PSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PSR_P2 = 0x4
	// Position of P3 field.
	PIO_PSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PSR_P3 = 0x8
	// Position of P4 field.
	PIO_PSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PSR_P4 = 0x10
	// Position of P5 field.
	PIO_PSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PSR_P5 = 0x20
	// Position of P6 field.
	PIO_PSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PSR_P6 = 0x40
	// Position of P7 field.
	PIO_PSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PSR_P7 = 0x80
	// Position of P8 field.
	PIO_PSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PSR_P8 = 0x100
	// Position of P9 field.
	PIO_PSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PSR_P9 = 0x200
	// Position of P10 field.
	PIO_PSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PSR_P10 = 0x400
	// Position of P11 field.
	PIO_PSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PSR_P11 = 0x800
	// Position of P12 field.
	PIO_PSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PSR_P31 = 0x80000000

	// OER: Output Enable Register
	// Position of P0 field.
	PIO_OER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OER_P0_Msk = 0x1
	// Bit P0.
	PIO_OER_P0 = 0x1
	// Position of P1 field.
	PIO_OER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OER_P1_Msk = 0x2
	// Bit P1.
	PIO_OER_P1 = 0x2
	// Position of P2 field.
	PIO_OER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OER_P2_Msk = 0x4
	// Bit P2.
	PIO_OER_P2 = 0x4
	// Position of P3 field.
	PIO_OER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OER_P3_Msk = 0x8
	// Bit P3.
	PIO_OER_P3 = 0x8
	// Position of P4 field.
	PIO_OER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OER_P4_Msk = 0x10
	// Bit P4.
	PIO_OER_P4 = 0x10
	// Position of P5 field.
	PIO_OER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OER_P5_Msk = 0x20
	// Bit P5.
	PIO_OER_P5 = 0x20
	// Position of P6 field.
	PIO_OER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OER_P6_Msk = 0x40
	// Bit P6.
	PIO_OER_P6 = 0x40
	// Position of P7 field.
	PIO_OER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OER_P7_Msk = 0x80
	// Bit P7.
	PIO_OER_P7 = 0x80
	// Position of P8 field.
	PIO_OER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OER_P8_Msk = 0x100
	// Bit P8.
	PIO_OER_P8 = 0x100
	// Position of P9 field.
	PIO_OER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OER_P9_Msk = 0x200
	// Bit P9.
	PIO_OER_P9 = 0x200
	// Position of P10 field.
	PIO_OER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OER_P10_Msk = 0x400
	// Bit P10.
	PIO_OER_P10 = 0x400
	// Position of P11 field.
	PIO_OER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OER_P11_Msk = 0x800
	// Bit P11.
	PIO_OER_P11 = 0x800
	// Position of P12 field.
	PIO_OER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OER_P12_Msk = 0x1000
	// Bit P12.
	PIO_OER_P12 = 0x1000
	// Position of P13 field.
	PIO_OER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OER_P13_Msk = 0x2000
	// Bit P13.
	PIO_OER_P13 = 0x2000
	// Position of P14 field.
	PIO_OER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OER_P14_Msk = 0x4000
	// Bit P14.
	PIO_OER_P14 = 0x4000
	// Position of P15 field.
	PIO_OER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OER_P15_Msk = 0x8000
	// Bit P15.
	PIO_OER_P15 = 0x8000
	// Position of P16 field.
	PIO_OER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OER_P16_Msk = 0x10000
	// Bit P16.
	PIO_OER_P16 = 0x10000
	// Position of P17 field.
	PIO_OER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OER_P17_Msk = 0x20000
	// Bit P17.
	PIO_OER_P17 = 0x20000
	// Position of P18 field.
	PIO_OER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OER_P18_Msk = 0x40000
	// Bit P18.
	PIO_OER_P18 = 0x40000
	// Position of P19 field.
	PIO_OER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OER_P19_Msk = 0x80000
	// Bit P19.
	PIO_OER_P19 = 0x80000
	// Position of P20 field.
	PIO_OER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OER_P20_Msk = 0x100000
	// Bit P20.
	PIO_OER_P20 = 0x100000
	// Position of P21 field.
	PIO_OER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OER_P21_Msk = 0x200000
	// Bit P21.
	PIO_OER_P21 = 0x200000
	// Position of P22 field.
	PIO_OER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OER_P22_Msk = 0x400000
	// Bit P22.
	PIO_OER_P22 = 0x400000
	// Position of P23 field.
	PIO_OER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OER_P23_Msk = 0x800000
	// Bit P23.
	PIO_OER_P23 = 0x800000
	// Position of P24 field.
	PIO_OER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OER_P24 = 0x1000000
	// Position of P25 field.
	PIO_OER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OER_P25 = 0x2000000
	// Position of P26 field.
	PIO_OER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OER_P26 = 0x4000000
	// Position of P27 field.
	PIO_OER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OER_P27 = 0x8000000
	// Position of P28 field.
	PIO_OER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OER_P28 = 0x10000000
	// Position of P29 field.
	PIO_OER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OER_P29 = 0x20000000
	// Position of P30 field.
	PIO_OER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OER_P30 = 0x40000000
	// Position of P31 field.
	PIO_OER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OER_P31 = 0x80000000

	// ODR: Output Disable Register
	// Position of P0 field.
	PIO_ODR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ODR_P0_Msk = 0x1
	// Bit P0.
	PIO_ODR_P0 = 0x1
	// Position of P1 field.
	PIO_ODR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ODR_P1_Msk = 0x2
	// Bit P1.
	PIO_ODR_P1 = 0x2
	// Position of P2 field.
	PIO_ODR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ODR_P2_Msk = 0x4
	// Bit P2.
	PIO_ODR_P2 = 0x4
	// Position of P3 field.
	PIO_ODR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ODR_P3_Msk = 0x8
	// Bit P3.
	PIO_ODR_P3 = 0x8
	// Position of P4 field.
	PIO_ODR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ODR_P4_Msk = 0x10
	// Bit P4.
	PIO_ODR_P4 = 0x10
	// Position of P5 field.
	PIO_ODR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ODR_P5_Msk = 0x20
	// Bit P5.
	PIO_ODR_P5 = 0x20
	// Position of P6 field.
	PIO_ODR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ODR_P6_Msk = 0x40
	// Bit P6.
	PIO_ODR_P6 = 0x40
	// Position of P7 field.
	PIO_ODR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ODR_P7_Msk = 0x80
	// Bit P7.
	PIO_ODR_P7 = 0x80
	// Position of P8 field.
	PIO_ODR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ODR_P8_Msk = 0x100
	// Bit P8.
	PIO_ODR_P8 = 0x100
	// Position of P9 field.
	PIO_ODR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ODR_P9_Msk = 0x200
	// Bit P9.
	PIO_ODR_P9 = 0x200
	// Position of P10 field.
	PIO_ODR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ODR_P10_Msk = 0x400
	// Bit P10.
	PIO_ODR_P10 = 0x400
	// Position of P11 field.
	PIO_ODR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ODR_P11_Msk = 0x800
	// Bit P11.
	PIO_ODR_P11 = 0x800
	// Position of P12 field.
	PIO_ODR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ODR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ODR_P12 = 0x1000
	// Position of P13 field.
	PIO_ODR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ODR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ODR_P13 = 0x2000
	// Position of P14 field.
	PIO_ODR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ODR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ODR_P14 = 0x4000
	// Position of P15 field.
	PIO_ODR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ODR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ODR_P15 = 0x8000
	// Position of P16 field.
	PIO_ODR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ODR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ODR_P16 = 0x10000
	// Position of P17 field.
	PIO_ODR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ODR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ODR_P17 = 0x20000
	// Position of P18 field.
	PIO_ODR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ODR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ODR_P18 = 0x40000
	// Position of P19 field.
	PIO_ODR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ODR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ODR_P19 = 0x80000
	// Position of P20 field.
	PIO_ODR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ODR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ODR_P20 = 0x100000
	// Position of P21 field.
	PIO_ODR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ODR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ODR_P21 = 0x200000
	// Position of P22 field.
	PIO_ODR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ODR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ODR_P22 = 0x400000
	// Position of P23 field.
	PIO_ODR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ODR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ODR_P23 = 0x800000
	// Position of P24 field.
	PIO_ODR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ODR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ODR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ODR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ODR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ODR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ODR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ODR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ODR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ODR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ODR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ODR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ODR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ODR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ODR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ODR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ODR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ODR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ODR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ODR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ODR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ODR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ODR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ODR_P31 = 0x80000000

	// OSR: Output Status Register
	// Position of P0 field.
	PIO_OSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OSR_P0_Msk = 0x1
	// Bit P0.
	PIO_OSR_P0 = 0x1
	// Position of P1 field.
	PIO_OSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OSR_P1_Msk = 0x2
	// Bit P1.
	PIO_OSR_P1 = 0x2
	// Position of P2 field.
	PIO_OSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OSR_P2_Msk = 0x4
	// Bit P2.
	PIO_OSR_P2 = 0x4
	// Position of P3 field.
	PIO_OSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OSR_P3_Msk = 0x8
	// Bit P3.
	PIO_OSR_P3 = 0x8
	// Position of P4 field.
	PIO_OSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OSR_P4_Msk = 0x10
	// Bit P4.
	PIO_OSR_P4 = 0x10
	// Position of P5 field.
	PIO_OSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OSR_P5_Msk = 0x20
	// Bit P5.
	PIO_OSR_P5 = 0x20
	// Position of P6 field.
	PIO_OSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OSR_P6_Msk = 0x40
	// Bit P6.
	PIO_OSR_P6 = 0x40
	// Position of P7 field.
	PIO_OSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OSR_P7_Msk = 0x80
	// Bit P7.
	PIO_OSR_P7 = 0x80
	// Position of P8 field.
	PIO_OSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OSR_P8_Msk = 0x100
	// Bit P8.
	PIO_OSR_P8 = 0x100
	// Position of P9 field.
	PIO_OSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OSR_P9_Msk = 0x200
	// Bit P9.
	PIO_OSR_P9 = 0x200
	// Position of P10 field.
	PIO_OSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OSR_P10_Msk = 0x400
	// Bit P10.
	PIO_OSR_P10 = 0x400
	// Position of P11 field.
	PIO_OSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OSR_P11_Msk = 0x800
	// Bit P11.
	PIO_OSR_P11 = 0x800
	// Position of P12 field.
	PIO_OSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_OSR_P12 = 0x1000
	// Position of P13 field.
	PIO_OSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_OSR_P13 = 0x2000
	// Position of P14 field.
	PIO_OSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_OSR_P14 = 0x4000
	// Position of P15 field.
	PIO_OSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_OSR_P15 = 0x8000
	// Position of P16 field.
	PIO_OSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_OSR_P16 = 0x10000
	// Position of P17 field.
	PIO_OSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_OSR_P17 = 0x20000
	// Position of P18 field.
	PIO_OSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_OSR_P18 = 0x40000
	// Position of P19 field.
	PIO_OSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_OSR_P19 = 0x80000
	// Position of P20 field.
	PIO_OSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_OSR_P20 = 0x100000
	// Position of P21 field.
	PIO_OSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_OSR_P21 = 0x200000
	// Position of P22 field.
	PIO_OSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_OSR_P22 = 0x400000
	// Position of P23 field.
	PIO_OSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_OSR_P23 = 0x800000
	// Position of P24 field.
	PIO_OSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_OSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_OSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_OSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_OSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_OSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_OSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_OSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OSR_P31 = 0x80000000

	// IFER: Glitch Input Filter Enable Register
	// Position of P0 field.
	PIO_IFER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFER_P0_Msk = 0x1
	// Bit P0.
	PIO_IFER_P0 = 0x1
	// Position of P1 field.
	PIO_IFER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFER_P1_Msk = 0x2
	// Bit P1.
	PIO_IFER_P1 = 0x2
	// Position of P2 field.
	PIO_IFER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFER_P2_Msk = 0x4
	// Bit P2.
	PIO_IFER_P2 = 0x4
	// Position of P3 field.
	PIO_IFER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFER_P3_Msk = 0x8
	// Bit P3.
	PIO_IFER_P3 = 0x8
	// Position of P4 field.
	PIO_IFER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFER_P4_Msk = 0x10
	// Bit P4.
	PIO_IFER_P4 = 0x10
	// Position of P5 field.
	PIO_IFER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFER_P5_Msk = 0x20
	// Bit P5.
	PIO_IFER_P5 = 0x20
	// Position of P6 field.
	PIO_IFER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFER_P6_Msk = 0x40
	// Bit P6.
	PIO_IFER_P6 = 0x40
	// Position of P7 field.
	PIO_IFER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFER_P7_Msk = 0x80
	// Bit P7.
	PIO_IFER_P7 = 0x80
	// Position of P8 field.
	PIO_IFER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFER_P8_Msk = 0x100
	// Bit P8.
	PIO_IFER_P8 = 0x100
	// Position of P9 field.
	PIO_IFER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFER_P9_Msk = 0x200
	// Bit P9.
	PIO_IFER_P9 = 0x200
	// Position of P10 field.
	PIO_IFER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFER_P10_Msk = 0x400
	// Bit P10.
	PIO_IFER_P10 = 0x400
	// Position of P11 field.
	PIO_IFER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFER_P11_Msk = 0x800
	// Bit P11.
	PIO_IFER_P11 = 0x800
	// Position of P12 field.
	PIO_IFER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFER_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFER_P12 = 0x1000
	// Position of P13 field.
	PIO_IFER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFER_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFER_P13 = 0x2000
	// Position of P14 field.
	PIO_IFER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFER_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFER_P14 = 0x4000
	// Position of P15 field.
	PIO_IFER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFER_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFER_P15 = 0x8000
	// Position of P16 field.
	PIO_IFER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFER_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFER_P16 = 0x10000
	// Position of P17 field.
	PIO_IFER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFER_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFER_P17 = 0x20000
	// Position of P18 field.
	PIO_IFER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFER_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFER_P18 = 0x40000
	// Position of P19 field.
	PIO_IFER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFER_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFER_P19 = 0x80000
	// Position of P20 field.
	PIO_IFER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFER_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFER_P20 = 0x100000
	// Position of P21 field.
	PIO_IFER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFER_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFER_P21 = 0x200000
	// Position of P22 field.
	PIO_IFER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFER_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFER_P22 = 0x400000
	// Position of P23 field.
	PIO_IFER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFER_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFER_P23 = 0x800000
	// Position of P24 field.
	PIO_IFER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFER_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFER_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFER_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFER_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFER_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFER_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFER_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFER_P31 = 0x80000000

	// IFDR: Glitch Input Filter Disable Register
	// Position of P0 field.
	PIO_IFDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFDR_P0_Msk = 0x1
	// Bit P0.
	PIO_IFDR_P0 = 0x1
	// Position of P1 field.
	PIO_IFDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFDR_P1_Msk = 0x2
	// Bit P1.
	PIO_IFDR_P1 = 0x2
	// Position of P2 field.
	PIO_IFDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFDR_P2_Msk = 0x4
	// Bit P2.
	PIO_IFDR_P2 = 0x4
	// Position of P3 field.
	PIO_IFDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFDR_P3_Msk = 0x8
	// Bit P3.
	PIO_IFDR_P3 = 0x8
	// Position of P4 field.
	PIO_IFDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFDR_P4_Msk = 0x10
	// Bit P4.
	PIO_IFDR_P4 = 0x10
	// Position of P5 field.
	PIO_IFDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFDR_P5_Msk = 0x20
	// Bit P5.
	PIO_IFDR_P5 = 0x20
	// Position of P6 field.
	PIO_IFDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFDR_P6_Msk = 0x40
	// Bit P6.
	PIO_IFDR_P6 = 0x40
	// Position of P7 field.
	PIO_IFDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFDR_P7_Msk = 0x80
	// Bit P7.
	PIO_IFDR_P7 = 0x80
	// Position of P8 field.
	PIO_IFDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFDR_P8_Msk = 0x100
	// Bit P8.
	PIO_IFDR_P8 = 0x100
	// Position of P9 field.
	PIO_IFDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFDR_P9_Msk = 0x200
	// Bit P9.
	PIO_IFDR_P9 = 0x200
	// Position of P10 field.
	PIO_IFDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFDR_P10_Msk = 0x400
	// Bit P10.
	PIO_IFDR_P10 = 0x400
	// Position of P11 field.
	PIO_IFDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFDR_P11_Msk = 0x800
	// Bit P11.
	PIO_IFDR_P11 = 0x800
	// Position of P12 field.
	PIO_IFDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFDR_P12 = 0x1000
	// Position of P13 field.
	PIO_IFDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFDR_P13 = 0x2000
	// Position of P14 field.
	PIO_IFDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFDR_P14 = 0x4000
	// Position of P15 field.
	PIO_IFDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFDR_P15 = 0x8000
	// Position of P16 field.
	PIO_IFDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFDR_P16 = 0x10000
	// Position of P17 field.
	PIO_IFDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFDR_P17 = 0x20000
	// Position of P18 field.
	PIO_IFDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFDR_P18 = 0x40000
	// Position of P19 field.
	PIO_IFDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFDR_P19 = 0x80000
	// Position of P20 field.
	PIO_IFDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFDR_P20 = 0x100000
	// Position of P21 field.
	PIO_IFDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFDR_P21 = 0x200000
	// Position of P22 field.
	PIO_IFDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFDR_P22 = 0x400000
	// Position of P23 field.
	PIO_IFDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFDR_P23 = 0x800000
	// Position of P24 field.
	PIO_IFDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFDR_P31 = 0x80000000

	// IFSR: Glitch Input Filter Status Register
	// Position of P0 field.
	PIO_IFSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFSR_P0_Msk = 0x1
	// Bit P0.
	PIO_IFSR_P0 = 0x1
	// Position of P1 field.
	PIO_IFSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFSR_P1_Msk = 0x2
	// Bit P1.
	PIO_IFSR_P1 = 0x2
	// Position of P2 field.
	PIO_IFSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFSR_P2_Msk = 0x4
	// Bit P2.
	PIO_IFSR_P2 = 0x4
	// Position of P3 field.
	PIO_IFSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFSR_P3_Msk = 0x8
	// Bit P3.
	PIO_IFSR_P3 = 0x8
	// Position of P4 field.
	PIO_IFSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFSR_P4_Msk = 0x10
	// Bit P4.
	PIO_IFSR_P4 = 0x10
	// Position of P5 field.
	PIO_IFSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFSR_P5_Msk = 0x20
	// Bit P5.
	PIO_IFSR_P5 = 0x20
	// Position of P6 field.
	PIO_IFSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFSR_P6_Msk = 0x40
	// Bit P6.
	PIO_IFSR_P6 = 0x40
	// Position of P7 field.
	PIO_IFSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFSR_P7_Msk = 0x80
	// Bit P7.
	PIO_IFSR_P7 = 0x80
	// Position of P8 field.
	PIO_IFSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFSR_P8_Msk = 0x100
	// Bit P8.
	PIO_IFSR_P8 = 0x100
	// Position of P9 field.
	PIO_IFSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFSR_P9_Msk = 0x200
	// Bit P9.
	PIO_IFSR_P9 = 0x200
	// Position of P10 field.
	PIO_IFSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFSR_P10_Msk = 0x400
	// Bit P10.
	PIO_IFSR_P10 = 0x400
	// Position of P11 field.
	PIO_IFSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFSR_P11_Msk = 0x800
	// Bit P11.
	PIO_IFSR_P11 = 0x800
	// Position of P12 field.
	PIO_IFSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFSR_P12 = 0x1000
	// Position of P13 field.
	PIO_IFSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFSR_P13 = 0x2000
	// Position of P14 field.
	PIO_IFSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFSR_P14 = 0x4000
	// Position of P15 field.
	PIO_IFSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFSR_P15 = 0x8000
	// Position of P16 field.
	PIO_IFSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFSR_P16 = 0x10000
	// Position of P17 field.
	PIO_IFSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFSR_P17 = 0x20000
	// Position of P18 field.
	PIO_IFSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFSR_P18 = 0x40000
	// Position of P19 field.
	PIO_IFSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFSR_P19 = 0x80000
	// Position of P20 field.
	PIO_IFSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFSR_P20 = 0x100000
	// Position of P21 field.
	PIO_IFSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFSR_P21 = 0x200000
	// Position of P22 field.
	PIO_IFSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFSR_P22 = 0x400000
	// Position of P23 field.
	PIO_IFSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFSR_P23 = 0x800000
	// Position of P24 field.
	PIO_IFSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFSR_P31 = 0x80000000

	// SODR: Set Output Data Register
	// Position of P0 field.
	PIO_SODR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_SODR_P0_Msk = 0x1
	// Bit P0.
	PIO_SODR_P0 = 0x1
	// Position of P1 field.
	PIO_SODR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_SODR_P1_Msk = 0x2
	// Bit P1.
	PIO_SODR_P1 = 0x2
	// Position of P2 field.
	PIO_SODR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_SODR_P2_Msk = 0x4
	// Bit P2.
	PIO_SODR_P2 = 0x4
	// Position of P3 field.
	PIO_SODR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_SODR_P3_Msk = 0x8
	// Bit P3.
	PIO_SODR_P3 = 0x8
	// Position of P4 field.
	PIO_SODR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_SODR_P4_Msk = 0x10
	// Bit P4.
	PIO_SODR_P4 = 0x10
	// Position of P5 field.
	PIO_SODR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_SODR_P5_Msk = 0x20
	// Bit P5.
	PIO_SODR_P5 = 0x20
	// Position of P6 field.
	PIO_SODR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_SODR_P6_Msk = 0x40
	// Bit P6.
	PIO_SODR_P6 = 0x40
	// Position of P7 field.
	PIO_SODR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_SODR_P7_Msk = 0x80
	// Bit P7.
	PIO_SODR_P7 = 0x80
	// Position of P8 field.
	PIO_SODR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_SODR_P8_Msk = 0x100
	// Bit P8.
	PIO_SODR_P8 = 0x100
	// Position of P9 field.
	PIO_SODR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_SODR_P9_Msk = 0x200
	// Bit P9.
	PIO_SODR_P9 = 0x200
	// Position of P10 field.
	PIO_SODR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_SODR_P10_Msk = 0x400
	// Bit P10.
	PIO_SODR_P10 = 0x400
	// Position of P11 field.
	PIO_SODR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_SODR_P11_Msk = 0x800
	// Bit P11.
	PIO_SODR_P11 = 0x800
	// Position of P12 field.
	PIO_SODR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_SODR_P12_Msk = 0x1000
	// Bit P12.
	PIO_SODR_P12 = 0x1000
	// Position of P13 field.
	PIO_SODR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_SODR_P13_Msk = 0x2000
	// Bit P13.
	PIO_SODR_P13 = 0x2000
	// Position of P14 field.
	PIO_SODR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_SODR_P14_Msk = 0x4000
	// Bit P14.
	PIO_SODR_P14 = 0x4000
	// Position of P15 field.
	PIO_SODR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_SODR_P15_Msk = 0x8000
	// Bit P15.
	PIO_SODR_P15 = 0x8000
	// Position of P16 field.
	PIO_SODR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_SODR_P16_Msk = 0x10000
	// Bit P16.
	PIO_SODR_P16 = 0x10000
	// Position of P17 field.
	PIO_SODR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_SODR_P17_Msk = 0x20000
	// Bit P17.
	PIO_SODR_P17 = 0x20000
	// Position of P18 field.
	PIO_SODR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_SODR_P18_Msk = 0x40000
	// Bit P18.
	PIO_SODR_P18 = 0x40000
	// Position of P19 field.
	PIO_SODR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_SODR_P19_Msk = 0x80000
	// Bit P19.
	PIO_SODR_P19 = 0x80000
	// Position of P20 field.
	PIO_SODR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_SODR_P20_Msk = 0x100000
	// Bit P20.
	PIO_SODR_P20 = 0x100000
	// Position of P21 field.
	PIO_SODR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_SODR_P21_Msk = 0x200000
	// Bit P21.
	PIO_SODR_P21 = 0x200000
	// Position of P22 field.
	PIO_SODR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_SODR_P22_Msk = 0x400000
	// Bit P22.
	PIO_SODR_P22 = 0x400000
	// Position of P23 field.
	PIO_SODR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_SODR_P23_Msk = 0x800000
	// Bit P23.
	PIO_SODR_P23 = 0x800000
	// Position of P24 field.
	PIO_SODR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_SODR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_SODR_P24 = 0x1000000
	// Position of P25 field.
	PIO_SODR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_SODR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_SODR_P25 = 0x2000000
	// Position of P26 field.
	PIO_SODR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_SODR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_SODR_P26 = 0x4000000
	// Position of P27 field.
	PIO_SODR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_SODR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_SODR_P27 = 0x8000000
	// Position of P28 field.
	PIO_SODR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_SODR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_SODR_P28 = 0x10000000
	// Position of P29 field.
	PIO_SODR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_SODR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_SODR_P29 = 0x20000000
	// Position of P30 field.
	PIO_SODR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_SODR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_SODR_P30 = 0x40000000
	// Position of P31 field.
	PIO_SODR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_SODR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_SODR_P31 = 0x80000000

	// CODR: Clear Output Data Register
	// Position of P0 field.
	PIO_CODR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_CODR_P0_Msk = 0x1
	// Bit P0.
	PIO_CODR_P0 = 0x1
	// Position of P1 field.
	PIO_CODR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_CODR_P1_Msk = 0x2
	// Bit P1.
	PIO_CODR_P1 = 0x2
	// Position of P2 field.
	PIO_CODR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_CODR_P2_Msk = 0x4
	// Bit P2.
	PIO_CODR_P2 = 0x4
	// Position of P3 field.
	PIO_CODR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_CODR_P3_Msk = 0x8
	// Bit P3.
	PIO_CODR_P3 = 0x8
	// Position of P4 field.
	PIO_CODR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_CODR_P4_Msk = 0x10
	// Bit P4.
	PIO_CODR_P4 = 0x10
	// Position of P5 field.
	PIO_CODR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_CODR_P5_Msk = 0x20
	// Bit P5.
	PIO_CODR_P5 = 0x20
	// Position of P6 field.
	PIO_CODR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_CODR_P6_Msk = 0x40
	// Bit P6.
	PIO_CODR_P6 = 0x40
	// Position of P7 field.
	PIO_CODR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_CODR_P7_Msk = 0x80
	// Bit P7.
	PIO_CODR_P7 = 0x80
	// Position of P8 field.
	PIO_CODR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_CODR_P8_Msk = 0x100
	// Bit P8.
	PIO_CODR_P8 = 0x100
	// Position of P9 field.
	PIO_CODR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_CODR_P9_Msk = 0x200
	// Bit P9.
	PIO_CODR_P9 = 0x200
	// Position of P10 field.
	PIO_CODR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_CODR_P10_Msk = 0x400
	// Bit P10.
	PIO_CODR_P10 = 0x400
	// Position of P11 field.
	PIO_CODR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_CODR_P11_Msk = 0x800
	// Bit P11.
	PIO_CODR_P11 = 0x800
	// Position of P12 field.
	PIO_CODR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_CODR_P12_Msk = 0x1000
	// Bit P12.
	PIO_CODR_P12 = 0x1000
	// Position of P13 field.
	PIO_CODR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_CODR_P13_Msk = 0x2000
	// Bit P13.
	PIO_CODR_P13 = 0x2000
	// Position of P14 field.
	PIO_CODR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_CODR_P14_Msk = 0x4000
	// Bit P14.
	PIO_CODR_P14 = 0x4000
	// Position of P15 field.
	PIO_CODR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_CODR_P15_Msk = 0x8000
	// Bit P15.
	PIO_CODR_P15 = 0x8000
	// Position of P16 field.
	PIO_CODR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_CODR_P16_Msk = 0x10000
	// Bit P16.
	PIO_CODR_P16 = 0x10000
	// Position of P17 field.
	PIO_CODR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_CODR_P17_Msk = 0x20000
	// Bit P17.
	PIO_CODR_P17 = 0x20000
	// Position of P18 field.
	PIO_CODR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_CODR_P18_Msk = 0x40000
	// Bit P18.
	PIO_CODR_P18 = 0x40000
	// Position of P19 field.
	PIO_CODR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_CODR_P19_Msk = 0x80000
	// Bit P19.
	PIO_CODR_P19 = 0x80000
	// Position of P20 field.
	PIO_CODR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_CODR_P20_Msk = 0x100000
	// Bit P20.
	PIO_CODR_P20 = 0x100000
	// Position of P21 field.
	PIO_CODR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_CODR_P21_Msk = 0x200000
	// Bit P21.
	PIO_CODR_P21 = 0x200000
	// Position of P22 field.
	PIO_CODR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_CODR_P22_Msk = 0x400000
	// Bit P22.
	PIO_CODR_P22 = 0x400000
	// Position of P23 field.
	PIO_CODR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_CODR_P23_Msk = 0x800000
	// Bit P23.
	PIO_CODR_P23 = 0x800000
	// Position of P24 field.
	PIO_CODR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_CODR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_CODR_P24 = 0x1000000
	// Position of P25 field.
	PIO_CODR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_CODR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_CODR_P25 = 0x2000000
	// Position of P26 field.
	PIO_CODR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_CODR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_CODR_P26 = 0x4000000
	// Position of P27 field.
	PIO_CODR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_CODR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_CODR_P27 = 0x8000000
	// Position of P28 field.
	PIO_CODR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_CODR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_CODR_P28 = 0x10000000
	// Position of P29 field.
	PIO_CODR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_CODR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_CODR_P29 = 0x20000000
	// Position of P30 field.
	PIO_CODR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_CODR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_CODR_P30 = 0x40000000
	// Position of P31 field.
	PIO_CODR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_CODR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_CODR_P31 = 0x80000000

	// ODSR: Output Data Status Register
	// Position of P0 field.
	PIO_ODSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ODSR_P0_Msk = 0x1
	// Bit P0.
	PIO_ODSR_P0 = 0x1
	// Position of P1 field.
	PIO_ODSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ODSR_P1_Msk = 0x2
	// Bit P1.
	PIO_ODSR_P1 = 0x2
	// Position of P2 field.
	PIO_ODSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ODSR_P2_Msk = 0x4
	// Bit P2.
	PIO_ODSR_P2 = 0x4
	// Position of P3 field.
	PIO_ODSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ODSR_P3_Msk = 0x8
	// Bit P3.
	PIO_ODSR_P3 = 0x8
	// Position of P4 field.
	PIO_ODSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ODSR_P4_Msk = 0x10
	// Bit P4.
	PIO_ODSR_P4 = 0x10
	// Position of P5 field.
	PIO_ODSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ODSR_P5_Msk = 0x20
	// Bit P5.
	PIO_ODSR_P5 = 0x20
	// Position of P6 field.
	PIO_ODSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ODSR_P6_Msk = 0x40
	// Bit P6.
	PIO_ODSR_P6 = 0x40
	// Position of P7 field.
	PIO_ODSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ODSR_P7_Msk = 0x80
	// Bit P7.
	PIO_ODSR_P7 = 0x80
	// Position of P8 field.
	PIO_ODSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ODSR_P8_Msk = 0x100
	// Bit P8.
	PIO_ODSR_P8 = 0x100
	// Position of P9 field.
	PIO_ODSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ODSR_P9_Msk = 0x200
	// Bit P9.
	PIO_ODSR_P9 = 0x200
	// Position of P10 field.
	PIO_ODSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ODSR_P10_Msk = 0x400
	// Bit P10.
	PIO_ODSR_P10 = 0x400
	// Position of P11 field.
	PIO_ODSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ODSR_P11_Msk = 0x800
	// Bit P11.
	PIO_ODSR_P11 = 0x800
	// Position of P12 field.
	PIO_ODSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ODSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ODSR_P12 = 0x1000
	// Position of P13 field.
	PIO_ODSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ODSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ODSR_P13 = 0x2000
	// Position of P14 field.
	PIO_ODSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ODSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ODSR_P14 = 0x4000
	// Position of P15 field.
	PIO_ODSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ODSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ODSR_P15 = 0x8000
	// Position of P16 field.
	PIO_ODSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ODSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ODSR_P16 = 0x10000
	// Position of P17 field.
	PIO_ODSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ODSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ODSR_P17 = 0x20000
	// Position of P18 field.
	PIO_ODSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ODSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ODSR_P18 = 0x40000
	// Position of P19 field.
	PIO_ODSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ODSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ODSR_P19 = 0x80000
	// Position of P20 field.
	PIO_ODSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ODSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ODSR_P20 = 0x100000
	// Position of P21 field.
	PIO_ODSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ODSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ODSR_P21 = 0x200000
	// Position of P22 field.
	PIO_ODSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ODSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ODSR_P22 = 0x400000
	// Position of P23 field.
	PIO_ODSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ODSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ODSR_P23 = 0x800000
	// Position of P24 field.
	PIO_ODSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ODSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ODSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ODSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ODSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ODSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ODSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ODSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ODSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ODSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ODSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ODSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ODSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ODSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ODSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ODSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ODSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ODSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ODSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ODSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ODSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ODSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ODSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ODSR_P31 = 0x80000000

	// PDSR: Pin Data Status Register
	// Position of P0 field.
	PIO_PDSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PDSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PDSR_P0 = 0x1
	// Position of P1 field.
	PIO_PDSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PDSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PDSR_P1 = 0x2
	// Position of P2 field.
	PIO_PDSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PDSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PDSR_P2 = 0x4
	// Position of P3 field.
	PIO_PDSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PDSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PDSR_P3 = 0x8
	// Position of P4 field.
	PIO_PDSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PDSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PDSR_P4 = 0x10
	// Position of P5 field.
	PIO_PDSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PDSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PDSR_P5 = 0x20
	// Position of P6 field.
	PIO_PDSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PDSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PDSR_P6 = 0x40
	// Position of P7 field.
	PIO_PDSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PDSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PDSR_P7 = 0x80
	// Position of P8 field.
	PIO_PDSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PDSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PDSR_P8 = 0x100
	// Position of P9 field.
	PIO_PDSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PDSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PDSR_P9 = 0x200
	// Position of P10 field.
	PIO_PDSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PDSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PDSR_P10 = 0x400
	// Position of P11 field.
	PIO_PDSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PDSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PDSR_P11 = 0x800
	// Position of P12 field.
	PIO_PDSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PDSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PDSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PDSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PDSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PDSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PDSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PDSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PDSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PDSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PDSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PDSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PDSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PDSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PDSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PDSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PDSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PDSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PDSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PDSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PDSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PDSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PDSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PDSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PDSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PDSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PDSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PDSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PDSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PDSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PDSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PDSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PDSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PDSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PDSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PDSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PDSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PDSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PDSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PDSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PDSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PDSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PDSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PDSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PDSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PDSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PDSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PDSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PDSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PDSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PDSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PDSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PDSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PDSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PDSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PDSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PDSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PDSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PDSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PDSR_P31 = 0x80000000

	// IER: Interrupt Enable Register
	// Position of P0 field.
	PIO_IER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IER_P0_Msk = 0x1
	// Bit P0.
	PIO_IER_P0 = 0x1
	// Position of P1 field.
	PIO_IER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IER_P1_Msk = 0x2
	// Bit P1.
	PIO_IER_P1 = 0x2
	// Position of P2 field.
	PIO_IER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IER_P2_Msk = 0x4
	// Bit P2.
	PIO_IER_P2 = 0x4
	// Position of P3 field.
	PIO_IER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IER_P3_Msk = 0x8
	// Bit P3.
	PIO_IER_P3 = 0x8
	// Position of P4 field.
	PIO_IER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IER_P4_Msk = 0x10
	// Bit P4.
	PIO_IER_P4 = 0x10
	// Position of P5 field.
	PIO_IER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IER_P5_Msk = 0x20
	// Bit P5.
	PIO_IER_P5 = 0x20
	// Position of P6 field.
	PIO_IER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IER_P6_Msk = 0x40
	// Bit P6.
	PIO_IER_P6 = 0x40
	// Position of P7 field.
	PIO_IER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IER_P7_Msk = 0x80
	// Bit P7.
	PIO_IER_P7 = 0x80
	// Position of P8 field.
	PIO_IER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IER_P8_Msk = 0x100
	// Bit P8.
	PIO_IER_P8 = 0x100
	// Position of P9 field.
	PIO_IER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IER_P9_Msk = 0x200
	// Bit P9.
	PIO_IER_P9 = 0x200
	// Position of P10 field.
	PIO_IER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IER_P10_Msk = 0x400
	// Bit P10.
	PIO_IER_P10 = 0x400
	// Position of P11 field.
	PIO_IER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IER_P11_Msk = 0x800
	// Bit P11.
	PIO_IER_P11 = 0x800
	// Position of P12 field.
	PIO_IER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IER_P12_Msk = 0x1000
	// Bit P12.
	PIO_IER_P12 = 0x1000
	// Position of P13 field.
	PIO_IER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IER_P13_Msk = 0x2000
	// Bit P13.
	PIO_IER_P13 = 0x2000
	// Position of P14 field.
	PIO_IER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IER_P14_Msk = 0x4000
	// Bit P14.
	PIO_IER_P14 = 0x4000
	// Position of P15 field.
	PIO_IER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IER_P15_Msk = 0x8000
	// Bit P15.
	PIO_IER_P15 = 0x8000
	// Position of P16 field.
	PIO_IER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IER_P16_Msk = 0x10000
	// Bit P16.
	PIO_IER_P16 = 0x10000
	// Position of P17 field.
	PIO_IER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IER_P17_Msk = 0x20000
	// Bit P17.
	PIO_IER_P17 = 0x20000
	// Position of P18 field.
	PIO_IER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IER_P18_Msk = 0x40000
	// Bit P18.
	PIO_IER_P18 = 0x40000
	// Position of P19 field.
	PIO_IER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IER_P19_Msk = 0x80000
	// Bit P19.
	PIO_IER_P19 = 0x80000
	// Position of P20 field.
	PIO_IER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IER_P20_Msk = 0x100000
	// Bit P20.
	PIO_IER_P20 = 0x100000
	// Position of P21 field.
	PIO_IER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IER_P21_Msk = 0x200000
	// Bit P21.
	PIO_IER_P21 = 0x200000
	// Position of P22 field.
	PIO_IER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IER_P22_Msk = 0x400000
	// Bit P22.
	PIO_IER_P22 = 0x400000
	// Position of P23 field.
	PIO_IER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IER_P23_Msk = 0x800000
	// Bit P23.
	PIO_IER_P23 = 0x800000
	// Position of P24 field.
	PIO_IER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IER_P24 = 0x1000000
	// Position of P25 field.
	PIO_IER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IER_P25 = 0x2000000
	// Position of P26 field.
	PIO_IER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IER_P26 = 0x4000000
	// Position of P27 field.
	PIO_IER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IER_P27 = 0x8000000
	// Position of P28 field.
	PIO_IER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IER_P28 = 0x10000000
	// Position of P29 field.
	PIO_IER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IER_P29 = 0x20000000
	// Position of P30 field.
	PIO_IER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IER_P30 = 0x40000000
	// Position of P31 field.
	PIO_IER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IER_P31 = 0x80000000

	// IDR: Interrupt Disable Register
	// Position of P0 field.
	PIO_IDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IDR_P0_Msk = 0x1
	// Bit P0.
	PIO_IDR_P0 = 0x1
	// Position of P1 field.
	PIO_IDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IDR_P1_Msk = 0x2
	// Bit P1.
	PIO_IDR_P1 = 0x2
	// Position of P2 field.
	PIO_IDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IDR_P2_Msk = 0x4
	// Bit P2.
	PIO_IDR_P2 = 0x4
	// Position of P3 field.
	PIO_IDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IDR_P3_Msk = 0x8
	// Bit P3.
	PIO_IDR_P3 = 0x8
	// Position of P4 field.
	PIO_IDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IDR_P4_Msk = 0x10
	// Bit P4.
	PIO_IDR_P4 = 0x10
	// Position of P5 field.
	PIO_IDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IDR_P5_Msk = 0x20
	// Bit P5.
	PIO_IDR_P5 = 0x20
	// Position of P6 field.
	PIO_IDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IDR_P6_Msk = 0x40
	// Bit P6.
	PIO_IDR_P6 = 0x40
	// Position of P7 field.
	PIO_IDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IDR_P7_Msk = 0x80
	// Bit P7.
	PIO_IDR_P7 = 0x80
	// Position of P8 field.
	PIO_IDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IDR_P8_Msk = 0x100
	// Bit P8.
	PIO_IDR_P8 = 0x100
	// Position of P9 field.
	PIO_IDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IDR_P9_Msk = 0x200
	// Bit P9.
	PIO_IDR_P9 = 0x200
	// Position of P10 field.
	PIO_IDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IDR_P10_Msk = 0x400
	// Bit P10.
	PIO_IDR_P10 = 0x400
	// Position of P11 field.
	PIO_IDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IDR_P11_Msk = 0x800
	// Bit P11.
	PIO_IDR_P11 = 0x800
	// Position of P12 field.
	PIO_IDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IDR_P12 = 0x1000
	// Position of P13 field.
	PIO_IDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IDR_P13 = 0x2000
	// Position of P14 field.
	PIO_IDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IDR_P14 = 0x4000
	// Position of P15 field.
	PIO_IDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IDR_P15 = 0x8000
	// Position of P16 field.
	PIO_IDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IDR_P16 = 0x10000
	// Position of P17 field.
	PIO_IDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IDR_P17 = 0x20000
	// Position of P18 field.
	PIO_IDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IDR_P18 = 0x40000
	// Position of P19 field.
	PIO_IDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IDR_P19 = 0x80000
	// Position of P20 field.
	PIO_IDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IDR_P20 = 0x100000
	// Position of P21 field.
	PIO_IDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IDR_P21 = 0x200000
	// Position of P22 field.
	PIO_IDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IDR_P22 = 0x400000
	// Position of P23 field.
	PIO_IDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IDR_P23 = 0x800000
	// Position of P24 field.
	PIO_IDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IDR_P31 = 0x80000000

	// IMR: Interrupt Mask Register
	// Position of P0 field.
	PIO_IMR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IMR_P0_Msk = 0x1
	// Bit P0.
	PIO_IMR_P0 = 0x1
	// Position of P1 field.
	PIO_IMR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IMR_P1_Msk = 0x2
	// Bit P1.
	PIO_IMR_P1 = 0x2
	// Position of P2 field.
	PIO_IMR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IMR_P2_Msk = 0x4
	// Bit P2.
	PIO_IMR_P2 = 0x4
	// Position of P3 field.
	PIO_IMR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IMR_P3_Msk = 0x8
	// Bit P3.
	PIO_IMR_P3 = 0x8
	// Position of P4 field.
	PIO_IMR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IMR_P4_Msk = 0x10
	// Bit P4.
	PIO_IMR_P4 = 0x10
	// Position of P5 field.
	PIO_IMR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IMR_P5_Msk = 0x20
	// Bit P5.
	PIO_IMR_P5 = 0x20
	// Position of P6 field.
	PIO_IMR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IMR_P6_Msk = 0x40
	// Bit P6.
	PIO_IMR_P6 = 0x40
	// Position of P7 field.
	PIO_IMR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IMR_P7_Msk = 0x80
	// Bit P7.
	PIO_IMR_P7 = 0x80
	// Position of P8 field.
	PIO_IMR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IMR_P8_Msk = 0x100
	// Bit P8.
	PIO_IMR_P8 = 0x100
	// Position of P9 field.
	PIO_IMR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IMR_P9_Msk = 0x200
	// Bit P9.
	PIO_IMR_P9 = 0x200
	// Position of P10 field.
	PIO_IMR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IMR_P10_Msk = 0x400
	// Bit P10.
	PIO_IMR_P10 = 0x400
	// Position of P11 field.
	PIO_IMR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IMR_P11_Msk = 0x800
	// Bit P11.
	PIO_IMR_P11 = 0x800
	// Position of P12 field.
	PIO_IMR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IMR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IMR_P12 = 0x1000
	// Position of P13 field.
	PIO_IMR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IMR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IMR_P13 = 0x2000
	// Position of P14 field.
	PIO_IMR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IMR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IMR_P14 = 0x4000
	// Position of P15 field.
	PIO_IMR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IMR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IMR_P15 = 0x8000
	// Position of P16 field.
	PIO_IMR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IMR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IMR_P16 = 0x10000
	// Position of P17 field.
	PIO_IMR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IMR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IMR_P17 = 0x20000
	// Position of P18 field.
	PIO_IMR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IMR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IMR_P18 = 0x40000
	// Position of P19 field.
	PIO_IMR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IMR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IMR_P19 = 0x80000
	// Position of P20 field.
	PIO_IMR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IMR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IMR_P20 = 0x100000
	// Position of P21 field.
	PIO_IMR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IMR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IMR_P21 = 0x200000
	// Position of P22 field.
	PIO_IMR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IMR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IMR_P22 = 0x400000
	// Position of P23 field.
	PIO_IMR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IMR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IMR_P23 = 0x800000
	// Position of P24 field.
	PIO_IMR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IMR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IMR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IMR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IMR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IMR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IMR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IMR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IMR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IMR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IMR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IMR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IMR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IMR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IMR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IMR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IMR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IMR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IMR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IMR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IMR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IMR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IMR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IMR_P31 = 0x80000000

	// ISR: Interrupt Status Register
	// Position of P0 field.
	PIO_ISR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ISR_P0_Msk = 0x1
	// Bit P0.
	PIO_ISR_P0 = 0x1
	// Position of P1 field.
	PIO_ISR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ISR_P1_Msk = 0x2
	// Bit P1.
	PIO_ISR_P1 = 0x2
	// Position of P2 field.
	PIO_ISR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ISR_P2_Msk = 0x4
	// Bit P2.
	PIO_ISR_P2 = 0x4
	// Position of P3 field.
	PIO_ISR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ISR_P3_Msk = 0x8
	// Bit P3.
	PIO_ISR_P3 = 0x8
	// Position of P4 field.
	PIO_ISR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ISR_P4_Msk = 0x10
	// Bit P4.
	PIO_ISR_P4 = 0x10
	// Position of P5 field.
	PIO_ISR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ISR_P5_Msk = 0x20
	// Bit P5.
	PIO_ISR_P5 = 0x20
	// Position of P6 field.
	PIO_ISR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ISR_P6_Msk = 0x40
	// Bit P6.
	PIO_ISR_P6 = 0x40
	// Position of P7 field.
	PIO_ISR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ISR_P7_Msk = 0x80
	// Bit P7.
	PIO_ISR_P7 = 0x80
	// Position of P8 field.
	PIO_ISR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ISR_P8_Msk = 0x100
	// Bit P8.
	PIO_ISR_P8 = 0x100
	// Position of P9 field.
	PIO_ISR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ISR_P9_Msk = 0x200
	// Bit P9.
	PIO_ISR_P9 = 0x200
	// Position of P10 field.
	PIO_ISR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ISR_P10_Msk = 0x400
	// Bit P10.
	PIO_ISR_P10 = 0x400
	// Position of P11 field.
	PIO_ISR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ISR_P11_Msk = 0x800
	// Bit P11.
	PIO_ISR_P11 = 0x800
	// Position of P12 field.
	PIO_ISR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ISR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ISR_P12 = 0x1000
	// Position of P13 field.
	PIO_ISR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ISR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ISR_P13 = 0x2000
	// Position of P14 field.
	PIO_ISR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ISR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ISR_P14 = 0x4000
	// Position of P15 field.
	PIO_ISR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ISR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ISR_P15 = 0x8000
	// Position of P16 field.
	PIO_ISR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ISR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ISR_P16 = 0x10000
	// Position of P17 field.
	PIO_ISR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ISR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ISR_P17 = 0x20000
	// Position of P18 field.
	PIO_ISR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ISR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ISR_P18 = 0x40000
	// Position of P19 field.
	PIO_ISR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ISR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ISR_P19 = 0x80000
	// Position of P20 field.
	PIO_ISR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ISR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ISR_P20 = 0x100000
	// Position of P21 field.
	PIO_ISR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ISR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ISR_P21 = 0x200000
	// Position of P22 field.
	PIO_ISR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ISR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ISR_P22 = 0x400000
	// Position of P23 field.
	PIO_ISR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ISR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ISR_P23 = 0x800000
	// Position of P24 field.
	PIO_ISR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ISR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ISR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ISR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ISR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ISR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ISR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ISR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ISR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ISR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ISR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ISR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ISR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ISR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ISR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ISR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ISR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ISR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ISR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ISR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ISR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ISR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ISR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ISR_P31 = 0x80000000

	// MDER: Multi-driver Enable Register
	// Position of P0 field.
	PIO_MDER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_MDER_P0_Msk = 0x1
	// Bit P0.
	PIO_MDER_P0 = 0x1
	// Position of P1 field.
	PIO_MDER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_MDER_P1_Msk = 0x2
	// Bit P1.
	PIO_MDER_P1 = 0x2
	// Position of P2 field.
	PIO_MDER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_MDER_P2_Msk = 0x4
	// Bit P2.
	PIO_MDER_P2 = 0x4
	// Position of P3 field.
	PIO_MDER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_MDER_P3_Msk = 0x8
	// Bit P3.
	PIO_MDER_P3 = 0x8
	// Position of P4 field.
	PIO_MDER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_MDER_P4_Msk = 0x10
	// Bit P4.
	PIO_MDER_P4 = 0x10
	// Position of P5 field.
	PIO_MDER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_MDER_P5_Msk = 0x20
	// Bit P5.
	PIO_MDER_P5 = 0x20
	// Position of P6 field.
	PIO_MDER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_MDER_P6_Msk = 0x40
	// Bit P6.
	PIO_MDER_P6 = 0x40
	// Position of P7 field.
	PIO_MDER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_MDER_P7_Msk = 0x80
	// Bit P7.
	PIO_MDER_P7 = 0x80
	// Position of P8 field.
	PIO_MDER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_MDER_P8_Msk = 0x100
	// Bit P8.
	PIO_MDER_P8 = 0x100
	// Position of P9 field.
	PIO_MDER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_MDER_P9_Msk = 0x200
	// Bit P9.
	PIO_MDER_P9 = 0x200
	// Position of P10 field.
	PIO_MDER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_MDER_P10_Msk = 0x400
	// Bit P10.
	PIO_MDER_P10 = 0x400
	// Position of P11 field.
	PIO_MDER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_MDER_P11_Msk = 0x800
	// Bit P11.
	PIO_MDER_P11 = 0x800
	// Position of P12 field.
	PIO_MDER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_MDER_P12_Msk = 0x1000
	// Bit P12.
	PIO_MDER_P12 = 0x1000
	// Position of P13 field.
	PIO_MDER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_MDER_P13_Msk = 0x2000
	// Bit P13.
	PIO_MDER_P13 = 0x2000
	// Position of P14 field.
	PIO_MDER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_MDER_P14_Msk = 0x4000
	// Bit P14.
	PIO_MDER_P14 = 0x4000
	// Position of P15 field.
	PIO_MDER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_MDER_P15_Msk = 0x8000
	// Bit P15.
	PIO_MDER_P15 = 0x8000
	// Position of P16 field.
	PIO_MDER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_MDER_P16_Msk = 0x10000
	// Bit P16.
	PIO_MDER_P16 = 0x10000
	// Position of P17 field.
	PIO_MDER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_MDER_P17_Msk = 0x20000
	// Bit P17.
	PIO_MDER_P17 = 0x20000
	// Position of P18 field.
	PIO_MDER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_MDER_P18_Msk = 0x40000
	// Bit P18.
	PIO_MDER_P18 = 0x40000
	// Position of P19 field.
	PIO_MDER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_MDER_P19_Msk = 0x80000
	// Bit P19.
	PIO_MDER_P19 = 0x80000
	// Position of P20 field.
	PIO_MDER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_MDER_P20_Msk = 0x100000
	// Bit P20.
	PIO_MDER_P20 = 0x100000
	// Position of P21 field.
	PIO_MDER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_MDER_P21_Msk = 0x200000
	// Bit P21.
	PIO_MDER_P21 = 0x200000
	// Position of P22 field.
	PIO_MDER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_MDER_P22_Msk = 0x400000
	// Bit P22.
	PIO_MDER_P22 = 0x400000
	// Position of P23 field.
	PIO_MDER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_MDER_P23_Msk = 0x800000
	// Bit P23.
	PIO_MDER_P23 = 0x800000
	// Position of P24 field.
	PIO_MDER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_MDER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_MDER_P24 = 0x1000000
	// Position of P25 field.
	PIO_MDER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_MDER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_MDER_P25 = 0x2000000
	// Position of P26 field.
	PIO_MDER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_MDER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_MDER_P26 = 0x4000000
	// Position of P27 field.
	PIO_MDER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_MDER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_MDER_P27 = 0x8000000
	// Position of P28 field.
	PIO_MDER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_MDER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_MDER_P28 = 0x10000000
	// Position of P29 field.
	PIO_MDER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_MDER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_MDER_P29 = 0x20000000
	// Position of P30 field.
	PIO_MDER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_MDER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_MDER_P30 = 0x40000000
	// Position of P31 field.
	PIO_MDER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_MDER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_MDER_P31 = 0x80000000

	// MDDR: Multi-driver Disable Register
	// Position of P0 field.
	PIO_MDDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_MDDR_P0_Msk = 0x1
	// Bit P0.
	PIO_MDDR_P0 = 0x1
	// Position of P1 field.
	PIO_MDDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_MDDR_P1_Msk = 0x2
	// Bit P1.
	PIO_MDDR_P1 = 0x2
	// Position of P2 field.
	PIO_MDDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_MDDR_P2_Msk = 0x4
	// Bit P2.
	PIO_MDDR_P2 = 0x4
	// Position of P3 field.
	PIO_MDDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_MDDR_P3_Msk = 0x8
	// Bit P3.
	PIO_MDDR_P3 = 0x8
	// Position of P4 field.
	PIO_MDDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_MDDR_P4_Msk = 0x10
	// Bit P4.
	PIO_MDDR_P4 = 0x10
	// Position of P5 field.
	PIO_MDDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_MDDR_P5_Msk = 0x20
	// Bit P5.
	PIO_MDDR_P5 = 0x20
	// Position of P6 field.
	PIO_MDDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_MDDR_P6_Msk = 0x40
	// Bit P6.
	PIO_MDDR_P6 = 0x40
	// Position of P7 field.
	PIO_MDDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_MDDR_P7_Msk = 0x80
	// Bit P7.
	PIO_MDDR_P7 = 0x80
	// Position of P8 field.
	PIO_MDDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_MDDR_P8_Msk = 0x100
	// Bit P8.
	PIO_MDDR_P8 = 0x100
	// Position of P9 field.
	PIO_MDDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_MDDR_P9_Msk = 0x200
	// Bit P9.
	PIO_MDDR_P9 = 0x200
	// Position of P10 field.
	PIO_MDDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_MDDR_P10_Msk = 0x400
	// Bit P10.
	PIO_MDDR_P10 = 0x400
	// Position of P11 field.
	PIO_MDDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_MDDR_P11_Msk = 0x800
	// Bit P11.
	PIO_MDDR_P11 = 0x800
	// Position of P12 field.
	PIO_MDDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_MDDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_MDDR_P12 = 0x1000
	// Position of P13 field.
	PIO_MDDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_MDDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_MDDR_P13 = 0x2000
	// Position of P14 field.
	PIO_MDDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_MDDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_MDDR_P14 = 0x4000
	// Position of P15 field.
	PIO_MDDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_MDDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_MDDR_P15 = 0x8000
	// Position of P16 field.
	PIO_MDDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_MDDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_MDDR_P16 = 0x10000
	// Position of P17 field.
	PIO_MDDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_MDDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_MDDR_P17 = 0x20000
	// Position of P18 field.
	PIO_MDDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_MDDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_MDDR_P18 = 0x40000
	// Position of P19 field.
	PIO_MDDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_MDDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_MDDR_P19 = 0x80000
	// Position of P20 field.
	PIO_MDDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_MDDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_MDDR_P20 = 0x100000
	// Position of P21 field.
	PIO_MDDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_MDDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_MDDR_P21 = 0x200000
	// Position of P22 field.
	PIO_MDDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_MDDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_MDDR_P22 = 0x400000
	// Position of P23 field.
	PIO_MDDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_MDDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_MDDR_P23 = 0x800000
	// Position of P24 field.
	PIO_MDDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_MDDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_MDDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_MDDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_MDDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_MDDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_MDDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_MDDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_MDDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_MDDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_MDDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_MDDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_MDDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_MDDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_MDDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_MDDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_MDDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_MDDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_MDDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_MDDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_MDDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_MDDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_MDDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_MDDR_P31 = 0x80000000

	// MDSR: Multi-driver Status Register
	// Position of P0 field.
	PIO_MDSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_MDSR_P0_Msk = 0x1
	// Bit P0.
	PIO_MDSR_P0 = 0x1
	// Position of P1 field.
	PIO_MDSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_MDSR_P1_Msk = 0x2
	// Bit P1.
	PIO_MDSR_P1 = 0x2
	// Position of P2 field.
	PIO_MDSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_MDSR_P2_Msk = 0x4
	// Bit P2.
	PIO_MDSR_P2 = 0x4
	// Position of P3 field.
	PIO_MDSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_MDSR_P3_Msk = 0x8
	// Bit P3.
	PIO_MDSR_P3 = 0x8
	// Position of P4 field.
	PIO_MDSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_MDSR_P4_Msk = 0x10
	// Bit P4.
	PIO_MDSR_P4 = 0x10
	// Position of P5 field.
	PIO_MDSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_MDSR_P5_Msk = 0x20
	// Bit P5.
	PIO_MDSR_P5 = 0x20
	// Position of P6 field.
	PIO_MDSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_MDSR_P6_Msk = 0x40
	// Bit P6.
	PIO_MDSR_P6 = 0x40
	// Position of P7 field.
	PIO_MDSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_MDSR_P7_Msk = 0x80
	// Bit P7.
	PIO_MDSR_P7 = 0x80
	// Position of P8 field.
	PIO_MDSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_MDSR_P8_Msk = 0x100
	// Bit P8.
	PIO_MDSR_P8 = 0x100
	// Position of P9 field.
	PIO_MDSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_MDSR_P9_Msk = 0x200
	// Bit P9.
	PIO_MDSR_P9 = 0x200
	// Position of P10 field.
	PIO_MDSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_MDSR_P10_Msk = 0x400
	// Bit P10.
	PIO_MDSR_P10 = 0x400
	// Position of P11 field.
	PIO_MDSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_MDSR_P11_Msk = 0x800
	// Bit P11.
	PIO_MDSR_P11 = 0x800
	// Position of P12 field.
	PIO_MDSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_MDSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_MDSR_P12 = 0x1000
	// Position of P13 field.
	PIO_MDSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_MDSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_MDSR_P13 = 0x2000
	// Position of P14 field.
	PIO_MDSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_MDSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_MDSR_P14 = 0x4000
	// Position of P15 field.
	PIO_MDSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_MDSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_MDSR_P15 = 0x8000
	// Position of P16 field.
	PIO_MDSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_MDSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_MDSR_P16 = 0x10000
	// Position of P17 field.
	PIO_MDSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_MDSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_MDSR_P17 = 0x20000
	// Position of P18 field.
	PIO_MDSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_MDSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_MDSR_P18 = 0x40000
	// Position of P19 field.
	PIO_MDSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_MDSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_MDSR_P19 = 0x80000
	// Position of P20 field.
	PIO_MDSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_MDSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_MDSR_P20 = 0x100000
	// Position of P21 field.
	PIO_MDSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_MDSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_MDSR_P21 = 0x200000
	// Position of P22 field.
	PIO_MDSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_MDSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_MDSR_P22 = 0x400000
	// Position of P23 field.
	PIO_MDSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_MDSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_MDSR_P23 = 0x800000
	// Position of P24 field.
	PIO_MDSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_MDSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_MDSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_MDSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_MDSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_MDSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_MDSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_MDSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_MDSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_MDSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_MDSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_MDSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_MDSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_MDSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_MDSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_MDSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_MDSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_MDSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_MDSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_MDSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_MDSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_MDSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_MDSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_MDSR_P31 = 0x80000000

	// PUDR: Pull-up Disable Register
	// Position of P0 field.
	PIO_PUDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PUDR_P0_Msk = 0x1
	// Bit P0.
	PIO_PUDR_P0 = 0x1
	// Position of P1 field.
	PIO_PUDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PUDR_P1_Msk = 0x2
	// Bit P1.
	PIO_PUDR_P1 = 0x2
	// Position of P2 field.
	PIO_PUDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PUDR_P2_Msk = 0x4
	// Bit P2.
	PIO_PUDR_P2 = 0x4
	// Position of P3 field.
	PIO_PUDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PUDR_P3_Msk = 0x8
	// Bit P3.
	PIO_PUDR_P3 = 0x8
	// Position of P4 field.
	PIO_PUDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PUDR_P4_Msk = 0x10
	// Bit P4.
	PIO_PUDR_P4 = 0x10
	// Position of P5 field.
	PIO_PUDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PUDR_P5_Msk = 0x20
	// Bit P5.
	PIO_PUDR_P5 = 0x20
	// Position of P6 field.
	PIO_PUDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PUDR_P6_Msk = 0x40
	// Bit P6.
	PIO_PUDR_P6 = 0x40
	// Position of P7 field.
	PIO_PUDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PUDR_P7_Msk = 0x80
	// Bit P7.
	PIO_PUDR_P7 = 0x80
	// Position of P8 field.
	PIO_PUDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PUDR_P8_Msk = 0x100
	// Bit P8.
	PIO_PUDR_P8 = 0x100
	// Position of P9 field.
	PIO_PUDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PUDR_P9_Msk = 0x200
	// Bit P9.
	PIO_PUDR_P9 = 0x200
	// Position of P10 field.
	PIO_PUDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PUDR_P10_Msk = 0x400
	// Bit P10.
	PIO_PUDR_P10 = 0x400
	// Position of P11 field.
	PIO_PUDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PUDR_P11_Msk = 0x800
	// Bit P11.
	PIO_PUDR_P11 = 0x800
	// Position of P12 field.
	PIO_PUDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PUDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PUDR_P12 = 0x1000
	// Position of P13 field.
	PIO_PUDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PUDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PUDR_P13 = 0x2000
	// Position of P14 field.
	PIO_PUDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PUDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PUDR_P14 = 0x4000
	// Position of P15 field.
	PIO_PUDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PUDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PUDR_P15 = 0x8000
	// Position of P16 field.
	PIO_PUDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PUDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PUDR_P16 = 0x10000
	// Position of P17 field.
	PIO_PUDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PUDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PUDR_P17 = 0x20000
	// Position of P18 field.
	PIO_PUDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PUDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PUDR_P18 = 0x40000
	// Position of P19 field.
	PIO_PUDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PUDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PUDR_P19 = 0x80000
	// Position of P20 field.
	PIO_PUDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PUDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PUDR_P20 = 0x100000
	// Position of P21 field.
	PIO_PUDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PUDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PUDR_P21 = 0x200000
	// Position of P22 field.
	PIO_PUDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PUDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PUDR_P22 = 0x400000
	// Position of P23 field.
	PIO_PUDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PUDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PUDR_P23 = 0x800000
	// Position of P24 field.
	PIO_PUDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PUDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PUDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PUDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PUDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PUDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PUDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PUDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PUDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PUDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PUDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PUDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PUDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PUDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PUDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PUDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PUDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PUDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PUDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PUDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PUDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PUDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PUDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PUDR_P31 = 0x80000000

	// PUER: Pull-up Enable Register
	// Position of P0 field.
	PIO_PUER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PUER_P0_Msk = 0x1
	// Bit P0.
	PIO_PUER_P0 = 0x1
	// Position of P1 field.
	PIO_PUER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PUER_P1_Msk = 0x2
	// Bit P1.
	PIO_PUER_P1 = 0x2
	// Position of P2 field.
	PIO_PUER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PUER_P2_Msk = 0x4
	// Bit P2.
	PIO_PUER_P2 = 0x4
	// Position of P3 field.
	PIO_PUER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PUER_P3_Msk = 0x8
	// Bit P3.
	PIO_PUER_P3 = 0x8
	// Position of P4 field.
	PIO_PUER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PUER_P4_Msk = 0x10
	// Bit P4.
	PIO_PUER_P4 = 0x10
	// Position of P5 field.
	PIO_PUER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PUER_P5_Msk = 0x20
	// Bit P5.
	PIO_PUER_P5 = 0x20
	// Position of P6 field.
	PIO_PUER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PUER_P6_Msk = 0x40
	// Bit P6.
	PIO_PUER_P6 = 0x40
	// Position of P7 field.
	PIO_PUER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PUER_P7_Msk = 0x80
	// Bit P7.
	PIO_PUER_P7 = 0x80
	// Position of P8 field.
	PIO_PUER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PUER_P8_Msk = 0x100
	// Bit P8.
	PIO_PUER_P8 = 0x100
	// Position of P9 field.
	PIO_PUER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PUER_P9_Msk = 0x200
	// Bit P9.
	PIO_PUER_P9 = 0x200
	// Position of P10 field.
	PIO_PUER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PUER_P10_Msk = 0x400
	// Bit P10.
	PIO_PUER_P10 = 0x400
	// Position of P11 field.
	PIO_PUER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PUER_P11_Msk = 0x800
	// Bit P11.
	PIO_PUER_P11 = 0x800
	// Position of P12 field.
	PIO_PUER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PUER_P12_Msk = 0x1000
	// Bit P12.
	PIO_PUER_P12 = 0x1000
	// Position of P13 field.
	PIO_PUER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PUER_P13_Msk = 0x2000
	// Bit P13.
	PIO_PUER_P13 = 0x2000
	// Position of P14 field.
	PIO_PUER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PUER_P14_Msk = 0x4000
	// Bit P14.
	PIO_PUER_P14 = 0x4000
	// Position of P15 field.
	PIO_PUER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PUER_P15_Msk = 0x8000
	// Bit P15.
	PIO_PUER_P15 = 0x8000
	// Position of P16 field.
	PIO_PUER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PUER_P16_Msk = 0x10000
	// Bit P16.
	PIO_PUER_P16 = 0x10000
	// Position of P17 field.
	PIO_PUER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PUER_P17_Msk = 0x20000
	// Bit P17.
	PIO_PUER_P17 = 0x20000
	// Position of P18 field.
	PIO_PUER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PUER_P18_Msk = 0x40000
	// Bit P18.
	PIO_PUER_P18 = 0x40000
	// Position of P19 field.
	PIO_PUER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PUER_P19_Msk = 0x80000
	// Bit P19.
	PIO_PUER_P19 = 0x80000
	// Position of P20 field.
	PIO_PUER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PUER_P20_Msk = 0x100000
	// Bit P20.
	PIO_PUER_P20 = 0x100000
	// Position of P21 field.
	PIO_PUER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PUER_P21_Msk = 0x200000
	// Bit P21.
	PIO_PUER_P21 = 0x200000
	// Position of P22 field.
	PIO_PUER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PUER_P22_Msk = 0x400000
	// Bit P22.
	PIO_PUER_P22 = 0x400000
	// Position of P23 field.
	PIO_PUER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PUER_P23_Msk = 0x800000
	// Bit P23.
	PIO_PUER_P23 = 0x800000
	// Position of P24 field.
	PIO_PUER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PUER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PUER_P24 = 0x1000000
	// Position of P25 field.
	PIO_PUER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PUER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PUER_P25 = 0x2000000
	// Position of P26 field.
	PIO_PUER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PUER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PUER_P26 = 0x4000000
	// Position of P27 field.
	PIO_PUER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PUER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PUER_P27 = 0x8000000
	// Position of P28 field.
	PIO_PUER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PUER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PUER_P28 = 0x10000000
	// Position of P29 field.
	PIO_PUER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PUER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PUER_P29 = 0x20000000
	// Position of P30 field.
	PIO_PUER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PUER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PUER_P30 = 0x40000000
	// Position of P31 field.
	PIO_PUER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PUER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PUER_P31 = 0x80000000

	// PUSR: Pad Pull-up Status Register
	// Position of P0 field.
	PIO_PUSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PUSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PUSR_P0 = 0x1
	// Position of P1 field.
	PIO_PUSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PUSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PUSR_P1 = 0x2
	// Position of P2 field.
	PIO_PUSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PUSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PUSR_P2 = 0x4
	// Position of P3 field.
	PIO_PUSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PUSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PUSR_P3 = 0x8
	// Position of P4 field.
	PIO_PUSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PUSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PUSR_P4 = 0x10
	// Position of P5 field.
	PIO_PUSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PUSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PUSR_P5 = 0x20
	// Position of P6 field.
	PIO_PUSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PUSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PUSR_P6 = 0x40
	// Position of P7 field.
	PIO_PUSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PUSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PUSR_P7 = 0x80
	// Position of P8 field.
	PIO_PUSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PUSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PUSR_P8 = 0x100
	// Position of P9 field.
	PIO_PUSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PUSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PUSR_P9 = 0x200
	// Position of P10 field.
	PIO_PUSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PUSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PUSR_P10 = 0x400
	// Position of P11 field.
	PIO_PUSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PUSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PUSR_P11 = 0x800
	// Position of P12 field.
	PIO_PUSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PUSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PUSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PUSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PUSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PUSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PUSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PUSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PUSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PUSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PUSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PUSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PUSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PUSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PUSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PUSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PUSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PUSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PUSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PUSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PUSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PUSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PUSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PUSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PUSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PUSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PUSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PUSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PUSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PUSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PUSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PUSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PUSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PUSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PUSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PUSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PUSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PUSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PUSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PUSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PUSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PUSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PUSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PUSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PUSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PUSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PUSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PUSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PUSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PUSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PUSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PUSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PUSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PUSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PUSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PUSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PUSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PUSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PUSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PUSR_P31 = 0x80000000

	// ASR: Peripheral A Select Register
	// Position of P0 field.
	PIO_ASR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ASR_P0_Msk = 0x1
	// Bit P0.
	PIO_ASR_P0 = 0x1
	// Position of P1 field.
	PIO_ASR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ASR_P1_Msk = 0x2
	// Bit P1.
	PIO_ASR_P1 = 0x2
	// Position of P2 field.
	PIO_ASR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ASR_P2_Msk = 0x4
	// Bit P2.
	PIO_ASR_P2 = 0x4
	// Position of P3 field.
	PIO_ASR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ASR_P3_Msk = 0x8
	// Bit P3.
	PIO_ASR_P3 = 0x8
	// Position of P4 field.
	PIO_ASR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ASR_P4_Msk = 0x10
	// Bit P4.
	PIO_ASR_P4 = 0x10
	// Position of P5 field.
	PIO_ASR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ASR_P5_Msk = 0x20
	// Bit P5.
	PIO_ASR_P5 = 0x20
	// Position of P6 field.
	PIO_ASR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ASR_P6_Msk = 0x40
	// Bit P6.
	PIO_ASR_P6 = 0x40
	// Position of P7 field.
	PIO_ASR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ASR_P7_Msk = 0x80
	// Bit P7.
	PIO_ASR_P7 = 0x80
	// Position of P8 field.
	PIO_ASR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ASR_P8_Msk = 0x100
	// Bit P8.
	PIO_ASR_P8 = 0x100
	// Position of P9 field.
	PIO_ASR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ASR_P9_Msk = 0x200
	// Bit P9.
	PIO_ASR_P9 = 0x200
	// Position of P10 field.
	PIO_ASR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ASR_P10_Msk = 0x400
	// Bit P10.
	PIO_ASR_P10 = 0x400
	// Position of P11 field.
	PIO_ASR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ASR_P11_Msk = 0x800
	// Bit P11.
	PIO_ASR_P11 = 0x800
	// Position of P12 field.
	PIO_ASR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ASR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ASR_P12 = 0x1000
	// Position of P13 field.
	PIO_ASR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ASR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ASR_P13 = 0x2000
	// Position of P14 field.
	PIO_ASR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ASR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ASR_P14 = 0x4000
	// Position of P15 field.
	PIO_ASR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ASR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ASR_P15 = 0x8000
	// Position of P16 field.
	PIO_ASR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ASR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ASR_P16 = 0x10000
	// Position of P17 field.
	PIO_ASR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ASR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ASR_P17 = 0x20000
	// Position of P18 field.
	PIO_ASR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ASR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ASR_P18 = 0x40000
	// Position of P19 field.
	PIO_ASR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ASR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ASR_P19 = 0x80000
	// Position of P20 field.
	PIO_ASR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ASR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ASR_P20 = 0x100000
	// Position of P21 field.
	PIO_ASR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ASR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ASR_P21 = 0x200000
	// Position of P22 field.
	PIO_ASR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ASR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ASR_P22 = 0x400000
	// Position of P23 field.
	PIO_ASR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ASR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ASR_P23 = 0x800000
	// Position of P24 field.
	PIO_ASR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ASR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ASR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ASR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ASR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ASR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ASR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ASR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ASR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ASR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ASR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ASR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ASR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ASR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ASR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ASR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ASR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ASR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ASR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ASR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ASR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ASR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ASR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ASR_P31 = 0x80000000

	// BSR: Peripheral B Select Register
	// Position of P0 field.
	PIO_BSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_BSR_P0_Msk = 0x1
	// Bit P0.
	PIO_BSR_P0 = 0x1
	// Position of P1 field.
	PIO_BSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_BSR_P1_Msk = 0x2
	// Bit P1.
	PIO_BSR_P1 = 0x2
	// Position of P2 field.
	PIO_BSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_BSR_P2_Msk = 0x4
	// Bit P2.
	PIO_BSR_P2 = 0x4
	// Position of P3 field.
	PIO_BSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_BSR_P3_Msk = 0x8
	// Bit P3.
	PIO_BSR_P3 = 0x8
	// Position of P4 field.
	PIO_BSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_BSR_P4_Msk = 0x10
	// Bit P4.
	PIO_BSR_P4 = 0x10
	// Position of P5 field.
	PIO_BSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_BSR_P5_Msk = 0x20
	// Bit P5.
	PIO_BSR_P5 = 0x20
	// Position of P6 field.
	PIO_BSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_BSR_P6_Msk = 0x40
	// Bit P6.
	PIO_BSR_P6 = 0x40
	// Position of P7 field.
	PIO_BSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_BSR_P7_Msk = 0x80
	// Bit P7.
	PIO_BSR_P7 = 0x80
	// Position of P8 field.
	PIO_BSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_BSR_P8_Msk = 0x100
	// Bit P8.
	PIO_BSR_P8 = 0x100
	// Position of P9 field.
	PIO_BSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_BSR_P9_Msk = 0x200
	// Bit P9.
	PIO_BSR_P9 = 0x200
	// Position of P10 field.
	PIO_BSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_BSR_P10_Msk = 0x400
	// Bit P10.
	PIO_BSR_P10 = 0x400
	// Position of P11 field.
	PIO_BSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_BSR_P11_Msk = 0x800
	// Bit P11.
	PIO_BSR_P11 = 0x800
	// Position of P12 field.
	PIO_BSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_BSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_BSR_P12 = 0x1000
	// Position of P13 field.
	PIO_BSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_BSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_BSR_P13 = 0x2000
	// Position of P14 field.
	PIO_BSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_BSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_BSR_P14 = 0x4000
	// Position of P15 field.
	PIO_BSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_BSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_BSR_P15 = 0x8000
	// Position of P16 field.
	PIO_BSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_BSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_BSR_P16 = 0x10000
	// Position of P17 field.
	PIO_BSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_BSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_BSR_P17 = 0x20000
	// Position of P18 field.
	PIO_BSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_BSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_BSR_P18 = 0x40000
	// Position of P19 field.
	PIO_BSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_BSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_BSR_P19 = 0x80000
	// Position of P20 field.
	PIO_BSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_BSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_BSR_P20 = 0x100000
	// Position of P21 field.
	PIO_BSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_BSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_BSR_P21 = 0x200000
	// Position of P22 field.
	PIO_BSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_BSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_BSR_P22 = 0x400000
	// Position of P23 field.
	PIO_BSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_BSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_BSR_P23 = 0x800000
	// Position of P24 field.
	PIO_BSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_BSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_BSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_BSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_BSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_BSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_BSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_BSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_BSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_BSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_BSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_BSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_BSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_BSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_BSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_BSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_BSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_BSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_BSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_BSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_BSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_BSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_BSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_BSR_P31 = 0x80000000

	// ABSR: AB Status Register
	// Position of P0 field.
	PIO_ABSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ABSR_P0_Msk = 0x1
	// Bit P0.
	PIO_ABSR_P0 = 0x1
	// Position of P1 field.
	PIO_ABSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ABSR_P1_Msk = 0x2
	// Bit P1.
	PIO_ABSR_P1 = 0x2
	// Position of P2 field.
	PIO_ABSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ABSR_P2_Msk = 0x4
	// Bit P2.
	PIO_ABSR_P2 = 0x4
	// Position of P3 field.
	PIO_ABSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ABSR_P3_Msk = 0x8
	// Bit P3.
	PIO_ABSR_P3 = 0x8
	// Position of P4 field.
	PIO_ABSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ABSR_P4_Msk = 0x10
	// Bit P4.
	PIO_ABSR_P4 = 0x10
	// Position of P5 field.
	PIO_ABSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ABSR_P5_Msk = 0x20
	// Bit P5.
	PIO_ABSR_P5 = 0x20
	// Position of P6 field.
	PIO_ABSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ABSR_P6_Msk = 0x40
	// Bit P6.
	PIO_ABSR_P6 = 0x40
	// Position of P7 field.
	PIO_ABSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ABSR_P7_Msk = 0x80
	// Bit P7.
	PIO_ABSR_P7 = 0x80
	// Position of P8 field.
	PIO_ABSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ABSR_P8_Msk = 0x100
	// Bit P8.
	PIO_ABSR_P8 = 0x100
	// Position of P9 field.
	PIO_ABSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ABSR_P9_Msk = 0x200
	// Bit P9.
	PIO_ABSR_P9 = 0x200
	// Position of P10 field.
	PIO_ABSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ABSR_P10_Msk = 0x400
	// Bit P10.
	PIO_ABSR_P10 = 0x400
	// Position of P11 field.
	PIO_ABSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ABSR_P11_Msk = 0x800
	// Bit P11.
	PIO_ABSR_P11 = 0x800
	// Position of P12 field.
	PIO_ABSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ABSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ABSR_P12 = 0x1000
	// Position of P13 field.
	PIO_ABSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ABSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ABSR_P13 = 0x2000
	// Position of P14 field.
	PIO_ABSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ABSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ABSR_P14 = 0x4000
	// Position of P15 field.
	PIO_ABSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ABSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ABSR_P15 = 0x8000
	// Position of P16 field.
	PIO_ABSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ABSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ABSR_P16 = 0x10000
	// Position of P17 field.
	PIO_ABSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ABSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ABSR_P17 = 0x20000
	// Position of P18 field.
	PIO_ABSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ABSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ABSR_P18 = 0x40000
	// Position of P19 field.
	PIO_ABSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ABSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ABSR_P19 = 0x80000
	// Position of P20 field.
	PIO_ABSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ABSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ABSR_P20 = 0x100000
	// Position of P21 field.
	PIO_ABSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ABSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ABSR_P21 = 0x200000
	// Position of P22 field.
	PIO_ABSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ABSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ABSR_P22 = 0x400000
	// Position of P23 field.
	PIO_ABSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ABSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ABSR_P23 = 0x800000
	// Position of P24 field.
	PIO_ABSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ABSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ABSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ABSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ABSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ABSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ABSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ABSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ABSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ABSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ABSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ABSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ABSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ABSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ABSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ABSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ABSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ABSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ABSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ABSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ABSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ABSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ABSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ABSR_P31 = 0x80000000

	// OWER: Output Write Enable
	// Position of P0 field.
	PIO_OWER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OWER_P0_Msk = 0x1
	// Bit P0.
	PIO_OWER_P0 = 0x1
	// Position of P1 field.
	PIO_OWER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OWER_P1_Msk = 0x2
	// Bit P1.
	PIO_OWER_P1 = 0x2
	// Position of P2 field.
	PIO_OWER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OWER_P2_Msk = 0x4
	// Bit P2.
	PIO_OWER_P2 = 0x4
	// Position of P3 field.
	PIO_OWER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OWER_P3_Msk = 0x8
	// Bit P3.
	PIO_OWER_P3 = 0x8
	// Position of P4 field.
	PIO_OWER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OWER_P4_Msk = 0x10
	// Bit P4.
	PIO_OWER_P4 = 0x10
	// Position of P5 field.
	PIO_OWER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OWER_P5_Msk = 0x20
	// Bit P5.
	PIO_OWER_P5 = 0x20
	// Position of P6 field.
	PIO_OWER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OWER_P6_Msk = 0x40
	// Bit P6.
	PIO_OWER_P6 = 0x40
	// Position of P7 field.
	PIO_OWER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OWER_P7_Msk = 0x80
	// Bit P7.
	PIO_OWER_P7 = 0x80
	// Position of P8 field.
	PIO_OWER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OWER_P8_Msk = 0x100
	// Bit P8.
	PIO_OWER_P8 = 0x100
	// Position of P9 field.
	PIO_OWER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OWER_P9_Msk = 0x200
	// Bit P9.
	PIO_OWER_P9 = 0x200
	// Position of P10 field.
	PIO_OWER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OWER_P10_Msk = 0x400
	// Bit P10.
	PIO_OWER_P10 = 0x400
	// Position of P11 field.
	PIO_OWER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OWER_P11_Msk = 0x800
	// Bit P11.
	PIO_OWER_P11 = 0x800
	// Position of P12 field.
	PIO_OWER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OWER_P12_Msk = 0x1000
	// Bit P12.
	PIO_OWER_P12 = 0x1000
	// Position of P13 field.
	PIO_OWER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OWER_P13_Msk = 0x2000
	// Bit P13.
	PIO_OWER_P13 = 0x2000
	// Position of P14 field.
	PIO_OWER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OWER_P14_Msk = 0x4000
	// Bit P14.
	PIO_OWER_P14 = 0x4000
	// Position of P15 field.
	PIO_OWER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OWER_P15_Msk = 0x8000
	// Bit P15.
	PIO_OWER_P15 = 0x8000
	// Position of P16 field.
	PIO_OWER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OWER_P16_Msk = 0x10000
	// Bit P16.
	PIO_OWER_P16 = 0x10000
	// Position of P17 field.
	PIO_OWER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OWER_P17_Msk = 0x20000
	// Bit P17.
	PIO_OWER_P17 = 0x20000
	// Position of P18 field.
	PIO_OWER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OWER_P18_Msk = 0x40000
	// Bit P18.
	PIO_OWER_P18 = 0x40000
	// Position of P19 field.
	PIO_OWER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OWER_P19_Msk = 0x80000
	// Bit P19.
	PIO_OWER_P19 = 0x80000
	// Position of P20 field.
	PIO_OWER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OWER_P20_Msk = 0x100000
	// Bit P20.
	PIO_OWER_P20 = 0x100000
	// Position of P21 field.
	PIO_OWER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OWER_P21_Msk = 0x200000
	// Bit P21.
	PIO_OWER_P21 = 0x200000
	// Position of P22 field.
	PIO_OWER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OWER_P22_Msk = 0x400000
	// Bit P22.
	PIO_OWER_P22 = 0x400000
	// Position of P23 field.
	PIO_OWER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OWER_P23_Msk = 0x800000
	// Bit P23.
	PIO_OWER_P23 = 0x800000
	// Position of P24 field.
	PIO_OWER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OWER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OWER_P24 = 0x1000000
	// Position of P25 field.
	PIO_OWER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OWER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OWER_P25 = 0x2000000
	// Position of P26 field.
	PIO_OWER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OWER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OWER_P26 = 0x4000000
	// Position of P27 field.
	PIO_OWER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OWER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OWER_P27 = 0x8000000
	// Position of P28 field.
	PIO_OWER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OWER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OWER_P28 = 0x10000000
	// Position of P29 field.
	PIO_OWER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OWER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OWER_P29 = 0x20000000
	// Position of P30 field.
	PIO_OWER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OWER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OWER_P30 = 0x40000000
	// Position of P31 field.
	PIO_OWER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OWER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OWER_P31 = 0x80000000

	// OWDR: Output Write Disable
	// Position of P0 field.
	PIO_OWDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OWDR_P0_Msk = 0x1
	// Bit P0.
	PIO_OWDR_P0 = 0x1
	// Position of P1 field.
	PIO_OWDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OWDR_P1_Msk = 0x2
	// Bit P1.
	PIO_OWDR_P1 = 0x2
	// Position of P2 field.
	PIO_OWDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OWDR_P2_Msk = 0x4
	// Bit P2.
	PIO_OWDR_P2 = 0x4
	// Position of P3 field.
	PIO_OWDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OWDR_P3_Msk = 0x8
	// Bit P3.
	PIO_OWDR_P3 = 0x8
	// Position of P4 field.
	PIO_OWDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OWDR_P4_Msk = 0x10
	// Bit P4.
	PIO_OWDR_P4 = 0x10
	// Position of P5 field.
	PIO_OWDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OWDR_P5_Msk = 0x20
	// Bit P5.
	PIO_OWDR_P5 = 0x20
	// Position of P6 field.
	PIO_OWDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OWDR_P6_Msk = 0x40
	// Bit P6.
	PIO_OWDR_P6 = 0x40
	// Position of P7 field.
	PIO_OWDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OWDR_P7_Msk = 0x80
	// Bit P7.
	PIO_OWDR_P7 = 0x80
	// Position of P8 field.
	PIO_OWDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OWDR_P8_Msk = 0x100
	// Bit P8.
	PIO_OWDR_P8 = 0x100
	// Position of P9 field.
	PIO_OWDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OWDR_P9_Msk = 0x200
	// Bit P9.
	PIO_OWDR_P9 = 0x200
	// Position of P10 field.
	PIO_OWDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OWDR_P10_Msk = 0x400
	// Bit P10.
	PIO_OWDR_P10 = 0x400
	// Position of P11 field.
	PIO_OWDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OWDR_P11_Msk = 0x800
	// Bit P11.
	PIO_OWDR_P11 = 0x800
	// Position of P12 field.
	PIO_OWDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OWDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_OWDR_P12 = 0x1000
	// Position of P13 field.
	PIO_OWDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OWDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_OWDR_P13 = 0x2000
	// Position of P14 field.
	PIO_OWDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OWDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_OWDR_P14 = 0x4000
	// Position of P15 field.
	PIO_OWDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OWDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_OWDR_P15 = 0x8000
	// Position of P16 field.
	PIO_OWDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OWDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_OWDR_P16 = 0x10000
	// Position of P17 field.
	PIO_OWDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OWDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_OWDR_P17 = 0x20000
	// Position of P18 field.
	PIO_OWDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OWDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_OWDR_P18 = 0x40000
	// Position of P19 field.
	PIO_OWDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OWDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_OWDR_P19 = 0x80000
	// Position of P20 field.
	PIO_OWDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OWDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_OWDR_P20 = 0x100000
	// Position of P21 field.
	PIO_OWDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OWDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_OWDR_P21 = 0x200000
	// Position of P22 field.
	PIO_OWDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OWDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_OWDR_P22 = 0x400000
	// Position of P23 field.
	PIO_OWDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OWDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_OWDR_P23 = 0x800000
	// Position of P24 field.
	PIO_OWDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OWDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OWDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_OWDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OWDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OWDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_OWDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OWDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OWDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_OWDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OWDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OWDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_OWDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OWDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OWDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_OWDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OWDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OWDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_OWDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OWDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OWDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_OWDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OWDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OWDR_P31 = 0x80000000

	// OWSR: Output Write Status Register
	// Position of P0 field.
	PIO_OWSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OWSR_P0_Msk = 0x1
	// Bit P0.
	PIO_OWSR_P0 = 0x1
	// Position of P1 field.
	PIO_OWSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OWSR_P1_Msk = 0x2
	// Bit P1.
	PIO_OWSR_P1 = 0x2
	// Position of P2 field.
	PIO_OWSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OWSR_P2_Msk = 0x4
	// Bit P2.
	PIO_OWSR_P2 = 0x4
	// Position of P3 field.
	PIO_OWSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OWSR_P3_Msk = 0x8
	// Bit P3.
	PIO_OWSR_P3 = 0x8
	// Position of P4 field.
	PIO_OWSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OWSR_P4_Msk = 0x10
	// Bit P4.
	PIO_OWSR_P4 = 0x10
	// Position of P5 field.
	PIO_OWSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OWSR_P5_Msk = 0x20
	// Bit P5.
	PIO_OWSR_P5 = 0x20
	// Position of P6 field.
	PIO_OWSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OWSR_P6_Msk = 0x40
	// Bit P6.
	PIO_OWSR_P6 = 0x40
	// Position of P7 field.
	PIO_OWSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OWSR_P7_Msk = 0x80
	// Bit P7.
	PIO_OWSR_P7 = 0x80
	// Position of P8 field.
	PIO_OWSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OWSR_P8_Msk = 0x100
	// Bit P8.
	PIO_OWSR_P8 = 0x100
	// Position of P9 field.
	PIO_OWSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OWSR_P9_Msk = 0x200
	// Bit P9.
	PIO_OWSR_P9 = 0x200
	// Position of P10 field.
	PIO_OWSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OWSR_P10_Msk = 0x400
	// Bit P10.
	PIO_OWSR_P10 = 0x400
	// Position of P11 field.
	PIO_OWSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OWSR_P11_Msk = 0x800
	// Bit P11.
	PIO_OWSR_P11 = 0x800
	// Position of P12 field.
	PIO_OWSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OWSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_OWSR_P12 = 0x1000
	// Position of P13 field.
	PIO_OWSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OWSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_OWSR_P13 = 0x2000
	// Position of P14 field.
	PIO_OWSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OWSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_OWSR_P14 = 0x4000
	// Position of P15 field.
	PIO_OWSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OWSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_OWSR_P15 = 0x8000
	// Position of P16 field.
	PIO_OWSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OWSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_OWSR_P16 = 0x10000
	// Position of P17 field.
	PIO_OWSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OWSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_OWSR_P17 = 0x20000
	// Position of P18 field.
	PIO_OWSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OWSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_OWSR_P18 = 0x40000
	// Position of P19 field.
	PIO_OWSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OWSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_OWSR_P19 = 0x80000
	// Position of P20 field.
	PIO_OWSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OWSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_OWSR_P20 = 0x100000
	// Position of P21 field.
	PIO_OWSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OWSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_OWSR_P21 = 0x200000
	// Position of P22 field.
	PIO_OWSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OWSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_OWSR_P22 = 0x400000
	// Position of P23 field.
	PIO_OWSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OWSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_OWSR_P23 = 0x800000
	// Position of P24 field.
	PIO_OWSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OWSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OWSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_OWSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OWSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OWSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_OWSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OWSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OWSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_OWSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OWSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OWSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_OWSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OWSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OWSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_OWSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OWSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OWSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_OWSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OWSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OWSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_OWSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OWSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OWSR_P31 = 0x80000000
)

// Bitfields for PMC: Power Management Controller
const (
	// PMC_SCER: System Clock Enable Register
	// Position of UHP field.
	PMC_PMC_SCER_UHP_Pos = 0x6
	// Bit mask of UHP field.
	PMC_PMC_SCER_UHP_Msk = 0x40
	// Bit UHP.
	PMC_PMC_SCER_UHP = 0x40
	// Position of UDP field.
	PMC_PMC_SCER_UDP_Pos = 0x7
	// Bit mask of UDP field.
	PMC_PMC_SCER_UDP_Msk = 0x80
	// Bit UDP.
	PMC_PMC_SCER_UDP = 0x80
	// Position of PCK0 field.
	PMC_PMC_SCER_PCK0_Pos = 0x8
	// Bit mask of PCK0 field.
	PMC_PMC_SCER_PCK0_Msk = 0x100
	// Bit PCK0.
	PMC_PMC_SCER_PCK0 = 0x100
	// Position of PCK1 field.
	PMC_PMC_SCER_PCK1_Pos = 0x9
	// Bit mask of PCK1 field.
	PMC_PMC_SCER_PCK1_Msk = 0x200
	// Bit PCK1.
	PMC_PMC_SCER_PCK1 = 0x200

	// PMC_SCDR: System Clock Disable Register
	// Position of PCK field.
	PMC_PMC_SCDR_PCK_Pos = 0x0
	// Bit mask of PCK field.
	PMC_PMC_SCDR_PCK_Msk = 0x1
	// Bit PCK.
	PMC_PMC_SCDR_PCK = 0x1
	// Position of UHP field.
	PMC_PMC_SCDR_UHP_Pos = 0x6
	// Bit mask of UHP field.
	PMC_PMC_SCDR_UHP_Msk = 0x40
	// Bit UHP.
	PMC_PMC_SCDR_UHP = 0x40
	// Position of UDP field.
	PMC_PMC_SCDR_UDP_Pos = 0x7
	// Bit mask of UDP field.
	PMC_PMC_SCDR_UDP_Msk = 0x80
	// Bit UDP.
	PMC_PMC_SCDR_UDP = 0x80
	// Position of PCK0 field.
	PMC_PMC_SCDR_PCK0_Pos = 0x8
	// Bit mask of PCK0 field.
	PMC_PMC_SCDR_PCK0_Msk = 0x100
	// Bit PCK0.
	PMC_PMC_SCDR_PCK0 = 0x100
	// Position of PCK1 field.
	PMC_PMC_SCDR_PCK1_Pos = 0x9
	// Bit mask of PCK1 field.
	PMC_PMC_SCDR_PCK1_Msk = 0x200
	// Bit PCK1.
	PMC_PMC_SCDR_PCK1 = 0x200

	// PMC_SCSR: System Clock Status Register
	// Position of PCK field.
	PMC_PMC_SCSR_PCK_Pos = 0x0
	// Bit mask of PCK field.
	PMC_PMC_SCSR_PCK_Msk = 0x1
	// Bit PCK.
	PMC_PMC_SCSR_PCK = 0x1
	// Position of UHP field.
	PMC_PMC_SCSR_UHP_Pos = 0x6
	// Bit mask of UHP field.
	PMC_PMC_SCSR_UHP_Msk = 0x40
	// Bit UHP.
	PMC_PMC_SCSR_UHP = 0x40
	// Position of UDP field.
	PMC_PMC_SCSR_UDP_Pos = 0x7
	// Bit mask of UDP field.
	PMC_PMC_SCSR_UDP_Msk = 0x80
	// Bit UDP.
	PMC_PMC_SCSR_UDP = 0x80
	// Position of PCK0 field.
	PMC_PMC_SCSR_PCK0_Pos = 0x8
	// Bit mask of PCK0 field.
	PMC_PMC_SCSR_PCK0_Msk = 0x100
	// Bit PCK0.
	PMC_PMC_SCSR_PCK0 = 0x100
	// Position of PCK1 field.
	PMC_PMC_SCSR_PCK1_Pos = 0x9
	// Bit mask of PCK1 field.
	PMC_PMC_SCSR_PCK1_Msk = 0x200
	// Bit PCK1.
	PMC_PMC_SCSR_PCK1 = 0x200

	// PMC_PCER: Peripheral Clock Enable Register
	// Position of PID2 field.
	PMC_PMC_PCER_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	PMC_PMC_PCER_PID2_Msk = 0x4
	// Bit PID2.
	PMC_PMC_PCER_PID2 = 0x4
	// Position of PID3 field.
	PMC_PMC_PCER_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	PMC_PMC_PCER_PID3_Msk = 0x8
	// Bit PID3.
	PMC_PMC_PCER_PID3 = 0x8
	// Position of PID4 field.
	PMC_PMC_PCER_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	PMC_PMC_PCER_PID4_Msk = 0x10
	// Bit PID4.
	PMC_PMC_PCER_PID4 = 0x10
	// Position of PID5 field.
	PMC_PMC_PCER_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	PMC_PMC_PCER_PID5_Msk = 0x20
	// Bit PID5.
	PMC_PMC_PCER_PID5 = 0x20
	// Position of PID6 field.
	PMC_PMC_PCER_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	PMC_PMC_PCER_PID6_Msk = 0x40
	// Bit PID6.
	PMC_PMC_PCER_PID6 = 0x40
	// Position of PID7 field.
	PMC_PMC_PCER_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	PMC_PMC_PCER_PID7_Msk = 0x80
	// Bit PID7.
	PMC_PMC_PCER_PID7 = 0x80
	// Position of PID8 field.
	PMC_PMC_PCER_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	PMC_PMC_PCER_PID8_Msk = 0x100
	// Bit PID8.
	PMC_PMC_PCER_PID8 = 0x100
	// Position of PID9 field.
	PMC_PMC_PCER_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	PMC_PMC_PCER_PID9_Msk = 0x200
	// Bit PID9.
	PMC_PMC_PCER_PID9 = 0x200
	// Position of PID10 field.
	PMC_PMC_PCER_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	PMC_PMC_PCER_PID10_Msk = 0x400
	// Bit PID10.
	PMC_PMC_PCER_PID10 = 0x400
	// Position of PID11 field.
	PMC_PMC_PCER_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	PMC_PMC_PCER_PID11_Msk = 0x800
	// Bit PID11.
	PMC_PMC_PCER_PID11 = 0x800
	// Position of PID12 field.
	PMC_PMC_PCER_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	PMC_PMC_PCER_PID12_Msk = 0x1000
	// Bit PID12.
	PMC_PMC_PCER_PID12 = 0x1000
	// Position of PID13 field.
	PMC_PMC_PCER_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	PMC_PMC_PCER_PID13_Msk = 0x2000
	// Bit PID13.
	PMC_PMC_PCER_PID13 = 0x2000
	// Position of PID14 field.
	PMC_PMC_PCER_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	PMC_PMC_PCER_PID14_Msk = 0x4000
	// Bit PID14.
	PMC_PMC_PCER_PID14 = 0x4000
	// Position of PID15 field.
	PMC_PMC_PCER_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	PMC_PMC_PCER_PID15_Msk = 0x8000
	// Bit PID15.
	PMC_PMC_PCER_PID15 = 0x8000
	// Position of PID16 field.
	PMC_PMC_PCER_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	PMC_PMC_PCER_PID16_Msk = 0x10000
	// Bit PID16.
	PMC_PMC_PCER_PID16 = 0x10000
	// Position of PID17 field.
	PMC_PMC_PCER_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	PMC_PMC_PCER_PID17_Msk = 0x20000
	// Bit PID17.
	PMC_PMC_PCER_PID17 = 0x20000
	// Position of PID18 field.
	PMC_PMC_PCER_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	PMC_PMC_PCER_PID18_Msk = 0x40000
	// Bit PID18.
	PMC_PMC_PCER_PID18 = 0x40000
	// Position of PID19 field.
	PMC_PMC_PCER_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	PMC_PMC_PCER_PID19_Msk = 0x80000
	// Bit PID19.
	PMC_PMC_PCER_PID19 = 0x80000
	// Position of PID20 field.
	PMC_PMC_PCER_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	PMC_PMC_PCER_PID20_Msk = 0x100000
	// Bit PID20.
	PMC_PMC_PCER_PID20 = 0x100000
	// Position of PID21 field.
	PMC_PMC_PCER_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	PMC_PMC_PCER_PID21_Msk = 0x200000
	// Bit PID21.
	PMC_PMC_PCER_PID21 = 0x200000
	// Position of PID22 field.
	PMC_PMC_PCER_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	PMC_PMC_PCER_PID22_Msk = 0x400000
	// Bit PID22.
	PMC_PMC_PCER_PID22 = 0x400000
	// Position of PID23 field.
	PMC_PMC_PCER_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	PMC_PMC_PCER_PID23_Msk = 0x800000
	// Bit PID23.
	PMC_PMC_PCER_PID23 = 0x800000
	// Position of PID24 field.
	PMC_PMC_PCER_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	PMC_PMC_PCER_PID24_Msk = 0x1000000
	// Bit PID24.
	PMC_PMC_PCER_PID24 = 0x1000000
	// Position of PID25 field.
	PMC_PMC_PCER_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	PMC_PMC_PCER_PID25_Msk = 0x2000000
	// Bit PID25.
	PMC_PMC_PCER_PID25 = 0x2000000
	// Position of PID26 field.
	PMC_PMC_PCER_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	PMC_PMC_PCER_PID26_Msk = 0x4000000
	// Bit PID26.
	PMC_PMC_PCER_PID26 = 0x4000000
	// Position of PID27 field.
	PMC_PMC_PCER_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	PMC_PMC_PCER_PID27_Msk = 0x8000000
	// Bit PID27.
	PMC_PMC_PCER_PID27 = 0x8000000
	// Position of PID28 field.
	PMC_PMC_PCER_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	PMC_PMC_PCER_PID28_Msk = 0x10000000
	// Bit PID28.
	PMC_PMC_PCER_PID28 = 0x10000000
	// Position of PID29 field.
	PMC_PMC_PCER_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	PMC_PMC_PCER_PID29_Msk = 0x20000000
	// Bit PID29.
	PMC_PMC_PCER_PID29 = 0x20000000
	// Position of PID30 field.
	PMC_PMC_PCER_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	PMC_PMC_PCER_PID30_Msk = 0x40000000
	// Bit PID30.
	PMC_PMC_PCER_PID30 = 0x40000000
	// Position of PID31 field.
	PMC_PMC_PCER_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	PMC_PMC_PCER_PID31_Msk = 0x80000000
	// Bit PID31.
	PMC_PMC_PCER_PID31 = 0x80000000

	// PMC_PCDR: Peripheral Clock Disable Register
	// Position of PID2 field.
	PMC_PMC_PCDR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	PMC_PMC_PCDR_PID2_Msk = 0x4
	// Bit PID2.
	PMC_PMC_PCDR_PID2 = 0x4
	// Position of PID3 field.
	PMC_PMC_PCDR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	PMC_PMC_PCDR_PID3_Msk = 0x8
	// Bit PID3.
	PMC_PMC_PCDR_PID3 = 0x8
	// Position of PID4 field.
	PMC_PMC_PCDR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	PMC_PMC_PCDR_PID4_Msk = 0x10
	// Bit PID4.
	PMC_PMC_PCDR_PID4 = 0x10
	// Position of PID5 field.
	PMC_PMC_PCDR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	PMC_PMC_PCDR_PID5_Msk = 0x20
	// Bit PID5.
	PMC_PMC_PCDR_PID5 = 0x20
	// Position of PID6 field.
	PMC_PMC_PCDR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	PMC_PMC_PCDR_PID6_Msk = 0x40
	// Bit PID6.
	PMC_PMC_PCDR_PID6 = 0x40
	// Position of PID7 field.
	PMC_PMC_PCDR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	PMC_PMC_PCDR_PID7_Msk = 0x80
	// Bit PID7.
	PMC_PMC_PCDR_PID7 = 0x80
	// Position of PID8 field.
	PMC_PMC_PCDR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	PMC_PMC_PCDR_PID8_Msk = 0x100
	// Bit PID8.
	PMC_PMC_PCDR_PID8 = 0x100
	// Position of PID9 field.
	PMC_PMC_PCDR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	PMC_PMC_PCDR_PID9_Msk = 0x200
	// Bit PID9.
	PMC_PMC_PCDR_PID9 = 0x200
	// Position of PID10 field.
	PMC_PMC_PCDR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	PMC_PMC_PCDR_PID10_Msk = 0x400
	// Bit PID10.
	PMC_PMC_PCDR_PID10 = 0x400
	// Position of PID11 field.
	PMC_PMC_PCDR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	PMC_PMC_PCDR_PID11_Msk = 0x800
	// Bit PID11.
	PMC_PMC_PCDR_PID11 = 0x800
	// Position of PID12 field.
	PMC_PMC_PCDR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	PMC_PMC_PCDR_PID12_Msk = 0x1000
	// Bit PID12.
	PMC_PMC_PCDR_PID12 = 0x1000
	// Position of PID13 field.
	PMC_PMC_PCDR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	PMC_PMC_PCDR_PID13_Msk = 0x2000
	// Bit PID13.
	PMC_PMC_PCDR_PID13 = 0x2000
	// Position of PID14 field.
	PMC_PMC_PCDR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	PMC_PMC_PCDR_PID14_Msk = 0x4000
	// Bit PID14.
	PMC_PMC_PCDR_PID14 = 0x4000
	// Position of PID15 field.
	PMC_PMC_PCDR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	PMC_PMC_PCDR_PID15_Msk = 0x8000
	// Bit PID15.
	PMC_PMC_PCDR_PID15 = 0x8000
	// Position of PID16 field.
	PMC_PMC_PCDR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	PMC_PMC_PCDR_PID16_Msk = 0x10000
	// Bit PID16.
	PMC_PMC_PCDR_PID16 = 0x10000
	// Position of PID17 field.
	PMC_PMC_PCDR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	PMC_PMC_PCDR_PID17_Msk = 0x20000
	// Bit PID17.
	PMC_PMC_PCDR_PID17 = 0x20000
	// Position of PID18 field.
	PMC_PMC_PCDR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	PMC_PMC_PCDR_PID18_Msk = 0x40000
	// Bit PID18.
	PMC_PMC_PCDR_PID18 = 0x40000
	// Position of PID19 field.
	PMC_PMC_PCDR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	PMC_PMC_PCDR_PID19_Msk = 0x80000
	// Bit PID19.
	PMC_PMC_PCDR_PID19 = 0x80000
	// Position of PID20 field.
	PMC_PMC_PCDR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	PMC_PMC_PCDR_PID20_Msk = 0x100000
	// Bit PID20.
	PMC_PMC_PCDR_PID20 = 0x100000
	// Position of PID21 field.
	PMC_PMC_PCDR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	PMC_PMC_PCDR_PID21_Msk = 0x200000
	// Bit PID21.
	PMC_PMC_PCDR_PID21 = 0x200000
	// Position of PID22 field.
	PMC_PMC_PCDR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	PMC_PMC_PCDR_PID22_Msk = 0x400000
	// Bit PID22.
	PMC_PMC_PCDR_PID22 = 0x400000
	// Position of PID23 field.
	PMC_PMC_PCDR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	PMC_PMC_PCDR_PID23_Msk = 0x800000
	// Bit PID23.
	PMC_PMC_PCDR_PID23 = 0x800000
	// Position of PID24 field.
	PMC_PMC_PCDR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	PMC_PMC_PCDR_PID24_Msk = 0x1000000
	// Bit PID24.
	PMC_PMC_PCDR_PID24 = 0x1000000
	// Position of PID25 field.
	PMC_PMC_PCDR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	PMC_PMC_PCDR_PID25_Msk = 0x2000000
	// Bit PID25.
	PMC_PMC_PCDR_PID25 = 0x2000000
	// Position of PID26 field.
	PMC_PMC_PCDR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	PMC_PMC_PCDR_PID26_Msk = 0x4000000
	// Bit PID26.
	PMC_PMC_PCDR_PID26 = 0x4000000
	// Position of PID27 field.
	PMC_PMC_PCDR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	PMC_PMC_PCDR_PID27_Msk = 0x8000000
	// Bit PID27.
	PMC_PMC_PCDR_PID27 = 0x8000000
	// Position of PID28 field.
	PMC_PMC_PCDR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	PMC_PMC_PCDR_PID28_Msk = 0x10000000
	// Bit PID28.
	PMC_PMC_PCDR_PID28 = 0x10000000
	// Position of PID29 field.
	PMC_PMC_PCDR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	PMC_PMC_PCDR_PID29_Msk = 0x20000000
	// Bit PID29.
	PMC_PMC_PCDR_PID29 = 0x20000000
	// Position of PID30 field.
	PMC_PMC_PCDR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	PMC_PMC_PCDR_PID30_Msk = 0x40000000
	// Bit PID30.
	PMC_PMC_PCDR_PID30 = 0x40000000
	// Position of PID31 field.
	PMC_PMC_PCDR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	PMC_PMC_PCDR_PID31_Msk = 0x80000000
	// Bit PID31.
	PMC_PMC_PCDR_PID31 = 0x80000000

	// PMC_PCSR: Peripheral Clock Status Register
	// Position of PID2 field.
	PMC_PMC_PCSR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	PMC_PMC_PCSR_PID2_Msk = 0x4
	// Bit PID2.
	PMC_PMC_PCSR_PID2 = 0x4
	// Position of PID3 field.
	PMC_PMC_PCSR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	PMC_PMC_PCSR_PID3_Msk = 0x8
	// Bit PID3.
	PMC_PMC_PCSR_PID3 = 0x8
	// Position of PID4 field.
	PMC_PMC_PCSR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	PMC_PMC_PCSR_PID4_Msk = 0x10
	// Bit PID4.
	PMC_PMC_PCSR_PID4 = 0x10
	// Position of PID5 field.
	PMC_PMC_PCSR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	PMC_PMC_PCSR_PID5_Msk = 0x20
	// Bit PID5.
	PMC_PMC_PCSR_PID5 = 0x20
	// Position of PID6 field.
	PMC_PMC_PCSR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	PMC_PMC_PCSR_PID6_Msk = 0x40
	// Bit PID6.
	PMC_PMC_PCSR_PID6 = 0x40
	// Position of PID7 field.
	PMC_PMC_PCSR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	PMC_PMC_PCSR_PID7_Msk = 0x80
	// Bit PID7.
	PMC_PMC_PCSR_PID7 = 0x80
	// Position of PID8 field.
	PMC_PMC_PCSR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	PMC_PMC_PCSR_PID8_Msk = 0x100
	// Bit PID8.
	PMC_PMC_PCSR_PID8 = 0x100
	// Position of PID9 field.
	PMC_PMC_PCSR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	PMC_PMC_PCSR_PID9_Msk = 0x200
	// Bit PID9.
	PMC_PMC_PCSR_PID9 = 0x200
	// Position of PID10 field.
	PMC_PMC_PCSR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	PMC_PMC_PCSR_PID10_Msk = 0x400
	// Bit PID10.
	PMC_PMC_PCSR_PID10 = 0x400
	// Position of PID11 field.
	PMC_PMC_PCSR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	PMC_PMC_PCSR_PID11_Msk = 0x800
	// Bit PID11.
	PMC_PMC_PCSR_PID11 = 0x800
	// Position of PID12 field.
	PMC_PMC_PCSR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	PMC_PMC_PCSR_PID12_Msk = 0x1000
	// Bit PID12.
	PMC_PMC_PCSR_PID12 = 0x1000
	// Position of PID13 field.
	PMC_PMC_PCSR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	PMC_PMC_PCSR_PID13_Msk = 0x2000
	// Bit PID13.
	PMC_PMC_PCSR_PID13 = 0x2000
	// Position of PID14 field.
	PMC_PMC_PCSR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	PMC_PMC_PCSR_PID14_Msk = 0x4000
	// Bit PID14.
	PMC_PMC_PCSR_PID14 = 0x4000
	// Position of PID15 field.
	PMC_PMC_PCSR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	PMC_PMC_PCSR_PID15_Msk = 0x8000
	// Bit PID15.
	PMC_PMC_PCSR_PID15 = 0x8000
	// Position of PID16 field.
	PMC_PMC_PCSR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	PMC_PMC_PCSR_PID16_Msk = 0x10000
	// Bit PID16.
	PMC_PMC_PCSR_PID16 = 0x10000
	// Position of PID17 field.
	PMC_PMC_PCSR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	PMC_PMC_PCSR_PID17_Msk = 0x20000
	// Bit PID17.
	PMC_PMC_PCSR_PID17 = 0x20000
	// Position of PID18 field.
	PMC_PMC_PCSR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	PMC_PMC_PCSR_PID18_Msk = 0x40000
	// Bit PID18.
	PMC_PMC_PCSR_PID18 = 0x40000
	// Position of PID19 field.
	PMC_PMC_PCSR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	PMC_PMC_PCSR_PID19_Msk = 0x80000
	// Bit PID19.
	PMC_PMC_PCSR_PID19 = 0x80000
	// Position of PID20 field.
	PMC_PMC_PCSR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	PMC_PMC_PCSR_PID20_Msk = 0x100000
	// Bit PID20.
	PMC_PMC_PCSR_PID20 = 0x100000
	// Position of PID21 field.
	PMC_PMC_PCSR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	PMC_PMC_PCSR_PID21_Msk = 0x200000
	// Bit PID21.
	PMC_PMC_PCSR_PID21 = 0x200000
	// Position of PID22 field.
	PMC_PMC_PCSR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	PMC_PMC_PCSR_PID22_Msk = 0x400000
	// Bit PID22.
	PMC_PMC_PCSR_PID22 = 0x400000
	// Position of PID23 field.
	PMC_PMC_PCSR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	PMC_PMC_PCSR_PID23_Msk = 0x800000
	// Bit PID23.
	PMC_PMC_PCSR_PID23 = 0x800000
	// Position of PID24 field.
	PMC_PMC_PCSR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	PMC_PMC_PCSR_PID24_Msk = 0x1000000
	// Bit PID24.
	PMC_PMC_PCSR_PID24 = 0x1000000
	// Position of PID25 field.
	PMC_PMC_PCSR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	PMC_PMC_PCSR_PID25_Msk = 0x2000000
	// Bit PID25.
	PMC_PMC_PCSR_PID25 = 0x2000000
	// Position of PID26 field.
	PMC_PMC_PCSR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	PMC_PMC_PCSR_PID26_Msk = 0x4000000
	// Bit PID26.
	PMC_PMC_PCSR_PID26 = 0x4000000
	// Position of PID27 field.
	PMC_PMC_PCSR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	PMC_PMC_PCSR_PID27_Msk = 0x8000000
	// Bit PID27.
	PMC_PMC_PCSR_PID27 = 0x8000000
	// Position of PID28 field.
	PMC_PMC_PCSR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	PMC_PMC_PCSR_PID28_Msk = 0x10000000
	// Bit PID28.
	PMC_PMC_PCSR_PID28 = 0x10000000
	// Position of PID29 field.
	PMC_PMC_PCSR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	PMC_PMC_PCSR_PID29_Msk = 0x20000000
	// Bit PID29.
	PMC_PMC_PCSR_PID29 = 0x20000000
	// Position of PID30 field.
	PMC_PMC_PCSR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	PMC_PMC_PCSR_PID30_Msk = 0x40000000
	// Bit PID30.
	PMC_PMC_PCSR_PID30 = 0x40000000
	// Position of PID31 field.
	PMC_PMC_PCSR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	PMC_PMC_PCSR_PID31_Msk = 0x80000000
	// Bit PID31.
	PMC_PMC_PCSR_PID31 = 0x80000000

	// CKGR_MOR: Main Oscillator Register
	// Position of MOSCEN field.
	PMC_CKGR_MOR_MOSCEN_Pos = 0x0
	// Bit mask of MOSCEN field.
	PMC_CKGR_MOR_MOSCEN_Msk = 0x1
	// Bit MOSCEN.
	PMC_CKGR_MOR_MOSCEN = 0x1
	// Position of OSCBYPASS field.
	PMC_CKGR_MOR_OSCBYPASS_Pos = 0x1
	// Bit mask of OSCBYPASS field.
	PMC_CKGR_MOR_OSCBYPASS_Msk = 0x2
	// Bit OSCBYPASS.
	PMC_CKGR_MOR_OSCBYPASS = 0x2
	// Position of OSCOUNT field.
	PMC_CKGR_MOR_OSCOUNT_Pos = 0x8
	// Bit mask of OSCOUNT field.
	PMC_CKGR_MOR_OSCOUNT_Msk = 0xff00

	// CKGR_MCFR: Main Clock Frequency Register
	// Position of MAINF field.
	PMC_CKGR_MCFR_MAINF_Pos = 0x0
	// Bit mask of MAINF field.
	PMC_CKGR_MCFR_MAINF_Msk = 0xffff
	// Position of MAINRDY field.
	PMC_CKGR_MCFR_MAINRDY_Pos = 0x10
	// Bit mask of MAINRDY field.
	PMC_CKGR_MCFR_MAINRDY_Msk = 0x10000
	// Bit MAINRDY.
	PMC_CKGR_MCFR_MAINRDY = 0x10000

	// CKGR_PLLAR: PLL A Register
	// Position of DIVA field.
	PMC_CKGR_PLLAR_DIVA_Pos = 0x0
	// Bit mask of DIVA field.
	PMC_CKGR_PLLAR_DIVA_Msk = 0xff
	// Position of PLLACOUNT field.
	PMC_CKGR_PLLAR_PLLACOUNT_Pos = 0x8
	// Bit mask of PLLACOUNT field.
	PMC_CKGR_PLLAR_PLLACOUNT_Msk = 0x3f00
	// Position of OUTA field.
	PMC_CKGR_PLLAR_OUTA_Pos = 0xe
	// Bit mask of OUTA field.
	PMC_CKGR_PLLAR_OUTA_Msk = 0xc000
	// Position of MULA field.
	PMC_CKGR_PLLAR_MULA_Pos = 0x10
	// Bit mask of MULA field.
	PMC_CKGR_PLLAR_MULA_Msk = 0xff0000
	// Position of STUCKTO1 field.
	PMC_CKGR_PLLAR_STUCKTO1_Pos = 0x1d
	// Bit mask of STUCKTO1 field.
	PMC_CKGR_PLLAR_STUCKTO1_Msk = 0x20000000
	// Bit STUCKTO1.
	PMC_CKGR_PLLAR_STUCKTO1 = 0x20000000

	// CKGR_PLLBR: PLL B Register
	// Position of DIVB field.
	PMC_CKGR_PLLBR_DIVB_Pos = 0x0
	// Bit mask of DIVB field.
	PMC_CKGR_PLLBR_DIVB_Msk = 0xff
	// Position of PLLBCOUNT field.
	PMC_CKGR_PLLBR_PLLBCOUNT_Pos = 0x8
	// Bit mask of PLLBCOUNT field.
	PMC_CKGR_PLLBR_PLLBCOUNT_Msk = 0x3f00
	// Position of OUTB field.
	PMC_CKGR_PLLBR_OUTB_Pos = 0xe
	// Bit mask of OUTB field.
	PMC_CKGR_PLLBR_OUTB_Msk = 0xc000
	// Position of MULB field.
	PMC_CKGR_PLLBR_MULB_Pos = 0x10
	// Bit mask of MULB field.
	PMC_CKGR_PLLBR_MULB_Msk = 0x3f0000
	// Position of USBDIV field.
	PMC_CKGR_PLLBR_USBDIV_Pos = 0x1c
	// Bit mask of USBDIV field.
	PMC_CKGR_PLLBR_USBDIV_Msk = 0x30000000

	// PMC_MCKR: Master Clock Register
	// Position of CSS field.
	PMC_PMC_MCKR_CSS_Pos = 0x0
	// Bit mask of CSS field.
	PMC_PMC_MCKR_CSS_Msk = 0x3
	// Position of PRES field.
	PMC_PMC_MCKR_PRES_Pos = 0x2
	// Bit mask of PRES field.
	PMC_PMC_MCKR_PRES_Msk = 0x1c
	// Position of MDIV field.
	PMC_PMC_MCKR_MDIV_Pos = 0x8
	// Bit mask of MDIV field.
	PMC_PMC_MCKR_MDIV_Msk = 0x300
	// Position of PDIV field.
	PMC_PMC_MCKR_PDIV_Pos = 0xc
	// Bit mask of PDIV field.
	PMC_PMC_MCKR_PDIV_Msk = 0x1000
	// Bit PDIV.
	PMC_PMC_MCKR_PDIV = 0x1000

	// PMC_PCK: Programmable Clock 0 Register
	// Position of CSS field.
	PMC_PMC_PCK_CSS_Pos = 0x0
	// Bit mask of CSS field.
	PMC_PMC_PCK_CSS_Msk = 0x3
	// Position of PRES field.
	PMC_PMC_PCK_PRES_Pos = 0x2
	// Bit mask of PRES field.
	PMC_PMC_PCK_PRES_Msk = 0x1c

	// PMC_IER: Interrupt Enable Register
	// Position of MOSCS field.
	PMC_PMC_IER_MOSCS_Pos = 0x0
	// Bit mask of MOSCS field.
	PMC_PMC_IER_MOSCS_Msk = 0x1
	// Bit MOSCS.
	PMC_PMC_IER_MOSCS = 0x1
	// Position of LOCKA field.
	PMC_PMC_IER_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_IER_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_IER_LOCKA = 0x2
	// Position of LOCKB field.
	PMC_PMC_IER_LOCKB_Pos = 0x2
	// Bit mask of LOCKB field.
	PMC_PMC_IER_LOCKB_Msk = 0x4
	// Bit LOCKB.
	PMC_PMC_IER_LOCKB = 0x4
	// Position of MCKRDY field.
	PMC_PMC_IER_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_IER_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_IER_MCKRDY = 0x8
	// Position of PCKRDY0 field.
	PMC_PMC_IER_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_IER_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_IER_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_IER_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_IER_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_IER_PCKRDY1 = 0x200

	// PMC_IDR: Interrupt Disable Register
	// Position of MOSCS field.
	PMC_PMC_IDR_MOSCS_Pos = 0x0
	// Bit mask of MOSCS field.
	PMC_PMC_IDR_MOSCS_Msk = 0x1
	// Bit MOSCS.
	PMC_PMC_IDR_MOSCS = 0x1
	// Position of LOCKA field.
	PMC_PMC_IDR_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_IDR_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_IDR_LOCKA = 0x2
	// Position of LOCKB field.
	PMC_PMC_IDR_LOCKB_Pos = 0x2
	// Bit mask of LOCKB field.
	PMC_PMC_IDR_LOCKB_Msk = 0x4
	// Bit LOCKB.
	PMC_PMC_IDR_LOCKB = 0x4
	// Position of MCKRDY field.
	PMC_PMC_IDR_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_IDR_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_IDR_MCKRDY = 0x8
	// Position of PCKRDY0 field.
	PMC_PMC_IDR_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_IDR_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_IDR_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_IDR_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_IDR_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_IDR_PCKRDY1 = 0x200

	// PMC_SR: Status Register
	// Position of MOSCS field.
	PMC_PMC_SR_MOSCS_Pos = 0x0
	// Bit mask of MOSCS field.
	PMC_PMC_SR_MOSCS_Msk = 0x1
	// Bit MOSCS.
	PMC_PMC_SR_MOSCS = 0x1
	// Position of LOCKA field.
	PMC_PMC_SR_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_SR_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_SR_LOCKA = 0x2
	// Position of LOCKB field.
	PMC_PMC_SR_LOCKB_Pos = 0x2
	// Bit mask of LOCKB field.
	PMC_PMC_SR_LOCKB_Msk = 0x4
	// Bit LOCKB.
	PMC_PMC_SR_LOCKB = 0x4
	// Position of MCKRDY field.
	PMC_PMC_SR_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_SR_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_SR_MCKRDY = 0x8
	// Position of OSC_SEL field.
	PMC_PMC_SR_OSC_SEL_Pos = 0x7
	// Bit mask of OSC_SEL field.
	PMC_PMC_SR_OSC_SEL_Msk = 0x80
	// Bit OSC_SEL.
	PMC_PMC_SR_OSC_SEL = 0x80
	// Position of PCKRDY0 field.
	PMC_PMC_SR_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_SR_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_SR_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_SR_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_SR_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_SR_PCKRDY1 = 0x200

	// PMC_IMR: Interrupt Mask Register
	// Position of MOSCS field.
	PMC_PMC_IMR_MOSCS_Pos = 0x0
	// Bit mask of MOSCS field.
	PMC_PMC_IMR_MOSCS_Msk = 0x1
	// Bit MOSCS.
	PMC_PMC_IMR_MOSCS = 0x1
	// Position of LOCKA field.
	PMC_PMC_IMR_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_IMR_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_IMR_LOCKA = 0x2
	// Position of LOCKB field.
	PMC_PMC_IMR_LOCKB_Pos = 0x2
	// Bit mask of LOCKB field.
	PMC_PMC_IMR_LOCKB_Msk = 0x4
	// Bit LOCKB.
	PMC_PMC_IMR_LOCKB = 0x4
	// Position of MCKRDY field.
	PMC_PMC_IMR_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_IMR_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_IMR_MCKRDY = 0x8
	// Position of PCKRDY0 field.
	PMC_PMC_IMR_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_IMR_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_IMR_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_IMR_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_IMR_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_IMR_PCKRDY1 = 0x200

	// PMC_PLLICPR: PLL Charge Pump Current Register
	// Position of ICPLLA field.
	PMC_PMC_PLLICPR_ICPLLA_Pos = 0x0
	// Bit mask of ICPLLA field.
	PMC_PMC_PLLICPR_ICPLLA_Msk = 0x1
	// Bit ICPLLA.
	PMC_PMC_PLLICPR_ICPLLA = 0x1
	// Position of ICPLLB field.
	PMC_PMC_PLLICPR_ICPLLB_Pos = 0x10
	// Bit mask of ICPLLB field.
	PMC_PMC_PLLICPR_ICPLLB_Msk = 0x10000
	// Bit ICPLLB.
	PMC_PMC_PLLICPR_ICPLLB = 0x10000
)

// Bitfields for RSTC: Reset Controller
const (
	// CR: Control Register
	// Position of PROCRST field.
	SYSC_CR_PROCRST_Pos = 0x0
	// Bit mask of PROCRST field.
	SYSC_CR_PROCRST_Msk = 0x1
	// Bit PROCRST.
	SYSC_CR_PROCRST = 0x1
	// Position of PERRST field.
	SYSC_CR_PERRST_Pos = 0x2
	// Bit mask of PERRST field.
	SYSC_CR_PERRST_Msk = 0x4
	// Bit PERRST.
	SYSC_CR_PERRST = 0x4
	// Position of EXTRST field.
	SYSC_CR_EXTRST_Pos = 0x3
	// Bit mask of EXTRST field.
	SYSC_CR_EXTRST_Msk = 0x8
	// Bit EXTRST.
	SYSC_CR_EXTRST = 0x8
	// Position of KEY field.
	SYSC_CR_KEY_Pos = 0x18
	// Bit mask of KEY field.
	SYSC_CR_KEY_Msk = 0xff000000

	// SR: Status Register
	// Position of URSTS field.
	SYSC_SR_URSTS_Pos = 0x0
	// Bit mask of URSTS field.
	SYSC_SR_URSTS_Msk = 0x1
	// Bit URSTS.
	SYSC_SR_URSTS = 0x1
	// Position of RSTTYP field.
	SYSC_SR_RSTTYP_Pos = 0x8
	// Bit mask of RSTTYP field.
	SYSC_SR_RSTTYP_Msk = 0x700
	// Position of NRSTL field.
	SYSC_SR_NRSTL_Pos = 0x10
	// Bit mask of NRSTL field.
	SYSC_SR_NRSTL_Msk = 0x10000
	// Bit NRSTL.
	SYSC_SR_NRSTL = 0x10000
	// Position of SRCMP field.
	SYSC_SR_SRCMP_Pos = 0x11
	// Bit mask of SRCMP field.
	SYSC_SR_SRCMP_Msk = 0x20000
	// Bit SRCMP.
	SYSC_SR_SRCMP = 0x20000

	// MR: Mode Register
	// Position of ERSTL field.
	SYSC_MR_ERSTL_Pos = 0x8
	// Bit mask of ERSTL field.
	SYSC_MR_ERSTL_Msk = 0xf00
	// Position of KEY field.
	SYSC_MR_KEY_Pos = 0x18
	// Bit mask of KEY field.
	SYSC_MR_KEY_Msk = 0xff000000
)
