/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.util.HashMap;
import org.parosproxy.paros.model.HistoryReference;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.eventBus.Event;
import org.zaproxy.zap.eventBus.EventPublisher;

public final class ProxyListenerLogEventPublisher
implements EventPublisher {
    public static final String EVENT_ADDED = "href.added";
    public static final String FIELD_HISTORY_REFERENCE_ID = "historyReferenceId";
    private static final String FIELD_URI = "uri";
    private static final String FIELD_METHOD = "method";
    private static final String FIELD_TIME_SENT_MS = "timeSentInMs";
    private static final String FIELD_STATUS_CODE = "statusCode";
    private static final String FIELD_RTT = "rtt";
    private static final String FIELD_RESPONSE_BODY_LENGTH = "responseBodyLength";
    private static ProxyListenerLogEventPublisher publisher;

    @Override
    public String getPublisherName() {
        return ProxyListenerLogEventPublisher.class.getCanonicalName();
    }

    public static ProxyListenerLogEventPublisher getPublisher() {
        if (publisher == null) {
            ProxyListenerLogEventPublisher.createPublisher();
        }
        return publisher;
    }

    private static synchronized void createPublisher() {
        if (publisher == null) {
            publisher = new ProxyListenerLogEventPublisher();
            ZAP.getEventBus().registerPublisher(publisher, EVENT_ADDED);
        }
    }

    public void publishHrefAddedEvent(HistoryReference href) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(FIELD_HISTORY_REFERENCE_ID, Integer.toString(href.getHistoryId()));
        map.put(FIELD_URI, href.getURI().toString());
        map.put(FIELD_METHOD, href.getMethod());
        map.put(FIELD_TIME_SENT_MS, Long.toString(href.getTimeSentMillis()));
        map.put(FIELD_STATUS_CODE, Integer.toString(href.getStatusCode()));
        map.put(FIELD_RTT, Integer.toString(href.getRtt()));
        map.put(FIELD_RESPONSE_BODY_LENGTH, Integer.toString(href.getResponseBodyLength()));
        ZAP.getEventBus().publishSyncEvent(ProxyListenerLogEventPublisher.getPublisher(), new Event(ProxyListenerLogEventPublisher.getPublisher(), EVENT_ADDED, null, map));
    }
}

