/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.StunMessageEvent;
import org.ice4j.attribute.AttributeFactory;
import org.ice4j.attribute.IceControlledAttribute;
import org.ice4j.attribute.IceControllingAttribute;
import org.ice4j.attribute.MessageIntegrityAttribute;
import org.ice4j.attribute.PriorityAttribute;
import org.ice4j.attribute.UsernameAttribute;
import org.ice4j.ice.Agent;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.message.Message;
import org.ice4j.message.MessageFactory;
import org.ice4j.message.Request;
import org.ice4j.message.Response;
import org.ice4j.security.CredentialsAuthority;
import org.ice4j.stack.RequestListener;
import org.ice4j.stack.StunStack;

class ConnectivityCheckServer
implements RequestListener,
CredentialsAuthority {
    private static final Logger logger = Logger.getLogger(ConnectivityCheckServer.class.getName());
    private final Agent parentAgent;
    private boolean started = false;
    private final StunStack stunStack;
    private boolean alive = false;

    private static int compareUnsignedLong(long a, long b) {
        if (a == b) {
            return 0;
        }
        if (a + Long.MIN_VALUE < b + Long.MIN_VALUE) {
            return -1;
        }
        return 1;
    }

    public ConnectivityCheckServer(Agent parentAgent) {
        this.parentAgent = parentAgent;
        this.stunStack = this.parentAgent.getStunStack();
        this.stunStack.getCredentialsManager().registerAuthority(this);
        this.start();
    }

    boolean isAlive() {
        return this.alive;
    }

    @Override
    public void processRequest(StunMessageEvent evt) throws IllegalArgumentException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Received request " + evt);
        }
        this.alive = true;
        Request request = (Request)evt.getMessage();
        UsernameAttribute uname = (UsernameAttribute)request.getAttribute('\u0006');
        if (uname == null || !this.checkLocalUserName(new String(uname.getUsername()))) {
            return;
        }
        if ((this.parentAgent.isControlling() && request.containsAttribute('\u802a') || !this.parentAgent.isControlling() && request.containsAttribute('\u8029')) && !this.repairRoleConflict(evt)) {
            return;
        }
        long priority = 0L;
        boolean useCandidate = request.containsAttribute('%');
        String username = new String(uname.getUsername());
        String remoteUfrag = null;
        String localUFrag = null;
        priority = this.extractPriority(request);
        int colon = username.indexOf(":");
        remoteUfrag = username.substring(0, colon);
        this.parentAgent.incomingCheckReceived(evt.getRemoteAddress(), evt.getLocalAddress(), priority, remoteUfrag, localUFrag, useCandidate);
        Response response = MessageFactory.createBindingResponse(request, evt.getRemoteAddress());
        UsernameAttribute usernameAttribute = AttributeFactory.createUsernameAttribute(uname.getUsername());
        response.putAttribute(usernameAttribute);
        MessageIntegrityAttribute messageIntegrityAttribute = AttributeFactory.createMessageIntegrityAttribute(new String(uname.getUsername()));
        response.putAttribute(messageIntegrityAttribute);
        try {
            this.stunStack.sendResponse(evt.getTransactionID().getBytes(), response, evt.getLocalAddress(), evt.getRemoteAddress());
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Failed to send " + response + " through " + evt.getLocalAddress(), e);
            throw new RuntimeException("Failed to send a response", e);
        }
    }

    private long extractPriority(Request request) throws IllegalArgumentException {
        PriorityAttribute priorityAttr = (PriorityAttribute)request.getAttribute('$');
        if (priorityAttr == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Received a connectivity check withno PRIORITY attribute. Discarding.");
            }
            throw new IllegalArgumentException("Missing PRIORITY attribute!");
        }
        return priorityAttr.getPriority();
    }

    private boolean repairRoleConflict(StunMessageEvent evt) {
        Message req = evt.getMessage();
        long ourTieBreaker = this.parentAgent.getTieBreaker();
        if (this.parentAgent.isControlling() && req.containsAttribute('\u802a')) {
            IceControllingAttribute controlling = (IceControllingAttribute)req.getAttribute('\u802a');
            long theirTieBreaker = controlling.getTieBreaker();
            if (ConnectivityCheckServer.compareUnsignedLong(ourTieBreaker, theirTieBreaker) >= 0) {
                Response response = MessageFactory.createBindingErrorResponse('\u01e7');
                try {
                    this.stunStack.sendResponse(evt.getTransactionID().getBytes(), response, evt.getLocalAddress(), evt.getRemoteAddress());
                    return false;
                }
                catch (Exception exc) {
                    throw new RuntimeException("Failed to send a 487", exc);
                }
            }
            logger.finer("Switching to controlled because theirTieBreaker=" + theirTieBreaker + " and ourTieBreaker=" + ourTieBreaker);
            this.parentAgent.setControlling(false);
            return true;
        }
        if (!this.parentAgent.isControlling() && req.containsAttribute('\u8029')) {
            IceControlledAttribute controlled = (IceControlledAttribute)req.getAttribute('\u8029');
            long theirTieBreaker = controlled.getTieBreaker();
            if (ConnectivityCheckServer.compareUnsignedLong(ourTieBreaker, theirTieBreaker) >= 0) {
                logger.finer("Switching to controlling because theirTieBreaker=" + theirTieBreaker + " and ourTieBreaker=" + ourTieBreaker);
                this.parentAgent.setControlling(true);
                return true;
            }
            Response response = MessageFactory.createBindingErrorResponse('\u01e7');
            try {
                this.stunStack.sendResponse(evt.getTransactionID().getBytes(), response, evt.getLocalAddress(), evt.getRemoteAddress());
                return false;
            }
            catch (Exception exc) {
                throw new RuntimeException("Failed to send a 487", exc);
            }
        }
        return true;
    }

    @Override
    public boolean checkLocalUserName(String username) {
        String ufrag = null;
        int colon = username.indexOf(":");
        ufrag = colon < 0 ? username : username.substring(0, colon);
        return ufrag.equals(this.parentAgent.getLocalUfrag());
    }

    @Override
    public byte[] getLocalKey(String username) {
        return this.checkLocalUserName(username) ? this.parentAgent.getLocalPassword().getBytes() : null;
    }

    @Override
    public byte[] getRemoteKey(String username, String media) {
        IceMediaStream stream = this.parentAgent.getStream(media);
        if (stream == null) {
            return null;
        }
        int colon = username.indexOf(":");
        if (colon < 0 ? username.equals(stream.getRemoteUfrag()) : username.equals(this.parentAgent.generateLocalUserName(media)) && stream.getRemotePassword() != null) {
            return stream.getRemotePassword().getBytes();
        }
        return null;
    }

    public void start() {
        if (!this.started) {
            this.stunStack.addRequestListener(this);
            this.started = true;
        }
    }

    public void stop() {
        this.stunStack.removeRequestListener(this);
        this.started = false;
    }
}

