/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.RGB;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyleKt;
import com.github.ajalt.mordant.terminal.AnsiLevel;
import com.github.ajalt.mordant.terminal.TextColors;
import com.github.ajalt.mordant.terminal.TextStyles;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b0\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u00105\u001a\u00020\u00062\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002072\u0006\u00109\u001a\u0002072\u0006\u0010:\u001a\u000207J\u000e\u0010;\u001a\u00020\u00062\u0006\u0010;\u001a\u00020<J\u0010\u0010=\u001a\u00020\u00062\u0006\u0010>\u001a\u00020\u0006H\u0002J\u000e\u0010\u001f\u001a\u00020\u00062\u0006\u0010?\u001a\u00020@J\u001e\u0010A\u001a\u00020\u00062\u0006\u0010B\u001a\u0002072\u0006\u0010C\u001a\u0002072\u0006\u0010D\u001a\u000207J\u001e\u0010E\u001a\u00020\u00062\u0006\u0010B\u001a\u0002072\u0006\u0010C\u001a\u0002072\u0006\u0010F\u001a\u000207J\u001e\u0010G\u001a\u00020\u00062\u0006\u0010D\u001a\u00020@2\u0006\u0010H\u001a\u00020@2\u0006\u0010I\u001a\u00020@J\u001e\u0010J\u001a\u00020\u00062\u0006\u0010K\u001a\u0002072\u0006\u0010L\u001a\u0002072\u0006\u0010I\u001a\u000207J\u000e\u0010J\u001a\u00020\u00062\u0006\u0010M\u001a\u00020NJ\u001e\u0010O\u001a\u00020\u00062\u0006\u0010P\u001a\u00020@2\u0006\u00109\u001a\u00020@2\u0006\u0010Q\u001a\u00020@R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u0011\u0010\u0013\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\u0011\u0010\u0015\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\bR\u0011\u0010\u0017\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\bR\u0011\u0010\u0019\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\bR\u0011\u0010\u001b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\bR\u0011\u0010\u001d\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\bR\u0011\u0010\u001f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b \u0010\bR\u0011\u0010!\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\bR\u0011\u0010#\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\bR\u0011\u0010%\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\bR\u0011\u0010)\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\bR\u0011\u0010+\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\bR\u0011\u0010-\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\bR\u0011\u0010/\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\bR\u0011\u00101\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\bR\u0011\u00103\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\b\u00a8\u0006R"}, d2={"Lcom/github/ajalt/mordant/terminal/TerminalColors;", "", "level", "Lcom/github/ajalt/mordant/terminal/AnsiLevel;", "(Lcom/github/ajalt/mordant/terminal/AnsiLevel;)V", "black", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "getBlack", "()Lcom/github/ajalt/mordant/rendering/TextStyle;", "blue", "getBlue", "bold", "getBold", "brightBlue", "getBrightBlue", "brightCyan", "getBrightCyan", "brightGreen", "getBrightGreen", "brightMagenta", "getBrightMagenta", "brightRed", "getBrightRed", "brightWhite", "getBrightWhite", "brightYellow", "getBrightYellow", "cyan", "getCyan", "dim", "getDim", "gray", "getGray", "green", "getGreen", "inverse", "getInverse", "italic", "getItalic", "magenta", "getMagenta", "plain", "getPlain", "red", "getRed", "strikethrough", "getStrikethrough", "underline", "getUnderline", "white", "getWhite", "yellow", "getYellow", "cmyk", "c", "", "m", "y", "k", "color", "Lcom/github/ajalt/colormath/Color;", "downsample", "style", "fraction", "", "hsl", "h", "s", "l", "hsv", "v", "lab", "a", "b", "rgb", "r", "g", "hex", "", "xyz", "x", "z", "mordant"})
public final class TerminalColors {
    private final AnsiLevel level;

    @NotNull
    public final TextStyle getBlack() {
        return this.downsample(TextColors.black);
    }

    @NotNull
    public final TextStyle getRed() {
        return this.downsample(TextColors.red);
    }

    @NotNull
    public final TextStyle getGreen() {
        return this.downsample(TextColors.green);
    }

    @NotNull
    public final TextStyle getYellow() {
        return this.downsample(TextColors.yellow);
    }

    @NotNull
    public final TextStyle getBlue() {
        return this.downsample(TextColors.blue);
    }

    @NotNull
    public final TextStyle getMagenta() {
        return this.downsample(TextColors.magenta);
    }

    @NotNull
    public final TextStyle getCyan() {
        return this.downsample(TextColors.cyan);
    }

    @NotNull
    public final TextStyle getWhite() {
        return this.downsample(TextColors.white);
    }

    @NotNull
    public final TextStyle getGray() {
        return this.downsample(TextColors.gray);
    }

    @NotNull
    public final TextStyle getBrightRed() {
        return this.downsample(TextColors.brightRed);
    }

    @NotNull
    public final TextStyle getBrightGreen() {
        return this.downsample(TextColors.brightGreen);
    }

    @NotNull
    public final TextStyle getBrightYellow() {
        return this.downsample(TextColors.brightYellow);
    }

    @NotNull
    public final TextStyle getBrightBlue() {
        return this.downsample(TextColors.brightBlue);
    }

    @NotNull
    public final TextStyle getBrightMagenta() {
        return this.downsample(TextColors.brightMagenta);
    }

    @NotNull
    public final TextStyle getBrightCyan() {
        return this.downsample(TextColors.brightCyan);
    }

    @NotNull
    public final TextStyle getBrightWhite() {
        return this.downsample(TextColors.brightWhite);
    }

    @NotNull
    public final TextStyle getBold() {
        return this.downsample(TextStyles.bold.getStyle());
    }

    @NotNull
    public final TextStyle getDim() {
        return this.downsample(TextStyles.dim.getStyle());
    }

    @NotNull
    public final TextStyle getItalic() {
        return this.downsample(TextStyles.italic.getStyle());
    }

    @NotNull
    public final TextStyle getUnderline() {
        return this.downsample(TextStyles.underline.getStyle());
    }

    @NotNull
    public final TextStyle getInverse() {
        return this.downsample(TextStyles.inverse.getStyle());
    }

    @NotNull
    public final TextStyle getStrikethrough() {
        return this.downsample(TextStyles.strikethrough.getStyle());
    }

    @NotNull
    public final TextStyle getPlain() {
        return TextStyleKt.getDEFAULT_STYLE();
    }

    @NotNull
    public final TextStyle rgb(@NotNull String hex) {
        Intrinsics.checkNotNullParameter(hex, "hex");
        return this.color(new RGB(hex));
    }

    @NotNull
    public final TextStyle rgb(int r, int g, int b) {
        return TextColors.Companion.rgb(r, g, b, this.level);
    }

    @NotNull
    public final TextStyle hsl(int h, int s, int l) {
        return TextColors.Companion.hsl(h, s, l, this.level);
    }

    @NotNull
    public final TextStyle hsv(int h, int s, int v) {
        return TextColors.Companion.hsv(h, s, v, this.level);
    }

    @NotNull
    public final TextStyle cmyk(int c, int m, int y, int k) {
        return TextColors.Companion.cmyk(c, m, y, k, this.level);
    }

    @NotNull
    public final TextStyle gray(double fraction) {
        return TextColors.Companion.gray(fraction, this.level);
    }

    @NotNull
    public final TextStyle xyz(double x, double y, double z) {
        return TextColors.Companion.xyz(x, y, z, this.level);
    }

    @NotNull
    public final TextStyle lab(double l, double a, double b) {
        return TextColors.Companion.lab(l, a, b, this.level);
    }

    @NotNull
    public final TextStyle color(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "color");
        return TextColors.Companion.color(color, this.level);
    }

    private final TextStyle downsample(TextStyle style) {
        return this.level == AnsiLevel.NONE ? TextStyleKt.getDEFAULT_STYLE() : style;
    }

    public TerminalColors(@NotNull AnsiLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, "level");
        this.level = level;
    }
}

