/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelListener;
import org.apache.catalina.tribes.ErrorHandler;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.UniqueId;
import org.apache.catalina.tribes.group.ExtendedRpcCallback;
import org.apache.catalina.tribes.group.Response;
import org.apache.catalina.tribes.group.RpcCallback;
import org.apache.catalina.tribes.group.RpcMessage;
import org.apache.catalina.tribes.util.UUIDGenerator;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class RpcChannel
implements ChannelListener {
    private static final Log log = LogFactory.getLog(RpcChannel.class);
    public static final int FIRST_REPLY = 1;
    public static final int MAJORITY_REPLY = 2;
    public static final int ALL_REPLY = 3;
    public static final int NO_REPLY = 4;
    private Channel channel;
    private RpcCallback callback;
    private byte[] rpcId;
    private int replyMessageOptions = 0;
    private ConcurrentMap<RpcCollectorKey, RpcCollector> responseMap = new ConcurrentHashMap<RpcCollectorKey, RpcCollector>();

    public RpcChannel(byte[] byArray, Channel channel, RpcCallback rpcCallback) {
        this.channel = channel;
        this.callback = rpcCallback;
        this.rpcId = byArray;
        channel.addChannelListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response[] send(Member[] memberArray, Serializable serializable, int n, int n2, long l) throws ChannelException {
        if (memberArray == null || memberArray.length == 0) {
            return new Response[0];
        }
        int n3 = n2 & 0xFFFFFFFB;
        RpcCollectorKey rpcCollectorKey = new RpcCollectorKey(UUIDGenerator.randomUUID(false));
        RpcCollector rpcCollector = new RpcCollector(rpcCollectorKey, n, memberArray.length);
        try {
            RpcCollector rpcCollector2 = rpcCollector;
            synchronized (rpcCollector2) {
                if (n != 4) {
                    this.responseMap.put(rpcCollectorKey, rpcCollector);
                }
                RpcMessage rpcMessage = new RpcMessage(this.rpcId, rpcCollectorKey.id, serializable);
                this.channel.send(memberArray, rpcMessage, n3);
                if (n != 4) {
                    rpcCollector.wait(l);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.responseMap.remove(rpcCollectorKey);
        }
        return rpcCollector.getResponses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(Serializable serializable, Member member) {
        RpcMessage rpcMessage = (RpcMessage)serializable;
        RpcCollectorKey rpcCollectorKey = new RpcCollectorKey(rpcMessage.uuid);
        if (rpcMessage.reply) {
            RpcCollector rpcCollector = (RpcCollector)this.responseMap.get(rpcCollectorKey);
            if (rpcCollector == null) {
                if (!(rpcMessage instanceof RpcMessage.NoRpcChannelReply)) {
                    this.callback.leftOver(rpcMessage.message, member);
                }
            } else {
                RpcCollector rpcCollector2 = rpcCollector;
                synchronized (rpcCollector2) {
                    if (this.responseMap.containsKey(rpcCollectorKey)) {
                        if (rpcMessage instanceof RpcMessage.NoRpcChannelReply) {
                            --rpcCollector.destcnt;
                        } else {
                            rpcCollector.addResponse(rpcMessage.message, member);
                        }
                        if (rpcCollector.isComplete()) {
                            rpcCollector.notifyAll();
                        }
                    } else if (!(rpcMessage instanceof RpcMessage.NoRpcChannelReply)) {
                        this.callback.leftOver(rpcMessage.message, member);
                    }
                }
            }
        } else {
            boolean bl = false;
            final ExtendedRpcCallback extendedRpcCallback = this.callback instanceof ExtendedRpcCallback ? (ExtendedRpcCallback)this.callback : null;
            boolean bl2 = (this.replyMessageOptions & 8) == 8;
            Serializable serializable2 = this.callback.replyRequest(rpcMessage.message, member);
            ErrorHandler errorHandler = null;
            final Serializable serializable3 = serializable;
            final Serializable serializable4 = serializable2;
            final Member member2 = member;
            if (extendedRpcCallback != null && bl2) {
                errorHandler = new ErrorHandler(){

                    @Override
                    public void handleError(ChannelException channelException, UniqueId uniqueId) {
                        extendedRpcCallback.replyFailed(serializable3, serializable4, member2, channelException);
                    }

                    @Override
                    public void handleCompletion(UniqueId uniqueId) {
                        extendedRpcCallback.replySucceeded(serializable3, serializable4, member2);
                    }
                };
            }
            rpcMessage.reply = true;
            rpcMessage.message = serializable2;
            try {
                if (errorHandler != null) {
                    this.channel.send(new Member[]{member}, rpcMessage, this.replyMessageOptions & 0xFFFFFFFB, errorHandler);
                } else {
                    this.channel.send(new Member[]{member}, rpcMessage, this.replyMessageOptions & 0xFFFFFFFB);
                }
                bl = true;
            }
            catch (Exception exception) {
                if (extendedRpcCallback != null && !bl2) {
                    extendedRpcCallback.replyFailed(rpcMessage.message, serializable2, member, exception);
                }
                log.error((Object)"Unable to send back reply in RpcChannel.", (Throwable)exception);
            }
            if (bl && extendedRpcCallback != null && !bl2) {
                extendedRpcCallback.replySucceeded(rpcMessage.message, serializable2, member);
            }
        }
    }

    public void breakdown() {
        this.channel.removeChannelListener(this);
    }

    public void finalize() throws Throwable {
        this.breakdown();
        super.finalize();
    }

    @Override
    public boolean accept(Serializable serializable, Member member) {
        if (serializable instanceof RpcMessage) {
            RpcMessage rpcMessage = (RpcMessage)serializable;
            return Arrays.equals(rpcMessage.rpcId, this.rpcId);
        }
        return false;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public RpcCallback getCallback() {
        return this.callback;
    }

    public byte[] getRpcId() {
        return this.rpcId;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setCallback(RpcCallback rpcCallback) {
        this.callback = rpcCallback;
    }

    public void setRpcId(byte[] byArray) {
        this.rpcId = byArray;
    }

    public int getReplyMessageOptions() {
        return this.replyMessageOptions;
    }

    public void setReplyMessageOptions(int n) {
        this.replyMessageOptions = n;
    }

    @Deprecated
    protected static String bToS(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("{");
        for (int i = 0; byArray != null && i < byArray.length; ++i) {
            stringBuilder.append(String.valueOf(byArray[i])).append(" ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static class RpcCollectorKey {
        final byte[] id;

        public RpcCollectorKey(byte[] byArray) {
            this.id = byArray;
        }

        public int hashCode() {
            return this.id[0] + this.id[1] + this.id[2] + this.id[3];
        }

        public boolean equals(Object object) {
            if (object instanceof RpcCollectorKey) {
                RpcCollectorKey rpcCollectorKey = (RpcCollectorKey)object;
                return Arrays.equals(this.id, rpcCollectorKey.id);
            }
            return false;
        }
    }

    public static class RpcCollector {
        public ArrayList<Response> responses = new ArrayList();
        public RpcCollectorKey key;
        public int options;
        public int destcnt;
        @Deprecated
        public long timeout;

        @Deprecated
        public RpcCollector(RpcCollectorKey rpcCollectorKey, int n, int n2, long l) {
            this.key = rpcCollectorKey;
            this.options = n;
            this.destcnt = n2;
            this.timeout = l;
        }

        public RpcCollector(RpcCollectorKey rpcCollectorKey, int n, int n2) {
            this(rpcCollectorKey, n, n2, 0L);
        }

        public void addResponse(Serializable serializable, Member member) {
            Response response = new Response(member, serializable);
            this.responses.add(response);
        }

        public boolean isComplete() {
            if (this.destcnt <= 0) {
                return true;
            }
            switch (this.options) {
                case 3: {
                    return this.destcnt == this.responses.size();
                }
                case 2: {
                    float f = (float)this.responses.size() / (float)this.destcnt;
                    return f >= 0.5f;
                }
                case 1: {
                    return this.responses.size() > 0;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof RpcCollector) {
                RpcCollector rpcCollector = (RpcCollector)object;
                return rpcCollector.key.equals(this.key);
            }
            return false;
        }

        public Response[] getResponses() {
            return this.responses.toArray(new Response[0]);
        }
    }
}

