/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tomcat.util.digester.Rule;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class NodeCreateRule
extends Rule {
    private DocumentBuilder documentBuilder = null;
    private int nodeType = 1;

    public NodeCreateRule() throws ParserConfigurationException {
        this(1);
    }

    public NodeCreateRule(DocumentBuilder documentBuilder) {
        this(1, documentBuilder);
    }

    public NodeCreateRule(int n) throws ParserConfigurationException {
        this(n, DocumentBuilderFactory.newInstance().newDocumentBuilder());
    }

    public NodeCreateRule(int n, DocumentBuilder documentBuilder) {
        if (n != 11 && n != 1) {
            throw new IllegalArgumentException("Can only create nodes of type DocumentFragment and Element");
        }
        this.nodeType = n;
        this.documentBuilder = documentBuilder;
    }

    @Override
    public void begin(String string, String string2, Attributes attributes) throws Exception {
        XMLReader xMLReader = this.getDigester().getXMLReader();
        Document document = this.documentBuilder.newDocument();
        NodeBuilder nodeBuilder = null;
        if (this.nodeType == 1) {
            Element element = null;
            if (this.getDigester().getNamespaceAware()) {
                element = document.createElementNS(string, string2);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    element.setAttributeNS(attributes.getURI(i), attributes.getLocalName(i), attributes.getValue(i));
                }
            } else {
                element = document.createElement(string2);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    element.setAttribute(attributes.getQName(i), attributes.getValue(i));
                }
            }
            nodeBuilder = new NodeBuilder(document, element);
        } else {
            nodeBuilder = new NodeBuilder(document, document.createDocumentFragment());
        }
        xMLReader.setContentHandler(nodeBuilder);
    }

    @Override
    public void end(String string, String string2) throws Exception {
        this.digester.pop();
    }

    private class NodeBuilder
    extends DefaultHandler {
        protected ContentHandler oldContentHandler = null;
        protected int depth = 0;
        protected Document doc = null;
        protected Node root = null;
        protected Node top = null;

        public NodeBuilder(Document document, Node node) throws ParserConfigurationException, SAXException {
            this.doc = document;
            this.root = node;
            this.top = node;
            this.oldContentHandler = NodeCreateRule.this.digester.getXMLReader().getContentHandler();
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            try {
                String string = new String(cArray, n, n2);
                if (string.trim().length() > 0) {
                    this.top.appendChild(this.doc.createTextNode(string));
                }
            }
            catch (DOMException dOMException) {
                throw new SAXException(dOMException.getMessage(), dOMException);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            try {
                if (this.depth == 0) {
                    NodeCreateRule.this.getDigester().getXMLReader().setContentHandler(this.oldContentHandler);
                    NodeCreateRule.this.getDigester().push(this.root);
                    NodeCreateRule.this.getDigester().endElement(string, string2, string3);
                }
                this.top = this.top.getParentNode();
                --this.depth;
            }
            catch (DOMException dOMException) {
                throw new SAXException(dOMException.getMessage(), dOMException);
            }
        }

        @Override
        public void processingInstruction(String string, String string2) throws SAXException {
            try {
                this.top.appendChild(this.doc.createProcessingInstruction(string, string2));
            }
            catch (DOMException dOMException) {
                throw new SAXException(dOMException.getMessage(), dOMException);
            }
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                Node node = this.top;
                this.top = string2 == null || string2.length() == 0 ? this.doc.createElement(string3) : this.doc.createElementNS(string, string2);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Attr attr = null;
                    if (attributes.getLocalName(i) == null || attributes.getLocalName(i).length() == 0) {
                        attr = this.doc.createAttribute(attributes.getQName(i));
                        attr.setNodeValue(attributes.getValue(i));
                        ((Element)this.top).setAttributeNode(attr);
                        continue;
                    }
                    attr = this.doc.createAttributeNS(attributes.getURI(i), attributes.getLocalName(i));
                    attr.setNodeValue(attributes.getValue(i));
                    ((Element)this.top).setAttributeNodeNS(attr);
                }
                node.appendChild(this.top);
                ++this.depth;
            }
            catch (DOMException dOMException) {
                throw new SAXException(dOMException.getMessage(), dOMException);
            }
        }
    }
}

