/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.datasource;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.core.datasupport.Utils;

public final class Storage {
    private static final String VISUALVM_TMP_DIR = System.getProperty("visualvm.tmpdir");
    private static final String TEMPORARY_STORAGE_DIRNAME = "visualvm.dat";
    private static final String TEMPORARY_STORAGE_DIRNAME_EX = "visualvm_{0}.dat";
    private static final String PERSISTENT_STORAGE_DIRNAME = "repository";
    private static final Logger LOGGER = Logger.getLogger(Storage.class.getName());
    public static final String DEFAULT_PROPERTIES_EXT = ".properties";
    private static final Object temporaryStorageDirectoryLock = new Object();
    private static File temporaryStorageDirectory;
    private static final Object temporaryStorageDirectoryStringLock;
    private static String temporaryStorageDirectoryString;
    private static final Object persistentStorageDirectoryLock;
    private static File persistentStorageDirectory;
    private static final Object persistentStorageDirectoryStringLock;
    private static String persistentStorageDirectoryString;
    private final File directory;
    private final File propertiesFile;
    private Properties properties;

    public Storage() {
        this(new File(Storage.getTemporaryStorageDirectoryString()));
    }

    public Storage(File directory) {
        this(directory, null);
    }

    public Storage(File directory, String propertiesFile) {
        if (directory == null) {
            throw new NullPointerException("Directory cannot be null");
        }
        if (directory.isFile()) {
            throw new IllegalArgumentException("Not a valid directory: " + directory);
        }
        this.directory = directory;
        this.propertiesFile = propertiesFile != null ? new File(directory, propertiesFile) : null;
    }

    public synchronized boolean directoryExists() {
        return this.directory.exists();
    }

    public synchronized File getDirectory() {
        if (!Utils.prepareDirectory(this.directory)) {
            throw new IllegalStateException("Cannot create storage directory " + this.directory);
        }
        return this.directory;
    }

    public String getCustomProperty(String key) {
        return this.getCustomProperties(new String[]{key})[0];
    }

    public synchronized String[] getCustomProperties(String[] keys) {
        String[] values = new String[keys.length];
        Properties prop = this.getCustomProperties(false);
        if (prop != null) {
            for (int i = 0; i < keys.length; ++i) {
                values[i] = prop.getProperty(keys[i]);
            }
        }
        return values;
    }

    public void setCustomProperty(String key, String value) {
        this.setCustomProperties(new String[]{key}, new String[]{value});
    }

    public synchronized void setCustomProperties(String[] keys, String[] values) {
        Properties prop = this.getCustomProperties(true);
        for (int i = 0; i < keys.length; ++i) {
            if (values[i] != null) {
                prop.put(keys[i], values[i]);
                continue;
            }
            prop.remove(keys[i]);
        }
        this.storeCustomProperties();
    }

    public void clearCustomProperty(String key) {
        this.clearCustomProperties(new String[]{key});
    }

    public synchronized void clearCustomProperties(String[] keys) {
        Properties prop = this.getCustomProperties(false);
        if (prop != null) {
            for (int i = 0; i < keys.length; ++i) {
                prop.remove(keys[i]);
            }
        }
        this.storeCustomProperties();
    }

    public synchronized boolean hasCustomProperties() {
        Properties prop = this.getCustomProperties(false);
        return prop != null && !prop.isEmpty();
    }

    public synchronized void saveCustomPropertiesTo(File file) {
        if (file == null) {
            throw new NullPointerException("File cannot be null");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Not a valid file: " + file);
        }
        Properties prop = this.getCustomProperties(false);
        if (prop != null && !prop.isEmpty()) {
            Storage.storeProperties(prop, file);
        }
    }

    public synchronized void deleteCustomPropertiesStorage() {
        if (this.propertiesFile != null && this.propertiesFile.exists() && !this.propertiesFile.delete()) {
            this.propertiesFile.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTemporaryStorageDirectoryString() {
        Object object = temporaryStorageDirectoryStringLock;
        synchronized (object) {
            if (temporaryStorageDirectoryString == null) {
                if (VISUALVM_TMP_DIR != null) {
                    temporaryStorageDirectoryString = new File(VISUALVM_TMP_DIR).getAbsolutePath() + File.separator + TEMPORARY_STORAGE_DIRNAME;
                } else {
                    String storageDir;
                    String tmpDir = System.getProperty("java.io.tmpdir");
                    String userDir = System.getProperty("user.home");
                    if (userDir != null && !userDir.isEmpty()) {
                        String userName = new File(userDir).getName();
                        storageDir = MessageFormat.format(TEMPORARY_STORAGE_DIRNAME_EX, userName);
                    } else {
                        storageDir = TEMPORARY_STORAGE_DIRNAME;
                    }
                    temporaryStorageDirectoryString = new File(tmpDir).getAbsolutePath() + File.separator + storageDir;
                }
            }
            return temporaryStorageDirectoryString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getTemporaryStorageDirectory() {
        Object object = temporaryStorageDirectoryLock;
        synchronized (object) {
            if (temporaryStorageDirectory == null) {
                String temporaryStorageString = Storage.getTemporaryStorageDirectoryString();
                temporaryStorageDirectory = new File(temporaryStorageString);
                if (temporaryStorageDirectory.exists() && temporaryStorageDirectory.isFile()) {
                    throw new IllegalStateException("Cannot create temporary storage directory " + temporaryStorageString + ", file in the way");
                }
                if (!(!temporaryStorageDirectory.exists() || temporaryStorageDirectory.canRead() && temporaryStorageDirectory.canWrite())) {
                    throw new IllegalStateException("Cannot access temporary storage directory " + temporaryStorageString + ", read&write permission required");
                }
                if (!Utils.prepareDirectory(temporaryStorageDirectory)) {
                    throw new IllegalStateException("Cannot create temporary storage directory " + temporaryStorageString);
                }
            }
            return temporaryStorageDirectory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPersistentStorageDirectoryString() {
        Object object = persistentStorageDirectoryStringLock;
        synchronized (object) {
            if (persistentStorageDirectoryString == null) {
                persistentStorageDirectoryString = new File(System.getProperty("netbeans.user")).getAbsolutePath() + File.separator + PERSISTENT_STORAGE_DIRNAME;
            }
            return persistentStorageDirectoryString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getPersistentStorageDirectory() {
        Object object = persistentStorageDirectoryLock;
        synchronized (object) {
            if (persistentStorageDirectory == null) {
                String persistentStorageString = Storage.getPersistentStorageDirectoryString();
                persistentStorageDirectory = new File(persistentStorageString);
                if (persistentStorageDirectory.exists() && persistentStorageDirectory.isFile()) {
                    throw new IllegalStateException("Cannot create persistent storage directory " + persistentStorageString + ", file in the way");
                }
                if (!(!persistentStorageDirectory.exists() || persistentStorageDirectory.canRead() && persistentStorageDirectory.canWrite())) {
                    throw new IllegalStateException("Cannot access persistent storage directory " + persistentStorageString + ", read&write permission required");
                }
                if (!Utils.prepareDirectory(persistentStorageDirectory)) {
                    throw new IllegalStateException("Cannot create persistent storage directory " + persistentStorageString);
                }
            }
            return persistentStorageDirectory;
        }
    }

    public static boolean persistentStorageDirectoryExists() {
        return new File(Storage.getPersistentStorageDirectoryString()).isDirectory();
    }

    private void storeCustomProperties() {
        if (this.properties != null && this.propertiesFile != null) {
            Storage.storeProperties(this.properties, this.propertiesFile);
        }
    }

    private Properties getCustomProperties(boolean createEmpty) {
        if (this.properties == null && this.propertiesFile != null) {
            this.properties = Storage.loadProperties(this.propertiesFile);
        }
        if (this.properties == null && createEmpty) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(File file) {
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        FileInputStream is = null;
        BufferedInputStream bis = null;
        try {
            is = new FileInputStream(file);
            bis = new BufferedInputStream(is);
            Properties properties = new Properties();
            properties.loadFromXML(bis);
            Properties properties2 = properties;
            return properties2;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error loading properties", e);
            Properties properties = null;
            return properties;
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Problem closing input stream", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeProperties(Properties properties, File file) {
        Utils.prepareDirectory(file.getParentFile());
        FileOutputStream os = null;
        FilterOutputStream bos = null;
        try {
            os = new FileOutputStream(file);
            bos = new BufferedOutputStream(os);
            properties.storeToXML(os, null);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error storing properties", e);
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Problem closing output stream", e);
            }
        }
    }

    static {
        temporaryStorageDirectoryStringLock = new Object();
        persistentStorageDirectoryLock = new Object();
        persistentStorageDirectoryStringLock = new Object();
    }
}

