/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IBranchRegion;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.trycatch.CatchAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.trycatch.TryCatchBlock;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class RegionUtils {
    private RegionUtils() {
    }

    public static boolean hasExitEdge(IContainer container) {
        if (container instanceof IBlock) {
            InsnNode lastInsn = BlockUtils.getLastInsn((IBlock)container);
            if (lastInsn == null) {
                return false;
            }
            InsnType type = lastInsn.getType();
            return type == InsnType.RETURN || type == InsnType.CONTINUE || type == InsnType.BREAK || type == InsnType.THROW;
        }
        if (container instanceof IBranchRegion) {
            for (IContainer br : ((IBranchRegion)container).getBranches()) {
                if (br != null && RegionUtils.hasExitEdge(br)) continue;
                return false;
            }
            return true;
        }
        if (container instanceof IRegion) {
            IRegion region = (IRegion)container;
            List<IContainer> blocks = region.getSubBlocks();
            return !blocks.isEmpty() && RegionUtils.hasExitEdge(blocks.get(blocks.size() - 1));
        }
        throw new JadxRuntimeException(RegionUtils.unknownContainerType(container));
    }

    public static InsnNode getLastInsn(IContainer container) {
        if (container instanceof IBlock) {
            IBlock block = (IBlock)container;
            List<InsnNode> insnList = block.getInstructions();
            if (insnList.isEmpty()) {
                return null;
            }
            return insnList.get(insnList.size() - 1);
        }
        if (container instanceof IBranchRegion) {
            return null;
        }
        if (container instanceof IRegion) {
            IRegion region = (IRegion)container;
            List<IContainer> blocks = region.getSubBlocks();
            if (blocks.isEmpty()) {
                return null;
            }
            return RegionUtils.getLastInsn(blocks.get(blocks.size() - 1));
        }
        throw new JadxRuntimeException(RegionUtils.unknownContainerType(container));
    }

    public static IBlock getLastBlock(IContainer container) {
        if (container instanceof IBlock) {
            return (IBlock)container;
        }
        if (container instanceof IBranchRegion) {
            return null;
        }
        if (container instanceof IRegion) {
            List<IContainer> blocks = ((IRegion)container).getSubBlocks();
            if (blocks.isEmpty()) {
                return null;
            }
            return RegionUtils.getLastBlock(blocks.get(blocks.size() - 1));
        }
        throw new JadxRuntimeException(RegionUtils.unknownContainerType(container));
    }

    public static boolean hasExitBlock(IContainer container) {
        if (container instanceof BlockNode) {
            return ((BlockNode)container).getSuccessors().isEmpty();
        }
        if (container instanceof IBlock) {
            return true;
        }
        if (container instanceof IRegion) {
            List<IContainer> blocks = ((IRegion)container).getSubBlocks();
            return !blocks.isEmpty() && RegionUtils.hasExitBlock(blocks.get(blocks.size() - 1));
        }
        throw new JadxRuntimeException(RegionUtils.unknownContainerType(container));
    }

    public static boolean hasBreakInsn(IContainer container) {
        if (container instanceof IBlock) {
            return BlockUtils.checkLastInsnType((IBlock)container, InsnType.BREAK);
        }
        if (container instanceof IRegion) {
            List<IContainer> blocks = ((IRegion)container).getSubBlocks();
            return !blocks.isEmpty() && RegionUtils.hasBreakInsn(blocks.get(blocks.size() - 1));
        }
        throw new JadxRuntimeException("Unknown container type: " + container);
    }

    public static int insnsCount(IContainer container) {
        if (container instanceof IBlock) {
            return ((IBlock)container).getInstructions().size();
        }
        if (container instanceof IRegion) {
            IRegion region = (IRegion)container;
            int count = 0;
            for (IContainer block : region.getSubBlocks()) {
                count += RegionUtils.insnsCount(block);
            }
            return count;
        }
        throw new JadxRuntimeException(RegionUtils.unknownContainerType(container));
    }

    public static boolean isEmpty(IContainer container) {
        return !RegionUtils.notEmpty(container);
    }

    public static boolean notEmpty(IContainer container) {
        if (container instanceof IBlock) {
            return !((IBlock)container).getInstructions().isEmpty();
        }
        if (container instanceof IRegion) {
            IRegion region = (IRegion)container;
            for (IContainer block : region.getSubBlocks()) {
                if (!RegionUtils.notEmpty(block)) continue;
                return true;
            }
            return false;
        }
        throw new JadxRuntimeException(RegionUtils.unknownContainerType(container));
    }

    public static void getAllRegionBlocks(IContainer container, Set<IBlock> blocks) {
        if (container instanceof IBlock) {
            blocks.add((IBlock)container);
        } else if (container instanceof IRegion) {
            IRegion region = (IRegion)container;
            for (IContainer block : region.getSubBlocks()) {
                RegionUtils.getAllRegionBlocks(block, blocks);
            }
        } else {
            throw new JadxRuntimeException(RegionUtils.unknownContainerType(container));
        }
    }

    public static boolean isRegionContainsBlock(IContainer container, BlockNode block) {
        if (container instanceof IBlock) {
            return container == block;
        }
        if (container instanceof IRegion) {
            IRegion region = (IRegion)container;
            for (IContainer b : region.getSubBlocks()) {
                if (!RegionUtils.isRegionContainsBlock(b, block)) continue;
                return true;
            }
            return false;
        }
        throw new JadxRuntimeException(RegionUtils.unknownContainerType(container));
    }

    public static List<IContainer> getExcHandlersForRegion(IContainer region) {
        CatchAttr cb = region.get(AType.CATCH_BLOCK);
        if (cb != null) {
            TryCatchBlock tb = cb.getTryBlock();
            ArrayList<IContainer> list = new ArrayList<IContainer>(tb.getHandlersCount());
            for (ExceptionHandler eh : tb.getHandlers()) {
                list.add(eh.getHandlerRegion());
            }
            return list;
        }
        return Collections.emptyList();
    }

    private static boolean isRegionContainsExcHandlerRegion(IContainer container, IRegion region) {
        if (container == region) {
            return true;
        }
        if (container instanceof IRegion) {
            IRegion r = (IRegion)container;
            for (IContainer b : r.getSubBlocks()) {
                CatchAttr cb = b.get(AType.CATCH_BLOCK);
                if (cb != null && b instanceof IRegion) {
                    TryCatchBlock tb = cb.getTryBlock();
                    for (ExceptionHandler eh : tb.getHandlers()) {
                        if (!RegionUtils.isRegionContainsRegion(eh.getHandlerRegion(), region)) continue;
                        return true;
                    }
                }
                if (!RegionUtils.isRegionContainsRegion(b, region)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRegionContainsRegion(IContainer container, IRegion region) {
        if (container == region) {
            return true;
        }
        if (region == null) {
            return false;
        }
        IRegion parent = region.getParent();
        while (container != parent) {
            if (parent == null) {
                if (region.contains(AType.EXC_HANDLER)) {
                    return RegionUtils.isRegionContainsExcHandlerRegion(container, region);
                }
                return false;
            }
            region = parent;
            parent = region.getParent();
        }
        return true;
    }

    public static IContainer getBlockContainer(IContainer container, BlockNode block) {
        if (container instanceof IBlock) {
            return container == block ? container : null;
        }
        if (container instanceof IRegion) {
            IRegion region = (IRegion)container;
            for (IContainer c : region.getSubBlocks()) {
                IContainer res = RegionUtils.getBlockContainer(c, block);
                if (res == null) continue;
                return res instanceof IBlock ? region : res;
            }
            return null;
        }
        throw new JadxRuntimeException(RegionUtils.unknownContainerType(container));
    }

    public static boolean isDominatedBy(BlockNode dom, IContainer cont) {
        if (dom == cont) {
            return true;
        }
        if (cont instanceof BlockNode) {
            BlockNode block = (BlockNode)cont;
            return block.isDominator(dom);
        }
        if (cont instanceof IBlock) {
            return false;
        }
        if (cont instanceof IRegion) {
            IRegion region = (IRegion)cont;
            for (IContainer c : region.getSubBlocks()) {
                if (RegionUtils.isDominatedBy(dom, c)) continue;
                return false;
            }
            return true;
        }
        throw new JadxRuntimeException(RegionUtils.unknownContainerType(cont));
    }

    public static boolean hasPathThroughBlock(BlockNode block, IContainer cont) {
        if (block == cont) {
            return true;
        }
        if (cont instanceof BlockNode) {
            return BlockUtils.isPathExists(block, (BlockNode)cont);
        }
        if (cont instanceof IBlock) {
            return false;
        }
        if (cont instanceof IRegion) {
            IRegion region = (IRegion)cont;
            for (IContainer c : region.getSubBlocks()) {
                if (RegionUtils.hasPathThroughBlock(block, c)) continue;
                return false;
            }
            return true;
        }
        throw new JadxRuntimeException(RegionUtils.unknownContainerType(cont));
    }

    protected static String unknownContainerType(IContainer container) {
        if (container == null) {
            return "Null container variable";
        }
        return "Unknown container type: " + container.getClass();
    }
}

