/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.events;

import com.carrotsearch.ant.tasks.junit4.events.EventType;
import com.carrotsearch.ant.tasks.junit4.events.JsonHelpers;
import com.carrotsearch.ant.tasks.junit4.events.RemoteEvent;
import com.carrotsearch.ant.tasks.junit4.gson.stream.JsonReader;
import com.carrotsearch.ant.tasks.junit4.gson.stream.JsonToken;
import com.carrotsearch.ant.tasks.junit4.gson.stream.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.junit.runner.Description;

abstract class AbstractEvent
implements RemoteEvent {
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();
    private final transient EventType type;

    public AbstractEvent(EventType eventType) {
        if (this.getClass() != eventType.eventClass) {
            throw new RuntimeException("Event type mismatch: " + (Object)((Object)eventType) + ", class: " + this.getClass());
        }
        this.type = eventType;
    }

    @Override
    public EventType getType() {
        return this.type;
    }

    protected static JsonWriter writeBinaryProperty(JsonWriter jsonWriter, String string, byte[] byArray) {
        return jsonWriter.name(string).value(AbstractEvent.toAscii(byArray));
    }

    protected static byte[] readBinaryProperty(JsonReader jsonReader, String string) {
        return AbstractEvent.fromAscii(AbstractEvent.expectProperty(jsonReader, string).nextString());
    }

    protected static String readStringProperty(JsonReader jsonReader, String string) {
        if (AbstractEvent.expectProperty(jsonReader, string).peek() != JsonToken.STRING) {
            throw new IOException("Expected a non-null string for property: " + string);
        }
        return jsonReader.nextString();
    }

    protected static String readStringOrNullProperty(JsonReader jsonReader, String string) {
        AbstractEvent.expectProperty(jsonReader, string);
        if (jsonReader.peek() == JsonToken.STRING) {
            return jsonReader.nextString();
        }
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        throw new IOException("Expected a non or string for property: " + string);
    }

    protected static boolean readBoolean(JsonReader jsonReader, String string) {
        AbstractEvent.expectProperty(jsonReader, string);
        return jsonReader.nextBoolean();
    }

    protected static long readLongProperty(JsonReader jsonReader, String string) {
        return AbstractEvent.expectProperty(jsonReader, string).nextLong();
    }

    protected static JsonReader expectProperty(JsonReader jsonReader, String string) {
        String string2 = jsonReader.nextName();
        if (!string.equals(string2)) {
            throw new IOException("Expected property: " + string + " but got: " + string2);
        }
        return jsonReader;
    }

    private static byte[] fromAscii(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '%') {
                byteArrayOutputStream.write(c);
                continue;
            }
            byteArrayOutputStream.write(AbstractEvent.hexValue(string.charAt(++i)) << 4 | AbstractEvent.hexValue(string.charAt(++i)));
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static int hexValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IOException("Unexpected character in binary stream: " + c);
    }

    private static String toAscii(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            if (by >= 32 && by <= 126 && by != 37) {
                stringBuilder.append((char)by);
                continue;
            }
            stringBuilder.append('%');
            stringBuilder.append(HEX[by >> 4 & 0xF]);
            stringBuilder.append(HEX[by & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static void writeDescription(JsonWriter jsonWriter, Description description) {
        JsonHelpers.writeDescription(jsonWriter, description);
    }
}

