/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class CatalinaProperties {
    private static final Log log = LogFactory.getLog(CatalinaProperties.class);
    private static Properties properties = null;

    public static String getProperty(String string) {
        return properties.getProperty(string);
    }

    @Deprecated
    public static String getProperty(String string, String string2) {
        return properties.getProperty(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties() {
        Object object;
        Object object2;
        Enumeration<?> enumeration;
        InputStream inputStream = null;
        Throwable throwable = null;
        try {
            enumeration = CatalinaProperties.getConfigUrl();
            if (enumeration != null) {
                inputStream = new URL((String)((Object)enumeration)).openStream();
            }
        }
        catch (Throwable throwable2) {
            CatalinaProperties.handleThrowable(throwable2);
        }
        if (inputStream == null) {
            try {
                enumeration = new File(CatalinaProperties.getCatalinaBase());
                object2 = new File((File)((Object)enumeration), "conf");
                object = new File((File)object2, "catalina.properties");
                inputStream = new FileInputStream((File)object);
            }
            catch (Throwable throwable3) {
                CatalinaProperties.handleThrowable(throwable3);
            }
        }
        if (inputStream == null) {
            try {
                inputStream = CatalinaProperties.class.getResourceAsStream("/org/apache/catalina/startup/catalina.properties");
            }
            catch (Throwable throwable4) {
                CatalinaProperties.handleThrowable(throwable4);
            }
        }
        if (inputStream != null) {
            try {
                properties = new Properties();
                properties.load(inputStream);
            }
            catch (Throwable throwable5) {
                CatalinaProperties.handleThrowable(throwable5);
                throwable = throwable5;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    log.warn((Object)"Could not close catalina.properties", (Throwable)iOException);
                }
            }
        }
        if (inputStream == null || throwable != null) {
            log.warn((Object)"Failed to load catalina.properties", throwable);
            properties = new Properties();
        }
        enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = properties.getProperty((String)object2);
            if (object == null) continue;
            System.setProperty((String)object2, (String)object);
        }
    }

    private static String getCatalinaHome() {
        return System.getProperty("catalina.home", System.getProperty("user.dir"));
    }

    private static String getCatalinaBase() {
        return System.getProperty("catalina.base", CatalinaProperties.getCatalinaHome());
    }

    private static String getConfigUrl() {
        return System.getProperty("catalina.config");
    }

    private static void handleThrowable(Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        if (throwable instanceof VirtualMachineError) {
            throw (VirtualMachineError)throwable;
        }
    }

    static {
        CatalinaProperties.loadProperties();
    }
}

