/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.util.ArrayList;
import org.apache.coyote.RequestInfo;

public class RequestGroupInfo {
    ArrayList<RequestInfo> processors = new ArrayList();
    private long deadMaxTime = 0L;
    private long deadProcessingTime = 0L;
    private int deadRequestCount = 0;
    private int deadErrorCount = 0;
    private long deadBytesReceived = 0L;
    private long deadBytesSent = 0L;

    public synchronized void addRequestProcessor(RequestInfo requestInfo) {
        this.processors.add(requestInfo);
    }

    public synchronized void removeRequestProcessor(RequestInfo requestInfo) {
        if (requestInfo != null) {
            if (this.deadMaxTime < requestInfo.getMaxTime()) {
                this.deadMaxTime = requestInfo.getMaxTime();
            }
            this.deadProcessingTime += requestInfo.getProcessingTime();
            this.deadRequestCount += requestInfo.getRequestCount();
            this.deadErrorCount += requestInfo.getErrorCount();
            this.deadBytesReceived += requestInfo.getBytesReceived();
            this.deadBytesSent += requestInfo.getBytesSent();
            this.processors.remove(requestInfo);
        }
    }

    public synchronized long getMaxTime() {
        long l = this.deadMaxTime;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo requestInfo = this.processors.get(i);
            if (l >= requestInfo.getMaxTime()) continue;
            l = requestInfo.getMaxTime();
        }
        return l;
    }

    public synchronized void setMaxTime(long l) {
        this.deadMaxTime = l;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo requestInfo = this.processors.get(i);
            requestInfo.setMaxTime(l);
        }
    }

    public synchronized long getProcessingTime() {
        long l = this.deadProcessingTime;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo requestInfo = this.processors.get(i);
            l += requestInfo.getProcessingTime();
        }
        return l;
    }

    public synchronized void setProcessingTime(long l) {
        this.deadProcessingTime = l;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo requestInfo = this.processors.get(i);
            requestInfo.setProcessingTime(l);
        }
    }

    public synchronized int getRequestCount() {
        int n = this.deadRequestCount;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo requestInfo = this.processors.get(i);
            n += requestInfo.getRequestCount();
        }
        return n;
    }

    public synchronized void setRequestCount(int n) {
        this.deadRequestCount = n;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo requestInfo = this.processors.get(i);
            requestInfo.setRequestCount(n);
        }
    }

    public synchronized int getErrorCount() {
        int n = this.deadErrorCount;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo requestInfo = this.processors.get(i);
            n += requestInfo.getErrorCount();
        }
        return n;
    }

    public synchronized void setErrorCount(int n) {
        this.deadErrorCount = n;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo requestInfo = this.processors.get(i);
            requestInfo.setErrorCount(n);
        }
    }

    public synchronized long getBytesReceived() {
        long l = this.deadBytesReceived;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo requestInfo = this.processors.get(i);
            l += requestInfo.getBytesReceived();
        }
        return l;
    }

    public synchronized void setBytesReceived(long l) {
        this.deadBytesReceived = l;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo requestInfo = this.processors.get(i);
            requestInfo.setBytesReceived(l);
        }
    }

    public synchronized long getBytesSent() {
        long l = this.deadBytesSent;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo requestInfo = this.processors.get(i);
            l += requestInfo.getBytesSent();
        }
        return l;
    }

    public synchronized void setBytesSent(long l) {
        this.deadBytesSent = l;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo requestInfo = this.processors.get(i);
            requestInfo.setBytesSent(l);
        }
    }

    public void resetCounters() {
        this.setBytesReceived(0L);
        this.setBytesSent(0L);
        this.setRequestCount(0);
        this.setProcessingTime(0L);
        this.setMaxTime(0L);
        this.setErrorCount(0);
    }
}

