/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.util;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.UniqueId;
import org.apache.catalina.tribes.group.AbsoluteOrder;
import org.apache.catalina.tribes.membership.MemberImpl;
import org.apache.catalina.tribes.membership.Membership;

public class Arrays {
    private static final Charset CHARSET_ISO_8859_1 = Charset.forName("ISO-8859-1");

    public static boolean contains(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (n < 0 || n >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException("srcoffset is out of bounds.");
        }
        if (n2 < 0 || n2 >= byArray2.length) {
            throw new ArrayIndexOutOfBoundsException("keyoffset is out of bounds.");
        }
        if (n3 > byArray2.length - n2) {
            throw new ArrayIndexOutOfBoundsException("not enough data elements in the key, length is out of bounds.");
        }
        if (n3 > byArray.length - n) {
            return false;
        }
        boolean bl = true;
        int n4 = n2;
        for (int i = n; bl && i < n3; ++i) {
            bl = byArray[i] == byArray2[n4++];
        }
        return bl;
    }

    public static String toString(byte[] byArray) {
        return Arrays.toString(byArray, 0, byArray != null ? byArray.length : 0);
    }

    public static String toString(byte[] byArray, int n, int n2) {
        return Arrays.toString(byArray, n, n2, false);
    }

    public static String toString(byte[] byArray, int n, int n2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("{");
        if (byArray != null && n2 > 0) {
            int n3 = n;
            if (bl) {
                stringBuilder.append(byArray[n3++] & 0xFF);
                while (n3 < n2) {
                    stringBuilder.append(", ").append(byArray[n3] & 0xFF);
                    ++n3;
                }
            } else {
                stringBuilder.append(byArray[n3++]);
                while (n3 < n2) {
                    stringBuilder.append(", ").append(byArray[n3]);
                    ++n3;
                }
            }
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static String toString(Object[] objectArray) {
        return Arrays.toString(objectArray, 0, objectArray != null ? objectArray.length : 0);
    }

    public static String toString(Object[] objectArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder("{");
        if (objectArray != null && n2 > 0) {
            stringBuilder.append(objectArray[n++]);
            for (int i = n; i < n2; ++i) {
                stringBuilder.append(", ").append(objectArray[i]);
            }
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static String toNameString(Member[] memberArray) {
        return Arrays.toNameString(memberArray, 0, memberArray != null ? memberArray.length : 0);
    }

    public static String toNameString(Member[] memberArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder("{");
        if (memberArray != null && n2 > 0) {
            stringBuilder.append(memberArray[n++].getName());
            for (int i = n; i < n2; ++i) {
                stringBuilder.append(", ").append(memberArray[i].getName());
            }
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static int add(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            n += n2;
        }
        return n;
    }

    public static UniqueId getUniqudId(ChannelMessage channelMessage) {
        return new UniqueId(channelMessage.getUniqueId());
    }

    public static UniqueId getUniqudId(byte[] byArray) {
        return new UniqueId(byArray);
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        return java.util.Arrays.equals(byArray, byArray2);
    }

    public static boolean equals(Object[] objectArray, Object[] objectArray2) {
        boolean bl;
        boolean bl2 = bl = objectArray.length == objectArray2.length;
        if (bl) {
            for (int i = 0; i < objectArray.length && bl; ++i) {
                bl = objectArray[i].equals(objectArray2[i]);
            }
        }
        return bl;
    }

    public static boolean sameMembers(Member[] memberArray, Member[] memberArray2) {
        AbsoluteOrder.absoluteOrder(memberArray);
        AbsoluteOrder.absoluteOrder(memberArray2);
        return Arrays.equals(memberArray, memberArray2);
    }

    public static Member[] merge(Member[] memberArray, Member[] memberArray2) {
        AbsoluteOrder.absoluteOrder(memberArray);
        AbsoluteOrder.absoluteOrder(memberArray2);
        ArrayList<Member> arrayList = new ArrayList<Member>(java.util.Arrays.asList(memberArray));
        for (Member member : memberArray2) {
            if (arrayList.contains(member)) continue;
            arrayList.add(member);
        }
        Member[] memberArray3 = new Member[arrayList.size()];
        arrayList.toArray(memberArray3);
        AbsoluteOrder.absoluteOrder(memberArray3);
        return memberArray3;
    }

    public static void fill(Membership membership, Member[] memberArray) {
        for (Member member : memberArray) {
            membership.addMember((MemberImpl)member);
        }
    }

    public static Member[] diff(Membership membership, Membership membership2, Member member) {
        MemberImpl[] memberImplArray;
        ArrayList<MemberImpl> arrayList = new ArrayList<MemberImpl>();
        for (MemberImpl memberImpl : memberImplArray = membership.getMembers()) {
            if (member != null && member.equals(memberImpl) || membership2.getMember(memberImpl) != null) continue;
            arrayList.add(memberImpl);
        }
        return arrayList.toArray(new MemberImpl[0]);
    }

    public static Member[] remove(Member[] memberArray, Member member) {
        return Arrays.extract(memberArray, new Member[]{member});
    }

    public static Member[] extract(Member[] memberArray, Member[] memberArray2) {
        List<Member> list = java.util.Arrays.asList(memberArray);
        ArrayList<Member> arrayList = new ArrayList<Member>(list);
        for (Member member : memberArray2) {
            arrayList.remove(member);
        }
        return arrayList.toArray(new Member[0]);
    }

    public static int indexOf(Member member, Member[] memberArray) {
        int n = -1;
        for (int i = 0; n == -1 && i < memberArray.length; ++i) {
            if (!member.equals(memberArray[i])) continue;
            n = i;
        }
        return n;
    }

    public static int nextIndex(Member member, Member[] memberArray) {
        int n = Arrays.indexOf(member, memberArray) + 1;
        if (n >= memberArray.length) {
            n = memberArray.length > 0 ? 0 : -1;
        }
        return n;
    }

    public static int hashCode(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = 1;
        for (byte by : byArray) {
            n = 31 * n + by;
        }
        return n;
    }

    public static byte[] fromString(String string) {
        if (string == null) {
            return null;
        }
        if (!string.startsWith("{")) {
            throw new RuntimeException("byte arrays must be represented as {1,3,4,5,6}");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{,}", false);
        byte[] byArray = new byte[stringTokenizer.countTokens()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = Byte.parseByte(stringTokenizer.nextToken());
        }
        return byArray;
    }

    public static byte[] convert(String string) {
        return string.getBytes(CHARSET_ISO_8859_1);
    }
}

