/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import org.apache.naming.resources.CacheEntry;

public class ResourceCache {
    protected Random random = new Random();
    protected CacheEntry[] cache = new CacheEntry[0];
    protected HashMap<String, CacheEntry> notFoundCache = new HashMap();
    protected int cacheMaxSize = 10240;
    protected int maxAllocateIterations = 20;
    protected long desiredEntryAccessRatio = 3L;
    protected int spareNotFoundEntries = 500;
    protected int cacheSize = 0;
    protected long accessCount = 0L;
    protected long hitsCount = 0L;

    public long getAccessCount() {
        return this.accessCount;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(int n) {
        this.cacheMaxSize = n;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    @Deprecated
    public long getDesiredEntryAccessRatio() {
        return this.desiredEntryAccessRatio;
    }

    @Deprecated
    public void setDesiredEntryAccessRatio(long l) {
        this.desiredEntryAccessRatio = l;
    }

    public long getHitsCount() {
        return this.hitsCount;
    }

    @Deprecated
    public int getMaxAllocateIterations() {
        return this.maxAllocateIterations;
    }

    @Deprecated
    public void setMaxAllocateIterations(int n) {
        this.maxAllocateIterations = n;
    }

    @Deprecated
    public int getSpareNotFoundEntries() {
        return this.spareNotFoundEntries;
    }

    @Deprecated
    public void setSpareNotFoundEntries(int n) {
        this.spareNotFoundEntries = n;
    }

    public boolean allocate(int n) {
        int n2;
        int n3 = n - (this.cacheMaxSize - this.cacheSize);
        if (n3 <= 0) {
            return true;
        }
        n3 += this.cacheMaxSize / 20;
        int n4 = this.notFoundCache.size();
        if (n4 > this.spareNotFoundEntries) {
            this.notFoundCache.clear();
            this.cacheSize -= n4;
            n3 -= n4;
        }
        if (n3 <= 0) {
            return true;
        }
        int n5 = 0;
        int n6 = 0;
        long l = 0L;
        int[] nArray = new int[this.maxAllocateIterations];
        while (n3 > 0) {
            if (n5 == this.maxAllocateIterations) {
                return false;
            }
            int n7 = -1;
            n2 = 0;
            while (n2 == 0) {
                n2 = 1;
                n7 = this.random.nextInt(this.cache.length);
                for (int i = 0; i < n6; ++i) {
                    if (nArray[i] != n7) continue;
                    n2 = 0;
                }
            }
            long l2 = this.cache[n7].accessCount * 100L / this.accessCount;
            if (l2 < this.desiredEntryAccessRatio) {
                nArray[n6] = n7;
                l += (long)this.cache[n7].size;
                n3 -= this.cache[n7].size;
                ++n6;
            }
            ++n5;
        }
        Arrays.sort(nArray, 0, n6);
        CacheEntry[] cacheEntryArray = new CacheEntry[this.cache.length - n6];
        n2 = 0;
        int n8 = -1;
        if (n6 > 0) {
            n8 = nArray[0];
            for (int i = 0; i < this.cache.length; ++i) {
                if (i == n8) {
                    if (n2 + 1 < n6) {
                        n8 = nArray[n2 + 1];
                        ++n2;
                        continue;
                    }
                    ++n2;
                    n8 = -1;
                    continue;
                }
                cacheEntryArray[i - n2] = this.cache[i];
            }
        }
        this.cache = cacheEntryArray;
        this.cacheSize = (int)((long)this.cacheSize - l);
        return true;
    }

    public CacheEntry lookup(String string) {
        CacheEntry cacheEntry = null;
        CacheEntry[] cacheEntryArray = this.cache;
        ++this.accessCount;
        int n = ResourceCache.find(cacheEntryArray, string);
        if (n != -1 && string.equals(cacheEntryArray[n].name)) {
            cacheEntry = cacheEntryArray[n];
        }
        if (cacheEntry == null) {
            try {
                cacheEntry = this.notFoundCache.get(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cacheEntry != null) {
            ++this.hitsCount;
        }
        return cacheEntry;
    }

    public void load(CacheEntry cacheEntry) {
        if (cacheEntry.exists) {
            if (this.insertCache(cacheEntry)) {
                this.cacheSize += cacheEntry.size;
            }
        } else {
            int n = this.notFoundCache.get(cacheEntry.name) == null ? 1 : 0;
            this.notFoundCache.put(cacheEntry.name, cacheEntry);
            this.cacheSize += n;
        }
    }

    public boolean unload(String string) {
        CacheEntry cacheEntry = this.removeCache(string);
        if (cacheEntry != null) {
            this.cacheSize -= cacheEntry.size;
            return true;
        }
        if (this.notFoundCache.remove(string) != null) {
            --this.cacheSize;
            return true;
        }
        return false;
    }

    private static final int find(CacheEntry[] cacheEntryArray, String string) {
        int n = 0;
        int n2 = cacheEntryArray.length - 1;
        if (n2 == -1) {
            return -1;
        }
        if (string.compareTo(cacheEntryArray[0].name) < 0) {
            return -1;
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        do {
            n3 = n2 + n >>> 1;
            int n4 = string.compareTo(cacheEntryArray[n3].name);
            if (n4 > 0) {
                n = n3;
                continue;
            }
            if (n4 == 0) {
                return n3;
            }
            n2 = n3;
        } while (n2 - n != 1);
        int n5 = string.compareTo(cacheEntryArray[n2].name);
        if (n5 < 0) {
            return n;
        }
        return n2;
    }

    private final boolean insertCache(CacheEntry cacheEntry) {
        CacheEntry[] cacheEntryArray = this.cache;
        int n = ResourceCache.find(cacheEntryArray, cacheEntry.name);
        if (n != -1 && cacheEntry.name.equals(cacheEntryArray[n].name)) {
            return false;
        }
        CacheEntry[] cacheEntryArray2 = new CacheEntry[this.cache.length + 1];
        System.arraycopy(cacheEntryArray, 0, cacheEntryArray2, 0, n + 1);
        cacheEntryArray2[n + 1] = cacheEntry;
        System.arraycopy(cacheEntryArray, n + 1, cacheEntryArray2, n + 2, cacheEntryArray.length - n - 1);
        this.cache = cacheEntryArray2;
        return true;
    }

    private final CacheEntry removeCache(String string) {
        CacheEntry[] cacheEntryArray = this.cache;
        int n = ResourceCache.find(cacheEntryArray, string);
        if (n != -1 && string.equals(cacheEntryArray[n].name)) {
            CacheEntry[] cacheEntryArray2 = new CacheEntry[this.cache.length - 1];
            System.arraycopy(cacheEntryArray, 0, cacheEntryArray2, 0, n);
            System.arraycopy(cacheEntryArray, n + 1, cacheEntryArray2, n, cacheEntryArray.length - n - 1);
            this.cache = cacheEntryArray2;
            return cacheEntryArray[n];
        }
        return null;
    }
}

