/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.nio.ByteBuffer;
import org.apache.tomcat.util.buf.ByteBufferUtils;

public class SocketBufferHandler {
    private volatile boolean readBufferConfiguredForWrite = true;
    private volatile ByteBuffer readBuffer;
    private volatile boolean writeBufferConfiguredForWrite = true;
    private volatile ByteBuffer writeBuffer;
    private final boolean direct;

    public SocketBufferHandler(int n, int n2, boolean bl) {
        this.direct = bl;
        if (bl) {
            this.readBuffer = ByteBuffer.allocateDirect(n);
            this.writeBuffer = ByteBuffer.allocateDirect(n2);
        } else {
            this.readBuffer = ByteBuffer.allocate(n);
            this.writeBuffer = ByteBuffer.allocate(n2);
        }
    }

    public void configureReadBufferForWrite() {
        this.setReadBufferConfiguredForWrite(true);
    }

    public void configureReadBufferForRead() {
        this.setReadBufferConfiguredForWrite(false);
    }

    private void setReadBufferConfiguredForWrite(boolean bl) {
        if (this.readBufferConfiguredForWrite != bl) {
            if (bl) {
                int n = this.readBuffer.remaining();
                if (n == 0) {
                    this.readBuffer.clear();
                } else {
                    this.readBuffer.compact();
                }
            } else {
                this.readBuffer.flip();
            }
            this.readBufferConfiguredForWrite = bl;
        }
    }

    public ByteBuffer getReadBuffer() {
        return this.readBuffer;
    }

    public boolean isReadBufferEmpty() {
        if (this.readBufferConfiguredForWrite) {
            return this.readBuffer.position() == 0;
        }
        return this.readBuffer.remaining() == 0;
    }

    public void configureWriteBufferForWrite() {
        this.setWriteBufferConfiguredForWrite(true);
    }

    public void configureWriteBufferForRead() {
        this.setWriteBufferConfiguredForWrite(false);
    }

    private void setWriteBufferConfiguredForWrite(boolean bl) {
        if (this.writeBufferConfiguredForWrite != bl) {
            if (bl) {
                int n = this.writeBuffer.remaining();
                if (n == 0) {
                    this.writeBuffer.clear();
                } else {
                    this.writeBuffer.compact();
                    this.writeBuffer.position(n);
                    this.writeBuffer.limit(this.writeBuffer.capacity());
                }
            } else {
                this.writeBuffer.flip();
            }
            this.writeBufferConfiguredForWrite = bl;
        }
    }

    public boolean isWriteBufferWritable() {
        if (this.writeBufferConfiguredForWrite) {
            return this.writeBuffer.hasRemaining();
        }
        return this.writeBuffer.remaining() == 0;
    }

    public ByteBuffer getWriteBuffer() {
        return this.writeBuffer;
    }

    public boolean isWriteBufferEmpty() {
        if (this.writeBufferConfiguredForWrite) {
            return this.writeBuffer.position() == 0;
        }
        return this.writeBuffer.remaining() == 0;
    }

    public void reset() {
        this.readBuffer.clear();
        this.readBufferConfiguredForWrite = true;
        this.writeBuffer.clear();
        this.writeBufferConfiguredForWrite = true;
    }

    public void expand(int n) {
        this.configureReadBufferForWrite();
        this.readBuffer = ByteBufferUtils.expand((ByteBuffer)this.readBuffer, (int)n);
        this.configureWriteBufferForWrite();
        this.writeBuffer = ByteBufferUtils.expand((ByteBuffer)this.writeBuffer, (int)n);
    }

    public void free() {
        if (this.direct) {
            ByteBufferUtils.cleanDirectBuffer((ByteBuffer)this.readBuffer);
            ByteBufferUtils.cleanDirectBuffer((ByteBuffer)this.writeBuffer);
        }
    }
}

