/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import org.jruby.EvalType;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.operands.Label;
import org.jruby.parser.StaticScope;
import org.jruby.util.ByteList;

public class IREvalScript
extends IRClosure {
    private String fileName;
    private static final ByteList EVAL = new ByteList(new byte[]{69, 86, 65, 76});

    public IREvalScript(IRManager manager, IRScope lexicalParent, String fileName, int lineNumber, StaticScope staticScope, EvalType evalType) {
        super(manager, lexicalParent, lineNumber, staticScope, 0, EVAL);
        this.fileName = fileName;
        if (!this.getManager().isDryRun() && staticScope != null) {
            if (evalType == EvalType.MODULE_EVAL) {
                staticScope.setScopeType(this.getScopeType());
            } else {
                IRScope s2 = lexicalParent;
                while (s2 instanceof IREvalScript) {
                    s2 = s2.getLexicalParent();
                }
                staticScope.setScopeType(s2.getScopeType());
            }
        }
    }

    @Override
    public int getNextClosureId() {
        ++this.nextClosureIndex;
        return this.nextClosureIndex;
    }

    @Override
    public Label getNewLabel() {
        return this.getNewLabel("EV" + this.closureId + "_LBL");
    }

    @Override
    public IRScopeType getScopeType() {
        return IRScopeType.EVAL_SCRIPT;
    }

    @Override
    public boolean isScriptScope() {
        return true;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getFile() {
        return this.fileName;
    }
}

