/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/UnderscoreUsageChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCallElement", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "checkSimpleNameUsage", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "ktName", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "isUnderscoreOnlyName", "", "", "frontend"})
public final class UnderscoreUsageChecker
implements CallChecker {
    @NotNull
    public static final UnderscoreUsageChecker INSTANCE = new UnderscoreUsageChecker();

    private UnderscoreUsageChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        DeclarationDescriptor declarationDescriptor;
        Object object;
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            return;
        }
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        ConstructorDescriptor constructorDescriptor = descriptor2 instanceof ConstructorDescriptor ? (ConstructorDescriptor)descriptor2 : null;
        Object object2 = object = constructorDescriptor == null ? null : constructorDescriptor.getContainingDeclaration();
        if (object == null) {
            Intrinsics.checkNotNullExpressionValue(descriptor2, "descriptor");
            declarationDescriptor = (DeclarationDescriptor)descriptor2;
        } else {
            declarationDescriptor = (DeclarationDescriptor)object;
        }
        DeclarationDescriptor namedDescriptor = declarationDescriptor;
        object = namedDescriptor.getName().asString();
        Intrinsics.checkNotNullExpressionValue(object, "namedDescriptor.name.asString()");
        if (!this.isUnderscoreOnlyName((String)object)) {
            return;
        }
        object = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue(object, "resolvedCall.call.callElement");
        this.checkCallElement((KtElement)object, context2);
    }

    private final void checkCallElement(KtElement ktElement, CallCheckerContext context2) {
        KtExpression ktExpression;
        KtElement ktElement2 = ktElement;
        if (ktElement2 instanceof KtSimpleNameExpression) {
            this.checkSimpleNameUsage((KtSimpleNameExpression)ktElement, context2.getTrace());
        } else if (ktElement2 instanceof KtCallExpression && (ktExpression = ((KtCallExpression)ktElement).getCalleeExpression()) != null) {
            KtExpression ktExpression2 = ktExpression;
            boolean bl = false;
            boolean bl2 = false;
            KtExpression it = ktExpression2;
            boolean bl3 = false;
            INSTANCE.checkCallElement(it, context2);
        }
    }

    private final void checkSimpleNameUsage(KtSimpleNameExpression ktName, BindingTrace trace) {
        String string2 = ktName.getText();
        Intrinsics.checkNotNullExpressionValue(string2, "ktName.text");
        if (this.isUnderscoreOnlyName(string2)) {
            trace.report(Errors.UNDERSCORE_USAGE_WITHOUT_BACKTICKS.on(ktName));
        }
    }

    public final void checkSimpleNameUsage(@NotNull DeclarationDescriptor descriptor2, @NotNull KtSimpleNameExpression ktName, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(ktName, "ktName");
        Intrinsics.checkNotNullParameter(trace, "trace");
        String string2 = descriptor2.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "descriptor.name.asString()");
        if (this.isUnderscoreOnlyName(string2)) {
            this.checkSimpleNameUsage(ktName, trace);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUnderscoreOnlyName(String $this$isUnderscoreOnlyName) {
        CharSequence charSequence = $this$isUnderscoreOnlyName;
        boolean bl = false;
        if (charSequence.length() <= 0) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        CharSequence $this$all$iv = $this$isUnderscoreOnlyName;
        boolean $i$f$all = false;
        CharSequence charSequence2 = $this$all$iv;
        int n = 0;
        while (n < charSequence2.length()) {
            char element$iv;
            char it = element$iv = charSequence2.charAt(n);
            boolean bl3 = false;
            if (it != '_') return false;
            boolean bl4 = true;
            if (!bl4) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

