/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.model;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.BrowserUtils;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.HeapWalkerFieldNode;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.HeapWalkerNode;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.PrimitiveArrayNode;

public class PrimitiveArrayFieldNode
extends PrimitiveArrayNode
implements HeapWalkerFieldNode {
    private ObjectFieldValue fieldValue;

    public PrimitiveArrayFieldNode(ObjectFieldValue fieldValue, HeapWalkerNode parent) {
        this(fieldValue, parent, parent == null ? 1 : parent.getMode());
    }

    public PrimitiveArrayFieldNode(ObjectFieldValue fieldValue, HeapWalkerNode parent, int mode) {
        super((PrimitiveArrayInstance)fieldValue.getInstance(), fieldValue.getField().getName(), parent, mode);
        this.fieldValue = fieldValue;
    }

    public ObjectFieldValue getFieldValue() {
        return this.fieldValue;
    }

    @Override
    public boolean isStatic() {
        return this.fieldValue.getField().isStatic();
    }

    @Override
    protected Icon computeIcon() {
        ImageIcon icon = BrowserUtils.ICON_ARRAY;
        if (this.isStatic()) {
            icon = BrowserUtils.createStaticIcon(icon);
        }
        return this.processLoopIcon(icon);
    }

    @Override
    public Object getNodeID() {
        return this.fieldValue;
    }
}

