/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.lib.jfluid.ProfilerLogger;
import org.graalvm.visualvm.lib.profiler.ProfilerTopComponent;
import org.graalvm.visualvm.lib.profiler.api.ProfilerIDESettings;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.profiler.heapwalk.HeapWalker;
import org.graalvm.visualvm.lib.profiler.heapwalk.HeapWalkerManager;
import org.graalvm.visualvm.lib.profiler.heapwalk.ui.Bundle;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class HeapWalkerUI
extends ProfilerTopComponent {
    private static final byte PERSISTENCE_VERSION_MAJOR = 8;
    private static final byte PERSISTENCE_VERSION_MINOR = 1;
    private static final String HELP_CTX_KEY = "HeapWalker.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("HeapWalker.HelpCtx");
    private HeapWalker heapWalker;

    public HeapWalkerUI() {
        this.setIcon(Icons.getImage((String)"ProfilerIcons.HeapDump"));
        this.getAccessibleContext().setAccessibleDescription(Bundle.HeapWalkerUI_ComponentDescr());
        this.setLayout(new BorderLayout());
    }

    public HeapWalkerUI(HeapWalker heapWalker) {
        this();
        this.initImpl(heapWalker);
    }

    private void initImpl(HeapWalker hw) {
        this.heapWalker = hw;
        this.initDefaults();
        this.initComponents();
    }

    protected Component defaultFocusOwner() {
        return this.heapWalker == null ? this : this.heapWalker.getMainHeapWalker().getPanel();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(8);
        out.writeByte(1);
        out.writeUTF(Utilities.toURI((File)this.heapWalker.getHeapDumpFile()).toString());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.add(new JLabel(Bundle.HeapWalkerUI_LoadingProgress(), 0), "Center");
            this.invalidate();
            this.doLayout();
            this.repaint();
            super.readExternal(in);
            in.readByte();
            in.readByte();
            URI uri = new URI(in.readUTF());
            final File file = Utilities.toFile((URI)uri);
            new RequestProcessor("HPROF loader for " + this.getName()).post(new Runnable(){

                @Override
                public void run() {
                    try {
                        final HeapWalker hw = new HeapWalker(file);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                HeapWalkerUI.this.removeAll();
                                HeapWalkerUI.this.initImpl(hw);
                            }
                        });
                    }
                    catch (Throwable t) {
                        HeapWalkerUI.this.handleReadThrowable(t);
                    }
                }
            });
        }
        catch (Throwable t) {
            this.handleReadThrowable(t);
        }
    }

    private void handleReadThrowable(Throwable t) {
        ProfilerLogger.info((String)("Restoring heap dump failed: " + t.getMessage()));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HeapWalkerUI.this.close();
            }
        });
    }

    public int getPersistenceType() {
        return ProfilerIDESettings.getInstance().getReopenHeapDumps() ? 1 : 2;
    }

    protected void componentClosed() {
        if (this.heapWalker == null) {
            return;
        }
        HeapWalkerManager.getDefault().heapWalkerClosed(this.heapWalker);
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    private void initComponents() {
        this.add(this.heapWalker.getMainHeapWalker().getPanel(), "Center");
        this.invalidate();
        this.doLayout();
        this.repaint();
    }

    private void initDefaults() {
        this.setName(this.heapWalker.getName());
        if (this.heapWalker.getHeapDumpFile() != null) {
            this.setToolTipText(this.heapWalker.getHeapDumpFile().getAbsolutePath());
        }
        File file = this.heapWalker.getHeapDumpFile();
        this.putClientProperty("nb.recent.file.path", file);
    }
}

