/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.scripting;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.netbeans.spi.scripting.EngineProvider;
import org.openide.util.Lookup;

public final class Scripting {
    private boolean allowAllAccess;

    private Scripting() {
    }

    public static ScriptEngineManager createManager() {
        return Scripting.newBuilder().build();
    }

    public static Scripting newBuilder() {
        return new Scripting();
    }

    public Scripting allowAllAccess(boolean bl) {
        this.allowAllAccess = bl;
        return this;
    }

    public ScriptEngineManager build() {
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = Scripting.class.getClassLoader();
        }
        return new EngineManager(this.allowAllAccess, classLoader);
    }

    private static final class EngineManager
    extends ScriptEngineManager {
        private final List<ScriptEngineFactory> extra;
        private final boolean allowAllAccess;
        private static final Class<?> nashornScriptEngineFactory;

        EngineManager(boolean bl, ClassLoader classLoader) {
            super(classLoader);
            this.allowAllAccess = bl;
            if (bl) {
                this.getBindings().put("allowAllAccess", (Object)true);
            }
            this.extra = EngineManager.populateExtras(this);
            for (ScriptEngineFactory scriptEngineFactory : this.extra) {
                this.registerEngineName(scriptEngineFactory.getEngineName(), scriptEngineFactory);
                for (String string : scriptEngineFactory.getExtensions()) {
                    this.registerEngineExtension(string, scriptEngineFactory);
                }
                for (String string : scriptEngineFactory.getMimeTypes()) {
                    this.registerEngineMimeType(string, scriptEngineFactory);
                }
            }
        }

        private static List<ScriptEngineFactory> populateExtras(EngineManager engineManager) {
            ArrayList<? extends ScriptEngineFactory> arrayList = new ArrayList<ScriptEngineFactory>();
            for (EngineProvider engineProvider : Lookup.getDefault().lookupAll(EngineProvider.class)) {
                arrayList.addAll(engineProvider.factories(engineManager));
            }
            return Collections.unmodifiableList(arrayList);
        }

        @Override
        public List<ScriptEngineFactory> getEngineFactories() {
            ArrayList<ScriptEngineFactory> arrayList = new ArrayList<ScriptEngineFactory>();
            arrayList.addAll(super.getEngineFactories());
            arrayList.addAll(this.extra);
            ListIterator<GraalJSWrapperFactory> listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                ScriptEngineFactory scriptEngineFactory = (ScriptEngineFactory)listIterator.next();
                if (!scriptEngineFactory.getNames().contains("Graal.js") && !this.isNashornFactory(scriptEngineFactory)) continue;
                listIterator.set(new GraalJSWrapperFactory(scriptEngineFactory));
            }
            return arrayList;
        }

        @Override
        public ScriptEngine getEngineByExtension(String string) {
            return this.postConfigure(super.getEngineByExtension(string));
        }

        @Override
        public ScriptEngine getEngineByMimeType(String string) {
            return this.postConfigure(super.getEngineByMimeType(string));
        }

        @Override
        public ScriptEngine getEngineByName(String string) {
            return this.postConfigure(super.getEngineByName(string));
        }

        private ScriptEngine postConfigure(ScriptEngine scriptEngine) {
            if (scriptEngine == null) {
                return null;
            }
            if (scriptEngine.getFactory().getNames().contains("Graal.js")) {
                Bindings bindings = scriptEngine.getBindings(100);
                if (this.allowAllAccess) {
                    bindings.put("polyglot.js.nashorn-compat", (Object)true);
                } else {
                    bindings.put("polyglot.js.allowHostAccess", (Object)true);
                }
                bindings.put("polyglot.js.allowHostClassLookup", string -> this.allowHostClassLookup(scriptEngine, (String)string));
            }
            if (this.isNashornFactory(scriptEngine.getFactory())) {
                return this.secureEngineEngine(scriptEngine);
            }
            return scriptEngine;
        }

        private boolean isNashornFactory(ScriptEngineFactory scriptEngineFactory) {
            return nashornScriptEngineFactory.isInstance(scriptEngineFactory);
        }

        private ScriptEngine secureEngineEngine(ScriptEngine scriptEngine) {
            ScriptEngine[] scriptEngineArray = new ScriptEngine[]{scriptEngine};
            try {
                ScriptEngineFactory scriptEngineFactory = scriptEngineArray[0].getFactory();
                Class<?> clazz = scriptEngineFactory.getClass();
                ClassLoader classLoader = clazz.getClassLoader();
                Class<?> clazz2 = Class.forName("jdk.nashorn.api.scripting.ClassFilter", true, classLoader);
                Method method2 = clazz.getMethod("getScriptEngine", clazz2);
                Object object2 = Proxy.newProxyInstance(classLoader, new Class[]{clazz2}, (object, method, objectArray) -> this.allowHostClassLookup(scriptEngineArray[0], (String)objectArray[0]));
                scriptEngineArray[0] = (ScriptEngine)method2.invoke((Object)scriptEngineFactory, object2);
                return scriptEngineArray[0];
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
                return scriptEngineArray[0];
            }
        }

        private boolean allowHostClassLookup(ScriptEngine scriptEngine, String string) {
            return this.allowAllAccess;
        }

        static {
            Class<Object> clazz;
            try {
                clazz = Class.forName("jdk.nashorn.api.scripting.NashornScriptEngineFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = String.class;
            }
            nashornScriptEngineFactory = clazz;
        }

        private final class GraalJSWrapperFactory
        implements ScriptEngineFactory {
            private final ScriptEngineFactory original;

            GraalJSWrapperFactory(ScriptEngineFactory scriptEngineFactory) {
                this.original = scriptEngineFactory;
            }

            @Override
            public String getEngineName() {
                return this.original.getEngineName();
            }

            @Override
            public String getEngineVersion() {
                return this.original.getEngineVersion();
            }

            @Override
            public List<String> getExtensions() {
                return this.original.getExtensions();
            }

            @Override
            public List<String> getMimeTypes() {
                return this.original.getMimeTypes();
            }

            @Override
            public List<String> getNames() {
                return this.original.getNames();
            }

            @Override
            public String getLanguageName() {
                return this.original.getLanguageName();
            }

            @Override
            public String getLanguageVersion() {
                return this.original.getLanguageVersion();
            }

            @Override
            public Object getParameter(String string) {
                return this.original.getParameter(string);
            }

            @Override
            public String getMethodCallSyntax(String string, String string2, String ... stringArray) {
                return this.original.getMethodCallSyntax(string, string2, stringArray);
            }

            @Override
            public String getOutputStatement(String string) {
                return this.original.getOutputStatement(string);
            }

            @Override
            public String getProgram(String ... stringArray) {
                return this.original.getProgram(stringArray);
            }

            @Override
            public ScriptEngine getScriptEngine() {
                return EngineManager.this.postConfigure(this.original.getScriptEngine());
            }
        }
    }
}

