/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.type;

import java.util.Scanner;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.type.ApplicationType;
import org.graalvm.visualvm.application.type.IntellijApplicationType;
import org.graalvm.visualvm.application.type.MainClassApplicationTypeFactory;

public class IntellijApplicationTypeFactory
extends MainClassApplicationTypeFactory {
    private static final String MAIN_CLASS = "com.intellij.idea.Main";
    private static final String PLATFORM_ID = "-Didea.paths.selector=";
    private static final String PLATFORM_PREFIX = "-Didea.platform.prefix=";
    private static final String IDEA_ID = "Idea";
    private static final String IDEA_CE = "IdeaIC";
    private static final String IDEA_ENT = "IntelliJIdea";
    private static final String PYCHARM_CE = "PyCharmCE";
    private static final String IDEA_NAME = "IntelliJ IDEA";
    private static final String IDEA_CE_NAME = "IntelliJ IDEA CE";
    private static final String IDEA_ENT_NAME = "IntelliJ IDEA";
    private static final String PYCHARM_CE_NAME = "PyCharm CE";
    private static final String PLATFORM_NAME = "IntelliJ Platform";

    @Override
    public ApplicationType createApplicationTypeFor(Application app, Jvm jvm, String mainClass) {
        String args;
        if (MAIN_CLASS.equals(mainClass)) {
            return new IntellijApplicationType(app, this.getName(jvm));
        }
        if ((mainClass == null || mainClass.length() == 0) && (args = jvm.getJvmArgs()) != null && args.contains(PLATFORM_ID)) {
            return new IntellijApplicationType(app, this.getName(jvm));
        }
        return null;
    }

    private String getName(Jvm jvm) {
        String jvmArgs = jvm.getJvmArgs();
        String name = this.getValue(jvmArgs, PLATFORM_PREFIX);
        String selector = this.getValue(jvmArgs, PLATFORM_ID);
        if (selector != null) {
            if (selector.startsWith(IDEA_CE)) {
                return IDEA_CE_NAME;
            }
            if (selector.startsWith(IDEA_ENT)) {
                return "IntelliJ IDEA";
            }
            if (selector.startsWith(PYCHARM_CE)) {
                return PYCHARM_CE_NAME;
            }
        }
        if (name != null) {
            return name;
        }
        selector = this.getValue(jvmArgs, PLATFORM_ID);
        if (selector != null && selector.startsWith(IDEA_ID)) {
            return "IntelliJ IDEA";
        }
        return PLATFORM_NAME;
    }

    private String getValue(String args, String key) {
        Scanner sc;
        if (args == null) {
            return null;
        }
        int index = args.indexOf(key);
        if (index >= 0 && (sc = new Scanner(args.substring(index + key.length()))).hasNext()) {
            return sc.next();
        }
        return null;
    }
}

