/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.graalvm.visualvm.core.options.UISupport;
import org.graalvm.visualvm.core.ui.components.SectionSeparator;
import org.graalvm.visualvm.heapviewer.options.Bundle;
import org.graalvm.visualvm.heapviewer.oql.OQLEditorComponent;
import org.graalvm.visualvm.lib.profiler.heapwalk.OQLSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;

final class HeapViewerOptionsPanel
extends JPanel {
    private boolean loaded;
    private final Model model = new Model();
    private boolean internalChange;
    private JPanel presetsPanel;
    private JList list;
    private JButton removeButton;
    private JButton upButton;
    private JButton downButton;
    private JTextField nameField;
    private JTextArea descrArea;
    private OQLEditorComponent previewArea;

    HeapViewerOptionsPanel() {
        this.initComponents();
    }

    void setQueries(List<OQLSupport.Query> queries) {
        this.model.clear();
        for (OQLSupport.Query query : queries) {
            this.model.addElement(query);
        }
        this.loaded = true;
        this.model.fireChange();
        if (this.model.isEmpty()) {
            this.updateSelection();
        } else {
            this.list.setSelectedIndex(0);
        }
    }

    List<OQLSupport.Query> getQueries() {
        Object[] queries = new OQLSupport.Query[this.model.size()];
        this.model.copyInto(queries);
        return Arrays.asList(queries);
    }

    private void updateSelection() {
        int selectedIndex;
        int n = selectedIndex = this.model.isEmpty() ? -1 : this.list.getSelectedIndex();
        if (selectedIndex == this.model.getSize()) {
            return;
        }
        this.removeButton.setEnabled(selectedIndex != -1);
        this.upButton.setEnabled(selectedIndex > 0);
        this.downButton.setEnabled(selectedIndex < this.model.getSize() - 1);
        this.refreshPreset(selectedIndex);
    }

    private void deleteQuery() {
        int selectedIndex = this.list.getSelectedIndex();
        this.model.remove(selectedIndex);
        if (this.model.getSize() > 0) {
            this.list.setSelectedIndex(selectedIndex == this.model.getSize() ? selectedIndex - 1 : selectedIndex);
        } else {
            this.updateSelection();
        }
        this.model.fireChange();
    }

    private void moveQueryUp() {
        int selectedIndex = this.list.getSelectedIndex();
        OQLSupport.Query query = (OQLSupport.Query)this.model.elementAt(selectedIndex);
        this.model.remove(selectedIndex);
        this.model.add(selectedIndex - 1, query);
        this.list.setSelectedIndex(selectedIndex - 1);
    }

    private void moveQueryDown() {
        int selectedIndex = this.list.getSelectedIndex();
        OQLSupport.Query query = (OQLSupport.Query)this.model.elementAt(selectedIndex);
        this.model.remove(selectedIndex);
        this.model.add(selectedIndex + 1, query);
        this.list.setSelectedIndex(selectedIndex + 1);
    }

    private void refreshPreset(int index) {
        OQLSupport.Query query = index == -1 ? null : (OQLSupport.Query)this.model.get(index);
        this.internalChange = true;
        this.nameField.setText(query == null ? "" : query.getName());
        try {
            this.nameField.setCaretPosition(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.descrArea.setText(query == null ? "" : query.getDescription());
        try {
            this.descrArea.setCaretPosition(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.previewArea.setScript(query == null ? "" : query.getScript());
        this.internalChange = false;
        this.presetsPanel.setEnabled(index != -1);
    }

    private void updatePreset() {
        OQLSupport.Query query;
        if (this.internalChange) {
            return;
        }
        int index = this.list.getSelectedIndex();
        OQLSupport.Query query2 = query = index == -1 ? null : (OQLSupport.Query)this.model.get(index);
        if (query == null) {
            return;
        }
        query.setName(this.uniqueName(this.nameField.getText().trim(), index));
        query.setDescription(this.descrArea.getText().trim());
        this.model.fireChange();
    }

    private String uniqueName(String name, int index) {
        if (name.isEmpty()) {
            name = Bundle.HeapViewerOptionsPanel_CustomScript();
        }
        String baseName = name;
        int nameExt = 0;
        while (this.containsQuery(name, index)) {
            name = baseName + " " + ++nameExt;
        }
        return name;
    }

    private boolean containsQuery(String name, int index) {
        for (int i = 0; i < this.model.size(); ++i) {
            if (i == index || !name.equals(((OQLSupport.Query)this.model.get(i)).getName())) continue;
            return true;
        }
        return false;
    }

    private void initComponents() {
        int mar;
        boolean nimbusLaF = org.graalvm.visualvm.uisupport.UISupport.isNimbusLookAndFeel();
        this.setLayout(new GridBagLayout());
        SectionSeparator presetsSection = UISupport.createSectionSeparator((String)Bundle.HeapViewerOptionsPanel_CustomScripts());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        this.add((Component)presetsSection, c);
        JPanel listPanel = new JPanel(new BorderLayout());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weighty = 0.5;
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(3, 15, 3, 0);
        this.add((Component)listPanel, c);
        this.list = new JList<OQLSupport.Query>(this.model);
        this.list.setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int index0, int index1) {
                super.setSelectionInterval(index0, index1);
                HeapViewerOptionsPanel.this.updateSelection();
            }

            @Override
            public void removeSelectionInterval(int i1, int i2) {
            }
        });
        this.list.setSelectionMode(0);
        final Dimension oneDim = new Dimension(1, 1);
        final JLabel loadingScriptsLabel = new JLabel(Bundle.HeapViewerOptionsPanel_LoadingScripts(), 0);
        loadingScriptsLabel.setEnabled(false);
        loadingScriptsLabel.setSize(loadingScriptsLabel.getPreferredSize());
        final JLabel noScriptsLabel = new JLabel(Bundle.HeapViewerOptionsPanel_NoSavedScripts(), 0);
        noScriptsLabel.setEnabled(false);
        noScriptsLabel.setSize(noScriptsLabel.getPreferredSize());
        JScrollPane listScroll = new JScrollPane(this.list){

            @Override
            public Dimension getPreferredSize() {
                return oneDim;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            protected void paintChildren(Graphics g) {
                super.paintChildren(g);
                if (HeapViewerOptionsPanel.this.model.isEmpty()) {
                    JLabel hint = HeapViewerOptionsPanel.this.loaded ? noScriptsLabel : loadingScriptsLabel;
                    int x = (this.getWidth() - hint.getWidth()) / 2;
                    int y = (this.getHeight() - hint.getHeight()) / 2;
                    g.translate(x, y);
                    hint.paint(g);
                    g.translate(-x, -y);
                }
            }
        };
        listPanel.add((Component)listScroll, "Center");
        this.removeButton = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                HeapViewerOptionsPanel.this.deleteQuery();
            }
        };
        this.removeButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/profiler/resources/remove.png", (boolean)true)));
        Insets margin = this.removeButton.getMargin();
        margin.left = mar = nimbusLaF ? 0 : 8;
        margin.right = mar;
        this.removeButton.setToolTipText(Bundle.HeapViewerOptionsPanel_DeleteScriptTooltip());
        this.removeButton.setMargin(margin);
        this.upButton = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                HeapViewerOptionsPanel.this.moveQueryUp();
            }
        };
        this.upButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/profiler/resources/up.png", (boolean)true)));
        this.upButton.setToolTipText(Bundle.HeapViewerOptionsPanel_MoveScriptUpTooltip());
        this.upButton.setMargin(margin);
        this.downButton = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                HeapViewerOptionsPanel.this.moveQueryDown();
            }
        };
        this.downButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/profiler/resources/down.png", (boolean)true)));
        this.downButton.setToolTipText(Bundle.HeapViewerOptionsPanel_MoveScriptDownTooltip());
        this.downButton.setMargin(margin);
        JPanel controlsPanel = new JPanel(new GridLayout(1, 4, 5, 0)){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                for (Component c : this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        };
        controlsPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        controlsPanel.add(this.removeButton);
        controlsPanel.add(new JPanel(null));
        controlsPanel.add(this.upButton);
        controlsPanel.add(this.downButton);
        listPanel.add((Component)controlsPanel, "South");
        this.presetsPanel = new JPanel(new GridBagLayout()){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                for (Component c : this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        };
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(3, 8, 3, 0);
        this.add((Component)this.presetsPanel, c);
        JLabel nameLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)nameLabel, (String)Bundle.HeapViewerOptionsPanel_NameLabel());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(3, 3, 3, 0);
        this.presetsPanel.add((Component)nameLabel, c);
        this.nameField = new JTextField(){

            @Override
            public void setBackground(Color bg) {
                super.setBackground(bg);
                if (HeapViewerOptionsPanel.this.descrArea != null) {
                    HeapViewerOptionsPanel.this.descrArea.setBackground(bg);
                }
            }
        };
        nameLabel.setLabelFor(this.nameField);
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                HeapViewerOptionsPanel.this.updatePreset();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                HeapViewerOptionsPanel.this.updatePreset();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                HeapViewerOptionsPanel.this.updatePreset();
            }
        });
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(3, 5, 3, 0);
        this.presetsPanel.add((Component)this.nameField, c);
        JLabel descrLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)descrLabel, (String)Bundle.HeapViewerOptionsPanel_DescriptionLabel());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(10, 3, 3, 0);
        this.presetsPanel.add((Component)descrLabel, c);
        this.descrArea = new JTextArea();
        descrLabel.setLabelFor(this.descrArea);
        this.descrArea.setLineWrap(true);
        this.descrArea.setWrapStyleWord(true);
        this.descrArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                HeapViewerOptionsPanel.this.updatePreset();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                HeapViewerOptionsPanel.this.updatePreset();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                HeapViewerOptionsPanel.this.updatePreset();
            }
        });
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 0.3;
        c.gridwidth = 0;
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(3, 5, 3, 0);
        JScrollPane descrScroll = new JScrollPane(this.descrArea){

            @Override
            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }

            @Override
            public void setEnabled(boolean b) {
                super.setEnabled(b);
                HeapViewerOptionsPanel.this.descrArea.setEnabled(b);
            }
        };
        this.presetsPanel.add((Component)descrScroll, c);
        JLabel previewLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)previewLabel, (String)Bundle.HeapViewerOptionsPanel_PreviewLabel());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(10, 3, 3, 0);
        this.presetsPanel.add((Component)previewLabel, c);
        this.previewArea = new OQLEditorComponent(null);
        this.previewArea.setEditable(false);
        previewLabel.setLabelFor(this.previewArea);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 4;
        c.weightx = 1.0;
        c.weighty = 0.7;
        c.gridwidth = 0;
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(3, 5, 3, 0);
        this.presetsPanel.add((Component)this.previewArea, c);
        JLabel hint = new JLabel(Bundle.HeapViewerOptionsPanel_HintLabel());
        hint.setEnabled(false);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(8, 15, 3, 0);
        this.add((Component)hint, c);
        this.updateSelection();
    }

    private class Model
    extends DefaultListModel<OQLSupport.Query> {
        private Model() {
        }

        void fireChange() {
            super.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }
}

