/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedReifiedParameterReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeTypeParameterInQualifiedAccess;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirTypeParameterInQualifiedAccessChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessChecker;", "()V", "coneTypeParameterInQualifiedAccess", "Lorg/jetbrains/kotlin/fir/resolve/diagnostics/ConeTypeParameterInQualifiedAccess;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "getConeTypeParameterInQualifiedAccess", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Lorg/jetbrains/kotlin/fir/resolve/diagnostics/ConeTypeParameterInQualifiedAccess;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkExplicitReceiver", "checkExpressionItself", "checkers"})
public final class FirTypeParameterInQualifiedAccessChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirTypeParameterInQualifiedAccessChecker INSTANCE = new FirTypeParameterInQualifiedAccessChecker();

    private FirTypeParameterInQualifiedAccessChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        this.checkExplicitReceiver(expression2, context2, reporter);
        this.checkExpressionItself(expression2, context2, reporter);
    }

    private final void checkExpressionItself(FirQualifiedAccessExpression expression2, CheckerContext context2, DiagnosticReporter reporter) {
        block6: {
            block5: {
                if (context2.getQualifiedAccesses().size() > 1) break block5;
                Collection collection = context2.getGetClassCalls();
                boolean bl = false;
                if (!(!collection.isEmpty())) break block6;
            }
            return;
        }
        ConeTypeParameterInQualifiedAccess coneTypeParameterInQualifiedAccess = this.getConeTypeParameterInQualifiedAccess(expression2.getTypeRef());
        if (coneTypeParameterInQualifiedAccess == null) {
            return;
        }
        ConeTypeParameterInQualifiedAccess diagnostic = coneTypeParameterInQualifiedAccess;
        FirSourceElement firSourceElement = expression2.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        DiagnosticReporterKt.reportOn(reporter, source, FirErrors.INSTANCE.getTYPE_PARAMETER_IS_NOT_AN_EXPRESSION(), diagnostic.getSymbol(), context2);
    }

    private final void checkExplicitReceiver(FirQualifiedAccessExpression expression2, CheckerContext context2, DiagnosticReporter reporter) {
        FirTypeParameterSymbol typeParameterSymbol;
        Object object;
        Object object2;
        FirExpression explicitReceiver = expression2.getExplicitReceiver();
        FirResolvedReifiedParameterReference firResolvedReifiedParameterReference = explicitReceiver instanceof FirResolvedReifiedParameterReference ? (FirResolvedReifiedParameterReference)explicitReceiver : null;
        Object object3 = object2 = firResolvedReifiedParameterReference == null ? null : firResolvedReifiedParameterReference.getSymbol();
        if (object2 == null) {
            FirTypeRef firTypeRef;
            Object object4 = explicitReceiver;
            FirTypeRef firTypeRef2 = firTypeRef = object4 == null ? null : ((FirExpression)object4).getTypeRef();
            Object object5 = firTypeRef == null ? null : (firResolvedReifiedParameterReference = (object4 = this.getConeTypeParameterInQualifiedAccess(firTypeRef)) == null ? null : ((ConeTypeParameterInQualifiedAccess)object4).getSymbol());
            if (firResolvedReifiedParameterReference == null) {
                return;
            }
            object = firResolvedReifiedParameterReference;
        } else {
            object = typeParameterSymbol = object2;
        }
        if (expression2 instanceof FirCallableReferenceAccess) {
            DiagnosticReporterKt.reportOn(reporter, expression2.getSource(), FirErrors.INSTANCE.getCALLABLE_REFERENCE_LHS_NOT_A_CLASS(), context2);
        } else {
            object2 = explicitReceiver;
            DiagnosticReporterKt.reportOn(reporter, object2 == null ? null : ((FirExpression)object2).getSource(), FirErrors.INSTANCE.getTYPE_PARAMETER_ON_LHS_OF_DOT(), typeParameterSymbol, context2);
        }
    }

    private final ConeTypeParameterInQualifiedAccess getConeTypeParameterInQualifiedAccess(FirTypeRef $this$coneTypeParameterInQualifiedAccess) {
        FirErrorTypeRef firErrorTypeRef = $this$coneTypeParameterInQualifiedAccess instanceof FirErrorTypeRef ? (FirErrorTypeRef)$this$coneTypeParameterInQualifiedAccess : null;
        ConeDiagnostic coneDiagnostic = firErrorTypeRef == null ? null : firErrorTypeRef.getDiagnostic();
        return coneDiagnostic instanceof ConeTypeParameterInQualifiedAccess ? (ConeTypeParameterInQualifiedAccess)coneDiagnostic : null;
    }
}

