/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsDynamicScope;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"renameLabels", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "js.translator"})
public final class RenameLabelsKt {
    public static final void renameLabels(@NotNull JsNode root2) {
        Intrinsics.checkNotNullParameter(root2, "root");
        root2.accept(new RecursiveJsVisitor(){
            @NotNull
            private final Map<JsName, JsName> replacements;
            @NotNull
            private Set<String> labels;
            {
                boolean bl = false;
                this.replacements = new LinkedHashMap<K, V>();
                bl = false;
                this.labels = new LinkedHashSet<E>();
            }

            @NotNull
            public final Map<JsName, JsName> getReplacements() {
                return this.replacements;
            }

            @NotNull
            public final Set<String> getLabels() {
                return this.labels;
            }

            public final void setLabels(@NotNull Set<String> set) {
                Intrinsics.checkNotNullParameter(set, "<set-?>");
                this.labels = set;
            }

            protected void visitElement(@NotNull JsNode node) {
                JsName jsName;
                JsName name;
                Intrinsics.checkNotNullParameter(node, "node");
                super.visitElement(node);
                if (node instanceof HasName && (name = ((HasName)((Object)node)).getName()) != null && (jsName = this.replacements.get(name)) != null) {
                    JsName jsName2 = jsName;
                    boolean bl = false;
                    boolean bl2 = false;
                    JsName it = jsName2;
                    boolean bl3 = false;
                    ((HasName)((Object)node)).setName(it);
                }
            }

            public void visitLabel(@NotNull JsLabel x) {
                Intrinsics.checkNotNullParameter(x, "x");
                String addedName = null;
                if (x.getName().isTemporary()) {
                    String string2 = x.getName().getIdent();
                    Intrinsics.checkNotNullExpressionValue(string2, "x.name.ident");
                    String resolvedName = string2;
                    int suffix = 0;
                    while (!this.labels.add(resolvedName)) {
                        int n = suffix;
                        suffix = n + 1;
                        resolvedName = x.getName().getIdent() + '_' + n;
                    }
                    Map<JsName, JsName> map = this.replacements;
                    JsName jsName = x.getName();
                    Intrinsics.checkNotNullExpressionValue(jsName, "x.name");
                    JsName jsName2 = JsDynamicScope.INSTANCE.declareName(resolvedName);
                    Intrinsics.checkNotNullExpressionValue(jsName2, "JsDynamicScope.declareName(resolvedName)");
                    boolean bl = false;
                    map.put(jsName, jsName2);
                    addedName = resolvedName;
                }
                super.visitLabel(x);
                String string3 = addedName;
                if (string3 != null) {
                    String string4 = string3;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string4;
                    boolean bl3 = false;
                    this.getLabels().remove(it);
                }
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkNotNullParameter(x, "x");
                Set<String> oldLabels = this.labels;
                boolean bl = false;
                this.labels = new LinkedHashSet<E>();
                super.visitFunction(x);
                this.labels = oldLabels;
            }
        });
    }
}

