/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.NamingEntry;
import org.apache.naming.resources.FileDirContext;

public class VirtualDirContext
extends FileDirContext {
    private static final Log log = LogFactory.getLog(VirtualDirContext.class);
    private String extraResourcePaths = "";
    private Map<String, List<String>> mappedResourcePaths;

    public void setExtraResourcePaths(String string) {
        this.extraResourcePaths = string;
    }

    @Override
    public void allocate() {
        super.allocate();
        this.mappedResourcePaths = new HashMap<String, List<String>>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.extraResourcePaths, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string;
            String string2 = stringTokenizer.nextToken();
            if (string2.length() <= 0) continue;
            int n = string2.indexOf(61);
            if (n <= 0) {
                string = "";
            } else {
                if (string2.startsWith("/=")) {
                    string2 = string2.substring(1);
                    --n;
                }
                string = string2.substring(0, n);
            }
            File file = new File(string2.substring(n + 1));
            List<String> list = this.mappedResourcePaths.get(string);
            if (list == null) {
                list = new ArrayList<String>();
                this.mappedResourcePaths.put(string, list);
            }
            try {
                list.add(file.getCanonicalPath());
            }
            catch (IOException iOException) {
                log.warn((Object)sm.getString("fileResources.canonical.fail", file.getPath()));
                list.add(file.getAbsolutePath());
            }
        }
        if (this.mappedResourcePaths.isEmpty()) {
            this.mappedResourcePaths = null;
        }
    }

    @Override
    public void release() {
        this.mappedResourcePaths = null;
        super.release();
    }

    @Override
    public Attributes getAttributes(String string) throws NamingException {
        try {
            Attributes attributes = super.getAttributes(string);
            return attributes;
        }
        catch (NamingException namingException) {
            NamingException namingException2 = namingException;
            if (this.mappedResourcePaths != null) {
                for (Map.Entry<String, List<String>> entry : this.mappedResourcePaths.entrySet()) {
                    Object object;
                    String string2 = entry.getKey();
                    List<String> list = entry.getValue();
                    String string3 = list.get(0);
                    if (string.equals(string2)) {
                        object = new File(string3);
                        if ((object = this.validate((File)object, string, true, string3)) != null) {
                            return new FileDirContext.FileResourceAttributes((File)object);
                        }
                    }
                    if (!string.startsWith(string2 = string2 + "/")) continue;
                    object = string.substring(string2.length());
                    File file = new File(string3, (String)object);
                    if ((file = this.validate(file, (String)object, true, string3)) == null) continue;
                    return new FileDirContext.FileResourceAttributes(file);
                }
            }
            throw namingException2;
        }
    }

    @Override
    protected File file(String string) {
        return this.file(string, true);
    }

    @Override
    protected File file(String string, boolean bl) {
        File file = super.file(string, true);
        if (file != null || this.mappedResourcePaths == null) {
            return file;
        }
        if (string.length() > 0 && string.charAt(0) != '/') {
            string = "/" + string;
        }
        for (Map.Entry<String, List<String>> entry : this.mappedResourcePaths.entrySet()) {
            String string2 = entry.getKey();
            List<String> list = entry.getValue();
            if (string.equals(string2)) {
                for (String string3 : list) {
                    file = new File(string3);
                    if ((file = this.validate(file, string, true, string3)) == null) continue;
                    return file;
                }
            }
            if (!string.startsWith(string2 = string2 + "/")) continue;
            String string3 = string.substring(string2.length());
            for (String string4 : list) {
                file = new File(string4, string3);
                if ((file = this.validate(file, string3, true, string4)) == null) continue;
                return file;
            }
        }
        return null;
    }

    @Override
    protected List<NamingEntry> list(File file) {
        List<NamingEntry> list = super.list(file);
        if (this.mappedResourcePaths != null && !this.mappedResourcePaths.isEmpty()) {
            HashSet<String> hashSet = new HashSet<String>(list.size());
            for (NamingEntry object : list) {
                hashSet.add(object.name);
            }
            String string = file.getAbsolutePath();
            if (string.startsWith(this.getDocBase() + File.separator)) {
                String string2 = string.substring(this.getDocBase().length());
                String string3 = string2.replace(File.separatorChar, '/');
                for (Map.Entry<String, List<String>> entry : this.mappedResourcePaths.entrySet()) {
                    String string4 = entry.getKey();
                    List<String> list2 = entry.getValue();
                    String string5 = null;
                    if (string3.equals(string4)) {
                        string5 = "";
                    } else if (string3.startsWith(string4 + "/")) {
                        string5 = string2.substring(string4.length());
                    }
                    if (string5 == null) continue;
                    for (String string6 : list2) {
                        File file2 = new File(string6, string5);
                        if ((file2 = this.validate(file2, string5, true, string6)) == null || !file2.isDirectory()) continue;
                        List<NamingEntry> list3 = super.list(file2);
                        for (NamingEntry namingEntry : list3) {
                            if (hashSet.contains(namingEntry.name)) continue;
                            hashSet.add(namingEntry.name);
                            list.add(namingEntry);
                        }
                    }
                }
            }
        }
        return list;
    }

    @Override
    protected Object doLookup(String string) {
        Object object = super.doLookup(string);
        if (object != null || this.mappedResourcePaths == null) {
            return object;
        }
        for (Map.Entry<String, List<String>> entry : this.mappedResourcePaths.entrySet()) {
            String string2 = entry.getKey();
            List<String> list = entry.getValue();
            if (string.equals(string2)) {
                for (String string3 : list) {
                    Object object2 = new File(string3);
                    if ((object2 = this.validate((File)object2, string, true, string3)) == null || !((File)object2).isFile()) continue;
                    return new FileDirContext.FileResource((File)object2);
                }
            }
            if (!string.startsWith(string2 = string2 + "/")) continue;
            String string3 = string.substring(string2.length());
            for (Object object2 : list) {
                File file = new File((String)object2, string3);
                if ((file = this.validate(file, string3, true, (String)object2)) == null || !file.isFile()) continue;
                return new FileDirContext.FileResource(file);
            }
        }
        return object;
    }

    @Override
    protected String doGetRealPath(String string) {
        File file = this.file(string);
        if (null != file) {
            return file.getAbsolutePath();
        }
        return null;
    }

    protected File validate(File file, String string, boolean bl, String string2) {
        return this.validate(file, string, bl, this.normalize(string2), string2);
    }
}

