#!/usr/bin/perl

$modLog = "/tmp/modprobe.log";
$modErr = "/tmp/modprobe.err";
$cdMntLog = "/tmp/cdMount.log";
$cdMntErr = "/tmp/cdMount.err";

#######################
### Loading rtc & agpgart modules...
######
system "modprobe -s rtc     >> $modLog 2>> $modErr";
system "modprobe -s apm     >> $modLog 2>> $modErr";
system "modprobe -s agpgart >> $modLog 2>> $modErr";

# load the OSS emulation module for systems that don't work with alsa
system "modprobe -s snd-pcm-oss >> $modLog 2>> $modErr";
system "modprobe -s supermount >> $modLog 2>> $modErr";

system "rm -f /root/.mplayer/mp_pipe ; mkfifo /root/.mplayer/mp_pipe";

#######################
### Loading the libdvdcss lib if found...
######
foreach( `ls /tmp/libdvdcss*` ){
  chop;
  `rpm2cpio $_ > /tmp/libdvdcss.cpio`;
  `cd /tmp ; cpio -i -u -d -F libdvdcss.cpio`;
  `cd /lib ; ln -s /tmp/usr/lib/libdvdcss* .`;
  last;
}

########################################
### Collecting info on your CD/DVD drive(s)
### We need the CD/DVD devices in lexical order, so we first
### make a note of all IDE devices available...
#############
foreach (`ls -l /dev/hd?`){
  m|/dev/hd(\w) -> .*/cd$| or next;
  my $model = `cat /proc/ide/hd$1/model`;
  chop $model;
  $model = truncateTo(16,$model);
  push @cdDrives, $model;
  my $i = $#cdDrives;
  `hdparm -d1 -a8 /dev/cdroms/cdrom$i >> $cdMountLog 2>> $cdMountErr` unless $ENV{"DMA"} =~ /^n/i;
}
########################################
### Collecting info on your SCSI CD/DVD drive(s)
### should be ordered based on scsi id
### WARNING! this assumes that IDE drivers are
### always before SCSI drives in /dev/cdrom/cdroms[0-i]
#############
my($host,$bus,$id,$lun,$model,$modelList);
foreach (`cat /proc/scsi/scsi`){
  if( /^Host: scsi(\d+) Channel: (\d\d) Id: (\d\d) Lun: (\d\d)$/ ){
    $host = $1;
    $bus  = $2;
    $id   = $3;
    $lun  = $4;
  }
  $modelList->{$host}{$bus}{$id}{$lun}= "$1 $2"
    if /^  Vendor: (.+)\s+Model: (.+)\s+Rev/;
}
foreach (`ls -l /dev/cdroms/`){
  m|scsi/host(\d+)/bus(\d+)/target(\d+)/lun(\d+)/cd$| or next;
  $host = $1;
  $bus  = $2 < 10 ? "0$2" : $2;
  $id   = $3 < 10 ? "0$3" : $3;
  $lun  = $4 < 10 ? "0$4" : $4;
  $model = $modelList->{$host}{$bus}{$id}{$lun};
  $model = truncateTo(16,$model);
  push @cdDrives, $model;
  my $i = $#cdDrives;
  `hdparm -d1 -a8 /dev/cdroms/cdrom$i >> $cdMountLog 2>> $cdMountErr` unless $ENV{"DMA"} =~ /^n/i;
}
`ln -s /usr/bin/movix /usr/bin/playcd0`;
###                                                          ###
# Now we modify the MPlayer menu if more than a drive is found #
###                                                          ###
if( @cdDrives > 1 ){
  my $pls = "";
  my $acd_pls = "";
  my $vcd_pls = "";
  my $dvd_pls = "";
  for ( my $i=0; $i < @cdDrives; $i++ ) {
    $pls     .= "\t<e name=\"" . truncateTo(20,$cdDrives[$i]) . "\" ok=\"run playcd$i\"/>\n";
    $acd_pls .= "\t<e name=\"" . truncateTo(20,$cdDrives[$i]) . "\" ok=\"run playacd$i\"/>\n";
    $vcd_pls .= "\t<e name=\"" . truncateTo(20,$cdDrives[$i]) . "\" ok=\"run playvcd$i\"/>\n";
    $dvd_pls .= "\t<e name=\"" . truncateTo(20,$cdDrives[$i]) . "\" ok=\"run playdvd$i\"/>\n";
    `ln -s /usr/bin/movix /usr/bin/playcd$i`;
    `ln -s /usr/bin/movix /usr/bin/playacd$i`;
    `ln -s /usr/bin/movix /usr/bin/playvcd$i`;
    `ln -s /usr/bin/movix /usr/bin/playdvd$i`;
  }
  chop $pls;
  chop $acd_pls;
  chop $vcd_pls;
  chop $dvd_pls;
  my $menu = `cat /root/.mplayer/menu.conf`;
  $menu =~ s/\" ok=\"run playcd/ ...\" ok=\"set_menu drives/;
  $menu =~ s/(<cmdlist name=\"drives\" title=\".+\" ptr=\"<>\">)/$1\n$pls/;
  $menu =~ s/\" ok=\"run playacd/ ...\" ok=\"set_menu acd_drives/;
  $menu =~ s/(<cmdlist name=\"acd_drives\" title=\".+\" ptr=\"<>\">)/$1\n$acd_pls/;
  $menu =~ s/\" ok=\"run playvcd/ ...\" ok=\"set_menu vcd_drives/;
  $menu =~ s/(<cmdlist name=\"vcd_drives\" title=\".+\" ptr=\"<>\">)/$1\n$vcd_pls/;
  $menu =~ s/\" ok=\"run playdvd/ ...\" ok=\"set_menu dvd_drives/;
  $menu =~ s/(<cmdlist name=\"dvd_drives\" title=\".+\" ptr=\"<>\">)/$1\n$dvd_pls/;
  open MENU, "> /root/.mplayer/menu.conf";
  print MENU $menu;
  close MENU;
} else {
  `ln -s /dev/cdroms/cdrom0 /dev/cdrom`;
  `ln -s /dev/cdroms/cdrom0 /dev/dvd`;
  `ln -s /usr/bin/movix /usr/bin/playcd`;
  `ln -s /usr/bin/movix /usr/bin/playacd`;
  `ln -s /usr/bin/movix /usr/bin/playvcd`;
  `ln -s /usr/bin/movix /usr/bin/playdvd`;
}

sub truncateTo {
  my $n      = shift;
  my $string = shift;
  $string =~ /^(.{1,$n})/;
  return $1;
}
