/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;

public class PDFNameTreeNode
extends PDFDictionary {
    private static final String KIDS = "Kids";
    private static final String NAMES = "Names";
    private static final String LIMITS = "Limits";

    public void setKids(PDFArray kids) {
        this.put(KIDS, kids);
    }

    public PDFArray getKids() {
        return (PDFArray)this.get(KIDS);
    }

    public void setNames(PDFArray names) {
        this.put(NAMES, names);
    }

    public PDFArray getNames() {
        return (PDFArray)this.get(NAMES);
    }

    public void setLowerLimit(String key) {
        PDFArray limits = this.prepareLimitsArray();
        limits.set(0, key);
    }

    public String getLowerLimit() {
        PDFArray limits = this.prepareLimitsArray();
        return (String)limits.get(0);
    }

    public void setUpperLimit(String key) {
        PDFArray limits = this.prepareLimitsArray();
        limits.set(1, key);
    }

    public String getUpperLimit() {
        PDFArray limits = this.prepareLimitsArray();
        return (String)limits.get(1);
    }

    private PDFArray prepareLimitsArray() {
        PDFArray limits = (PDFArray)this.get(LIMITS);
        if (limits == null) {
            limits = new PDFArray(new Object[2]);
            this.put(LIMITS, limits);
        }
        if (limits.length() != 2) {
            throw new IllegalStateException("Limits array must have 2 entries");
        }
        return limits;
    }
}

