/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.impl;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.snapshot.SnapshotCategory;
import org.graalvm.visualvm.core.ui.DataSourceWindowManager;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.impl.JFRSnapshotImpl;
import org.openide.util.NbBundle;

public class JFRSnapshotCategory
extends SnapshotCategory<JFRSnapshot> {
    private static final Logger LOGGER = Logger.getLogger(JFRSnapshotCategory.class.getName());
    private static final String NAME = NbBundle.getMessage(JFRSnapshotCategory.class, (String)"LBL_Core_Dumps");
    private static final String PREFIX = null;
    private static final String SUFFIX = ".jfr";

    public JFRSnapshotCategory() {
        super(NAME, JFRSnapshot.class, PREFIX, SUFFIX, Integer.MIN_VALUE);
    }

    public boolean supportsOpenSnapshot() {
        return true;
    }

    public void openSnapshot(File file) {
        try {
            JFRSnapshotImpl snapshot = new JFRSnapshotImpl(file);
            DataSourceWindowManager.sharedInstance().openDataSource((DataSource)snapshot);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Error opening JFR snapshot", ex);
        }
    }
}

