/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.core.multitabs.Settings;
import org.netbeans.core.multitabs.impl.ProjectSupport;
import org.netbeans.core.multitabs.impl.SingleRowTabTable;
import org.netbeans.core.multitabs.impl.TabDataRenderer;
import org.netbeans.core.multitabs.impl.TabTable;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;

abstract class TabLayoutManager {
    protected final List<SingleRowTabTable> rows;
    protected final Container container;
    protected final TabDataModel tabModel;
    private final Timer layoutTimer;

    public static TabLayoutManager create(List<SingleRowTabTable> list, Container container, TabDataModel tabDataModel) {
        if (Settings.getDefault().isTabRowPerProject()) {
            return new RowPerProjectTabLayoutManager(list, container, tabDataModel);
        }
        return new FlowTabLayoutManager(list, container, tabDataModel);
    }

    protected TabLayoutManager(List<SingleRowTabTable> list, Container container, TabDataModel tabDataModel) {
        this.rows = list;
        this.container = container;
        this.tabModel = tabDataModel;
        this.layoutTimer = new Timer(350, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabLayoutManager.this.doLayout();
            }
        });
        this.layoutTimer.setRepeats(false);
    }

    Rectangle getTabBounds(int n) {
        TabData tabData = this.tabModel.getTab(n);
        if (null == tabData) {
            return null;
        }
        for (SingleRowTabTable singleRowTabTable : this.rows) {
            if (!singleRowTabTable.hasTabIndex(n)) continue;
            Rectangle rectangle = singleRowTabTable.getTabBounds(n);
            if (null != rectangle) {
                rectangle = SwingUtilities.convertRectangle(singleRowTabTable, rectangle, this.container);
            }
            return rectangle;
        }
        return null;
    }

    TabData getTabAt(Point point) {
        for (TabTable tabTable : this.rows) {
            Point point2;
            if (!tabTable.contains(point2 = SwingUtilities.convertPoint(this.container, point, tabTable))) continue;
            return tabTable.getTabAt(point2);
        }
        return null;
    }

    final void resizeContainer() {
        JComponent jComponent = (JComponent)this.container.getParent();
        jComponent.invalidate();
        jComponent.revalidate();
        jComponent.doLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void invalidate() {
        Timer timer = this.layoutTimer;
        synchronized (timer) {
            if (this.layoutTimer.isRunning()) {
                this.layoutTimer.restart();
                return;
            }
            this.layoutTimer.start();
        }
    }

    protected abstract void doLayout();

    private static class RowPerProjectTabLayoutManager
    extends TabLayoutManager {
        public RowPerProjectTabLayoutManager(List<SingleRowTabTable> list, Container container, TabDataModel tabDataModel) {
            super(list, container, tabDataModel);
        }

        @Override
        protected void doLayout() {
            int n;
            if (this.rows.isEmpty()) {
                return;
            }
            ProjectSupport projectSupport = ProjectSupport.getDefault();
            List<ProjectSupport.ProjectProxy> list = Arrays.asList(projectSupport.getOpenProjects());
            int n2 = this.tabModel.size();
            int n3 = this.rows.size();
            ArrayList[] arrayListArray = new ArrayList[n3];
            for (n = 0; n < n3; ++n) {
                arrayListArray[n] = new ArrayList(n2);
            }
            for (n = 0; n < n2; ++n) {
                TabData tabData = this.tabModel.getTab(n);
                ProjectSupport.ProjectProxy projectProxy = projectSupport.getProjectForTab(tabData);
                int n4 = list.indexOf(projectProxy);
                n4 = n4 < 0 || n4 >= arrayListArray.length - 1 || n3 == 1 ? 0 : ++n4;
                arrayListArray[n4].add(n);
            }
            for (n = 0; n < n3; ++n) {
                ((SingleRowTabTable)this.rows.get(n)).setTabs(arrayListArray[n]);
            }
            this.resizeContainer();
        }
    }

    private static class FlowTabLayoutManager
    extends TabLayoutManager {
        private final TabDataRenderer renderer = new TabDataRenderer();
        private final int columnPadding;

        FlowTabLayoutManager(List<SingleRowTabTable> list, Container container, TabDataModel tabDataModel) {
            super(list, container, tabDataModel);
            this.columnPadding = new JTable().getIntercellSpacing().width;
            container.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    this.invalidate();
                }

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                }

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                }

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                }
            });
        }

        @Override
        protected void doLayout() {
            int n;
            int n2;
            int n3 = this.rows.size();
            int n4 = this.container.getWidth();
            int n5 = 0;
            int[] nArray = new int[n3];
            int[] nArray2 = new int[n3];
            Arrays.fill(nArray2, -1);
            int n6 = this.tabModel.size();
            int[] nArray3 = new int[n6];
            for (n2 = 0; n2 < n6; ++n2) {
                TabData tabData = this.tabModel.getTab(n2);
                nArray3[n2] = n = this.renderer.getPreferredWidth(tabData) + this.columnPadding;
            }
            n2 = 0;
            while (n2 < n6) {
                int n7 = nArray3[n2];
                if (n7 + nArray[n5] <= n4 || n7 > n4) {
                    nArray2[n5] = n2++;
                    int n8 = n5;
                    nArray[n8] = nArray[n8] + n7;
                    continue;
                }
                if (++n5 < n3) continue;
                break;
            }
            if (n2 < n6) {
                n5 = 0;
                while (true) {
                    int n9;
                    int n10 = n5;
                    nArray2[n10] = nArray2[n10] + 1;
                    int n11 = n5;
                    nArray[n11] = nArray[n11] + nArray3[nArray2[n5]];
                    n4 = Math.max(n4, nArray[n5]);
                    for (n9 = n5 + 1; n9 < n3; ++n9) {
                        nArray2[n9] = -1;
                        nArray[n9] = 0;
                    }
                    n2 = nArray2[n5] + 1;
                    n9 = n5 + 1;
                    while (n2 < n6) {
                        n = nArray3[n2];
                        if (n + nArray[n9] <= n4 || n > n4) {
                            nArray2[n9] = n2++;
                            int n12 = n9;
                            nArray[n12] = nArray[n12] + n;
                            continue;
                        }
                        if (++n9 < n3) continue;
                        break;
                    }
                    if (n2 >= n6) break;
                    if (++n5 < n3 - 1) continue;
                    n5 = 0;
                }
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n6);
            n = -1;
            for (int i = 0; i < nArray2.length; ++i) {
                arrayList.clear();
                for (int j = n + 1; j <= nArray2[i]; ++j) {
                    arrayList.add(j);
                }
                ((SingleRowTabTable)this.rows.get(i)).setTabs(arrayList);
                n = nArray2[i];
            }
            this.resizeContainer();
        }
    }
}

