/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.nodes;

import org.graalvm.visualvm.heapviewer.java.StackFrameNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.Bundle;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.MultiRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NormalBoldGrayRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;

public class TruffleStackFrameNode
extends StackFrameNode {
    public TruffleStackFrameNode(String name, HeapViewerNode[] children) {
        super(name, children);
    }

    static class Renderer
    extends MultiRenderer
    implements HeapViewerRenderer {
        private final LabelRenderer atRenderer = new LabelRenderer(){

            public String toString() {
                return this.getText() + " ";
            }
        };
        private final NormalBoldGrayRenderer frameRenderer;
        private final ProfilerRenderer[] renderers;
        private String name1;
        private String name2;
        private String detail;

        public Renderer() {
            this.atRenderer.setText("at");
            this.atRenderer.setMargin(3, 3, 3, 0);
            this.frameRenderer = new NormalBoldGrayRenderer(){

                public void setValue(Object value, int row) {
                    if (value == null) {
                        this.setNormalValue("");
                        this.setBoldValue("");
                        this.setGrayValue("");
                    } else {
                        this.setNormalValue(((Object[])value)[0].toString());
                        this.setBoldValue(((Object[])value)[1].toString());
                        this.setGrayValue(((Object[])value)[2].toString());
                    }
                }
            };
            this.renderers = new ProfilerRenderer[]{this.atRenderer, this.frameRenderer};
        }

        protected ProfilerRenderer[] valueRenderers() {
            return this.renderers;
        }

        public void setValue(Object value, int row) {
            if (value == null) {
                this.name1 = "";
                this.name2 = Bundle.TruffleStackFrameNode_Unknown();
                this.detail = "";
            } else {
                String val = value.toString();
                int idx = val.lastIndexOf(32);
                if (idx != -1) {
                    this.detail = val.substring(idx);
                    if (this.detail.startsWith(" (")) {
                        val = val.substring(0, idx);
                    } else {
                        this.detail = "";
                    }
                    int n = idx = val.startsWith("<") ? -1 : val.lastIndexOf(32);
                    if (idx != -1) {
                        this.name2 = val.substring(idx + 1);
                        this.name1 = val.substring(0, idx + 1);
                    } else {
                        this.name1 = "";
                        this.name2 = val;
                    }
                    idx = this.name2.lastIndexOf(46);
                    if (idx != -1) {
                        if (!this.name1.isEmpty()) {
                            this.name1 = this.name1 + " ";
                        }
                        this.name1 = this.name1 + this.name2.substring(0, idx + 1);
                        this.name2 = this.name2.substring(idx + 1);
                    }
                } else {
                    this.name1 = "";
                    this.name2 = val;
                    this.detail = "";
                }
            }
            this.frameRenderer.setValue((Object)new Object[]{this.name1, this.name2, this.detail}, row);
        }

        public String getShortName() {
            return "at " + this.name2 + " " + this.detail;
        }
    }
}

