/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.ui.DataSourceCaption;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.DataSourceWindowManager;
import org.graalvm.visualvm.core.ui.DataSourceWindowTabbedPane;
import org.graalvm.visualvm.uisupport.UISupport;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

class DataSourceWindow
extends TopComponent
implements PropertyChangeListener {
    private static final RequestProcessor PROCESSOR = new RequestProcessor("DataSourceWindow Processor", 5);
    private static final Logger LOGGER = Logger.getLogger(DataSourceWindow.class.getName());
    private int viewsCount = 0;
    private DataSource dataSource;
    private DataSourceDescriptor dataSourceDescriptor;
    private DataSourceWindowTabbedPane.ViewContainer singleViewContainer;
    private JPanel multiViewContainer;
    private AlertListener alertListener;
    private DataSourceWindowTabbedPane tabbedContainer;

    public DataSourceWindow(DataSource dataSource) {
        this.dataSource = dataSource;
        this.initAppearance();
        this.initComponents();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void addView(DataSourceView view) {
        if (this.viewsCount == 0) {
            this.singleViewContainer = new DataSourceWindowTabbedPane.ViewContainer(new DataSourceCaption<DataSource>(view.getDataSource()), view);
            this.add(this.singleViewContainer, "Center");
            this.doLayout();
            this.alertListener = new AlertListener();
        } else if (this.viewsCount == 1) {
            this.remove(this.singleViewContainer);
            this.add(this.multiViewContainer, "Center");
            this.tabbedContainer.addView(this.dataSource, this.singleViewContainer.getView());
            this.tabbedContainer.addView(this.dataSource, view);
            this.doLayout();
            this.singleViewContainer.getCaption().finish();
            this.singleViewContainer = null;
        } else {
            this.tabbedContainer.addView(this.dataSource, view);
        }
        ++this.viewsCount;
        view.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.alertListener, (Object)view));
    }

    private void insertView(DataSourceView view, int index) {
        if (this.viewsCount == 0) {
            this.singleViewContainer = new DataSourceWindowTabbedPane.ViewContainer(new DataSourceCaption<DataSource>(view.getDataSource()), view);
            this.add(this.singleViewContainer, "Center");
            this.doLayout();
            this.alertListener = new AlertListener();
        } else if (this.viewsCount == 1) {
            this.remove(this.singleViewContainer);
            this.add(this.multiViewContainer, "Center");
            this.tabbedContainer.addView(this.dataSource, this.singleViewContainer.getView());
            this.tabbedContainer.insertView(this.dataSource, view, index);
            this.doLayout();
            this.singleViewContainer.getCaption().finish();
            this.singleViewContainer = null;
        } else {
            this.tabbedContainer.insertView(this.dataSource, view, index);
        }
        ++this.viewsCount;
        view.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.alertListener, (Object)view));
    }

    public void selectView(DataSourceView view) {
        if (this.viewsCount > 1) {
            int viewIndex = this.indexOf(view);
            if (viewIndex == -1) {
                throw new RuntimeException("View " + view + " not present in DataSourceWindow " + this);
            }
            this.tabbedContainer.setViewIndex(viewIndex);
        }
    }

    public void removeView(final DataSourceView view) {
        if (this.viewsCount == 1) {
            if (view != this.singleViewContainer.getView()) {
                throw new RuntimeException("View " + view + " not present in DataSourceWindow " + this);
            }
            view.viewWillBeRemoved();
            this.remove(this.singleViewContainer);
            this.singleViewContainer.getCaption().finish();
            this.singleViewContainer = null;
        } else {
            int viewIndex = this.indexOf(view);
            if (viewIndex == -1) {
                throw new RuntimeException("View " + view + " not present in DataSourceWindow " + this);
            }
            view.viewWillBeRemoved();
            this.tabbedContainer.removeView(viewIndex);
            if (this.viewsCount == 2) {
                DataSourceView remaining = this.tabbedContainer.getViews().get(0);
                this.singleViewContainer = new DataSourceWindowTabbedPane.ViewContainer(new DataSourceCaption<DataSource>(remaining.getDataSource()), remaining);
                this.remove(this.multiViewContainer);
                this.tabbedContainer.removeView(0);
                this.add(this.singleViewContainer, "Center");
                this.doLayout();
            }
        }
        PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                try {
                    view.viewRemoved();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed notifying removed view " + view, e);
                }
            }
        });
        DataSourceWindowManager.sharedInstance().unregisterClosedView(view);
        --this.viewsCount;
        if (this.viewsCount == 0 && this.isOpened()) {
            this.close();
        }
    }

    void clearView(final DataSourceView view, RequestProcessor notificationProcessor) {
        if (this.viewsCount == 1 && Objects.equals(this.singleViewContainer.getName(), view.getName())) {
            view.viewWillBeRemoved();
            this.singleViewContainer.removeAll();
            if (this.singleViewContainer.getCaption() != null) {
                this.singleViewContainer.getCaption().finish();
            }
            this.singleViewContainer.setReloading();
            this.singleViewContainer.doLayout();
            this.singleViewContainer.repaint();
        } else {
            int viewIndex = this.indexOf(view);
            if (viewIndex == -1) {
                return;
            }
            view.viewWillBeRemoved();
            this.tabbedContainer.clearView(viewIndex);
        }
        notificationProcessor.post(new Runnable(){

            @Override
            public void run() {
                try {
                    view.viewRemoved();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed notifying removed view " + view, e);
                }
            }
        });
    }

    void updateView(final DataSourceView view, int index) {
        if (this.viewsCount == 1 && Objects.equals(this.singleViewContainer.getName(), view.getName())) {
            this.singleViewContainer.removeAll();
            this.singleViewContainer.setCaption(new DataSourceCaption<DataSource>(view.getDataSource()));
            this.singleViewContainer.setView(view);
            this.singleViewContainer.doLayout();
            this.singleViewContainer.repaint();
        } else {
            DataSourceWindowTabbedPane.ViewContainer container = this.tabbedContainer.getContainer(view);
            if (container != null) {
                container.removeAll();
                container.setCaption(new DataSourceCaption<DataSource>(view.getDataSource()));
                container.setView(view);
                container.doLayout();
                container.repaint();
            } else {
                this.insertView(view, index);
            }
        }
        PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                try {
                    view.viewAdded();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed post-initialize view " + view, e);
                }
            }
        });
    }

    void closeUnregisteredView(DataSourceView view) {
        if (this.viewsCount == 1) {
            if (view != this.singleViewContainer.getView()) {
                throw new RuntimeException("View " + view + " not present in DataSourceWindow " + this);
            }
            this.remove(this.singleViewContainer);
            this.singleViewContainer.getCaption().finish();
            this.singleViewContainer = null;
        } else {
            int viewIndex = this.indexOf(view);
            if (viewIndex == -1) {
                throw new RuntimeException("View " + view + " not present in DataSourceWindow " + this);
            }
            this.tabbedContainer.removeView(viewIndex);
            if (this.viewsCount == 2) {
                DataSourceView remaining = this.tabbedContainer.getViews().get(0);
                this.singleViewContainer = new DataSourceWindowTabbedPane.ViewContainer(new DataSourceCaption<DataSource>(remaining.getDataSource()), remaining);
                this.remove(this.multiViewContainer);
                this.tabbedContainer.removeView(0);
                this.add(this.singleViewContainer, "Center");
                this.doLayout();
            }
        }
        --this.viewsCount;
        if (this.viewsCount == 0 && this.isOpened()) {
            this.close();
        }
    }

    public void removeAllViews() {
        List<DataSourceView> views = this.getViews();
        for (DataSourceView view : views) {
            this.removeView(view);
        }
    }

    public List<DataSourceView> getViews() {
        if (this.viewsCount == 1) {
            return Collections.singletonList(this.singleViewContainer.getView());
        }
        return this.tabbedContainer.getViews();
    }

    public boolean containsView(DataSourceView view) {
        return this.indexOf(view) != -1;
    }

    private int indexOf(DataSourceView view) {
        if (this.viewsCount == 1) {
            return view == this.singleViewContainer.getView() ? 0 : -1;
        }
        return this.tabbedContainer.indexOfView(view);
    }

    protected final void componentActivated() {
        super.componentActivated();
        if (this.singleViewContainer != null) {
            this.singleViewContainer.requestFocusInWindow();
        } else if (this.getComponentCount() > 0) {
            this.getComponent(0).requestFocusInWindow();
        }
    }

    public final boolean canClose() {
        for (DataSourceView view : this.getViews()) {
            view.viewWillBeRemoved();
        }
        return true;
    }

    protected final void componentClosed() {
        this.dataSourceDescriptor.removePropertyChangeListener(this);
        this.removeAllViews();
        DataSourceWindowManager.sharedInstance().unregisterClosedWindow(this);
        super.componentClosed();
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("prop_name".equals(propertyName)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataSourceWindow.this.setName((String)evt.getNewValue());
                }
            });
        } else if ("prop_icon".equals(propertyName)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataSourceWindow.this.setIcon((Image)evt.getNewValue());
                }
            });
        }
    }

    private void initAppearance() {
        this.dataSourceDescriptor = DataSourceDescriptorFactory.getDescriptor(this.dataSource);
        this.dataSourceDescriptor.addPropertyChangeListener(this);
        this.setName(this.dataSourceDescriptor.getName());
        this.setIcon(this.dataSourceDescriptor.getIcon());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.tabbedContainer = new DataSourceWindowTabbedPane(){

            @Override
            protected void closeView(DataSourceWindowTabbedPane.ViewContainer view) {
                DataSourceWindow.this.removeView(DataSourceWindow.this.tabbedContainer.getView(view));
            }
        };
        this.multiViewContainer = new JPanel(new BorderLayout());
        if (UISupport.isAquaLookAndFeel()) {
            this.multiViewContainer.setOpaque(true);
            this.multiViewContainer.setBackground(UISupport.getDefaultBackground());
        }
        this.multiViewContainer.add((Component)this.tabbedContainer, "Center");
        this.add(this.multiViewContainer, "Center");
    }

    private void setAlert(DataSourceView view, DataSourceView.Alert alert) {
        int viewIndex = this.tabbedContainer.indexOfView(view);
        this.tabbedContainer.setViewBackground(viewIndex, this.getAlertColor(alert));
        if (alert != DataSourceView.Alert.OK) {
            this.requestAttention(false);
        } else if (this.getApplicationAlert(alert) == DataSourceView.Alert.OK) {
            this.cancelRequestAttention();
        }
    }

    private Color getAlertColor(DataSourceView.Alert alert) {
        Color color = null;
        switch (alert) {
            case ERROR: {
                color = Color.RED;
                break;
            }
            case WARNING: {
                color = Color.YELLOW;
                break;
            }
            case OK: {
                color = null;
            }
        }
        return color;
    }

    private DataSourceView.Alert getApplicationAlert(DataSourceView.Alert alert) {
        if (alert == DataSourceView.Alert.ERROR) {
            return alert;
        }
        for (DataSourceView view : this.getViews()) {
            DataSourceView.Alert a = view.getAlert();
            if (a == DataSourceView.Alert.ERROR) {
                return a;
            }
            if (a != DataSourceView.Alert.WARNING) continue;
            alert = a;
        }
        return alert;
    }

    public int getPersistenceType() {
        return 2;
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    private class AlertListener
    implements PropertyChangeListener {
        private AlertListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("Alert".equals(evt.getPropertyName())) {
                DataSourceWindow.this.setAlert((DataSourceView)evt.getSource(), (DataSourceView.Alert)((Object)evt.getNewValue()));
            }
        }
    }
}

