/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.datalab.tables;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.PatternSyntaxException;
import javax.swing.RowFilter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.desktop.datalab.DataTablesModel;
import org.gephi.desktop.datalab.tables.ElementsDataTableModel;
import org.gephi.desktop.datalab.tables.celleditors.AttributeTypesSupportCellEditor;
import org.gephi.desktop.datalab.tables.columns.AttributeDataColumn;
import org.gephi.desktop.datalab.tables.columns.ElementDataColumn;
import org.gephi.desktop.datalab.utils.GraphModelProvider;
import org.gephi.desktop.datalab.utils.componentproviders.ArraySparklinesGraphicsComponentProvider;
import org.gephi.desktop.datalab.utils.componentproviders.IntervalMapSparklinesGraphicsComponentProvider;
import org.gephi.desktop.datalab.utils.componentproviders.IntervalSetGraphicsComponentProvider;
import org.gephi.desktop.datalab.utils.componentproviders.TimestampMapSparklinesGraphicsComponentProvider;
import org.gephi.desktop.datalab.utils.componentproviders.TimestampSetGraphicsComponentProvider;
import org.gephi.desktop.datalab.utils.stringconverters.ArrayStringConverter;
import org.gephi.desktop.datalab.utils.stringconverters.DefaultStringRepresentationConverter;
import org.gephi.desktop.datalab.utils.stringconverters.DoubleStringConverter;
import org.gephi.desktop.datalab.utils.stringconverters.TimeMapStringConverter;
import org.gephi.desktop.datalab.utils.stringconverters.TimeSetStringConverter;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.types.IntervalMap;
import org.gephi.graph.api.types.IntervalSet;
import org.gephi.graph.api.types.TimestampMap;
import org.gephi.graph.api.types.TimestampSet;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.StringValue;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class AbstractElementsDataTable<T extends Element>
implements GraphModelProvider {
    protected final JXTable table;
    protected String filterPattern;
    protected List<T> selectedElements;
    protected final AttributeColumnsController attributeColumnsController;
    protected boolean refreshingTable = false;
    protected Column[] showingColumns = null;
    protected ElementsDataTableModel<T> model;
    protected GraphModel graphModel;
    private boolean drawTimeIntervalGraphics = false;
    private boolean drawSparklines = false;
    private final DefaultTableRenderer arrayRenderer = new DefaultTableRenderer((StringValue)new ArrayStringConverter());
    private final DefaultTableRenderer defaultStringRepresentationRenderer = new DefaultTableRenderer((StringValue)new DefaultStringRepresentationConverter());
    private final DefaultTableRenderer timeSetRenderer;
    private final DefaultTableRenderer timeMapRenderer;
    private final DefaultTableRenderer doubleRenderer = new DefaultTableRenderer((StringValue)new DoubleStringConverter());
    private final IntervalSetGraphicsComponentProvider intervalSetGraphicsComponentProvider;
    private final TimestampSetGraphicsComponentProvider timestampSetGraphicsComponentProvider;
    private final DefaultTableRenderer intervalSetGraphicsRenderer;
    private final DefaultTableRenderer timestampSetGraphicsRenderer;
    private final DefaultTableRenderer intervalMapSparklinesGraphicsRenderer;
    private final DefaultTableRenderer timestampMapSparklinesGraphicsRenderer;
    private final DefaultTableRenderer arraySparklinesGraphicsRenderer;

    public AbstractElementsDataTable() {
        this.attributeColumnsController = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        this.table = new JXTable();
        this.table.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping()});
        this.table.setColumnControlVisible(false);
        this.table.setSortable(true);
        this.table.setAutoCreateRowSorter(true);
        this.intervalSetGraphicsComponentProvider = new IntervalSetGraphicsComponentProvider(this, this.table);
        this.timestampSetGraphicsComponentProvider = new TimestampSetGraphicsComponentProvider(this, this.table);
        this.intervalSetGraphicsRenderer = new DefaultTableRenderer((ComponentProvider)this.intervalSetGraphicsComponentProvider);
        this.timestampSetGraphicsRenderer = new DefaultTableRenderer((ComponentProvider)this.timestampSetGraphicsComponentProvider);
        this.timeSetRenderer = new DefaultTableRenderer((StringValue)new TimeSetStringConverter(this));
        this.timeMapRenderer = new DefaultTableRenderer((StringValue)new TimeMapStringConverter(this));
        this.intervalMapSparklinesGraphicsRenderer = new DefaultTableRenderer((ComponentProvider)new IntervalMapSparklinesGraphicsComponentProvider(this, this.table));
        this.timestampMapSparklinesGraphicsRenderer = new DefaultTableRenderer((ComponentProvider)new TimestampMapSparklinesGraphicsComponentProvider(this, this.table));
        this.arraySparklinesGraphicsRenderer = new DefaultTableRenderer((ComponentProvider)new ArraySparklinesGraphicsComponentProvider(this, this.table));
        this.prepareCellEditors();
        this.prepareRenderers();
    }

    public abstract List<? extends ElementDataColumn<T>> getFakeDataColumns(GraphModel var1, DataTablesModel var2);

    private void prepareCellEditors() {
        for (Class typeClass : AttributeUtils.getSupportedTypes()) {
            if (typeClass.equals(Boolean.class) || typeClass.equals(Boolean.TYPE)) continue;
            this.table.setDefaultEditor(typeClass, (TableCellEditor)new AttributeTypesSupportCellEditor(this, typeClass));
        }
    }

    private void prepareRenderers() {
        for (Class typeClass : AttributeUtils.getSupportedTypes()) {
            DefaultTableRenderer typeRenderer = null;
            boolean isNumberType = AttributeUtils.isNumberType((Class)typeClass);
            boolean isDynamic = AttributeUtils.isDynamicType((Class)typeClass);
            boolean isArray = typeClass.isArray();
            if (typeClass.equals(IntervalSet.class)) {
                typeRenderer = this.drawTimeIntervalGraphics ? this.intervalSetGraphicsRenderer : this.timeSetRenderer;
            } else if (typeClass.equals(TimestampSet.class)) {
                typeRenderer = this.drawTimeIntervalGraphics ? this.timestampSetGraphicsRenderer : this.timeSetRenderer;
            } else if (this.drawSparklines && isNumberType && (isArray || isDynamic)) {
                if (isArray) {
                    typeRenderer = this.arraySparklinesGraphicsRenderer;
                } else if (IntervalMap.class.isAssignableFrom(typeClass)) {
                    typeRenderer = this.intervalMapSparklinesGraphicsRenderer;
                } else if (TimestampMap.class.isAssignableFrom(typeClass)) {
                    typeRenderer = this.timestampMapSparklinesGraphicsRenderer;
                }
            }
            if (typeRenderer == null) {
                if (isArray) {
                    typeRenderer = this.arrayRenderer;
                } else if (isDynamic) {
                    typeRenderer = this.timeMapRenderer;
                } else if (isNumberType) {
                    boolean isDecimalType;
                    boolean bl = isDecimalType = typeClass.equals(Double.class) || typeClass.equals(Double.TYPE) || typeClass.equals(Float.class) || typeClass.equals(Float.TYPE);
                    if (isDecimalType) {
                        typeRenderer = this.doubleRenderer;
                    }
                }
            }
            if (typeRenderer == null) {
                typeRenderer = this.defaultStringRepresentationRenderer;
            }
            if (typeClass.equals(Boolean.class) || typeClass.equals(Boolean.TYPE)) continue;
            this.table.setDefaultRenderer(typeClass, (TableCellRenderer)typeRenderer);
        }
    }

    public JXTable getTable() {
        return this.table;
    }

    public boolean setFilterPattern(String regularExpr, int column) {
        try {
            if (Objects.equals(this.filterPattern, regularExpr)) {
                return true;
            }
            this.filterPattern = regularExpr;
            if (regularExpr == null || regularExpr.trim().isEmpty()) {
                this.table.setRowFilter(null);
            } else {
                if (!regularExpr.startsWith("(?i)")) {
                    regularExpr = "(?i)" + regularExpr;
                }
                RowFilter rowFilter = RowFilter.regexFilter(regularExpr, column);
                this.table.setRowFilter(rowFilter);
            }
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return true;
    }

    public String getPattern() {
        return this.filterPattern;
    }

    public void refreshModel(T[] elements, Column[] cols, GraphModel graphModel, DataTablesModel dataTablesModel) {
        this.graphModel = graphModel;
        this.showingColumns = cols;
        Interval timeBounds = graphModel.getTimeBounds();
        double min = timeBounds != null ? timeBounds.getLow() : 0.0;
        double max = timeBounds != null ? timeBounds.getHigh() : 0.0;
        this.refreshCellRenderersConfiguration(graphModel, min, max);
        this.refreshingTable = true;
        if (this.selectedElements == null) {
            this.selectedElements = this.getElementsFromSelectedRows();
        }
        ArrayList<ElementDataColumn<ElementDataColumn>> columns = new ArrayList<ElementDataColumn<ElementDataColumn>>();
        columns.addAll(this.getFakeDataColumns(graphModel, dataTablesModel));
        for (Column c : cols) {
            columns.add(new AttributeDataColumn(this.attributeColumnsController, c));
        }
        if (this.model == null) {
            this.model = new ElementsDataTableModel(elements, columns.toArray(new ElementDataColumn[0]));
            this.table.setModel(this.model);
        } else {
            this.model.configure((Element[])elements, columns.toArray(new ElementDataColumn[0]));
        }
        TableHeaderWithTooltip headerWithTooltips = new TableHeaderWithTooltip(this.table.getColumnModel(), columns);
        this.table.setTableHeader((JTableHeader)headerWithTooltips);
        this.setElementsSelection(this.selectedElements);
        this.selectedElements = null;
        this.refreshingTable = false;
    }

    private void refreshCellRenderersConfiguration(GraphModel graphModel, double min, double max) {
        this.intervalSetGraphicsComponentProvider.setMinMax(min, max);
        this.timestampSetGraphicsComponentProvider.setMinMax(min, max);
    }

    @Override
    public GraphModel getGraphModel() {
        return this.graphModel;
    }

    public boolean isRefreshingTable() {
        return this.refreshingTable;
    }

    public Column getColumnAtIndex(int columnIndex) {
        int realColumnIndex = this.table.convertColumnIndexToModel(columnIndex);
        return this.model.getColumnAtIndex(realColumnIndex);
    }

    public void setElementsSelection(List<T> elements) {
        this.selectedElements = elements;
        HashSet<T> elementsSet = new HashSet<T>();
        elementsSet.addAll(elements);
        this.table.clearSelection();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (!elementsSet.contains(this.getElementFromRow(i))) continue;
            this.table.addRowSelectionInterval(i, i);
        }
    }

    public void setElementsSelection(T[] elements) {
        this.setElementsSelection(Arrays.asList(elements));
    }

    public void scrollToFirstElementSelected() {
        int row = this.table.getSelectedRow();
        if (row != -1) {
            Rectangle rect = this.table.getCellRect(row, 0, true);
            this.table.scrollRectToVisible(rect);
        }
    }

    public boolean hasData() {
        return this.table.getRowCount() > 0;
    }

    public void setDrawSparklines(boolean drawSparklines) {
        this.drawSparklines = drawSparklines;
        this.prepareRenderers();
    }

    public void setDrawTimeIntervalGraphics(boolean drawTimeIntervalGraphics) {
        this.drawTimeIntervalGraphics = drawTimeIntervalGraphics;
        this.prepareRenderers();
    }

    public boolean isDrawTimeIntervalGraphics() {
        return this.drawTimeIntervalGraphics;
    }

    public T getElementFromRow(int row) {
        return ((ElementsDataTableModel)this.table.getModel()).getElementAtRow(this.table.convertRowIndexToModel(row));
    }

    public List<T> getElementsFromSelectedRows() {
        int[] selectedRows = this.table.getSelectedRows();
        ArrayList<T> elements = new ArrayList<T>();
        for (int i = 0; i < selectedRows.length; ++i) {
            elements.add(this.getElementFromRow(selectedRows[i]));
        }
        return elements;
    }

    private class TableHeaderWithTooltip
    extends JTableHeader {
        private final List<ElementDataColumn<T>> columns;

        public TableHeaderWithTooltip(TableColumnModel columnModel, List<ElementDataColumn<T>> columns) {
            super(columnModel);
            this.columns = columns;
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            Point p = e.getPoint();
            int index = this.columnModel.getColumnIndexAtX(p.x);
            int realIndex = this.columnModel.getColumn(index).getModelIndex();
            if (realIndex < this.columns.size() && this.columns.get(realIndex).getColumn() != null) {
                String id = this.columns.get(realIndex).getColumn().getId();
                return NbBundle.getMessage(AbstractElementsDataTable.class, (String)"AbstractElementsDataTable.column.tooltip", (Object)id);
            }
            return null;
        }
    }
}

