/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.filters.plugin;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;

public class JQuickHistogram {
    private int constraintHeight = 0;
    private int constraintWidth = 0;
    private JPanel panel;
    private final boolean inclusive = true;
    private List<Double> data;
    private Double minValue;
    private Double maxValue;
    private Double minRange;
    private Double maxRange;

    public JQuickHistogram() {
        this.clear();
    }

    public void clear() {
        this.data = new ArrayList<Double>();
        this.minValue = Double.MAX_VALUE;
        this.maxValue = Double.NEGATIVE_INFINITY;
    }

    public void addData(Object data) {
        if (data instanceof Double) {
            this.addData((Double)data);
        } else if (data instanceof Integer) {
            this.addData(((Integer)data).doubleValue());
        } else if (data instanceof Float) {
            this.addData(((Float)data).doubleValue());
        } else if (data instanceof Long) {
            this.addData(((Long)data).doubleValue());
        }
    }

    public void addData(Double data) {
        this.data.add(data);
        this.minValue = Math.min(this.minValue, data);
        this.maxValue = Math.max(this.maxValue, data);
        this.minRange = this.minValue;
        this.maxRange = this.maxValue;
    }

    public void sortData() {
        Collections.sort(this.data);
    }

    public void setLowerBound(Double lowerBound) {
        this.minRange = lowerBound;
    }

    public void setUpperBound(Double upperBound) {
        this.maxRange = upperBound;
    }

    public JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JQuickHistogramPanel(this);
        }
        return this.panel;
    }

    public void setConstraintHeight(int constraintHeight) {
        this.constraintHeight = constraintHeight;
        this.panel.setPreferredSize(new Dimension(this.constraintWidth, constraintHeight));
        this.panel.setMinimumSize(new Dimension(this.constraintWidth, constraintHeight));
    }

    public void setConstraintWidth(int constraintWidth) {
        this.constraintWidth = constraintWidth;
        this.panel.setPreferredSize(new Dimension(constraintWidth, this.constraintHeight));
        this.panel.setMinimumSize(new Dimension(constraintWidth, this.constraintHeight));
    }

    public int countValues() {
        return this.data.size();
    }

    public int countInRange() {
        int res = 0;
        for (int i = 0; i < this.data.size(); ++i) {
            Double d = this.data.get(i);
            if (!(d >= this.minRange) || !(d <= this.maxRange)) continue;
            ++res;
        }
        return res;
    }

    public double getAverage() {
        double res = 0.0;
        for (int i = 0; i < this.data.size(); ++i) {
            double d = this.data.get(i);
            res += d;
        }
        return res /= (double)this.data.size();
    }

    public double getAverageInRange() {
        double res = 0.0;
        int c = 0;
        for (int i = 0; i < this.data.size(); ++i) {
            double d = this.data.get(i);
            if (!(d >= this.minRange) || !(d <= this.maxRange)) continue;
            res += d;
            ++c;
        }
        return res /= (double)c;
    }

    public double getMedian() {
        return this.data.get((this.data.size() + 1) / 2);
    }

    public double getMedianInRange() {
        int median = (this.countInRange() + 1) / 2;
        for (int i = 0; i < this.data.size(); ++i) {
            double d = this.data.get(i);
            if (!(d >= this.minRange) || !(d <= this.maxRange) || median-- != 0) continue;
            return d;
        }
        return -1.0;
    }

    private static class JQuickHistogramPanel
    extends JPanel {
        private final Color fillColor = new Color(13619923);
        private final Color fillInRangeColor = new Color(3883074);
        private final JQuickHistogram histogram;
        private int currentHeight = 0;
        private int currentWidth = 0;

        public JQuickHistogramPanel(JQuickHistogram histogram) {
            this.histogram = histogram;
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.setCurrentDimension();
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(0, this.currentHeight);
            g2d.scale(1.0, -1.0);
            this.drawHisto(g2d);
            g2d.dispose();
        }

        private void drawHisto(Graphics2D g2d) {
            if (this.histogram.minRange == null || this.histogram.maxRange == null) {
                return;
            }
            int dataSize = this.histogram.data.size();
            if (dataSize < this.currentWidth) {
                int rectWidth = (int)((float)this.currentWidth / (float)dataSize);
                int leftover = this.currentWidth - rectWidth * dataSize;
                int xPosition = 0;
                for (int i = 0; i < dataSize; ++i) {
                    Double data = (Double)this.histogram.data.get(i);
                    int rectangleWidth = rectWidth + (leftover > 0 ? 1 : 0);
                    --leftover;
                    int rectangleHeight = (int)((data - this.histogram.minValue) / (this.histogram.maxValue - this.histogram.minValue) * (double)this.currentHeight);
                    if (data >= this.histogram.minRange && data <= this.histogram.maxRange) {
                        g2d.setColor(this.fillInRangeColor);
                    } else {
                        g2d.setColor(this.fillColor);
                    }
                    g2d.fillRect(xPosition, 0, rectangleWidth, rectangleHeight);
                    xPosition += rectangleWidth;
                }
            } else {
                int xPosition = 0;
                int sizeOfSmallSublists = dataSize / this.currentWidth;
                int sizeOfLargeSublists = sizeOfSmallSublists + 1;
                int numberOfLargeSublists = dataSize % this.currentWidth;
                int numberOfSmallSublists = this.currentWidth - numberOfLargeSublists;
                int numberOfElementsHandled = 0;
                for (int i = 0; i < this.currentWidth; ++i) {
                    int size = i < numberOfSmallSublists ? sizeOfSmallSublists : sizeOfLargeSublists;
                    double average = 0.0;
                    for (int j = 0; j < size; ++j) {
                        Double d = (Double)this.histogram.data.get(numberOfElementsHandled++);
                        average += d.doubleValue();
                    }
                    int rectangleHeight = (int)(((average /= (double)size) - this.histogram.minValue) / (this.histogram.maxValue - this.histogram.minValue) * (double)this.currentHeight);
                    if (average >= this.histogram.minRange && average <= this.histogram.maxRange) {
                        g2d.setColor(this.fillInRangeColor);
                    } else {
                        g2d.setColor(this.fillColor);
                    }
                    g2d.fillRect(xPosition, 0, 1, rectangleHeight);
                    ++xPosition;
                }
            }
        }

        private void setCurrentDimension() {
            this.currentHeight = this.histogram.constraintHeight > 0 ? this.histogram.constraintHeight : this.getHeight();
            this.currentWidth = this.histogram.constraintWidth > 0 ? this.histogram.constraintWidth : this.getWidth();
        }
    }
}

