'''
Static type checking stub file for scipy/spatial/qhull.pyx
'''

from __future__ import annotations
from typing import TYPE_CHECKING, List, Tuple, Any

if TYPE_CHECKING:
    from numpy.typing import ArrayLike
else:
    ArrayLike = Any

import numpy as np

class _Qhull:
    def __init__(
        self,
        points: ArrayLike,
        furthest_site: bool = ...,
        incremental: bool = ...,
        qhull_options=...
    ): ...
    def check_active(self) -> None: ...
    def close(self) -> None: ...
    def get_points(self) -> np.ndarray: ...
    def add_points(
        self,
        points: ArrayLike,
        interior_point: ArrayLike = ...
    ): ...
    def get_paraboloid_shift_scale(self) -> Tuple[float, float]: ...
    def volume_area(self) -> Tuple[float, float]: ...
    def triangulate(self) -> None: ...
    def get_simplex_facet_array(self): ...
    def get_hull_points(self) -> np.ndarray: ...
    def get_hull_facets(self) -> Tuple[List[List[int]], np.ndarray]: ...
    def get_voronoi_diagram(self) -> Tuple[np.ndarray, np.ndarray,
                                           List[List], List[List],
                                           np.ndarray]: ...
    def get_extremes_2d(self) -> np.ndarray: ...

def _get_barycentric_transforms(
    points: np.ndarray,
    simplices: np.ndarray,
    eps: float
) -> np.ndarray: ...

class _QhullUser:
    def close(self) -> None: ...
    def _update(self, qhull: _Qhull) -> None: ...
    def _add_points(
        self,
        points: ArrayLike,
        restart: bool = ...,
        interior_point: ArrayLike = ...
    ) -> None: ...

class Delaunay(_QhullUser):
    def __init__(
        self,
        points: ArrayLike,
        furthest_site: bool = ...,
        incremental: bool = ...,
        qhull_options=...
    ): ...
    def _update(self, qhull: _Qhull) -> None: ...
    def add_points(
        self,
        points: ArrayLike,
        restart: bool = ...
    ) -> None: ...
    @property
    def points(self) -> np.ndarray: ...
    @property
    def transform(self) -> np.ndarray: ...
    @property
    def vertex_to_simplex(self) -> np.ndarray: ...
    @property
    def vertex_neighbor_vertices(self) -> Tuple[np.ndarray, np.ndarray]: ...
    @property
    def convex_hull(self) -> np.ndarray: ...
    def find_simplex(
        self,
        xi: ArrayLike,
        bruteforce: bool = ...,
        tol: float = ...
    ) -> np.ndarray: ...
    def plane_distance(self, xi: ArrayLike) -> np.ndarray: ...
    def lift_points(self, x: ArrayLike) -> np.ndarray: ...

def tsearch(tri: Delaunay, xi: ArrayLike) -> np.ndarray: ...
def _copy_docstr(dst: object, src: object) -> None: ...

class ConvexHull(_QhullUser):
    def __init__(
        self,
        points: ArrayLike,
        incremental: bool = ...,
        qhull_options=...
    ): ...
    def _update(self, qhull: _Qhull) -> None: ...
    def add_points(self, points: ArrayLike,
                   restart: bool = ...) -> None: ...
    @property
    def points(self) -> np.ndarray: ...
    @property
    def vertices(self) -> np.ndarray: ...

class Voronoi(_QhullUser):
    def __init__(
        self,
        points: ArrayLike,
        furthest_site: bool = ...,
        incremental: bool = ...,
        qhull_options=...
    ): ...
    def _update(self, qhull: _Qhull) -> None: ...
    def add_points(
        self,
        points: ArrayLike,
        restart: bool = ...
    ) -> None: ...
    @property
    def points(self) -> np.ndarray: ...
    @property
    def ridge_dict(self) -> dict: ...

class HalfspaceIntersection(_QhullUser):
    def __init__(
        self,
        halfspaces: ArrayLike,
        interior_point: ArrayLike,
        incremental: bool = ...,
        qhull_options=...
    ): ...
    def _update(self, qhull: _Qhull) -> None: ...
    def add_halfspaces(
        self,
        halfspaces: ArrayLike,
        restart: bool = ...
    ) -> None: ...
    @property
    def halfspaces(self) -> np.ndarray: ...
    @property
    def dual_vertices(self) -> np.ndarray: ...
