/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteBufferUtils;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.SocketBufferHandler;
import org.apache.tomcat.util.net.TLSClientHelloExtractor;
import org.apache.tomcat.util.net.openssl.ciphers.Cipher;
import org.apache.tomcat.util.res.StringManager;

public class SecureNioChannel
extends NioChannel {
    private static final Log log = LogFactory.getLog(SecureNioChannel.class);
    private static final StringManager sm = StringManager.getManager(SecureNioChannel.class);
    private static final int DEFAULT_NET_BUFFER_SIZE = 16921;
    private final NioEndpoint endpoint;
    protected ByteBuffer netInBuffer;
    protected ByteBuffer netOutBuffer;
    protected SSLEngine sslEngine;
    protected boolean sniComplete = false;
    protected boolean handshakeComplete = false;
    protected SSLEngineResult.HandshakeStatus handshakeStatus;
    protected boolean closed = false;
    protected boolean closing = false;
    private final Map<String, List<String>> additionalTlsAttributes = new HashMap<String, List<String>>();

    public SecureNioChannel(SocketBufferHandler socketBufferHandler, NioEndpoint nioEndpoint) {
        super(socketBufferHandler);
        if (nioEndpoint.getSocketProperties().getDirectSslBuffer()) {
            this.netInBuffer = ByteBuffer.allocateDirect(16921);
            this.netOutBuffer = ByteBuffer.allocateDirect(16921);
        } else {
            this.netInBuffer = ByteBuffer.allocate(16921);
            this.netOutBuffer = ByteBuffer.allocate(16921);
        }
        this.endpoint = nioEndpoint;
    }

    @Override
    public void reset(SocketChannel socketChannel, NioEndpoint.NioSocketWrapper nioSocketWrapper) throws IOException {
        super.reset(socketChannel, nioSocketWrapper);
        this.sslEngine = null;
        this.sniComplete = false;
        this.handshakeComplete = false;
        this.closed = false;
        this.closing = false;
        this.netInBuffer.clear();
    }

    @Override
    public void free() {
        super.free();
        if (this.endpoint.getSocketProperties().getDirectSslBuffer()) {
            ByteBufferUtils.cleanDirectBuffer((ByteBuffer)this.netInBuffer);
            ByteBufferUtils.cleanDirectBuffer((ByteBuffer)this.netOutBuffer);
        }
    }

    protected boolean flush(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.remaining();
        if (n > 0) {
            return this.sc.write(byteBuffer) >= n;
        }
        return true;
    }

    @Override
    public int handshake(boolean bl, boolean bl2) throws IOException {
        if (this.handshakeComplete) {
            return 0;
        }
        if (!this.sniComplete) {
            int n = this.processSNI();
            if (n == 0) {
                this.sniComplete = true;
            } else {
                return n;
            }
        }
        if (!this.flush(this.netOutBuffer)) {
            return 4;
        }
        SSLEngineResult sSLEngineResult = null;
        block9: while (!this.handshakeComplete) {
            switch (this.handshakeStatus) {
                case NOT_HANDSHAKING: {
                    throw new IOException(sm.getString("channel.nio.ssl.notHandshaking"));
                }
                case FINISHED: {
                    if (this.endpoint.hasNegotiableProtocols()) {
                        if (this.sslEngine instanceof SSLUtil.ProtocolInfo) {
                            this.socketWrapper.setNegotiatedProtocol(((SSLUtil.ProtocolInfo)((Object)this.sslEngine)).getNegotiatedProtocol());
                        } else if (JreCompat.isAlpnSupported()) {
                            this.socketWrapper.setNegotiatedProtocol(JreCompat.getInstance().getApplicationProtocol(this.sslEngine));
                        }
                    }
                    this.handshakeComplete = !this.netOutBuffer.hasRemaining();
                    return this.handshakeComplete ? 0 : 4;
                }
                case NEED_WRAP: {
                    try {
                        sSLEngineResult = this.handshakeWrap(bl2);
                    }
                    catch (SSLException sSLException) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("channel.nio.ssl.wrapException"), (Throwable)sSLException);
                        }
                        sSLEngineResult = this.handshakeWrap(bl2);
                    }
                    if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) {
                        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                            this.handshakeStatus = this.tasks();
                        }
                    } else {
                        if (sSLEngineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
                            this.flush(this.netOutBuffer);
                            return -1;
                        }
                        throw new IOException(sm.getString("channel.nio.ssl.unexpectedStatusDuringWrap", new Object[]{sSLEngineResult.getStatus()}));
                    }
                    if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP || !this.flush(this.netOutBuffer)) {
                        return 4;
                    }
                }
                case NEED_UNWRAP: {
                    sSLEngineResult = this.handshakeUnwrap(bl);
                    if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) {
                        if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK) continue block9;
                        this.handshakeStatus = this.tasks();
                        continue block9;
                    }
                    if (sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        return 1;
                    }
                    throw new IOException(sm.getString("channel.nio.ssl.unexpectedStatusDuringWrap", new Object[]{sSLEngineResult.getStatus()}));
                }
                case NEED_TASK: {
                    this.handshakeStatus = this.tasks();
                    continue block9;
                }
            }
            throw new IllegalStateException(sm.getString("channel.nio.ssl.invalidStatus", new Object[]{this.handshakeStatus}));
        }
        return 0;
    }

    private int processSNI() throws IOException {
        int n = this.sc.read(this.netInBuffer);
        if (n == -1) {
            return -1;
        }
        TLSClientHelloExtractor tLSClientHelloExtractor = new TLSClientHelloExtractor(this.netInBuffer);
        while (tLSClientHelloExtractor.getResult() == TLSClientHelloExtractor.ExtractorResult.UNDERFLOW && this.netInBuffer.capacity() < this.endpoint.getSniParseLimit()) {
            int n2 = Math.min(this.netInBuffer.capacity() * 2, this.endpoint.getSniParseLimit());
            log.info((Object)sm.getString("channel.nio.ssl.expandNetInBuffer", new Object[]{Integer.toString(n2)}));
            this.netInBuffer = ByteBufferUtils.expand((ByteBuffer)this.netInBuffer, (int)n2);
            this.sc.read(this.netInBuffer);
            tLSClientHelloExtractor = new TLSClientHelloExtractor(this.netInBuffer);
        }
        String string = null;
        List<Cipher> list = null;
        List<String> list2 = null;
        switch (tLSClientHelloExtractor.getResult()) {
            case COMPLETE: {
                string = tLSClientHelloExtractor.getSNIValue();
                list2 = tLSClientHelloExtractor.getClientRequestedApplicationProtocols();
            }
            case NOT_PRESENT: {
                list = tLSClientHelloExtractor.getClientRequestedCiphers();
                break;
            }
            case NEED_READ: {
                return 1;
            }
            case UNDERFLOW: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("channel.nio.ssl.sniDefault"));
                }
                string = this.endpoint.getDefaultSSLHostConfigName();
                list = Collections.emptyList();
                break;
            }
            case NON_SECURE: {
                this.netOutBuffer.clear();
                this.netOutBuffer.put(TLSClientHelloExtractor.USE_TLS_RESPONSE);
                this.netOutBuffer.flip();
                this.flushOutbound();
                throw new IOException(sm.getString("channel.nio.ssl.foundHttp"));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("channel.nio.ssl.sniHostName", new Object[]{this.sc, string}));
        }
        this.sslEngine = this.endpoint.createSSLEngine(string, list, list2);
        this.additionalTlsAttributes.put("org.apache.tomcat.util.net.secure_requested_protocol_versions", tLSClientHelloExtractor.getClientRequestedProtocols());
        this.additionalTlsAttributes.put("org.apache.tomcat.util.net.secure_requested_ciphers", tLSClientHelloExtractor.getClientRequestedCipherNames());
        this.getBufHandler().expand(this.sslEngine.getSession().getApplicationBufferSize());
        if (this.netOutBuffer.capacity() < this.sslEngine.getSession().getApplicationBufferSize()) {
            log.info((Object)sm.getString("channel.nio.ssl.expandNetOutBuffer", new Object[]{Integer.toString(this.sslEngine.getSession().getApplicationBufferSize())}));
        }
        this.netInBuffer = ByteBufferUtils.expand((ByteBuffer)this.netInBuffer, (int)this.sslEngine.getSession().getPacketBufferSize());
        this.netOutBuffer = ByteBufferUtils.expand((ByteBuffer)this.netOutBuffer, (int)this.sslEngine.getSession().getPacketBufferSize());
        this.netOutBuffer.position(0);
        this.netOutBuffer.limit(0);
        this.sslEngine.beginHandshake();
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
        return 0;
    }

    public void rehandshake(long l) throws IOException {
        if (this.netInBuffer.position() > 0 && this.netInBuffer.position() < this.netInBuffer.limit()) {
            throw new IOException(sm.getString("channel.nio.ssl.netInputNotEmpty"));
        }
        if (this.netOutBuffer.position() > 0 && this.netOutBuffer.position() < this.netOutBuffer.limit()) {
            throw new IOException(sm.getString("channel.nio.ssl.netOutputNotEmpty"));
        }
        if (!this.getBufHandler().isReadBufferEmpty()) {
            throw new IOException(sm.getString("channel.nio.ssl.appInputNotEmpty"));
        }
        if (!this.getBufHandler().isWriteBufferEmpty()) {
            throw new IOException(sm.getString("channel.nio.ssl.appOutputNotEmpty"));
        }
        this.handshakeComplete = false;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        Selector selector = null;
        SelectionKey selectionKey = null;
        try {
            this.sslEngine.beginHandshake();
            this.handshakeStatus = this.sslEngine.getHandshakeStatus();
            block18: while (bl3) {
                int n = this.handshake(bl, bl2);
                switch (n) {
                    case -1: {
                        throw new EOFException(sm.getString("channel.nio.ssl.eofDuringHandshake"));
                    }
                    case 0: {
                        bl3 = false;
                        continue block18;
                    }
                }
                long l2 = System.currentTimeMillis();
                if (selector == null) {
                    selector = Selector.open();
                    selectionKey = this.getIOChannel().register(selector, n);
                } else {
                    selectionKey.interestOps(n);
                }
                int n2 = selector.select(l);
                if (n2 == 0 && System.currentTimeMillis() - l2 >= l) {
                    throw new SocketTimeoutException(sm.getString("channel.nio.ssl.timeoutDuringHandshake"));
                }
                bl = selectionKey.isReadable();
                bl2 = selectionKey.isWritable();
            }
        }
        catch (IOException iOException) {
            this.closeSilently();
            throw iOException;
        }
        catch (Exception exception) {
            this.closeSilently();
            IOException iOException = new IOException(exception);
            throw iOException;
        }
        finally {
            if (selectionKey != null) {
                try {
                    selectionKey.cancel();
                }
                catch (Exception exception) {}
            }
            if (selector != null) {
                try {
                    selector.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected SSLEngineResult.HandshakeStatus tasks() {
        Runnable runnable = null;
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return this.sslEngine.getHandshakeStatus();
    }

    protected SSLEngineResult handshakeWrap(boolean bl) throws IOException {
        this.netOutBuffer.clear();
        this.getBufHandler().configureWriteBufferForRead();
        SSLEngineResult sSLEngineResult = this.sslEngine.wrap(this.getBufHandler().getWriteBuffer(), this.netOutBuffer);
        this.netOutBuffer.flip();
        this.handshakeStatus = sSLEngineResult.getHandshakeStatus();
        if (bl) {
            this.flush(this.netOutBuffer);
        }
        return sSLEngineResult;
    }

    protected SSLEngineResult handshakeUnwrap(boolean bl) throws IOException {
        SSLEngineResult sSLEngineResult;
        int n;
        if (this.netInBuffer.position() == this.netInBuffer.limit()) {
            this.netInBuffer.clear();
        }
        if (bl && (n = this.sc.read(this.netInBuffer)) == -1) {
            throw new IOException(sm.getString("channel.nio.ssl.eofDuringHandshake"));
        }
        boolean bl2 = false;
        do {
            this.netInBuffer.flip();
            this.getBufHandler().configureReadBufferForWrite();
            sSLEngineResult = this.sslEngine.unwrap(this.netInBuffer, this.getBufHandler().getReadBuffer());
            this.netInBuffer.compact();
            this.handshakeStatus = sSLEngineResult.getHandshakeStatus();
            if (sSLEngineResult.getStatus() != SSLEngineResult.Status.OK || sSLEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
            this.handshakeStatus = this.tasks();
        } while (bl2 = sSLEngineResult.getStatus() == SSLEngineResult.Status.OK && this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
        return sSLEngineResult;
    }

    public SSLSupport getSSLSupport() {
        if (this.sslEngine != null) {
            SSLSession sSLSession = this.sslEngine.getSession();
            return this.endpoint.getSslImplementation().getSSLSupport(sSLSession, this.additionalTlsAttributes);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.closing) {
            return;
        }
        this.closing = true;
        if (this.sslEngine == null) {
            this.netOutBuffer.clear();
            this.closed = true;
            return;
        }
        this.sslEngine.closeOutbound();
        if (!this.flush(this.netOutBuffer)) {
            throw new IOException(sm.getString("channel.nio.ssl.remainingDataDuringClose"));
        }
        this.netOutBuffer.clear();
        SSLEngineResult sSLEngineResult = this.sslEngine.wrap(this.getEmptyBuf(), this.netOutBuffer);
        if (sSLEngineResult.getStatus() != SSLEngineResult.Status.CLOSED) {
            throw new IOException(sm.getString("channel.nio.ssl.invalidCloseState"));
        }
        this.netOutBuffer.flip();
        this.flush(this.netOutBuffer);
        this.closed = !this.netOutBuffer.hasRemaining() && sSLEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_WRAP;
    }

    @Override
    public void close(boolean bl) throws IOException {
        try {
            this.close();
        }
        finally {
            if (bl || this.closed) {
                this.closed = true;
                this.sc.close();
            }
        }
    }

    private void closeSilently() {
        try {
            this.close(true);
        }
        catch (IOException iOException) {
            log.debug((Object)sm.getString("channel.nio.ssl.closeSilentError"), (Throwable)iOException);
        }
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (this.closing || this.closed) {
            return -1;
        }
        if (!this.handshakeComplete) {
            throw new IllegalStateException(sm.getString("channel.nio.ssl.incompleteHandshake"));
        }
        int n = this.sc.read(this.netInBuffer);
        if (n == -1) {
            return -1;
        }
        int n2 = 0;
        do {
            this.netInBuffer.flip();
            SSLEngineResult sSLEngineResult = this.sslEngine.unwrap(this.netInBuffer, byteBuffer);
            this.netInBuffer.compact();
            if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK || sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                n2 += sSLEngineResult.bytesProduced();
                if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.tasks();
                }
                if (sSLEngineResult.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
                break;
            }
            if (sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                if (n2 > 0) break;
                if (byteBuffer == this.getBufHandler().getReadBuffer()) {
                    this.getBufHandler().expand(this.sslEngine.getSession().getApplicationBufferSize());
                    byteBuffer = this.getBufHandler().getReadBuffer();
                    continue;
                }
                if (this.getAppReadBufHandler() != null && byteBuffer == this.getAppReadBufHandler().getByteBuffer()) {
                    this.getAppReadBufHandler().expand(this.sslEngine.getSession().getApplicationBufferSize());
                    byteBuffer = this.getAppReadBufHandler().getByteBuffer();
                    continue;
                }
                throw new IOException(sm.getString("channel.nio.ssl.unwrapFailResize", new Object[]{sSLEngineResult.getStatus()}));
            }
            if (sSLEngineResult.getStatus() == SSLEngineResult.Status.CLOSED && this.netInBuffer.position() == 0 && n2 > 0) continue;
            throw new IOException(sm.getString("channel.nio.ssl.unwrapFail", new Object[]{sSLEngineResult.getStatus()}));
        } while (this.netInBuffer.position() != 0);
        return n2;
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (this.closing || this.closed) {
            return -1L;
        }
        if (!this.handshakeComplete) {
            throw new IllegalStateException(sm.getString("channel.nio.ssl.incompleteHandshake"));
        }
        int n3 = this.sc.read(this.netInBuffer);
        if (n3 == -1) {
            return -1L;
        }
        int n4 = 0;
        OverflowState overflowState = OverflowState.NONE;
        do {
            if (overflowState == OverflowState.PROCESSING) {
                overflowState = OverflowState.DONE;
            }
            this.netInBuffer.flip();
            SSLEngineResult sSLEngineResult = this.sslEngine.unwrap(this.netInBuffer, byteBufferArray, n, n2);
            this.netInBuffer.compact();
            if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK || sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                n4 += sSLEngineResult.bytesProduced();
                if (overflowState == OverflowState.DONE) {
                    n4 -= this.getBufHandler().getReadBuffer().position();
                }
                if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.tasks();
                }
                if (sSLEngineResult.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
                break;
            }
            if (sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                if (n4 > 0) break;
                ByteBuffer byteBuffer = this.getBufHandler().getReadBuffer();
                boolean bl = false;
                boolean bl2 = true;
                for (int i = 0; i < n2; ++i) {
                    if (byteBufferArray[n + i] == this.getBufHandler().getReadBuffer()) {
                        this.getBufHandler().expand(this.sslEngine.getSession().getApplicationBufferSize());
                        if (byteBufferArray[n + i] == this.getBufHandler().getReadBuffer()) {
                            bl2 = false;
                        }
                        byteBufferArray[n + i] = this.getBufHandler().getReadBuffer();
                        bl = true;
                        continue;
                    }
                    if (this.getAppReadBufHandler() == null || byteBufferArray[n + i] != this.getAppReadBufHandler().getByteBuffer()) continue;
                    this.getAppReadBufHandler().expand(this.sslEngine.getSession().getApplicationBufferSize());
                    if (byteBufferArray[n + i] == this.getAppReadBufHandler().getByteBuffer()) {
                        bl2 = false;
                    }
                    byteBufferArray[n + i] = this.getAppReadBufHandler().getByteBuffer();
                    bl = true;
                }
                if (bl) {
                    if (bl2) continue;
                    throw new IOException(sm.getString("channel.nio.ssl.unwrapFail", new Object[]{sSLEngineResult.getStatus()}));
                }
                ByteBuffer[] byteBufferArray2 = new ByteBuffer[byteBufferArray.length + 1];
                int n5 = 0;
                for (int i = 0; i < byteBufferArray.length + 1; ++i) {
                    if (i == n + n2) {
                        byteBufferArray2[i] = byteBuffer;
                        n5 = -1;
                        continue;
                    }
                    byteBufferArray2[i] = byteBufferArray[i + n5];
                }
                byteBufferArray = byteBufferArray2;
                ++n2;
                this.getBufHandler().configureReadBufferForWrite();
                overflowState = OverflowState.PROCESSING;
                continue;
            }
            throw new IOException(sm.getString("channel.nio.ssl.unwrapFail", new Object[]{sSLEngineResult.getStatus()}));
        } while ((this.netInBuffer.position() != 0 || overflowState == OverflowState.PROCESSING) && overflowState != OverflowState.DONE);
        return n4;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.checkInterruptStatus();
        if (byteBuffer == this.netOutBuffer) {
            int n = this.sc.write(byteBuffer);
            return n;
        }
        if (this.closing || this.closed) {
            throw new IOException(sm.getString("channel.nio.ssl.closing"));
        }
        if (!this.flush(this.netOutBuffer)) {
            return 0;
        }
        this.netOutBuffer.clear();
        SSLEngineResult sSLEngineResult = this.sslEngine.wrap(byteBuffer, this.netOutBuffer);
        int n = sSLEngineResult.bytesConsumed();
        this.netOutBuffer.flip();
        if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) {
            if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                this.tasks();
            }
        } else {
            throw new IOException(sm.getString("channel.nio.ssl.wrapFail", new Object[]{sSLEngineResult.getStatus()}));
        }
        this.flush(this.netOutBuffer);
        return n;
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        this.checkInterruptStatus();
        if (this.closing || this.closed) {
            throw new IOException(sm.getString("channel.nio.ssl.closing"));
        }
        if (!this.flush(this.netOutBuffer)) {
            return 0L;
        }
        this.netOutBuffer.clear();
        SSLEngineResult sSLEngineResult = this.sslEngine.wrap(byteBufferArray, n, n2, this.netOutBuffer);
        int n3 = sSLEngineResult.bytesConsumed();
        this.netOutBuffer.flip();
        if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) {
            if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                this.tasks();
            }
        } else {
            throw new IOException(sm.getString("channel.nio.ssl.wrapFail", new Object[]{sSLEngineResult.getStatus()}));
        }
        this.flush(this.netOutBuffer);
        return n3;
    }

    @Override
    public int getOutboundRemaining() {
        return this.netOutBuffer.remaining();
    }

    @Override
    public boolean flushOutbound() throws IOException {
        int n = this.netOutBuffer.remaining();
        this.flush(this.netOutBuffer);
        int n2 = this.netOutBuffer.remaining();
        return n2 < n;
    }

    @Override
    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    @Override
    public boolean isClosing() {
        return this.closing;
    }

    public SSLEngine getSslEngine() {
        return this.sslEngine;
    }

    public ByteBuffer getEmptyBuf() {
        return emptyBuf;
    }

    private static enum OverflowState {
        NONE,
        PROCESSING,
        DONE;

    }
}

