/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.NumberFormat;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import org.graalvm.visualvm.core.ui.components.ScrollableContainer;
import org.graalvm.visualvm.heapviewer.HeapViewer;
import org.graalvm.visualvm.heapviewer.ui.Bundle;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.lib.jfluid.heap.HeapSummary;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.components.HTMLTextArea;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;

class HeapDumpInfoAction
extends AbstractAction {
    private final HeapViewer heapViewer;
    private static final String SUMMARY_SECTION_PREFIX = "<b><img border='0' align='bottom' src='nbresloc:/" + Icons.getResource((String)"GeneralIcons.Info") + "'>&nbsp;&nbsp;" + Bundle.HeapDumpInfoAction_SummaryString() + "</b><br><hr>";

    public HeapDumpInfoAction(HeapViewer heapViewer) {
        this.putValue("Name", Bundle.HeapDumpInfoAction_ActionName());
        this.putValue("ShortDescription", Bundle.HeapDumpInfoAction_ActionDescr());
        this.putValue("SmallIcon", Icons.getIcon((String)"GeneralIcons.Info"));
        this.putValue("iconBase", Icons.getResource((String)"GeneralIcons.Info"));
        this.heapViewer = heapViewer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DialogDescriptor dd = new DialogDescriptor((Object)HeapDumpInfoAction.infoComponent(this.heapViewer), Bundle.HeapDumpInfoAction_WindowCaption(), true, new Object[]{DialogDescriptor.OK_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
        DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
    }

    private static JComponent infoComponent(HeapViewer heapViewer) {
        HTMLTextArea text = new HTMLTextArea();
        text.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        HeapDumpInfoAction.createInfo(text, heapViewer);
        ScrollableContainer textScroll = new ScrollableContainer((JComponent)text);
        textScroll.setPreferredSize(new Dimension(500, 175));
        return textScroll;
    }

    private static void createInfo(final HTMLTextArea text, final HeapViewer heapViewer) {
        SwingWorker<String, String> worker = new SwingWorker<String, String>(){

            @Override
            protected String doInBackground() throws Exception {
                return HeapDumpInfoAction.computeInfo(heapViewer);
            }

            @Override
            protected void done() {
                try {
                    text.setText((String)this.get());
                    text.setCaretPosition(0);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        worker.execute();
        try {
            worker.get(UIThresholds.VIEW_LOAD, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (TimeoutException ex) {
            text.setText(SUMMARY_SECTION_PREFIX + "<div style='margin-left: 10px;'>" + Bundle.HeapDumpInfoAction_ComputingInfo() + "</div>");
            text.setCaretPosition(0);
        }
    }

    private static String computeInfo(HeapViewer heapViewer) {
        File file = heapViewer.getFile();
        HeapSummary hsummary = heapViewer.getFragments().get(0).getHeap().getSummary();
        NumberFormat numberFormat = (NumberFormat)NumberFormat.getInstance().clone();
        numberFormat.setMaximumFractionDigits(1);
        String filename = Bundle.HeapDumpInfoAction_FileItemString(file != null && file.exists() ? file.getAbsolutePath() : Bundle.HeapDumpInfoAction_NotAvailableMsg());
        String filesize = Bundle.HeapDumpInfoAction_FileSizeItemString(file != null && file.exists() ? numberFormat.format((double)file.length() / 1048576.0) + " MB" : Bundle.HeapDumpInfoAction_NotAvailableMsg());
        String dateTaken = Bundle.HeapDumpInfoAction_DateTakenItemString(new Date(hsummary.getTime()).toString());
        return SUMMARY_SECTION_PREFIX + "<div style='margin-left: 10px;'>" + dateTaken + "<br>" + filename + "<br>" + filesize + "</div>";
    }
}

