/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import net.sourceforge.jnlp.JNLPSplashScreen;
import net.sourceforge.jnlp.OptionsDefinitions;
import net.sourceforge.jnlp.ParserSettings;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.runtime.Boot;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.runtime.html.AppletExtractor;
import net.sourceforge.jnlp.runtime.html.AppletParser;
import net.sourceforge.jnlp.runtime.html.AppletsFilter;
import net.sourceforge.jnlp.util.ScreenFinder;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.jnlp.util.optionparser.OptionParser;
import net.sourceforge.swing.SwingUtils;

public final class HtmlBoot {
    private final OptionParser optionParser;
    private JNLPSplashScreen splashScreen;

    public HtmlBoot(OptionParser optionParser) {
        this.optionParser = optionParser;
    }

    private JFrame invokePluginMain(PluginBridge pb, URL html) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> c = Class.forName("sun.applet.PluginMain");
        Method m = c.getMethod("javawsHtmlMain", PluginBridge.class, URL.class);
        return (JFrame)m.invoke(null, pb, html);
    }

    private static void changeMovement(int[] move) {
        if (move[0] > 0) {
            if (move[0] % 2 == 0) {
                move[1] = move[1] + 100;
            } else {
                move[2] = move[2] + 100;
            }
        }
    }

    private Point changeMovementSigns(int[] move) {
        int x = move[1];
        int y = move[2];
        switch (move[0] % 4) {
            case 0: {
                x = -x;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                y = -y;
                break;
            }
            case 3: {
                x = -x;
                y = -y;
            }
        }
        return new Point(x, y);
    }

    boolean run(Map<String, List<String>> extra) {
        if (!this.optionParser.hasOption(OptionsDefinitions.OPTIONS.HEADLESS)) {
            SwingUtils.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HtmlBoot.this.splashScreen = new JNLPSplashScreen(null, null);
                    HtmlBoot.this.splashScreen.setSplashImageURL(null);
                    HtmlBoot.this.splashScreen.setVisible(true);
                }
            });
        }
        List<String> vars = this.optionParser.getParams(OptionsDefinitions.OPTIONS.HTML);
        JNLPRuntime.setForksAllowed(false);
        ParserSettings settings = Boot.init(extra);
        if (settings == null) {
            return false;
        }
        try {
            OutputController.getLogger().log("Proceeding with html");
            URL html = Boot.getFileLocation();
            AppletExtractor axe = new AppletExtractor(html, settings);
            AppletsFilter filtered = new AppletsFilter(axe.findAppletsOnPage(), html, vars.subList(1, vars.size()));
            List<AppletParser> applets = filtered.getApplets();
            final int[] move = new int[]{0, 0, 0};
            for (AppletParser appletParser : applets) {
                HtmlBoot.changeMovement(move);
                PluginBridge pb = appletParser.toPluginBridge();
                if (this.splashScreen != null) {
                    this.splashScreen.setFile(pb);
                }
                final JFrame f = this.invokePluginMain(pb, html);
                f.setDefaultCloseOperation(3);
                SwingUtils.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Point movement = HtmlBoot.this.changeMovementSigns(move);
                        f.pack();
                        ScreenFinder.centerWindowsToCurrentScreen(f);
                        Rectangle r = f.getBounds();
                        r.x += movement.x;
                        r.y += movement.y;
                        f.setBounds(r);
                        f.setVisible(true);
                    }
                });
                move[0] = move[0] + 1;
            }
            if (this.splashScreen != null) {
                this.splashScreen.stopAnimation();
                this.splashScreen.setVisible(false);
                this.splashScreen.dispose();
            }
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
            if (this.splashScreen != null) {
                SwingUtils.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HtmlBoot.this.splashScreen.setErrorSplash(ex);
                        HtmlBoot.this.splashScreen.setDefaultCloseOperation(2);
                        HtmlBoot.this.splashScreen.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosed(WindowEvent e) {
                                Boot.fatalError(Translator.R("RUnexpected", ex.toString(), ex.getStackTrace()[0]));
                            }
                        });
                    }
                });
            }
            Boot.fatalError(Translator.R("RUnexpected", ex.toString(), ex.getStackTrace()[0]));
        }
        return true;
    }
}

