/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jmx.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.remote.JMXServiceURL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.DataSourceRepository;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.datasupport.DataChangeEvent;
import org.graalvm.visualvm.core.datasupport.DataChangeListener;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.core.options.GlobalPreferences;
import org.graalvm.visualvm.host.Host;
import org.graalvm.visualvm.host.HostsSupport;
import org.graalvm.visualvm.jmx.CredentialsProvider;
import org.graalvm.visualvm.jmx.EnvironmentProvider;
import org.graalvm.visualvm.jmx.JmxApplicationException;
import org.graalvm.visualvm.jmx.JmxApplicationsSupport;
import org.graalvm.visualvm.jmx.impl.JmxApplication;
import org.graalvm.visualvm.jmx.impl.JmxConnectionSupportImpl;
import org.graalvm.visualvm.jmx.impl.JmxHeartbeat;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class JmxApplicationProvider {
    private static final String SNAPSHOT_VERSION = "snapshot_version";
    private static final String SNAPSHOT_VERSION_DIVIDER = ".";
    private static final String CURRENT_SNAPSHOT_VERSION_MAJOR = "1";
    private static final String CURRENT_SNAPSHOT_VERSION_MINOR = "2";
    private static final String CURRENT_SNAPSHOT_VERSION = "1.2";
    public static final String PROPERTY_RETRY_WITHOUT_SSL = "prop_retry_without_ssl";
    private static final String PROPERTY_CONNECTION_STRING = "prop_conn_string";
    private static final String PROPERTY_HOSTNAME = "prop_conn_hostname";
    private static final String PROPERTY_ENV_PROVIDER_ID = "prop_env_provider_id";
    private static final String PROPERTIES_FILE = "jmxapplication.properties";
    static final String JMX_SUFFIX = ".jmx";
    private static final String DNSA_KEY = "JMXApplicationProvider_NotifyUnresolved";
    private volatile boolean trackingNewHosts;
    private Map<String, Set<Storage>> persistedApplications = new HashMap<String, Set<Storage>>();

    private static boolean isLocalHost(String hostname) throws IOException {
        InetAddress remoteAddr = InetAddress.getByName(hostname);
        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
        while (nis.hasMoreElements()) {
            NetworkInterface ni = nis.nextElement();
            Enumeration<InetAddress> addrs = ni.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress localAddr = addrs.nextElement();
                if (!localAddr.equals(remoteAddr)) continue;
                return true;
            }
        }
        return false;
    }

    private Host getHost(String hostname, JMXServiceURL url) throws IOException {
        if (hostname != null) {
            if (hostname.isEmpty() || JmxApplicationProvider.isLocalHost(hostname)) {
                return Host.LOCALHOST;
            }
            return HostsSupport.getInstance().getOrCreateHost(hostname, false);
        }
        return Host.UNKNOWN_HOST;
    }

    public static String getConnectionString(JmxApplication application) {
        return application.getStorage().getCustomProperty(PROPERTY_CONNECTION_STRING);
    }

    public static String getSuggestedName(String displayName, String connectionString, String username) {
        if (displayName != null) {
            return displayName;
        }
        if (username == null) {
            username = "";
        }
        return (username.isEmpty() ? "" : username + "@") + connectionString;
    }

    public JmxApplication createJmxApplication(String connectionString, String displayName, String suggestedName, EnvironmentProvider provider, boolean persistent, boolean allowsInsecure, boolean connectImmediately, boolean connectAutomatically) throws JmxApplicationException {
        JMXServiceURL serviceURL;
        String normalizedConnectionName = this.normalizeConnectionName(connectionString);
        try {
            serviceURL = this.getServiceURL(normalizedConnectionName);
        }
        catch (MalformedURLException ex) {
            throw new JmxApplicationException(NbBundle.getMessage(JmxApplicationProvider.class, (String)"MSG_Invalid_JMX_connection", (Object)normalizedConnectionName), ex);
        }
        String hostName = this.getHostName(serviceURL);
        hostName = hostName == null ? "" : hostName;
        Storage storage = null;
        if (persistent) {
            File storageDirectory = Utils.getUniqueFile((File)JmxApplicationsSupport.getStorageDirectory(), (String)("" + System.currentTimeMillis()), (String)JMX_SUFFIX);
            Utils.prepareDirectory((File)storageDirectory);
            storage = new Storage(storageDirectory, PROPERTIES_FILE);
            storage.setCustomProperty(SNAPSHOT_VERSION, CURRENT_SNAPSHOT_VERSION);
        }
        try {
            JmxApplication app = this.addJmxApplication(true, serviceURL, normalizedConnectionName, displayName, suggestedName, hostName, provider, storage, Boolean.toString(allowsInsecure), true, connectImmediately, connectAutomatically);
            return app;
        }
        catch (JMXException e) {
            File appStorage;
            if (storage != null && (appStorage = storage.getDirectory()).isDirectory()) {
                Utils.delete((File)appStorage, (boolean)true);
            }
            throw new JmxApplicationException(e.getMessage(), e.getCause());
        }
    }

    private JmxApplication addJmxApplication(boolean newApp, JMXServiceURL serviceURL, String connectionName, String displayName, String suggestedName, String hostName, EnvironmentProvider provider, Storage storage, String allowsInsecure, boolean lazy, boolean connectImmediately, boolean connectAutomatically) throws JMXException {
        if (lazy) {
            return this.addLazyJmxApplication(newApp, serviceURL, connectionName, displayName, suggestedName, hostName, provider, storage, allowsInsecure, connectImmediately, connectAutomatically);
        }
        throw new RuntimeException("Only lazy JMX connections currently implemented!");
    }

    private JmxApplication addLazyJmxApplication(boolean newApp, JMXServiceURL serviceURL, String connectionName, String displayName, String suggestedName, String hostName, EnvironmentProvider provider, Storage storage, String allowsInsecure, boolean connectImmediately, boolean connectAutomatically) throws JMXException {
        Set jmxapps;
        if (serviceURL == null) {
            try {
                serviceURL = this.getServiceURL(connectionName);
            }
            catch (MalformedURLException ex) {
                throw new JMXException(true, NbBundle.getMessage(JmxApplicationProvider.class, (String)"MSG_Invalid_JMX_connection", (Object)connectionName), ex);
            }
        }
        Set hosts = DataSourceRepository.sharedInstance().getDataSources(Host.class);
        Host host = null;
        try {
            host = this.getHost(hostName, serviceURL);
        }
        catch (Exception e) {
            this.cleanupCreatedHost(hosts, host);
            throw new JMXException(false, NbBundle.getMessage(JmxApplicationProvider.class, (String)"MSG_Cannot_resolve_host", (Object)hostName), e);
        }
        if (storage != null) {
            if (newApp) {
                storage.setCustomProperty(PROPERTY_HOSTNAME, host.getHostName());
                if (provider != null) {
                    storage.setCustomProperty(PROPERTY_ENV_PROVIDER_ID, provider.getId());
                    provider.saveEnvironment(storage);
                }
            } else if (provider != null) {
                provider.loadEnvironment(storage);
            }
        }
        JmxApplication application = new JmxApplication(host, serviceURL, provider, storage);
        if (newApp) {
            Storage s = application.getStorage();
            String[] keys = new String[]{PROPERTY_CONNECTION_STRING, displayName != null ? "prop_name" : "prop_suggested_name"};
            String[] values = new String[]{connectionName, displayName != null ? displayName : suggestedName};
            s.setCustomProperties(keys, values);
            if (provider != null) {
                provider.saveEnvironment(s);
            }
        }
        if ((jmxapps = host.getRepository().getDataSources(JmxApplication.class)).contains((Object)application)) {
            JmxApplication tempapp = null;
            for (JmxApplication jmxapp : jmxapps) {
                if (!jmxapp.equals((Object)application)) continue;
                tempapp = jmxapp;
                break;
            }
            this.cleanupCreatedHost(hosts, host);
            throw new JMXException(true, NbBundle.getMessage(JmxApplicationProvider.class, (String)"MSG_connection_already_exists", (Object[])new Object[]{application.getId(), DataSourceDescriptorFactory.getDescriptor((DataSource)tempapp).getName()}));
        }
        application.getStorage().setCustomProperty(PROPERTY_RETRY_WITHOUT_SSL, allowsInsecure);
        host.getRepository().addDataSource((DataSource)application);
        if (!connectAutomatically) {
            application.disableHeartbeat();
        }
        if (connectImmediately) {
            JmxHeartbeat.scheduleImmediately(application);
        }
        return application;
    }

    private void cleanupCreatedHost(Set<Host> hosts, Host host) {
        if (host != null && !Host.LOCALHOST.equals((Object)host) && !hosts.contains(host)) {
            host.getOwner().getRepository().removeDataSource((DataSource)host);
        }
    }

    private String normalizeConnectionName(String connectionName) {
        if (connectionName.startsWith("service:jmx:")) {
            return connectionName;
        }
        return "service:jmx:rmi:///jndi/rmi://" + connectionName + "/jmxrmi";
    }

    private String getHostName(JMXServiceURL serviceURL) {
        String hostname = serviceURL.getHost();
        if (hostname == null || hostname.isEmpty()) {
            hostname = null;
            if ("rmi".equals(serviceURL.getProtocol()) && serviceURL.getURLPath().startsWith("/jndi/rmi://")) {
                String urlPath = serviceURL.getURLPath().substring("/jndi/rmi://".length());
                if ('/' == urlPath.charAt(0)) {
                    hostname = "localhost";
                } else if ('[' == urlPath.charAt(0)) {
                    int closingSquareBracketIndex = urlPath.indexOf("]");
                    hostname = closingSquareBracketIndex == -1 ? null : urlPath.substring(0, closingSquareBracketIndex + 1);
                } else {
                    int slashIndex;
                    int colonIndex = urlPath.indexOf(":");
                    int min = Math.min(colonIndex, slashIndex = urlPath.indexOf("/"));
                    if (min == -1) {
                        min = 0;
                    }
                    if ((hostname = urlPath.substring(0, min)).isEmpty()) {
                        hostname = "localhost";
                    }
                }
            }
        }
        return hostname;
    }

    private JMXServiceURL getServiceURL(String connectionString) throws MalformedURLException {
        return new JMXServiceURL(connectionString);
    }

    private void initPersistedApplications() {
        if (!JmxApplicationsSupport.storageDirectoryExists()) {
            return;
        }
        File[] files = JmxApplicationsSupport.getStorageDirectory().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(JmxApplicationProvider.JMX_SUFFIX);
            }
        });
        final int[] persistedAppsCount = new int[1];
        for (File file : files) {
            if (!file.isDirectory()) continue;
            persistedAppsCount[0] = persistedAppsCount[0] + 1;
            Storage storage = new Storage(file, PROPERTIES_FILE);
            Set<Storage> storageSet = this.persistedApplications.get(storage.getCustomProperty(PROPERTY_HOSTNAME));
            if (storageSet == null) {
                storageSet = new HashSet<Storage>();
                this.persistedApplications.put(storage.getCustomProperty(PROPERTY_HOSTNAME), storageSet);
            }
            storageSet.add(storage);
        }
        DataChangeListener<Host> dataChangeListener = new DataChangeListener<Host>(){

            public synchronized void dataChanged(DataChangeEvent<Host> event) {
                final Set failedAppsN = Collections.synchronizedSet(new HashSet());
                final Set failedAppsS = Collections.synchronizedSet(new HashSet());
                Set hosts = event.getAdded();
                for (Host host : hosts) {
                    String hostName = host.getHostName();
                    Set storageSet = (Set)JmxApplicationProvider.this.persistedApplications.get(hostName);
                    int storageSetSize = storageSet == null ? 0 : storageSet.size();
                    if (storageSetSize <= 0) continue;
                    JmxApplicationProvider.this.persistedApplications.remove(hostName);
                    String[] keys = new String[]{JmxApplicationProvider.PROPERTY_CONNECTION_STRING, JmxApplicationProvider.PROPERTY_HOSTNAME, "prop_name", "prop_suggested_name", JmxApplicationProvider.PROPERTY_ENV_PROVIDER_ID, JmxApplicationProvider.PROPERTY_RETRY_WITHOUT_SSL, "prop_disable_heartbeat"};
                    final AtomicInteger counter = new AtomicInteger(storageSetSize);
                    final List persistentApps = Collections.synchronizedList(new ArrayList());
                    RequestProcessor processor = new RequestProcessor("JMX Persistence Processor", Math.min(storageSetSize, 10));
                    for (final Storage storage : storageSet) {
                        final String[] values = storage.getCustomProperties(keys);
                        processor.post(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    boolean autoConnect;
                                    EnvironmentProvider ep;
                                    JmxApplication app;
                                    String sv;
                                    String epid = values[4];
                                    if (epid == null && "1.0".equals(sv = storage.getCustomProperty(JmxApplicationProvider.SNAPSHOT_VERSION))) {
                                        epid = CredentialsProvider.class.getName();
                                    }
                                    if (!(app = JmxApplicationProvider.this.addLazyJmxApplication(false, null, values[0], values[2], values[3], values[1], ep = epid == null ? null : JmxConnectionSupportImpl.getProvider(epid), storage, values[5], autoConnect = !Boolean.parseBoolean(values[6]), autoConnect)).isHeartbeatDisabled()) {
                                        persistentApps.add(app);
                                    }
                                }
                                catch (JMXException e) {
                                    if (e.isConfig()) {
                                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
                                    } else {
                                        String name = values[2];
                                        if (name == null || name.trim().isEmpty()) {
                                            name = values[3];
                                        }
                                        failedAppsN.add(name);
                                        failedAppsS.add(storage);
                                    }
                                }
                                finally {
                                    if (counter.decrementAndGet() == 0) {
                                        JmxHeartbeat.scheduleImmediately(persistentApps.toArray(new JmxApplication[0]));
                                    }
                                }
                                int[] nArray = persistedAppsCount;
                                synchronized (persistedAppsCount) {
                                    persistedAppsCount[0] = persistedAppsCount[0] - 1;
                                    if (persistedAppsCount[0] == 0 && !failedAppsN.isEmpty()) {
                                        JmxApplicationProvider.notifyUnresolvedApplications(failedAppsN, failedAppsS);
                                    }
                                    // ** MonitorExit[var1_1] (shouldn't be in output)
                                    return;
                                }
                            }
                        });
                    }
                }
                if (JmxApplicationProvider.this.trackingNewHosts && JmxApplicationProvider.this.persistedApplications.isEmpty()) {
                    JmxApplicationProvider.this.trackingNewHosts = false;
                    DataSourceRepository.sharedInstance().removeDataChangeListener((DataChangeListener)this);
                }
            }
        };
        if (!this.persistedApplications.isEmpty()) {
            this.trackingNewHosts = true;
            DataSourceRepository.sharedInstance().addDataChangeListener((DataChangeListener)dataChangeListener, Host.class);
        }
    }

    private static void notifyUnresolvedApplications(final Set<String> failedHostsN, final Set<Storage> failedHostsS) {
        VisualVM.getInstance().runTask(new Runnable(){

            @Override
            public void run() {
                Boolean b;
                String s = GlobalPreferences.sharedInstance().getDoNotShowAgain(JmxApplicationProvider.DNSA_KEY);
                Boolean bl = b = s == null ? null : Boolean.valueOf(Boolean.parseBoolean(s));
                if (b == null) {
                    JPanel messagePanel = new JPanel(new BorderLayout(5, 5));
                    messagePanel.add((Component)new JLabel(NbBundle.getMessage(JmxApplicationProvider.class, (String)"MSG_Unresolved_JMX")), "North");
                    JList<Object> list = new JList<Object>(failedHostsN.toArray());
                    list.setVisibleRowCount(4);
                    messagePanel.add((Component)new JScrollPane(list), "Center");
                    JCheckBox dnsa = new JCheckBox();
                    Mnemonics.setLocalizedText((AbstractButton)dnsa, (String)NbBundle.getMessage(JmxApplicationProvider.class, (String)"LBL_RememberAction"));
                    dnsa.setToolTipText(NbBundle.getMessage(JmxApplicationProvider.class, (String)"TTP_RememberAction"));
                    JPanel p = new JPanel(new BorderLayout());
                    p.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 20));
                    p.add((Component)dnsa, "West");
                    messagePanel.add((Component)p, "South");
                    NotifyDescriptor dd = new NotifyDescriptor((Object)messagePanel, NbBundle.getMessage(JmxApplicationProvider.class, (String)"Title_Unresolved_JMX"), 0, 0, null, NotifyDescriptor.YES_OPTION);
                    Object ret = DialogDisplayer.getDefault().notify(dd);
                    if (ret == NotifyDescriptor.NO_OPTION) {
                        b = Boolean.FALSE;
                    } else if (ret == NotifyDescriptor.YES_OPTION) {
                        b = Boolean.TRUE;
                    }
                    if (dnsa.isSelected() && b != null) {
                        GlobalPreferences.sharedInstance().setDoNotShowAgain(JmxApplicationProvider.DNSA_KEY, b.toString());
                    }
                }
                if (Boolean.FALSE.equals(b)) {
                    for (Storage storage : failedHostsS) {
                        File appStorage = storage.getDirectory();
                        if (!appStorage.isDirectory()) continue;
                        Utils.delete((File)appStorage, (boolean)true);
                    }
                }
                failedHostsS.clear();
            }
        }, 1000);
    }

    public void initialize() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                VisualVM.getInstance().runTask(new Runnable(){

                    @Override
                    public void run() {
                        JmxApplicationProvider.this.initPersistedApplications();
                    }
                });
            }
        });
    }

    private static class JMXException
    extends Exception {
        private final boolean isConfig;

        public JMXException(boolean config, String message) {
            super(message);
            this.isConfig = config;
        }

        public JMXException(boolean config, String message, Throwable cause) {
            super(message, cause);
            this.isConfig = config;
        }

        public boolean isConfig() {
            return this.isConfig;
        }
    }
}

