/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.InputFilter;
import org.apache.tomcat.util.buf.ByteChunk;

public class SavedRequestInputFilter
implements InputFilter {
    protected ByteChunk input = null;

    public SavedRequestInputFilter(ByteChunk byteChunk) {
        this.input = byteChunk;
    }

    @Override
    public int doRead(ByteChunk byteChunk, Request request) throws IOException {
        int n = 0;
        n = byteChunk.getLimit() > 0 && byteChunk.getLimit() < this.input.getLength() ? byteChunk.getLimit() : this.input.getLength();
        if (this.input.getOffset() >= this.input.getEnd()) {
            return -1;
        }
        this.input.substract(byteChunk.getBuffer(), 0, n);
        byteChunk.setOffset(0);
        byteChunk.setEnd(n);
        return n;
    }

    @Override
    public void setRequest(Request request) {
        request.setContentLength(this.input.getLength());
    }

    @Override
    public void recycle() {
        this.input = null;
    }

    @Override
    public ByteChunk getEncodingName() {
        return null;
    }

    @Override
    public void setBuffer(InputBuffer inputBuffer) {
    }

    @Override
    public int available() {
        return this.input.getLength();
    }

    @Override
    public long end() throws IOException {
        return 0L;
    }
}

