/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.tomcat.util.res.StringManager;

public final class NetMask {
    private static final StringManager sm = StringManager.getManager(NetMask.class);
    private final String expression;
    private final byte[] netaddr;
    private final int nrBytes;
    private final int lastByteShift;

    public NetMask(String string) {
        int n;
        this.expression = string;
        int n2 = string.indexOf("/");
        if (n2 == -1) {
            try {
                this.netaddr = InetAddress.getByName(string).getAddress();
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalArgumentException(sm.getString("netmask.invalidAddress", new Object[]{string}));
            }
            this.nrBytes = this.netaddr.length;
            this.lastByteShift = 0;
            return;
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        try {
            this.netaddr = InetAddress.getByName(string2).getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException(sm.getString("netmask.invalidAddress", new Object[]{string2}));
        }
        int n3 = this.netaddr.length * 8;
        try {
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(sm.getString("netmask.cidrNotNumeric", new Object[]{string3}));
        }
        if (n < 0) {
            throw new IllegalArgumentException(sm.getString("netmask.cidrNegative", new Object[]{string3}));
        }
        if (n > n3) {
            throw new IllegalArgumentException(sm.getString("netmask.cidrTooBig", new Object[]{string3, n3}));
        }
        this.nrBytes = n / 8;
        int n4 = n % 8;
        this.lastByteShift = n4 == 0 ? 0 : 8 - n4;
    }

    public boolean matches(InetAddress inetAddress) {
        int n;
        byte[] byArray = inetAddress.getAddress();
        if (byArray.length != this.netaddr.length) {
            return false;
        }
        for (n = 0; n < this.nrBytes; ++n) {
            if (this.netaddr[n] == byArray[n]) continue;
            return false;
        }
        if (this.lastByteShift == 0) {
            return true;
        }
        int n2 = this.netaddr[n] ^ byArray[n];
        return n2 >> this.lastByteShift == 0;
    }

    public String toString() {
        return this.expression;
    }
}

