/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.util;

import java.security.SecureRandom;
import java.util.Random;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class UUIDGenerator {
    private static final Log log = LogFactory.getLog(UUIDGenerator.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.tribes.util");
    public static final int UUID_LENGTH = 16;
    public static final int UUID_VERSION = 4;
    public static final int BYTES_PER_INT = 4;
    public static final int BITS_PER_BYTE = 8;
    protected static SecureRandom secrand = null;
    protected static Random rand = new Random();

    public static byte[] randomUUID(boolean bl) {
        byte[] byArray = new byte[16];
        return UUIDGenerator.randomUUID(bl, byArray, 0);
    }

    public static byte[] randomUUID(boolean bl, byte[] byArray, int n) {
        if (n + 16 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("Unable to fit 16 bytes into the array. length:" + byArray.length + " required length:" + (n + 16));
        }
        Random random = bl && secrand != null ? secrand : rand;
        UUIDGenerator.nextBytes(byArray, n, 16, random);
        int n2 = 6 + n;
        byArray[n2] = (byte)(byArray[n2] & 0xF);
        int n3 = 6 + n;
        byArray[n3] = (byte)(byArray[n3] | 0x40);
        int n4 = 8 + n;
        byArray[n4] = (byte)(byArray[n4] & 0x3F);
        int n5 = 8 + n;
        byArray[n5] = (byte)(byArray[n5] | 0x80);
        return byArray;
    }

    public static void nextBytes(byte[] byArray, int n, int n2, Random random) {
        int n3 = n2;
        int n4 = 0;
        int n5 = 0;
        block0: while (true) {
            int n6 = 0;
            while (true) {
                if (n6 >= 4) continue block0;
                if (n4 == n3) {
                    return;
                }
                n5 = n6 == 0 ? random.nextInt() : n5 >> 8;
                byArray[n + n4] = (byte)n5;
                ++n4;
                ++n6;
            }
            break;
        }
    }

    static {
        long l = System.currentTimeMillis();
        secrand = new SecureRandom();
        secrand.nextInt();
        long l2 = System.currentTimeMillis() - l;
        if (l2 > 100L) {
            log.info((Object)sm.getString("uuidGenerator.createRandom", secrand.getAlgorithm(), l2));
        }
    }
}

