/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class InlineView
extends LabelView {
    private boolean nowrap;
    private AttributeSet attr;

    public InlineView(Element element) {
        super(element);
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.insertUpdate(documentEvent, shape, viewFactory);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.removeUpdate(documentEvent, shape, viewFactory);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, viewFactory);
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
        this.preferenceChanged(null, true, true);
    }

    @Override
    public AttributeSet getAttributes() {
        return this.attr;
    }

    @Override
    public int getBreakWeight(int n, float f, float f2) {
        if (this.nowrap) {
            return 0;
        }
        return super.getBreakWeight(n, f, f2);
    }

    @Override
    public View breakView(int n, int n2, float f, float f2) {
        return super.breakView(n, n2, f, f2);
    }

    @Override
    protected void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        AttributeSet attributeSet = this.getAttributes();
        Object object = attributeSet.getAttribute(CSS.Attribute.TEXT_DECORATION);
        boolean bl = object != null ? object.toString().indexOf("underline") >= 0 : false;
        this.setUnderline(bl);
        boolean bl2 = object != null ? object.toString().indexOf("line-through") >= 0 : false;
        this.setStrikeThrough(bl2);
        Object object2 = attributeSet.getAttribute(CSS.Attribute.VERTICAL_ALIGN);
        bl2 = object2 != null ? object2.toString().indexOf("sup") >= 0 : false;
        this.setSuperscript(bl2);
        bl2 = object2 != null ? object2.toString().indexOf("sub") >= 0 : false;
        this.setSubscript(bl2);
        Object object3 = attributeSet.getAttribute(CSS.Attribute.WHITE_SPACE);
        this.nowrap = object3 != null && object3.equals("nowrap");
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        Color color = hTMLDocument.getBackground(attributeSet);
        if (color != null) {
            this.setBackground(color);
        }
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }
}

