/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fi extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_bax = "bamum";
        final String metaValue_kpe = "kpelle";
        final String metaValue_men = "mende";
        final String metaValue_nqo = "n\u2019ko";
        final Object[][] data = new Object[][] {
            { "ksh", "k\u00f6lsch" },
            { "Ogam", "ogam" },
            { "mwl", "mirandeesi" },
            { "key.colStrength", "lajittelun taso" },
            { "Zsym", "symbolit" },
            { "cch", "atsam" },
            { "mwr", "marwari" },
            { "type.nu.lanatham", "taithamin tham-numerot" },
            { "egl", "emilia" },
            { "mwv", "mentawai" },
            { "Tagb", "tagbanwalainen" },
            { "%%NJIVA", "sloveenin resian Gnivan/Njivan alamurre" },
            { "xmf", "mingreli" },
            { "egy", "muinaisegypti" },
            { "raj", "rad\u017eastani" },
            { "Phag", "phags-pa" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "ter", "tereno" },
            { "AC", "Ascension-saari" },
            { "rar", "rarotonga" },
            { "tet", "tetum" },
            { "%%BARLA", "kapverdenkreolin barlaventolainen murreryhm\u00e4" },
            { "AD", "Andorra" },
            { "AE", "Arabiemiirikunnat" },
            { "nl_BE", "flaami" },
            { "AF", "Afganistan" },
            { "AG", "Antigua ja Barbuda" },
            { "type.ca.ethiopic", "etiopialainen kalenteri" },
            { "glk", "gilaki" },
            { "AI", "Anguilla" },
            { "key.tz", "aikavy\u00f6hyke" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "Teng", "tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentiina" },
            { "Prti", "piirtokirjoitusparthialainen" },
            { "AS", "Amerikan Samoa" },
            { "AT", "It\u00e4valta" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "amerikanenglanti" },
            { "AX", "Ahvenanmaa" },
            { "key.colNormalization", "lajittelun normalisointi" },
            { "mye", "myene" },
            { "AZ", "Azerbaid\u017ean" },
            { "%%AREVELA", "it\u00e4armenialainen" },
            { "BA", "Bosnia ja Hertsegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuano" },
            { "BD", "Bangladesh" },
            { "kum", "kumykki" },
            { "BE", "Belgia" },
            { "gmh", "keskiyl\u00e4saksa" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "kut", "kutenai" },
            { "myv", "ers\u00e4" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Karibian Alankomaat" },
            { "BR", "Brasilia" },
            { "BS", "Bahama" },
            { "xog", "soga" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet\u2019nsaari" },
            { "BW", "Botswana" },
            { "BY", "Valko-Ven\u00e4j\u00e4" },
            { "BZ", "Belize" },
            { "Visp", "n\u00e4kyv\u00e4 puhe" },
            { "type.ca.persian", "persialainen kalenteri" },
            { "type.nu.hebr", "heprealaiset numerot" },
            { "CA", "Kanada" },
            { "CC", "Kookossaaret (Keelingsaaret)" },
            { "mzn", "mazandarani" },
            { "CD", "Kongon demokraattinen tasavalta" },
            { "CF", "Keski-Afrikan tasavalta" },
            { "CG", "Kongon tasavalta" },
            { "CH", "Sveitsi" },
            { "CI", "Norsunluurannikko" },
            { "CK", "Cookinsaaret" },
            { "CL", "Chile" },
            { "Kthi", "kaithi" },
            { "CM", "Kamerun" },
            { "CN", "Kiina" },
            { "CO", "Kolumbia" },
            { "CP", "Clippertoninsaari" },
            { "CR", "Costa Rica" },
            { "CU", "Kuuba" },
            { "CV", "Kap Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Joulusaari" },
            { "CY", "Kypros" },
            { "type.nu.bali", "balilaiset numerot" },
            { "CZ", "T\u0161ekki" },
            { "eka", "ekajuk" },
            { "Ahom", "ahom" },
            { "Pauc", "zotuallai" },
            { "vls", "l\u00e4nsiflaami" },
            { "%%RIGIK", "klassinen volap\u00fck" },
            { "DE", "Saksa" },
            { "goh", "muinaisyl\u00e4saksa" },
            { "ace", "at\u0161eh" },
            { "cgg", "kiga" },
            { "DG", "Diego Garcia" },
            { "gom", "goankonkani" },
            { "type.nu.deva", "devanagarinumerot" },
            { "DJ", "Djibouti" },
            { "type.colNumeric.no", "numero-numerolta lajittelu" },
            { "DK", "Tanska" },
            { "ach", "at\u0161oli" },
            { "gon", "gondi" },
            { "Brai", "braille-pistekirjoitus" },
            { "Brah", "brahmi" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "armenialaiset piennumerot" },
            { "DO", "Dominikaaninen tasavalta" },
            { "gor", "gorontalo" },
            { "got", "gootti" },
            { "vmf", "maininfrankki" },
            { "Mtei", "meitei" },
            { "key.variableTop", "lajittelu symboleina" },
            { "zun", "zuni" },
            { "tig", "tigre" },
            { "Takr", "takri" },
            { "DZ", "Algeria" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "EA", "Ceuta ja Melilla" },
            { "chb", "t\u0161ibt\u0161a" },
            { "pam", "pampanga" },
            { "EC", "Ecuador" },
            { "pap", "papiamentu" },
            { "ada", "adangme" },
            { "EE", "Viro" },
            { "tiv", "tiv" },
            { "EG", "Egypti" },
            { "EH", "L\u00e4nsi-Sahara" },
            { "chg", "t\u0161agatai" },
            { "pau", "palau" },
            { "type.colNormalization.yes", "lajittelu Unicode-normalisoituna" },
            { "chk", "chuuk" },
            { "chn", "chinook-jargon" },
            { "chm", "mari" },
            { "chp", "chipewyan" },
            { "cho", "choctaw" },
            { "chr", "cherokee" },
            { "ER", "Eritrea" },
            { "ES", "Espanja" },
            { "ET", "Etiopia" },
            { "EU", "Euroopan unioni" },
            { "elx", "elami" },
            { "type.ca.gregorian", "gregoriaaninen kalenteri" },
            { "chy", "cheyenne" },
            { "type.nu.gujr", "gud\u017earatilaiset numerot" },
            { "Inds", "induslainen" },
            { "ady", "adyge" },
            { "aeb", "tunisianarabia" },
            { "FI", "Suomi" },
            { "FJ", "Fid\u017ei" },
            { "FK", "Falklandinsaaret" },
            { "FM", "Mikronesian liittovaltio" },
            { "key.va", "maavalinnan muunnelma" },
            { "FO", "F\u00e4rsaaret" },
            { "Taml", "tamililainen" },
            { "FR", "Ranska" },
            { "Kpel", metaValue_kpe },
            { "pcd", "picardi" },
            { "tkl", "tokelau" },
            { "grb", "grebo" },
            { "root", "juuri" },
            { "%%DAJNKO", "sloveenin Dajnko-aakkosto" },
            { "type.ca.indian", "intialainen kalenteri" },
            { "rgn", "romagnoli" },
            { "grc", "muinaiskreikka" },
            { "GA", "Gabon" },
            { "tkr", "tsahuri" },
            { "vot", "vatja" },
            { "GB", "Iso-Britannia" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Ranskan Guayana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "tailelainen" },
            { "GI", "Gibraltar" },
            { "afh", "afrihili" },
            { "GL", "Gr\u00f6nlanti" },
            { "enm", "keskienglanti" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "P\u00e4iv\u00e4ntasaajan Guinea" },
            { "GR", "Kreikka" },
            { "GS", "Etel\u00e4-Georgia ja Etel\u00e4iset Sandwichsaaret" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "pennsylvaniansaksa" },
            { "GW", "Guinea-Bissau" },
            { "tli", "tlingit" },
            { "tlh", "klingon" },
            { "Talu", "uusi tailuelainen" },
            { "GY", "Guyana" },
            { "ckb", "sorani" },
            { "zxx", "ei kielellist\u00e4 sis\u00e4lt\u00f6\u00e4" },
            { "Jurc", "d\u017eurt\u0161en" },
            { "tly", "tali\u0161i" },
            { "pdt", "plautdietsch" },
            { "de_AT", "it\u00e4vallansaksa" },
            { "HK", "Hongkong \u2013 Kiinan e.h.a." },
            { "Vaii", "vailainen" },
            { "HM", "Heard ja McDonaldinsaaret" },
            { "HN", "Honduras" },
            { "HR", "Kroatia" },
            { "agq", "aghem" },
            { "gsw", "sveitsinsaksa" },
            { "type.ca.islamic-umalqura", "islamilainen Umm al-Qura -kalenteri" },
            { "HT", "Haiti" },
            { "HU", "Unkari" },
            { "rif", "tarifit" },
            { "tmh", "tama\u0161ek" },
            { "IC", "Kanariansaaret" },
            { "nan", "min nan -kiina" },
            { "ID", "Indonesia" },
            { "peo", "muinaispersia" },
            { "type.nu.kali", "kayah li -numerot" },
            { "IE", "Irlanti" },
            { "nap", "napoli" },
            { "%%NDYUKA", "ndyukan kreolimurre" },
            { "naq", "nama" },
            { "type.nu.sora", "sora sompeng -numerot" },
            { "zza", "zaza" },
            { "Tang", "tangut" },
            { "IL", "Israel" },
            { "Nbat", "nabatealainen" },
            { "IM", "Mansaari" },
            { "IN", "Intia" },
            { "type.co.eor", "yleiseurooppalainen lajitteluj\u00e4rjestys" },
            { "IO", "Brittil\u00e4inen Intian valtameren alue" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islanti" },
            { "IT", "Italia" },
            { "Zmth", "matemaattinen" },
            { "type.nu.thai", "thainumerot" },
            { "vro", "v\u00f5ro" },
            { "guc", "wayuu" },
            { "%%POSIX", "tietokonem\u00e4\u00e4rittely POSIX" },
            { "type.nu.beng", "bengalilaiset numerot" },
            { "pfl", "pfaltsi" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "islamilainen kalenteri" },
            { "JM", "Jamaika" },
            { "Beng", "bengalilainen" },
            { "%%EKAVSK", "serbian ekavialainen \u00e4\u00e4nt\u00e4mys" },
            { "JO", "Jordania" },
            { "gur", "frafra" },
            { "JP", "Japani" },
            { "%%1606NICT", "my\u00f6h\u00e4iskeskiranska" },
            { "ain", "ainu" },
            { "%%KOCIEWIE", "puolan kociewielainen murre" },
            { "Mend", metaValue_men },
            { "guz", "gusii" },
            { "tog", "malawintonga" },
            { "type.nu.knda", "kannadalaiset numerot" },
            { "Kali", "kayah li" },
            { "Sidd", "siddham-tavukirjoitus" },
            { "de_CH", "sveitsinyl\u00e4saksa" },
            { "type.co.phonetic", "\u00e4\u00e4nteellinen j\u00e4rjestys" },
            { "izh", "inkeroinen" },
            { "type.ca.buddhist", "buddhalainen kalenteri" },
            { "KE", "Kenia" },
            { "419", "Latinalainen Amerikka" },
            { "KG", "Kirgisia" },
            { "KH", "Kambod\u017ea" },
            { "KI", "Kiribati" },
            { "KM", "Komorit" },
            { "KN", "Saint Kitts ja Nevis" },
            { "Knda", "kannadalainen" },
            { "Zinh", "peritty" },
            { "fr_CA", "kanadanranska" },
            { "KP", "Pohjois-Korea" },
            { "KR", "Etel\u00e4-Korea" },
            { "Plrd", "Pollardin foneettinen" },
            { "fr_CH", "sveitsinranska" },
            { "KW", "Kuwait" },
            { "tpi", "tok-pisin" },
            { "KY", "Caymansaaret" },
            { "KZ", "Kazakstan" },
            { "Cyrl", "kyrillinen" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "Saint Lucia" },
            { "phn", "foinikia" },
            { "Cyrs", "kyrillinen muinaiskirkkoslaavimuunnelma" },
            { "gwi", "gwit\u0161in" },
            { "%%LUNA1918", "ven\u00e4j\u00e4n ortografia 1918" },
            { "nds", "alasaksa" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "akkadi" },
            { "cop", "kopti" },
            { "LR", "Liberia" },
            { "esu", "alaskanjupik" },
            { "LS", "Lesotho" },
            { "Phlv", "kirjapahlavilainen" },
            { "LT", "Liettua" },
            { "LU", "Luxemburg" },
            { "LV", "Latvia" },
            { "Kana", "katakana" },
            { "Sora", "sorang sompeng" },
            { "LY", "Libya" },
            { "lad", "ladino" },
            { "vun", "vunjo" },
            { "akz", "alabama" },
            { "%%LAUKIKA", "klassinen sanskriitti" },
            { "lah", "lahnda" },
            { "Mahj", "mahajanilainen" },
            { "lag", "lango" },
            { "Thaa", "thaana" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "Nshu", "n\u00fcshu" },
            { "ME", "Montenegro" },
            { "MF", "Saint-Martin" },
            { "lam", "lamba" },
            { "MG", "Madagaskar" },
            { "MH", "Marshallinsaaret" },
            { "ale", "aleutti" },
            { "Thai", "thailainen" },
            { "type.nu.vaii", "vai-numerot" },
            { "MK", "Makedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "new", "newari" },
            { "MO", "Macao \u2013 Kiinan e.h.a." },
            { "aln", "geg" },
            { "MP", "Pohjois-Mariaanit" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "type.colAlternate.non-ignorable", "symbolit huomioiva lajittelu" },
            { "MT", "Malta" },
            { "cps", "capiznon" },
            { "MU", "Mauritius" },
            { "alt", "altai" },
            { "MV", "Malediivit" },
            { "MW", "Malawi" },
            { "MX", "Meksiko" },
            { "type.ca.japanese", "japanilainen kalenteri" },
            { "MY", "Malesia" },
            { "MZ", "Mosambik" },
            { "Phli", "piirtokirjoituspahlavilainen" },
            { "NA", "Namibia" },
            { "type.ca.hebrew", "juutalainen kalenteri" },
            { "type.co.dictionary", "sanakirjaj\u00e4rjestys" },
            { "NC", "Uusi-Kaledonia" },
            { "%%WADEGILE", "kiinan Wade-Giles-latinaistus" },
            { "tru", "turojo" },
            { "%%UCRCOR", "kornin uusittu yhten\u00e4iskirjoitus" },
            { "NE", "Niger" },
            { "NF", "Norfolkinsaari" },
            { "NG", "Nigeria" },
            { "trv", "taroko" },
            { "Phlp", "psalttaripahlavilainen" },
            { "NI", "Nicaragua" },
            { "Hmng", "pahawh hmong" },
            { "NL", "Alankomaat" },
            { "NO", "Norja" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "tsd", "tsakonia" },
            { "NU", "Niue" },
            { "Phnx", "foinikialainen" },
            { "rof", "rombo" },
            { "tsi", "tsim\u0161i" },
            { "NZ", "Uusi-Seelanti" },
            { "Merc", "meroiittinen kursiivikirjoitus" },
            { "rom", "romani" },
            { "Mero", "meroiittinen" },
            { "crh", "krimintataari" },
            { "type.colAlternate.shifted", "symbolit ohittava lajittelu" },
            { "ang", "muinaisenglanti" },
            { "OM", "Oman" },
            { "%%PETR1708", "ven\u00e4j\u00e4n Pietarin siviiliaakkosto 1708" },
            { "anp", "angika" },
            { "Xpeo", "muinaispersialainen" },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "islamilainen siviilikalenteri, perjantai-epookki" },
            { "csb", "ka\u0161ubi" },
            { "en_GB", "britannianenglanti" },
            { "PE", "Peru" },
            { "ttt", "tati" },
            { "PF", "Ranskan Polynesia" },
            { "PG", "Papua-Uusi-Guinea" },
            { "PH", "Filippiinit" },
            { "PK", "Pakistan" },
            { "PL", "Puola" },
            { "ewo", "ewondo" },
            { "PM", "Saint-Pierre ja Miquelon" },
            { "PN", "Pitcairn" },
            { "type.colBackwards.yes", "painomerkkien k\u00e4\u00e4nteinen lajittelu" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestiinalaisalueet" },
            { "Bali", "balilainen" },
            { "PT", "Portugali" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "type.nu.greklow", "kreikkalaiset piennumerot" },
            { "PY", "Paraguay" },
            { "tum", "tumbuka" },
            { "Hebr", "heprealainen" },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "skotlanninenglanti" },
            { "jam", "jamaikankreolienglanti" },
            { "pms", "piemonte" },
            { "niu", "niue" },
            { "QO", "ulkomeri" },
            { "ext", "extremadura" },
            { "lez", "lezgi" },
            { "%%FONUPA", "uralilainen foneettinen aakkosto UPA" },
            { "type.nu.takr", "takri-numerot" },
            { "tvl", "tuvalu" },
            { "Tavt", "tai viet" },
            { "%%SOTAV", "kapverdenkreolin sotaventolainen murreryhm\u00e4" },
            { "001", "maailma" },
            { "002", "Afrikka" },
            { "njo", "ao naga" },
            { "003", "Pohjois-Amerikka" },
            { "RE", "R\u00e9union" },
            { "type.colNormalization.no", "lajittelu ilman normalisoinrtia" },
            { "005", "Etel\u00e4-Amerikka" },
            { "lfn", "lingua franca nova" },
            { "jbo", "lojban" },
            { "pnt", "pontoksenkreikka" },
            { "Rjng", "rejang" },
            { "009", "Oseania" },
            { "%%SURSILV", "retoromaanin sursilvan-muoto" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "Mroo", "mro" },
            { "RU", "Ven\u00e4j\u00e4" },
            { "RW", "Ruanda" },
            { "type.nu.talu", "uudet tai lue -numerot" },
            { "%%METELKO", "sloveenin Metelko-aakkosto" },
            { "Mani", "manikealainen" },
            { "Ugar", "ugaritilainen" },
            { "key.colAlternate", "symbolien lajittelu" },
            { "Khar", "kharosthi" },
            { "SA", "Saudi-Arabia" },
            { "pon", "pohnpei" },
            { "Mand", "mandealainen" },
            { "SB", "Salomonsaaret" },
            { "twq", "tasawaq" },
            { "011", "L\u00e4nsi-Afrikka" },
            { "SC", "Seychellit" },
            { "SD", "Sudan" },
            { "013", "V\u00e4li-Amerikka" },
            { "SE", "Ruotsi" },
            { "014", "It\u00e4-Afrikka" },
            { "arc", "valtakunnanaramea" },
            { "Loma", "loma" },
            { "015", "Pohjois-Afrikka" },
            { "SG", "Singapore" },
            { "SH", "Saint Helena" },
            { "type.lb.strict", "tarkka rivinvaihto" },
            { "017", "Keski-Afrikka" },
            { "SI", "Slovenia" },
            { "018", "etel\u00e4inen Afrikka" },
            { "SJ", "Huippuvuoret ja Jan Mayen" },
            { "Bamu", metaValue_bax },
            { "019", "Amerikka" },
            { "SK", "Slovakia" },
            { "Wole", "woleai" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "mapudungun" },
            { "arp", "arapaho" },
            { "type.nu.taml", "perinteiset tamilinumerot" },
            { "SR", "Surinam" },
            { "aro", "araona" },
            { "SS", "Etel\u00e4-Sudan" },
            { "ST", "S\u00e3o Tom\u00e9 ja Pr\u00edncipe" },
            { "arq", "algerianarabia" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syyria" },
            { "yao", "jao" },
            { "SZ", "Swazimaa" },
            { "arw", "arawak" },
            { "arz", "egyptinarabia" },
            { "ary", "marokonarabia" },
            { "yap", "japi" },
            { "rtm", "rotuma" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "type.ms.ussystem", "yhdysvaltalainen mittaj\u00e4rjestelm\u00e4" },
            { "021", "pohjoinen Amerikka" },
            { "TC", "Turks- ja Caicossaaret" },
            { "yav", "yangben" },
            { "TD", "T\u0161ad" },
            { "TF", "Ranskan etel\u00e4iset alueet" },
            { "ase", "amerikkalainen viittomakieli" },
            { "TG", "Togo" },
            { "TH", "Thaimaa" },
            { "TJ", "Tad\u017eikistan" },
            { "029", "Karibia" },
            { "TK", "Tokelau" },
            { "TL", "It\u00e4-Timor" },
            { "ybb", "yemba" },
            { "type.co.searchjl", "haku hangul-alkukonsonantin mukaan" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "englannin boontling-murre" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "%%NULIK", "nykyvolap\u00fck" },
            { "TR", "Turkki" },
            { "TT", "Trinidad ja Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "asturia" },
            { "rue", "ruteeni" },
            { "rug", "roviana" },
            { "Orkh", "orkhon" },
            { "TZ", "Tansania" },
            { "nmg", "kwasio" },
            { "Zzzz", "tuntematon kirjoitusj\u00e4rjestelm\u00e4" },
            { "Sind", "khudabadi" },
            { "UA", "Ukraina" },
            { "lij", "liguuri" },
            { "rup", "aromania" },
            { "030", "It\u00e4-Aasia" },
            { "tyv", "tuva" },
            { "sw_CD", "kingwana" },
            { "034", "Etel\u00e4-Aasia" },
            { "hai", "haida" },
            { "035", "Kaakkois-Aasia" },
            { "UG", "Uganda" },
            { "hak", "hakka-kiina" },
            { "type.co.pinyin", "pinyin-j\u00e4rjestys" },
            { "type.colHiraganaQuaternary.yes", "kana-merkkien lajittelu tyypin mukaan" },
            { "039", "Etel\u00e4-Eurooppa" },
            { "Sinh", "sinhalilainen" },
            { "UM", "Yhdysvaltain erillissaaret" },
            { "liv", "liivi" },
            { "US", "Yhdysvallat" },
            { "haw", "havaiji" },
            { "%%1959ACAD", "valkoven\u00e4j\u00e4n virallinen oikeinkirjoitus" },
            { "type.co.gb2312han", "yksinkertaistettu kiinalainen j\u00e4rjestys GB2312" },
            { "UY", "Uruguay" },
            { "prg", "muinaispreussi" },
            { "UZ", "Uzbekistan" },
            { "tzm", "keskiatlaksentamazight" },
            { "type.co.stroke", "piirtoj\u00e4rjestys" },
            { "nnh", "ngiemboon" },
            { "VA", "Vatikaani" },
            { "pro", "muinaisprovensaali" },
            { "VC", "Saint Vincent ja Grenadiinit" },
            { "VE", "Venezuela" },
            { "VG", "Brittil\u00e4iset Neitsytsaaret" },
            { "VI", "Yhdysvaltain Neitsytsaaret" },
            { "VN", "Vietnam" },
            { "type.colBackwards.no", "painomerkkien normaali lajittelu" },
            { "VU", "Vanuatu" },
            { "nog", "nogai" },
            { "rwk", "rwa" },
            { "non", "muinaisnorja" },
            { "053", "Australaasia" },
            { "%%AREVMDA", "l\u00e4nsiarmenialainen" },
            { "054", "Melanesia" },
            { "WF", "Wallis ja Futuna" },
            { "type.co.traditional", "perinteinen j\u00e4rjestys" },
            { "057", "Mikronesia" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "nov", "novial" },
            { "type.nu.finance", "talousnumerot" },
            { "avk", "kotava" },
            { "%%HEPBURN", "japanin Hepburn-latinaistus" },
            { "type.co.compat", "aiempi lajitteluj\u00e4rjestys yhteensopivuutta varten" },
            { "wae", "walser" },
            { "WS", "Samoa" },
            { "Bass", "bassa" },
            { "type.nu.mtei", "meetei mayek -numerot" },
            { "wal", "wolaitta" },
            { "was", "washo" },
            { "war", "waray" },
            { "awa", "awadhi" },
            { "061", "Polynesia" },
            { "%%KSCOR", "kornin standardikirjoitus" },
            { "XK", "Kosovo" },
            { "type.nu.brah", "brahmilaiset numerot" },
            { "Gujr", "gud\u017earatilainen" },
            { "Zxxx", "kirjoittamaton" },
            { "Olck", "ol chiki" },
            { "wbp", "warlpiri" },
            { "Batk", "batakilainen" },
            { "Blis", "bliss-symbolit" },
            { "YE", "Jemen" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "normaalij\u00e4rjestys" },
            { "lmo", "lombardi" },
            { "fan", "fang" },
            { "%%BALANKA", "aniin balankalaismurre" },
            { "%%ROZAJ", "sloveenin resian murre" },
            { "%%SUTSILV", "retoromaanin sutsilvan-muoto" },
            { "fat", "fanti" },
            { "Sgnw", "SignWriting" },
            { "YT", "Mayotte" },
            { "type.nu.cham", "cham-numerot" },
            { "ZA", "Etel\u00e4-Afrikka" },
            { "type.nu.sund", "sundalaiset numerot" },
            { "type.lb.loose", "v\u00e4lj\u00e4 rivinvaihto" },
            { "Deva", "devanagari" },
            { "type.nu.geor", "georgialaiset numerot" },
            { "type.co.zhuyin", "zhuyin-j\u00e4rjestys" },
            { "Hira", "hiragana" },
            { "ZM", "Sambia" },
            { "%%PINYIN", "kiinan pinyin-latinaistus" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "tuntematon alue" },
            { "Runr", "riimukirjoitus" },
            { "type.ms.metric", "metrij\u00e4rjestelm\u00e4" },
            { "type.ca.iso8601", "ISO 8601 -kalenteri" },
            { "lol", "mongo" },
            { "nso", "pohjoissotho" },
            { "type.nu.telu", "telugulaiset numerot" },
            { "loz", "lozi" },
            { "Nkgb", "naxi geba" },
            { "type.colHiraganaQuaternary.no", "kana-merkkien lajittelu erillisin\u00e4" },
            { "jmc", "machame" },
            { "hif", "fid\u017einhindi" },
            { "type.nu.hansfin", "yksinkertaistetut kiinalaiset talousnumerot" },
            { "type.colStrength.secondary", "painomerkit huomioiva lajittelu" },
            { "hil", "hiligaino" },
            { "type.nu.arabext", "laajennetut arabialaiset numerot" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "type.nu.fullwide", "ideografin levyiset numerot" },
            { "hit", "heetti" },
            { "dar", "dargi" },
            { "dav", "taita" },
            { "Maya", "maya-hieroglyfit" },
            { "lrc", "pohjoisluri" },
            { "type.co.emoji", "emojien lajitteluj\u00e4rjestys" },
            { "Copt", "koptilainen" },
            { "nwc", "klassinen newari" },
            { "udm", "udmurtti" },
            { "Khmr", "khmeril\u00e4inen" },
            { "type.ca.islamic-rgsa", "islamilainen saudiarabialainen kalenteri" },
            { "Limb", "limbulainen" },
            { "sad", "sandawe" },
            { "type.nu.roman", "roomalaiset numerot" },
            { "sah", "jakuutti" },
            { "type.nu.shrd", "\u0161arida-numerot" },
            { "ltg", "latgalli" },
            { "sam", "samarianaramea" },
            { "Aghb", "kaukasianalbanialainen" },
            { "%%SCOUSE", "englannin scouse-murre" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "Tfng", "tifinagh" },
            { "jpr", "juutalaispersia" },
            { "saz", "saura\u0161tri" },
            { "type.nu.native", "kielen omat numerot" },
            { "sba", "ngambay" },
            { "Guru", "gurmukhi" },
            { "%%ALUKU", "alukun kreolimurre" },
            { "lua", "luluanluba" },
            { "%%BISCAYAN", "baskin biskajalaismurre" },
            { "sbp", "sangu" },
            { "lui", "luise\u00f1o" },
            { "nyn", "nyankole" },
            { "nym", "nyamwezi" },
            { "lun", "lunda" },
            { "nyo", "nyoro" },
            { "luo", "luo" },
            { "fil", "filipino" },
            { "hmn", "hmong" },
            { "del", "delaware" },
            { "lus", "lusai" },
            { "bal", "belut\u0161i" },
            { "den", "slevi" },
            { "ban", "bali" },
            { "uga", "ugarit" },
            { "fit", "me\u00e4nkieli" },
            { "luy", "luhya" },
            { "bar", "baijeri" },
            { "bas", "basaa" },
            { "bax", metaValue_bax },
            { "jrb", "juutalaisarabia" },
            { "es_ES", "euroopanespanja" },
            { "nzi", "nzima" },
            { "sco", "skotti" },
            { "scn", "sisilia" },
            { "aa", "afar" },
            { "ab", "abhaasi" },
            { "bbc", "batak-toba" },
            { "key.colCaseFirst", "isojen ja pienten kirjainten j\u00e4rjestys" },
            { "ae", "avesta" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "type.nu.cakm", "chakmalaiset numerot" },
            { "bbj", "ghomala" },
            { "am", "amhara" },
            { "an", "aragonia" },
            { "Arab", "arabialainen" },
            { "%%SOLBA", "sloveenin resian Stolvizzan/Solbican alamurre" },
            { "Jpan", "japanilainen" },
            { "ar", "arabia" },
            { "Hrkt", "hiragana tai katakana" },
            { "as", "assami" },
            { "sdc", "sassarinsardi" },
            { "Lina", "lineaari-A" },
            { "av", "avaari" },
            { "Linb", "lineaari-B" },
            { "sdh", "etel\u00e4kurdi" },
            { "ay", "aimara" },
            { "az", "azeri" },
            { "Khoj", "khojki" },
            { "%%OSOJS", "sloveenin resian Oseaccon/Osojanen alamurre" },
            { "%%UNIFON", "englannin foneeminen unifon-aakkosto" },
            { "ba", "ba\u0161kiiri" },
            { "type.co.unihan", "radikaali- ja piirtoj\u00e4rjestys" },
            { "be", "valkoven\u00e4j\u00e4" },
            { "bg", "bulgaria" },
            { "bi", "bislama" },
            { "type.nu.java", "jaavalaiset numerot" },
            { "bm", "bambara" },
            { "bn", "bengali" },
            { "bo", "tiibet" },
            { "dgr", "dogrib" },
            { "br", "bretoni" },
            { "bs", "bosnia" },
            { "see", "seneca" },
            { "Mymr", "burmalainen" },
            { "sei", "seri" },
            { "type.nu.laoo", "laolaiset numerot" },
            { "seh", "sena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "selkuppi" },
            { "ca", "katalaani" },
            { "ses", "koyraboro senni" },
            { "ce", "t\u0161et\u0161eeni" },
            { "ch", "t\u0161amorro" },
            { "%%REVISED", "uudistettu oikeinkirjoitus" },
            { "co", "korsika" },
            { "Orya", "orijalainen" },
            { "cr", "cree" },
            { "cs", "t\u0161ekki" },
            { "cu", "kirkkoslaavi" },
            { "yrl", "\u00f1eengat\u00fa" },
            { "cv", "t\u0161uvassi" },
            { "cy", "kymri" },
            { "type.nu.ethi", "etiopialaiset numerot" },
            { "Yiii", "yil\u00e4inen" },
            { "da", "tanska" },
            { "pt_PT", "euroopanportugali" },
            { "de", "saksa" },
            { "bej", "bed\u017ea" },
            { "din", "dinka" },
            { "jut", "juutti" },
            { "Bugi", "bugilainen" },
            { "bem", "bemba" },
            { "sga", "muinaisiiri" },
            { "type.nu.mong", "mongolialaiset numerot" },
            { "dv", "divehi" },
            { "es_419", "amerikanespanja" },
            { "bew", "betawi" },
            { "dz", "dzongkha" },
            { "bez", "bena" },
            { "type.ca.chinese", "kiinalainen kalenteri" },
            { "lzh", "klassinen kiina" },
            { "Lisu", "Fraserin aakkoset" },
            { "dje", "djerma" },
            { "sgs", "samogiitti" },
            { "type.nu.grek", "kreikkalaiset numerot" },
            { "ee", "ewe" },
            { "bfd", "fut" },
            { "type.lb.normal", "normaali rivinvaihto" },
            { "ro_MD", "moldova" },
            { "el", "kreikka" },
            { "en", "englanti" },
            { "eo", "esperanto" },
            { "bfq", "badaga" },
            { "lzz", "lazi" },
            { "type.co.big5han", "perinteinen kiinalainen j\u00e4rjestys Big5" },
            { "es", "espanja" },
            { "et", "viro" },
            { "eu", "baski" },
            { "Buhd", "buhidilainen" },
            { "Hang", "hangul" },
            { "Samr", "samarianaramealainen" },
            { "shi", "ta\u0161elhit" },
            { "hsb", "yl\u00e4sorbi" },
            { "Hani", "kiinalainen han" },
            { "%%ULSTER", "skotin ulster-murre" },
            { "shn", "shan" },
            { "Hano", "hanunoolainen" },
            { "fa", "farsi" },
            { "Hans", "yksinkertaistettu han" },
            { "type.nu.latn", "l\u00e4nsimaiset numerot" },
            { "Hant", "perinteinen han" },
            { "ff", "fulani" },
            { "shu", "t\u0161adinarabia" },
            { "hsn", "xiang-kiina" },
            { "fi", "suomi" },
            { "fj", "fid\u017ei" },
            { "fon", "fon" },
            { "bgn", "l\u00e4nsibelut\u0161i" },
            { "yue", "kantoninkiina" },
            { "fo", "f\u00e4\u00e4ri" },
            { "umb", "mbundu" },
            { "fr", "ranska" },
            { "sid", "sidamo" },
            { "fy", "l\u00e4nsifriisi" },
            { "ga", "iiri" },
            { "gd", "gaeli" },
            { "key.colCaseLevel", "aakkoslajien lajittelu" },
            { "gl", "galicia" },
            { "gn", "guarani" },
            { "bho", "bhod\u017epuri" },
            { "und", "m\u00e4\u00e4ritt\u00e4m\u00e4t\u00f6n kieli" },
            { "type.ca.ethiopic-amete-alem", "etiopialainen amete alem -kalenteri" },
            { "gu", "gud\u017earati" },
            { "type.ca.islamic-tbla", "islamilainen matemaattinen kalenteri, torstai-epookki" },
            { "gv", "manksi" },
            { "type.nu.osma", "osmanjalaiset numerot" },
            { "ha", "hausa" },
            { "he", "heprea" },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "ho", "hiri-motu" },
            { "hr", "kroatia" },
            { "ht", "haiti" },
            { "hu", "unkari" },
            { "hy", "armenia" },
            { "hz", "herero" },
            { "frc", "cajun" },
            { "%%FONIPA", "kansainv\u00e4linen foneettinen aakkosto IPA" },
            { "ia", "interlingua" },
            { "id", "indonesia" },
            { "type.nu.tibt", "tiibetil\u00e4iset numerot" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "sichuanin-yi" },
            { "frm", "keskiranska" },
            { "%%RUMGR", "retoromaanin rumantsch grischun -muoto" },
            { "ik", "inupiaq" },
            { "fro", "muinaisranska" },
            { "frp", "arpitaani" },
            { "io", "ido" },
            { "frs", "it\u00e4friisi" },
            { "bjn", "banjar" },
            { "frr", "pohjoisfriisi" },
            { "is", "islanti" },
            { "it", "italia" },
            { "iu", "inuktitut" },
            { "sli", "sleesiansaksa" },
            { "%%HOGNORSK", "norjan h\u00f6gnorsk" },
            { "ja", "japani" },
            { "Mlym", "malajalamilainen" },
            { "Sarb", "muinaisetel\u00e4arabialainen" },
            { "Sara", "sarati" },
            { "doi", "dogri" },
            { "sly", "selayar" },
            { "type.nu.lepc", "lepchanumerot" },
            { "bkm", "kom" },
            { "sma", "etel\u00e4saame" },
            { "jv", "jaava" },
            { "Shaw", "shaw\u2019lainen" },
            { "%%BAUDDHA", "sanskriitin buddhalainen sekamuoto" },
            { "mad", "madura" },
            { "smj", "luulajansaame" },
            { "mag", "magahi" },
            { "maf", "mafa" },
            { "mai", "maithili" },
            { "smn", "inarinsaame" },
            { "ka", "georgia" },
            { "bla", "siksika" },
            { "mak", "makassar" },
            { "wuu", "wu-kiina" },
            { "sms", "koltansaame" },
            { "man", "mandingo" },
            { "kg", "kongo" },
            { "Goth", "goottilainen" },
            { "ki", "kikuju" },
            { "mas", "maasai" },
            { "kj", "kuanjama" },
            { "kk", "kazakki" },
            { "kl", "kalaallisut" },
            { "km", "khmer" },
            { "kn", "kannada" },
            { "type.colStrength.identical", "kaikkien merkkien lajittelu" },
            { "ko", "korea" },
            { "kr", "kanuri" },
            { "ks", "ka\u0161miri" },
            { "Cirt", "cirth" },
            { "Lepc", "lepchalainen" },
            { "Avst", "avestalainen" },
            { "ku", "kurdi" },
            { "kv", "komi" },
            { "kw", "korni" },
            { "ky", "kirgiisi" },
            { "snk", "soninke" },
            { "type.colStrength.primary", "vain peruskirjainten lajittelu" },
            { "Mult", "multanilainen" },
            { "la", "latina" },
            { "Hatr", "hatralainen" },
            { "lb", "luxemburg" },
            { "type.nu.mlym", "malajalamilaiset numerot" },
            { "lg", "ganda" },
            { "Roro", "rongorongo" },
            { "li", "limburg" },
            { "Tibt", "tiibetil\u00e4inen" },
            { "ln", "lingala" },
            { "fur", "friuli" },
            { "type.colCaseLevel.no", "isojen ja pienten kirjainten lajittelu yhdess\u00e4" },
            { "lo", "lao" },
            { "type.ms.uksystem", "brittil\u00e4inen mittaj\u00e4rjestelm\u00e4" },
            { "type.colStrength.tertiary", "painomerkit ja aakkoslajit tai merkkileveydet huomioiva lajittelu" },
            { "type.nu.lana", "taithamin hora-numerot" },
            { "lt", "liettua" },
            { "lu", "katanganluba" },
            { "lv", "latvia" },
            { "sog", "sogdi" },
            { "mg", "malagassi" },
            { "mh", "marshall" },
            { "type.co.ducet", "Unicoden oletusj\u00e4rjestys" },
            { "mi", "maori" },
            { "mk", "makedonia" },
            { "ml", "malajalam" },
            { "mn", "mongoli" },
            { "mr", "marathi" },
            { "ms", "malaiji" },
            { "mt", "malta" },
            { "my", "burma" },
            { "Saur", "saurashtra" },
            { "Armn", "armenialainen" },
            { "mdf", "mok\u0161a" },
            { "mde", "maba" },
            { "dsb", "alasorbi" },
            { "Armi", "valtakunnanaramealainen" },
            { "na", "nauru" },
            { "type.co.search", "yleishakuj\u00e4rjestys" },
            { "nb", "norjan bokm\u00e5l" },
            { "nd", "pohjois-ndebele" },
            { "ne", "nepali" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "hollanti" },
            { "nn", "norjan nynorsk" },
            { "no", "norja" },
            { "nr", "etel\u00e4-ndebele" },
            { "nv", "navajo" },
            { "kaa", "karakalpakki" },
            { "ny", "njand\u017ea" },
            { "kac", "kat\u0161in" },
            { "kab", "kabyyli" },
            { "%%POLYTON", "polytoninen kreikka" },
            { "type.colCaseFirst.lower", "pienet kirjaimet edelt\u00e4v\u00e4t isoja" },
            { "oc", "oksitaani" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", metaValue_men },
            { "%%EMODENG", "varhaisnykyenglanti" },
            { "oj", "od\u017eibwa" },
            { "mer", "meru" },
            { "type.nu.armn", "armenialaiset numerot" },
            { "om", "oromo" },
            { "kaw", "kavi" },
            { "dtp", "dusun" },
            { "or", "orija" },
            { "Modi", "modi-aakkoset" },
            { "os", "osseetti" },
            { "%%ALALC97", "amerikkalainen kirjastolatinaistus 1997" },
            { "bpy", "bi\u0161nupria" },
            { "kbd", "kabardi" },
            { "mfe", "morisyen" },
            { "srn", "sranan" },
            { "pa", "pand\u017eabi" },
            { "dua", "duala" },
            { "srr", "serer" },
            { "%%LIPAW", "sloveenin resian Lipovazin/Lipovecin alamurre" },
            { "kbl", "kanembu" },
            { "pi", "paali" },
            { "bqi", "bahtiari" },
            { "pl", "puola" },
            { "dum", "keskihollanti" },
            { "type.nu.saur", "saurashtra-numerot" },
            { "type.ca.dangi", "dangilainen kalenteri" },
            { "%%VALLADER", "reoromaanin vallader-muoto" },
            { "ps", "pa\u0161tu" },
            { "pt", "portugali" },
            { "mga", "keski-iiri" },
            { "key.co", "lajitteluj\u00e4rjestys" },
            { "pt_BR", "brasilianportugali" },
            { "%%BOHORIC", "sloveenin Bohori\u010d-aakkosto" },
            { "kcg", "tyap" },
            { "mgh", "makua-meetto" },
            { "type.nu.nkoo", "n\u2019ko-numerot" },
            { "bra", "brad\u017e" },
            { "key.ca", "kalenteri" },
            { "%%JAUER", "retoromaanin jauer-murre" },
            { "Laoo", "laolainen" },
            { "%%SURMIRAN", "retoromaanin surmiran-muoto" },
            { "mgo", "meta\u2019" },
            { "type.hc.h23", "24 tunnin j\u00e4rjestelm\u00e4 (0\u201323)" },
            { "type.hc.h24", "24 tunnin j\u00e4rjestelm\u00e4 (1\u201324)" },
            { "ssy", "saho" },
            { "brh", "brahui" },
            { "type.nu.mymr", "burmalaiset numerot" },
            { "qu", "ket\u0161ua" },
            { "zap", "zapoteekki" },
            { "brx", "bodo" },
            { "Lana", "lanna" },
            { "kde", "makonde" },
            { "%%VAIDIKA", "sanskriitin veda-murre" },
            { "stq", "saterlandinfriisi" },
            { "Ethi", "etiopialainen" },
            { "%%JYUTPING", "kantoninkiinan jyutping-latinaistus" },
            { "type.hc.h12", "12 tunnin j\u00e4rjestelm\u00e4 (1\u201312)" },
            { "type.hc.h11", "12 tunnin j\u00e4rjestelm\u00e4 (0\u201311)" },
            { "rm", "retoromaani" },
            { "rn", "rundi" },
            { "key.cu", "valuutta" },
            { "ro", "romania" },
            { "%%SAAHO", "afarin saho-murre" },
            { "type.nu.orya", "orijalaiset numerot" },
            { "type.nu.hanidec", "kiinalaiset desimaalinumerot" },
            { "ru", "ven\u00e4j\u00e4" },
            { "bss", "koose" },
            { "rw", "ruanda" },
            { "zbl", "blisskieli" },
            { "kea", "kapverdenkreoli" },
            { "mic", "micmac" },
            { "suk", "sukuma" },
            { "en_AU", "australianenglanti" },
            { "Dupl", "Duploy\u00e9n pikakirjoitus" },
            { "sa", "sanskrit" },
            { "%%UCCOR", "kornin yhten\u00e4iskirjoitus" },
            { "sc", "sardi" },
            { "sus", "susu" },
            { "sd", "sindhi" },
            { "se", "pohjoissaame" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "sh", "serbokroaatti" },
            { "ken", "kenyang" },
            { "si", "sinhala" },
            { "sux", "sumeri" },
            { "sk", "slovakki" },
            { "sl", "sloveeni" },
            { "Gran", "grantha" },
            { "sm", "samoa" },
            { "sn", "\u0161ona" },
            { "so", "somali" },
            { "type.nu.arab", "arabialaiset numerot" },
            { "sq", "albania" },
            { "sr", "serbia" },
            { "ss", "swazi" },
            { "st", "etel\u00e4sotho" },
            { "Java", "jaavalainen" },
            { "su", "sunda" },
            { "%%NEDIS", "sloveenin natisonen murre" },
            { "sv", "ruotsi" },
            { "sw", "swahili" },
            { "type.nu.hantfin", "perinteiset kiinalaiset talousnumerot" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", "tamili" },
            { "142", "Aasia" },
            { "bua", "burjaatti" },
            { "143", "Keski-Aasia" },
            { "te", "telugu" },
            { "145", "L\u00e4nsi-Aasia" },
            { "tg", "tad\u017eikki" },
            { "th", "thai" },
            { "ti", "tigrinja" },
            { "bug", "bugi" },
            { "kfo", "norsunluurannikonkoro" },
            { "type.colNumeric.yes", "numeroden lajittelu lukuina" },
            { "en_CA", "kanadanenglanti" },
            { "tk", "turkmeeni" },
            { "tl", "tagalog" },
            { "tn", "tswana" },
            { "to", "tonga" },
            { "bum", "bulu" },
            { "dyo", "jola-fonyi" },
            { "type.nu.jpan", "japanilaiset numerot" },
            { "tr", "turkki" },
            { "ts", "tsonga" },
            { "swb", "komori" },
            { "Cakm", "chakmalainen" },
            { "tt", "tataari" },
            { "dyu", "djula" },
            { "tw", "twi" },
            { "ty", "tahiti" },
            { "%%BISKE", "sloveenin resian San Giorgion/Bilan alamurre" },
            { "150", "Eurooppa" },
            { "key.colHiraganaQuaternary", "kana-merkkien lajittelu" },
            { "151", "It\u00e4-Eurooppa" },
            { "154", "Pohjois-Eurooppa" },
            { "dzg", "dazaga" },
            { "155", "L\u00e4nsi-Eurooppa" },
            { "ug", "uiguuri" },
            { "Ital", "muinaisitalialainen" },
            { "Kore", "korealainen" },
            { "kgp", "kaingang" },
            { "Zyyy", "m\u00e4\u00e4ritt\u00e4m\u00e4t\u00f6n" },
            { "uk", "ukraina" },
            { "zea", "seelanti" },
            { "type.colCaseFirst.no", "isojen ja pienten kirjainten normaalij\u00e4rjestys" },
            { "type.colStrength.quaternary", "painomerkit ja aakkoslajit tai merkkileveydet ja kana-merkit huomioiva lajittelu" },
            { "type.ca.coptic", "koptilainen kalenteri" },
            { "ur", "urdu" },
            { "%%1994", "sloveenin resian murteen yhdenmukaistettu oikeinkirjoitus" },
            { "xal", "kalmukki" },
            { "zen", "zenaga" },
            { "uz", "uzbekki" },
            { "kha", "khasi" },
            { "%%1996", "saksan uusi oikeinkirjoitus" },
            { "nds_NL", "alankomaidenalasaksa" },
            { "Sylo", "syloti nagri" },
            { "ve", "venda" },
            { "Wara", "varang kshiti" },
            { "type.ca.roc", "Kiinan tasavallan kalenteri" },
            { "vi", "vietnam" },
            { "kho", "khotani" },
            { "khq", "koyra chiini" },
            { "key.hc", "tuntij\u00e4rjestelm\u00e4" },
            { "%%TARASK", "valkoven\u00e4j\u00e4n tara\u0161kevitsa-oikeinkirjoitus" },
            { "vo", "volap\u00fck" },
            { "key.x", "yksityisk\u00e4ytt\u00f6" },
            { "khw", "khowar" },
            { "syc", "muinaissyyria" },
            { "Osma", "osmanjalainen" },
            { "quc", "k\u02bciche\u02bc" },
            { "qug", "chimborazonyl\u00e4nk\u00f6ket\u0161ua" },
            { "gaa", "ga" },
            { "wa", "valloni" },
            { "gag", "gagauzi" },
            { "syr", "syyria" },
            { "Grek", "kreikkalainen" },
            { "gan", "gan-kiina" },
            { "kiu", "kirmanjki" },
            { "Lydi", "lyydialainen" },
            { "Xsux", "sumerilais-akkadilainen nuolenp\u00e4\u00e4kirjoitus" },
            { "wo", "wolof" },
            { "zgh", "vakioitu tamazight" },
            { "ar_001", "yleisarabia" },
            { "Cans", "kanadalaisten alkuper\u00e4iskansojen yhten\u00e4istetty tavukirjoitus" },
            { "%%FONXSAMP", "foneettinen X-SAMPA-merkist\u00f6" },
            { "gay", "gajo" },
            { "key.colNumeric", "numeroiden lajittelu" },
            { "Mong", "mongolilainen" },
            { "mnc", "mant\u0161u" },
            { "Latf", "latinalainen fraktuuramuunnelma" },
            { "szl", "sleesia" },
            { "Hluw", "anatolialaiset hieroglyfit" },
            { "gba", "gbaja" },
            { "mni", "manipuri" },
            { "Latn", "latinalainen" },
            { "Latg", "latinalainen gaelimuunnelma" },
            { "type.nu.hans", "yksinkertaistetut kiinalaiset numerot" },
            { "type.nu.hant", "perinteiset kiinalaiset numerot" },
            { "xh", "xhosa" },
            { "type.nu.romanlow", "roomalaiset piennumerot" },
            { "byn", "bilin" },
            { "%%PAMAKA", "pamakan kreolimurre" },
            { "Lyci", "lyykialainen" },
            { "osa", "osage" },
            { "byv", "medumba" },
            { "gbz", "zoroastrialaisdari" },
            { "Moon", "moon-kohokirjoitus" },
            { "moh", "mohawk" },
            { "kkj", "kako" },
            { "%%1694ACAD", "varhaisnykyranska" },
            { "yi", "jiddi\u0161" },
            { "mos", "mossi" },
            { "Syrc", "syyrialainen" },
            { "Dsrt", "deseret" },
            { "yo", "joruba" },
            { "type.nu.traditional", "perinteiset numerot" },
            { "es_MX", "meksikonespanja" },
            { "Syrj", "syyrialainen l\u00e4ntinen muunnelma" },
            { "ota", "osmani" },
            { "Syre", "syyrialainen estrangelo-muunnelma" },
            { "vai", "vai" },
            { "za", "zhuang" },
            { "Cari", "kaarialainen" },
            { "kln", "kalenjin" },
            { "zh", "kiina" },
            { "Afak", "afaka" },
            { "Bopo", "bopomofo" },
            { "Perm", "muinaispermil\u00e4inen" },
            { "key.lb", "rivinvaihtotyyli" },
            { "zu", "zulu" },
            { "type.co.phonebook", "puhelinluetteloj\u00e4rjestys" },
            { "%%MONOTON", "monotoninen kreikka" },
            { "Geor", "georgialainen" },
            { "Shrd", "\u0161arada" },
            { "kmb", "kimbundu" },
            { "type.colCaseLevel.yes", "isojen ja pienten kirjainten lajittelu erikseen" },
            { "type.nu.jpanfin", "japanilaiset talousnumerot" },
            { "Cham", "t\u0161amilainen" },
            { "gez", "ge\u2019ez" },
            { "mrj", "vuorimari" },
            { "Syrn", "syyrialainen it\u00e4inen muunnelma" },
            { "type.nu.mymrshan", "myanmarin shan-numerot" },
            { "Elba", "elbasanilainen" },
            { "Narb", "muinaispohjoisarabialainen" },
            { "type.nu.olck", "ol chiki -numerot" },
            { "type.co.reformed", "uudistettu j\u00e4rjestys" },
            { "Tglg", "tagalogilainen" },
            { "Egyd", "egyptil\u00e4inen demoottinen" },
            { "key.colBackwards", "painomerkkien lajittelu" },
            { "Egyh", "egyptil\u00e4inen hieraattinen" },
            { "%%ITIHASA", "sanskriitin eeppinen muoto" },
            { "Palm", "palmyralainen" },
            { "ebu", "embu" },
            { "Egyp", "egyptil\u00e4iset hieroglyfit" },
            { "Geok", "muinaisgeorgialainen" },
            { "zh_Hans", "yksinkertaistettu kiina" },
            { "koi", "komipermjakki" },
            { "Hung", "muinaisunkarilainen" },
            { "kok", "konkani" },
            { "%%1901", "saksan perinteinen oikeinkirjoitus" },
            { "kos", "kosrae" },
            { "vec", "venetsia" },
            { "type.nu.limb", "limbunumerot" },
            { "zh_Hant", "perinteinen kiina" },
            { "Sund", "sundalainen" },
            { "vep", "veps\u00e4" },
            { "kpe", metaValue_kpe },
            { "type.nu.khmr", "khmeril\u00e4iset numerot" },
            { "Tirh", "tirhuta" },
            { "ilo", "iloko" },
            { "%%VALENCIA", "katalaanin valencian murre" },
            { "Cprt", "muinaiskyproslainen" },
            { "%%BAKU1926", "yhten\u00e4istetty turkkilainen latinalainen aakkosto" },
            { "%%IJEKAVSK", "serbian ijekavialainen \u00e4\u00e4nt\u00e4miys" },
            { "mua", "mundang" },
            { "type.nu.guru", "gurmukhilaiset numerot" },
            { "mul", "monia kieli\u00e4" },
            { "%%PUTER", "retoromaanin puter-muoto" },
            { "cad", "caddo" },
            { "key.ms", "mittaj\u00e4rjestelm\u00e4" },
            { "mus", "creek" },
            { "Glag", "glagoliittinen" },
            { "gil", "kiribati" },
            { "%%KKCOR", "kornin yleiskirjoitus" },
            { "Cher", "cherokeelainen" },
            { "car", "karibi" },
            { "cay", "cayuga" },
            { "type.nu.tamldec", "tamilinumerot" },
            { "krc", "karat\u0161ai-balkaari" },
            { "inh", "inguu\u0161i" },
            { "krj", "kinaray-a" },
            { "kri", "krio" },
            { "krl", "karjala" },
            { "efi", "efik" },
            { "tcy", "tulu" },
            { "key.nu", "numerot" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "type.colCaseFirst.upper", "isot kirjaimet edelt\u00e4v\u00e4t pieni\u00e4" },
            { "Telu", "telugulainen" },
            { "ksf", "bafia" },
        };
        return data;
    }
}
