/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.managed;

import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.dbcp2.managed.TransactionRegistry;
import org.apache.tomcat.dbcp.dbcp2.managed.XAConnectionFactory;

public class DataSourceXAConnectionFactory
implements XAConnectionFactory {
    private final TransactionRegistry transactionRegistry;
    private final XADataSource xaDataSource;
    private String userName;
    private char[] userPassword;

    public DataSourceXAConnectionFactory(TransactionManager transactionManager, XADataSource xADataSource) {
        this(transactionManager, xADataSource, null, null, null);
    }

    public DataSourceXAConnectionFactory(TransactionManager transactionManager, XADataSource xADataSource, String string, char[] cArray) {
        this(transactionManager, xADataSource, string, cArray, null);
    }

    public DataSourceXAConnectionFactory(TransactionManager transactionManager, XADataSource xADataSource, String string, char[] cArray, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        Objects.requireNonNull(transactionManager, "transactionManager is null");
        Objects.requireNonNull(xADataSource, "xaDataSource is null");
        this.transactionRegistry = new TransactionRegistry(transactionManager, transactionSynchronizationRegistry);
        this.xaDataSource = xADataSource;
        this.userName = string;
        this.userPassword = cArray;
    }

    public DataSourceXAConnectionFactory(TransactionManager transactionManager, XADataSource xADataSource, String string, String string2) {
        this(transactionManager, xADataSource, string, Utils.toCharArray(string2), null);
    }

    public DataSourceXAConnectionFactory(TransactionManager transactionManager, XADataSource xADataSource, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        this(transactionManager, xADataSource, null, null, transactionSynchronizationRegistry);
    }

    @Override
    public Connection createConnection() throws SQLException {
        XAConnection xAConnection = this.userName == null ? this.xaDataSource.getXAConnection() : this.xaDataSource.getXAConnection(this.userName, Utils.toString(this.userPassword));
        Connection connection = xAConnection.getConnection();
        XAResource xAResource = xAConnection.getXAResource();
        this.transactionRegistry.registerConnection(connection, xAResource);
        xAConnection.addConnectionEventListener(new ConnectionEventListener(){

            @Override
            public void connectionClosed(ConnectionEvent connectionEvent) {
                PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
                pooledConnection.removeConnectionEventListener(this);
                try {
                    pooledConnection.close();
                }
                catch (SQLException sQLException) {
                    System.err.println("Failed to close XAConnection");
                    sQLException.printStackTrace();
                }
            }

            @Override
            public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
                this.connectionClosed(connectionEvent);
            }
        });
        return connection;
    }

    @Override
    public TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    @Deprecated
    public String getUsername() {
        return this.userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public char[] getUserPassword() {
        return this.userPassword;
    }

    public XADataSource getXaDataSource() {
        return this.xaDataSource;
    }

    public void setPassword(char[] cArray) {
        this.userPassword = cArray;
    }

    public void setPassword(String string) {
        this.userPassword = Utils.toCharArray(string);
    }

    public void setUsername(String string) {
        this.userName = string;
    }
}

