/*
 * Decompiled with CFR 0.152.
 */
package gps.log.in;

import bt747.sys.File;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.RAFile;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747RAFile;
import gps.log.GPSRecord;
import gps.log.in.CommonIn;
import gps.log.in.GPSFileConverterInterface;
import gps.log.in.GPSLogConvertInterface;

public final class HoluxTrlLogConvert
extends GPSLogConvertInterface {
    private int recordSize;
    private boolean passToFindFieldsActivatedInLog = false;
    private int error;

    @Override
    public final int parseFile(Object object, GPSFileConverterInterface gPSFileConverterInterface) {
        try {
            object = (BT747RAFile)object;
            GPSRecord gPSRecord = GPSRecord.getLogFormatRecord(0);
            byte[] byArray = new byte[2048];
            if (!this.passToFindFieldsActivatedInLog) {
                gPSFileConverterInterface.writeLogFmtHeader(GPSRecord.getLogFormatRecord(29));
            }
            this.recordSize = 15;
            int n = 0;
            int n2 = 0;
            int n3 = object.getSize();
            while (!this.stop && n2 + this.recordSize + 1 < n3) {
                int n4 = 2048;
                if (n2 + 2048 > n3) {
                    n4 = n3 - n2;
                }
                int n5 = 0;
                object.setPos(n2);
                if (object.readBytes(byArray, 0, n4) != n4) {
                    this.errorInfo = object.getPath() + "|" + object.getLastError();
                    return -3;
                }
                n2 += n4;
                while (n4 > n5 + this.recordSize) {
                    int n6 = n5;
                    int n7 = 0;
                    while (n6 < this.recordSize + n5 && n6 < n4 - 1) {
                        n7 ^= byArray[n6++];
                    }
                    int n8 = n5;
                    n5 = ++n6;
                    ++n;
                    if ((n7 & 0xFF) != (0xFF & byArray[n6 - 1])) continue;
                    gPSRecord.recCount = n;
                    if (this.passToFindFieldsActivatedInLog) continue;
                    gPSRecord.valid = 65535;
                    gPSRecord.rcr = 1;
                    gPSRecord.utc = 0xFF & byArray[n8++] | (0xFF & byArray[n8++]) << 8 | (0xFF & byArray[n8++]) << 16 | (0xFF & byArray[n8++]) << 24;
                    n6 = 0xFF & byArray[n8++] | (0xFF & byArray[n8++]) << 8 | (0xFF & byArray[n8++]) << 16 | (0xFF & byArray[n8++]) << 24;
                    gPSRecord.latitude = JavaLibBridge.toFloatBitwise(n6);
                    n6 = 0xFF & byArray[n8++] | (0xFF & byArray[n8++]) << 8 | (0xFF & byArray[n8++]) << 16 | (0xFF & byArray[n8++]) << 24;
                    gPSRecord.longitude = JavaLibBridge.toFloatBitwise(n6);
                    n6 = (0xFF & byArray[n8++]) << 8 | (0xFF & byArray[n8++]) << 16 | (0xFF & byArray[n8]) << 24;
                    gPSRecord.height = JavaLibBridge.toFloatBitwise(n6);
                    CommonIn.convertHeight(gPSRecord, this.factorConversionWGS84ToMSL);
                    gPSFileConverterInterface.addLogRecord(gPSRecord);
                    gPSRecord = GPSRecord.getLogFormatRecord(0);
                }
                n2 -= n4 - n5;
            }
        }
        catch (Exception exception) {
            Generic.debug("", exception);
        }
        return 0;
    }

    @Override
    protected final Object getFileObject(BT747Path bT747Path) {
        RAFile rAFile = null;
        if (File.isAvailable() && !(rAFile = new RAFile(bT747Path, 1)).isOpen()) {
            this.errorInfo = bT747Path + "|" + rAFile.getLastError();
            this.error = -1;
            rAFile = null;
        }
        return rAFile;
    }

    @Override
    protected final void closeFileObject(Object object) {
        ((File)object).close();
    }

    @Override
    public final int toGPSFile(BT747Path object, GPSFileConverterInterface gPSFileConverterInterface) {
        this.error = 0;
        try {
            object = this.getFileObject((BT747Path)object);
            if (object != null) {
                this.passToFindFieldsActivatedInLog = gPSFileConverterInterface.needPassToFindFieldsActivatedInLog();
                if (this.passToFindFieldsActivatedInLog) {
                    gPSFileConverterInterface.setActiveFileFields(GPSRecord.getLogFormatRecord(29));
                }
                this.passToFindFieldsActivatedInLog = false;
                if (this.error == 0) {
                    do {
                        this.error = this.parseFile(object, gPSFileConverterInterface);
                    } while (gPSFileConverterInterface.nextPass());
                }
                gPSFileConverterInterface.finaliseFile();
                this.closeFileObject(object);
            }
        }
        catch (Exception exception) {
            Generic.debug("", exception);
        }
        return this.error;
    }

    @Override
    public final int getType() {
        return 9;
    }
}

