/*
 * Decompiled with CFR 0.152.
 */
package gps.mvc;

import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747HashSet;
import gps.GPSListener;
import gps.GpsEvent;
import gps.ProtocolConstants;
import gps.connection.GPSrxtx;
import gps.log.GPSRecord;
import gps.log.in.CommonIn;
import gps.mvc.GpsLinkHandler;
import gps.mvc.HoluxModel;
import gps.mvc.MtkModel;
import gps.mvc.SkytraqModel;
import gps.mvc.WPModel;
import gps.mvc.commands.GpsLinkExecCommand;

public class GpsModel
implements ProtocolConstants {
    private final GpsLinkHandler handler;
    private MtkModel mtkModel;
    private int protocol = -1;
    private final GPSRecord gpsPos = GPSRecord.getLogFormatRecord(0);
    private final BT747HashSet listeners = JavaLibBridge.getHashSetInstance();

    public GpsModel(GPSrxtx gPSrxtx, int n) {
        this.handler = new GpsLinkHandler();
        this.setProtocol(n);
        GPSrxtx gPSrxtx2 = gPSrxtx;
        this.handler.setGPSRxtx(gPSrxtx2);
    }

    public final void setProtocol(int n) {
        if (this.protocol != n) {
            this.protocol = n;
            switch (n) {
                case 0: 
                case 3: {
                    this.mtkModel = new MtkModel(this, this.handler);
                    return;
                }
                case 1: {
                    this.mtkModel = new WPModel(this, this.handler);
                    return;
                }
                case 2: 
                case 5: {
                    this.mtkModel = new HoluxModel(this, this.handler);
                    return;
                }
                case 4: {
                    this.mtkModel = new SkytraqModel(this, this.handler);
                    return;
                }
            }
            this.mtkModel = null;
        }
    }

    public final MtkModel getMtkModel() {
        return this.mtkModel;
    }

    public final GpsLinkHandler getHandler() {
        return this.handler;
    }

    public final void setAllUnavailable() {
        this.mtkModel.setAllUnavailable();
    }

    final boolean analyseResponse(Object object) {
        return this.mtkModel.analyseResponse(object);
    }

    public final boolean analyseNMEA(String[] object) {
        boolean bl = false;
        try {
            if (((String[])object).length == 0) {
                Generic.debug("Problem - report NMEA is 0 length");
            } else if (this.handler.isGpsDecode() && !this.mtkModel.isLogDownloadOngoing() && object[0].length() != 0 && object[0].charAt(0) == 'G') {
                if (object[0].startsWith("GPGGA")) {
                    GPSRecord gPSRecord = this.gpsPos;
                    String[] stringArray = object;
                    object = this;
                    if (CommonIn.analyzeGPGGA(stringArray, gPSRecord) != 0) {
                        gPSRecord.height -= gPSRecord.geoid;
                        ((GpsModel)object).postGpsEvent(4, gPSRecord);
                    }
                } else if (object[0].startsWith("GPRMC")) {
                    GPSRecord gPSRecord = this.gpsPos;
                    String[] stringArray = object;
                    object = this;
                    if (CommonIn.analyzeGPRMC(stringArray, gPSRecord) != 0) {
                        ((GpsModel)object).postGpsEvent(3, gPSRecord);
                    }
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            Generic.debug("AnalyzeNMEA", exception);
        }
        return bl;
    }

    public final void setGpsDecode(boolean bl) {
        this.handler.setGpsDecode(bl);
    }

    protected final void postGpsEvent(int n, Object object) {
        this.postEvent(new GpsEvent(n, object));
    }

    public final GPSRecord getGpsRecord() {
        return this.gpsPos;
    }

    public final void addListener(GPSListener gPSListener) {
        this.listeners.add(gPSListener);
    }

    public final void removeListener(GPSListener gPSListener) {
        this.listeners.remove(gPSListener);
    }

    protected final void postEvent(GpsEvent gpsEvent) {
        BT747HashSet bT747HashSet = this.listeners.iterator();
        while (bT747HashSet.hasNext()) {
            ((GPSListener)bT747HashSet.next()).gpsEvent(gpsEvent);
        }
    }

    public final void sendCmd(GpsLinkExecCommand gpsLinkExecCommand) {
        this.handler.sendCmd(gpsLinkExecCommand);
    }

    public final int getOutStandingCmdsCount() {
        return this.handler.getOutStandingCmdsCount();
    }

    public final int getStartAddr() {
        return this.mtkModel.getStartAddr();
    }

    public final int getEndAddr() {
        return this.mtkModel.getEndAddr();
    }

    public final boolean isLogDownloadOnGoing() {
        return this.mtkModel.isLogDownloadOngoing();
    }

    public final int getNextReadAddr() {
        return this.mtkModel.getNextReadAddr();
    }
}

